from typing import Optional, Tuple

from .. import Provider as GeoProvider


class Provider(GeoProvider):
    """
    Implement GEO provider for ``bn_BD`` locale.
    """

    land_coords = (
        ("42.50729", "1.53414", "লেস এসকালডেস", "AD", "ইউরোপ/অ্যান্ডোরা"),
        ("36.21544", "65.93249", "সার-ই পুল", "AF", "এশিয়া/কাবুল"),
        ("40.49748", "44.7662", "হরাজদান", "AM", "এশিয়া/ইয়েরেভান"),
        ("-11.78333", "19.91667", "লুয়েনা", "AO", "আফ্রিকা/লুয়ান্ডা"),
        ("-37.32167", "-59.13316", "তান্ডিল", "AR", "আমেরিকা/আর্জেন্টিনা/বুয়েনস_আয়ারস"),
        ("-34.74785", "-58.70072", "পন্টেভেদ্রা", "AR", "আমেরিকা/আর্জেন্টিনা/বুয়েনস_আয়ারস"),
        ("-34.64966", "-58.38341", "বারাকাস", "AR", "আমেরিকা/আর্জেন্টিনা/বুয়েনস_আয়ারস"),
        ("-54.8", "-68.3", "উশুইয়া", "AR", "আমেরিকা/আর্জেন্টিনা/উশুয়া"),
        ("-31.25033", "-61.4867", "রাফায়েলা", "AR", "আমেরিকা/আর্জেন্টিনা/কর্ডোবা"),
        ("-31.4488", "-60.93173", "এসপেরানজা", "AR", "আমেরিকা/আর্জেন্টিনা/কর্ডোবা"),
        ("-34.64167", "-60.47389", "চাকাবুকো", "AR", "আমেরিকা/আর্জেন্টিনা/বুয়েনস_আয়ারস"),
        ("-27.4338", "-65.61427", "অ্যাগুইলারেস", "AR", "আমেরিকা/আর্জেন্টিনা/টুকুমান"),
        ("47.05", "15.46667", "সাঙ্কট পিটার", "AT", "ইউরোপ/ভিয়েনা"),
        ("48.25", "16.4", "ফ্লোরিডসডর্ফ", "AT", "ইউরোপ/ভিয়েনা"),
        ("-31.95224", "115.8614", "পার্থ", "AU", "অস্ট্রেলিয়া/পার্থ"),
        ("-37.9", "145.18333", "হুইলার হিল", "AU", "অস্ট্রেলিয়া/মেলবোর্ন"),
        ("-33.88096", "151.07986", "স্ট্র্যাথফিল্ড", "AU", "অস্ট্রেলিয়া/সিডনি"),
        ("-34.88422", "150.60036", "নওরা", "AU", "অস্ট্রেলিয়া/সিডনি"),
        ("-25.54073", "152.70493", "মেরিবরো", "AU", "অস্ট্রেলিয়া/ব্রিসবেন"),
        ("-34.28853", "146.05093", "গ্রিফিথ", "AU", "অস্ট্রেলিয়া/সিডনি"),
        ("-33.79176", "151.08057", "ইস্টউড", "AU", "অস্ট্রেলিয়া/সিডনি"),
        ("-37.88333", "145.06667", "কার্নেগি", "AU", "অস্ট্রেলিয়া/মেলবোর্ন"),
        ("-33.75881", "150.99292", "বৌলখাম পাহাড়", "AU", "অস্ট্রেলিয়া/সিডনি"),
        ("-27.50578", "153.10236", "ক্যারিন্ডেল", "AU", "অস্ট্রেলিয়া/ব্রিসবেন"),
        ("-32.05251", "115.88782", "উইলেটন", "AU", "অস্ট্রেলিয়া/পার্থ"),
        ("-38.16604", "145.13643", "ফ্রাঙ্কস্টন সাউথ", "AU", "অস্ট্রেলিয়া/মেলবোর্ন"),
        ("38.45598", "48.87498", "আস্তারা", "AZ", "এশিয়া/বাকু"),
        ("41.09246", "45.36561", "কাজ্যাক্স", "AZ", "এশিয়া/বাকু"),
        ("44.75874", "19.21437", "বিজেলজিনা", "BA", "ইউরোপ/সারায়েভো"),
        ("23.80700", "90.40971", "ঢাকা", "BD", "এশিয়া/ঢাকা"),
        ("24.37648", "88.60527", "রাজশাহী", "BD", "এশিয়া/ঢাকা"),
        ("22.36135", "91.78067", "চট্টগ্রাম", "BD", "এশিয়া/ঢাকা"),
        ("22.84686", "89.53730", "খুলনা", "BD", "এশিয়া/ঢাকা"),
        ("22.70250", "90.35243", "বরিশাল", "BD", "এশিয়া/ঢাকা"),
        ("24.89108", "91.86156", "সিলেট", "BD", "এশিয়া/ঢাকা"),
        ("25.74364", "89.27526", "রংপুর", "BD", "এশিয়া/ঢাকা"),
        ("24.74564", "90.41537", "ময়মনসিংহ", "BD", "এশিয়া/ঢাকা"),
        ("23.46092", "91.18056", "কুমিল্লা", "BD", "এশিয়া/ঢাকা"),
        ("23.60156", "89.83321", "ফরিদপুর", "BD", "এশিয়া/ঢাকা"),
        ("21.42798", "92.00831", "কক্সবাজার", "BD", "এশিয়া/ঢাকা"),
        ("23.15413", "89.21153", "যশোর", "BD", "এশিয়া/ঢাকা"),
        ("24.84920", "89.36662", "বগুড়া", "BD", "এশিয়া/ঢাকা"),
        ("24.58064", "88.27124", "চাঁপাই নবাবগঞ্জ", "BD", "এশিয়া/ঢাকা"),
        ("24.68209", "88.15827", "শিবগঞ্জ", "BD", "এশিয়া/ঢাকা"),
        ("23.9028", "89.11943", "কুষ্টিয়া", "BD", "এশিয়া/ঢাকা"),
        ("22.83957", "91.84128", "মানিকছড়ি", "BD", "এশিয়া/ঢাকা"),
        ("50.8", "3.16667", "ওয়েভেলজেম", "BE", "ইউরোপ/ব্রাসেলস"),
        ("51.12794", "4.21372", "তেমসে", "BE", "ইউরোপ/ব্রাসেলস"),
        ("50.71229", "4.52529", "রিক্সেনসার্ট", "BE", "ইউরোপ/ব্রাসেলস"),
        ("50.74497", "3.20639", "মাউসক্রন", "BE", "ইউরোপ/ব্রাসেলস"),
        ("51.24197", "4.82313", "লিলে", "BE", "ইউরোপ/ব্রাসেলস"),
        ("51.03427", "5.37429", "হাউথালেন", "BE", "ইউরোপ/ব্রাসেলস"),
        ("50.56149", "4.69889", "জেমব্লুক্স", "BE", "ইউরোপ/ব্রাসেলস"),
        ("50.88506", "4.07601", "ডেন্ডারলিউ", "BE", "ইউরোপ/ব্রাসেলস"),
        ("51.21187", "4.25633", "বেভারেন", "BE", "ইউরোপ/ব্রাসেলস"),
        ("41.57439", "24.71204", "স্মোলিয়ান", "BG", "ইউরোপ/সোফিয়া"),
        ("43.4125", "23.225", "মন্টানা", "BG", "ইউরোপ/সোফিয়া"),
        ("42.7", "27.25", "আয়টোস", "BG", "ইউরোপ/সোফিয়া"),
        ("8.88649", "2.59753", "চাওরো", "BJ", "আফ্রিকা/পোর্তো-নভো"),
        ("-21.44345", "-65.71875", "টুপিজা", "BO", "আমেরিকা/লা_পাজ"),
        ("-0.71667", "-48.52333", "সাউর", "BR", "আমেরিকা/বেলেম"),
        ("-8.05389", "-34.88111", "রেসিফ", "BR", "আমেরিকা/রেসিফ"),
        ("-4.42472", "-41.45861", "পেড্রো দ্বিতীয়", "BR", "আমেরিকা/ফর্তালেজা"),
        ("-3.14306", "-58.44417", "ইটাকোটিয়ারা", "BR", "আমেরিকা/মানাস"),
        ("-4.16694", "-40.7475", "গুয়ারসিয়াবা দো নর্তে", "BR", "আমেরিকা/ফর্তালেজা"),
        ("-8.66667", "-35.71667", "ক্যাটেন্ডে", "BR", "আমেরিকা/রেসিফ"),
        ("-8.28333", "-35.03333", "কাবো", "BR", "আমেরিকা/রেসিফ"),
        ("-4.24444", "-42.29444", "বারাস", "BR", "আমেরিকা/ফর্তালেজা"),
        ("-3.20333", "-52.20639", "আলতামিরা", "BR", "আমেরিকা/সান্তারেম"),
        ("-20.87306", "-48.29694", "ভিরাডুরো", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-22.97056", "-46.99583", "ভালিনহোস", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-10.95817", "-38.79084", "টুকানো", "BR", "আমেরিকা/বাহিয়া"),
        ("-28.81833", "-52.51028", "সোলেডে", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-23.44361", "-51.87389", "সারন্দি", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-22.45667", "-47.53028", "সান্তা গার্ট্রুডস", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-11.48472", "-37.93278", "রিও রিয়াল", "BR", "আমেরিকা/বাহিয়া"),
        ("-19.32556", "-41.25528", "প্রতিশোধক", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-26.22861", "-52.67056", "প্যাটো ব্রাঙ্কো", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-25.42944", "-50.00639", "পালমেইরা", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-12.91667", "-39.25", "মুরিতিবা", "BR", "আমেরিকা/বাহিয়া"),
        ("-21.41222", "-42.19667", "মিরাসেমা", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-28.44917", "-52.2", "মারাউ", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-22.92306", "-53.13722", "লোয়ান্ডা", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-10.91722", "-37.65", "লাগারতো", "BR", "আমেরিকা/ম্যাসিও"),
        ("-19.72806", "-50.19556", "ইতুরামা", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-21.205", "-41.88778", "ইটাপেরুনা", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-20.25333", "-43.80139", "ইতাবিরিতো", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-28.24", "-48.67028", "ইম্বিটুবা", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-22.53722", "-42.98194", "গুয়াপিমিরিম", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-19.7625", "-44.31389", "এসমেরালদাস", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-25.42778", "-49.27306", "কিউরিটিবা", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-14.66463", "-52.35558", "নোভা জাভান্তিনা", "BR", "আমেরিকা/কুয়াবা"),
        ("-29.2975", "-51.50361", "কার্লোস বারবোসা", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-15.675", "-38.94722", "ক্যানভিইরাস", "BR", "আমেরিকা/বাহিয়া"),
        ("-17.74431", "-48.62789", "কালডাস নোভাস", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-23.7975", "-48.59278", "বুড়ি", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-10.90889", "-37.03861", "বারা ডস কোকিরোস", "BR", "আমেরিকা/ম্যাসিও"),
        ("-22.57306", "-47.1725", "আর্টুর নোগুইরা", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-10.91111", "-37.07167", "আরাকাজু", "BR", "আমেরিকা/ম্যাসিও"),
        ("-21.42917", "-45.94722", "আলফেনাস", "BR", "আমেরিকা/সাও_পাওলো"),
        ("-8.76194", "-63.90389", "পোর্টো ভেলহো", "BR", "আমেরিকা/পোর্টো_ভেলহো"),
        ("-21.44236", "27.46153", "টোনোটা", "BW", "আফ্রিকা/গ্যাবোরোন"),
        ("55.1904", "30.2049", "ভিটেবস্ক", "BY", "ইউরোপ/মিনস্ক"),
        ("53.5942", "25.8191", "নভোগ্রুডোক", "BY", "ইউরোপ/মিনস্ক"),
        ("52.4089", "31.3237", "ডোব্রাশ", "BY", "ইউরোপ/মিনস্ক"),
        ("45.43341", "-73.86586", "বীকনসফিল্ড", "CA", "আমেরিকা/টরন্টো"),
        ("46.23899", "-63.13414", "শার্লটটাউন", "CA", "আমেরিকা/হ্যালিফ্যাক্স"),
        ("45.4473", "-73.75335", "ডোরভাল", "CA", "আমেরিকা/টরন্টো"),
        ("49.88307", "-119.48568", "কেলোনা", "CA", "আমেরিকা/ভ্যাঙ্কুভার"),
        ("43.86682", "-79.2663", "মার্কহাম", "CA", "আমেরিকা/টরন্টো"),
        ("42.8334", "-80.38297", "নরফোক কাউন্টি", "CA", "আমেরিকা/টরন্টো"),
        ("45.44868", "-73.81669", "পয়েন্ট-ক্লেয়ার", "CA", "আমেরিকা/টরন্টো"),
        ("45.40008", "-73.58248", "সেন্ট-ক্যাথরিন", "CA", "আমেরিকা/টরন্টো"),
        ("53.51684", "-113.3187", "শেরউড পার্ক", "CA", "আমেরিকা/এডমন্টন"),
        ("50.26729", "-119.27337", "ভার্নন", "CA", "আমেরিকা/ভ্যাঙ্কুভার"),
        ("46.1351", "-60.1831", "সিডনি", "CA", "আমেরিকা/গ্লেস_বে"),
        ("0.76755", "24.43973", "ইয়াংগাম্বি", "CD", "আফ্রিকা/লুবুম্বাশি"),
        ("-8.73508", "24.99798", "কামিনা", "CD", "আফ্রিকা/লুবুম্বাশি"),
        ("0.49113", "29.47306", "বেনী", "CD", "আফ্রিকা/লুবুম্বাশি"),
        ("-4.5833", "15.16554", "কাসাংগুলু", "CD", "আফ্রিকা/কিনশাসা"),
        ("4.94273", "15.87735", "কার্নট", "CF", "আফ্রিকা/বাঙ্গুই"),
        ("-4.26613", "15.28318", "ব্রাজাভিল", "CG", "আফ্রিকা/ব্রাজাভিল"),
        ("46.18396", "6.10237", "ওয়ানেক্স", "CH", "ইউরোপ/জুরিখ"),
        ("47.30997", "8.52462", "অ্যাডলিসউইল", "CH", "ইউরোপ/জুরিখ"),
        ("5.84752", "-5.682", "লাকোটা", "CI", "আফ্রিকা/আবিজান"),
        ("5.27247", "-3.59625", "বনুয়া", "CI", "আফ্রিকা/আবিজান"),
        ("-33.59217", "-70.6996", "সান বার্নার্ডো", "CL", "আমেরিকা/সান্টিয়াগো"),
        ("-30.60106", "-71.19901", "ওভালে", "CL", "আমেরিকা/সান্টিয়াগো"),
        ("-32.45242", "-71.23106", "লা লিগুয়া", "CL", "আমেরিকা/সান্টিয়াগো"),
        ("-36.9256", "-73.02841", "চিগুয়ান্তে", "CL", "আমেরিকা/সান্টিয়াগো"),
        ("4.96667", "10.7", "টোঙ্গা", "CM", "আফ্রিকা/ডুয়ালা"),
        ("3.51667", "11.5", "এমবালমায়ো", "CM", "আফ্রিকা/ডুয়ালা"),
        ("4.2475", "9.00472", "আইডেনাও", "CM", "আফ্রিকা/ডুয়ালা"),
        ("46.51872", "86.00214", "হক্সটলগে", "CN", "এশিয়া/উরুমকি"),
        ("36.81667", "117.81667", "ঝাউকুন", "CN", "এশিয়া/সাংহাই"),
        ("34.86472", "117.55417", "জাওজুয়াং", "CN", "এশিয়া/সাংহাই"),
        ("23.73333", "114.68333", "হেয়ুয়ান", "CN", "এশিয়া/সাংহাই"),
        ("34.65918", "109.22921", "ইয়ানলিয়াং", "CN", "এশিয়া/সাংহাই"),
        ("38.40917", "112.73333", "জিনঝো", "CN", "এশিয়া/সাংহাই"),
        ("33.78333", "114.51667", "ওয়াচেং", "CN", "এশিয়া/সাংহাই"),
        ("27.85", "112.9", "জিয়াংটান", "CN", "এশিয়া/সাংহাই"),
        ("37.19723", "122.05228", "তিয়ানফু", "CN", "এশিয়া/সাংহাই"),
        ("34.85", "117.33333", "তাওজুয়াং", "CN", "এশিয়া/সাংহাই"),
        ("35.64889", "117.27583", "শিশুই", "CN", "এশিয়া/সাংহাই"),
        ("27.34089", "117.4831", "শাওউ", "CN", "এশিয়া/সাংহাই"),
        ("37.30553", "120.82747", "ঝুয়াংইয়ুয়ান", "CN", "এশিয়া/সাংহাই"),
        ("35.50056", "117.63083", "পিঙ্গি", "CN", "এশিয়া/সাংহাই"),
        ("27.92333", "118.53333", "পুচেং", "CN", "এশিয়া/সাংহাই"),
        ("24.28859", "116.11768", "মেইঝো", "CN", "এশিয়া/সাংহাই"),
        ("37.65181", "120.33063", "লংগ্যাং", "CN", "এশিয়া/সাংহাই"),
        ("23.29549", "113.82465", "লিচেং", "CN", "এশিয়া/সাংহাই"),
        ("36.19278", "117.65694", "লাইউউ", "CN", "এশিয়া/সাংহাই"),
        ("30.35028", "112.19028", "জিংঝো", "CN", "এশিয়া/সাংহাই"),
        ("32.50611", "120.14278", "জিয়াংইয়ান", "CN", "এশিয়া/সাংহাই"),
        ("30.24706", "115.04814", "হুয়াংশি", "CN", "এশিয়া/সাংহাই"),
        ("37.73222", "115.70111", "হেংশুই", "CN", "এশিয়া/সাংহাই"),
        ("28.88162", "120.03308", "গুলি", "CN", "এশিয়া/সাংহাই"),
        ("23.02677", "113.13148", "ফোশান", "CN", "এশিয়া/সাংহাই"),
        ("35.85", "117.7", "ডংডু", "CN", "এশিয়া/সাংহাই"),
        ("32.54278", "111.50861", "দানজিয়াংকু", "CN", "এশিয়া/সাংহাই"),
        ("35.20889", "111.73861", "চাংঝি", "CN", "এশিয়া/সাংহাই"),
        ("34.56861", "105.89333", "বেইদাও", "CN", "এশিয়া/সাংহাই"),
        ("29.98869", "122.20488", "ঝুশান", "CN", "এশিয়া/সাংহাই"),
        ("40.66482", "122.22833", "ইংকু", "CN", "এশিয়া/সাংহাই"),
        ("46.08333", "122.08333", "উলানহট", "CN", "এশিয়া/সাংহাই"),
        ("45.35", "126.28333", "শুয়াংচেং", "CN", "এশিয়া/সাংহাই"),
        ("41.09822", "120.74792", "নানপিয়াও", "CN", "এশিয়া/সাংহাই"),
        ("41.27194", "123.17306", "লিয়াওইয়াং", "CN", "এশিয়া/সাংহাই"),
        ("41.94175", "123.50266", "হুশিতাই", "CN", "এশিয়া/সাংহাই"),
        ("40.85158", "122.74754", "হাইচেং", "CN", "এশিয়া/সাংহাই"),
        ("42.64031", "125.51176", "ডংফেং", "CN", "এশিয়া/সাংহাই"),
        ("45.75279", "130.57211", "বলি", "CN", "এশিয়া/সাংহাই"),
        ("31.64615", "120.74221", "চাংশু সিটি", "CN", "এশিয়া/সাংহাই"),
        ("7.83389", "-72.47417", "ভিলা দেল রোজারিও", "CO", "আমেরিকা/বোগোটা"),
        ("6.46838", "-73.26022", "সোকোরো", "CO", "আমেরিকা/বোগোটা"),
        ("8.79577", "-75.69947", "সান কার্লোস", "CO", "আমেরিকা/বোগোটা"),
        ("10.98778", "-74.95472", "পুয়ের্তো কলম্বিয়া", "CO", "আমেরিকা/বোগোটা"),
        ("4.73245", "-74.26419", "মাদ্রিদ", "CO", "আমেরিকা/বোগোটা"),
        ("5.20856", "-74.73584", "হোন্ডা", "CO", "আমেরিকা/বোগোটা"),
        ("10.15031", "-73.9614", "এল কোপে", "CO", "আমেরিকা/বোগোটা"),
        ("3.8801", "-77.03116", "বুয়েনাভেন্টুরা", "CO", "আমেরিকা/বোগোটা"),
        ("5.6561", "-75.87877", "আন্ডিস", "CO", "আমেরিকা/বোগোটা"),
        ("9.92787", "-84.13722", "সান রাফায়েল", "CR", "আমেরিকা/কোস্টারিকা"),
        ("10.63504", "-85.43772", "লাইবেরিয়া", "CR", "আমেরিকা/কোস্টারিকা"),
        ("23.15678", "-81.24441", "ভারাদেরো", "CU", "আমেরিকা/হাভানা"),
        ("20.14298", "-77.43532", "মিডিয়া লুনা", "CU", "আমেরিকা/হাভানা"),
        ("23.04419", "-82.00919", "জারুকো", "CU", "আমেরিকা/হাভানা"),
        ("22.98212", "-80.58556", "কোরালিলো", "CU", "আমেরিকা/হাভানা"),
        ("23.0072", "-82.4017", "বোয়েরোস", "CU", "আমেরিকা/হাভানা"),
        ("50.50301", "13.63617", "অধিকাংশ", "CZ", "ইউরোপ/প্রাগ"),
        ("50.23271", "12.87117", "কারলোভি ভ্যারি", "CZ", "ইউরোপ/প্রাগ"),
        ("51.04962", "12.1369", "জিৎজ", "DE", "ইউরোপ/বার্লিন"),
        ("52.59319", "13.32127", "উইটেনউ", "DE", "ইউরোপ/বার্লিন"),
        ("50.82709", "6.9747", "ওয়েসেলিং", "DE", "ইউরোপ/বার্লিন"),
        ("50.9803", "11.32903", "ওয়েইমার", "DE", "ইউরোপ/বার্লিন"),
        ("52.86147", "9.5926", "ওয়ালরোড", "DE", "ইউরোপ/বার্লিন"),
        ("51.88333", "8.51667", "ভার্ল", "DE", "ইউরোপ/বার্লিন"),
        ("48.07667", "8.64409", "ট্রোসিংজেন", "DE", "ইউরোপ/বার্লিন"),
        ("48.78232", "9.17702", "স্টুটগার্ট", "DE", "ইউরোপ/বার্লিন"),
        ("53.59337", "9.47629", "স্টেড", "DE", "ইউরোপ/বার্লিন"),
        ("50.80019", "7.20769", "সিগবার্গ", "DE", "ইউরোপ/বার্লিন"),
        ("51.21667", "6.26667", "Schwalmtal", "DE", "ইউরোপ/বার্লিন"),
        ("54.52156", "9.5586", "শ্লেসউইগ", "DE", "ইউরোপ/বার্লিন"),
        ("50.72043", "11.34046", "রুডলস্ট্যাড", "DE", "ইউরোপ/বার্লিন"),
        ("48.49144", "9.20427", "রিউটলিংজেন", "DE", "ইউরোপ/বার্লিন"),
        ("51.20219", "7.36027", "রাদেভর্মওয়াল্ড", "DE", "ইউরোপ/বার্লিন"),
        ("48.46458", "9.22796", "ফুলিংজেন", "DE", "ইউরোপ/বার্লিন"),
        ("51.30001", "13.10984", "ওশ্যাটজ", "DE", "ইউরোপ/বার্লিন"),
        ("51.47805", "6.8625", "ওবারহাউসেন", "DE", "ইউরোপ/বার্লিন"),
        ("50.23805", "8.86704", "নিদ্দেরউ", "DE", "ইউরোপ/বার্লিন"),
        ("48.73218", "11.18709", "নিউবার্গ আন ডার ডোনাউ", "DE", "ইউরোপ/বার্লিন"),
        ("47.98372", "10.18527", "মেমিনজেন", "DE", "ইউরোপ/বার্লিন"),
        ("50.80904", "8.77069", "মারবার্গ আন ডার লাহন", "DE", "ইউরোপ/বার্লিন"),
        ("49.5099", "6.74549", "লোশেইম", "DE", "ইউরোপ/বার্লিন"),
        ("48.52961", "12.16179", "ল্যান্ডশাট", "DE", "ইউরোপ/বার্লিন"),
        ("51.19139", "6.51352", "কর্শেনব্রোইচ", "DE", "ইউরোপ/বার্লিন"),
        ("52.2", "8.63333", "কির্চলেঙ্গার্ন", "DE", "ইউরোপ/বার্লিন"),
        ("50.23019", "8.77155", "কারবেন", "DE", "ইউরোপ/বার্লিন"),
        ("50.09019", "8.4493", "হফহেইম অ্যাম টাউনাস", "DE", "ইউরোপ/বার্লিন"),
        ("52.61131", "13.31783", "হার্মসডর্ফ", "DE", "ইউরোপ/বার্লিন"),
        ("48.35149", "8.96317", "হেচিংজেন", "DE", "ইউরোপ/বার্লিন"),
        ("53.63333", "9.85", "হালস্টেনবেক", "DE", "ইউরোপ/বার্লিন"),
        ("52.21099", "7.02238", "গ্রনাউ", "DE", "ইউরোপ/বার্লিন"),
        ("52.47774", "10.5511", "গিফহর্ন", "DE", "ইউরোপ/বার্লিন"),
        ("48.06919", "11.37703", "গাটিং", "DE", "ইউরোপ/বার্লিন"),
        ("48.35693", "10.98461", "ফ্রাইডবার্গ", "DE", "ইউরোপ/বার্লিন"),
        ("51.168", "7.973", "ফিনেনট্রপ", "DE", "ইউরোপ/বার্লিন"),
        ("49.13645", "8.91229", "এপিংজেন", "DE", "ইউরোপ/বার্লিন"),
        ("48.28259", "9.72749", "এহিংগেন", "DE", "ইউরোপ/বার্লিন"),
        ("52.4581", "13.28702", "ডাহলেম", "DE", "ইউরোপ/বার্লিন"),
        ("51.08468", "7.11393", "বার্শেইড", "DE", "ইউরোপ/বার্লিন"),
        ("49.03685", "8.70745", "ব্রেটেন", "DE", "ইউরোপ/বার্লিন"),
        ("49.68369", "8.61839", "বেনশেইম", "DE", "ইউরোপ/বার্লিন"),
        ("53.94313", "10.30215", "ব্যাড সেজেবার্গ", "DE", "ইউরোপ/বার্লিন"),
        ("50.64336", "7.2278", "খারাপ হোনেফ", "DE", "ইউরোপ/বার্লিন"),
        ("49.97704", "9.15214", "আসকাফেনবার্গ", "DE", "ইউরোপ/বার্লিন"),
        ("48.21644", "9.02596", "আলবস্ট্যাড", "DE", "ইউরোপ/বার্লিন"),
        ("52.53048", "13.29371", "শার্লটেনবার্গ-নর্ড", "DE", "ইউরোপ/বার্লিন"),
        ("53.6052", "10.03988", "বারম্বেক-নর্ড", "DE", "ইউরোপ/বার্লিন"),
        ("11.15583", "42.7125", "আলি সাবিহ", "DJ", "আফ্রিকা/জিবুতি"),
        ("55.67938", "12.53463", "ফ্রেডেরিকসবার্গ", "DK", "ইউরোপ/কোপেনহেগেন"),
        ("18.20854", "-71.10077", "সান্তা ক্রুজ ডি বারাহোনা", "DO", "আমেরিকা/সান্টো_ডোমিঙ্গো"),
        ("36.76639", "3.47717", "বউমারদাস", "DZ", "আফ্রিকা/আলজিয়ার্স"),
        ("36.72544", "3.55665", "থেনিয়া", "DZ", "আফ্রিকা/আলজিয়ার্স"),
        ("34.15429", "3.50309", "মেসাদ", "DZ", "আফ্রিকা/আলজিয়ার্স"),
        ("35.21222", "2.31889", "কসার চেল্লালা", "DZ", "আফ্রিকা/আলজিয়ার্স"),
        ("35.06544", "1.04945", "ফ্রেন্ডা", "DZ", "আফ্রিকা/আলজিয়ার্স"),
        ("36.06386", "4.62744", "এল আচির", "DZ", "আফ্রিকা/আলজিয়ার্স"),
        ("36.76775", "2.95924", "চেরাগা", "DZ", "আফ্রিকা/আলজিয়ার্স"),
        ("36.27462", "4.85668", "বোর্ডজ জেমুরা", "DZ", "আফ্রিকা/আলজিয়ার্স"),
        ("36.61954", "4.08282", "বেনি দুআলা", "DZ", "আফ্রিকা/আলজিয়ার্স"),
        ("-2.13404", "-79.59415", "মিলাগ্রো", "EC", "আমেরিকা/গুয়াকিল"),
        ("-2.90055", "-79.00453", "কুয়েনকা", "EC", "আমেরিকা/গুয়াকিল"),
        ("59.37722", "28.19028", "নারভা", "EE", "ইউরোপ/টালিন"),
        ("26.67319", "31.4976", "জুহায়নাহ", "EG", "আফ্রিকা/কায়রো"),
        ("31.20176", "29.91582", "আলেকজান্দ্রিয়া", "EG", "আফ্রিকা/কায়রো"),
        ("39.96348", "-4.83076", "তালাভেরা দে লা রেইনা", "ES", "ইউরোপ/মাদ্রিদ"),
        ("37.35813", "-6.03731", "সান জুয়ান দে আজনালফারচে", "ES", "ইউরোপ/মাদ্রিদ"),
        ("38.68712", "-4.10734", "পুয়ের্টোলানো", "ES", "ইউরোপ/মাদ্রিদ"),
        ("38.38479", "-0.76773", "নভেলদা", "ES", "ইউরোপ/মাদ্রিদ"),
        ("27.76056", "-15.58602", "মাসপালোমাস", "ES", "আটলান্টিক/ক্যানারি"),
        ("38.47917", "-1.325", "জুমিল্লা", "ES", "ইউরোপ/মাদ্রিদ"),
        ("38.96667", "-0.18333", "গান্ডিয়া", "ES", "ইউরোপ/মাদ্রিদ"),
        ("38.10558", "-1.86343", "কারাভাকা", "ES", "ইউরোপ/মাদ্রিদ"),
        ("37.49073", "-2.77259", "বাজা", "ES", "ইউরোপ/মাদ্রিদ"),
        ("42.64685", "-5.55835", "ভিলাকিলামব্রে", "ES", "ইউরোপ/মাদ্রিদ"),
        ("42.06166", "-1.60452", "টুডেলা", "ES", "ইউরোপ/মাদ্রিদ"),
        ("40.42386", "-3.53261", "সান ফার্নান্দো ডি হেনারেস", "ES", "ইউরোপ/মাদ্রিদ"),
        ("41.15612", "1.10687", "রিউস", "ES", "ইউরোপ/মাদ্রিদ"),
        ("41.91738", "3.1631", "প্যালাফ্রুগেল", "ES", "ইউরোপ/মাদ্রিদ"),
        ("43.32686", "-2.98884", "লিওয়া", "ES", "ইউরোপ/মাদ্রিদ"),
        ("43.31667", "-2.68333", "গেরনিকা-লুমো", "ES", "ইউরোপ/মাদ্রিদ"),
        ("43.48961", "-8.2194", "ফেরল", "ES", "ইউরোপ/মাদ্রিদ"),
        ("41.63976", "2.35739", "কার্ডেডিউ", "ES", "ইউরোপ/মাদ্রিদ"),
        ("40.70995", "0.57856", "অ্যাম্পোস্টা", "ES", "ইউরোপ/মাদ্রিদ"),
        ("37.13548", "-3.67029", "লাস গ্যাবিয়াস", "ES", "ইউরোপ/মাদ্রিদ"),
        ("42.8139", "-1.64295", "সেগুন্ডো এনসানচে", "ES", "ইউরোপ/মাদ্রিদ"),
        ("41.41204", "2.18247", "এল ক্যাম্প দে ল আর্পা দেল ক্লট", "ES", "ইউরোপ/মাদ্রিদ"),
        ("11.85", "38.01667", "ডেব্রে তাবর", "ET", "আফ্রিকা/আদিস_আবাবা"),
        ("6.03333", "37.55", "আরবা মিঞ্চ", "ET", "আফ্রিকা/আদিস_আবাবা"),
        ("65.84811", "24.14662", "টর্নিও", "FI", "ইউরোপ/হেলসিঙ্কি"),
        ("60.18427", "24.95034", "কালিও", "FI", "ইউরোপ/হেলসিঙ্কি"),
        ("60.2052", "24.6522", "এসপু", "FI", "ইউরোপ/হেলসিঙ্কি"),
        ("45.51667", "4.86667", "ভিয়েন", "FR", "ইউরোপ/প্যারিস"),
        ("44.92801", "4.8951", "ভ্যালেন্স", "FR", "ইউরোপ/প্যারিস"),
        ("44.80477", "-0.59543", "প্রতিভা", "FR", "ইউরোপ/প্যারিস"),
        ("48.77644", "2.29026", "স্কাউক্স", "FR", "ইউরোপ/প্যারিস"),
        ("50.75", "2.25", "সন্ত-ওমর", "FR", "ইউরোপ/প্যারিস"),
        ("45.69558", "4.7934", "সেন্ট-জেনিস-লাভাল", "FR", "ইউরোপ/প্যারিস"),
        ("48.8765", "2.18967", "রুয়েল-মালমাইসন", "FR", "ইউরোপ/প্যারিস"),
        ("48", "-4.1", "কুইম্পার", "FR", "ইউরোপ/প্যারিস"),
        ("43.11667", "1.6", "পামিয়ার্স", "FR", "ইউরোপ/প্যারিস"),
        ("46.32313", "-0.45877", "নিওর্ট", "FR", "ইউরোপ/প্যারিস"),
        ("43.61092", "3.87723", "মন্টপেলিয়ার", "FR", "ইউরোপ/প্যারিস"),
        ("48.98333", "2.61667", "মিত্রি-মরি", "FR", "ইউরোপ/প্যারিস"),
        ("48.86667", "2.08333", "মারলি-লে-রোই", "FR", "ইউরোপ/প্যারিস"),
        ("46.67535", "5.55575", "লন্স-লে-সাউনিয়ার", "FR", "ইউরোপ/প্যারিস"),
        ("43.32393", "5.4584", "লেস অলিভস", "FR", "ইউরোপ/প্যারিস"),
        ("48.8222", "2.12213", "লে চেসনে", "FR", "ইউরোপ/প্যারিস"),
        ("48.90472", "2.2469", "লা গ্যারেনে-কলম্বস", "FR", "ইউরোপ/প্যারিস"),
        ("48.98994", "2.1699", "হার্বলে", "FR", "ইউরোপ/প্যারিস"),
        ("48.98693", "2.44892", "গোনেসে", "FR", "ইউরোপ/প্যারিস"),
        ("48.79325", "2.29275", "ফন্টেনাই-অক্স-রোসেস", "FR", "ইউরোপ/প্যারিস"),
        ("49.28669", "1.00288", "এলবেউফ", "FR", "ইউরোপ/প্যারিস"),
        ("43.71032", "-1.05366", "ড্যাক্স", "FR", "ইউরোপ/প্যারিস"),
        ("43.61058", "1.33467", "কলোমিয়ার্স", "FR", "ইউরোপ/প্যারিস"),
        ("43.83125", "5.03586", "ক্যাভিলন", "FR", "ইউরোপ/প্যারিস"),
        ("45.73333", "4.91667", "ব্রন", "FR", "ইউরোপ/প্যারিস"),
        ("48.90982", "2.45012", "ববিগনি", "FR", "ইউরোপ/প্যারিস"),
        ("48.77275", "5.16108", "বার-লে-ডুক", "FR", "ইউরোপ/প্যারিস"),
        ("43.67681", "4.63031", "আর্লস", "FR", "ইউরোপ/প্যারিস"),
        ("41.91886", "8.73812", "আজাচিও", "FR", "ইউরোপ/প্যারিস"),
        ("43.2907", "5.4384", "মারসেইল 11", "FR", "ইউরোপ/প্যারিস"),
        ("-1.63333", "13.58357", "ফ্রান্সভিল", "GA", "আফ্রিকা/লিব্রেভিল"),
        ("53.19146", "-2.52398", "উইনসফোর্ড", "GB", "ইউরোপ/লন্ডন"),
        ("51.26", "-2.1875", "ওয়েস্টবেরি", "GB", "ইউরোপ/লন্ডন"),
        ("51.84819", "1.26738", "ওয়ালটন-অন-দ্য-নেজ", "GB", "ইউরোপ/লন্ডন"),
        ("52.41667", "0.75", "থেটফোর্ড", "GB", "ইউরোপ/লন্ডন"),
        ("51.39323", "0.47713", "স্ট্রুড", "GB", "ইউরোপ/লন্ডন"),
        ("50.79205", "-1.08593", "দক্ষিণ সাগর", "GB", "ইউরোপ/লন্ডন"),
        ("53.78333", "-1.06667", "সেলবি", "GB", "ইউরোপ/লন্ডন"),
        ("55.82885", "-4.21376", "রাদারগ্লেন", "GB", "ইউরোপ/লন্ডন"),
        ("53.00974", "-3.05814", "রোসলানারক্রুগগ", "GB", "ইউরোপ/লন্ডন"),
        ("53.83333", "-2.98333", "পল্টন-লে-ফিল্ড", "GB", "ইউরোপ/লন্ডন"),
        ("50.11861", "-5.53715", "পেনজান্স", "GB", "ইউরোপ/লন্ডন"),
        ("50.82882", "-0.32247", "ল্যান্সিং", "GB", "ইউরোপ/লন্ডন"),
        ("51.40148", "-1.32471", "নিউবেরি", "GB", "ইউরোপ/লন্ডন"),
        ("53.49389", "-1.29243", "মেক্সবরো", "GB", "ইউরোপ/লন্ডন"),
        ("50.75767", "-1.5443", "লিমিংটন", "GB", "ইউরোপ/লন্ডন"),
        ("53.69786", "-2.68758", "লেল্যান্ড", "GB", "ইউরোপ/লন্ডন"),
        ("53.7446", "-0.33525", "হাল উপর কিংসটন", "GB", "ইউরোপ/লন্ডন"),
        ("57.47908", "-4.22398", "ইনভারনেস", "GB", "ইউরোপ/লন্ডন"),
        ("51.62907", "-0.74934", "হাই ওয়াইকম্ব", "GB", "ইউরোপ/লন্ডন"),
        ("51.38673", "0.30367", "হার্টলি", "GB", "ইউরোপ/লন্ডন"),
        ("52.66277", "-2.01111", "গ্রেট উইরলি", "GB", "ইউরোপ/লন্ডন"),
        ("53.38333", "-0.76667", "গেইনসবরো", "GB", "ইউরোপ/লন্ডন"),
        ("50.7236", "-3.52751", "এক্সেটার", "GB", "ইউরোপ/লন্ডন"),
        ("52.68333", "0.93333", "ইস্ট ডেরেহাম", "GB", "ইউরোপ/লন্ডন"),
        ("51.35084", "-1.99421", "ডিভাইস", "GB", "ইউরোপ/লন্ডন"),
        ("50.76306", "-1.29772", "গরু", "GB", "ইউরোপ/লন্ডন"),
        ("51.78967", "1.15597", "ক্ল্যাকটন-অন-সি", "GB", "ইউরোপ/লন্ডন"),
        ("53.46506", "-1.47217", "চ্যাপলটাউন", "GB", "ইউরোপ/লন্ডন"),
        ("51.64316", "-0.36053", "বুশে", "GB", "ইউরোপ/লন্ডন"),
        ("52.48173", "-2.12139", "ব্রিয়ারলি হিল", "GB", "ইউরোপ/লন্ডন"),
        ("53.81667", "-3.05", "ব্ল্যাকপুল", "GB", "ইউরোপ/লন্ডন"),
        ("53.0233", "-1.48119", "বেলপার", "GB", "ইউরোপ/লন্ডন"),
        ("51.65", "-0.2", "বারনেট", "GB", "ইউরোপ/লন্ডন"),
        ("56.56317", "-2.58736", "আরব্রোথ", "GB", "ইউরোপ/লন্ডন"),
        ("57.14369", "-2.09814", "আবারডিন", "GB", "ইউরোপ/লন্ডন"),
        ("51.39148", "-0.29825", "সারবিটন", "GB", "ইউরোপ/লন্ডন"),
        ("51.42708", "-0.91979", "লোয়ার আর্লি", "GB", "ইউরোপ/লন্ডন"),
        ("55.82737", "-4.0573", "ভিউপার্ক", "GB", "ইউরোপ/লন্ডন"),
        ("41.82143", "41.77921", "কবুলেতি", "GE", "এশিয়া/টিবিলিসি"),
        ("5.30383", "-1.98956", "তারকওয়া", "GH", "আফ্রিকা/আকরা"),
        ("7.06273", "-1.4001", "ম্যাম্পং", "GH", "আফ্রিকা/আকরা"),
        ("6.46346", "-2.31938", "বিবিয়ানী", "GH", "আফ্রিকা/আকরা"),
        ("13.56667", "-15.6", "ফরাফেন্নি", "GM", "আফ্রিকা/বানজুল"),
        ("9.535", "-13.68778", "ক্যামেয়েন", "GN", "আফ্রিকা/কোনাক্রি"),
        ("14.93333", "-91.11667", "চিচিকাস্টেনাঙ্গো", "GT", "আমেরিকা/গুয়েতেমালা"),
        ("22.37066", "114.10479", "সুয়েন ওয়ান", "HK", "এশিয়া/হংকং"),
        ("15.48131", "-86.57415", "ওলানচিটো", "HN", "আমেরিকা/টেগুসিগালপা"),
        ("43.50891", "16.43915", "বিভক্ত", "HR", "ইউরোপ/জাগরেব"),
        ("18.65297", "-72.09391", "থমাজেউ", "HT", "আমেরিকা/পোর্ট-অ-প্রিন্স"),
        ("18.57677", "-72.22625", "কোরিস-দেস-বুকেটস", "HT", "আমেরিকা/পোর্ট-অ-প্রিন্স"),
        ("3.3285", "99.1625", "তেবিংটিংগি", "ID", "এশিয়া/জাকার্তা"),
        ("3.7278", "98.6738", "লাবুহান ডেলি", "ID", "এশিয়া/জাকার্তা"),
        ("-7.51611", "109.05389", "ওয়াঙ্গন", "ID", "এশিয়া/জাকার্তা"),
        ("3.31332", "117.59152", "তারকান", "ID", "এশিয়া/মাকাসার"),
        ("-6.91806", "106.92667", "সুকাবুমি", "ID", "এশিয়া/জাকার্তা"),
        ("-1.26424", "104.09701", "সিম্পাং", "ID", "এশিয়া/জাকার্তা"),
        ("-7.0981", "109.3243", "রান্দুডংকাল", "ID", "এশিয়া/জাকার্তা"),
        ("0.51667", "101.44167", "পেকানবারু", "ID", "এশিয়া/জাকার্তা"),
        ("-7.01833", "107.60389", "পামেউং পিক", "ID", "এশিয়া/জাকার্তা"),
        ("-8.43333", "114.33333", "মুনকার", "ID", "এশিয়া/জাকার্তা"),
        ("-3.5403", "118.9707", "মজেনে", "ID", "এশিয়া/মাকাসার"),
        ("-6.8048", "110.8405", "কুদুস", "ID", "এশিয়া/জাকার্তা"),
        ("-7.81667", "112.01667", "কেদিরি", "ID", "এশিয়া/জাকার্তা"),
        ("-1.6", "103.61667", "জাম্বি সিটি", "ID", "এশিয়া/জাকার্তা"),
        ("-7.57897", "112.23109", "দিউইক", "ID", "এশিয়া/জাকার্তা"),
        ("-6.48167", "106.85417", "সিবিনং", "ID", "এশিয়া/জাকার্তা"),
        ("-7.73379", "113.69785", "বেসুকি", "ID", "এশিয়া/জাকার্তা"),
        ("-1.26753", "116.82887", "বালিকপাপন", "ID", "এশিয়া/মাকাসার"),
        ("-7.54972", "110.71639", "এনগেমপ্লাক", "ID", "এশিয়া/জাকার্তা"),
        ("53.53333", "-7.35", "এন মুইলিয়ান জিকার", "IE", "ইউরোপ/ডাবলিন"),
        ("53.43333", "-7.95", "অ্যাথলোন", "IE", "ইউরোপ/ডাবলিন"),
        ("31.92923", "34.86563", "রমলা", "IL", "এশিয়া/জেরুজালেম"),
        ("32.05971", "34.8732", "গনেই টিকভা", "IL", "এশিয়া/জেরুজালেম"),
        ("31.39547", "34.75699", "রাহাত", "IL", "এশিয়া/জেরুজালেম"),
        ("18.87813", "72.93924", "উরান", "IN", "এশিয়া/কলকাতা"),
        ("10.58806", "77.24779", "উদুমালাইপেত্তাই", "IN", "এশিয়া/কলকাতা"),
        ("9.82564", "78.25795", "তিরুপুবনম", "IN", "এশিয়া/কলকাতা"),
        ("25.49043", "85.94001", "তেঘরা", "IN", "এশিয়া/কলকাতা"),
        ("12.04161", "75.35927", "তালিপারম্বা", "IN", "এশিয়া/কলকাতা"),
        ("26.11527", "86.59509", "সুপল", "IN", "এশিয়া/কলকাতা"),
        ("34.08565", "74.80555", "শ্রীনগর", "IN", "এশিয়া/কলকাতা"),
        ("25.92493", "73.66633", "সোজাত", "IN", "এশিয়া/কলকাতা"),
        ("14.62072", "74.83554", "সিরসি", "IN", "এশিয়া/কলকাতা"),
        ("25.13915", "73.06784", "শেওগঞ্জ", "IN", "এশিয়া/কলকাতা"),
        ("11.50526", "77.23826", "সত্যমঙ্গলম", "IN", "এশিয়া/কলকাতা"),
        ("21.46527", "83.97573", "সম্বলপুর", "IN", "এশিয়া/কলকাতা"),
        ("25.87498", "86.59611", "সহরসা", "IN", "এশিয়া/কলকাতা"),
        ("12.95629", "78.27539", "রবার্টসনপেট", "IN", "এশিয়া/কলকাতা"),
        ("26.44931", "91.61356", "রঙ্গিয়া", "IN", "এশিয়া/কলকাতা"),
        ("33.37526", "74.3092", "রাজাওরি", "IN", "এশিয়া/কলকাতা"),
        ("24.81757", "84.63445", "রফিগঞ্জ", "IN", "এশিয়া/কলকাতা"),
        ("18.51957", "73.85535", "পুনে", "IN", "এশিয়া/কলকাতা"),
        ("11.93381", "79.82979", "পুদুচেরি", "IN", "এশিয়া/কলকাতা"),
        ("28.71271", "77.656", "পিলখুয়া", "IN", "এশিয়া/কলকাতা"),
        ("10.12268", "77.54372", "পেরিয়াকুলাম", "IN", "এশিয়া/কলকাতা"),
        ("31.28092", "74.85849", "পট্টি", "IN", "এশিয়া/কলকাতা"),
        ("20.88098", "75.11937", "পরোলা", "IN", "এশিয়া/কলকাতা"),
        ("23.07492", "88.28637", "পান্ডুয়া", "IN", "এশিয়া/কলকাতা"),
        ("18.18158", "76.03889", "ওসমানবাদ", "IN", "এশিয়া/কলকাতা"),
        ("25.6439", "77.9129", "নারওয়ার", "IN", "এশিয়া/কলকাতা"),
        ("30.81383", "75.16878", "মোগা", "IN", "এশিয়া/কলকাতা"),
        ("28.98002", "77.70636", "মিরাট", "IN", "এশিয়া/কলকাতা"),
        ("11.12018", "76.11996", "মঞ্জেরি", "IN", "এশিয়া/কলকাতা"),
        ("30.21121", "74.4818", "মালাউত", "IN", "এশিয়া/কলকাতা"),
        ("25.92127", "86.79271", "মধীপুরা", "IN", "এশিয়া/কলকাতা"),
        ("24.05979", "77.40858", "লেটরি", "IN", "এশিয়া/কলকাতা"),
        ("21.34222", "71.30633", "কুন্ডলা", "IN", "এশিয়া/কলকাতা"),
        ("22.75218", "72.68533", "খেদা", "IN", "এশিয়া/কলকাতা"),
        ("23.1959", "86.51499", "কেন্দা", "IN", "এশিয়া/কলকাতা"),
        ("29.21399", "78.95693", "কাশিপুর", "IN", "এশিয়া/কলকাতা"),
        ("11.00599", "77.5609", "কাঙ্গায়ম", "IN", "এশিয়া/কলকাতা"),
        ("22.88783", "84.13864", "যশপুরনগর", "IN", "এশিয়া/কলকাতা"),
        ("26.2649", "81.54855", "যাইস", "IN", "এশিয়া/কলকাতা"),
        ("16.06213", "76.0586", "হুংগুন্ড", "IN", "এশিয়া/কলকাতা"),
        ("29.22254", "79.5286", "হলদওয়ানি", "IN", "এশিয়া/কলকাতা"),
        ("26.76628", "83.36889", "গোরখপুর", "IN", "এশিয়া/কলকাতা"),
        ("12.25282", "79.41727", "জিঞ্জি", "IN", "এশিয়া/কলকাতা"),
        ("21.53889", "71.57737", "গড়িয়াধর", "IN", "এশিয়া/কলকাতা"),
        ("15.73628", "75.96976", "গজেন্দ্রগড়", "IN", "এশিয়া/কলকাতা"),
        ("17.54907", "82.85749", "এলামঞ্চিলি", "IN", "এশিয়া/কলকাতা"),
        ("19.21667", "73.08333", "ডম্বিভলি", "IN", "এশিয়া/কলকাতা"),
        ("22.19303", "88.18466", "ডায়মন্ড হারবার", "IN", "এশিয়া/কলকাতা"),
        ("12.1277", "78.15794", "ধর্মপুরী", "IN", "এশিয়া/কলকাতা"),
        ("25.75728", "75.37991", "দেওলি", "IN", "এশিয়া/কলকাতা"),
        ("14.46693", "75.92694", "দাভাঙ্গেরে", "IN", "এশিয়া/কলকাতা"),
        ("25.66795", "85.83636", "দলসিং সরাই", "IN", "এশিয়া/কলকাতা"),
        ("15.5439", "73.7553", "ক্যালাঙ্গুট", "IN", "এশিয়া/কলকাতা"),
        ("27.9247", "78.40102", "ছারা", "IN", "এশিয়া/কলকাতা"),
        ("32.55531", "76.12647", "চাম্বা", "IN", "এশিয়া/কলকাতা"),
        ("20.88197", "85.83334", "ভুবন", "IN", "এশিয়া/কলকাতা"),
        ("19.30157", "72.85107", "ভায়ান্দর", "IN", "এশিয়া/কলকাতা"),
        ("15.45144", "78.14797", "বেতামেরলা", "IN", "এশিয়া/কলকাতা"),
        ("26.32293", "91.00632", "বারপেটা", "IN", "এশিয়া/কলকাতা"),
        ("28.92694", "78.23456", "বাছরাও", "IN", "এশিয়া/কলকাতা"),
        ("21.59983", "71.21169", "আমরেলি", "IN", "এশিয়া/কলকাতা"),
        ("10.10649", "76.35484", "সর্বদা", "IN", "এশিয়া/কলকাতা"),
        ("24.41288", "76.56719", "আকলেরা", "IN", "এশিয়া/কলকাতা"),
        ("23.49668", "86.68363", "আদ্রা", "IN", "এশিয়া/কলকাতা"),
        ("22.4711", "88.1453", "পূজালি", "IN", "এশিয়া/কলকাতা"),
        ("22.10194", "85.37752", "বারবিল", "IN", "এশিয়া/কলকাতা"),
        ("17.34769", "78.55757", "লাল বাহাদুর নগর", "IN", "এশিয়া/কলকাতা"),
        ("23.18", "88.58", "আইস্তালা", "IN", "এশিয়া/কলকাতা"),
        ("9.57046", "76.32756", "কালাভুর", "IN", "এশিয়া/কলকাতা"),
        ("32.61603", "44.02488", "কারবালা", "IQ", "এশিয়া/বাগদাদ"),
        ("35.6803", "51.0193", "শাহরে জাদিদে আন্দিসেহ", "IR", "এশিয়া/তেহরান"),
        ("36.64852", "51.49621", "নওশহর", "IR", "এশিয়া/তেহরান"),
        ("33.14447", "47.3799", "দারেহ শাহর", "IR", "এশিয়া/তেহরান"),
        ("33.86419", "48.26258", "আলেশতার", "IR", "এশিয়া/তেহরান"),
        ("32.65246", "51.67462", "ইসফাহান", "IR", "এশিয়া/তেহরান"),
        ("38.07789", "13.44275", "ভিলাবাতে", "IT", "ইউরোপ/রোম"),
        ("36.92574", "14.72443", "রাগুসা", "IT", "ইউরোপ/রোম"),
        ("37.51803", "15.00913", "মিস্টারবিয়ানকো", "IT", "ইউরোপ/রোম"),
        ("37.49223", "15.07041", "ক্যাটানিয়া", "IT", "ইউরোপ/রোম"),
        ("37.31065", "13.57661", "Agrigento", "IT", "ইউরোপ/রোম"),
        ("43.78956", "7.60872", "ভেন্টিমিগ্লিয়া", "IT", "ইউরোপ/রোম"),
        ("44.89784", "8.86374", "টরটোনা", "IT", "ইউরোপ/রোম"),
        ("40.87329", "14.43865", "সোমা ভেসুভিয়ানা", "IT", "ইউরোপ/রোম"),
        ("40.72586", "8.55552", "সাসারী", "IT", "ইউরোপ/রোম"),
        ("45.39402", "9.29109", "সান গিউলিয়ানো মিলানিস", "IT", "ইউরোপ/রোম"),
        ("42.67164", "14.01481", "রোসেটো দেগলি অ্যাব্রুজি", "IT", "ইউরোপ/রোম"),
        ("45.78071", "12.84052", "পোর্টোগুয়ারো", "IT", "ইউরোপ/রোম"),
        ("43.1122", "12.38878", "পেরুজিয়া", "IT", "ইউরোপ/রোম"),
        ("45.44694", "8.62118", "নোভারা", "IT", "ইউরোপ/রোম"),
        ("45.50369", "11.412", "মন্টেচিও ম্যাগিওর-আল্টে সেকাতো", "IT", "ইউরোপ/রোম"),
        ("40.55851", "17.80774", "মেসেগনে", "IT", "ইউরোপ/রোম"),
        ("45.79377", "8.88104", "মালনাট", "IT", "ইউরোপ/রোম"),
        ("42.22718", "14.39024", "ল্যান্সিয়ানো", "IT", "ইউরোপ/রোম"),
        ("45.53069", "9.40531", "গরগনজোলা", "IT", "ইউরোপ/রোম"),
        ("40.53123", "17.58522", "ফ্রাঙ্কাভিলা ফন্টানা", "IT", "ইউরোপ/রোম"),
        ("43.62558", "13.39954", "ফ্যালকোনারা মারিত্তিমা", "IT", "ইউরোপ/রোম"),
        ("45.9836", "12.70038", "কর্ডেননস", "IT", "ইউরোপ/রোম"),
        ("44.31771", "9.32241", "চিয়াওয়ারি", "IT", "ইউরোপ/রোম"),
        ("44.59445", "11.04979", "ক্যাস্টেলফ্রাঙ্কো এমিলিয়া", "IT", "ইউরোপ/রোম"),
        ("41.55947", "14.66737", "ক্যাম্পোবাসো", "IT", "ইউরোপ/রোম"),
        ("41.24264", "16.50104", "বিসেগলি", "IT", "ইউরোপ/রোম"),
        ("41.72063", "12.6723", "আরিকিয়া", "IT", "ইউরোপ/রোম"),
        ("40.92298", "14.30935", "আফরাগোলা", "IT", "ইউরোপ/রোম"),
        ("40.87363", "14.34085", "ভোল্লা", "IT", "ইউরোপ/রোম"),
        ("18.00747", "-76.78319", "নিউ কিংস্টন", "JM", "আমেরিকা/জ্যামাইকা"),
        ("35.8", "137.23333", "জিরো", "JP", "এশিয়া/টোকিও"),
        ("34.61667", "135.6", "ইয়াও", "JP", "এশিয়া/টোকিও"),
        ("34.75856", "136.13108", "উয়েনো-ইবিসুমাচি", "JP", "এশিয়া/টোকিও"),
        ("34.81667", "137.4", "টোয়োকাওয়া", "JP", "এশিয়া/টোকিও"),
        ("34.4833", "136.84186", "তোবা", "JP", "এশিয়া/টোকিও"),
        ("36.65", "138.31667", "সুজাকা", "JP", "এশিয়া/টোকিও"),
        ("34.9", "137.5", "শিনশিরো", "JP", "এশিয়া/টোকিও"),
        ("35.06667", "135.21667", "সসায়ামা", "JP", "এশিয়া/টোকিও"),
        ("36", "139.55722", "ওকেগাওয়া", "JP", "এশিয়া/টোকিও"),
        ("36.53333", "136.61667", "নোনোইচি", "JP", "এশিয়া/টোকিও"),
        ("36.75965", "137.36215", "নামেরিকাওয়া", "JP", "এশিয়া/টোকিও"),
        ("35", "136.51667", "কোমোনো", "JP", "এশিয়া/টোকিও"),
        ("33.4425", "129.96972", "কারাতসু", "JP", "এশিয়া/টোকিও"),
        ("35.30889", "139.55028", "কামাকুরা", "JP", "এশিয়া/টোকিও"),
        ("34.25", "135.31667", "আইওয়াড", "JP", "এশিয়া/টোকিও"),
        ("35.82756", "137.95378", "ইনা", "JP", "এশিয়া/টোকিও"),
        ("33.3213", "130.94098", "হিতা", "JP", "এশিয়া/টোকিও"),
        ("36.24624", "139.07204", "ফুজিওকা", "JP", "এশিয়া/টোকিও"),
        ("36.33011", "138.89585", "আন্নাকা", "JP", "এশিয়া/টোকিও"),
        ("35.815", "139.6853", "শিমোতোদা", "JP", "এশিয়া/টোকিও"),
        ("39.46667", "141.95", "ইয়ামাদা", "JP", "এশিয়া/টোকিও"),
        ("37.56667", "140.11667", "ইনাওয়াশিরো", "JP", "এশিয়া/টোকিও"),
        ("43.82634", "144.09638", "মোটোমাচি", "JP", "এশিয়া/টোকিও"),
        ("44.35056", "142.45778", "নায়োরো", "JP", "এশিয়া/টোকিও"),
        ("41.77583", "140.73667", "হাকোদতে", "JP", "এশিয়া/টোকিও"),
        ("35.48199", "137.02166", "মিনোকামো", "JP", "এশিয়া/টোকিও"),
        ("0.03813", "36.36339", "ন্যাহুরুরু", "KE", "আফ্রিকা/নাইরোবি"),
        ("3.11988", "35.59642", "লোডওয়ার", "KE", "আফ্রিকা/নাইরোবি"),
        ("0.46005", "34.11169", "বুসিয়া", "KE", "আফ্রিকা/নাইরোবি"),
        ("40.93333", "73", "জালাল-আবাদ", "KG", "এশিয়া/বিশকেক"),
        ("13.65805", "102.56365", "পায় পায়ে", "KH", "এশিয়া/ফনম_পেন"),
        ("36.82167", "128.63083", "আইজেন", "KR", "এশিয়া/সিউল"),
        ("37.1759", "128.9889", "টি আওবায়েক", "KR", "এশিয়া/সিউল"),
        ("36.20389", "127.08472", "ননসান", "KR", "এশিয়া/সিউল"),
        ("37.65639", "126.835", "গোয়াং-সি", "KR", "এশিয়া/সিউল"),
        ("36.6009", "126.665", "হংসিওং", "KR", "এশিয়া/সিউল"),
        ("34.8825", "128.62667", "সিনহিওন", "KR", "এশিয়া/সিউল"),
        ("47.83333", "59.6", "শালকার", "KZ", "এশিয়া/আকতোব"),
        ("47.46657", "84.87144", "জায়সান", "KZ", "এশিয়া/আলমাটি"),
        ("44.85278", "65.50917", "কাইজি লাঁদা", "KZ", "এশিয়া/কিউজিলর্ডা"),
        ("43.41949", "77.0202", "ওটেজেন বাটিরা", "KZ", "এশিয়া/আলমাটি"),
        ("6.84019", "79.87116", "দেহিওয়ালা-মাউন্ট লাভিনিয়া", "LK", "এশিয়া/কলম্বো"),
        ("6.9909", "79.883", "হেন্ডালা", "LK", "এশিয়া/কলম্বো"),
        ("7.57944", "-8.53778", "নিউ ইয়েকেপা", "LR", "আফ্রিকা/মনরোভিয়া"),
        ("55.25", "24.75", "উকমার্জ", "LT", "ইউরোপ/ভিলনিয়াস"),
        ("54.39635", "24.04142", "অ্যালিটাস", "LT", "ইউরোপ/ভিলনিয়াস"),
        ("30.75545", "20.22625", "আজদাবিয়া", "LY", "আফ্রিকা/ত্রিপোলি"),
        ("24.96334", "10.18003", "ঘাট", "LY", "আফ্রিকা/ত্রিপোলি"),
        ("33.92866", "-6.90656", "তেমারা", "MA", "আফ্রিকা/ক্যাসাব্লাঙ্কা"),
        ("33.42585", "-6.00137", "ওলমেস", "MA", "আফ্রিকা/ক্যাসাব্লাঙ্কা"),
        ("34.31", "-2.16", "জেরদা", "MA", "আফ্রিকা/ক্যাসাব্লাঙ্কা"),
        ("33.43443", "-5.22126", "আজরু", "MA", "আফ্রিকা/ক্যাসাব্লাঙ্কা"),
        ("48.15659", "28.28489", "সোরোকা", "MD", "ইউরোপ/চিসিনাউ"),
        ("42.28639", "18.84", "বুদভা", "ME", "ইউরোপ/পডগোরিকা"),
        ("-22.9", "44.53333", "সাকারহা", "MG", "ভারতীয়/আন্তানানারিভো"),
        ("-21.15", "46.58333", "ইকালমাভনি", "MG", "ভারতীয়/আন্তানানারিভো"),
        ("-19.65", "47.31667", "অ্যান্টানিফোটসি", "MG", "ভারতীয়/আন্তানানারিভো"),
        ("-17.83333", "48.41667", "আম্বাতোন্দ্রাজাকা", "MG", "ভারতীয়/আন্তানানারিভো"),
        ("42", "21.32778", "সরজ", "MK", "ইউরোপ/স্কোপজে"),
        ("41.92361", "20.91361", "বোগোভিঞ্জে", "MK", "ইউরোপ/স্কোপজে"),
        ("12.74409", "-8.07257", "কাটি", "ML", "আফ্রিকা/বামাকো"),
        ("14.0823", "98.19151", "দাউই", "MM", "এশিয়া/ইয়াঙ্গুন"),
        ("16.68911", "98.50893", "ম্যাওয়াদি", "MM", "এশিয়া/ইয়াঙ্গুন"),
        ("17.30858", "97.01124", "কাইক্টো", "MM", "এশিয়া/ইয়াঙ্গুন"),
        ("47.90771", "106.88324", "উলান বাটোর", "MN", "এশিয়া/উলানবাতার"),
        ("14.67751", "-60.94228", "লে রবার্ট", "MQ", "আমেরিকা/মার্টিনিক"),
        ("35.89972", "14.51472", "ভ্যালেটা", "MT", "ইউরোপ/মাল্টা"),
        ("-13.7804", "34.4587", "সালিমা", "MW", "আফ্রিকা/ব্লান্টার"),
        ("16.75973", "-93.11308", "টাক্সটলা", "MX", "আমেরিকা/মেক্সিকো_সিটি"),
        ("19.8173", "-97.35992", "তেজিউটলান", "MX", "আমেরিকা/মেক্সিকো_সিটি"),
        ("21.28306", "-89.66123", "প্রগ্রেসো", "MX", "আমেরিকা/মেরিডা"),
        ("17.06542", "-96.72365", "ওক্সাকা", "MX", "আমেরিকা/মেক্সিকো_সিটি"),
        ("25.87972", "-97.50417", "হিরোইকা মাতামোরোস", "MX", "আমেরিকা/মাতামোরোস"),
        ("19.32932", "-98.1664", "কন্টলা", "MX", "আমেরিকা/মেক্সিকো_সিটি"),
        ("17.94979", "-94.91386", "আকাইউকান", "MX", "আমেরিকা/মেক্সিকো_সিটি"),
        ("19.32889", "-99.32556", "সান লরেঞ্জো অ্যাকোপিলকো", "MX", "আমেরিকা/মেক্সিকো_সিটি"),
        ("20.22816", "-103.5687", "জাকোয়ালকো ডি টরেস", "MX", "আমেরিকা/মেক্সিকো_সিটি"),
        ("20.74122", "-100.44843", "সান্তা রোজা জাউরেগুই", "MX", "আমেরিকা/মেক্সিকো_সিটি"),
        ("20.21322", "-100.88023", "সালভাতিয়েরা", "MX", "আমেরিকা/মেক্সিকো_সিটি"),
        ("19.64745", "-102.04897", "প্যারাচো দে ভার্দুজকো", "MX", "আমেরিকা/মেক্সিকো_সিটি"),
        ("20.28527", "-103.42897", "জোকোটেপেক", "MX", "আমেরিকা/মেক্সিকো_সিটি"),
        ("21.01858", "-101.2591", "গুয়ানাজুয়াতো", "MX", "আমেরিকা/মেক্সিকো_সিটি"),
        ("22.49396", "-105.36369", "অ্যাকাপোনেটা", "MX", "আমেরিকা/মাজাতলান"),
        ("19.04222", "-98.11889", "কাসা ব্লাঙ্কা", "MX", "আমেরিকা/মেক্সিকো_সিটি"),
        ("1.6561", "103.6032", "কুলাই", "MY", "এশিয়া/কুয়ালালামপুর"),
        ("5.90702", "116.10146", "ডংগনগন", "MY", "এশিয়া/কুচিং"),
        ("4.88441", "101.96857", "গুয়া মুসাং", "MY", "এশিয়া/কুয়ালালামপুর"),
        ("5.4709", "100.24529", "বাতু ফেরিংগি", "MY", "এশিয়া/কুয়ালালামপুর"),
        ("4.02219", "101.02083", "তেলুক ইন্তান", "MY", "এশিয়া/কুয়ালালামপুর"),
        ("1.6", "103.81667", "উলু তিরাম", "MY", "এশিয়া/কুয়ালালামপুর"),
        ("2.2139", "102.3278", "কাম্পুং আয়ের মোলেক", "MY", "এশিয়া/কুয়ালালামপুর"),
        ("-23.85972", "35.34722", "ম্যাক্সি", "MZ", "আফ্রিকা/মাপুতো"),
        ("-21.98333", "16.91667", "ওকাহান্দজা", "NA", "আফ্রিকা/উইন্ডহোক"),
        ("13.70727", "9.15013", "মিররিয়া", "NE", "আফ্রিকা/নিয়ামে"),
        ("4.92675", "6.26764", "ইয়েনাগোয়া", "NG", "আফ্রিকা/লাগোস"),
        ("6.8485", "3.64633", "শাগামু", "NG", "আফ্রিকা/লাগোস"),
        ("7.6", "4.18333", "ওলুপোনা", "NG", "আফ্রিকা/লাগোস"),
        ("6.15038", "6.83042", "এনকেপোর", "NG", "আফ্রিকা/লাগোস"),
        ("6.45407", "3.39467", "লাগোস", "NG", "আফ্রিকা/লাগোস"),
        ("9.58126", "8.2926", "কাফঞ্চন", "NG", "আফ্রিকা/লাগোস"),
        ("7.62789", "4.74161", "ইলেসা", "NG", "আফ্রিকা/লাগোস"),
        ("7.50251", "5.06258", "ইগবারা-ওডো", "NG", "আফ্রিকা/লাগোস"),
        ("11.86064", "9.0027", "গয়া", "NG", "আফ্রিকা/লাগোস"),
        ("7.65649", "4.92235", "ইফন-আলায়ে", "NG", "আফ্রিকা/লাগোস"),
        ("10.61285", "12.19458", "বিউ", "NG", "আফ্রিকা/লাগোস"),
        ("12.74482", "4.52514", "আর্গুঙ্গু", "NG", "আফ্রিকা/লাগোস"),
        ("13.48082", "-86.58208", "সোমোটো", "NI", "আমেরিকা/মানাগুয়া"),
        ("11.84962", "-86.19903", "জিনোটেপ", "NI", "আমেরিকা/মানাগুয়া"),
        ("52.09", "5.23333", "জিস্ট", "NL", "ইউরোপ/আমস্টারডাম"),
        ("51.65333", "5.2875", "ভুত", "NL", "ইউরোপ/আমস্টারডাম"),
        ("51.44889", "5.51978", "টোঙ্গেলরে", "NL", "ইউরোপ/আমস্টারডাম"),
        ("51.95838", "4.47124", "স্কিব্রেক", "NL", "ইউরোপ/আমস্টারডাম"),
        ("52.31333", "6.92917", "ওল্ডেনজাল", "NL", "ইউরোপ/আমস্টারডাম"),
        ("52.26083", "7.00417", "পরাজয়কারী", "NL", "ইউরোপ/আমস্টারডাম"),
        ("53.16167", "6.76111", "হুগেজান্ড", "NL", "ইউরোপ/আমস্টারডাম"),
        ("52.57583", "6.61944", "হার্ডেনবার্গ", "NL", "ইউরোপ/আমস্টারডাম"),
        ("52.71083", "5.74861", "এমেলরড", "NL", "ইউরোপ/আমস্টারডাম"),
        ("51.955", "5.22778", "কুলেমবুর্গ", "NL", "ইউরোপ/আমস্টারডাম"),
        ("52.14", "5.58472", "বারনেভেল্ড", "NL", "ইউরোপ/আমস্টারডাম"),
        ("68.79833", "16.54165", "হারস্তাদ", "NO", "ইউরোপ/অসলো"),
        ("-44.39672", "171.25364", "তিমারু", "NZ", "প্যাসিফিক/অকল্যান্ড"),
        ("-38.65333", "178.00417", "গিসবোর্ন", "NZ", "প্যাসিফিক/অকল্যান্ড"),
        ("8.88988", "-79.62603", "ভেরাক্রুজ", "PA", "আমেরিকা/পানামা"),
        ("9.15093", "-79.62098", "চিলিব্রে", "PA", "আমেরিকা/পানামা"),
        ("-3.74912", "-73.25383", "ইকুইটোস", "PE", "আমেরিকা/লিমা"),
        ("-16.25", "-69.08333", "ইয়ুনগুইয়ো", "PE", "আমেরিকা/লিমা"),
        ("-15.21194", "-75.11028", "মিনাস ডি মার্কোনা", "PE", "আমেরিকা/লিমা"),
        ("-11.94306", "-76.70944", "চসিকা", "PE", "আমেরিকা/লিমা"),
        ("-5.85746", "144.23058", "মাউন্ট হেগেন", "PG", "প্যাসিফিক/পোর্ট_মোরসবি"),
        ("6.33444", "124.95278", "টুপি", "PH", "এশিয়া/ম্যানিলা"),
        ("10.7375", "122.9666", "তালিসে", "PH", "এশিয়া/ম্যানিলা"),
        ("12.97389", "123.99333", "সরসোগন", "PH", "এশিয়া/ম্যানিলা"),
        ("9.3337", "122.8637", "সান্তা ক্যাটালিনা", "PH", "এশিয়া/ম্যানিলা"),
        ("12.35275", "121.06761", "সান জোসে", "PH", "এশিয়া/ম্যানিলা"),
        ("6.95194", "121.96361", "রেকোডো", "PH", "এশিয়া/ম্যানিলা"),
        ("14.66", "120.56528", "পিলার", "PH", "এশিয়া/ম্যানিলা"),
        ("10.20898", "123.758", "নাগা", "PH", "এশিয়া/ম্যানিলা"),
        ("12.37169", "123.62494", "মাসবাতে", "PH", "এশিয়া/ম্যানিলা"),
        ("16.0438", "120.4861", "মানোয়াগ", "PH", "এশিয়া/ম্যানিলা"),
        ("10.13361", "124.84472", "মাসিন", "PH", "এশিয়া/ম্যানিলা"),
        ("16.455", "120.5875", "লা ত্রিনিদাদ", "PH", "এশিয়া/ম্যানিলা"),
        ("9.6531", "124.3697", "জাগ্না", "PH", "এশিয়া/ম্যানিলা"),
        ("14.8361", "120.97844", "গুইয়ং", "PH", "এশিয়া/ম্যানিলা"),
        ("8.56697", "123.33471", "ডিপোলগ", "PH", "এশিয়া/ম্যানিলা"),
        ("10.31672", "123.89071", "সেবু সিটি", "PH", "এশিয়া/ম্যানিলা"),
        ("14.14989", "121.3152", "কলাউয়ান", "PH", "এশিয়া/ম্যানিলা"),
        ("15.72892", "120.57224", "বার্গোস", "PH", "এশিয়া/ম্যানিলা"),
        ("14.95472", "120.89694", "বালিউয়াগ", "PH", "এশিয়া/ম্যানিলা"),
        ("14.62578", "121.12251", "অ্যান্টিপোলো", "PH", "এশিয়া/ম্যানিলা"),
        ("27.52948", "68.75915", "খয়েরপুর মিরস", "PK", "এশিয়া/করাচি"),
        ("26.9423", "68.11759", "থারু শাহ", "PK", "এশিয়া/করাচি"),
        ("31.82539", "72.54064", "সিল্লানওয়ালি", "PK", "এশিয়া/করাচি"),
        ("31.71667", "73.38333", "সাংলা পাহাড়", "PK", "এশিয়া/করাচি"),
        ("30.29184", "71.67164", "কাদিরপুর রান", "PK", "এশিয়া/করাচি"),
        ("31.96258", "73.97117", "নৌশাহরা বিরকান", "PK", "এশিয়া/করাচি"),
        ("32.57756", "71.52847", "মিয়ানওয়ালি", "PK", "এশিয়া/করাচি"),
        ("27.55898", "68.21204", "লারকানা", "PK", "এশিয়া/করাচি"),
        ("30.46907", "70.96699", "কোট আদ্দু", "PK", "এশিয়া/করাচি"),
        ("30.76468", "74.12286", "কাঙ্গনপুর", "PK", "এশিয়া/করাচি"),
        ("25.95533", "68.88871", "ঝোল", "PK", "এশিয়া/করাচি"),
        ("29.69221", "72.54566", "হাসিলপুর", "PK", "এশিয়া/করাচি"),
        ("32.17629", "75.06583", "ফাজিলপুর", "PK", "এশিয়া/করাচি"),
        ("32.87533", "71.57118", "দাউদ খেলা", "PK", "এশিয়া/করাচি"),
        ("25.80565", "68.49143", "ভীত শাহ", "PK", "এশিয়া/করাচি"),
        ("29.38242", "70.91106", "আলিপুর", "PK", "এশিয়া/করাচি"),
        ("51.14942", "15.00835", "জগরজেলেক", "PL", "ইউরোপ/ওয়ারশ"),
        ("54.58048", "16.86194", "উসকা", "PL", "ইউরোপ/ওয়ারশ"),
        ("50.5107", "18.30056", "স্ট্রজেলস ওপোলস্কি", "PL", "ইউরোপ/ওয়ারশ"),
        ("54.60528", "18.34717", "রেদা", "PL", "ইউরোপ/ওয়ারশ"),
        ("50.20528", "19.27498", "জাওর্জনো", "PL", "ইউরোপ/ওয়ারশ"),
        ("50.86079", "17.4674", "ব্রজেগ", "PL", "ইউরোপ/ওয়ারশ"),
        ("18.42745", "-67.15407", "আগুয়াডিলা", "PR", "আমেরিকা/পুয়ের্তো_রিকো"),
        ("18.03496", "-66.8499", "ইয়াউকো", "PR", "আমেরিকা/পুয়ের্তো_রিকো"),
        ("31.78336", "35.23388", "পূর্ব জেরুজালেম", "PS", "এশিয়া/হেব্রন"),
        ("38.72706", "-9.24671", "কার্নাক্সাইড", "PT", "ইউরোপ/লিসবন"),
        ("37.08819", "-8.2503", "আলবুফেরা", "PT", "ইউরোপ/লিসবন"),
        ("41.20485", "-8.33147", "পারদেস", "PT", "ইউরোপ/লিসবন"),
        ("41.1053", "-7.32097", "কাস্টোয়াস", "PT", "ইউরোপ/লিসবন"),
        ("37.74615", "-25.66689", "পোন্তা দেলগাদা", "PT", "আটলান্টিক/অ্যাজোরস"),
        ("-20.88231", "55.4504", "সেন্ট-ডেনিস", "RE", "ভারতীয়/পুনর্মিলন"),
        ("44.43579", "26.01649", "সেক্টর 6", "RO", "ইউরোপ/বুখারেস্ট"),
        ("44.22639", "22.53083", "নেগোটিন", "RS", "ইউরোপ/বেলগ্রেড"),
        ("44.97639", "19.61222", "স্রেমস্কা মিত্রোভিকা", "RS", "ইউরোপ/বেলগ্রেড"),
        ("53.53395", "33.72798", "ঝুকভকা", "RU", "ইউরোপ/মস্কো"),
        ("46.7055", "38.2739", "ইয়েস্ক", "RU", "ইউরোপ/মস্কো"),
        ("44.98901", "38.94324", "ইয়াবলোনোভস্কি", "RU", "ইউরোপ/মস্কো"),
        ("56.03361", "35.96944", "ভোলোকোলামস্ক", "RU", "ইউরোপ/মস্কো"),
        ("57.97472", "33.2525", "ভালদিন", "RU", "ইউরোপ/মস্কো"),
        ("56.85836", "35.90057", "Tver", "RU", "ইউরোপ/মস্কো"),
        ("55.62047", "37.49338", "টাইপলি স্ট্যান", "RU", "ইউরোপ/মস্কো"),
        ("54.90083", "38.07083", "স্টুপিনো", "RU", "ইউরোপ/মস্কো"),
        ("55.63711", "37.38115", "সোল্টসেভো", "RU", "ইউরোপ/মস্কো"),
        ("59.80917", "30.38167", "শুশারী", "RU", "ইউরোপ/মস্কো"),
        ("64.5635", "39.8302", "সেভেরোডভিনস্ক", "RU", "ইউরোপ/মস্কো"),
        ("51.78771", "56.36091", "সর্কতাশ", "RU", "এশিয়া/ইয়েকাটেরিনবার্গ"),
        ("53.95278", "32.86389", "রোসলাভল", "RU", "ইউরোপ/মস্কো"),
        ("51.40944", "46.04833", "প্রিভোলজস্কি", "RU", "ইউরোপ/সারাতোভ"),
        ("61.78491", "34.34691", "পেট্রোজাভোডস্ক", "RU", "ইউরোপ/মস্কো"),
        ("53.37596", "51.3452", "Otradnyy", "RU", "ইউরোপ/সামারা"),
        ("54.48147", "53.47103", "অক্টিয়াব্রএস্কি", "RU", "এশিয়া/ইয়েকাটেরিনবার্গ"),
        ("43.96222", "43.63417", "নোভোপাভলভস্ক", "RU", "ইউরোপ/মস্কো"),
        ("53.53041", "43.67663", "নিঝনি লোমভ", "RU", "ইউরোপ/মস্কো"),
        ("55.38752", "36.73307", "নারো-ফমিনস্ক", "RU", "ইউরোপ/মস্কো"),
        ("50.06", "43.2379", "মিখাইলোভকা", "RU", "ইউরোপ/ভলগোগ্রাদ"),
        ("55.64776", "38.02486", "মালাখোভকা", "RU", "ইউরোপ/মস্কো"),
        ("55.85", "37.56667", "লিখবরী", "RU", "ইউরোপ/মস্কো"),
        ("51.4781", "57.3552", "কুভান্ডিক", "RU", "এশিয়া/ইয়েকাটেরিনবার্গ"),
        ("44.92934", "37.99117", "ক্রিমস্ক", "RU", "ইউরোপ/মস্কো"),
        ("54.03876", "43.91385", "কোভিলকিনো", "RU", "ইউরোপ/মস্কো"),
        ("60.02427", "30.28491", "কলোম্যাগি", "RU", "ইউরোপ/মস্কো"),
        ("53.93361", "37.92792", "কিরেয়েভস্ক", "RU", "ইউরোপ/মস্কো"),
        ("54.84444", "38.16694", "কাশিরা", "RU", "ইউরোপ/মস্কো"),
        ("58.7002", "59.4839", "কাচকানার", "RU", "এশিয়া/ইয়েকাটেরিনবার্গ"),
        ("43.35071", "46.10925", "গুডারমেস", "RU", "ইউরোপ/মস্কো"),
        ("57.30185", "39.85331", "গ্যাভ্রিলভ-ইয়াম", "RU", "ইউরোপ/মস্কো"),
        ("53.59782", "34.33825", "ডায়াটএকোভো", "RU", "ইউরোপ/মস্কো"),
        ("58.1908", "40.17171", "দানিলভ", "RU", "ইউরোপ/মস্কো"),
        ("42.819", "47.1192", "বুইনাকস্ক", "RU", "ইউরোপ/মস্কো"),
        ("53.77166", "38.12408", "বোগোরোডিটস্ক", "RU", "ইউরোপ/মস্কো"),
        ("54.39304", "53.26023", "বাভলি", "RU", "ইউরোপ/মস্কো"),
        ("55.39485", "43.83992", "আরজামাস", "RU", "ইউরোপ/মস্কো"),
        ("54.8421", "46.5813", "আলাটির", "RU", "ইউরোপ/মস্কো"),
        ("58.63667", "59.80222", "লেসনয়", "RU", "এশিয়া/ইয়েকাটেরিনবার্গ"),
        ("55.8736", "85.4265", "ইয়াশকিনো", "RU", "এশিয়া/নোভোকুজনেটস্ক"),
        ("58.04254", "65.27258", "তাভদা", "RU", "এশিয়া/ইয়েকাটেরিনবার্গ"),
        ("55.54028", "89.20083", "শারিপোভো", "RU", "এশিয়া/ক্রাসনোয়ারস্ক"),
        ("53.30972", "83.62389", "নোভোসিলিকাটনি", "RU", "এশিয়া/বার্নউল"),
        ("58.23583", "92.48278", "লেসোসিবিরস্ক", "RU", "এশিয়া/ক্রাসনোয়ারস্ক"),
        ("56.11281", "69.49015", "ইশিম", "RU", "এশিয়া/ইয়েকাটেরিনবার্গ"),
        ("56.9083", "60.8019", "বেরিওজভস্কি", "RU", "এশিয়া/ইয়েকাটেরিনবার্গ"),
        ("55.75556", "60.70278", "ওজারস্ক", "RU", "এশিয়া/ইয়েকাটেরিনবার্গ"),
        ("51.82721", "107.60627", "উলান-উদে", "RU", "এশিয়া/ইরকুটস্ক"),
        ("45.47885", "133.42825", "লেসোজাভোডস্ক", "RU", "এশিয়া/ভ্লাদিভোস্টক"),
        ("65.93381", "111.4834", "আয়খাল", "RU", "এশিয়া/ইয়াকুটস্ক"),
        ("53.14657", "140.72287", "নিকোলায়েভস্ক-অন-আমুরে", "RU", "এশিয়া/ভ্লাদিভোস্টক"),
        ("60.97944", "76.92421", "ইজলুচিনস্ক", "RU", "এশিয়া/ইয়েকাটেরিনবার্গ"),
        ("-1.9487", "30.4347", "রওয়ামাগানা", "RW", "আফ্রিকা/কিগালি"),
        ("27.0174", "49.62251", "আল জুবাইল", "SA", "এশিয়া/রিয়াদ"),
        ("11.8659", "34.3869", "আর রুসেরিস", "SD", "আফ্রিকা/খার্তুম"),
        ("61.72744", "17.10558", "হুডিক্সভাল", "SE", "ইউরোপ/স্টকহোম"),
        ("59.33333", "18.28333", "বু", "SE", "ইউরোপ/স্টকহোম"),
        ("48.8449", "17.22635", "স্কালিকা", "SK", "ইউরোপ/ব্র্যাটিস্লাভা"),
        ("48.43174", "17.8031", "হলোহোভেক", "SK", "ইউরোপ/ব্রাটিস্লাভা"),
        ("8.48714", "-13.2356", "ফ্রিটাউন", "SL", "আফ্রিকা/ফ্রিটাউন"),
        ("-0.35817", "42.54536", "কিসমায়ো", "SO", "আফ্রিকা/মোগাদিশু"),
        ("9.89206", "43.38531", "বাকি", "SO", "আফ্রিকা/মোগাদিশু"),
        ("13.73417", "-89.71472", "সোনজাকেট", "SV", "আমেরিকা/এল_সালভাদর"),
        ("13.70167", "-89.10944", "ইলোপাঙ্গো", "SV", "আমেরিকা/এল_সালভাদর"),
        ("34.5624", "38.28402", "তাদমুর", "SY", "এশিয়া/দামাস্কাস"),
        ("35.95664", "36.7138", "বিন্নিশ", "SY", "এশিয়া/দামাস্কাস"),
        ("12.18441", "18.69303", "মঙ্গো", "TD", "আফ্রিকা/এনজামেনা"),
        ("15.46063", "99.89166", "থাপ থান", "TH", "এশিয়া/ব্যাংকক"),
        ("8.43333", "99.96667", "নাখোঁ সি থামমারাত", "TH", "এশিয়া/ব্যাংকক"),
        ("13.51825", "99.95469", "ড্যামনোয়েন সাদুয়াক", "TH", "এশিয়া/ব্যাংকক"),
        ("15.79408", "104.1451", "ইয়াসোথন", "TH", "এশিয়া/ব্যাংকক"),
        ("6.25947", "102.05461", "তক বাই", "TH", "এশিয়া/ব্যাংকক"),
        ("16.0567", "103.65309", "রই এট", "TH", "এশিয়া/ব্যাংকক"),
        ("13.44581", "101.18445", "ফানাত নিখোম", "TH", "এশিয়া/ব্যাংকক"),
        ("13.8196", "100.04427", "নাখোঁ পথম", "TH", "এশিয়া/ব্যাংকক"),
        ("14.64056", "104.64992", "কাঁথারলক", "TH", "এশিয়া/ব্যাংকক"),
        ("15.58552", "102.42587", "বুয়া ইয়াই", "TH", "এশিয়া/ব্যাংকক"),
        ("14.37395", "100.48528", "ব্যাং ব্যান", "TH", "এশিয়া/ব্যাংকক"),
        ("38.55632", "69.01354", "ওয়াহদাত", "TJ", "এশিয়া/দুশানবে"),
        ("-8.99167", "125.21972", "মালিয়ানা", "TL", "এশিয়া/দিলি"),
        ("36.08497", "9.37082", "সিলিয়ানা", "TN", "আফ্রিকা/তিউনিস"),
        ("35.72917", "10.58082", "মসকেন", "TN", "আফ্রিকা/তিউনিস"),
        ("36.46917", "10.78222", "বেনী খিয়ার", "TN", "আফ্রিকা/তিউনিস"),
        ("37.16911", "10.03478", "এল আলিয়া", "TN", "আফ্রিকা/তিউনিস"),
        ("38.13708", "41.00817", "সিলভান", "TR", "ইউরোপ/ইস্তাম্বুল"),
        ("39.22493", "42.85693", "প্যাটনোস", "TR", "ইউরোপ/ইস্তাম্বুল"),
        ("37.31309", "40.74357", "মর্দিন", "TR", "ইউরোপ/ইস্তাম্বুল"),
        ("37.58105", "29.26639", "সেরিনহিসার", "TR", "ইউরোপ/ইস্তাম্বুল"),
        ("37.05944", "37.3825", "গাজিয়ানটেপ", "TR", "ইউরোপ/ইস্তাম্বুল"),
        ("39.59611", "27.02444", "এডরেমিট", "TR", "ইউরোপ/ইস্তাম্বুল"),
        ("39.12074", "27.18052", "বারগামা", "TR", "ইউরোপ/ইস্তাম্বুল"),
        ("38.37255", "34.02537", "অক্ষরে", "TR", "ইউরোপ/ইস্তাম্বুল"),
        ("40.98894", "28.67582", "ইয়াকুপলু", "TR", "ইউরোপ/ইস্তাম্বুল"),
        ("40.1675", "34.37389", "সুঙ্গুরলু", "TR", "ইউরোপ/ইস্তাম্বুল"),
        ("40.37528", "28.88222", "মুদান্যা", "TR", "ইউরোপ/ইস্তাম্বুল"),
        ("10.66668", "-61.51889", "স্পেনের বন্দর", "TT", "আমেরিকা/পোর্ট_অফ_স্পেন"),
        ("23.5654", "119.58627", "মাগং", "TW", "এশিয়া/তাইপেই"),
        ("-2.68333", "33", "উসাগর", "TZ", "আফ্রিকা/দার_এস_সালাম"),
        ("-4.06667", "37.73333", "একই", "TZ", "আফ্রিকা/দার_এস_সালাম"),
        ("-6.25", "38.66667", "এমভোমেরো", "TZ", "আফ্রিকা/দার_এস_সালাম"),
        ("-4.83", "29.65806", "মওয়ান্ডিগা", "TZ", "আফ্রিকা/দার_এস_সালাম"),
        ("-6.8", "39.25", "মাগোমেনি", "TZ", "আফ্রিকা/দার_এস_সালাম"),
        ("-7.60361", "37.00438", "কিডোদি", "TZ", "আফ্রিকা/দার_এস_সালাম"),
        ("-7.76667", "35.7", "ইরিঙ্গা", "TZ", "আফ্রিকা/দার_এস_সালাম"),
        ("-5.41667", "38.01667", "চনিকা", "TZ", "আফ্রিকা/দার_এস_সালাম"),
        ("-10.33333", "39.28333", "নিয়াগাও", "TZ", "আফ্রিকা/দার_এস_সালাম"),
        ("49.07866", "30.96755", "জেভেনিহোরোদকা", "UA", "ইউরোপ/কিয়েভ"),
        ("47.56494", "31.33078", "ভোজনেসেনস্ক", "UA", "ইউরোপ/কিয়েভ"),
        ("49.41029", "38.15035", "স্বাতভ", "UA", "ইউরোপ/জাপোরোজি"),
        ("50.18545", "27.06365", "শেপেটিভকা", "UA", "ইউরোপ/কিয়েভ"),
        ("47.48444", "36.25361", "পলোহী", "UA", "ইউরোপ/জাপোরোজি"),
        ("46.75451", "33.34864", "নোভা কাখোভকা", "UA", "ইউরোপ/কিয়েভ"),
        ("50.75932", "25.34244", "লুটস্ক", "UA", "ইউরোপ/কিয়েভ"),
        ("49.65186", "26.97253", "ক্র্যাসিলিভ", "UA", "ইউরোপ/কিয়েভ"),
        ("46.65581", "32.6178", "খেরসন", "UA", "ইউরোপ/কিয়েভ"),
        ("51.67822", "33.9162", "হলুখিভ", "UA", "ইউরোপ/কিয়েভ"),
        ("45.99194", "29.41824", "আর্টসিজ", "UA", "ইউরোপ/কিয়েভ"),
        ("2.41669", "30.98551", "পইধা", "UG", "আফ্রিকা/কাম্পালা"),
        ("3.27833", "32.88667", "কিটগাম", "UG", "আফ্রিকা/কাম্পালা"),
        ("3.02013", "30.91105", "আরুয়া", "UG", "আফ্রিকা/কাম্পালা"),
        ("33.45122", "-86.99666", "হুইটাউন", "US", "আমেরিকা/শিকাগো"),
        ("33.44872", "-86.78777", "ভেস্তাভিয়া পাহাড়", "US", "আমেরিকা/শিকাগো"),
        ("35.25064", "-91.73625", "সার্সি", "US", "আমেরিকা/শিকাগো"),
        ("26.68451", "-80.66756", "বেলে গ্লেড", "US", "আমেরিকা/নিউইয়র্ক"),
        ("28.54944", "-81.77285", "ক্লারমন্ট", "US", "আমেরিকা/নিউইয়র্ক"),
        ("28.90054", "-81.26367", "ডেল্টোনা", "US", "আমেরিকা/নিউইয়র্ক"),
        ("29.65163", "-82.32483", "গেইনসভিল", "US", "আমেরিকা/নিউইয়র্ক"),
        ("25.67927", "-80.31727", "কেন্ডাল", "US", "আমেরিকা/নিউইয়র্ক"),
        ("28.15112", "-82.46148", "লুটজ", "US", "আমেরিকা/নিউইয়র্ক"),
        ("26.2173", "-80.22588", "উত্তর লডারডেল", "US", "আমেরিকা/নিউইয়র্ক"),
        ("30.17746", "-81.38758", "পাম ভ্যালি", "US", "আমেরিকা/নিউইয়র্ক"),
        ("26.91756", "-82.07842", "পান্তা গোর্দা দ্বীপপুঞ্জ", "US", "আমেরিকা/নিউইয়র্ক"),
        ("27.71809", "-82.35176", "সান সিটি সেন্টার", "US", "আমেরিকা/নিউইয়র্ক"),
        ("27.09978", "-82.45426", "ভেনিস", "US", "আমেরিকা/নিউইয়র্ক"),
        ("34.06635", "-84.67837", "অ্যাকওয়ার্থ", "US", "আমেরিকা/নিউইয়র্ক"),
        ("32.54044", "-82.90375", "ডাবলিন", "US", "আমেরিকা/নিউইয়র্ক"),
        ("33.08014", "-83.2321", "মিলজেভিল", "US", "আমেরিকা/নিউইয়র্ক"),
        ("33.54428", "-84.23381", "স্টকব্রিজ", "US", "আমেরিকা/নিউইয়র্ক"),
        ("38.58894", "-89.99038", "ফেয়ারভিউ হাইটস", "US", "আমেরিকা/শিকাগো"),
        ("39.78504", "-85.76942", "গ্রিনফিল্ড", "US", "আমেরিকা/ইন্ডিয়ানা/ইন্ডিয়ানাপোলিস"),
        ("38.06084", "-97.92977", "হাচিনসন", "US", "আমেরিকা/শিকাগো"),
        ("39.08367", "-84.50855", "কভিংটন", "US", "আমেরিকা/নিউইয়র্ক"),
        ("36.61033", "-88.31476", "মারে", "US", "আমেরিকা/শিকাগো"),
        ("29.84576", "-90.10674", "এস্টেল", "US", "আমেরিকা/শিকাগো"),
        ("32.52515", "-93.75018", "শ্রেভপোর্ট", "US", "আমেরিকা/শিকাগো"),
        ("38.96372", "-76.99081", "চিলুম", "US", "আমেরিকা/নিউইয়র্ক"),
        ("38.70734", "-77.02303", "ফোর্ট ওয়াশিংটন", "US", "আমেরিকা/নিউইয়র্ক"),
        ("39.33427", "-76.43941", "মধ্য নদী", "US", "আমেরিকা/নিউইয়র্ক"),
        ("39.32011", "-76.51552", "রোজডেল", "US", "আমেরিকা/নিউইয়র্ক"),
        ("39.32288", "-76.72803", "উডলন", "US", "আমেরিকা/নিউইয়র্ক"),
        ("39.09112", "-94.41551", "স্বাধীনতা", "US", "আমেরিকা/শিকাগো"),
        ("37.95143", "-91.77127", "রোল্লা", "US", "আমেরিকা/শিকাগো"),
        ("33.41012", "-91.06177", "গ্রিনভিল", "US", "আমেরিকা/শিকাগো"),
        ("34.25807", "-88.70464", "টুপেলো", "US", "আমেরিকা/শিকাগো"),
        ("35.05266", "-78.87836", "ফয়েটভিল", "US", "আমেরিকা/নিউইয়র্ক"),
        ("34.25628", "-78.04471", "লেল্যান্ড", "US", "আমেরিকা/নিউইয়র্ক"),
        ("35.88264", "-80.08199", "থমাসভিল", "US", "আমেরিকা/নিউইয়র্ক"),
        ("39.71734", "-74.96933", "সিকলারভিল", "US", "আমেরিকা/নিউইয়র্ক"),
        ("39.43534", "-84.20299", "লেবানন", "US", "আমেরিকা/নিউইয়র্ক"),
        ("34.77453", "-96.67834", "আডা", "US", "আমেরিকা/শিকাগো"),
        ("35.74788", "-95.36969", "মুস্কোজি", "US", "আমেরিকা/শিকাগো"),
        ("39.96097", "-75.60804", "ওয়েস্ট চেস্টার", "US", "আমেরিকা/নিউইয়র্ক"),
        ("33.98154", "-81.23621", "লেক্সিংটন", "US", "আমেরিকা/নিউইয়র্ক"),
        ("36.02506", "-86.77917", "ব্রেন্টউড এস্টেটস", "US", "আমেরিকা/শিকাগো"),
        ("35.61452", "-88.81395", "জ্যাকসন", "US", "আমেরিকা/শিকাগো"),
        ("32.44874", "-99.73314", "অ্যাবিলিন", "US", "আমেরিকা/শিকাগো"),
        ("30.16688", "-96.39774", "ব্রেনহাম", "US", "আমেরিকা/শিকাগো"),
        ("31.12406", "-97.90308", "কপারাস কোভ", "US", "আমেরিকা/শিকাগো"),
        ("29.53885", "-95.44744", "ফ্রেসনো", "US", "আমেরিকা/শিকাগো"),
        ("30.5427", "-97.54667", "হুট্টো", "US", "আমেরিকা/শিকাগো"),
        ("32.5007", "-94.74049", "দূর দৃষ্টি", "US", "আমেরিকা/শিকাগো"),
        ("31.76212", "-95.63079", "ফিলিস্তিন", "US", "আমেরিকা/শিকাগো"),
        ("26.18924", "-98.15529", "সান জুয়ান", "US", "আমেরিকা/শিকাগো"),
        ("32.35126", "-95.30106", "টাইলার", "US", "আমেরিকা/শিকাগো"),
        ("37.52487", "-77.55777", "বন এয়ার", "US", "আমেরিকা/নিউইয়র্ক"),
        ("38.91817", "-78.19444", "ফ্রন্ট রয়্যাল", "US", "আমেরিকা/নিউইয়র্ক"),
        ("37.60876", "-77.37331", "মেকানিক্সভিল", "US", "আমেরিকা/নিউইয়র্ক"),
        ("39.00622", "-77.4286", "স্টার্লিং", "US", "আমেরিকা/নিউইয়র্ক"),
        ("39.45621", "-77.96389", "মার্টিনসবার্গ", "US", "আমেরিকা/নিউইয়র্ক"),
        ("41.27621", "-72.86843", "ইস্ট হ্যাভেন", "US", "আমেরিকা/নিউইয়র্ক"),
        ("41.14676", "-73.49484", "নতুন কেনান", "US", "আমেরিকা/নিউইয়র্ক"),
        ("41.55815", "-73.0515", "ওয়াটারবেরি", "US", "আমেরিকা/নিউইয়র্ক"),
        ("41.6764", "-91.58045", "কোরালভিল", "US", "আমেরিকা/শিকাগো"),
        ("41.57721", "-93.71133", "ওয়েস্ট ডেস মইনেস", "US", "আমেরিকা/শিকাগো"),
        ("41.15376", "-87.88754", "বারবোনাইস", "US", "আমেরিকা/শিকাগো"),
        ("42.24113", "-88.3162", "ক্রিস্টাল লেক", "US", "আমেরিকা/শিকাগো"),
        ("41.72059", "-87.70172", "এভারগ্রিন পার্ক", "US", "আমেরিকা/শিকাগো"),
        ("42.16808", "-88.42814", "হান্টলি", "US", "আমেরিকা/শিকাগো"),
        ("41.8542", "-87.66561", "লোয়ার ওয়েস্ট সাইড", "US", "আমেরিকা/শিকাগো"),
        ("41.80753", "-87.65644", "নতুন শহর", "US", "আমেরিকা/শিকাগো"),
        ("40.56754", "-89.64066", "পেকিন", "US", "আমেরিকা/শিকাগো"),
        ("41.84364", "-87.71255", "সাউথ লন্ডেল", "US", "আমেরিকা/শিকাগো"),
        ("41.85059", "-87.882", "ওয়েস্টচেস্টার", "US", "আমেরিকা/শিকাগো"),
        ("41.75338", "-86.11084", "গ্রেঞ্জার", "US", "আমেরিকা/ইন্ডিয়ানা/ইন্ডিয়ানাপোলিস"),
        ("41.47892", "-87.45476", "শেরেরভিল", "US", "আমেরিকা/শিকাগো"),
        ("42.35843", "-71.05977", "বোস্টন", "US", "আমেরিকা/নিউইয়র্ক"),
        ("42.58342", "-71.8023", "ফিচবার্গ", "US", "আমেরিকা/নিউইয়র্ক"),
        ("42.4251", "-71.06616", "মালডেন", "US", "আমেরিকা/নিউইয়র্ক"),
        ("42.52787", "-70.92866", "পিবডি", "US", "আমেরিকা/নিউইয়র্ক"),
        ("41.9001", "-71.08977", "টনটন", "US", "আমেরিকা/নিউইয়র্ক"),
        ("43.91452", "-69.96533", "ব্রান্সউইক", "US", "আমেরিকা/নিউইয়র্ক"),
        ("42.30865", "-83.48216", "ক্যান্টন", "US", "আমেরিকা/ডেট্রয়েট"),
        ("46.09273", "-88.64235", "লোহা নদী", "US", "আমেরিকা/মেনোমিনি"),
        ("42.97086", "-82.42491", "পোর্ট হুরন", "US", "আমেরিকা/ডেট্রয়েট"),
        ("42.7392", "-84.62081", "ওয়েভারলি", "US", "আমেরিকা/ডেট্রয়েট"),
        ("45.0408", "-93.263", "কলাম্বিয়া হাইটস", "US", "আমেরিকা/শিকাগো"),
        ("45.16024", "-93.08883", "লিনো লেকস", "US", "আমেরিকা/শিকাগো"),
        ("44.73941", "-93.12577", "রোজমাউন্ট", "US", "আমেরিকা/শিকাগো"),
        ("47.92526", "-97.03285", "গ্র্যান্ড ফর্কস", "US", "আমেরিকা/শিকাগো"),
        ("42.93369", "-72.27814", "কিনে", "US", "আমেরিকা/নিউইয়র্ক"),
        ("40.94065", "-73.99681", "ডুমন্ট", "US", "আমেরিকা/নিউইয়র্ক"),
        ("40.72816", "-74.07764", "জার্সি সিটি", "US", "আমেরিকা/নিউইয়র্ক"),
        ("40.82232", "-74.15987", "নাটলি", "US", "আমেরিকা/নিউইয়র্ক"),
        ("40.65538", "-74.38987", "স্কচ সমভূমি", "US", "আমেরিকা/নিউইয়র্ক"),
        ("40.5576", "-74.28459", "উডব্রিজ", "US", "আমেরিকা/নিউইয়র্ক"),
        ("40.57788", "-73.95958", "ব্রাইটন বিচ", "US", "আমেরিকা/নিউইয়র্ক"),
        ("40.67705", "-73.89125", "সাইপ্রেস হিলস", "US", "আমেরিকা/নিউইয়র্ক"),
        ("40.60538", "-73.75513", "ফার রকওয়ে", "US", "আমেরিকা/নিউইয়র্ক"),
        ("40.72371", "-73.95097", "গ্রিনপয়েন্ট", "US", "আমেরিকা/নিউইয়র্ক"),
        ("40.64621", "-73.97069", "কেন্সিংটন", "US", "আমেরিকা/নিউইয়র্ক"),
        ("40.68066", "-73.47429", "মাসাপেকা", "US", "আমেরিকা/নিউইয়র্ক"),
        ("41.50343", "-74.01042", "নিউবার্গ", "US", "আমেরিকা/নিউইয়র্ক"),
        ("40.63316", "-74.13653", "পোর্ট রিচমন্ড", "US", "আমেরিকা/নিউইয়র্ক"),
        ("41.0051", "-73.78458", "স্কারসডেল", "US", "আমেরিকা/নিউইয়র্ক"),
        ("43.1009", "-75.23266", "ইউটিকা", "US", "আমেরিকা/নিউইয়র্ক"),
        ("40.93121", "-73.89875", "ইয়ঙ্কার্স", "US", "আমেরিকা/নিউইয়র্ক"),
        ("41.55838", "-81.56929", "কলিনউড", "US", "আমেরিকা/নিউইয়র্ক"),
        ("41.48199", "-81.79819", "লেকউড", "US", "আমেরিকা/নিউইয়র্ক"),
        ("41.24255", "-82.61573", "নরওয়াক", "US", "আমেরিকা/নিউইয়র্ক"),
        ("41.66394", "-83.55521", "টোলেডো", "US", "আমেরিকা/নিউইয়র্ক"),
        ("40.2737", "-76.88442", "হ্যারিসবার্গ", "US", "আমেরিকা/নিউইয়র্ক"),
        ("40.24537", "-75.64963", "পটসটাউন", "US", "আমেরিকা/নিউইয়র্ক"),
        ("41.54566", "-71.29144", "মিডলটাউন", "US", "আমেরিকা/নিউইয়র্ক"),
        ("43.61062", "-72.97261", "রাটল্যান্ড", "US", "আমেরিকা/নিউইয়র্ক"),
        ("44.27804", "-88.27205", "কাউকাউনা", "US", "আমেরিকা/শিকাগো"),
        ("42.55308", "-87.93341", "প্লিজেন্ট প্রেইরি", "US", "আমেরিকা/শিকাগো"),
        ("41.16704", "-73.20483", "ব্রিজপোর্ট", "US", "আমেরিকা/নিউইয়র্ক"),
        ("33.35283", "-111.78903", "গিলবার্ট", "US", "আমেরিকা/ফিনিক্স"),
        ("33.50921", "-111.89903", "স্কটসডেল", "US", "আমেরিকা/ফিনিক্স"),
        ("38.17492", "-122.2608", "আমেরিকান ক্যানিয়ন", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("33.92946", "-116.97725", "বিউমন্ট", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("34.21639", "-119.0376", "ক্যামারিলো", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("34.09668", "-117.71978", "ক্লেরমন্ট", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("38.54491", "-121.74052", "ডেভিস", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("33.03699", "-117.29198", "এনসিনিটাস", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("34.14251", "-118.25508", "গ্লেনডেল", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("33.7207", "-116.21677", "ইন্দিও", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("33.52253", "-117.70755", "লাগুনা নিগুয়েল", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("34.63915", "-120.45794", "লোমপোক", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("32.9156", "-117.14392", "মীরা মেসা", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("33.93113", "-117.54866", "নরকো", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("33.72255", "-116.37697", "পাম মরুভূমি", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("36.06523", "-119.01677", "পোর্টারভিল", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("37.73604", "-120.93549", "নদীর তীর", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("34.09611", "-118.10583", "সান গ্যাব্রিয়েল", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("34.95303", "-120.43572", "সান্তা মারিয়া", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("33.95015", "-118.03917", "সাউথ হুইটিয়ার", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("33.76446", "-117.79394", "উত্তর তুস্টিন", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("36.91023", "-121.75689", "ওয়াটসনভিল", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("39.72943", "-104.83192", "অরোরা", "US", "আমেরিকা/ডেনভার"),
        ("39.57582", "-105.11221", "কেন ক্যারিল", "US", "আমেরিকা/ডেনভার"),
        ("32.42067", "-104.22884", "কার্লসব্যাড", "US", "আমেরিকা/ডেনভার"),
        ("36.20829", "-115.98391", "পাহারাম্প", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("31.84568", "-102.36764", "ওডেসা", "US", "আমেরিকা/শিকাগো"),
        ("40.58654", "-122.39168", "রেডিং", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("43.54072", "-116.56346", "নাম্পা", "US", "আমেরিকা/বোইস"),
        ("45.49428", "-122.86705", "আলোহা", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("44.99012", "-123.02621", "কেইজার", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("45.53929", "-122.38731", "ট্রাউটডেল", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("40.65995", "-111.99633", "কার্নস", "US", "আমেরিকা/ডেনভার"),
        ("40.34912", "-111.90466", "সারাতোগা স্প্রিংস", "US", "আমেরিকা/ডেনভার"),
        ("47.76232", "-122.2054", "বোথেল", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("47.38093", "-122.23484", "কেন্ট", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("47.64995", "-117.23991", "সুযোগ", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("46.32374", "-120.00865", "রৌদ্রজ্জল দিক", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("20.88953", "-156.47432", "কাহুলুই", "US", "প্যাসিফিক/হনোলুলু"),
        ("40.81", "-73.9625", "মর্নিংসাইড হাইটস", "US", "আমেরিকা/নিউইয়র্ক"),
        ("43.16547", "-77.70066", "গেটস-উত্তর গেটস", "US", "আমেরিকা/নিউইয়র্ক"),
        ("47.4943", "-122.24092", "ব্রাইন মাওর-স্কাইওয়ে", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("47.80527", "-122.24064", "বোথেল ওয়েস্ট", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("37.71715", "-122.40433", "ভিজিটাসিয়ন ভ্যালি", "US", "আমেরিকা/লস_এঞ্জেলেস"),
        ("-33.38056", "-56.52361", "ডুরাজনো", "UY", "আমেরিকা/মন্টেভিডিও"),
        ("41.29444", "69.67639", "পার্কেন্ট", "UZ", "এশিয়া/তাসখন্দ"),
        ("40.11583", "67.84222", "জিজাক্স", "UZ", "এশিয়া/সমরকন্দ"),
        ("40.78206", "72.34424", "অ্যান্ডিজন", "UZ", "এশিয়া/তাসখন্দ"),
        ("9.91861", "-68.30472", "টিনাকুইলো", "VE", "আমেরিকা/কারাকাস"),
        ("10.22677", "-67.33122", "লা ভিক্টোরিয়া", "VE", "আমেরিকা/কারাকাস"),
        ("8.35122", "-62.64102", "সিউদাদ গায়ানা", "VE", "আমেরিকা/কারাকাস"),
        ("8.62261", "-70.20749", "বারিনাস", "VE", "আমেরিকা/কারাকাস"),
        ("10.29085", "105.75635", "সা ডিসেম্বর", "VN", "এশিয়া/হো_চি_মিন"),
        ("-17.73648", "168.31366", "পোর্ট-ভিলা", "VU", "প্যাসিফিক/ইফেট"),
        ("42.62833", "20.89389", "গ্লোগোভাক", "XK", "ইউরোপ/বেলগ্রেড"),
        ("14.53767", "46.83187", "আতক", "YE", "এশিয়া/এডেন"),
        ("-27.76952", "30.79165", "ভাইহাইড", "ZA", "আফ্রিকা/জোহানেসবার্গ"),
        ("-26.93366", "29.24152", "স্ট্যান্ডারটন", "ZA", "আফ্রিকা/জোহানেসবার্গ"),
        ("-24.19436", "29.00974", "মোকোপানে", "ZA", "আফ্রিকা/জোহানেসবার্গ"),
    )

    def local_latlng(self, country_code: str = "BD", coords_only: bool = False) -> Optional[Tuple[str, ...]]:
        """Set Bangladesh BD as country code."""
        return super(self.__class__, self).local_latlng(country_code=country_code, coords_only=coords_only)
