from .. import Provider as BaseProvider

"""
Data is provided by the official list of professions from
National institue for statistics
* http://dissemination.bhas.ba/classifications/kzbih.aspx?l=h
"""


class Provider(BaseProvider):
    jobs = [
        "Аdministrаtivni pоmоćnik u mеdicinskој оrdinаciјi",
        "Administrativni službenik",
        "Administrator",
        "Administrator baza podataka",
        "Administrator obrade podataka",
        "Administrator područne računarske mreže",
        "Advokat",
        "Aerodromski transportni radnik",
        "Agent za kulturne priredbe",
        "Agent za literaturu",
        "Agent za muzičke priredbe",
        "Agent za pozorišne priredbe",
        "Agent za propagandu",
        "Agent za sport",
        "Agroekonomista",
        "Agronom kunićarstva",
        "Agronom pčelarstva",
        "Agronom peradarstva",
        "Agronom ribarstva",
        "Agronom savjetodavne službe",
        "Agronom stočarstva",
        "Agronom za hortikulturu",
        "Agronom za melioracije",
        "Agronom za proizvodnju duhana",
        "Agronom za ratarstvo",
        "Agronom za vinogradarstvo",
        "Agronom za voćarstvo",
        "Agronom za vrtlarstvo",
        "Agronom za zaštitu bilja",
        "Ahrimandit",
        "Akademski grafički dizajner",
        "Aktuar",
        "Аkupunktоrоlоg",
        "Akustički izolater",
        "Akviziter",
        "Alatničar",
        "Alatničar za metalne kalupe,specijalizirani",
        "Alatničar za mjerne pribore,specijalizirani",
        "Alatničar za rezane alate,specijalizirani",
        "Alatničar za stezne pribore,specijalizirani",
        "Alatničar,majstor",
        "Alatničarski poslovođa",
        "Alpinistički vodič",
        "Ambasador",
        "Analitičar istraživanja tržišta",
        "Аnаlitičаr pоlitika organizacije",
        "Analitičar sistema",
        "Analitičar sistema inženjersko-naučnih procesa",
        "Analitičar sistema poslovnih procesa",
        "Analitičar sistema sa računarske mreže",
        "Analitičar studija rada i vremena",
        "Analitičar zanimanja",
        "Anatom",
        "Andragog",
        "Animator",
        "Аnkеtаr u istrаživаnju tržištа",
        "Аnkеtаr u istrаživаnju јаvnоg mnjеnjа",
        "Antikvar",
        "Antropolog",
        "Aranžer",
        "Aranžer muzike",
        "Arheolog",
        "Arhitekt dizajner",
        "Arhitekt istraživač",
        "Arhitekt konzervator",
        "Arhitekt samostalni istraživač",
        "Arhivar",
        "Arhivist",
        "Arhivski službenik",
        "Arhivski službenik filmoteke",
        "Armirač",
        "Armirač i betonirac",
        "Armirač i betonirac,majstor",
        "Armirač, specijalizirani",
        "Armirački radnik",
        "Artist",
        "Artist dreser",
        "Asfalter",
        "Asfalter,specijalizirani",
        "Asistent folklornog koreografa",
        "Asistent u osiguranju",
        "Asistent visoke škole biotehničkih nauka",
        "Asistent visoke škole društveno-humanističkih nauka",
        "Asistent visoke škole medicinskih nauka",
        "Asistent visoke škole prirodnih nauka",
        "Asistent visoke škole tehničkih nauka",
        "Asistent visoke škole u teologiji",
        "Astrolog",
        "Astronom",
        "Astronomski tehničar",
        "Ataše",
        "Aukcionar",
        "Autoelektričar",
        "Autoelektričar, majstor",
        "Autolakirer",
        "Autolakirerski poslovođa",
        "Autolimar",
        "Autolimar,majstor",
        "Automehaničar",
        "Automehaničar, majstor",
        "Aviolimar",
        "Aviolimar,specijalizirani",
        "Aviomehaničar",
        "Babica",
        "Bačvar",
        "Bačvar,majstor",
        "Bakroštamper",
        "Bakteriolog",
        "Bakteriološki tehničar",
        "Balanser letilica",
        "Baletni pedagog",
        "Baletni plesač",
        "Baletni solista",
        "Balzamer",
        "Bankovni službenik",
        "Bankovni službenik na šalteru",
        "Barmen",
        "Batler",
        "Berač ljekovitog bilja",
        "Berač poljoprivrednih proizvoda",
        "Berač šumskih plodova",
        "Betonirac",
        "Betonirac, specijalizirani",
        "Bibliotečki istraživač",
        "Bibliotekar",
        "Bibliotekar specijalist",
        "Bibliotekarski službenik",
        "Bibliоtеčki tеhničаr",
        "Biletar",
        "Bioenergetičar",
        "Biofizičar",
        "Biograf",
        "Biohemičar",
        "Biohemijski tehničar",
        "Biolog",
        "Biološki tehničar",
        "Biskup",
        "Bižuterist",
        "Blagajnik",
        "Blagajnik na pošti",
        "Blagajnik u banci",
        "Blagajnik u trgovini",
        "Blanjač metala",
        "Bojadiser drvenih proizvoda",
        "Bolničar",
        "Botaničar",
        "Botanički tehničar",
        "Bravar",
        "Bravar,majstor",
        "Brigadir",
        "Brigadni general",
        "Brijač",
        "Brodarski brokerski službenik",
        "Brodobravar",
        "Brodobravar,specijalizirani",
        "Brodocjevar",
        "Brodograđevinski inženjer",
        "Brodograđevni tehničar",
        "Brodolimar",
        "Brodolimar,specijalizirani",
        "Brodomonter",
        "Brodomonter ,specijalizirani",
        "Brodoskelar",
        "Brodostolar",
        "Brodostrojar",
        "Brodostrojarski inženjer pomorskog prometa",
        "Brodotraser",
        "Brodotraser,specijalizirani",
        "Brodovođa unutarnje plovidbe",
        "Brodski elektromehaničar",
        "Brodski elektromehaničar,specijalizirani",
        "Brodski mazač",
        "Brodski motorist",
        "Brojač novca",
        "Brusač i moler konstrukcija",
        "Brusač kristalnog stakla",
        "Brusač kristalnog stakla,specijalizirani",
        "Brusač metala",
        "Bula",
        "Buregdžija",
        "Bušač i dubinski bušač",
        "Bušač na površinskom kopu",
        "Bаkаlin",
        "Carinik",
        "Carinski inspektor",
        "Carinski službenik",
        "Cerader",
        "Cestarski radnik",
        "Citolog",
        "Cjevar",
        "Crkveni muzičar",
        "Crkveni vratar",
        "Crkvenjak",
        "Crtač dezena na staklu,keramici i sl.",
        "Crtač, netehnički",
        "Cvjećar",
        "Cvjećar - aranžer",
        "Cvjećarski poslovođa",
        "Časna sestra",
        "Četkar",
        "Čipkar",
        "Čipkar ručni",
        "Čistač fasade",
        "Čistač obuće",
        "Čistač stroja",
        "Čistač ulica",
        "Čistačica prostorija",
        "Čistačica u domaćinstvu",
        "Čistačica vozila",
        "Čistаč tеpihа",
        "Član /delegat - poslanik doma parlamenta / skupštine entiteta",
        "Član nadzornog savjeta preduzeća",
        "Član predsjedništva BiH",
        "Član Predstavničkog doma Parlamentarne skupštine BiH",
        "Član uprave preduzeća",
        "Član Upravnog odbora Centralne banke BiH",
        "Član upravnog odbora preduzeća",
        "Čuvar",
        "Čuvar cestovnog prelaza",
        "Čuvar mosta",
        "Čuvar ophodar",
        "Čuvar plaže",
        "Čuvar prtljaga",
        "Čuvar pruge",
        "Čuvar ribnjaka",
        "Čuvar skretnica",
        "Čuvar staja",
        "Čuvar šume, lugar",
        "Čuvar tunela",
        "Čuvar usporene vožnje",
        "Čuvar životinja (u ZOO-vrtu,štenarama, rezervatima)",
        "Ćevabdžija",
        "Ćilimar",
        "Dadilja",
        "Daktilograf",
        "Daktilograf - administrativni tehničar",
        "Defektolog",
        "Defektolog logoped",
        "Defektolog surdoaudiolog",
        "Dekan",
        "Dekorater",
        "Dekorater emajlom",
        "Dekorater keramike",
        "Dekorater stakla",
        "Dekorativni slikar",
        "Delegat Doma naroda Parlamentarne skupštine BiH",
        "Deminer",
        "Demograf",
        "Demonstrator za prodaju",
        "Deratizer",
        "Detektiv",
        "Devizni inspektor",
        "Dezinfektor",
        "Dezinsektor",
        "Dijagnostičar kvarova na vozilima, specijalizirani",
        "Dijetni kuhar",
        "Dimnjačar",
        "Dimnjačarski poslovođa",
        "Direktor Agencije za bankarstvo",
        "Direktor Agencije za privatizaciju",
        "Direktor arhiva",
        "Direktor banke",
        "Direktor biblioteke",
        "Direktor bolnice",
        "Direktor botaničkog vrta",
        "Direktor dijela preduzeća za proizvodnju termoelektrične energije",
        "Direktor direkcije",
        "Direktor distribucije",
        "Direktor doma penzionera",
        "Direktor doma zdravlja",
        "Direktor finansija i računovodstva",
        "Direktor gerijatrijskog centra",
        "Direktor hotelskoga poslovanja",
        "Direktor inspektorata",
        "Direktor internog glasila",
        "Direktor izvanteritorijalne organizacije",
        "Direktor kampa",
        "Direktor kazneno - popravnog zavoda",
        "Direktor kliničkog centra",
        "Direktor klinike",
        "Direktor komercijalne službe",
        "Direktor konferencijskog centra",
        "Direktor kontrole",
        "Direktor male izvanteritorijalne organizacije",
        "Direktor male kafane",
        "Direktor male mjenjačnice",
        "Direktor male modne agencije",
        "Direktor male obrazovne ustanove",
        "Direktor male trgovine na malo",
        "Direktor male trgovine na veliko",
        "Direktor male ustanove socijalnog rada",
        "Direktor male ustanove za kulturu",
        "Direktor male ustanove za sport i rekreaciju",
        "Direktor male zdravstvene ustanove",
        "Direktor malog disko-bara",
        "Direktor malog građevinskog preduzeća",
        "Direktor malog hotela",
        "Direktor malog kampa",
        "Direktor malog lovišta",
        "Direktor malog lovno-uzgojnog preduzeća",
        "Direktor malog noćnog bara",
        "Direktor malog odmarališta",
        "Direktor malog poljoprivrednog preduzeća",
        "Direktor malog povrtlarskog preduzeća",
        "Direktor malog preduzeća za poslovne usluge",
        "Direktor malog preduzeća i ustanove na drugom mjestu nespomenut",
        "Direktor malog preduzeća za dizajniranje",
        "Direktor malog preduzeća za finansijske poslove",
        "Direktor malog preduzeća za ispitivanje javnog mijenja",
        "Direktor malog preduzeća za iznajmljivanje soba i kuća",
        "Direktor malog preduzeća za lične usluge",
        "Direktor malog preduzeća za poljoprivredne radove",
        "Direktor malog preduzeća za posredovanje nekretninama",
        "Direktor malog preduzeća za pranje i čišćenje",
        "Direktor malog preduzeća za prevoz opasnih materija",
        "Direktor malog preduzeća za računarske usluge",
        "Direktor malog preduzeća za računovodstvene poslove",
        "Direktor malog preduzeća za računovodstveno-finansijske poslove",
        "Direktor malog preduzeća za tehničko ispitivanje i analize",
        "Direktor malog preduzeća za usluge putničkih agencija",
        "Direktor malog preduzeća za usluge turističkih agencija",
        "Direktor malog prevoznog preduzeća",
        "Direktor malog proizvodnog preduzeća",
        "Direktor malog projektnog ureda",
        "Direktor malog rasadnika",
        "Direktor malog restorana",
        "Direktor malog ribarskog preduzeća",
        "Direktor malog skladišta",
        "Direktor malog špediterskog preduzeća",
        "Direktor malog šumarskog preduzeća",
        "Direktor malog šumarskog rasadnika",
        "Direktor malog telekomunikacionog preduzeća",
        "Direktor malog veterinarskog društva",
        "Direktor marketinga",
        "Direktor međunarodnog putničkog saobaraćaja u preduzećima",
        "Direktor međunarodnog teretnoga saobraćaja u preduzećima",
        "Direktor muzeja",
        "Direktor nabave",
        "Direktor nacionalnog parka",
        "Direktor naučno-istraživačkog instituta",
        "Direktor odjela za računarske usluge",
        "Direktor organizacije u oblasti kulture",
        "Direktor osnovne škole",
        "Direktor područne službe",
        "Direktor područne službe za socijalni rad",
        "Direktor policijske uprave",
        "Direktor popravne ustanove",
        "Direktor poslova uspostave informacionog sistema",
        "Direktor poslovanja za područje hrane i pića u hotelima i restoranima",
        "Direktor poslovanja izdavačkog preduzeća",
        "Direktor poslovanja osiguravajućega društva",
        "Direktor poslovanja pogrebnoga preduzeća",
        "Direktor poslovanja preduzeća komunalne čistoće",
        "Direktor poslovanja preduzeća lične usluge",
        "Direktor poslovanja preduzeća za cjevovodni transport",
        "Direktor poslovanja preduzeća za drumski saobraćaj",
        "Direktor poslovanja preduzeća za filmsku i video djelatnost",
        "Direktor poslovanja preduzeća za finansijsko posredovanje",
        "Direktor poslovanja preduzeća za intelektualne usluge",
        "Direktor poslovanja preduzeća za istraživanje i razvoj",
        "Direktor poslovanja preduzeća za iznajmljivanje",
        "Direktor poslovanja preduzeća za nespomenute poslovne usluge",
        "Direktor poslovanja preduzeća za ostale usluge u saobraćaju",
        "Direktor poslovanja preduzeća za poslovanje nekretninama",
        "Direktor poslovanja preduzeća za posredničke poslove",
        "Direktor poslovanja preduzeća za promet nekretninama",
        "Direktor poslovanja preduzeća za smještaj gostiju",
        "Direktor poslovanja preduzeća za uklanjanje otpadnih voda",
        "Direktor poslovanja preduzeća za vazdušni saobraćaj",
        "Direktor poslovanja privatnih agencija i fondova",
        "Direktor poslovanja putničke i turističke agencije",
        "Direktor poslovanja skladišta",
        "Direktor poslovanja špediterskog preduzeća",
        "Direktor poslovanja ugostiteljskoga preduzeća",
        "Direktor poslovanja ustanove za kulturu",
        "Direktor poslovanja veterinarske ustanove",
        "Direktor poslovanja zdravstvene ustanove",
        "Direktor poslovanja željezničkog saobraćaja",
        "Direktor poslovne jedinice trgovine na malo",
        "Direktor poslovne jedinice trgovine na veliko",
        "Direktor poslovne jedinice za održavanje i popravku motornih vozila",
        "Direktor poslovne jedinice za popravku proizvoda široke potrošnje",
        "Direktor pošta",
        "Direktor pravne, kadrovske i opće službe",
        "Direktor predškolske ustanove",
        "Direktor pretovarne operative",
        "Direktor prihvata i otpreme na aerodromu",
        "Direktor prijevoza opasnih materija u preduzeću",
        "Direktor prijevoza u brodarskom preduzeću",
        "Direktor prodaje",
        "Direktor prodajne promocije",
        "Direktor proizvodne i operativne jedinice građevinskog preduzeća",
        "Direktor proizvodne i operativne jedinice preduzeća u prerađivačkoj djelatnosti",
        "Direktor proizvodne i operativne jedinice preduzeća u proizvodnji termoelektrične energije",
        "Direktor proizvodne i operativne jedinice preduzeća u rudarstvu",
        "Direktor proizvodne i operativne jedinice preduzeća za snabdjevanje el. energijom, gasom i vodom ",
        "Direktor proizvodnje i poslovanja lovno-uzgojnog preduzeća",
        "Direktor proizvodnje i poslovanja šumarskog preduzeća",
        "Direktor proizvodnje poljoprivrednog preduzeća",
        "Direktor proizvodnje ribarskog preduzeća",
        "Direktor putničke agencije",
        "Direktor razvojno-istraživačke službe",
        "Direktor rekreacionog centra",
        "Direktor restoranskog poslovanja",
        "Direktor revizije za poslovanje banaka i finansijskih organizacija",
        "Direktor revizije za poslovanje poduzetnika",
        "Direktor saobraćaja autobuske stanice",
        "Direktor sektora banke",
        "Direktor skladišne službe",
        "Direktor službe drugdje nerazvrstan",
        "Direktor službe obezbjeđenja",
        "Direktor službe za odnose s javnošću",
        "Direktor službe za oglašavanje",
        "Direktor službe za pomoć porodicama",
        "Direktor službe za računarske usluge",
        "Direktor sportskog objekta",
        "Direktor srednje škole",
        "Direktor staračkog doma",
        "Direktor telekomunikacija",
        "Direktor tržnog centra",
        "Direktor umjetničke galerije",
        "Direktor unutrašnje finansijske kontrole",
        "Direktor uprave",
        "Direktor upravne organizacije",
        "Direktor upravnog organa u sastavu ministarstva",
        "Direktor ustanove socijalnog rada",
        "Direktor ustanove za brigu o djeci",
        "Direktor ustanove za pružanje pravne pomoći",
        "Direktor ustanove za smještaj iz okvira socijalne zaštite",
        "Direktor visoke škole",
        "Direktor za ekološke poslove",
        "Direktor za organizaciju rada",
        "Direktor za socijalno osiguranje",
        "Direktor zaštite okoline i sigurnosti na radu",
        "Direktor Zavoda za računovodstvo i reviziju",
        "Direktor Zavoda za reviziju",
        "Direktor Zavoda/Agencija za zapošljavanje",
        "Direktor zoološkog vrta",
        "Dirigent hora",
        "Dirigent orkestra",
        "Disko džokej",
        "Dispečer transportnog gasnog sistema, specijalizirani",
        "Dizajner",
        "Dizajner ambalaže",
        "Dizajner interijera",
        "Dizajner keramike",
        "Dizajner kože",
        "Dizajner obuće i kožne galanterije",
        "Dizajner stakla",
        "Dizajner tekstila i odjeće",
        "Doktor dječije i preventivne stomatologije",
        "Doktor farmacije",
        "Doktor farmacije specijalizant",
        "Doktor farmacije stažist",
        "Doktor fizikalne medicine i rehabilitacije",
        "Doktor javnog zdravstva",
        "Doktor medicine",
        "Doktor medicine anesteziolog i reanimatolog",
        "Doktor medicine citolog",
        "Doktor medicine dermatolog",
        "Doktor medicine dermatolog i venerolog",
        "Doktor medicine dječji hirurg",
        "Doktor medicine epidemiolog",
        "Doktor medicine ginekolog i opstetričar",
        "Doktor medicine infektolog",
        "Doktor medicine internista",
        "Doktor medicine klinički farmakolog",
        "Doktor medicine klinički farmakolog i toksikolog",
        "Doktor medicine maksilofacijalni hirurg",
        "Doktor medicine neurohirurg",
        "Doktor medicine neurolog",
        "Doktor medicine neuropsihijatar",
        "Doktor medicine oftalmolog",
        "Doktor medicine opšti hirurg",
        "Doktor medicine ortoped",
        "Doktor medicine otorinolaringolog",
        "Doktor medicine patološki anatom",
        "Doktor medicine pedijatar",
        "Doktor medicine plastični i rekonstruktivni hirurg",
        "Doktor medicine pneumoftizeolog",
        "Doktor medicine psihijatar",
        "Doktor medicine rada",
        "Doktor medicine radiolog",
        "Doktor medicine radioterapeut",
        "Doktor medicine radioterapeut i onkolog",
        "Doktor medicine rentgenolog",
        "Doktor medicine specijalizant",
        "Doktor medicine stažista",
        "Doktor medicine transfuziolog",
        "Doktor medicine urolog",
        "Doktor medicine zdravstveni ekolog",
        "Doktor medicine-specijalista higijene",
        "Doktor medicinske mikrobiologije s parazitologijom",
        "Doktor nuklearne medicine",
        "Doktor opće medicine",
        "Doktor porodične medicine",
        "Doktor porodične stomatologije",
        "Doktor socijalne medicine",
        "Doktor stomatologije",
        "Doktor stomatologije dentalni i oralni patolog i parodontolog",
        "Doktor stomatologije dentalni patolog i endodont",
        "Doktor stomatologije oralni hirurg",
        "Doktor stomatologije oralni patolog",
        "Doktor stomatologije ortodont",
        "Doktor stomatologije parodontolog",
        "Doktor stomatologije protetičar",
        "Doktor stomatologije specijalizant",
        "Doktor stomatologije stažist",
        "Doktor sudske medicine",
        "Doktor školske medicine",
        "Dokumentalist",
        "Domaćin kluba",
        "Domar kampa",
        "Domar planinarskog doma",
        "Dostavljač",
        "Draguljar",
        "Dramaturg",
        "Dreser pasa",
        "Druga zanimanja - mehaničari i mašinisti",
        "Drugi oficir palube",
        "Drugi oficir stroja",
        "Drvodjelja",
        "Drvogalanterist",
        "Drvomodelar",
        "Drvorezbar",
        "Drvorezbar,specijalizirani",
        "Drvotokar",
        "Drvotokar,majstor",
        "Državni odvjetnik",
        "Đakon",
        "Edukator-rehabilitolog",
        "Eko higijeničar",
        "Ekolog",
        "Ekološki tehničar",
        "Ekološko-sanitarni inženjer",
        "Ekonom",
        "Ekonom uredski",
        "Ekonometrik",
        "Ekonomista",
        "Ekonomista bankarstva",
        "Ekonomista hoteljerstva",
        "Ekonomista investicijski savjetnik",
        "Ekonomista kontrolor poslovanja",
        "Ekonomista kreditno-garantnih poslova",
        "Ekonomista menadžmenta",
        "Ekonomista osiguranja",
        "Ekonomista platnog prometa",
        "Ekonomista savjetnik",
        "Ekonomista turizmolog",
        "Ekonomista vanjsko - trgovinskog smjera",
        "Ekonomista za analize i planiranje",
        "Ekonomista za carinske poslove",
        "Ekonomista za devizno poslovanje",
        "Ekonomista za finansije",
        "Ekonomista za marketing",
        "Ekonomista za međunarodnu razmjenu",
        "Ekonomista za politiku cijena",
        "Ekonomista za poreski sistem",
        "Ekonomista za poslovanje s vrijednosnim papirima",
        "Ekonomista za turizam i ugostiteljstvo",
        "Ekonomski službenik",
        "Ekonomski tehničar",
        "Električar održavanja",
        "Električar pozornice i studija",
        "Električar pozornice i studija,specijalizirani",
        "Elektroenergetičar, majstor",
        "Elektroenergetski inspektor",
        "Elektroenergetski tehničar",
        "Elektroinstalater",
        "Elektroinstalater telekomunikacijskih vodova i instalacija",
        "Elektroinstalater za priključke i instalacije",
        "Elektroinstalater,specijalizirani",
        "Elektroinženjer za automatiku",
        "Elektroinženjer za automatizaciju u elektroenergetici",
        "Elektroinženjer za automatizaciju u industriji",
        "Elektroinženjer za automatizaciju u transportu",
        "Elektroinženjer za automatsko upravljanje tehničkim sistemima",
        "Elektroinženjer za elektrane",
        "Elektroinženjer za električnu vuču",
        "Elektroinženjer za mjerenja i instrumentaciju",
        "Elektroinženjer za plovna sredstva",
        "Elektroinženjer za procesna mjerenja",
        "Elektroinženjer za vađenje pokretnih objekata",
        "Elektrolizer aluminijuma",
        "Elektromašinski tehničar",
        "Elektromehaničar",
        "Elektromehaničar aparata za domaćinstvo",
        "Elektromehaničar aparata za domaćinstvo,majstor",
        "Elektromehaničar proizvodnih mašina",
        "Elektromehaničar proizvodnih mašina,specijalizirani",
        "Elektromehaničar za elektroenergetiku",
        "Elektromehaničar za elektroenergetiku,specijalizirani",
        "Elektromehaničar za elektroenergetska postrojenja",
        "Elektromehaničar za mjerne instrumente i sklopove",
        "Elektromehaničar za mjerne instrumente i sklopove,specijalizirani",
        "Elektromehaničar za željezničku elektroenergetiku,specijalizirani",
        "Elektromehaničar za željezničku elektroenergitiku",
        "Elektromehaničar željezničke vuče i vozila",
        "Elektromehaničar željezničke vuče i vozila,specijalizirani",
        "Elektromonter",
        "Elektromonter dizala",
        "Elektromonter energetskih mašina i uređaja",
        "Elektromonter energetskih mašina i uređaja,specijalizirani",
        "Elektromonter za visoki napon",
        "Elektronamotač",
        "Elektronamotač,specijalizirani",
        "Elektroničar telekomunikacionih uređaja, majstor",
        "Elektroničar za AOP",
        "Elektroničar za telekomunikacije",
        "Elektrorudarski inspektor",
        "Elektrotehničar",
        "Elektrotehničar proizvoda za domaćinstvo",
        "Elektrotehničar šinskih vozila i postrojenja",
        "Elektrotehničar za distribuciju električne energije",
        "Elektrotehničar za dizala i transportna sredstva",
        "Elektrotehničar za električne mašine, aparate i uređaje",
        "Elektrotehničar za elektromotore",
        "Elektrotehničar za instalacije i opremu",
        "Elektrotehničar za mjerne instrumente i sklopove",
        "Elektrotehničar za opremu proizvodnih mašina",
        "Elektrotehničar za plovna sredstva",
        "Elektrotehničar za prijenos električne energije",
        "Elektrotehničar za procesnu tehniku",
        "Elektrotehničar za proizvodnju električne energije",
        "Elektrotehničar za slabu i jaku struju",
        "Elektrotehničar za željeznicu",
        "Elektrotiper",
        "Elektrozavarivač",
        "Elektrozavarivač, specijalizirani",
        "Embriolog",
        "Endokrinolog",
        "Epidemiolog",
        "Episkop",
        "Esejist",
        "Etnogeograf",
        "Etnolog",
        "Evangelista",
        "Evidentičar normativa",
        "Evidentičar radnih lista",
        "Evidentičari u proizvodnji",
        "Fakturista",
        "Farmaceut",
        "Farmaceut farmakoinformatičar",
        "Farmaceut na ispitivanju i kontroli lijekova",
        "Farmaceut u industriji",
        "Farmaceut u veleprodaji",
        "Farmaceut za ljekovito bilje",
        "Farmaceutski laborant",
        "Farmaceutski tehničar",
        "Farmakolog",
        "Farmakološki tehničar",
        "Fasader",
        "Fasader,majstor",
        "Figurant",
        "Filigranist",
        "Filmski i elektronski montažer",
        "Filmski laborant",
        "Filolog",
        "Filolog istraživač",
        "Filolog samostalni istraživač",
        "Filosanitarni inspektor",
        "Filozof",
        "Finansijski administrator",
        "Finansijski analitičar",
        "Finansijski inspektor",
        "Finansijski knjigovođa",
        "Finansijski savjetnik",
        "Finomehaničar",
        "Finomehaničar,majstor",
        "Fitosanitarni inspektor",
        "Fizičar",
        "Fizičar istraživač",
        "Fizičar samostalni istraživač",
        "Fiziolog",
        "Fizioterapeut",
        "Fizioterapeutski tehničar",
        "Fleksografski štampar",
        "Folklorni igrač",
        "Folklorni muzičar",
        "Fonetičar",
        "Fonotekar",
        "Fotograf",
        "Fotograf za komercijalne ilustracije",
        "Fotograf,majstor",
        "Fotografski tehničar",
        "Fotogrametar",
        "Fotograver",
        "Fotolaborant",
        "Fotomodel",
        "Fotoreporter",
        "Fratar",
        "Frizer - Vlasuljar",
        "Frizer - Vlasuljar, majstor",
        "Frizer za muškarce",
        "Frizer za muškarce, majstor",
        "Frizer za žene",
        "Frizer za muškarce i žene",
        "Frizer za žene, majstor",
        "Galerijski vodič",
        "Galvanizer",
        "Galvanizer,specijalizirani",
        "Garderober",
        "Gatara",
        "Generalmajor",
        "Generalni direktor",
        "Generalni revizor Ureda za reviziju institucija u FBIH",
        "Generalni sekretar Narodne skupštine",
        "Generalni sekretar Vlade",
        "Generalpukovnik",
        "Genetičar",
        "Geodet hidrograf",
        "Geodet topograf",
        "Geodeta fotogrametar",
        "Geodeta kartograf",
        "Geodeta projektant fotogrametrijskih radova",
        "Geodeta projektant osnovnih geodetskih radova",
        "Geodeta projektant u oblasti kartografije",
        "Geodeta projektant za inženjersku geodeziju",
        "Geodeta projektant za zemljišno informacione sisteme",
        "Geodeta za inženjersku geodeziju",
        "Geodeta za osnovne radove",
        "Geodeta za rudnike",
        "Geodeta za zemljišno informacione sisteme",
        "Geodetski projektant",
        "Geodetski tehničar",
        "Geodetski tehničar geometar",
        "Geodetski tehničar hidrografije",
        "Geodetski tehničar restitutor",
        "Geodetski tehničar za elaborate",
        "Geodetski tehničar za evidenciju državnog vlasništva",
        "Geodetski tehničar za evidenciju prostornih jedinica",
        "Geodetski tehničar za fotogrametriju",
        "Geodetski tehničar za katastar",
        "Geodetski tehničar za katastar vodova",
        "Geofizički tehničar",
        "Geograf",
        "Geolog istraživač",
        "Geolog samostalni istraživač",
        "Geolog za geomehaniku",
        "Geolog za geotermiku",
        "Geolog za hidrologiju",
        "Geolog za inženjerisku geologiju",
        "Geolog za istraživanje metalnih i nemetalnih sirovina",
        "Geolog za obradu podataka",
        "Geolog za paleontologiju",
        "Geolog za petrografiju",
        "Geolog za sedimentologiju",
        "Geolog za stratigrafiju",
        "Geolog za tektoniku",
        "Geološki tehničar",
        "Gipsar",
        "Gipsmodelar",
        "Gipsmodelar,specijalizirani",
        "Glavni entitetski inspektor",
        "Glavni imam",
        "Glavni inspektor policije",
        "Glavni inspektor u inspektoratu RS",
        "Glavni konobar",
        "Glavni kuhar",
        "Glavni okružni tužilac",
        "Glavni planer izgradnje",
        "Glavni planer održavanja",
        "Glavni planer pripreme rada",
        "Glavni planer proizvodnje",
        "Glavni republički tužilac",
        "Glavni revizor RS",
        "Glavni tužilac BiH",
        "Glazer keramike",
        "Glumac",
        "Gorski spasilac",
        "Graditelj drvenih brodova",
        "Graditelj drvenih brodova,majstor",
        "Graditelj lakih letjelica",
        "Graditelj metalnih brodova",
        "Graditelj metalnih brodova, majstor",
        "Graditelji tradicionalnim materijalima",
        "Gradonačelnik",
        "Građevinar za održavanje pruga",
        "Građevinar za održavanje puteva",
        "Građevinar za održavanje zgrada",
        "Građevinski dekorater",
        "Građevinski inspektor",
        "Građevinski inženjer",
        "Građevinski inženjer za geotehniku",
        "Građevinski laborant",
        "Građevinski poslovođa",
        "Građevinski staklar",
        "Građevinski stolar",
        "Građevinski stolar,majstor",
        "Građevinski tehničar",
        "Građevinski tehničar izrade štamparskih formata",
        "Građevinski tehničar niskogradnje",
        "Građevinski tehničar razrađivač projekta",
        "Građevinski tehničar saobraćajni",
        "Građevinski tehničar visokogradnje",
        "Građevinski tehničar za hidrogradnju",
        "Grafičar pripremne proizvodnje,specijalizirani",
        "Grafičar slagač/monter",
        "Grafičar štamparske proizvodnje,specijalizirani",
        "Grafičar za doradu",
        "Grafičar za fotoslog i računarski slog,specijalizirani",
        "Grafičar završne proizvodnje,specijalizirani",
        "Grafički dizajner",
        "Grafički jetkač",
        "Grafički predradnik",
        "Grafički tehničar",
        "Grafički urednik",
        "Grafolog",
        "Granični policajac",
        "Graver pečatorezac",
        "Graver plemenitih metala",
        "Gravimetrijski i magnetometrijski tehničar",
        "Grobar",
        "Grupovođa elektromontera i elektromehaničara energetskih mašina",
        "Grupovođa industrijskih talioca,livaca i valjaoničara",
        "Grupovođa mehaničara i montera motornih vozila",
        "Grupovođa montera električnih i telekomunikacijskih mreža",
        "Grupovođa montera,mehaničara i servisera elektronike",
        "Grupovođa montera,mehaničara i servisera mašina",
        "Grupovođa montera,mehaničara i servisera telekomunikacijskih uređaja",
        "Grupovođa preciznih mehaničara",
        "Grupovođa rukovalaca alatnih mašina",
        "Grupovođa rukovalaca mašinama za izradu drvenih proizvoda",
        "Grupovođa rukovalaca procesnih mašina i uređaja za dobijanje metala",
        "Grupovođa staklarskih,keramičkih i sličnih procesnih mašina i uređaja",
        "Grupovođa stolara",
        "Gumar",
        "Guverner Centralne banke BiH",
        "Gvardijan",
        "Gаlеriјski tеhničаr",
        "Hafiz",
        "Hemičar",
        "Hemičar analitičar",
        "Hemičar istraživač",
        "Hemičar operator",
        "Hemičar samostalni istraživač",
        "Hemičar u farmaciji",
        "Hemičar za anorgansku hemiju",
        "Hemičar za fizikalnu hemiju",
        "Hemičar za organsku hemiju",
        "Hemijski čistač",
        "Hemijski čistač,majstor",
        "Hemijski laborant",
        "Hemijski predradnik",
        "Hemijski tehničar",
        "Hemijski tehničar analitičkih sistema",
        "Hemijski tehničar anorganskih sistema",
        "Hemijski tehničar elektrotehničkih materijala",
        "Hemijski tehničar organskih sistema",
        "Hemijski tehnolog za elektrotehničke materijale i sisteme",
        "Hemijskotehnološki tehničar",
        "Hidrobiolog",
        "Hidroizolater",
        "Hidrolog",
        "Hidrološki tehničar",
        "Hidrometeorolog",
        "Higijeničarka",
        "Hipnotizer",
        "Histolog",
        "Historičar",
        "Historičar umjetnosti",
        "Hodža",
        "Horizontalni metalobušač",
        "Horizontalni metalobušač,specijalizirani",
        "Hortikulturni tehničar",
        "Hostesa",
        "Hotelska domaćica / domaćin",
        "Hotelski nosač",
        "Hotelski poslovođa",
        "Hotelski recepcionar",
        "Hroničar",
        "Hоmеоpаtа",
        "Iguman",
        "Ilustrator",
        "Imam",
        "Imitator",
        "Impregnator drveta",
        "Impregnirač elektromehaničkih komponenti i sklopova",
        "Imunolog",
        "Industrijski kalilac",
        "Industrijski livac",
        "Industrijski obrađivač mlijeka,specijalizirani",
        "Industrijski psiholog",
        "Industrijski talilac",
        "Industrijski talilac livar",
        "Industrijski valjaoničar",
        "Industrijski žarilac",
        "Industrijski žičar",
        "Informacijski istraživač",
        "Informacijski stručnjak",
        "Informatičar",
        "Inkasant",
        "Inspektor državne uprave bliže neodređen",
        "Inspektor igara na stolovima za igru na sreću",
        "Inspektor parnih kotlova",
        "Inspektor za civilnu zaštitu",
        "Inspektor za odbranu",
        "Inspektor za požarnu sigurnost",
        "Inspektor za promet",
        "Inspektor za rad",
        "Inspektor za sigurnost ličnih podataka",
        "Inspektor za sigurnost na radu",
        "Inspicijent opere",
        "Instalater grijanja i klimatizacije",
        "Instalater vodovoda i kanalizacije",
        "Instruktor za jedrenje i plovidbu",
        "Instruktor za letenje",
        "Instruktor za zanimanje i stručno obrazovanje",
        "Instruktori za upravljanje mašinama",
        "Instrumentalist",
        "Instrumentalist (violinist)",
        "Instrumentalist solist",
        "Instrumentalni optičar",
        "Instrumentalni optičar,majstor",
        "Instrumentalni solist (klavijaturist)",
        "Intarzijski stolar",
        "Intarzijski stolar,specijalizirani",
        "Inženjer za karotažu i perforiranje naftnih bušotina",
        "Inženjer aeronautike",
        "Inženjer agronom",
        "Inženjer arhitekture",
        "Inženjer biotehnologije",
        "Inženjer brodske elektronike",
        "Inženjer drumskog saobraćaja",
        "Inženjer drvne tehnologije",
        "Inženjer elektroenergetike",
        "Inženjer elektromašinskog održavanja",
        "Inženjer elektromašinstva",
        "Inženjer elektronike",
        "Inženjer elektronike za normalizaciju i mjerenje",
        "Inženjer elektrotehnike",
        "Inženjer geodezije",
        "Inženjer geofizike",
        "Inženjer geologije",
        "Inženjer grafičke tehnologije",
        "Inženjer hemijske tehnologije",
        "Inženjer hortikulture",
        "Inženjer informacijskih tehnologija",
        "Inženjer kontrole leta",
        "Inženjer kožarstva",
        "Inženjer medicinske elektronike",
        "Inženjer medicinske radiologije",
        "Inženjer medicinsko-laboratorijske dijagnostike",
        "Inženjer metalnih materijala",
        "Inženjer metalurgije",
        "Inženjer nautike unutrašnje plovidbe",
        "Inženjer nemetalnih materijala",
        "Inženjer obućarstva",
        "Inženjer pomorske nautike",
        "Inženjer pomorskog saobraćaja",
        "Inženjer poštanskog saobraćaja",
        "Inženjer prehrambene tehnologije",
        "Inženjer prerade drveta",
        "Inženjer računarske elektronike",
        "Inženjer računarstva",
        "Inženjer radiokomunikacija",
        "Inženjer rudarstva za bušotinsku eksploataciju mineralnih sirovina",
        "Inženjer signalnosigurnosnih uređaja",
        "Inženjer sigurnosti i pomoći",
        "Inženjer sistema za opremu",
        "Inženjer sistema za personalne računare",
        "Inženjer sistema za programe",
        "Inženjer smjenski u termoelektranama",
        "Inženjer šumarstva",
        "Inženjer tekstilne tehnologije",
        "Inženjer telekomunikacija",
        "Inženjer unutrašnje plovidbe",
        "Inženjer vazduhoplovne elektronike",
        "Inženjer za električne mašine i uređaje",
        "Inženjer za elektroenergetska postrojenja",
        "Inženjer za elektroničke komponente",
        "Inženjer za elektroničke proizvode",
        "Inženjer za elektrotehničke proizvode",
        "Inženjer za geofizička mjerenja",
        "Inženjer za geofizičko istraživanje ležišta",
        "Inženjer za geološka istraživanja ležišta",
        "Inženjer za izgradnju računarskih sistema",
        "Inženjer za izradu i održavanje naftnih bušotina",
        "Inženjer za laboratorijsko ispitivanje stjena",
        "Inženjer za logistiku",
        "Inženjer za normizaciju u elektroenergetici i elektromašinstvu",
        "Inženjer za obradu geofizičkih podataka",
        "Inženjer za obradu podataka",
        "Inženjer za obradu tona i slike",
        "Inženjer za optoelektroniku",
        "Inženjer za organizaciju rada",
        "Inženjer za proizvodnju nafte i gasa",
        "Inženjer za računarsku grafiku",
        "Inženjer za radiokomunikacijske uređaje",
        "Inženjer za razradu ležišta nafte i gasa",
        "Inženjer za razvoj tehnologije transporta gasa",
        "Inženjer za telekomunikacijske uređaje i mreže",
        "Inženjer za transport nafte i gasa",
        "Inženjer za višemedijske komunikacije",
        "Inženjer za zaštitu analize",
        "Inženjer za zaštitu od električnog napona",
        "Inženjer zaštite okoliša",
        "Inženjer zračnog saobraćaja",
        "Inženjer željezničkog saobraćaja",
        "Ipođakon",
        "Ispitivač kvaliteta industrijskih procesa",
        "Ispitivač kvaliteta proizvoda",
        "Ispitivač kvaliteta usluga",
        "Istražitelj kriminalist",
        "Istražitelj kriminolog",
        "Istraživač antropolog",
        "Istraživač arheolog",
        "Istraživač arhivistike",
        "Istraživač biologije",
        "Istraživač biotehnologije",
        "Istraživač brodograđevinarstva",
        "Istraživač ekonomskih nauka",
        "Istraživač elektronike, telekomunikacija i automatike",
        "Istraživač etnolog",
        "Istraživač filozofije",
        "Istraživač geodezije",
        "Istraživač geograf",
        "Istraživač građevinarstva",
        "Istraživač grafičke tehnologije",
        "Istraživač hemijske tehnologije",
        "Istraživač historije",
        "Istraživač komunikolog",
        "Istraživač mašinstva",
        "Istraživač metalurgije",
        "Istraživač meteorologije",
        "Istraživač politologije",
        "Istraživač pravnih nauka",
        "Istraživač računarstva",
        "Istraživač rudarstva",
        "Istraživač saobraćaja",
        "Istraživač sociolog",
        "Istraživač tekstilne tehnologije",
        "Istraživač u agronomiji",
        "Istraživač u oblasti životne sredine",
        "Istraživač u šumarstvu",
        "Istraživač umjetnosti",
        "Istraživač urbanizma",
        "Istraživač vaspitnih nauka",
        "Istraživač veterine",
        "Istraživač za elektroenergetiku i elektromašinstvo",
        "Istražni sudija",
        "Iznajmljivač odjeće",
        "Iznajmljivač opreme",
        "Iznajmljivač soba",
        "Izolater",
        "Izradivac hemijskih proivoda",
        "Izradivac kožne galanterije",
        "Izrađivač alata za grafičku ambalažu",
        "Izrađivač donjih dijelova obuće",
        "Izrađivač drvene obuće",
        "Izrađivač drvene sportske opreme",
        "Izrađivač držala,štapova i sličnih predmeta",
        "Izrađivač duvačkih muzičkih instrumenata",
        "Izrađivač gornjih dijelova obuće",
        "Izrađivač gornjih dijelova ortopedske obuće",
        "Izrađivač gudačkih instrumenata",
        "Izrađivač harmonika",
        "Izrađivač hirurških instrumenata",
        "Izrađivač hirurških instrumenata,specijalizirani",
        "Izrađivač klavira",
        "Izrađivač ključeva",
        "Izrađivač kožnih proizvoda domaće radinosti",
        "Izrađivač krzna",
        "Izrađivač leća",
        "Izrađivač ljekovitih proizvoda od meda,specijalizirani",
        "Izrađivač muzičkih instrumenata",
        "Izrađivač narodnih nošnji",
        "Izrađivač okvira za slike",
        "Izrađivač orgulja",
        "Izrađivač ortopedskih pomagala",
        "Izrađivač ortopedskih pomagala,majstor",
        "Izrađivač ploče za Braillovo pismo",
        "Izrađivač posebnih koža",
        "Izrađivač posteljnih ulošaka",
        "Izrađivač predmeta domaće radinosti iz kamena",
        "Izrađivač predmeta od školjki",
        "Izrađivač sredstava za poliranje i brušenje",
        "Izrađivač svijeća",
        "Izrađivač šablona za odjeću, specijalizirani",
        "Izrađivač tambura",
        "Izrađivač tapiserija",
        "Izrađivač tekstilnih proizvoda domaće radinosti",
        "Izrađivač tradicijskih predmeta",
        "Izrađivač udaračkih mašinskih instrumenata",
        "Izrađivač ukrasa i nakita",
        "Izrezivač drvenih igračaka",
        "Izvršni direktor",
        "Izvršni sekretar u konzularnom uredu",
        "Jamski spasilac",
        "Javni notar",
        "Jerej",
        "Jeromonah",
        "Jetkač stakla",
        "Jezgrar ljevačkih kalupa",
        "Jorgandžija",
        "Juvelir",
        "Kadrovski referent",
        "Kalajdžija",
        "Kalkulant",
        "Kaluđer/kaluđerica",
        "Kamenorezac",
        "Kapetan",
        "Kapetan aviona",
        "Kaplar",
        "Kardinal",
        "Karikaturist",
        "Kartograf",
        "Kartografski crtač",
        "Kaskader",
        "Kazandžija",
        "Kemigraf",
        "Keramičar",
        "Keramičar - teracer - podopolagač",
        "Keramičar - teracer - podopolagač,majstor",
        "Kineziolog",
        "Kinooperater",
        "Kipar",
        "Kipar naivac",
        "Kišobrandžija",
        "Klesar",
        "Klesar, majstor",
        "Klesarski poslovođa",
        "Klinaš",
        "Klinički farmaceut",
        "Klinički psiholog",
        "Klovn",
        "Ključar",
        "Knjigoštampar",
        "Knjigovezac",
        "Knjigovezac mekog uveza",
        "Knjigovezac tvrdog uveza",
        "Knjigovezac za ručni uvez",
        "Knjigovezac,majstor",
        "Knjigovezački poslovođa",
        "Knjigovodstveni operator na računaru",
        "Knjigovođa",
        "Knjigovođa zaliha",
        "Književni komparatist",
        "Književnik",
        "Kobasičar",
        "Kočijaš",
        "Kočničar",
        "Kolar",
        "Kolar,majstor",
        "Komandant bataljona/bojne",
        "Komandir čete/satnije",
        "Komandir odjeljenja/desetine",
        "Komandir voda",
        "Komentator",
        "Komercijalist",
        "Komercijalist unutrašnje trgovine",
        "Komercijalist vanjske trgovine",
        "Komercijalist za domaću trgovinu",
        "Komercijalist za vanjsku trgovinu",
        "Komercijalni službenik",
        "Komesar policije",
        "Komičar",
        "Kompozitor",
        "Komunalni redar",
        "Komunikolog",
        "Koncertni majstor",
        "Konditor",
        "Kondukter",
        "Kondukter na žičari",
        "Kondukter u autobusu",
        "Kondukter u spavaćim kolima",
        "Kondukter u vozu",
        "Konfekcionar",
        "Konfekcionar tekstila - krojač",
        "Konferencijski tumač",
        "Konobar",
        "Konstruktor odjeće",
        "Konter",
        "Kontrolor mineralurških procesa i proizvoda",
        "Kontrolor drvenih proizvoda",
        "Kontrolor električnih proizvoda",
        "Kontrolor gumenih proizvoda",
        "Kontrolor igara na stolovima za igru na sreću",
        "Kontrolor kamere",
        "Kontrolor leta",
        "Kontrolor metalnih proizvoda",
        "Kontrolor metalurških procesa i proizvoda",
        "Kontrolor mlijeka",
        "Kontrolor pošte",
        "Kontrolor preciznih instrumenata",
        "Kontrolor pripreme i obrade podataka",
        "Kontrolor proizvoda od drveta",
        "Kontrolor robota",
        "Kontrolor staklenih proizvoda",
        "Kontrolor šivanih i sličnih proizvoda",
        "Kontrolor štamparskih proizvoda",
        "Kontrolor telefonskog saobraćaja",
        "Kontrolor telegrafskog prometa",
        "Kontrolor za kvalitet poslovanja",
        "Kontrolor za slijetanje aviona",
        "Konzervator umjetničkih djela",
        "Konzervator za kulturno nasljeđe",
        "Konzervator za prirodno nasljeđe",
        "Konzul",
        "Koordinator računarske mreže",
        "Koordinator za pružanje njege starijim osobama u zajednici",
        "Koordinator zračnog saobraćaja",
        "Kopač rova",
        "Korektor",
        "Korektor u izdavaštvu",
        "Koreograf",
        "Korepetitor",
        "Korespodent",
        "Kormilar",
        "Kormilar tegljača",
        "Kormilar unutarnje plovidbe",
        "Kostimograf",
        "Kotlar",
        "Kotlar,majstor",
        "Kovač",
        "Kovač,majstor",
        "Kozmetičar",
        "Kožar",
        "Kožar bojadiser, specijalizirani",
        "Kožni galanterist",
        "Kreditni službenik",
        "Kriminalist",
        "Kriminalistički inspektor",
        "Kriminalistički tehničar",
        "Kriminalističko tehnički vještak",
        "Kriminolog",
        "Kritičar",
        "Krojač",
        "Krojač gornjih dijelova obuće",
        "Krojač krzna i kože",
        "Krojač lake odjeće",
        "Krojač materijala za tapaciranje",
        "Krojač muške odjeće,majstor",
        "Krojač rublja, majstor",
        "Krojač tekstila",
        "Krojač teške odjeće",
        "Krojač trikotažne odjeće",
        "Krojač u scenografiji,specijalizirani",
        "Krojač ženske odjeće,majstor",
        "Krojač,majstor",
        "Krovopokrivač",
        "Krovopokrivač,majstor",
        "Krovopokrivač,specijalizirani",
        "Krupije",
        "Krznar",
        "Krznar, majstor",
        "Kućna pomoćnica",
        "Kuhar",
        "Kuhar specijaliteta",
        "Kuhar šibe",
        "Kuhinjski pomoćnik",
        "Kuhаr brzе hrаnе",
        "Kujundžija",
        "Kulinar",
        "Kulinarski tehničar",
        "Kulturolog",
        "Kupališni radnik",
        "Kurir",
        "Kustos muzeja",
        "Kustos umjetničke galerije",
        "Kušaoc hrane",
        "Kušaoc pića",
        "Kаlupеr оptičkih sоčivа",
        "Lađar",
        "Lakej, dodavač",
        "Lakirer proizvedene robe",
        "Leksikograf",
        "Lektor",
        "Lektor stranog jezika",
        "Lemitelj",
        "Licitar",
        "Likovni tehničar",
        "Likovni tehničar primjenjenog slikarstva",
        "Likovni tehničar primjenjenog vajarstva",
        "Likovni tehničar tekstilnog dizajna",
        "Likovni tehničar za oblikovanje u metalu",
        "Likovni tehničar za opremu knjige",
        "Likovni tehničar za reklamnu grafiku",
        "Likvidator",
        "Limar",
        "Limar,majstor",
        "Litografski crtač",
        "Logoped i surdoaudiolog",
        "Lončar",
        "Lovac",
        "Lovački vodič",
        "Lovni inspektor",
        "Lovni tehničar",
        "Lovočuvar",
        "Ložač centralnog grijanja",
        "Ložač parne lokomotive",
        "Ložač parnog kotla",
        "Lučki radnik",
        "Lugar",
        "Lutkar",
        "Ljevač keramičkih proizvoda",
        "Ljevač metala",
        "Ljevač metala,majstor",
        "Ljevač olovnih slova",
        "Ljevač plemenitih metala",
        "Ljevač stereotipskih ploča",
        "Ljevački drvomodelar",
        "Ljevački drvomodelar,specijalizirani",
        "Ljevački kalupar",
        "Ljuštilac kore",
        "Ljuštilac povrća i voća",
        "Ljuštilac žita",
        "Mađioničar",
        "Magacioner",
        "Magistar farmacije specijalizant",
        "Magistar farmacije stažist",
        "Major",
        "Majstor drvene sportske opreme",
        "Majstor rasvjete",
        "Majstor stilskog namještaja",
        "Majstor za zanimanje i stručno obrazovanje",
        "Maketar",
        "Maneken",
        "Manevrist",
        "Manikir",
        "Manipulant tekućeg naftnog gasa",
        "Manipulant u konfekcioniranju tekstila",
        "Manipulant u preradi plastičnih masa",
        "Maser",
        "Masker",
        "Maslar",
        "Mašinist generatora i gasnih stanica",
        "Mašinist motora SUS",
        "Mašinista",
        "Mašinobravar",
        "Mašinobravar za termo i hidro postrojenja",
        "Mašinobravar,majstor",
        "Mašinovođa",
        "Mašinovođa dizelvučnog vozila",
        "Mašinovođa elektrovučnog vozila",
        "Mašinovođa parne lokomotive",
        "Mašinovođa za manevar dizelvučnog vozila",
        "Mašinovođa za manevar elektrovučnog vozila",
        "Mašinski inženjer",
        "Mašinski inženjer za normizaciju",
        "Mašinski konstruktor aparata za domaćinstvo",
        "Mašinski konstruktor procesne opreme",
        "Mašinski kovač",
        "Mašinski ljevački kalupar",
        "Mašinski pletač",
        "Mašinski projektant konstruktor",
        "Mašinski projektant male automatizacije",
        "Mašinski projektant postrojenja",
        "Mašinski projektant postrojenja procesne industrije",
        "Mašinski projektant postrojenja za mikroklimu u postrojenjima",
        "Mašinski projektant tehnologije montaže",
        "Mašinski projektant tehnologije obrade plastičnih masa",
        "Mašinski slovoslagač",
        "Mašinski tehničar",
        "Mašinski tehničar - energetičar",
        "Mašinski tehničar održavanja brodske opreme",
        "Mašinski tehničar održavanja cjevovodne mreže",
        "Mašinski tehničar održavanja drumskih vozila",
        "Mašinski tehničar održavanja energetskog postrojenja",
        "Mašinski tehničar održavanja građevinskih mašina",
        "Mašinski tehničar održavanja metalurške opreme",
        "Mašinski tehničar održavanja opreme",
        "Mašinski tehničar održavanja plinske mreže",
        "Mašinski tehničar održavanja poljoprivredne mehanizacije",
        "Mašinski tehničar održavanja procesne opreme",
        "Mašinski tehničar održavanja proizvodne opreme",
        "Mašinski tehničar održavanja šinskih vozila",
        "Mašinski tehničar održavanja vazduhoplova",
        "Mašinski tehničar vazduhoplovnog smjera",
        "Mašinski tehničar za montažne postupke",
        "Mašinski tehničar za kompjutersko konstruisanje",
        "Mašinski tehničar za motore i motorna vozila",
        "Mašinski tehničar za preciznu mehaniku i optiku",
        "Mašinski tehničar za preradu plastičnih masa",
        "Mašinski tehnolog za održavanje energetskih postrojenja",
        "Mašinski tehnolog za održavanje metalurške opreme",
        "Mašinski tehnolog za održavanje procesne opreme",
        "Matematičar",
        "Matematičar - informatičar",
        "Matematičar aplikativni",
        "Matematičar istraživač",
        "Matičar",
        "Maturant gimnazije",
        "Maturant vazduhoplovne gimnazije",
        "Medicinska sestra",
        "Medicinska sestra babica",
        "Medicinska sestra za intenzivnu zdravstvenu njegu",
        "Medicinska sestra za oftalmološku zdravstvenu njegu",
        "Medicinska sestra za patronažnu zdravstvenu njegu",
        "Medicinska sestra za porodiljsko - ginekološku zdravstvenu njegu",
        "Medicinska sestra za psihijatrijsku zdravstvenu njegu",
        "Medicinska sestra-tehničar",
        "Medicinski asistent",
        "Medicinski fizičar",
        "Medicinski laboratorijski tehničar",
        "Medicinski patronažni asistenti",
        "Medicinski terapeut",
        "Mehanaičar uredskih mašina, majstor",
        "Mehaničar alatnih mašina",
        "Mehaničar alatnih mašina,majstor",
        "Mehaničar audio i video tehnike",
        "Mehaničar audio i video tehnike,majstor",
        "Mehaničar bicikla",
        "Mehaničar brodskih mašina",
        "Mehaničar brodskih mašina,specijalizirani",
        "Mehaničar elektroničar",
        "Mehaničar elektroničar,specijalizirani",
        "Mehaničar elektronike proizvodnih mašina",
        "Mehaničar elektronike proizvodnih mašina,specijalizirani",
        "Mehaničar elektronike uredski mašina",
        "Mehaničar elektronike uredskih mašina,specijalizirani",
        "Mehaničar elektronskih signalnih uređaja",
        "Mehaničar elektronskih signalnih uređaja,majstor",
        "Mehaničar energetske opreme",
        "Mehaničar energetske opreme,specijalizirani",
        "Mehaničar građevinski mašina",
        "Mehaničar građevinski mašina,specijalizirani",
        "Mehaničar grafičkih mašina",
        "Mehaničar grafičkih mašina,specijalizirani",
        "Mehaničar grejne i rashladne tehnike",
        "Mehaničar industrijske opreme",
        "Mehaničar industrijske opreme,specijalizirani",
        "Mehaničar konfekcijskih mašina",
        "Mehaničar konfekcijskih mašina,specijalizirani",
        "Mehaničar mašina za kožarstvo i obućarstvo",
        "Mehaničar mašina za kožarstvo i obućarstvo,specijalizirani",
        "Mehaničar mašina za preradu nemetala",
        "Mehaničar mašina za preradu nemetala,specijalizirani",
        "Mehaničar medicinske elektronike",
        "Mehaničar metalurške opreme",
        "Mehaničar metalurške opreme,specijalizirani",
        "Mehaničar motocikla",
        "Mehaničar motocikla,majstor",
        "Mehaničar opreme za grijanje",
        "Mehaničar opreme za grijanje,specijalizirani",
        "Mehaničar opreme za kompresore",
        "Mehaničar opreme za kompresore, specijalizirani",
        "Mehaničar pletaćih mašina",
        "Mehaničar poljoprivredne mehanizacije",
        "Mehaničar poljoprivredne mehanizacije,majstor",
        "Mehaničar postrojenja za punjenje i pakovanje",
        "Mehaničar postrojenja za punjenje i pakovanje, specijalizirani",
        "Mehaničar pretovarne mehanizacije",
        "Mehaničar pretovarne mehanizacije,specijalizirani",
        "Mehaničar procesne opreme",
        "Mehaničar procesne opreme,specijalizirani",
        "Mehaničar proizvodnog postrojenja",
        "Mehaničar proizvodnog postrojenja,specijalizirani",
        "Mehaničar pružnih vozila unutrašnjeg transporta",
        "Mehaničar pružnih vozila, specijalizirani",
        "Mehaničar računarske elektronike",
        "Mehaničar računarske elektronike,specijalizirani",
        "Mehaničar rudarskih mašina",
        "Mehaničar rudarskih mašina,specijalizirani",
        "Mehaničar studijskih tonskih i videouređaja",
        "Mehaničar studijskih tonskih i videouređaja,specijalizirani",
        "Mehaničar šumske mehanizacije",
        "Mehaničar šumske mehnizacije,specijalizirani",
        "Mehaničar tekstilnih mašina",
        "Mehaničar tekstilnih mašina,specijalizirani",
        "Mehaničar telekomunikacijske opreme",
        "Mehaničar telekomunikacijske opreme,specijalizirani",
        "Mehaničar telekomunikacijskih uređaja",
        "Mehaničar telekomunikacijskih uređaja,specijalizirani",
        "Mehaničar uredskih mašina",
        "Mehaničar uređaja za mjerenje i regulaciju",
        "Mehaničar uređaja za mjerenje i regulaciju,majstor",
        "Mehaničar vazduhoplova i motora",
        "Mehaničar vazduhoplova i motora,specijalizirani",
        "Mehaničar vazduhoplovne elektornike,specijalizirani",
        "Mehaničar vazduhoplovne elektronike",
        "Mehaničar vozila unutrašnjeg transporta",
        "Mehaničar za baždarenje mjernih instrumenata",
        "Mehaničar za baždarenje mjernih instrumenata,specijalizirani",
        "Mehaničar za energetskoelektronske uređaje,specijalizirani",
        "Mehaničar za hidrauliku,specijalizirani",
        "Mehaničar za medicinsku i laboratorijsku opremu",
        "Mehaničar za medicinsku i laboratorijsku opremu,majstor",
        "Mehaničar za pumpe,specijalizirani",
        "Mehaničar za rashladne i klimatizacijske uređaje",
        "Mehaničar za rashladne i klimatizacijske uređaje,majstor",
        "Mehaničar za vage",
        "Mehaničar za vage,majstor",
        "Mehaničar ze elektronske mjerne i upravljačke uređaje,specijalzirani",
        "Mehatroničar operater",
        "Mehatroničar procesnih tehnologija",
        "Menadžer kvaliteta",
        "Menadžer samostalnih stvaralaca",
        "Menadžer sportista",
        "Mesar",
        "Mesar, majstor",
        "Mesarski poslovođa",
        "Metalobrusač",
        "Metalobrusač,specijalizirani",
        "Metaloglodač",
        "Metaloglodač,specijalizirani",
        "Metalomodelar",
        "Metalomodelar,specijalizirani",
        "Metalopojaser",
        "Metalostrugar",
        "Metalotokar",
        "Metalotokar,majstor",
        "Metalurg obojenih metala",
        "Metalurg u proizvodnji",
        "Metalurški tehničar za preradu i toplinsku obradu",
        "Metalurški tehnolog prerade i toplinske obrade",
        "Meteorolog",
        "Meteorološki tehničar",
        "Metlar",
        "Mikrobiolog",
        "Mikrobiološki tehničar - kontrolor namirnica",
        "Mikrofotograf",
        "Mikser slike",
        "Mikser zvuka",
        "Miner",
        "Ministar u Vijeću ministara BiH",
        "Ministar u Vladi entiteta",
        "Ministar u vladi kantona",
        "Mitropolit",
        "Mjenjač novca",
        "Mješalac pića",
        "Mlinar",
        "Mlinar sirovina za cement, kreč i gips",
        "Mlinar žita",
        "Mljekar",
        "Mljekar,majstor",
        "Mljekarski tehničar",
        "Modelar i konstruktor kožne galanterije",
        "Modelar i konstruktor obuće",
        "Modelar kalupa i peta",
        "Modelar odjeće",
        "Moderator",
        "Modist",
        "Modular, elektrotip",
        "Modular, stereotip",
        "Molekularni botaničar",
        "Moler",
        "Moler - farbar",
        "Moler - farbar, majstor",
        "Monah/monahinja",
        "Montažer slike i zvuka",
        "Montažer u štamparstvu",
        "Monter alatnih mašina",
        "Monter alatnih mašina,specijalizirani",
        "Monter audiovizuelne elektronike,specijalizirani",
        "Monter bicikla",
        "Monter brodske opreme",
        "Monter brodske opreme,specijalizirani",
        "Monter brodskih instalacija",
        "Monter centralnog grijanja",
        "Monter cjevovoda",
        "Monter dizala",
        "Monter dizala,specijalizirani",
        "Monter električnih aparata za domaćinstvo",
        "Monter električnih mašina i opreme",
        "Monter električnih mjernih instrumenata i sklopova",
        "Monter električnih mreža",
        "Monter električnih mreža,specijalizirani",
        "Monter elektronike instrumenata,specijalizirani",
        "Monter elektronske opreme",
        "Monter energetske opreme",
        "Monter energetske opreme,specijalizirani",
        "Monter građevinskih elemenata",
        "Monter građevinskih skela",
        "Monter industrijskih transportnih sredstava",
        "Monter industrijskih transportnih sredstava,specijalizirani",
        "Monter mašina",
        "Monter mašina,specijalizrani",
        "Monter medicinske elektronike,specijalizirani",
        "Monter metalnih konstrukcija",
        "Monter metalnih konstrukcija,specijalizirani",
        "Monter mjernih instrumenata",
        "Monter motornih vozila",
        "Monter namještaja",
        "Monter niskonaponskih instalacija",
        "Monter opreme za grijanje i hlađenje",
        "Monter opreme za grijanje i hlađenje,specijalizirani",
        "Monter poljoprivrednih mašina",
        "Monter poljoprivrednih mašina,specijalizirani",
        "Monter procesne opreme",
        "Monter procesne opreme,specijalizrani",
        "Monter računarske elektronike,specijalizirani",
        "Monter radio-televizijske elektronike,specijalizirani",
        "Monter signalne elektronike,specijalizirani",
        "Monter suhe gradnje",
        "Monter tekstilnih mašina",
        "Monter tekstilnih mašina,specijalizirani",
        "Monter telekomunikacijske elektronike,specijalizirani",
        "Monter telekomunikacijskih mreža",
        "Monter telekomunikacijskih mreža,specijalizirani",
        "Monter telekomunikacijskih uređaja",
        "Monter telekomunikacijskih uređaja,specijalizirani",
        "Monter televizijskih antena",
        "Monter vazduhoplova",
        "Monteri čeličnih užadi i žica",
        "Mornar",
        "Mornar marine",
        "Mornar motorist",
        "Mrijestilišni uzgajivač",
        "Mrtvozornik",
        "Mualim",
        "Muftija",
        "Mujezin",
        "Muzejski službenik",
        "Мuzејski tеhničаr",
        "Muzejski vodič",
        "Muzeolog",
        "Muzičar",
        "Muzičar - klavirist",
        "Muzičar na ulici",
        "Muzičar opceg smjera",
        "Muzičar solista",
        "Muzičar u noćnom klubu",
        "Muzički redaktor",
        "Muzički urednik",
        "Muzikolog",
        "Nabavni referent",
        "Nabavno – prodajni referent",
        "Načelnik policije",
        "Nadbiskup",
        "Nadzornik lovišta",
        "Nadzornik novčanog tržišta",
        "Nadzornik prirodnih parkova",
        "Nadzornik tržišta kapitala",
        "Nadzornik uzgajališta divljači",
        "Naftni procesni tehnolog",
        "Naftno rudarski tehničar",
        "Naftno rudarski tehničar za bušotinske fluide",
        "Naftno rudarski tehničar za hidrodinamička mjerenja",
        "Naftno rudarski tehničar za karotažne radove",
        "Naftno rudarski tehničar za opskrbu bušaće platforme",
        "Naftno rudarski tehničar za posebne radove u bušotinama",
        "Naftno rudarski tehničar za pripremne radove",
        "Naftno rudarski tehničar za sanacijske radove u bušotinama",
        "Naftno rudarski tehničar za usmjereno bušenje",
        "Naftno-rudarski inženjer",
        "Naftno-rudarski inženjer za razvoj tehnologije izrade i održavanja bušotina",
        "Najavljivač programa",
        "Nanositelj kita na drvo",
        "Naočalni majstor optike",
        "Naočalni optičar",
        "Naočalni tehničar-optičar",
        "Naplaćivač na parkingu",
        "Naplaćivač pijačarine",
        "Naplaćivač putarine",
        "Nastavnik biologije",
        "Nastavnik biologije i hemije",
        "Nastavnik domaćinstva",
        "Nastavnik ekonomike domaćinstva i hemije",
        "Nastavnik engleskog jezika",
        "Nastavnik fizičke i zdravstvene kulture",
        "Nastavnik fizike",
        "Nastavnik geografije",
        "Nastavnik hemije",
        "Nastavnik historije",
        "Nastavnik informatike",
        "Nastavnik islamske vjeronauke",
        "Nastavnik likovne kulture",
        "Nastavnik matematike",
        "Nastavnik maternjeg jezika",
        "Nastavnik muzičke kulture",
        "Nastavnik muzičke teorijsko - pedagoškog smjera",
        "Nastavnik praktične nastave",
        "Nastavnik predškolskog vaspitanja",
        "Nastavnik razredne nastave",
        "Nastavnik ruskog jezika",
        "Nastavnik stranog jezika",
        "Nastavnik tehničke kulture",
        "Nastavnik tehničkog obrazovanja i hemije",
        "Nastavnik tehničkog obrazovanja i informatike",
        "Nastavnik vjeronauke",
        "Nautičar unutrašnje plovidbe",
        "Navigator leta",
        "Neposredni izvršilac društvene samozaštite",
        "Nijanser premaznih sredstava",
        "Noćni stražar",
        "Nomodski stočar",
        "Nosač",
        "Notar - Javni bilježnik",
        "Notni arhivar",
        "Novinar",
        "Novinski fotograf",
        "Nuklearni fizičar",
        "Numerolog",
        "Nutricionista",
        "Nаdzоrnik u transportu",
        "Nаdzоrnik visоkоgrаdnjе",
        "Njegovatelj bolesnika u kući",
        "Njegovatelj djece",
        "Njegovatelj lica s razvojnim teškoćama",
        "Njegovatelj starijih i nemoćnih lica",
        "Njegovatelji životinja",
        "Oblikovalac metala",
        "Obrađivač drveta,specijalizirani",
        "Obrađivač kamenih blokova",
        "Obrađivač konstrukcijskog željeza",
        "Obrađivač lima",
        "Obrađivač materijala u kartonaži",
        "Obrađivač materijala u knjigoveznici",
        "Obrađivač materijala u preradi papira",
        "Obrađivač metala odvajanjem čestica",
        "Obrađivač metala toplinskim postupkom",
        "Obućar",
        "Obućar,majstor",
        "Obućarski radnik",
        "Ocjenjivač duvana",
        "Ocjenjivač hrane",
        "Ocjenjivač pića",
        "Ocrtavač limova",
        "Ocrtavač limova,specijalizirani",
        "Ocrtavač odljevaka",
        "Ocrtavač odljevaka,specijalizirani",
        "Očitač brojila gasa / vode / struje",
        "Odbornik skupštine grada",
        "Odbornik skupštine opštine",
        "Odgajitelj",
        "Odgojitelj u zavodu za djecu sa posebnim potrebama",
        "Odjavničar",
        "Oficir",
        "Oficir artiljerije",
        "Oficir informatike",
        "Oficir inženjerstva",
        "Oficir kontrole vazdušnog prostora",
        "Oficir lučke kapetanije",
        "Oficir oklopnih jedinica",
        "Oficir palube na platformi",
        "Oficir palube unutrašnje plovidbe",
        "Oficir pomorstva",
        "Oficir protivzračne odbrane",
        "Oficir stabilnosti platforme",
        "Oficir stroja unutrašnje plovidbe",
        "Oficir veze",
        "Oficir za administrativne poslove",
        "Oficir za bezbjednosne i kontraobavještajne poslove",
        "Oficir za finansijske poslove",
        "Oficir za logostiku",
        "Oficir za obavještajne poslove",
        "Oficir za održavanje materijalnotehničkih sredstava",
        "Oficir za opće i kadrovske poslove",
        "Oficir za pokret i transport",
        "Oficir za sanitet",
        "Oficir za zdravstvenu zaštitu",
        "Oficir zaštite na radu",
        "Oficir zrakoplovstva",
        "Ofset mašinist",
        "Ofset štamper",
        "Oftalmološki optičar",
        "Oglašivač",
        "Okružni tužilac",
        "Oligofrenopedagog",
        "Ombudsmen",
        "Opančar",
        "Općinski načelnik",
        "Operacijski istraživač",
        "Оpеrаtеr pоstrојеnjа zа prеrаdu vоdе",
        "Operator dojavnog sistema",
        "Operator na audiometrijskoj opremi",
        "Operator na elektroencefalografskoj opremi",
        "Operator na elektrokardiografskoj opremi",
        "Operator na medicinskoj opremi",
        "Operator na medicinskoj skenirajućoj opremi",
        "Operator na opremi medicinske radiografije",
        "Operator na opremi medicinske radiologije",
        "Operator na opremi u očnoj dijagnostici",
        "Operator na opremi za dijalizu",
        "Operator na optoelektronskim uređajima i sistemima",
        "Operator na provođenju mjera gazdovanja šumom",
        "Operator na radioodašiljaču",
        "Operator na scenskoj rasvjeti",
        "Operator na telekomunikacijskoj opremi",
        "Operator na televizijskom odašiljaču",
        "Operator na vanjskoj računarskoj opremi",
        "Operator opreme za zračnu kontrolu",
        "Operator optičkog čitača",
        "Operator računara za tekst",
        "Operator radioprijenosa",
        "Operator sistema na računarskom sistemu",
        "Operator telegrafskih uređaja",
        "Operator televizijskog prijenosa",
        "Operator za pripremu obrade podataka",
        "Operator za unos podataka",
        "Oplemenjivač tekstila",
        "Optičar",
        "Optometričar",
        "Optometrist",
        "Opunomoćeni ministar ambasade",
        "Оrganizаtоr kоnfеrеnciја/skupоvа",
        "Organizator kongresne djelatnosti",
        "Organizator kulturno-zabavne djelatnosti",
        "Organizator lova",
        "Organizator muzičke i muzičkoscenske produkcije",
        "Organizator obrade podataka",
        "Organizator obrazovanja odraslih u obrazovnim zavodima",
        "Organizator obrazovanja zaposlenih u preduzeću",
        "Organizator posla",
        "Organizator poslovnih priredbi",
        "Organizator praktične nastave",
        "Organizator prodaje",
        "Organizator putovanja",
        "Organizator rada",
        "Organizator sajamske djelatnosti",
        "Organizator sportsko-rekreacijske djelatnosti",
        "Organizator televizijske i filmske produkcije",
        "Organizator zdravstvene njege",
        "Organizator zdravstvenog odgoja",
        "Ornitolog",
        "Ortopedski obućar",
        "Ortopedski obućar,majstor",
        "Osmatrač šumskih požara",
        "Osoba zadužena za kontrolu vode",
        "Oštrač alata",
        "Oštrač alata,specijalizirani",
        "Oštrač noževa",
        "Otpravnik poslova u ambasadi",
        "Otpravnik u drumskom saobraćaju",
        "Ovlašteni posrednik vrijednosnim papirima",
        "Ovlašteni revizor",
        "Ovlaživač drveta",
        "Palitelj mina površinskog kopa",
        "Palitelj mina u jami",
        "Parazitolog",
        "Paritelj drveta",
        "Parketar",
        "Parkirališni radnik",
        "Paroh",
        "Pastir",
        "Pastor",
        "Patofiziolog",
        "Patolog",
        "Patološki tehničar",
        "Patrijarh",
        "Pazikuća",
        "Pčelar",
        "Pčelarski radnik",
        "Pečenjar",
        "Pećar",
        "Pećar, specijalizirani",
        "Pedagog",
        "Pedagog-psiholog",
        "Pedijatrijska sestra - tehničar",
        "Pediker",
        "Peglač",
        "Pekar",
        "Pekar bureka i pizze",
        "Pekar,majstor",
        "Pekarski poslovođa",
        "Peljar",
        "Perač ",
        "Perač fabričkih prostorija",
        "Perač prozora",
        "Perač ulica",
        "Peradar",
        "Peradarski poslovođa",
        "Peradarski radnik",
        "Peradarski tehničar",
        "Petrohemijski laborant",
        "Petrohemijski tehničar",
        "Petrohemijski tehničar analitičar",
        "Petrohemijski tehnolog",
        "Pilar drva za ogrijev",
        "Pilot aviona",
        "Pilot helikoptera",
        "Pirotehničar",
        "Pisac reklamnih poruka",
        "Pisar",
        "Pismoslikar",
        "Pismoslikar,majstor",
        "Pismoslikarski poslovođa",
        "Pivar",
        "Pjeskar zgrada i konstrukcija",
        "Pjevač hora",
        "Pjevač na ulici",
        "Pjevač u noćnom klubu",
        "Plakatar",
        "Planer visokogradnje",
        "Planinarski vodič",
        "Plesač",
        "Plesač na ulici",
        "Plesač slobodnog plesa",
        "Plesač u noćnom klubu",
        "Pletač",
        "Pletač korpi",
        "Pletač likom",
        "Pletač metalne užadi",
        "Pletač namještaja",
        "Pletač rogozom i trskom",
        "Pletač slamom",
        "Pletač uzoraka za korpe",
        "Pletač,majstor",
        "Plinoinstalater",
        "Podešavač drvoobrađivački mašina,specijalizirani",
        "Podešavač drvoobrađivačkih mašina",
        "Podešavač metaloobrađivačkih numeričkih upravljanih mašina,specijalizirani",
        "Podešavač metaloobrađivačkog automatskog postrojenja,specijalizirani",
        "Podešavač muzičkih instrumenata",
        "Podešavač poluautomatskih i automatskih alatnih mašina,specijalizirani",
        "Podešavač sastavljenih reznih alata,specijalizirani",
        "Podešavač specijalnih alatnih mašina,specijalizirani",
        "Podgrađivač okna,specijalizirani",
        "Podmazivač mašina",
        "Podmazivač vozila",
        "Podoficir",
        "Podoficir artiljerije",
        "Podoficir informatike",
        "Podoficir inženjerstva",
        "Podoficir kontrole vazdušnog prostora",
        "Podoficir oklopnih jedinica",
        "Podoficir pomorstva",
        "Podoficir protivzračne odbrane",
        "Podoficir veze",
        "Podoficir za administrativne poslove",
        "Podoficir za bezbjednosne i kontraobavještajne poslove",
        "Podoficir za finansijske poslove",
        "Podoficir za kadrovske poslove",
        "Podoficir za logistiku",
        "Podoficir za obavještajne poslove",
        "Podoficir za održavanje materijalnotehničkih sredstava",
        "Podoficir za pokret i transport",
        "Podoficir za sanitet",
        "Podoficir za zdravstvenu zaštitu",
        "Podoficir zaštite na radu",
        "Podoficir zrakoplovstva",
        "Podopolagač",
        "Podopolagač,specijalizirani",
        "Podrumar",
        "Podrumar,vinogradar",
        "Podrumarski radnik",
        "Podvodni monter",
        "Pođakon",
        "Pogonski električar",
        "Pogrebnik",
        "Polagač čeličnih užadi žica",
        "Polagač keramičkih pločica",
        "Polagač zidnih tapeta",
        "Policajac",
        "Policajac- pozornik",
        "Policajac specijalac",
        "Policajac za posebne zadatke",
        "Policijski detektiv",
        "Policijski inspektor",
        "Policijski službenik",
        "Polirac metala",
        "Politolog",
        "Poljoprivredni inspektor",
        "Poljoprivredni radnik",
        "Poljoprivredni tehničar",
        "Poljoprivredni tehničar savjetodavac, asistent",
        "Poljoprivredni tehničar za melioraciju",
        "Poljoprivredni traktorist",
        "Pomočni skladištar",
        "Pomoćni analitičar u stručnim obrazovnim školama",
        "Pomoćni analitičar u stručnom osposobljavanju u službama",
        "Pomoćni automehaničar",
        "Pomoćni bravar",
        "Pomoćni električar",
        "Pomoćni frizer (muški i ženski)",
        "Pomoćni gumari i plastičari",
        "Pomoćni instalater vodovoda i kanalizacije",
        "Pomoćni istraživač u biologiji",
        "Pomoćni istraživač u fizici",
        "Pomoćni istraživač u geografiji",
        "Pomoćni istraživač u hemiji",
        "Pomoćni izolater",
        "Pomoćni jamski kopač i rudar",
        "Pomoćni kalupar",
        "Pomoćni keramičar",
        "Pomoćni konobar",
        "Pomoćni kontrolor leta",
        "Pomoćni krojač podstave obuće",
        "Pomoćni krojač tekstila",
        "Pomoćni kuhar",
        "Pomoćni metalobušač",
        "Pomoćni moler",
        "Pomoćni monter mašina",
        "Pomoćni proizvođač celuloze",
        "Pomoćni radnik u arhivi",
        "Pomoćni rukovalac rudarskim postrojenjem",
        "Pomoćni rukovalac sjekaćicom kamena",
        "Pomoćni rukovalac šivaćim mašinama za tapetariju",
        "Pomoćni trgovac",
        "Pomoćni ugostiteljski radnik",
        "Pomoćni uzgajivač životinja",
        "Pomoćni vatrogasac",
        "Pomoćni zdravstveni radnik",
        "Pomoćnik pravobranioca",
        "Pomoćnik direktora republičke uprave",
        "Pomoćnik direktora republičke upravne organizacije",
        "Pomoćnik direktora upravne organizacije i uprave",
        "Pomoćnik generalnog sekretara Vlade",
        "Pomoćnik konfekcijskog tekstila",
        "Pomoćnik mesara",
        "Pomoćnik ministra",
        "Pomoćnik ministra u Vladi entiteta",
        "Pomoćnik ministra u Vladi kantona",
        "Pomoćnik u podzemsnoj eksploataciji",
        "Pomorski nautičar",
        "Pomorski radiotelegrafist",
        "Pop",
        "Poreski inspektor",
        "Poreski kontrolor",
        "Poreski savjetnik",
        "Poreski službenik",
        "Poreznik",
        "Portir",
        "Poručnik",
        "Poslanik kantonalne skupštine",
        "Poslanik općinskog vijeća/ skupštine",
        "Poslovni sekretar",
        "Poslovođa armiračnice",
        "Poslovođa asfaltirnice",
        "Poslovođa betonare",
        "Poslovođa bušotinskih servisa",
        "Poslovođa dopreme i pripreme uglja u TE",
        "Poslovođa gradnje saobraćajnica",
        "Poslovođa građevinskoinstalaterskih radova",
        "Poslovođa građevinskozanatskih radova",
        "Poslovođa hidrotehničkih radova",
        "Poslovođa mehaničara i montera motornih vozila",
        "Poslovođa miniranja",
        "Poslovođa naftno-gasnog polja",
        "Poslovođa pripreme karotažnih radova",
        "Poslovođa pripreme, izrade i održavanja bušotina",
        "Poslovođa proizvodnje soli",
        "Poslovođa pružnih radova",
        "Poslovođa radova niskogradnje",
        "Poslovođa radova visokogradnje",
        "Poslovođa servisa za sanacijske radove u bušotina",
        "Poslovođa soboslikara i molera",
        "Poslovođa stanice za tehnički pregled vozila",
        "Poslovođa transporta gasa",
        "Poslovođa u ribogojstvu",
        "Poslovođa u šumarstvu",
        "Poslovođa uzgajivača ostalih životinja",
        "Poslovođa uzgoja riba i školjaka",
        "Poslovođa za parkove i nasade",
        "Poslovođa završnih radova",
        "Poslovođa žičare",
        "Poslužitelj",
        "Poslužitelj alatnih mašina",
        "Poslužitelj jela i pića",
        "Poslužitelj lifta",
        "Poslužitelj linije u preradi duhana",
        "Poslužitelj linije u proizvodnji pića",
        "Poslužitelj linije za preradu voća i povrća",
        "Poslužitelj mašina u preradi mesa i ribe",
        "Poslužitelj mašina za pekarske proizvode i slatkiše",
        "Poslužitelj mašina za sastavljanje četaka",
        "Poslužitelj mašine za gradiranje obućarskih šablona",
        "Poslužitelj mašine za isijecanje i rezanje kožne galanterije",
        "Poslužitelj mašine za mljevenje prehrambenih proizvoda",
        "Poslužitelj mašine za proizvodnju sijalica",
        "Poslužitelj mašine za proizvodnju šećera",
        "Poslužitelj mašine za ukrašavanje obuće",
        "Poslužitelj na žičari",
        "Poslužitelj postrojenja za izradu parketa",
        "Poslužitelj specijalne alatne mašine",
        "Poslužitelj u golfu",
        "Poslužitelj u kasinu",
        "Poslužitelj u saunama,bazenima i kupatilima",
        "Poslužitelj uređaja u preradi mlijeka",
        "Poslužitelj zabavnog parka",
        "Posrebrivač ogledala",
        "Posrednik prodaje na lizing",
        "Posrednik za nekretnine",
        "Posrednik za poslovne djelatnosti",
        "Posrednik za prevoz",
        "Posrednik za putovanja",
        "Posrednik za trgovinu",
        "Posrednik za uslužne djelatnosti",
        "Posrednik za zapošljavanje",
        "Postavničar",
        "Poštanski službenik na šalteru",
        "Poštar-pismonoša",
        "Potkivač",
        "Potporučnik",
        "Potpredsjednik /dopredsjednik Komore",
        "Potpredsjednik entiteta",
        "Potpredsjednik Narodne skupštine RS",
        "Potpredsjednik skupštine grada",
        "Potpredsjednik skupštine opštine",
        "Povrtlarski tehničar",
        "Pratilac",
        "Pratilac vrijednosne pošiljke",
        "Pratitelj lokomotiva",
        "Pravni savjetnik",
        "Pravni zastupnik",
        "Pravnik",
        "Pravobranilac",
        "Pravobranilac BiH",
        "Praznitelj automata za igru",
        "Praznitelj prodajnih automata",
        "Precrtavač furnira i masivnog drveta",
        "Predavač agronomije",
        "Predavač arheologije",
        "Predavač arhitekture i urbanizma",
        "Predavač astronomije",
        "Predavač biologije",
        "Predavač biotehničkih nauka",
        "Predavač biotehnologije i prehrambene tehnologije",
        "Predavač defektologije",
        "Predavač dizajna",
        "Predavač društveno-humanističkih nauka",
        "Predavač ekonomije",
        "Predavač elektrotehnike",
        "Predavač etnologije",
        "Predavač farmacije",
        "Predavač filologije",
        "Predavač filozofije",
        "Predavač fizike",
        "Predavač geodezije",
        "Predavač geofizike",
        "Predavač geografije",
        "Predavač geologije",
        "Predavač građevinarstva",
        "Predavač grafičke tehnologije",
        "Predavač hemije",
        "Predavač hemijskog inženjerstva i tehnologije",
        "Predavač historije",
        "Predavač informacijskih nauka",
        "Predavač kineziologije",
        "Predavač kriminalistike",
        "Predavač likovnih umjetnosti",
        "Predavač mašinstva",
        "Predavač matematike",
        "Predavač medicine",
        "Predavač medicinske biohemije",
        "Predavač mehanike",
        "Predavač metalurgije",
        "Predavač muzičkih umjetnosti",
        "Predavač organizacijskih nauka",
        "Predavač pedagogije",
        "Predavač politologije",
        "Predavač prava",
        "Predavač primjenjenih umjetnosti",
        "Predavač prirodnih nauka",
        "Predavač psihologije",
        "Predavač računarstva",
        "Predavač rudarstva",
        "Predavač saobraćaja",
        "Predavač scenskih umjetnosti",
        "Predavač socijalnog rada",
        "Predavač sociologije",
        "Predavač stomatologije",
        "Predavač šumarstva",
        "Predavač tehničko-tehnoloških nauka",
        "Predavač tehnologije drva",
        "Predavač tekstilne tehnologije",
        "Predavač teologije",
        "Predavač ugostiteljstva i turizma",
        "Predavač veterine",
        "Predavač zaštite na radu",
        "Predkazivač sreće i budućnosti",
        "Predmetni učitelj",
        "Predradnik brodogradilišta",
        "Predradnik cjevovodnotransportnim uređajima",
        "Predradnik elektroničar",
        "Predradnik elektroničar u montaži",
        "Predradnik kožarstva",
        "Predradnik kožne galanterije",
        "Predradnik mašinski",
        "Predradnik montaže mašina i metalnih proizvoda",
        "Predradnik obrade kamena",
        "Predradnik obrade metala",
        "Predradnik obućarstva",
        "Predradnik pripreme, izrade i održavanja bušotina",
        "Predradnik proizvodnje soli",
        "Predradnik tapetarstva",
        "Predradnik u crnoj metalurgiji",
        "Predradnik u elektroenergetici",
        "Predradnik u elektromašinstvu",
        "Predradnik u elektromontaži i instalacijama",
        "Predradnik u obojenoj metalurgiji",
        "Predradnik u preradi drveta",
        "Predradnik u staklarstvu",
        "Predradnik za bitumensko katranske materijale",
        "Predradnik za emajle i glazure",
        "Predradnik za građevinske materijale",
        "Predradnik za keramiku",
        "Predradnik za odjeću",
        "Predradnik za proizvodnju leća",
        "Predsjedavajući / predsjednik doma parlamenta / skupštine entiteta",
        "Predsjedavajući Doma naroda Parlamentarne skupštine BiH",
        "Predsjedavajući gradskog vijeća/skupštine",
        "Predsjedavajući kantonalne skupštine",
        "Predsjedavajući općinskog vijeća/skupštine",
        "Predsjedavajući Predsjedništva BiH",
        "Predsjedavajući predstavničkog doma Parlamentarne skupštine BiH",
        "Predsjedavajući Vijeća ministara BiH",
        "Predsjednik entiteta",
        "Predsjednik humanitarne organizacije",
        "Predsjednik izborne komisije",
        "Predsjednik kantonalnog - oblasnog suda",
        "Predsjednik komisije za ljudska prava",
        "Predsjednik komisije za zaštitu okoline",
        "Predsjednik komore",
        "Predsjednik Narodne skupštine RS",
        "Predsjednik općinskog suda",
        "Predsjednik političke stranke",
        "Predsjednik posebne interesne organizacije",
        "Predsjednik poslovnog udruženja",
        "Predsjednik saveza",
        "Predsjednik Saveza sindikata",
        "Predsjednik sindikata",
        "Predsjednik skupštine grada",
        "Predsjednik skupštine opštine",
        "Predsjednik strukovnog udruženja",
        "Predsjednik upravnog odbora preduzeća",
        "Predsjednik Ustavnog suda BiH",
        "Predsjednik Ustavnog suda entiteta",
        "Predsjednik Vlade entiteta",
        "Predsjednik Vrhovnog suda entiteta",
        "Predsjednik zadružnog saveza",
        "Predstavnik stranke za odnose na javnošću",
        "Pregledač vagona",
        "Prehrambeni predradnik",
        "Prehrambeni tehničar",
        "Prehrambenohemijski laborant",
        "Premijer/Predsjednik vlade kantona",
        "Preparator",
        "Prerađivač mesa i mlijeka",
        "Prerađivač žita, brašna i šećera",
        "Prerađivač glinice",
        "Prerađivač mlijeka,specijalizirani",
        "Prerađivač voća i povrća",
        "Prešač metala",
        "Prešač plemenitih metala",
        "Prevodilac",
        "Primatelj uloga za klađenje",
        "Primatelj uplata u igrama na sreću",
        "Pripremač duvana",
        "Pripremač tekstilnih vlakana",
        "Probni padobranac",
        "Probni pilot",
        "Procjenitelj",
        "Procjenitelj boniteta",
        "Procjenitelj nakita",
        "Procjenitelj osiguranja",
        "Procjenitelj umjetnina",
        "Prodajni referent",
        "Prodavac prehrambene robe",
        "Prodavac tehničke robe",
        "Prodavac nafte i naftnih derivata",
        "Prodavac tekstilne robe",
        "Prodavač",
        "Prodavač autobusnih karata",
        "Prodavač na pijaci",
        "Prodavač na priredbama",
        "Prodavač na uličnoj tezgi",
        "Prodavač nа pumpi",
        "Prodavač putem telefona",
        "Prodavač putničkih karata",
        "Prodavač u kiosku",
        "Prodavač u kаfеtеriјi",
        "Prodavač ulaznica",
        "Prodavači zakupci",
        "Prodekan",
        "Producent",
        "Profesor albanskog jezika",
        "Profesor arapskog jezika",
        "Profesor arhitekture",
        "Profesor astronomije",
        "Profesor baleta i plesa",
        "Profesor biologije",
        "Profesor birotehničkih predmeta",
        "Profesor bosanskog jezika",
        "Profesor drumskog saobraćaja",
        "Profesor ekonomskih predmeta",
        "Profesor elektronike",
        "Profesor elektrotehnike",
        "Profesor engleskog jezika",
        "Profesor farmaceutskih predmeta",
        "Profesor filozofije",
        "Profesor fizičke i zdravstvene kulture",
        "Profesor fizike",
        "Profesor fizioterapije",
        "Profesor flaute",
        "Profesor francuskog jezika",
        "Profesor geodezije",
        "Profesor geofizike",
        "Profesor geografije",
        "Profesor geologije",
        "Profesor građevinarstva",
        "Profesor grčkog jezika",
        "Profesor gumarske tehnologije",
        "Profesor hemije",
        "Profesor hemijske tehnologije",
        "Profesor historije",
        "Profesor hrvatskog jezika",
        "Profesor informatike",
        "Profesor instrumentalista-privatni časovi",
        "Profesor keramičarske tehnologije",
        "Profesor kliničkih medicinskih nauka",
        "Profesor konditorstva",
        "Profesor konfekcijske tehnologije",
        "Profesor kožarsko-krznarske tehnologije",
        "Profesor kulinarstva",
        "Profesor kulturoloških predmeta",
        "Profesor latinskog jezika",
        "Profesor likovnih predmeta",
        "Profesor logike",
        "Profesor ljekovitog i aromatskog bilja",
        "Profesor marksizma",
        "Profesor mašinske energetike",
        "Profesor mašinstva",
        "Profesor matematike",
        "Profesor medicinskobiohemijskih predmeta",
        "Profesor mehanike",
        "Profesor melioracije",
        "Profesor metalurgije",
        "Profesor mlinarstva i pekarstva",
        "Profesor muzičkih predmeta",
        "Profesor njemačkog jezika",
        "Profesor obućarske i kožno-galanterijske tehnologije",
        "Profesor odbrane i sigurnosti",
        "Profesor orjentalistike",
        "Profesor osnovnih i socijalnih medicinskih nauka",
        "Profesor pedagogije",
        "Profesor plastičarske tehnologije",
        "Profesor poljoprivredne mehanizacije",
        "Profesor praktične nastave",
        "Profesor pravnih predmeta",
        "Profesor prerade duhana",
        "Profesor prerade mesa",
        "Profesor prerade mlijeka",
        "Profesor prerade voća",
        "Profesor proizvodnje alkohola i alkoholnih pića",
        "Profesor proizvodnje šećera i skroba",
        "Profesor proizvodnje ulja i biljnih masti",
        "Profesor protupožarne zaštite",
        "Profesor psihologije",
        "Profesor PTT saobraćaja",
        "Profesor računarstva",
        "Profesor ratarstva i povrtlarstva",
        "Profesor religijske kulture",
        "Profesor restauracije i gradnje muzičkih predmeta",
        "Profesor riječnog saobraćaja",
        "Profesor romskog jezika",
        "Profesor rudarstva",
        "Profesor ruskog jezika",
        "Profesor scenskih predmeta",
        "Profesor sociologije",
        "Profesor srpskog jezika",
        "Profesor srpskohrvatskog jezika i jugoslovenske književnosti",
        "Profesor staklarske tehnologije",
        "Profesor stočarstva",
        "Profesor stomatoloških predmeta",
        "Profesor stranog jezika",
        "Profesor šumarstva",
        "Profesor talijanskog jezika",
        "Profesor tehnologije drveta",
        "Profesor tehnologije papira",
        "Profesor tekstilne tehnologije",
        "Profesor trgovinskih predmeta",
        "Profesor turskog jezika",
        "Profesor ugostiteljstva i turizma",
        "Profesor unutrašnjeg saobraćaja",
        "Profesor vazduhoplovnog saobraćaja",
        "Profesor veterinarskih predmeta",
        "Profesor visoke škole biotehničkih nauka",
        "Profesor visoke škole društveno-humanističkih nauka",
        "Profesor visoke škole medicinskih nauka",
        "Profesor visoke škole prirodnih nauka",
        "Profesor visoke škole tehničkih nauka",
        "Profesor visoke škole u teologiji",
        "Profesor vjeronauke",
        "Profesor voćarstva i vinogradarstva",
        "Profesor za osobe sa poremećajima u ponašanju",
        "Profesor zaštite na radu",
        "Profesor željezničkog saobraćaja",
        "Programer",
        "Programer inženjersko-naučnih primjena",
        "Programer mašina upravljanih brojčano",
        "Programer poslovnih primjena",
        "Programer računarskih primjena",
        "Programer za računarske mreže",
        "Proizvodni inženjer",
        "Proizvođač akumulatorskih kutija",
        "Proizvođač alkoholnih pića",
        "Proizvođač bezalkoholnih pića",
        "Proizvođač duvanskih proizvoda",
        "Proizvođač furnira i drvenih pločica",
        "Proizvođač gume i plastike",
        "Proizvođač industrijskog bilja",
        "Proizvođač jestivih ulja",
        "Proizvođač sirćeta",
        "Proizvođač šećera",
        "Proizvođač vatrostalnog materijala",
        "Projektant arhitekture",
        "Projektant bušotina za naftu i gas",
        "Projektant elektroenergetskih postrojenja",
        "Projektant enterijera",
        "Projektant građevinskih konstrukcija",
        "Projektant hemijske tehnologije",
        "Projektant hidrotehničkih građevina",
        "Projektant informacionih sistema",
        "Projektant konstruktor alatnih mašina",
        "Projektant konstruktor brodskih motora",
        "Projektant konstruktor brodskih pomoćnih mašina",
        "Projektant konstruktor dizalica",
        "Projektant konstruktor drumskih vozila",
        "Projektant konstruktor elektroničkih sistema i proizvoda",
        "Projektant konstruktor elektrotehničkih proizvoda",
        "Projektant konstruktor energetskoelektroničkih uređaja",
        "Projektant konstruktor klasičnog naoružanja",
        "Projektant konstruktor mašina za građevinarstvo i industrijski transport",
        "Projektant konstruktor mašina za zavarivanje",
        "Projektant konstruktor metalnih konstrukcija",
        "Projektant konstruktor plovnih sredstava",
        "Projektant konstruktor poljoprivrednih mašina",
        "Projektant konstruktor preciznih instrumenata",
        "Projektant konstruktor pumpi i kompresora",
        "Projektant konstruktor pumpi pod pritiskom",
        "Projektant konstruktor složenih alata i uređaja",
        "Projektant konstruktor šinskih vozila",
        "Projektant konstruktor šivaćih mašina",
        "Projektant konstruktor tekstilnih mašina",
        "Projektant konstruktor turbina",
        "Projektant mašinske tehnologije",
        "Projektant mašinske tehnologije osiguranja kvaliteta",
        "Projektant mašinskog dijela energetskog postrojenja",
        "Projektant mreže za distribuciju gasovitih medija",
        "Projektant naftne tehnologije",
        "Projektant organizacije gradnje",
        "Projektant postrojenja za snabdjevanje vodom",
        "Projektant sabirnih sistema za naftu i plin",
        "Projektant saobraćajnih građevina",
        "Projektant tehnologije gradnje plovnih sredstava",
        "Projektant tehnologije obrade deformacijom",
        "Projektant tehnologije obrade odvajanjem čestica",
        "Projektant tehnologije održavanja brodske opreme",
        "Projektant tehnologije održavanja vazduhoplova",
        "Projektant tehnologije za održavanje drumskih vozila",
        "Projektant tehnologije za održavanje građevinskih mašina",
        "Projektant tehnologije za održavanje poljoprivredne mehanizacije",
        "Projektant tehnologije za održavanje proizvodne opreme",
        "Projektant tehnologije za održavanje šinskih vozila",
        "Projektant tehnologije zavarivanja",
        "Projektant vrtne i pejsažne arhitekture",
        "Propovjednik",
        "Prorektor",
        "Prostorni planer",
        "Prostorni projektant",
        "Prota",
        "Protođakon",
        "Protupožarni inspektor",
        "Pružni radnik",
        "Prvi oficir palube",
        "Prvi oficir stroja",
        "Prеdаvаč iz оblаsti rаčunаrа",
        "Prеdаvаč iz оblаsti sоftvеrа",
        "Prоfеsоr gitаrе - privаtni čаsоvi",
        "Prоfеsоr klаvirа - privаtni čаsоvi",
        "Prоfеsоr pjevanja - privаtni čаsоvi",
        "Prоfеsоr plеsа - privаtni čаsоvi",
        "Prоfеsоr slikаnjа - privаtni čаsоvi",
        "Prоfеsоr viоlinе - privаtni čаsоvi",
        "Prоfеsоr zа intеnzivnо učеnjе јеzikа",
        "Prоfеsоr zа prаktičnu primjenu јеzikа",
        "Psihogerijatrijska sestra - tehničar",
        "Psiholog",
        "Psiholog forenzičar",
        "Psiholog istraživač",
        "Psiholog rada",
        "Psiholog samostalni istraživač",
        "Psiholog savjetnik u savjetovalištu",
        "Psihoterapeut",
        "PTT tehničar poštanskog saobraćaja",
        "Pukovnik",
        "Puškar",
        "Puškar,majstor",
        "Putar",
        "Pоmоćnik u kuhinji",
        "Pоmоćnik učitеljа",
        "Pоzоrišni gаrdеrоbеr",
        "Pоzоrišni tеhničаr",
        "Rabin",
        "Računarski operator",
        "Računarski tehničar",
        "Računovođa",
        "Radiotelegrafist",
        "Radni terapeut",
        "Radnik betonirac",
        "Radnik na baliranju otpadaka",
        "Radnik na elektronamotavanju",
        "Radnik na istovaru i utovaru",
        "Radnik na izvozu i iznosu drvnih sortimenata",
        "Radnik na jednostavnim drvoprerađivačkim poslovima",
        "Radnik na jednostavnim grafičkim poslovima",
        "Radnik na jednostavnim keramičkim poslovima",
        "Radnik na jednostavnim laboratorijskim poslovima",
        "Radnik na jednostavnim poslovima na energetskom postrojenju",
        "Radnik na jednostavnim poslovima na pakovanju tehničkih gasova",
        "Radnik na jednostavnim poslovima na postrojenju za preradu i obradu vode",
        "Radnik na jednostavnim poslovima u ciglarstvu",
        "Radnik na jednostavnim poslovima u hemijskoj proizvodnji",
        "Radnik na jednostavnim poslovima u izradi građevinskih materijala",
        "Radnik na jednostavnim poslovima u kožarstvu",
        "Radnik na jednostavnim poslovima u kožnoj galanteriji",
        "Radnik na jednostavnim poslovima u naftno hemijskoj proizvodnji",
        "Radnik na jednostavnim poslovima u proizvodnji obuće",
        "Radnik na jednostavnim poslovima u tekstilnoj proizvodnji",
        "Radnik na jednostavnim poslovima utovarača,pretovarača i prenosa tereta",
        "Radnik na jednostavnim transportnim poslovima",
        "Radnik na kontinuiranom kuhalu drveta",
        "Radnik na palubi platforme",
        "Radnik na sabiranju sjemena",
        "Radnik na tržnici",
        "Radnik na utovaru drvnih sortimenata",
        "Radnik na uzgoju i zaštiti divljači",
        "Radnik niskogradnje",
        "Radnik u asfaltirnici",
        "Radnik u ekonomskom dvorištu",
        "Radnik u glinokopu",
        "Radnik u kamenolomu",
        "Radnik u lovištu",
        "Radnik u održavanju",
        "Radnik u šljunkari",
        "Radnik uzgajanja različitih životinja",
        "Radnik visokogradnje",
        "Radnik za dostavu robe iz trgovina",
        "Radnik za jednostavne poslove drugdje nerazvrstan",
        "Radnik za jednostavne poslove na montaži",
        "Radnik za jednostavne poslove na proizvodnoj liniji",
        "Radnik za jednostavne poslove u preradi duhana",
        "Radnik za mehaničku lopatu",
        "Radnik za pomoć u kući",
        "Radnik za sortiranje prtljaga",
        "Radnik za uređenje kaptaža",
        "Rafinerijski punitelj",
        "Rasadničar",
        "Raspoređivač u drumskom saobraćaju",
        "Ratar",
        "Ratar i stočar",
        "Ratar za navodnjavanje",
        "Ratarski mehanizator",
        "Ratarski poslovođa",
        "Ratarski radnik",
        "Ratarski tehničar",
        "Raznosilac",
        "Razredni učitelj",
        "Razvrstavač i slagač lemelnih i mozaičnih parketa",
        "Razvrstavač keramičkih proizvoda",
        "Razvrstavač koža,specijalizirani",
        "Recenzent",
        "Recepcionar",
        "Redaktor",
        "Redovnik",
        "Referent kancelarijskog poslovanja",
        "Referent za bolničko liječenje",
        "Referent za građevinske dozvole",
        "Referent za izdavanje koncesija",
        "Referent za izdavanje putnih isprava",
        "Referent za iznajmljivanje vozila",
        "Referent za izvoz i uvoz",
        "Referent za javno upravne poslove",
        "Referent za naknade za nezaposlenost",
        "Referent za penziono i invalidsko osiguranje",
        "Referent za porodična primanja",
        "Referent za poštu",
        "Referent za pravne poslove",
        "Referent za reklamaciju",
        "Referent za socijalne pomoći",
        "Referent za vozne redove",
        "Referent za zdravstveno osiguranje",
        "Reis ullema",
        "Rektor univerziteta",
        "Rekviziter alata",
        "Remenar-sedlar",
        "Rentgenski pregledač osoba, prtljaga i poštanskih pošiljki",
        "Reporter",
        "Reprofotograf",
        "Reprograf skenarist",
        "Republički tužilac",
        "Restaurator drvenih predmeta,specijalizirani",
        "Restaurator umjetničkih djela",
        "Retušer",
        "Revizor",
        "Revizor za ekonomsko-finansijske poslove",
        "Revizori za pravne poslove",
        "Rezač drvenih figura",
        "Rezač drveta",
        "Rezač i brusač naočalnih zaštitnih stakala",
        "Rezač plinom",
        "Rezbar predmeta od roga",
        "Režiser",
        "Režiser operne predstave",
        "Ribar na moru",
        "Ribar otvorenog mora",
        "Ribar riječni i jezerski",
        "Ribarski inspektor",
        "Ribarski poslovođa na otvorenom moru",
        "Ribarski poslovođa riječni i jezerski",
        "Ribarski tehničar",
        "Ribarski vodič",
        "Ribarskonautički tehničar",
        "Ribnjačarski radnik",
        "Roletar",
        "Roletar,majstor",
        "Ronilac spužvi i koralja",
        "Ronilac za spasavanje",
        "Ručni čistač",
        "Ručni graver štamparskih uzoraka u metalu",
        "Ručni graver štamparskih uzoraka u nemetalu",
        "Ručni izrađivač ambalažnih grafičkih proizvoda",
        "Ručni izrađivač fotoosjetljivih slojeva za sitoštampu",
        "Ručni izrađivač proizvoda od papira",
        "Ručni izrađivač štamparskih formi i klišeja",
        "Ručni pakirer",
        "Ručni perač ambalaže",
        "Ručni perač automobila",
        "Ručni perač dijelova",
        "Ručni perač stakla na kolima -ulični",
        "Ručni razvrstavač dijelova",
        "Ručni razvrstavač proizvoda",
        "Ručni savijač metala",
        "Ručni slovoslagač",
        "Ručni štampar",
        "Rudar",
        "Rudar podzemnog kopa",
        "Rudar površinskog kopa",
        "Rudar,specijalizirani",
        "Rudarski inspektor",
        "Rudarski inženjer",
        "Rudarski Inženjer podzemne eksploatacije",
        "Rudarski Inženjer površinske eksploatacije",
        "Rudarski jamski nadzornik",
        "Rudarski jamski poslovođa",
        "Rudarski jamski predradnik",
        "Rudarski mjernik",
        "Rudarski nadzornik površinskog kopa",
        "Rudarski nadzornik separacije",
        "Rudarski poslovođa",
        "Rudarski poslovođa površinskog kopa",
        "Rudarski predradnik površinskog kopa",
        "Rudarski radnik",
        "Rudarski tehničar",
        "Rudarski tehničar podzemne eksploatacije",
        "Rudarski tehničar površinske eksploatacije",
        "Rudarski tehničar za pripremu proizvodnje",
        "Rudarski tesar",
        "Rukavičar",
        "Rukovalac bušilicom za drvo",
        "Rukovalac mašinom za brušenje i poliranje drveta",
        "Rukovalac oštrilicom alata",
        "Rukovalac uređajem za sljepljivanje rubova drveta",
        "Rukovalac alatnom mašinom",
        "Rukovalac asfaltne baze",
        "Rukovalac autoklavom za sječku",
        "Rukovalac automatiziranom montažnom linijom,specijalizirani",
        "Rukovalac betonskim topom",
        "Rukovalac betonskom pumpom",
        "Rukovalac blanjalicom metala",
        "Rukovalac blanjalicom za drvo",
        "Rukovalac brodskim dizalicama",
        "Rukovalac brojčano upravljanim mašinama za primarnu preradu drveta",
        "Rukovalac brojčano upravljanom drvoobrađivačkom mašinom",
        "Rukovalac brojčano upravljanom mašinom za obradu metala",
        "Rukovalac brojčano upravljanom mašinom za obradu metala ,specijalizirani",
        "Rukovalac cirkularom ,gaterom i poralicom",
        "Rukovalac cjevovodnotransportnim uređajima",
        "Rukovalac dehidratorom hemikalija",
        "Rukovalac destilatorom",
        "Rukovalac destilatorom aroma i parfema",
        "Rukovalac digestorom za pulpu",
        "Rukovalac dijamantnom pilom",
        "Rukovalac dispergatorom hemikalija",
        "Rukovalac dizalicom",
        "Rukovalac dizalom",
        "Rukovalac drobilicom za hemikalije",
        "Rukovalac drvotokarskim mašinama",
        "Rukovalac ekstraktorom hemikalija",
        "Rukovalac ekstruderom za hemikalije",
        "Rukovalac ekstruderom za polimere",
        "Rukovalac elektroenergetskim postrojenjem,specijalizirani",
        "Rukovalac elektrolizne stanice",
        "Rukovalac filterima za hemikalije",
        "Rukovalac fleksoštamparskom mašinom",
        "Rukovalac glodalicom metala",
        "Rukovalac glodalicom za drvo",
        "Rukovalac građevinskih strojeva visokogradnje",
        "Rukovalac građevinskim i pretovarnim mašinama",
        "Rukovalac građevinskim mašinama",
        "Rukovalac industrijskim robotom,specijalizirani",
        "Rukovalac isparivačem",
        "Rukovalac jamskom utovarnom mehanizacijom",
        "Rukovalac kalandrom za tekstil",
        "Rukovalac knjigovezačkim mašinama",
        "Rukovalac kompresorom",
        "Rukovalac kompresorskih stanica,specijalizirani",
        "Rukovalac kotlova",
        "Rukovalac kožarsko-krznarskim mašinama",
        "Rukovalac kranom",
        "Rukovalac krematorija",
        "Rukovalac kružnom pilom",
        "Rukovalac lakih građevinskih mašina",
        "Rukovalac laktofrizom",
        "Rukovalac linijom za sastavljanje tapaciranih proizvoda",
        "Rukovalac lučkom mehanizacijom",
        "Rukovalac mašinama za izradu plastičnih proizvoda,specijalizirani",
        "Rukovalac mašinama i uređajima za istiskivanje metala",
        "Rukovalac mašinama i uređajima za izvlačenje metala",
        "Rukovalac mašinama i uređajima za obradu rude i kamena",
        "Rukovalac mašinama i uređajima za proizvodnju keramike",
        "Rukovalac mašinama i uređajima za proizvodnju stakla",
        "Rukovalac mašinama i uređajima za proizvodnju staklenih proizvoda",
        "Rukovalac mašinama u pekarstvu",
        "Rukovalac mašinama za asfaltiranje",
        "Rukovalac mašinama za bojenje tekstila",
        "Rukovalac mašinama za brušenje i četkanje kože",
        "Rukovalac mašinama za bušenje i razbijanje",
        "Rukovalac mašinama za češljanje i šišanje krzna",
        "Rukovalac mašinama za doradu potplatnih koža",
        "Rukovalac mašinama za glačanje i ravnanje koža",
        "Rukovalac mašinama za iglanje i prošivanje",
        "Rukovalac mašinama za injektiranje tla",
        "Rukovalac mašinama za iskop",
        "Rukovalac mašinama za iskop tunela",
        "Rukovalac mašinama za iskuhavanje tekstila",
        "Rukovalac mašinama za izdvajanje radioaktivnih materija",
        "Rukovalac mašinama za izradu dijafragme",
        "Rukovalac mašinama za izradu plastičnih proizvoda",
        "Rukovalac mašinama za izradu šešira",
        "Rukovalac mašinama za izradu traka s uzorkom",
        "Rukovalac mašinama za kesonsko temeljenje",
        "Rukovalac mašinama za konzerviranje mesa i ribe",
        "Rukovalac mašinama za ljuštenje žita",
        "Rukovalac mašinama za mliječne proizvode",
        "Rukovalac mašinama za mljevenje uljarične ljuske",
        "Rukovalac mašinama za mljevenje uljnog sjemena",
        "Rukovalac mašinama za mljevenje žita",
        "Rukovalac mašinama za nabijanje",
        "Rukovalac mašinama za napinjanje kože",
        "Rukovalac mašinama za netkani tekstil",
        "Rukovalac mašinama za obradu kamena",
        "Rukovalac mašinama za obradu voća",
        "Rukovalac mašinama za planiranje tla",
        "Rukovalac mašinama za pletenje",
        "Rukovalac mašinama za pletenje mreža",
        "Rukovalac mašinama za pokrivne slojeve kože",
        "Rukovalac mašinama za poslastice i peciva",
        "Rukovalac mašinama za pranje tekstila",
        "Rukovalac mašinama za pranje voća i povrća",
        "Rukovalac mašinama za predenje",
        "Rukovalac mašinama za preradu mesa",
        "Rukovalac mašinama za preradu ribe",
        "Rukovalac mašinama za preradu voća i povrća",
        "Rukovalac mašinama za pripremu voća i povrća",
        "Rukovalac mašinama za proizvodnju čokolade",
        "Rukovalac mašinama za proizvodnju dijetne hrane",
        "Rukovalac mašinama za proizvodnju dječije hrane iz voća",
        "Rukovalac mašinama za proizvodnju industrijskih dijamanata",
        "Rukovalac mašinama za proizvodnju jestivog ulja",
        "Rukovalac mašinama za proizvodnju keksa",
        "Rukovalac mašinama za proizvodnju koksa",
        "Rukovalac mašinama za proizvodnju kolača",
        "Rukovalac mašinama za proizvodnju margarina i biljnog masla",
        "Rukovalac mašinama za proizvodnju sintetičkih vlakana",
        "Rukovalac mašinama za proizvodnju slatkiša",
        "Rukovalac mašinama za proizvodnju sokova",
        "Rukovalac mašinama za proizvodnju soli",
        "Rukovalac mašinama za proizvodnju stočne hrane",
        "Rukovalac mašinama za proizvodnju tijesta",
        "Rukovalac mašinama za proizvodnju tjestenine",
        "Rukovalac mašinama za proizvodnju vještačke kože",
        "Rukovalac mašinama za proizvodnju vještačkih đubriva",
        "Rukovalac mašinama za proizvodnju žvakaćih guma",
        "Rukovalac mašinama za pružne radove",
        "Rukovalac mašinama za rafiniranje ulja i masti",
        "Rukovalac mašinama za stabilizaciju tla",
        "Rukovalac mašinama za sušenje kože",
        "Rukovalac mašinama za sušenje mesa",
        "Rukovalac mašinama za tkanje",
        "Rukovalac mašinama za toplinsko oblikovanje tekstila",
        "Rukovalac mašinama za toplinsku obradu hemikalija",
        "Rukovalac mašinama za toplinsku obradu tekstila",
        "Rukovalac mašinama za topljenje masti",
        "Rukovalac mašinama za ugradnju betonskih ivičnjaka",
        "Rukovalac mašinama za ukrasni tekstil",
        "Rukovalac mašinama za užad",
        "Rukovalac mašinama za vezenje",
        "Rukovalac mašinama za zabijanje pilote",
        "Rukovalac mašinama za zemljane radove",
        "Rukovalac mašinama za žitne proizvode",
        "Rukovalac mašinom za torkretiranje",
        "Rukovalac mašinom u kartonaži",
        "Rukovalac mašinom za bakroštampu",
        "Rukovalac mašinom za bijeljenje tekstila",
        "Rukovalac mašinom za blanjenje",
        "Rukovalac mašinom za bojenje pređe",
        "Rukovalac mašinom za bojenje tekstilnih vlakana",
        "Rukovalac mašinom za boranje (plisiranje) tekstila",
        "Rukovalac mašinom za brizganje polimera",
        "Rukovalac mašinom za brizganje potplata na obuću",
        "Rukovalac mašinom za brušenje metala",
        "Rukovalac mašinom za brušenje obuće",
        "Rukovalac mašinom za brušenje žljebova",
        "Rukovalac mašinom za bušenje metala",
        "Rukovalac mašinom za cijeđenje rublja",
        "Rukovalac mašinom za cijepanje kože",
        "Rukovalac mašinom za čupavljenje tekstila",
        "Rukovalac mašinom za dijeljenje drveta bez iverja",
        "Rukovalac mašinom za dubljenje rupa u drvetu",
        "Rukovalac mašinom za elektroerodiranje",
        "Rukovalac mašinom za farmaceutske proizvode",
        "Rukovalac mašinom za glačanje odjeće",
        "Rukovalac mašinom za glačanje tekstila",
        "Rukovalac mašinom za glodanje žljebova",
        "Rukovalac mašinom za graviranje metala",
        "Rukovalac mašinom za hermetičko zatvaranje",
        "Rukovalac mašinom za injekcijsko presanje polimera",
        "Rukovalac mašinom za isijecanje donjih dijelova obuće",
        "Rukovalac mašinom za iveranje drveta",
        "Rukovalac mašinom za izradu dugmadi",
        "Rukovalac mašinom za izradu gornjih gumenih dijelova obuće",
        "Rukovalac mašinom za izradu gume",
        "Rukovalac mašinom za izradu koverata",
        "Rukovalac mašinom za izradu pragova",
        "Rukovalac mašinom za izradu reznog alata",
        "Rukovalac mašinom za izradu sintetičkih đonova",
        "Rukovalac mašinom za izradu vrećica",
        "Rukovalac mašinom za jetkanje metala",
        "Rukovalac mašinom za karboniziranje tekstila",
        "Rukovalac mašinom za knjižnu štampu",
        "Rukovalac mašinom za konzerviranje mlijeka",
        "Rukovalac mašinom za kovanje alata",
        "Rukovalac mašinom za kovanje novca",
        "Rukovalac mašinom za kozmetičke proizvode",
        "Rukovalac mašinom za krojenje gornjih dijelova obuće",
        "Rukovalac mašinom za laminiranje polimera",
        "Rukovalac mašinom za lijevanje betona",
        "Rukovalac mašinom za lomljenje lica kože",
        "Rukovalac mašinom za mekšanje kože",
        "Rukovalac mašinom za mjerenje kože",
        "Rukovalac mašinom za naknadnu obradu tekstila",
        "Rukovalac mašinom za namotavanje tekstila",
        "Rukovalac mašinom za navlačenje gornjih dijelova obuće",
        "Rukovalac mašinom za oblikovanje drveta savijanjem i utiskivanjem",
        "Rukovalac mašinom za oblikovanje gumenih proizvoda",
        "Rukovalac mašinom za obradu papira",
        "Rukovalac mašinom za obradu pluta",
        "Rukovalac mašinom za obradu ruba potplata",
        "Rukovalac mašinom za obrađivanje i obljepljivanje drveta",
        "Rukovalac mašinom za održavanje skijališta",
        "Rukovalac mašinom za odškrobljavanje tekstila",
        "Rukovalac mašinom za otkoravanje",
        "Rukovalac mašinom za označavanje ceste",
        "Rukovalac mašinom za pakovanje",
        "Rukovalac mašinom za pakovanje pod pritiskom",
        "Rukovalac mašinom za pakovanje tableta",
        "Rukovalac mašinom za peraća sredstva",
        "Rukovalac mašinom za piljenje metala",
        "Rukovalac mašinom za plastificiranje tekstila",
        "Rukovalac mašinom za postavljanje cijevne instalacije",
        "Rukovalac mašinom za postavljanje drenaže",
        "Rukovalac mašinom za postavljanje izolacije",
        "Rukovalac mašinom za pranje automobila",
        "Rukovalac mašinom za pranje rublja",
        "Rukovalac mašinom za pranje vagona",
        "Rukovalac mašinom za preradu duhana",
        "Rukovalac mašinom za preradu papira",
        "Rukovalac mašinom za presanje dijelova obuće",
        "Rukovalac mašinom za prevlačenje električnih vodova",
        "Rukovalac mašinom za pripremu oblovine",
        "Rukovalac mašinom za pripremu polimera",
        "Rukovalac mašinom za proizvodnju baterija",
        "Rukovalac mašinom za proizvodnju duhanskih proizvoda",
        "Rukovalac mašinom za proizvodnju električnih vodova",
        "Rukovalac mašinom za proizvodnju kotlova",
        "Rukovalac mašinom za proizvodnju metalne užadi",
        "Rukovalac mašinom za proizvodnju nakita",
        "Rukovalac mašinom za proizvodnju papira",
        "Rukovalac mašinom za proizvodnju papira,specijalizirani",
        "Rukovalac mašinom za proizvodnju toaletnih proizvoda",
        "Rukovalac mašinom za prošivanje đonova",
        "Rukovalac mašinom za puhanje polimera",
        "Rukovalac mašinom za ravno šivenje odjeće",
        "Rukovalac mašinom za riblje proizvode",
        "Rukovalac mašinom za rotolijev polimera",
        "Rukovalac mašinom za rupičanje kožnih dijelova",
        "Rukovalac mašinom za sastavljanje kablova i užadi",
        "Rukovalac mašinom za sastavljanje madraca",
        "Rukovalac mašinom za skidanje mesine",
        "Rukovalac mašinom za sljepljiivanje kutnih spojeva drveta",
        "Rukovalac mašinom za sljepljivanje uskih strana drveta",
        "Rukovalac mašinom za struganje kože",
        "Rukovalac mašinom za šišanje tekstila",
        "Rukovalac mašinom za štampanje tekstila",
        "Rukovalac mašinom za valjanje tekstila",
        "Rukovalac mašinom za vezenje",
        "Rukovalac mašinom za zakivanje eksera",
        "Rukovalac mašinskim makazama za rezanje metala",
        "Rukovalac mehanizacijom na površinskoj eksploataciji",
        "Rukovalac mehanizacijom u šumarstvu",
        "Rukovalac mješalicom za granulat plastike",
        "Rukovalac mlinom za gumu",
        "Rukovalac mlinom za hemikalije",
        "Rukovalac mlinom za papirnu smjesu",
        "Rukovalac mlinom za plastiku",
        "Rukovalac mlinom za začine",
        "Rukovalac mlinskim sitima",
        "Rukovalac mlinskim valjcima",
        "Rukovalac motorom s unutrašnjim sagorjevanjem",
        "Rukovalac motorom s unutrašnjim sagorjevanjem,specijalizirani",
        "Rukovalac obalnim dizalicama",
        "Rukovalac obućarskim mašinama",
        "Rukovalac ofsetnom štamparskom mašinom",
        "Rukovalac opremom u zabavnom parku",
        "Rukovalac opremom za doradu gumenih proizvoda",
        "Rukovalac parnim kotlovima sa automatskom komandom,specijalizirani",
        "Rukovalac parnim kotlovima sa mehaniziranim loženjem,specijalizirani",
        "Rukovalac parnim kotlovima sa ručnim loženjem",
        "Rukovalac parnim mašinama",
        "Rukovalac parnim turbinama",
        "Rukovalac parnim turbinama,specijalizirani",
        "Rukovalac peći za cement",
        "Rukovalac peći za fritu",
        "Rukovalac peći za gips",
        "Rukovalac peći za kreč",
        "Rukovalac pećima za prerađivanje metala",
        "Rukovalac pilom za kamen",
        "Rukovalac plinskim turbinama",
        "Rukovalac plinskim turbinama,specijalizirani",
        "Rukovalac pokretnim parnim kotlovima",
        "Rukovalac pokretnim parnim kotlovima,specijalizirani",
        "Rukovalac pokretnom dizalicom",
        "Rukovalac pomičnim mostom",
        "Rukovalac pomoćne jamske mehanizacije",
        "Rukovalac pomoćnim knjigovezačkim mašinama",
        "Rukovalac pomoćnom mašinom u kartonaži",
        "Rukovalac pomoćnom štamparskom mašinom",
        "Rukovalac posebnim mašinama za šivanje odjeće",
        "Rukovalac postrojenja kondenzacije",
        "Rukovalac postrojenja kondenzacije, specijalizirani",
        "Rukovalac postrojenjem pri instrumentacijama u bušotini,specijalizirani",
        "Rukovalac postrojenjem pri kosom usmjerenom bušenju,specijalizirani",
        "Rukovalac postrojenjem za cementacije i stimulacije bušotina,specijalizirani",
        "Rukovalac postrojenjem za dobivanje glutena",
        "Rukovalac postrojenjem za dobivanje škrobnog sirupa",
        "Rukovalac postrojenjem za drobljenje rude i kamena",
        "Rukovalac postrojenjem za ekstrakciju šećera",
        "Rukovalac postrojenjem za farmaceutske proizvode,specijalizirani",
        "Rukovalac postrojenjem za filtriranje šećernog sirupa",
        "Rukovalac postrojenjem za hidratizaciju kreča",
        "Rukovalac postrojenjem za hidrološka bušenja",
        "Rukovalac postrojenjem za istraživanje bušotina,specijalizirani",
        "Rukovalac postrojenjem za izbjeljivanje, dimljenje i patiniranje drveta",
        "Rukovalac postrojenjem za izradu staklenih vlakana",
        "Rukovalac postrojenjem za karotažne radove,specijalizirani",
        "Rukovalac postrojenjem za kozmetičke proizvode,specijalizirani",
        "Rukovalac postrojenjem za kristalizaciju",
        "Rukovalac postrojenjem za mljevenje rude i kamena",
        "Rukovalac postrojenjem za nanošenje veznih slojeva na drvo",
        "Rukovalac postrojenjem za oplemenjivanje gasa,specijalizirani",
        "Rukovalac postrojenjem za oplemenjivanje mineralnih sirovina",
        "Rukovalac postrojenjem za peraća sredstva,specijalizirani",
        "Rukovalac postrojenjem za pranje cisterni",
        "Rukovalac postrojenjem za preradu meda",
        "Rukovalac postrojenjem za preradu mlijeka",
        "Rukovalac postrojenjem za pripremu bušotinskih fluida",
        "Rukovalac postrojenjem za pripremu kafe,kafovine,instanta i čajeva",
        "Rukovalac postrojenjem za pripremu keramičke mase",
        "Rukovalac postrojenjem za pripremu vode",
        "Rukovalac postrojenjem za pročišćavanje vode",
        "Rukovalac postrojenjem za proizvodnju duhanskih proizvoda",
        "Rukovalac postrojenjem za proizvodnju mliječne dječije hrane",
        "Rukovalac postrojenjem za proizvodnju piva",
        "Rukovalac postrojenjem za proizvodnju sirćeta",
        "Rukovalac postrojenjem za proizvodnju škrobnih derivata",
        "Rukovalac postrojenjem za protočna mjerenja u bušotini,specijalizirani",
        "Rukovalac postrojenjem za punjenje boca",
        "Rukovalac postrojenjem za punjenje boca tehničkim plinom",
        "Rukovalac postrojenjem za radove sa savitljivim tubingom u bušotini,specijalizirani",
        "Rukovalac postrojenjem za radove sa tekućim azotom u bušotini,specijalizirani",
        "Rukovalac postrojenjem za radove žicom i kablom u bušotini,specijalizirani",
        "Rukovalac postrojenjem za rafiniranje škroba",
        "Rukovalac postrojenjem za razvlaknjivanje drveta",
        "Rukovalac postrojenjem za rezanje šećerne repe",
        "Rukovalac postrojenjem za separaciju",
        "Rukovalac postrojenjem za separaciju škroba",
        "Rukovalac postrojenjem za spaljivanje otpadaka",
        "Rukovalac postrojenjem za steriliziranje uređaja i transportnih sredstava",
        "Rukovalac postrojenjem za sušenje šećera i rezanaca",
        "Rukovalac postrojenjem za tekući šećer",
        "Rukovalac postrojenjem za transport gasa",
        "Rukovalac postrojenjem za usitnjavanje hemikalija",
        "Rukovalac postrojenjem za ventilaciju i klimatizaciju",
        "Rukovalac postrojenjima u preradi nafte",
        "Rukovalac postrojenjima za preradu kafe,kakaoa,dodataka jelima i čajeva",
        "Rukovalac prehrambenim mašinama",
        "Rukovalac presom za metale",
        "Rukovalac presom za obljepljivanje rubova",
        "Rukovalac presom za polimere",
        "Rukovalac presom za sljepljivanje drvenih ploha",
        "Rukovalac presom za sljepljivanje drvenih vlakana",
        "Rukovalac presom za sljepljivanje iverja i ploča",
        "Rukovalac presom za sljepljivanje rubova drveta",
        "Rukovalac presom za utiskivanje ornamenata u drvo",
        "Rukovalac pretovarnim mašinama za beton",
        "Rukovalac procesnih linija za prerađivanje metala",
        "Rukovalac procesnih mašina i uređaja za dobijanje metala",
        "Rukovalac procesnih mašina za toplotnu obradu metala",
        "Rukovalac proizvodnim postrojenjem za naftu i gas,specijalizirani",
        "Rukovalac proizvodno-otpremnim postrojenjem za naftu i gas",
        "Rukovalac proizvodno-otpremnim sistemom za naftu i gas,specijalizirani",
        "Rukovalac pumpama",
        "Rukovalac pumpnih stanica,specijalizirani (osim nafte i prirodnog gasa)",
        "Rukovalac rashladnim postrojenjem",
        "Rukovalac rashladnim postrojenjem, specijalizirani",
        "Rukovalac reaktorskim postrojenjem za proizvodnju hemikalija",
        "Rukovalac rudarskim izvoznim postrojenjem",
        "Rukovalac rudarskim postrojenjem",
        "Rukovalac samopokretnom bušilicom",
        "Rukovalac separatorom za hemikalije",
        "Rukovalac silosnim uređajima",
        "Rukovalac sitima za hemikalije",
        "Rukovalac sitoštamparskom mašinom",
        "Rukovalac sjekaćicom kamena",
        "Rukovalac sterilizatorom",
        "Rukovalac sušarom za hemikalije",
        "Rukovalac šivaćim mašinama za tapetariju",
        "Rukovalac šivaćim poluautomatom i automatom",
        "Rukovalac šivaćom mašinom za kožnu galanteriju",
        "Rukovalac šivaćom mašinom za kožu",
        "Rukovalac šivaćom mašinom za obuću",
        "Rukovalac šivaćom mašinom za tekstil",
        "Rukovalac štamparskom mašinom",
        "Rukovalac tekstilnom presom",
        "Rukovalac tokarilicom metala",
        "Rukovalac topioničkim pećima",
        "Rukovalac tračnom pilom",
        "Rukovalac transportnim gasnim sistemom,specijalizirani",
        "Rukovalac transportnom trakom",
        "Rukovalac uklopnim postrojenjem",
        "Rukovalac uklopnim postrojenjem,specijalizirani",
        "Rukovalac urađejem za mješanje hemikalija",
        "Rukovalac uređajem za bojanje i lakiranje drveta",
        "Rukovalac uređajem za azbestnocementne proizvode",
        "Rukovalac uređajem za bitumensko-katranske proizvode",
        "Rukovalac uređajem za bruniranje",
        "Rukovalac uređajem za ekspandiranje polimera",
        "Rukovalac uređajem za elektrolizu",
        "Rukovalac uređajem za elektrozavarivanje",
        "Rukovalac uređajem za eloksiranje",
        "Rukovalac uređajem za fosfatiziranje metala",
        "Rukovalac uređajem za frakcijsku destilaciju drveta",
        "Rukovalac uređajem za gipsane ploče",
        "Rukovalac uređajem za granuliranje hemikalija",
        "Rukovalac uređajem za gumiranje",
        "Rukovalac uređajem za hidriranje pulpe",
        "Rukovalac uređajem za hlađenje mliječnih proizvoda",
        "Rukovalac uređajem za iskuhavanje drveta",
        "Rukovalac uređajem za izbjeljivanje celuloze",
        "Rukovalac uređajem za izradu betonskih građevinskih elemenata",
        "Rukovalac uređajem za izradu betonskih proizvoda",
        "Rukovalac uređajem za izradu fotografija",
        "Rukovalac uređajem za izradu metalne galanterije",
        "Rukovalac uređajem za izradu proizvoda od porobetona",
        "Rukovalac uređajem za izradu šibica",
        "Rukovalac uređajem za izradu žičanih mreža i tkanina",
        "Rukovalac uređajem za kalciniranje",
        "Rukovalac uređajem za karotažne radove",
        "Rukovalac uređajem za klimatiziranje i otvrdnjavanje površine drveta",
        "Rukovalac uređajem za kondicioniranje drveta",
        "Rukovalac uređajem za kuhanje hemikalija",
        "Rukovalac uređajem za lijevanje polimera",
        "Rukovalac uređajem za mješanje betona",
        "Rukovalac uređajem za obradu mlijeka",
        "Rukovalac uređajem za odmašćivanje metala",
        "Rukovalac uređajem za otapanje hemikalija",
        "Rukovalac uređajem za pasterizaciju mliječnih proizvoda",
        "Rukovalac uređajem za pasterizaciju mlijeka",
        "Rukovalac uređajem za pirotehničke proizvode",
        "Rukovalac uređajem za pjeskarenje metala",
        "Rukovalac uređajem za plastificiranje metala",
        "Rukovalac uređajem za poliranje metala",
        "Rukovalac uređajem za pranje vozila",
        "Rukovalac uređajem za premazivanje metala",
        "Rukovalac uređajem za preradu duhana",
        "Rukovalac uređajem za preradu gumenih proizvoda",
        "Rukovalac uređajem za preradu otpadnog luga",
        "Rukovalac uređajem za preradu plastike",
        "Rukovalac uređajem za pripremu glazure",
        "Rukovalac uređajem za pripremu ljepila za papir",
        "Rukovalac uređajem za pripremu papirne mase",
        "Rukovalac uređajem za pripremu smjese za šibice",
        "Rukovalac uređajem za proizvode iz polimernog betona",
        "Rukovalac uređajem za proizvodnju eksploziva",
        "Rukovalac uređajem za proizvodnju fotografskih filmova",
        "Rukovalac uređajem za proizvodnju fotografskih ploča",
        "Rukovalac uređajem za proizvodnju fotografskih proizvoda",
        "Rukovalac uređajem za proizvodnju fotohemikalija",
        "Rukovalac uređajem za proizvodnju linoleuma",
        "Rukovalac uređajem za proizvodnju olovaka",
        "Rukovalac uređajem za proizvodnju silicijskih ploča",
        "Rukovalac uređajem za proizvodnju streljiva",
        "Rukovalac uređajem za proizvodnju streljiva,specijalizirani",
        "Rukovalac uređajem za proizvodnju svijeća",
        "Rukovalac uređajem za proizvodnju školskog pribora",
        "Rukovalac uređajem za prosijavanje,razvrstavanje i natresanje drveta",
        "Rukovalac uređajem za razvijanje filmova",
        "Rukovalac uređajem za rezanje plamenom",
        "Rukovalac uređajem za sačmarenje metala",
        "Rukovalac uređajem za sastavljanje kliznih zatvarača",
        "Rukovalac uređajem za savijanje drveta",
        "Rukovalac uređajem za sintezu hemikalija",
        "Rukovalac uređajem za suhu destilaciju drveta",
        "Rukovalac uređajem za uranjanje metala",
        "Rukovalac uređajem za vulkaniziranje",
        "Rukovalac uređajem za zavarivanje plamenom",
        "Rukovalac uređajima brane",
        "Rukovalac uređajima na palubi platforme",
        "Rukovalac uređajima u hemigrafiji",
        "Rukovalac uređajima u reprofotografiji",
        "Rukovalac uređajima u slovoljevaonici",
        "Rukovalac uređajima za cementacije i stimulacije u bušotini",
        "Rukovalac uređajima za izradu kobasica",
        "Rukovalac uređajima za izvlačenje žice",
        "Rukovalac uređajima za obradu ječma i slada",
        "Rukovalac uređajima za obradu mesa",
        "Rukovalac uređajima za obradu ribe",
        "Rukovalac uređajima za oplemenjivanje gasa",
        "Rukovalac uređajima za pripremu stakla",
        "Rukovalac uređajima za proizvodnju alkohola",
        "Rukovalac uređajima za proizvodnju bezalkoholnih pića",
        "Rukovalac uređajima za proizvodnju elektroda",
        "Rukovalac uređajima za proizvodnju gasa",
        "Rukovalac uređajima za proizvodnju jakih alkoholnih pića",
        "Rukovalac uređajima za proizvodnju kvasca",
        "Rukovalac uređajima za proizvodnju nafte i gasa",
        "Rukovalac uređajima za proizvodnju pića",
        "Rukovalac uređajima za proizvodnju vina",
        "Rukovalac uređajima za sterilizaciju mesnih i ribljih konzervi",
        "Rukovalac uređajima za steriliziranje konzervi voća i povrća",
        "Rukovalac uređajima za sušenje voća i povrća",
        "Rukovalac uređajima za utovar tekućeg gasa",
        "Rukovalac uređajima za zamrzavanje mesa i ribe",
        "Rukovalac uređajima za zamrzavanje voća i povrća",
        "Rukovalac uspinjačom",
        "Rukovalac vagom",
        "Rukovalac viljuškarom",
        "Rukovalac višefaznim mašinama za drvo",
        "Rukovalac višefaznom mašinom za guljenje,pilenje,iveranje",
        "Rukovalac višefazom mašinom za obradu drveta i spajanje rubova",
        "Rukovalac vitlom",
        "Rukovalac vodnim turbinama",
        "Rukovalac vodnim turbinama,specijalizirani",
        "Rukovalac za dodavanje financijskih markica",
        "Rukovalac za izradu pozamenterije",
        "Rukovalac za obilježavanje robe",
        "Rukovalac za toplo oblikovanje polimera",
        "Rukovalac žičarom",
        "Rukovodilac vladinog ureda",
        "Rukovodilac finansijskih poslova",
        "Rukovodilac gradnje",
        "Rukovodilac kadrovskih poslova",
        "Rukovodilac knjigovodstvenih poslova",
        "Rukovodilac općih i pravnih poslova",
        "Rukovodilac poslova pretovara",
        "Rukovodilac poslovnice nabave i prodaje",
        "Rukovodilac protokola",
        "Rukovodilac računovodstva i finansija",
        "Rukovodilac službe za zaštitu",
        "Rukovodilac špeditersko-agencijskih poslova",
        "Rukоvоdilаc grаdilištа",
        "Sakristan",
        "Sakupljač i naplaćivač dugova",
        "Saldakontist",
        "Samaraš",
        "Samostalni bibliotečki istraživač",
        "Samostalni informacijski istraživač",
        "Samostalni istražitelj kriminalist",
        "Samostalni istražitelj kriminolog",
        "Samostalni istraživač antropolog",
        "Samostalni istraživač arheolog",
        "Samostalni istraživač arhivistike",
        "Samostalni istraživač biologije",
        "Samostalni istraživač biotehnologije",
        "Samostalni istraživač brodograđevinarstva",
        "Samostalni istraživač ekonomskih nauka",
        "Samostalni istraživač elektronike, telekomunikacija i automatike",
        "Samostalni istraživač etnolog",
        "Samostalni istraživač filozofije",
        "Samostalni istraživač geodezije",
        "Samostalni istraživač geograf",
        "Samostalni istraživač građevinarstva",
        "Samostalni istraživač grafičke tehnologije",
        "Samostalni istraživač hemijske tehnologije",
        "Samostalni istraživač historije",
        "Samostalni istraživač komunikolog",
        "Samostalni istraživač mašinstva",
        "Samostalni istraživač metalurgije",
        "Samostalni istraživač meteorologije",
        "Samostalni istraživač politologije",
        "Samostalni istraživač pravnih nauka",
        "Samostalni istraživač računarstva",
        "Samostalni istraživač rudarstva",
        "Samostalni istraživač sociolog",
        "Samostalni istraživač tekstilne tehnologije",
        "Samostalni istraživač u agronomiji",
        "Samostalni istraživač u šumarstvu",
        "Samostalni istraživač umjetnosti",
        "Samostalni istraživač urbanizma",
        "Samostalni istraživač vaspitnih nauka",
        "Samostalni istraživač veterine",
        "Samostalni istraživač za elektroenergetiku i elektromašinstvo",
        "Samostalni prognostičar vremena",
        "Samostalni računovođa",
        "Samostalni stručni saradnik u poslovnim i srodnim djelatnostima",
        "Sanitarni inspektor",
        "Sanitarni inženjer",
        "Sanitarni tehničar",
        "Saobraćajni disponent",
        "Saobraćajni policajac",
        "Saobraćajni tehničar",
        "Saradnik prevodioca za francuski jezik",
        "Saradnik prevodioca za francuski jezik sa poznavanjem arapskog jezika",
        "Saradnik prevodioca za francuski jezik sa poznavanjem latinskog jezika",
        "Saradnik prevodioca za njemački jezik",
        "Saradnik prevodioca za njemački jezik sa poznavanjem arapskog jezika",
        "Saradnik prevodioca za njemački jezik sa poznavanjem latinskog jezika",
        "Saradnik prevodioca za ruski jezik",
        "Saradnik prevodioca za ruski jezik sa poznavanjem arapskog jezika",
        "Saradnik prevodioca za ruski jezik sa poznavanjem latinskog jezika",
        "Saradnik (pomoćnik) stručnjaka za specijalno vaspitanje i obrazovanje",
        "Saradnik (pomoćnik) u nastavi u osnovnoj školi",
        "Saradnik (pomoćnik) vaspitača predškolske djece",
        "Saradnik prevodioca za engleski jezik",
        "Saradnik prevodioca za engleski jezik sa poznavanjem arapskog jezika",
        "Saradnik prevodioca za engleski jezik sa poznavanjem latinskog jezika",
        "Saradnik za analiziranje i planiranje proizvodnih procesa",
        "Saradnik za logistiku",
        "Saradnik za organizaciju posla",
        "Sastavljač akumulatora",
        "Sastavljač aparata za domaćinstvo",
        "Sastavljač baterija",
        "Sastavljač dizalica",
        "Sastavljač drvenih proizvoda",
        "Sastavljač električnih mjernih instrumenata i sklopova",
        "Sastavljač elektroinstalacijskog materijala",
        "Sastavljač elektromehaničkih komponenti i sklopova",
        "Sastavljač elektromotora",
        "Sastavljač elektronske opreme",
        "Sastavljač elektronskih sklopova",
        "Sastavljač elektrožičanih snopova",
        "Sastavljač građevinske stolarije",
        "Sastavljač gumenih proizvoda",
        "Sastavljač kartonskih proizvoda",
        "Sastavljač kožnih proizvoda",
        "Sastavljač malih transformatora",
        "Sastavljač mašina",
        "Sastavljač mašinskih pribora",
        "Sastavljač metalnih proizvoda",
        "Sastavljač metalnog namještaja",
        "Sastavljač motora",
        "Sastavljač naočala",
        "Sastavljač papirnatih proizvoda",
        "Sastavljač parnih kotlova",
        "Sastavljač parnih turbina",
        "Sastavljač plastičnih proizvoda",
        "Sastavljač plinskih turbina",
        "Sastavljač proizvoda od različitih materijala",
        "Sastavljač računarske opreme",
        "Sastavljač rasvjetnih tijela",
        "Sastavljač sijalica",
        "Sastavljač streljiva, specijalizirani",
        "Sastavljač štampanih ploča",
        "Sastavljač tekstilnih proizvoda",
        "Sastavljač telefonskog aparata",
        "Sastavljač telekomunikacijske opreme",
        "Sastavljač vozila",
        "Satiričar",
        "Savijač drveta u kalupu",
        "Savjetnik direktora",
        "Savjetnik kantonalnog suda",
        "Savjetnik komore",
        "Savjetnik ministra",
        "Savjetnik općinskog suda",
        "Savjetnik predsjednika političke stranke",
        "Savjetnik socijalne pomoći",
        "Savjetnik u vaspitno obrazovnom zavodu",
        "Savjetnik vrhovnog suda",
        "Savjetnik za ekonomiku domaćinstva",
        "Savjetnik za istraživanje tržišta",
        "Savjetnik za kulturno-umjetničke programe",
        "Savjetnik za nekretnine",
        "Savjetnik za obrazovanje osoba sa posebnim potrebama",
        "Savjetnik za odbranu",
        "Savjetnik za odbranu i sigurnost",
        "Savjetnik za odnose sa javnosti",
        "Savjetnik za osobnu i poslovnu uspješnost",
        "Savjetnik za patente",
        "Savjetnik za poduzetništvo",
        "Savjetnik za poslovanje",
        "Savjetnik za predmetno područje",
        "Savjetnik za predškolsko vaspitanje",
        "Savjetnik za prodajne metode",
        "Savjetnik za prodaju",
        "Savjetnik za profesionalno informiranje",
        "Savjetnik za promotivne metode",
        "Savjetnik za proračune",
        "Savjetnik za razrednu nastavu",
        "Savjetnik za studentska pitanja",
        "Savjetnik za veterinarstvo",
        "Savjetnik za zapošljavanje",
        "Savjetnik za zaštitu životne sredine",
        "Savjetnik za zdravstveno osiguranje",
        "Savjetnik za zdravstvo",
        "Savjetnik zemljišno-informacijskog sistema",
        "Scenarist",
        "Scenograf",
        "Scenski dizajner",
        "Scenski tehničar",
        "Seizmolog",
        "Sekretar diplomatsko konzularnog predstavništva",
        "Sekretar društva",
        "Sekretar gradskog vijeća",
        "Sekretar humanitarne organizacije",
        "Sekretar kabineta funkcionera",
        "Sekretar komore",
        "Sekretar ministarstva",
        "Sekretar mjesnog ureda",
        "Sekretar okružnog tužilaštva",
        "Sekretar općinskog vijeća",
        "Sekretar organizacije",
        "Sekretar parlamenta / skupštine",
        "Sekretar političke stranke",
        "Sekretar poslovne interesne organizacije",
        "Sekretar pravobranilaštva",
        "Sekretar preduzeća",
        "Sekretar radnog tijela parlamenta / skupštine",
        "Sekretar radnog tijela vlade",
        "Sekretar republičkog tužilaštva",
        "Sekretar sindikata",
        "Sekretar Skupštine grada",
        "Sekretar Skupštine kantona",
        "Sekretar Skupštine opštine",
        "Sekretar ustanove",
        "Sekretar Vlade entiteta",
        "Sekretarica",
        "Servis ortopedskih i drugih zdravstvenih pomagala",
        "Serviser dijamantnih pila",
        "Serviser električnih aparata i opreme",
        "Serviser elektronskih uređaja i opreme",
        "Serviser muzičkih instrumenata",
        "Serviser optičke opreme",
        "Serviser plinskih uređaja",
        "Serviser plinskih uređaja,specijalizirani",
        "Serviser preciznih naprava i opreme",
        "Serviser ručnog alata",
        "Serviser ručnog alata,specijalizirani",
        "Serviser sportske opreme",
        "Serviser šivaćih mašina",
        "Serviser šivaćih mašina,majstor",
        "Serviser terminalskih aparata kod pretplatnika",
        "Serviser uređaja za točenje goriva",
        "Serviser uređaja za točenje goriva,specijalizirani",
        "Serviser vatrogasnih aparata",
        "Sinđel",
        "Sirar",
        "Sirar, industrijski",
        "Sistem inženjer",
        "Sistem programer",
        "Sitoštampar",
        "Sjekač šiba i trske",
        "Sjemenar",
        "Skelar",
        "Skiper",
        "Skladišni dispečer",
        "Skladišni manipulant",
        "Skladišni radnik",
        "Skladišni službenik",
        "Skladištar",
        "Skladištar alata",
        "Skretničar",
        "Skupljač priloga za dobrotvorne svrhe",
        "Sladoledar",
        "Slagač na računskom terminalu",
        "Slastičar",
        "Slastičar,majstor",
        "Slavista",
        "Slikar",
        "Slikar crtanog filma",
        "Slikar grafičar",
        "Slikar naivac",
        "Slikar proizvedene robe",
        "Slikar vozila",
        "Slovoslagač",
        "Službenik deviznog poslovanja",
        "Službenik kadrovskih poslova",
        "Službenik lučke kapetanije",
        "Službenik nabave",
        "Službenik obračuna plaća",
        "Službenik općih poslova",
        "Službenik platnog prometa",
        "Službenik prodaje",
        "Službenik protokola",
        "Službenik u agenciji za platni promet na šalteru",
        "Službenik u distribuciji",
        "Službenik u knjigovodstvu",
        "Službenik za administrativno-tehničke poslove",
        "Službenik za bankomatsku mrežu",
        "Službenik za informacije",
        "Službenik za izračunavanje",
        "Službenik za kopiranje dokumenata",
        "Službenik za likvidaciju naknada",
        "Službenik za organizaciju putovanja",
        "Službenik za osiguranje",
        "Službenik za posredništvo sa nekretninama",
        "Službenik za vrijednosne papire",
        "Službenik zbirnog prometa",
        "Službеnik infоrmisаnjа u zdrаvstvu",
        "Službеnik mеdicinskоg оsigurаnjа",
        "Službеnik оbаvеštајno-sigurnosne službе",
        "Smećar",
        "Smjenovođa u TE",
        "Snimatelj slike",
        "Snimatelj slike i zvuka",
        "Snimatelj trika",
        "Snimatelj vremena i pokreta",
        "Snimatelj zvuka",
        "Sobarica",
        "Soboslikar i moler",
        "Soboslikar i moler,majstor",
        "Socijalni pedagog",
        "Socijalni radnik",
        "Socijalni radnik u centru",
        "Socijalni radnik u domu",
        "Socijalni radnik u obrazovanju",
        "Socijalni radnik u pravosuđu",
        "Socijalni radnik u zdravstvu",
        "Socijalni radnik za ostvarivanje prava",
        "Socijalni radnik za rad sa hendikepiranim osobama",
        "Socijalni radnik za rad sa materijalno ugroženim osobama",
        "Socijalni stručnjak",
        "Socijalni stručnjak u centru",
        "Socijalni stručnjak u domu",
        "Socijalni stručnjak u obrazovanju",
        "Socijalni stručnjak u pravosuđu",
        "Socijalni stručnjak u zdravstvu",
        "Socijalni stručnjak za rad sa hendikepiranim osobama",
        "Socijalni stručnjak za rad sa materijalno ugroženim osobama",
        "Sociolog",
        "Softwer inženjer",
        "Sokolar",
        "Solanski radnik",
        "Solo pjevač",
        "SOS majka",
        "SOS teta",
        "Spajač elektrotehničkih elemenata",
        "Spasilac iz požara",
        "Spasilac iz vode",
        "Speleološki vodič",
        "Spiker",
        "Splavar",
        "Sportista",
        "Sportski direktor",
        "Sportski psiholog",
        "Sportski sudac",
        "Sportski trener",
        "Sportski vodič",
        "Srmar",
        "Staklar",
        "Staklarski poslovođa",
        "Staklobrusač",
        "Stakloduvač",
        "Stakloduvač,specijalizirani",
        "Staklorezac",
        "Staratelj",
        "Stariji vodnik",
        "Stariji vodnik I. klase",
        "Statista",
        "Statističar",
        "Statističar demograf",
        "Statističar istraživač",
        "Statističar matematičar",
        "Statističar metodolog",
        "Statističar samostalni istraživač",
        "Statistički službenik",
        "Stečajni upravnik",
        "Stenodaktilograf",
        "Stenograf",
        "Stilar,dekorni i umjetnički majstor",
        "Stjuard / stjuardesa na aerodromu",
        "Stjuard / stjuardesa na brodu",
        "Stjuard / stjuardesa u avionu",
        "Stočar",
        "Stočarski poslovođa",
        "Stočarski radnik",
        "Stočarski tehničar",
        "Stolar",
        "Stolar stilskog namještaja",
        "Stolar za scensku opremu",
        "Stolar za scensku opremu,specijalizirani",
        "Stolar za šablone",
        "Stolar,dekorni i umjetnički",
        "Stolar,majstor",
        "Stolar,ortopedski",
        "Stolar,ortopedski specijalizirani",
        "Stolar,specijalizirani za izradu šablona i prototipova",
        "Stomatološka sestra",
        "Stražar",
        "Stražar u zatvoru",
        "Stručna bаbica",
        "Stručni saradnik (asistent) za finansijske planove i analize",
        "Stručni saradnik (asistent) za proračune i prikaze u osiguranju",
        "Stručni saradnik (asistent) za računovodstvene proračune i prikaze",
        "Stručni saradnik (asistent) za statističke proračune i prikaze",
        "Stručni saradnik kontonalnog suda",
        "Stručni saradnik općinskog suda",
        "Stručni saradnik u pravosudnim organima",
        "Stručni saradnik vrhovnog suda",
        "Stručni saradnik za analitičko-planske poslove",
        "Stručni saradnik za imovinsko-pravne poslove",
        "Stručni saradnik za kadrovske poslove",
        "Stručni saradnik za normativne poslove",
        "Stručni saradnik za poslove javnih nabavki",
        "Stručni saradnik za rad sa mladima",
        "Stručnjak za metodiku u obrazovnim područjima",
        "Stručnjak za obrazovne tehnologije",
        "Stručnjak za razvoj vaspitno-obrazovnog programa",
        "Stručnjak za strateško planiranje",
        "Stručnjak za upravljanje energijom i vodom",
        "Stručnjak za upravljanje otpadom",
        "Stručnjak za zdravstvenu njegu",
        "Stučni saradnik za likvidaciju računa i naknada",
        "Stučni saradnik-instruktor za kontrolu obračuna i naplate",
        "Stučni saradnik-instruktor za računovodstvene poslove",
        "Sudija kantonalnog - oblasnog suda",
        "Sudija okružnog suda",
        "Sudija općinskog suda",
        "Sudija prekršajnog suda",
        "Sudija Ustavnog suda na nivou države",
        "Sudija Ustavnog suda na nivou entiteta",
        "Sudija Vrhovnog suda",
        "Sudski tumač",
        "Sudski zapisničar",
        "Sufler",
        "Sušilac duvana",
        "Sušitelj drveta",
        "Svećenik",
        "Svjetioničar",
        "Šalterski službenik putničke agencije",
        "Šalterski službenik zalagaonice",
        "Šef kuhinje",
        "Šef željezničkoga saobraćaja",
        "Šeširdžija",
        "Šeširdžija, majstor",
        "Šifrant",
        "Šinter",
        "Šivač",
        "Šivač gornjih dijelova obuće",
        "Šivač kože",
        "Šivač krzna",
        "Šivač krzna i kože",
        "Šivač lake konfekcije",
        "Šivač podstave obuće",
        "Šivač tekstila",
        "Šivač teške konfekcije",
        "Školski inspektor",
        "Školski laborant",
        "Školski psiholog",
        "Špediter",
        "Špediterski carinski deklarant",
        "Špeditersko-agencijski službenik",
        "Štampar",
        "Štampar na metalu",
        "Štampar na plastici",
        "Štampar na tekstilu",
        "Štampar višebojnih otisaka u štampi",
        "Štamparski graver,specijalizirani",
        "Štamper nijanser štamparskih boja",
        "Štamper probnih otisaka",
        "Štamper višebojnih otisaka",
        "Štamper višebojnih otisaka u bakroštampi",
        "Štamper višebojnih otisaka u fleksoštampi",
        "Štamper višebojnih otisaka u knjigoštampi",
        "Štamper višebojnih otisaka u ofsetu",
        "Štimer harmonike",
        "Štimer klavira",
        "Štukater",
        "Šumarski inspektor",
        "Šumarski radnik",
        "Šumarski tehničar",
        "Šumski mjerač drveta",
        "Šumski poslovođa",
        "Šumski putar",
        "Šumski radnik na destilaciji drveta tradicionalnom tehnikom",
        "Šumski rasadničar",
        "Šumski sjekač",
        "Šumski traktorist",
        "Šumski uzgajivač",
        "Šаltеrski službеnik zа priјеm zahtjevа",
        "Tapetar",
        "Tapetar dekorater",
        "Tapetar namještaja",
        "Tapetar vozila",
        "Tapetar, majstor",
        "Tapetarski tehničar",
        "Tarifer",
        "Tehničar agrohemikalija",
        "Tehničar analize namirnica",
        "Tehničar bitumensko katranskih proizvoda",
        "Tehničar boja i lakova",
        "Tehničar celuloze",
        "Tehničar dijetetske proizvodnje",
        "Tehničar drumskog saobraćaja",
        "Tehničar elektrohemijskih sistema",
        "Tehničar elektroničar za računare",
        "Tehničar elektronike",
        "Tehničar elektronike za mjerne i upravljačke uređaje",
        "Tehničar elektronike za signalno-zaštitne uređaje",
        "Tehničar farmaceutskih proizvoda",
        "Tehničar farmaceutskih sistema",
        "Tehničar finalne prerade drveta",
        "Tehničar fizikalni",
        "Tehničar fotografskih proizvoda",
        "Tehničar geoelektričnih mjerenja",
        "Tehničar geofizičkog istraživanja ležišta",
        "Tehničar geološkog istraživanja ležišta",
        "Tehničar grafičke dorade",
        "Tehničar grafički urednik",
        "Tehničar gumarstva",
        "Tehničar hemigrafije i reprofotografije",
        "Tehničar hidraulike i pneumatike",
        "Теhničаr hitnе mеdicinske pоmоći",
        "Tehničar interpretacije geofizičkih podataka",
        "Tehničar keramike",
        "Tehničar konditorske proizvodnje",
        "Tehničar konstruktor alatnih mašina",
        "Tehničar konstruktor aparata za domaćinstvo",
        "Tehničar konstruktor brodskih mašina",
        "Tehničar konstruktor cjevovoda",
        "Tehničar konstruktor cjevovoda i armature",
        "Tehničar konstruktor dijelova metalnih konstrukcija",
        "Tehničar konstruktor dijelova plovnih sredstava",
        "Tehničar konstruktor dijelova proizvoda precizne mehanike",
        "Tehničar konstruktor dijelova pružnih vozila",
        "Tehničar konstruktor dijelova uređaja i kalupa",
        "Tehničar konstruktor dizalica",
        "Tehničar konstruktor drumskih vozila",
        "Tehničar konstruktor električnih proizvoda",
        "Tehničar konstruktor elektronskih proizvoda",
        "Tehničar konstruktor energetskoelektronskih uređaja",
        "Tehničar konstruktor gasne mreže",
        "Tehničar konstruktor klasičnog naoružanja",
        "Tehničar konstruktor limenih dijelova",
        "Tehničar konstruktor mašina za građevinarstvo i industrijski transport",
        "Tehničar konstruktor mašinskih dijelova",
        "Tehničar konstruktor plovnih sredstava",
        "Tehničar konstruktor poljoprivrednih mašina",
        "Tehničar konstruktor posuda pod pritiskom",
        "Tehničar konstruktor procesne opreme",
        "Tehničar konstruktor proizvoda precizne mehanike",
        "Tehničar konstruktor pumpi i kompresora",
        "Tehničar konstruktor rashladnih uređaja",
        "Tehničar konstruktor složenih alata i uređaja",
        "Tehničar konstruktor šinskih vozila",
        "Tehničar konstruktor šivaćih mašina",
        "Tehničar konstruktor tekstilnih mašina",
        "Tehničar konstruktor telekomunikacijskih uređaja",
        "Tehničar konstruktor turbina",
        "Tehničar konstruktor uređaja za zavarivanje",
        "Tehničar kozmetičkih proizvoda",
        "Tehničar laboratorijske kontrole",
        "Tehničar laboratorijskog ispitivanja stijena",
        "Tehničar lijevanja crne metalurgije",
        "Tehničar lijevanja obojenih metala",
        "Tehničar logistike i špedicije",
        "Tehničar mašinski konstruktor",
        "Tehničar mašinski konstruktor detaljist",
        "Tehničar matematički",
        "Теhničаr mеdicinskih dоsiјеа",
        "Tehničar mehatronike",
        "Tehničar metalurgije",
        "Tehničar mlinarstva i prerade brašna",
        "Tehničar obrade geofizičkih podataka",
        "Tehničar obrade kamena",
        "Tehničar okeanografije",
        "Tehničar papirske tehnologije",
        "Tehničar pigmenata",
        "Tehničar pletenja",
        "Tehničar polimera",
        "Tehničar poštanskog saobraćaja",
        "Tehničar predenja",
        "Tehničar preparator životinja i biljaka",
        "Tehničar prerade duhana",
        "Tehničar prerade kave, kavovina i čajeva",
        "Tehničar prerade mesa i ribe",
        "Tehničar prerade polimera",
        "Tehničar prerade voća, povrća i sokova",
        "Tehničar pripreme i obrade vode",
        "Теhničаr prоcеsа rаfinisаnjа",
        "Tehničar proizvodnje biljnih ulja",
        "Tehničar proizvodnje crne metalurgije",
        "Tehničar proizvodnje enzima",
        "Tehničar proizvodnje jakih alkoholnih pića",
        "Tehničar proizvodnje obojenih metala",
        "Tehničar proizvodnje piva",
        "Tehničar proizvodnje stočne hrane",
        "Tehničar proizvodnje šećera",
        "Tehničar proizvodnje škroba",
        "Tehničar proizvodnje vina",
        "Tehničar proizvodnje voda i gaziranih napitaka",
        "Tehničar prostornog planiranja",
        "Tehničar radioloških sistema",
        "Tehničar robota",
        "Tehničar rudarski mjernik",
        "Tehničar savjetodavac za dijetnu ishranu",
        "Tehničar savjetodavac za zdravu ishranu",
        "Tehničar seizmičkih mjerenja",
        "Tehničar sredstava za pranje",
        "Tehničar staklarstva",
        "Tehničar tiska",
        "Tehničar tkanja",
        "Tehničar unutrašnjeg transporta",
        "Tehničar vojno hemijskih sistema",
        "Tehničar vojnohemijskih proizvoda",
        "Tehničar vuče",
        "Tehničar za brodske telekomunikacije",
        "Tehničar za drvo",
        "Tehničar za eksploataciju kamena",
        "Tehničar za elektronske proizvode",
        "Tehničar za elektrotehniku",
        "Tehničar za emajle i glazure",
        "Tehničar za energetskoelektronske uređaje",
        "Tehničar za gradnju plovnih sredstava",
        "Tehničar za građevinske materijale",
        "Tehničar za izgradnju sabirnih sistema za naftu i plin",
        "Tehničar za izvođenje programa",
        "Tehničar za kožarstvo",
        "Tehničar za kožnu galanteriju",
        "Tehničar za medicinske elektronske uređaje",
        "Tehničar za mehatroniku",
        "Tehničar za mjerenja nafte i plina",
        "Tehničar za obradu deformacijom",
        "Tehničar za obradu odvajanjem čestica",
        "Tehničar za obuću",
        "Tehničar za odjeću",
        "Tehničar za održavanje elektrotehničkih proizvoda",
        "Tehničar za održavanje programa",
        "Tehničar za održavanje pruga",
        "Tehničar za organske sinteze",
        "Tehničar za ortopednu tehniku",
        "Tehničar za podvodnu opremu na bušaćoj platformi",
        "Tehničar za pomoć korisniku",
        "Tehničar za pretovar",
        "Tehničar za procesnu automatiku",
        "Tehničar za programiranje",
        "Tehničar za proizvodnju elektrotehničkih proizvoda",
        "Tehničar za proizvodnju leća",
        "Tehničar za proizvodnju nafte i plina",
        "Tehničar za proizvodnju soli",
        "Tehničar za računsku tehniku i automatiku",
        "Tehničar za radio i televizijske uređaje",
        "Tehničar za razradu naftnih i plinskih ležišta",
        "Tehničar za razvijanje",
        "Tehničar za sigurnost na radu",
        "Tehničar za sigurnost saobraćaja",
        "Tehničar za sigurnost vazduhoplovnog saobraćaja",
        "Tehničar za sistemsku programsku opremu",
        "Tehničar za tehnologiju saobraćaja",
        "Tehničar za telekomunikacije",
        "Tehničar za telekomunikacijske uređaje i mreže",
        "Tehničar za transport plina",
        "Tehničar za uređaje vazduhoplovne elektronike",
        "Tehničar za vazduhoplovne telekomunikacije",
        "Tehničar za zavarivanje",
        "Tehničar za zubnu protetiku",
        "Tehničar za zvučne efekte",
        "Tehničar za željezničke telekomunikacije",
        "Tehničar zaštite bilja",
        "Tehničar zaštite od korozije",
        "Tehnički crtač",
        "Tehnički crtač za arheologiju",
        "Tehnički crtač za arhitekturu",
        "Tehnički crtač za brodogradnju",
        "Tehnički crtač za elektrotehniku",
        "Tehnički crtač za geodeziju",
        "Tehnički crtač za građevinarstvo",
        "Tehnički crtač za mašinstvo",
        "Tehnički direktor u termoelektrani",
        "Tehnički ilustrator",
        "Tehnički kalkulant",
        "Tehnički kontrolor drumskih vozila",
        "Tehnički kontrolor tramvaja",
        "Tehnički kontrolor vozila",
        "Tehnički pisac",
        "Tehnički saradnik za zaštitu okoline",
        "Tehnički zastupnik prodaje",
        "Tehnički zastupnik za prodaju informacione opreme",
        "Tehnički zastupnik za prodaju komunikacijske opreme",
        "Tehnolog - tehničar",
        "Tehnolog agrohemikalija",
        "Tehnolog automatike i elektrotehnike",
        "Tehnolog boja i lakova",
        "Tehnolog celuloze",
        "Tehnolog elektrotehnike",
        "Tehnolog famaceutskih proizvoda",
        "Tehnolog građevinskog održavanja",
        "Tehnolog gumarstva",
        "Tehnolog konditorske proizvodnje",
        "Tehnolog kotlovskih postrojenja u TE",
        "Tehnolog kozmetičkih proizvoda",
        "Tehnolog lijevanja i valjanja obojenih metala",
        "Tehnolog mašinskog održavanja energetskih postrojenja u TE",
        "Tehnolog mlinarstva i prerade brašna",
        "Tehnolog obrade otpadnih voda",
        "Tehnolog održavanja cjevovodne mreže",
        "Tehnolog održavanja gasne mreže",
        "Tehnolog održavanja rudarske opreme",
        "Tehnolog pakovanja",
        "Tehnolog papirnih proizvoda",
        "Tehnolog peradarstva",
        "Tehnolog pigmenata",
        "Tehnolog prerade duhana",
        "Tehnolog prerade mesa i ribe",
        "Tehnolog prerade mlijeka i mliječnih proizvoda",
        "Tehnolog prerade polimera",
        "Tehnolog prerade voća, povrća i bezalkoholnih pića",
        "Tehnolog presovanja obojenih metala",
        "Tehnolog pripreme i obrade vode",
        "Tehnolog proizvodnje biljnih ulja i masti",
        "Tehnolog proizvodnje crne metalurgije",
        "Tehnolog proizvodnje enzima",
        "Tehnolog proizvodnje gotove hrane",
        "Tehnolog proizvodnje obojenih metala",
        "Tehnolog proizvodnje piva",
        "Tehnolog proizvodnje soli",
        "Tehnolog proizvodnje stočne hrane",
        "Tehnolog proizvodnje šećera, skroba i derivata",
        "Tehnolog proizvodnje vina, alkohola i sirćeta",
        "Tehnolog proizvodnje vitamina i hormona",
        "Tehnolog ribarstva",
        "Tehnolog sredstava za pranje i čišćenje",
        "Tehnolog stočarstva",
        "Tehnolog školskog pribora",
        "Tehnolog tekstila",
        "Tehnolog telekomunikacija",
        "Tehnolog vojnohemijskih sistema",
        "Tehnolog za fotografske proizvode",
        "Tehnolog za građevinske materijale",
        "Tehnolog za keramiku",
        "Tehnolog za organske sinteze",
        "Tehnolog za preciznu optiku",
        "Tehnolog za proizvodni proces u TE",
        "Tehnolog za promet",
        "Tehnolog za staklarstvo",
        "Tehnolog zaštite od korozije",
        "Tekstilni inženjer",
        "Tekstilni inženjer - tehnolog konfekcije",
        "Tekstilni predradnik",
        "Tekstilni tehničar",
        "Tekstilni tehničar - konfekcionar",
        "Tekstilni tehničar hemijsko - oplemenjivačkog smjera",
        "Tekstilni tehničar mašinskog smjera tkač, predioničar, pletač",
        "Tekstilni tehničar modelar - konstruktor",
        "Tekstilnohemijski tehničar",
        "Telefaksist",
        "Telefonist",
        "Telefonist za međunarodne veze",
        "Telegrafist",
        "Teleprinterist",
        "Teolog",
        "Teracer",
        "Terapeut za govor i gluhoću",
        "Terapeut za poremećaje vida",
        "Termoizolater",
        "Termotehničar",
        "Tesar",
        "Tesar - parketar",
        "Tesar - parketar,majstor",
        "Tesar krovopokrivač",
        "Tesar,majstor",
        "Tesarski radnik",
        "Tetovirač",
        "Timaritelj u zoološkom vrtu",
        "Tipomašinist",
        "Tipomašinist, specijalizirani",
        "Tjelohranitelj",
        "Tjesteninar",
        "Tkač",
        "Tkač ćilima",
        "Tkač, predioničar, pletač",
        "Točilac pića",
        "Toksikolog",
        "Torbar",
        "Torbar, prodavač",
        "Torbar,specijalizirani",
        "Tornjaš",
        "Transportni agent",
        "Тrаvаr",
        "Treći oficir palube",
        "Treći oficir stroja",
        "Trener konja",
        "Trezorist",
        "Trgovački poslovođa",
        "Trgovački putnik",
        "Tržni inspektor",
        "Tumač za jezike",
        "Turistički animator",
        "Turistički pratioci",
        "Turistički vodič",
        "Turističko hotelijerski tehničar",
        "Turizmolog",
        "Tužilac",
        "TV mehaničar",
        "Učitelj djece sa razvojnim teškoćama",
        "Učitelj mentalno retardiranih osoba",
        "Učitelj muzike",
        "Učitelj osoba s oštećenjem sluha",
        "Učitelj osoba s oštećenjem vida",
        "Učitelj osoba s poremećajima u ponašanju",
        "Učitelj predškolske djece",
        "Učitelj predškolske djece sa posebnim potrebama",
        "Učitelj tjelesno invalidnih osoba",
        "Ugljar",
        "Ugostiteljska domaćica / domaćin",
        "Ugostiteljski poslastičar",
        "Ugostiteljski poslovođa",
        "Ugostiteljski tehničar",
        "Ulični piljаr",
        "Ulični prodavač drugih proizvoda",
        "Ulični prodavač hrane i pića",
        "Umjetnički model",
        "Umjetnički stvaralac",
        "Univerzitetski asistent agronomije",
        "Univerzitetski asistent arheologije",
        "Univerzitetski asistent arhitekture i urbanizma",
        "Univerzitetski asistent astronomije",
        "Univerzitetski asistent biologije",
        "Univerzitetski asistent biotehničkih nauka",
        "Univerzitetski asistent biotehnologije i prehrambene tehnologije",
        "Univerzitetski asistent defektologije",
        "Univerzitetski asistent dizajna",
        "Univerzitetski asistent društveno-humanističkih nauka",
        "Univerzitetski asistent ekonomije",
        "Univerzitetski asistent elektrotehnike",
        "Univerzitetski asistent etnologije",
        "Univerzitetski asistent farmacije",
        "Univerzitetski asistent filologije",
        "Univerzitetski asistent filozofije",
        "Univerzitetski asistent fizike",
        "Univerzitetski asistent geodezije",
        "Univerzitetski asistent geofizike",
        "Univerzitetski asistent geografije",
        "Univerzitetski asistent geologije",
        "Univerzitetski asistent građevinarstva",
        "Univerzitetski asistent grafičke tehnologije",
        "Univerzitetski asistent hemije",
        "Univerzitetski asistent hemijskog inženjerstva i tehnologije",
        "Univerzitetski asistent historije",
        "Univerzitetski asistent informacijskih nauka",
        "Univerzitetski asistent kineziologije",
        "Univerzitetski asistent kriminalistike",
        "Univerzitetski asistent likovnih umjetnosti",
        "Univerzitetski asistent mašinstva",
        "Univerzitetski asistent matematike",
        "Univerzitetski asistent medicine",
        "Univerzitetski asistent medicinske biohemije",
        "Univerzitetski asistent mehanike",
        "Univerzitetski asistent metalurgije",
        "Univerzitetski asistent muzičkih umjetnosti",
        "Univerzitetski asistent organizacijskih nauka",
        "Univerzitetski asistent pedagogije",
        "Univerzitetski asistent politologije",
        "Univerzitetski asistent prava",
        "Univerzitetski asistent primjenjenih umjetnosti",
        "Univerzitetski asistent prirodnih nauka",
        "Univerzitetski asistent psihologije",
        "Univerzitetski asistent računarstva",
        "Univerzitetski asistent rudarstva",
        "Univerzitetski asistent saobraćaja",
        "Univerzitetski asistent scenskih umjetnosti",
        "Univerzitetski asistent socijalnog rada",
        "Univerzitetski asistent sociologije",
        "Univerzitetski asistent stomatologije",
        "Univerzitetski asistent šumarstva",
        "Univerzitetski asistent tehničko -tehnoloških nauka",
        "Univerzitetski asistent tehnologije drva",
        "Univerzitetski asistent tekstilne tehnologije",
        "Univerzitetski asistent teologije",
        "Univerzitetski asistent ugostiteljstva i turizma",
        "Univerzitetski asistent veterine",
        "Univerzitetski asistent zaštite na radu",
        "Univerzitetski profesor agronomije",
        "Univerzitetski profesor arheologije",
        "Univerzitetski profesor arhitekture i urbanizma",
        "Univerzitetski profesor astronomije",
        "Univerzitetski profesor biologije",
        "Univerzitetski profesor biotehničkih nauka",
        "Univerzitetski profesor biotehnologije i prehrambene tehnologije",
        "Univerzitetski profesor defektologije",
        "Univerzitetski profesor dizajna",
        "Univerzitetski profesor društveno-humanističkih nauka",
        "Univerzitetski profesor ekonomije",
        "Univerzitetski profesor elektrotehnike",
        "Univerzitetski profesor etnologije",
        "Univerzitetski profesor farmacije",
        "Univerzitetski profesor filologije",
        "Univerzitetski profesor filozofije",
        "Univerzitetski profesor fizike",
        "Univerzitetski profesor geodezije",
        "Univerzitetski profesor geofizike",
        "Univerzitetski profesor geografije",
        "Univerzitetski profesor geologije",
        "Univerzitetski profesor građevinarstva",
        "Univerzitetski profesor grafičke tehnologije",
        "Univerzitetski profesor hemije",
        "Univerzitetski profesor hemijskog inženjerstva i tehnologije",
        "Univerzitetski profesor historije",
        "Univerzitetski profesor informacijskih nauka",
        "Univerzitetski profesor kineziologije",
        "Univerzitetski profesor kriminalistike",
        "Univerzitetski profesor likovnih umjetnosti",
        "Univerzitetski profesor mašinstva",
        "Univerzitetski profesor matematike",
        "Univerzitetski profesor medicine",
        "Univerzitetski profesor medicinske biohemije",
        "Univerzitetski profesor mehanike",
        "Univerzitetski profesor metalurgije",
        "Univerzitetski profesor muzičkih umjetnosti",
        "Univerzitetski profesor organizacijskih nauka",
        "Univerzitetski profesor pedagogije",
        "Univerzitetski profesor politologije",
        "Univerzitetski profesor prava",
        "Univerzitetski profesor primjenjenih umjetnosti",
        "Univerzitetski profesor prirodnih nauka",
        "Univerzitetski profesor psihologije",
        "Univerzitetski profesor računarstva",
        "Univerzitetski profesor rudarstva",
        "Univerzitetski profesor saobraćaja",
        "Univerzitetski profesor scenskih umjetnosti",
        "Univerzitetski profesor socijalnog rada",
        "Univerzitetski profesor sociologije",
        "Univerzitetski profesor stomatologije",
        "Univerzitetski profesor šumarstva",
        "Univerzitetski profesor tehničko-tehnoloških nauka",
        "Univerzitetski profesor tehnologije drva",
        "Univerzitetski profesor tekstilne tehnologije",
        "Univerzitetski profesor teologije",
        "Univerzitetski profesor ugostiteljstva i turizma",
        "Univerzitetski profesor veterine",
        "Univerzitetski profesor zaštite na radu",
        "Upravitelj stroja",
        "Upravitelj stroja unutrašnje plovidbe",
        "Upravni inspektor",
        "Upravni organizator",
        "Upravni pravnik",
        "Upravni savjetnik",
        "Upravni službenik",
        "Upravni službenik za dozvole i isprave",
        "Upravnik / upravnica domaćinstva",
        "Upravnik zatvora",
        "Urar za popravak i održavanja satova",
        "Urar, u proizvodnji satova",
        "Urbanistički inspektor",
        "Urednik novinar",
        "Uređivač polica",
        "Utovarivač otpada",
        "Uzgajivač divljači",
        "Uzgajivač glista",
        "Uzgajivač gljiva",
        "Uzgajivač goveda",
        "Uzgajivač konja",
        "Uzgajivač koza",
        "Uzgajivač kunića za meso",
        "Uzgajivač laboratorijskih životinja",
        "Uzgajivač ljekovitog bilja",
        "Uzgajivač mačaka",
        "Uzgajivač ostalih životinja",
        "Uzgajivač ovaca",
        "Uzgajivač pasa",
        "Uzgajivač pernate šumske divljači",
        "Uzgajivač ptica",
        "Uzgajivač puževa",
        "Uzgajivač ribe",
        "Uzgajivač ribe i školjki",
        "Uzgajivač ribljih larvi i žive hrane",
        "Uzgajivač svilene bube",
        "Uzgajivač svinja",
        "Uzgajivač šumske dlakave divljači",
        "Uzgajivač ukrasnih riba",
        "Uzgajivač žaba",
        "Uzgajivač životinja za krzno",
        "Uzgajivači nojeva",
        "Užar i izrađivač vrpci",
        "Valjač plemenitih metala",
        "Vaspitač",
        "Vaspitač u učeničkom domu",
        "Vatrogasac",
        "Vatrogasni tehničar",
        "Vatrogasni tehničar,specijalista",
        "Vazduhoplovni otpravnik",
        "Veterinar",
        "Veterinar na poslovima kvaliteta i higijene namjernica životinjskog porijekla",
        "Veterinar epizootiolog",
        "Veterinar hirurg",
        "Veterinar internist",
        "Veterinar kućnih ljubimaca",
        "Veterinar mikrobiolog",
        "Veterinar na poslovima deratizacije, dezinsekcije i dezinfekcije",
        "Veterinar opšte prakse",
        "Veterinar parazitolog",
        "Veterinar specijalizant",
        "Veterinar tehnolog u animalnoj proizvodnji",
        "Veterinar za reprodukciju životinja",
        "Veterinar za zdravstvenu zaštitu životinja",
        "Veterinarski bolničar",
        "Veterinarski inspektor",
        "Veterinarski laboratorijski tehničar",
        "Veterinarski tehničar",
        "Veterinarski tehničar za pelcovanje životinja",
        "Veterinarski tehničar za poslove deratizacije, dezinsekcije i dezinfekcije",
        "Veterinarski tehničar za trihinoskopiju",
        "Veterinarski tehničar za vještačko osjemenjavanje",
        "Vezilac",
        "Vicekonzul",
        "Videotehničar",
        "Videotekar",
        "Vijećnik gradskog vijeća",
        "Vijećnik općinskog vijeća",
        "Vinogradar",
        "Vinogradarski poslovođa",
        "Vinogradarski tehničar",
        "Vinogradski radnik",
        "Vinski savjetodavac",
        "Visoki čelnik institucije drugdje nerazvrstan",
        "Visoki funkcioner institucije drugdje nerazvrstan",
        "Viša medicinska sestra i zdravstveni tehničar",
        "Viši fizioterapeut",
        "Viši radiološki tehničar",
        "Viši sanitarni tehničar",
        "Viši upravni savjetnik",
        "Vjeroučitelj u osnovnoj školi",
        "Vladika",
        "Voćar",
        "Voćar - vinogradar",
        "Voćarski poslovođa",
        "Voćarski radnik",
        "Voćarski tehničar",
        "Vodič",
        "Voditelj distributivnih poslova",
        "Voditelj matičnog ureda",
        "Voditelj plovnog sistema jahti",
        "Voditelj poslova obezbjeđenja",
        "Voditelj poslovnice nabave",
        "Voditelj poslovnice prodaje",
        "Voditelj rudarskog katastra",
        "Voditelj skladišnog poslovanja",
        "Voditelj sportske rekreacije",
        "Voditelj sportskih aktivnosti djece i omladine",
        "Voditelj u programu",
        "Vodnik",
        "Vodograditelj",
        "Vodoinstalater",
        "Vodoinstalater i plinoinstalater",
        "Vođa benda",
        "Vođa hidroloških radova",
        "Vođa knjigovodstva",
        "Vođa krojačnice",
        "Vođa malog plovećeg radnog stroja",
        "Vođa palube",
        "Vođa palube na platformi",
        "Vođa palube unutarnje plovidbe",
        "Vođa plovećeg radnog stroja",
        "Vođa posade marine",
        "Vođa poslovnog voza",
        "Vođa recepcije",
        "Vođa skladišta",
        "Vođa smjene na bušaćem postrojenju",
        "Vođa smjene na postrojenju za remont bušotina",
        "Vođa smjene vatrogasne jedinice",
        "Vođa straže",
        "Vođa stroja",
        "Vođa stroja unutarnje plovidbe",
        "Vojni psiholog",
        "Vojnik",
        "Vojnik I. klase",
        "Vozač autobusa",
        "Vozač automješalice",
        "Vozač cisterne",
        "Vozač električnih paletnih kolica",
        "Vozač furgona",
        "Vozač hitne pomoći",
        "Vozač hladnjače",
        "Vozač kamiona",
        "Vozač kamiona s dizalicom",
        "Vozač kombibusa",
        "Vozač kontejnerskog prijenosnika",
        "Vozač kontejnerskog trajlera",
        "Vozač lakih motornih vozila",
        "Vozač lakog dostavnog vozila",
        "Vozač mašina za asfaltiranje",
        "Vozač mašina za bušenje i razbijanje",
        "Vozač mašina za čišćenje kanalizacije",
        "Vozač mašina za čišćenje saobraćajnica",
        "Vozač mašina za injektiranje tla",
        "Vozač mašina za iskop",
        "Vozač mašina za nabijanje tla",
        "Vozač mašina za stabilizaciju tla",
        "Vozač mašina za ugradnju betonskih ivičnjaka",
        "Vozač mašina za zabijanje pilota",
        "Vozač mašine za zemljane radove",
        "Vozač motocikla",
        "Vozač motornih pružnih vozila",
        "Vozač motornih vozila",
        "Vozač opasnih materija",
        "Vozač pokretne dizalice",
        "Vozač poljoprivrednih mašina",
        "Vozač posebnih teretnih vozila",
        "Vozač putničkog automobila",
        "Vozač ručnih kolica",
        "Vozač skele",
        "Vozač šlepera",
        "Vozač šlepera sa poluprikolicom",
        "Vozač taksija",
        "Vozač taksija na vodi",
        "Vozač teretnog viljuškara",
        "Vozač teretnog vozila",
        "Vozač teretnog vozila sa prikolicom",
        "Vozač teške šumske mehanizacije",
        "Vozač teških notornih vozila,majstor",
        "Vozač teškog traktora",
        "Vozač tramvaja",
        "Vozač tricikla",
        "Vozač trolejbusa",
        "Vozački instruktor",
        "Vozni manipulant",
        "Vratar,razvodnik",
        "Vrtlar",
        "Vrtlar za nasade",
        "Vrtlar za parkove",
        "Vrtlar,specijalizirani",
        "Vrtlarski poslovođa",
        "Vrtlarski radnik",
        "Vrtlarski tehničar",
        "Vulkanizer",
        "Vunovlačar",
        "Web site tеhničаr",
        "Zajmodavac",
        "Zamjenik direktora inspektorata",
        "Zamjenik direktora kazneno - popravnog zavoda",
        "Zamjenik direktora uprave",
        "Zamjenik direktora upravne organizacije",
        "Zamjenik glavnog republičkog tužioca",
        "Zamjenik glavnog revizora",
        "Zamjenik glavnog revizora Ureda za reviziju FBIH",
        "Zamjenik gradonačelnika",
        "Zamjenik ministra u Vijeću ministara BiH",
        "Zamjenik ministra u Vladi FBiH",
        "Zamjenik načelnika",
        "Zamjenik pravobranioca BiH",
        "Zamjenik predsjedavajućeg /potpredsjednik doma parlamenta /skupštine entiteta",
        "Zamjenik predsjedavajućeg Doma naroda Parlamentarne skupštine BiH",
        "Zamjenik predsjedavajućeg gradskog vijeća",
        "Zamjenik predsjedavajućeg kantonalne skupštine",
        "Zamjenik predsjedavajućeg općinskog vijeća",
        "Zamjenik predsjedavajućeg Predstavničkog doma Parlamentarne skupštine BiH",
        "Zamjenik predsjedavajućeg Vijeća ministara BiH",
        "Zapovijednik broda",
        "Zapovijednik broda unutrašnje plovidbe",
        "Zapovijednik bušaće platforme",
        "Zastakljivač",
        "Zastakljivač vozila",
        "Zastavnik",
        "Zastavnik I. klase",
        "Zastupnik osiguranja",
        "Zastupnik za trgovinu",
        "Zastupnik za zapošljavanje",
        "Zavarivač",
        "Zavarivač plinom",
        "Zavarivač za zavarivanje u zaštićenim atmosferama",
        "Zavarivač,specijalizirani",
        "Zdravstveni inspektor",
        "Zemljoradnik",
        "Zidar",
        "Zidar - fasader - izolater",
        "Zidar - fasader - izolater, majstor",
        "Zidar dimnjaka",
        "Zidar dimnjaka,specijalizirani",
        "Zidar i betonirac",
        "Zidar i tesar",
        "Zidar kamenom",
        "Zidar kamenom,specijalizirani",
        "Zidar šamoter",
        "Zidar šamoter,specijalizirani",
        "Zidar za popločavanje trotoara i ulica",
        "Zidar za spomenike od kamena",
        "Zidar, majstor",
        "Zidarski poslovođa",
        "Zidarski radnik",
        "Zlatar",
        "Zlatar - draguljar",
        "Zlatarski poslovođa",
        "Zoolog",
        "Zoološki tehničar",
        "Zubotehničar",
        "Zubozdravstveni asistent",
        "Zvonar",
        "Željeznički otpravnik",
        "Željeznički robno-putnički blagajnik",
        "Željeznički transportni radnik",
        "Željezničko - saobraćajni tehničar",
        "Živoder",
        "Žongler",
        "Župni asistent",
        "Župnik",
    ]
