# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""

# Module `PySide6.QtNetwork`

import PySide6.QtNetwork
import PySide6.QtCore

import enum
from typing import Any, Callable, ClassVar, Dict, List, Optional, OrderedDict, Sequence, Tuple, Union, overload
from PySide6.QtCore import Signal
from shiboken6 import Shiboken


NoneType = type(None)


class QAbstractNetworkCache(PySide6.QtCore.QObject):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def cacheSize(self) -> int: ...
    def clear(self) -> None: ...
    def data(self, url: Union[PySide6.QtCore.QUrl, str]) -> PySide6.QtCore.QIODevice: ...
    def insert(self, device: PySide6.QtCore.QIODevice) -> None: ...
    def metaData(self, url: Union[PySide6.QtCore.QUrl, str]) -> PySide6.QtNetwork.QNetworkCacheMetaData: ...
    def prepare(self, metaData: PySide6.QtNetwork.QNetworkCacheMetaData) -> PySide6.QtCore.QIODevice: ...
    def remove(self, url: Union[PySide6.QtCore.QUrl, str]) -> bool: ...
    def updateMetaData(self, metaData: PySide6.QtNetwork.QNetworkCacheMetaData) -> None: ...


class QAbstractSocket(PySide6.QtCore.QIODevice):

    connected                : ClassVar[Signal] = ... # connected()
    disconnected             : ClassVar[Signal] = ... # disconnected()
    errorOccurred            : ClassVar[Signal] = ... # errorOccurred(QAbstractSocket::SocketError)
    hostFound                : ClassVar[Signal] = ... # hostFound()
    proxyAuthenticationRequired: ClassVar[Signal] = ... # proxyAuthenticationRequired(QNetworkProxy,QAuthenticator*)
    stateChanged             : ClassVar[Signal] = ... # stateChanged(QAbstractSocket::SocketState)

    class BindFlag(enum.Flag):

        DefaultForPlatform       : QAbstractSocket.BindFlag = ... # 0x0
        ShareAddress             : QAbstractSocket.BindFlag = ... # 0x1
        DontShareAddress         : QAbstractSocket.BindFlag = ... # 0x2
        ReuseAddressHint         : QAbstractSocket.BindFlag = ... # 0x4

    class NetworkLayerProtocol(enum.Enum):

        UnknownNetworkLayerProtocol: QAbstractSocket.NetworkLayerProtocol = ... # -0x1
        IPv4Protocol             : QAbstractSocket.NetworkLayerProtocol = ... # 0x0
        IPv6Protocol             : QAbstractSocket.NetworkLayerProtocol = ... # 0x1
        AnyIPProtocol            : QAbstractSocket.NetworkLayerProtocol = ... # 0x2

    class PauseMode(enum.Flag):

        PauseNever               : QAbstractSocket.PauseMode = ... # 0x0
        PauseOnSslErrors         : QAbstractSocket.PauseMode = ... # 0x1

    class SocketError(enum.Enum):

        UnknownSocketError       : QAbstractSocket.SocketError = ... # -0x1
        ConnectionRefusedError   : QAbstractSocket.SocketError = ... # 0x0
        RemoteHostClosedError    : QAbstractSocket.SocketError = ... # 0x1
        HostNotFoundError        : QAbstractSocket.SocketError = ... # 0x2
        SocketAccessError        : QAbstractSocket.SocketError = ... # 0x3
        SocketResourceError      : QAbstractSocket.SocketError = ... # 0x4
        SocketTimeoutError       : QAbstractSocket.SocketError = ... # 0x5
        DatagramTooLargeError    : QAbstractSocket.SocketError = ... # 0x6
        NetworkError             : QAbstractSocket.SocketError = ... # 0x7
        AddressInUseError        : QAbstractSocket.SocketError = ... # 0x8
        SocketAddressNotAvailableError: QAbstractSocket.SocketError = ... # 0x9
        UnsupportedSocketOperationError: QAbstractSocket.SocketError = ... # 0xa
        UnfinishedSocketOperationError: QAbstractSocket.SocketError = ... # 0xb
        ProxyAuthenticationRequiredError: QAbstractSocket.SocketError = ... # 0xc
        SslHandshakeFailedError  : QAbstractSocket.SocketError = ... # 0xd
        ProxyConnectionRefusedError: QAbstractSocket.SocketError = ... # 0xe
        ProxyConnectionClosedError: QAbstractSocket.SocketError = ... # 0xf
        ProxyConnectionTimeoutError: QAbstractSocket.SocketError = ... # 0x10
        ProxyNotFoundError       : QAbstractSocket.SocketError = ... # 0x11
        ProxyProtocolError       : QAbstractSocket.SocketError = ... # 0x12
        OperationError           : QAbstractSocket.SocketError = ... # 0x13
        SslInternalError         : QAbstractSocket.SocketError = ... # 0x14
        SslInvalidUserDataError  : QAbstractSocket.SocketError = ... # 0x15
        TemporaryError           : QAbstractSocket.SocketError = ... # 0x16

    class SocketOption(enum.Enum):

        LowDelayOption           : QAbstractSocket.SocketOption = ... # 0x0
        KeepAliveOption          : QAbstractSocket.SocketOption = ... # 0x1
        MulticastTtlOption       : QAbstractSocket.SocketOption = ... # 0x2
        MulticastLoopbackOption  : QAbstractSocket.SocketOption = ... # 0x3
        TypeOfServiceOption      : QAbstractSocket.SocketOption = ... # 0x4
        SendBufferSizeSocketOption: QAbstractSocket.SocketOption = ... # 0x5
        ReceiveBufferSizeSocketOption: QAbstractSocket.SocketOption = ... # 0x6
        PathMtuSocketOption      : QAbstractSocket.SocketOption = ... # 0x7

    class SocketState(enum.Enum):

        UnconnectedState         : QAbstractSocket.SocketState = ... # 0x0
        HostLookupState          : QAbstractSocket.SocketState = ... # 0x1
        ConnectingState          : QAbstractSocket.SocketState = ... # 0x2
        ConnectedState           : QAbstractSocket.SocketState = ... # 0x3
        BoundState               : QAbstractSocket.SocketState = ... # 0x4
        ListeningState           : QAbstractSocket.SocketState = ... # 0x5
        ClosingState             : QAbstractSocket.SocketState = ... # 0x6

    class SocketType(enum.Enum):

        UnknownSocketType        : QAbstractSocket.SocketType = ... # -0x1
        TcpSocket                : QAbstractSocket.SocketType = ... # 0x0
        UdpSocket                : QAbstractSocket.SocketType = ... # 0x1
        SctpSocket               : QAbstractSocket.SocketType = ... # 0x2


    def __init__(self, socketType: PySide6.QtNetwork.QAbstractSocket.SocketType, parent: PySide6.QtCore.QObject) -> None: ...

    def abort(self) -> None: ...
    @overload
    def bind(self, address: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], port: int = ..., mode: PySide6.QtNetwork.QAbstractSocket.BindFlag = ...) -> bool: ...
    @overload
    def bind(self, port: int = ..., mode: PySide6.QtNetwork.QAbstractSocket.BindFlag = ...) -> bool: ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def close(self) -> None: ...
    @overload
    def connectToHost(self, address: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], port: int, mode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ...) -> None: ...
    @overload
    def connectToHost(self, hostName: str, port: int, mode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ..., protocol: PySide6.QtNetwork.QAbstractSocket.NetworkLayerProtocol = ...) -> None: ...
    def disconnectFromHost(self) -> None: ...
    def error(self) -> PySide6.QtNetwork.QAbstractSocket.SocketError: ...
    def flush(self) -> bool: ...
    def isSequential(self) -> bool: ...
    def isValid(self) -> bool: ...
    def localAddress(self) -> PySide6.QtNetwork.QHostAddress: ...
    def localPort(self) -> int: ...
    def pauseMode(self) -> PySide6.QtNetwork.QAbstractSocket.PauseMode: ...
    def peerAddress(self) -> PySide6.QtNetwork.QHostAddress: ...
    def peerName(self) -> str: ...
    def peerPort(self) -> int: ...
    def protocolTag(self) -> str: ...
    def proxy(self) -> PySide6.QtNetwork.QNetworkProxy: ...
    def readBufferSize(self) -> int: ...
    def readData(self, maxlen: int) -> object: ...
    def readLineData(self, maxlen: int) -> object: ...
    def resume(self) -> None: ...
    def setLocalAddress(self, address: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress]) -> None: ...
    def setLocalPort(self, port: int) -> None: ...
    def setPauseMode(self, pauseMode: PySide6.QtNetwork.QAbstractSocket.PauseMode) -> None: ...
    def setPeerAddress(self, address: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress]) -> None: ...
    def setPeerName(self, name: str) -> None: ...
    def setPeerPort(self, port: int) -> None: ...
    def setProtocolTag(self, tag: str) -> None: ...
    def setProxy(self, networkProxy: Union[PySide6.QtNetwork.QNetworkProxy, PySide6.QtNetwork.QNetworkProxy.ProxyType]) -> None: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def setSocketDescriptor(self, socketDescriptor: int, state: PySide6.QtNetwork.QAbstractSocket.SocketState = ..., openMode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ...) -> bool: ...
    def setSocketError(self, socketError: PySide6.QtNetwork.QAbstractSocket.SocketError) -> None: ...
    def setSocketOption(self, option: PySide6.QtNetwork.QAbstractSocket.SocketOption, value: Any) -> None: ...
    def setSocketState(self, state: PySide6.QtNetwork.QAbstractSocket.SocketState) -> None: ...
    def skipData(self, maxSize: int) -> int: ...
    def socketDescriptor(self) -> int: ...
    def socketOption(self, option: PySide6.QtNetwork.QAbstractSocket.SocketOption) -> Any: ...
    def socketType(self) -> PySide6.QtNetwork.QAbstractSocket.SocketType: ...
    def state(self) -> PySide6.QtNetwork.QAbstractSocket.SocketState: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def waitForConnected(self, msecs: int = ...) -> bool: ...
    def waitForDisconnected(self, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def writeData(self, data: Union[bytes, bytearray, memoryview], len: int) -> int: ...


class QAuthenticator(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QAuthenticator) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def isNull(self) -> bool: ...
    def option(self, opt: str) -> Any: ...
    def options(self) -> Dict[str, Any]: ...
    def password(self) -> str: ...
    def realm(self) -> str: ...
    def setOption(self, opt: str, value: Any) -> None: ...
    def setPassword(self, password: str) -> None: ...
    def setRealm(self, realm: str) -> None: ...
    def setUser(self, user: str) -> None: ...
    def user(self) -> str: ...


class QDnsDomainNameRecord(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QDnsDomainNameRecord) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def name(self) -> str: ...
    def swap(self, other: PySide6.QtNetwork.QDnsDomainNameRecord) -> None: ...
    def timeToLive(self) -> int: ...
    def value(self) -> str: ...


class QDnsHostAddressRecord(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QDnsHostAddressRecord) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def name(self) -> str: ...
    def swap(self, other: PySide6.QtNetwork.QDnsHostAddressRecord) -> None: ...
    def timeToLive(self) -> int: ...
    def value(self) -> PySide6.QtNetwork.QHostAddress: ...


class QDnsLookup(PySide6.QtCore.QObject):

    finished                 : ClassVar[Signal] = ... # finished()
    nameChanged              : ClassVar[Signal] = ... # nameChanged(QString)
    nameserverChanged        : ClassVar[Signal] = ... # nameserverChanged(QHostAddress)
    nameserverPortChanged    : ClassVar[Signal] = ... # nameserverPortChanged(ushort)
    typeChanged              : ClassVar[Signal] = ... # typeChanged(Type)

    class Error(enum.Enum):

        NoError                  : QDnsLookup.Error = ... # 0x0
        ResolverError            : QDnsLookup.Error = ... # 0x1
        OperationCancelledError  : QDnsLookup.Error = ... # 0x2
        InvalidRequestError      : QDnsLookup.Error = ... # 0x3
        InvalidReplyError        : QDnsLookup.Error = ... # 0x4
        ServerFailureError       : QDnsLookup.Error = ... # 0x5
        ServerRefusedError       : QDnsLookup.Error = ... # 0x6
        NotFoundError            : QDnsLookup.Error = ... # 0x7
        TimeoutError             : QDnsLookup.Error = ... # 0x8

    class Type(enum.Enum):

        A                        : QDnsLookup.Type = ... # 0x1
        NS                       : QDnsLookup.Type = ... # 0x2
        CNAME                    : QDnsLookup.Type = ... # 0x5
        PTR                      : QDnsLookup.Type = ... # 0xc
        MX                       : QDnsLookup.Type = ... # 0xf
        TXT                      : QDnsLookup.Type = ... # 0x10
        AAAA                     : QDnsLookup.Type = ... # 0x1c
        SRV                      : QDnsLookup.Type = ... # 0x21
        ANY                      : QDnsLookup.Type = ... # 0xff


    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtNetwork.QDnsLookup.Type, name: str, nameserver: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtNetwork.QDnsLookup.Type, name: str, nameserver: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], port: int, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtNetwork.QDnsLookup.Type, name: str, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def abort(self) -> None: ...
    def canonicalNameRecords(self) -> List[PySide6.QtNetwork.QDnsDomainNameRecord]: ...
    def error(self) -> PySide6.QtNetwork.QDnsLookup.Error: ...
    def errorString(self) -> str: ...
    def hostAddressRecords(self) -> List[PySide6.QtNetwork.QDnsHostAddressRecord]: ...
    def isFinished(self) -> bool: ...
    def lookup(self) -> None: ...
    def mailExchangeRecords(self) -> List[PySide6.QtNetwork.QDnsMailExchangeRecord]: ...
    def name(self) -> str: ...
    def nameServerRecords(self) -> List[PySide6.QtNetwork.QDnsDomainNameRecord]: ...
    def nameserver(self) -> PySide6.QtNetwork.QHostAddress: ...
    def nameserverPort(self) -> int: ...
    def pointerRecords(self) -> List[PySide6.QtNetwork.QDnsDomainNameRecord]: ...
    def serviceRecords(self) -> List[PySide6.QtNetwork.QDnsServiceRecord]: ...
    def setName(self, name: str) -> None: ...
    @overload
    def setNameserver(self, nameserver: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress]) -> None: ...
    @overload
    def setNameserver(self, nameserver: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], port: int) -> None: ...
    def setNameserverPort(self, port: int) -> None: ...
    def setType(self, arg__1: PySide6.QtNetwork.QDnsLookup.Type) -> None: ...
    def textRecords(self) -> List[PySide6.QtNetwork.QDnsTextRecord]: ...
    def type(self) -> PySide6.QtNetwork.QDnsLookup.Type: ...


class QDnsMailExchangeRecord(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QDnsMailExchangeRecord) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def exchange(self) -> str: ...
    def name(self) -> str: ...
    def preference(self) -> int: ...
    def swap(self, other: PySide6.QtNetwork.QDnsMailExchangeRecord) -> None: ...
    def timeToLive(self) -> int: ...


class QDnsServiceRecord(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QDnsServiceRecord) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def name(self) -> str: ...
    def port(self) -> int: ...
    def priority(self) -> int: ...
    def swap(self, other: PySide6.QtNetwork.QDnsServiceRecord) -> None: ...
    def target(self) -> str: ...
    def timeToLive(self) -> int: ...
    def weight(self) -> int: ...


class QDnsTextRecord(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QDnsTextRecord) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def name(self) -> str: ...
    def swap(self, other: PySide6.QtNetwork.QDnsTextRecord) -> None: ...
    def timeToLive(self) -> int: ...
    def values(self) -> List[PySide6.QtCore.QByteArray]: ...


class QDtls(PySide6.QtCore.QObject):

    handshakeTimeout         : ClassVar[Signal] = ... # handshakeTimeout()
    pskRequired              : ClassVar[Signal] = ... # pskRequired(QSslPreSharedKeyAuthenticator*)

    class HandshakeState(enum.Enum):

        HandshakeNotStarted      : QDtls.HandshakeState = ... # 0x0
        HandshakeInProgress      : QDtls.HandshakeState = ... # 0x1
        PeerVerificationFailed   : QDtls.HandshakeState = ... # 0x2
        HandshakeComplete        : QDtls.HandshakeState = ... # 0x3


    def __init__(self, mode: PySide6.QtNetwork.QSslSocket.SslMode, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def abortHandshake(self, socket: PySide6.QtNetwork.QUdpSocket) -> bool: ...
    def decryptDatagram(self, socket: PySide6.QtNetwork.QUdpSocket, dgram: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> PySide6.QtCore.QByteArray: ...
    def doHandshake(self, socket: PySide6.QtNetwork.QUdpSocket, dgram: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview] = ...) -> bool: ...
    def dtlsConfiguration(self) -> PySide6.QtNetwork.QSslConfiguration: ...
    def dtlsError(self) -> PySide6.QtNetwork.QDtlsError: ...
    def dtlsErrorString(self) -> str: ...
    def handleTimeout(self, socket: PySide6.QtNetwork.QUdpSocket) -> bool: ...
    def handshakeState(self) -> PySide6.QtNetwork.QDtls.HandshakeState: ...
    def ignoreVerificationErrors(self, errorsToIgnore: Sequence[PySide6.QtNetwork.QSslError]) -> None: ...
    def isConnectionEncrypted(self) -> bool: ...
    def mtuHint(self) -> int: ...
    def peerAddress(self) -> PySide6.QtNetwork.QHostAddress: ...
    def peerPort(self) -> int: ...
    def peerVerificationErrors(self) -> List[PySide6.QtNetwork.QSslError]: ...
    def peerVerificationName(self) -> str: ...
    def resumeHandshake(self, socket: PySide6.QtNetwork.QUdpSocket) -> bool: ...
    def sessionCipher(self) -> PySide6.QtNetwork.QSslCipher: ...
    def sessionProtocol(self) -> PySide6.QtNetwork.QSsl.SslProtocol: ...
    def setDtlsConfiguration(self, configuration: PySide6.QtNetwork.QSslConfiguration) -> bool: ...
    def setMtuHint(self, mtuHint: int) -> None: ...
    def setPeer(self, address: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], port: int, verificationName: str = ...) -> bool: ...
    def setPeerVerificationName(self, name: str) -> bool: ...
    def shutdown(self, socket: PySide6.QtNetwork.QUdpSocket) -> bool: ...
    def sslMode(self) -> PySide6.QtNetwork.QSslSocket.SslMode: ...
    def writeDatagramEncrypted(self, socket: PySide6.QtNetwork.QUdpSocket, dgram: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> int: ...


class QDtlsClientVerifier(PySide6.QtCore.QObject):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def dtlsError(self) -> PySide6.QtNetwork.QDtlsError: ...
    def dtlsErrorString(self) -> str: ...
    def verifiedHello(self) -> PySide6.QtCore.QByteArray: ...
    def verifyClient(self, socket: PySide6.QtNetwork.QUdpSocket, dgram: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], address: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], port: int) -> bool: ...


class QDtlsError(enum.Enum):

    NoError                  : QDtlsError = ... # 0x0
    InvalidInputParameters   : QDtlsError = ... # 0x1
    InvalidOperation         : QDtlsError = ... # 0x2
    UnderlyingSocketError    : QDtlsError = ... # 0x3
    RemoteClosedConnectionError: QDtlsError = ... # 0x4
    PeerVerificationError    : QDtlsError = ... # 0x5
    TlsInitializationError   : QDtlsError = ... # 0x6
    TlsFatalError            : QDtlsError = ... # 0x7
    TlsNonFatalError         : QDtlsError = ... # 0x8


class QHostAddress(Shiboken.Object):

    UnknownNetworkLayerProtocol: QAbstractSocket.NetworkLayerProtocol = ... # -0x1
    IPv4Protocol             : QAbstractSocket.NetworkLayerProtocol = ... # 0x0
    IPv6Protocol             : QAbstractSocket.NetworkLayerProtocol = ... # 0x1
    AnyIPProtocol            : QAbstractSocket.NetworkLayerProtocol = ... # 0x2

    class ConversionModeFlag(enum.Flag):

        StrictConversion         : QHostAddress.ConversionModeFlag = ... # 0x0
        ConvertV4MappedToIPv4    : QHostAddress.ConversionModeFlag = ... # 0x1
        ConvertV4CompatToIPv4    : QHostAddress.ConversionModeFlag = ... # 0x2
        ConvertUnspecifiedAddress: QHostAddress.ConversionModeFlag = ... # 0x4
        ConvertLocalHost         : QHostAddress.ConversionModeFlag = ... # 0x8
        TolerantConversion       : QHostAddress.ConversionModeFlag = ... # 0xff

    class SpecialAddress(enum.Enum):

        Null                     : QHostAddress.SpecialAddress = ... # 0x0
        Broadcast                : QHostAddress.SpecialAddress = ... # 0x1
        LocalHost                : QHostAddress.SpecialAddress = ... # 0x2
        LocalHostIPv6            : QHostAddress.SpecialAddress = ... # 0x3
        Any                      : QHostAddress.SpecialAddress = ... # 0x4
        AnyIPv6                  : QHostAddress.SpecialAddress = ... # 0x5
        AnyIPv4                  : QHostAddress.SpecialAddress = ... # 0x6


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, address: PySide6.QtNetwork.QHostAddress.SpecialAddress) -> None: ...
    @overload
    def __init__(self, address: str) -> None: ...
    @overload
    def __init__(self, copy: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress]) -> None: ...
    @overload
    def __init__(self, ip4Addr: int) -> None: ...
    @overload
    def __init__(self, ip6Addr: PySide6.QtNetwork.QIPv6Address) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def clear(self) -> None: ...
    def isBroadcast(self) -> bool: ...
    def isEqual(self, address: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], mode: PySide6.QtNetwork.QHostAddress.ConversionModeFlag = ...) -> bool: ...
    def isGlobal(self) -> bool: ...
    @overload
    def isInSubnet(self, subnet: Tuple[PySide6.QtNetwork.QHostAddress, int]) -> bool: ...
    @overload
    def isInSubnet(self, subnet: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], netmask: int) -> bool: ...
    def isLinkLocal(self) -> bool: ...
    def isLoopback(self) -> bool: ...
    def isMulticast(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isPrivateUse(self) -> bool: ...
    def isSiteLocal(self) -> bool: ...
    def isUniqueLocalUnicast(self) -> bool: ...
    @staticmethod
    def parseSubnet(subnet: str) -> Tuple[PySide6.QtNetwork.QHostAddress, int]: ...
    def protocol(self) -> PySide6.QtNetwork.QAbstractSocket.NetworkLayerProtocol: ...
    def scopeId(self) -> str: ...
    @overload
    def setAddress(self, address: PySide6.QtNetwork.QHostAddress.SpecialAddress) -> None: ...
    @overload
    def setAddress(self, address: str) -> bool: ...
    @overload
    def setAddress(self, ip4Addr: int) -> None: ...
    @overload
    def setAddress(self, ip6Addr: PySide6.QtNetwork.QIPv6Address) -> None: ...
    def setScopeId(self, id: str) -> None: ...
    def swap(self, other: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress]) -> None: ...
    def toIPv4Address(self) -> Tuple[int, bool]: ...
    def toIPv6Address(self) -> PySide6.QtNetwork.QIPv6Address: ...
    def toString(self) -> str: ...


class QHostInfo(Shiboken.Object):

    class HostInfoError(enum.Enum):

        NoError                  : QHostInfo.HostInfoError = ... # 0x0
        HostNotFound             : QHostInfo.HostInfoError = ... # 0x1
        UnknownError             : QHostInfo.HostInfoError = ... # 0x2


    @overload
    def __init__(self, d: Union[PySide6.QtNetwork.QHostInfo, int]) -> None: ...
    @overload
    def __init__(self, lookupId: int = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def abortHostLookup(lookupId: int) -> None: ...
    def addresses(self) -> List[PySide6.QtNetwork.QHostAddress]: ...
    def error(self) -> PySide6.QtNetwork.QHostInfo.HostInfoError: ...
    def errorString(self) -> str: ...
    @staticmethod
    def fromName(name: str) -> PySide6.QtNetwork.QHostInfo: ...
    def hostName(self) -> str: ...
    @staticmethod
    def localDomainName() -> str: ...
    @staticmethod
    def localHostName() -> str: ...
    @overload
    @staticmethod
    def lookupHost(name: str, receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview]) -> int: ...
    @overload
    def lookupHost(self, arg__1: str, arg__2: Callable) -> None: ...
    def lookupId(self) -> int: ...
    def setAddresses(self, addresses: Sequence[PySide6.QtNetwork.QHostAddress]) -> None: ...
    def setError(self, error: PySide6.QtNetwork.QHostInfo.HostInfoError) -> None: ...
    def setErrorString(self, errorString: str) -> None: ...
    def setHostName(self, name: str) -> None: ...
    def setLookupId(self, id: int) -> None: ...
    def swap(self, other: Union[PySide6.QtNetwork.QHostInfo, int]) -> None: ...


class QHstsPolicy(Shiboken.Object):

    class PolicyFlag(enum.Flag):

        IncludeSubDomains        : QHstsPolicy.PolicyFlag = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, expiry: PySide6.QtCore.QDateTime, flags: PySide6.QtNetwork.QHstsPolicy.PolicyFlag, host: str, mode: PySide6.QtCore.QUrl.ParsingMode = ...) -> None: ...
    @overload
    def __init__(self, rhs: PySide6.QtNetwork.QHstsPolicy) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def expiry(self) -> PySide6.QtCore.QDateTime: ...
    def host(self, options: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def includesSubDomains(self) -> bool: ...
    def isExpired(self) -> bool: ...
    def setExpiry(self, expiry: PySide6.QtCore.QDateTime) -> None: ...
    def setHost(self, host: str, mode: PySide6.QtCore.QUrl.ParsingMode = ...) -> None: ...
    def setIncludesSubDomains(self, include: bool) -> None: ...
    def swap(self, other: PySide6.QtNetwork.QHstsPolicy) -> None: ...


class QHttp2Configuration(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QHttp2Configuration) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def huffmanCompressionEnabled(self) -> bool: ...
    def maxFrameSize(self) -> int: ...
    def serverPushEnabled(self) -> bool: ...
    def sessionReceiveWindowSize(self) -> int: ...
    def setHuffmanCompressionEnabled(self, enable: bool) -> None: ...
    def setMaxFrameSize(self, size: int) -> bool: ...
    def setServerPushEnabled(self, enable: bool) -> None: ...
    def setSessionReceiveWindowSize(self, size: int) -> bool: ...
    def setStreamReceiveWindowSize(self, size: int) -> bool: ...
    def streamReceiveWindowSize(self) -> int: ...
    def swap(self, other: PySide6.QtNetwork.QHttp2Configuration) -> None: ...


class QHttpHeaders(Shiboken.Object):

    class WellKnownHeader(enum.Enum):

        AIM                      : QHttpHeaders.WellKnownHeader = ... # 0x0
        Accept                   : QHttpHeaders.WellKnownHeader = ... # 0x1
        AcceptAdditions          : QHttpHeaders.WellKnownHeader = ... # 0x2
        AcceptCH                 : QHttpHeaders.WellKnownHeader = ... # 0x3
        AcceptDatetime           : QHttpHeaders.WellKnownHeader = ... # 0x4
        AcceptEncoding           : QHttpHeaders.WellKnownHeader = ... # 0x5
        AcceptFeatures           : QHttpHeaders.WellKnownHeader = ... # 0x6
        AcceptLanguage           : QHttpHeaders.WellKnownHeader = ... # 0x7
        AcceptPatch              : QHttpHeaders.WellKnownHeader = ... # 0x8
        AcceptPost               : QHttpHeaders.WellKnownHeader = ... # 0x9
        AcceptRanges             : QHttpHeaders.WellKnownHeader = ... # 0xa
        AcceptSignature          : QHttpHeaders.WellKnownHeader = ... # 0xb
        AccessControlAllowCredentials: QHttpHeaders.WellKnownHeader = ... # 0xc
        AccessControlAllowHeaders: QHttpHeaders.WellKnownHeader = ... # 0xd
        AccessControlAllowMethods: QHttpHeaders.WellKnownHeader = ... # 0xe
        AccessControlAllowOrigin : QHttpHeaders.WellKnownHeader = ... # 0xf
        AccessControlExposeHeaders: QHttpHeaders.WellKnownHeader = ... # 0x10
        AccessControlMaxAge      : QHttpHeaders.WellKnownHeader = ... # 0x11
        AccessControlRequestHeaders: QHttpHeaders.WellKnownHeader = ... # 0x12
        AccessControlRequestMethod: QHttpHeaders.WellKnownHeader = ... # 0x13
        Age                      : QHttpHeaders.WellKnownHeader = ... # 0x14
        Allow                    : QHttpHeaders.WellKnownHeader = ... # 0x15
        ALPN                     : QHttpHeaders.WellKnownHeader = ... # 0x16
        AltSvc                   : QHttpHeaders.WellKnownHeader = ... # 0x17
        AltUsed                  : QHttpHeaders.WellKnownHeader = ... # 0x18
        Alternates               : QHttpHeaders.WellKnownHeader = ... # 0x19
        ApplyToRedirectRef       : QHttpHeaders.WellKnownHeader = ... # 0x1a
        AuthenticationControl    : QHttpHeaders.WellKnownHeader = ... # 0x1b
        AuthenticationInfo       : QHttpHeaders.WellKnownHeader = ... # 0x1c
        Authorization            : QHttpHeaders.WellKnownHeader = ... # 0x1d
        CacheControl             : QHttpHeaders.WellKnownHeader = ... # 0x1e
        CacheStatus              : QHttpHeaders.WellKnownHeader = ... # 0x1f
        CalManagedID             : QHttpHeaders.WellKnownHeader = ... # 0x20
        CalDAVTimezones          : QHttpHeaders.WellKnownHeader = ... # 0x21
        CapsuleProtocol          : QHttpHeaders.WellKnownHeader = ... # 0x22
        CDNCacheControl          : QHttpHeaders.WellKnownHeader = ... # 0x23
        CDNLoop                  : QHttpHeaders.WellKnownHeader = ... # 0x24
        CertNotAfter             : QHttpHeaders.WellKnownHeader = ... # 0x25
        CertNotBefore            : QHttpHeaders.WellKnownHeader = ... # 0x26
        ClearSiteData            : QHttpHeaders.WellKnownHeader = ... # 0x27
        ClientCert               : QHttpHeaders.WellKnownHeader = ... # 0x28
        ClientCertChain          : QHttpHeaders.WellKnownHeader = ... # 0x29
        Close                    : QHttpHeaders.WellKnownHeader = ... # 0x2a
        Connection               : QHttpHeaders.WellKnownHeader = ... # 0x2b
        ContentDigest            : QHttpHeaders.WellKnownHeader = ... # 0x2c
        ContentDisposition       : QHttpHeaders.WellKnownHeader = ... # 0x2d
        ContentEncoding          : QHttpHeaders.WellKnownHeader = ... # 0x2e
        ContentID                : QHttpHeaders.WellKnownHeader = ... # 0x2f
        ContentLanguage          : QHttpHeaders.WellKnownHeader = ... # 0x30
        ContentLength            : QHttpHeaders.WellKnownHeader = ... # 0x31
        ContentLocation          : QHttpHeaders.WellKnownHeader = ... # 0x32
        ContentRange             : QHttpHeaders.WellKnownHeader = ... # 0x33
        ContentSecurityPolicy    : QHttpHeaders.WellKnownHeader = ... # 0x34
        ContentSecurityPolicyReportOnly: QHttpHeaders.WellKnownHeader = ... # 0x35
        ContentType              : QHttpHeaders.WellKnownHeader = ... # 0x36
        Cookie                   : QHttpHeaders.WellKnownHeader = ... # 0x37
        CrossOriginEmbedderPolicy: QHttpHeaders.WellKnownHeader = ... # 0x38
        CrossOriginEmbedderPolicyReportOnly: QHttpHeaders.WellKnownHeader = ... # 0x39
        CrossOriginOpenerPolicy  : QHttpHeaders.WellKnownHeader = ... # 0x3a
        CrossOriginOpenerPolicyReportOnly: QHttpHeaders.WellKnownHeader = ... # 0x3b
        CrossOriginResourcePolicy: QHttpHeaders.WellKnownHeader = ... # 0x3c
        DASL                     : QHttpHeaders.WellKnownHeader = ... # 0x3d
        Date                     : QHttpHeaders.WellKnownHeader = ... # 0x3e
        DAV                      : QHttpHeaders.WellKnownHeader = ... # 0x3f
        DeltaBase                : QHttpHeaders.WellKnownHeader = ... # 0x40
        Depth                    : QHttpHeaders.WellKnownHeader = ... # 0x41
        Destination              : QHttpHeaders.WellKnownHeader = ... # 0x42
        DifferentialID           : QHttpHeaders.WellKnownHeader = ... # 0x43
        DPoP                     : QHttpHeaders.WellKnownHeader = ... # 0x44
        DPoPNonce                : QHttpHeaders.WellKnownHeader = ... # 0x45
        EarlyData                : QHttpHeaders.WellKnownHeader = ... # 0x46
        ETag                     : QHttpHeaders.WellKnownHeader = ... # 0x47
        Expect                   : QHttpHeaders.WellKnownHeader = ... # 0x48
        ExpectCT                 : QHttpHeaders.WellKnownHeader = ... # 0x49
        Expires                  : QHttpHeaders.WellKnownHeader = ... # 0x4a
        Forwarded                : QHttpHeaders.WellKnownHeader = ... # 0x4b
        From                     : QHttpHeaders.WellKnownHeader = ... # 0x4c
        Hobareg                  : QHttpHeaders.WellKnownHeader = ... # 0x4d
        Host                     : QHttpHeaders.WellKnownHeader = ... # 0x4e
        If                       : QHttpHeaders.WellKnownHeader = ... # 0x4f
        IfMatch                  : QHttpHeaders.WellKnownHeader = ... # 0x50
        IfModifiedSince          : QHttpHeaders.WellKnownHeader = ... # 0x51
        IfNoneMatch              : QHttpHeaders.WellKnownHeader = ... # 0x52
        IfRange                  : QHttpHeaders.WellKnownHeader = ... # 0x53
        IfScheduleTagMatch       : QHttpHeaders.WellKnownHeader = ... # 0x54
        IfUnmodifiedSince        : QHttpHeaders.WellKnownHeader = ... # 0x55
        IM                       : QHttpHeaders.WellKnownHeader = ... # 0x56
        IncludeReferredTokenBindingID: QHttpHeaders.WellKnownHeader = ... # 0x57
        KeepAlive                : QHttpHeaders.WellKnownHeader = ... # 0x58
        Label                    : QHttpHeaders.WellKnownHeader = ... # 0x59
        LastEventID              : QHttpHeaders.WellKnownHeader = ... # 0x5a
        LastModified             : QHttpHeaders.WellKnownHeader = ... # 0x5b
        Link                     : QHttpHeaders.WellKnownHeader = ... # 0x5c
        Location                 : QHttpHeaders.WellKnownHeader = ... # 0x5d
        LockToken                : QHttpHeaders.WellKnownHeader = ... # 0x5e
        MaxForwards              : QHttpHeaders.WellKnownHeader = ... # 0x5f
        MementoDatetime          : QHttpHeaders.WellKnownHeader = ... # 0x60
        Meter                    : QHttpHeaders.WellKnownHeader = ... # 0x61
        MIMEVersion              : QHttpHeaders.WellKnownHeader = ... # 0x62
        Negotiate                : QHttpHeaders.WellKnownHeader = ... # 0x63
        NEL                      : QHttpHeaders.WellKnownHeader = ... # 0x64
        ODataEntityId            : QHttpHeaders.WellKnownHeader = ... # 0x65
        ODataIsolation           : QHttpHeaders.WellKnownHeader = ... # 0x66
        ODataMaxVersion          : QHttpHeaders.WellKnownHeader = ... # 0x67
        ODataVersion             : QHttpHeaders.WellKnownHeader = ... # 0x68
        OptionalWWWAuthenticate  : QHttpHeaders.WellKnownHeader = ... # 0x69
        OrderingType             : QHttpHeaders.WellKnownHeader = ... # 0x6a
        Origin                   : QHttpHeaders.WellKnownHeader = ... # 0x6b
        OriginAgentCluster       : QHttpHeaders.WellKnownHeader = ... # 0x6c
        OSCORE                   : QHttpHeaders.WellKnownHeader = ... # 0x6d
        OSLCCoreVersion          : QHttpHeaders.WellKnownHeader = ... # 0x6e
        Overwrite                : QHttpHeaders.WellKnownHeader = ... # 0x6f
        PingFrom                 : QHttpHeaders.WellKnownHeader = ... # 0x70
        PingTo                   : QHttpHeaders.WellKnownHeader = ... # 0x71
        Position                 : QHttpHeaders.WellKnownHeader = ... # 0x72
        Prefer                   : QHttpHeaders.WellKnownHeader = ... # 0x73
        PreferenceApplied        : QHttpHeaders.WellKnownHeader = ... # 0x74
        Priority                 : QHttpHeaders.WellKnownHeader = ... # 0x75
        ProxyAuthenticate        : QHttpHeaders.WellKnownHeader = ... # 0x76
        ProxyAuthenticationInfo  : QHttpHeaders.WellKnownHeader = ... # 0x77
        ProxyAuthorization       : QHttpHeaders.WellKnownHeader = ... # 0x78
        ProxyStatus              : QHttpHeaders.WellKnownHeader = ... # 0x79
        PublicKeyPins            : QHttpHeaders.WellKnownHeader = ... # 0x7a
        PublicKeyPinsReportOnly  : QHttpHeaders.WellKnownHeader = ... # 0x7b
        Range                    : QHttpHeaders.WellKnownHeader = ... # 0x7c
        RedirectRef              : QHttpHeaders.WellKnownHeader = ... # 0x7d
        Referer                  : QHttpHeaders.WellKnownHeader = ... # 0x7e
        Refresh                  : QHttpHeaders.WellKnownHeader = ... # 0x7f
        ReplayNonce              : QHttpHeaders.WellKnownHeader = ... # 0x80
        ReprDigest               : QHttpHeaders.WellKnownHeader = ... # 0x81
        RetryAfter               : QHttpHeaders.WellKnownHeader = ... # 0x82
        ScheduleReply            : QHttpHeaders.WellKnownHeader = ... # 0x83
        ScheduleTag              : QHttpHeaders.WellKnownHeader = ... # 0x84
        SecPurpose               : QHttpHeaders.WellKnownHeader = ... # 0x85
        SecTokenBinding          : QHttpHeaders.WellKnownHeader = ... # 0x86
        SecWebSocketAccept       : QHttpHeaders.WellKnownHeader = ... # 0x87
        SecWebSocketExtensions   : QHttpHeaders.WellKnownHeader = ... # 0x88
        SecWebSocketKey          : QHttpHeaders.WellKnownHeader = ... # 0x89
        SecWebSocketProtocol     : QHttpHeaders.WellKnownHeader = ... # 0x8a
        SecWebSocketVersion      : QHttpHeaders.WellKnownHeader = ... # 0x8b
        Server                   : QHttpHeaders.WellKnownHeader = ... # 0x8c
        ServerTiming             : QHttpHeaders.WellKnownHeader = ... # 0x8d
        SetCookie                : QHttpHeaders.WellKnownHeader = ... # 0x8e
        Signature                : QHttpHeaders.WellKnownHeader = ... # 0x8f
        SignatureInput           : QHttpHeaders.WellKnownHeader = ... # 0x90
        SLUG                     : QHttpHeaders.WellKnownHeader = ... # 0x91
        SoapAction               : QHttpHeaders.WellKnownHeader = ... # 0x92
        StatusURI                : QHttpHeaders.WellKnownHeader = ... # 0x93
        StrictTransportSecurity  : QHttpHeaders.WellKnownHeader = ... # 0x94
        Sunset                   : QHttpHeaders.WellKnownHeader = ... # 0x95
        SurrogateCapability      : QHttpHeaders.WellKnownHeader = ... # 0x96
        SurrogateControl         : QHttpHeaders.WellKnownHeader = ... # 0x97
        TCN                      : QHttpHeaders.WellKnownHeader = ... # 0x98
        TE                       : QHttpHeaders.WellKnownHeader = ... # 0x99
        Timeout                  : QHttpHeaders.WellKnownHeader = ... # 0x9a
        Topic                    : QHttpHeaders.WellKnownHeader = ... # 0x9b
        Traceparent              : QHttpHeaders.WellKnownHeader = ... # 0x9c
        Tracestate               : QHttpHeaders.WellKnownHeader = ... # 0x9d
        Trailer                  : QHttpHeaders.WellKnownHeader = ... # 0x9e
        TransferEncoding         : QHttpHeaders.WellKnownHeader = ... # 0x9f
        TTL                      : QHttpHeaders.WellKnownHeader = ... # 0xa0
        Upgrade                  : QHttpHeaders.WellKnownHeader = ... # 0xa1
        Urgency                  : QHttpHeaders.WellKnownHeader = ... # 0xa2
        UserAgent                : QHttpHeaders.WellKnownHeader = ... # 0xa3
        VariantVary              : QHttpHeaders.WellKnownHeader = ... # 0xa4
        Vary                     : QHttpHeaders.WellKnownHeader = ... # 0xa5
        Via                      : QHttpHeaders.WellKnownHeader = ... # 0xa6
        WantContentDigest        : QHttpHeaders.WellKnownHeader = ... # 0xa7
        WantReprDigest           : QHttpHeaders.WellKnownHeader = ... # 0xa8
        WWWAuthenticate          : QHttpHeaders.WellKnownHeader = ... # 0xa9
        XContentTypeOptions      : QHttpHeaders.WellKnownHeader = ... # 0xaa
        XFrameOptions            : QHttpHeaders.WellKnownHeader = ... # 0xab
        AcceptCharset            : QHttpHeaders.WellKnownHeader = ... # 0xac
        CPEPInfo                 : QHttpHeaders.WellKnownHeader = ... # 0xad
        Pragma                   : QHttpHeaders.WellKnownHeader = ... # 0xae
        ProtocolInfo             : QHttpHeaders.WellKnownHeader = ... # 0xaf
        ProtocolQuery            : QHttpHeaders.WellKnownHeader = ... # 0xb0


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QHttpHeaders) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @overload
    def append(self, name: PySide6.QtNetwork.QHttpHeaders.WellKnownHeader, value: str) -> bool: ...
    @overload
    def append(self, name: str, value: str) -> bool: ...
    def clear(self) -> None: ...
    @overload
    def combinedValue(self, name: PySide6.QtNetwork.QHttpHeaders.WellKnownHeader) -> PySide6.QtCore.QByteArray: ...
    @overload
    def combinedValue(self, name: str) -> PySide6.QtCore.QByteArray: ...
    @overload
    def contains(self, name: PySide6.QtNetwork.QHttpHeaders.WellKnownHeader) -> bool: ...
    @overload
    def contains(self, name: str) -> bool: ...
    @staticmethod
    def fromListOfPairs(headers: Sequence[Tuple[PySide6.QtCore.QByteArray, PySide6.QtCore.QByteArray]]) -> PySide6.QtNetwork.QHttpHeaders: ...
    @staticmethod
    def fromMultiHash(headers: Dict[PySide6.QtCore.QByteArray, PySide6.QtCore.QByteArray]) -> PySide6.QtNetwork.QHttpHeaders: ...
    @staticmethod
    def fromMultiMap(headers: Dict[PySide6.QtCore.QByteArray, PySide6.QtCore.QByteArray]) -> PySide6.QtNetwork.QHttpHeaders: ...
    @overload
    def insert(self, i: int, name: PySide6.QtNetwork.QHttpHeaders.WellKnownHeader, value: str) -> bool: ...
    @overload
    def insert(self, i: int, name: str, value: str) -> bool: ...
    def isEmpty(self) -> bool: ...
    def nameAt(self, i: int) -> str: ...
    @overload
    def removeAll(self, name: PySide6.QtNetwork.QHttpHeaders.WellKnownHeader) -> None: ...
    @overload
    def removeAll(self, name: str) -> None: ...
    def removeAt(self, i: int) -> None: ...
    @overload
    def replace(self, i: int, name: PySide6.QtNetwork.QHttpHeaders.WellKnownHeader, newValue: str) -> bool: ...
    @overload
    def replace(self, i: int, name: str, newValue: str) -> bool: ...
    def reserve(self, size: int) -> None: ...
    def size(self) -> int: ...
    def swap(self, other: PySide6.QtNetwork.QHttpHeaders) -> None: ...
    def toListOfPairs(self) -> List[Tuple[PySide6.QtCore.QByteArray, PySide6.QtCore.QByteArray]]: ...
    def toMultiHash(self) -> Dict[PySide6.QtCore.QByteArray, PySide6.QtCore.QByteArray]: ...
    def toMultiMap(self) -> Dict[PySide6.QtCore.QByteArray, PySide6.QtCore.QByteArray]: ...
    @overload
    def value(self, name: PySide6.QtNetwork.QHttpHeaders.WellKnownHeader, defaultValue: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview] = ...) -> PySide6.QtCore.QByteArray: ...
    @overload
    def value(self, name: str, defaultValue: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview] = ...) -> PySide6.QtCore.QByteArray: ...
    def valueAt(self, i: int) -> PySide6.QtCore.QByteArray: ...
    @overload
    def values(self, name: PySide6.QtNetwork.QHttpHeaders.WellKnownHeader) -> List[PySide6.QtCore.QByteArray]: ...
    @overload
    def values(self, name: str) -> List[PySide6.QtCore.QByteArray]: ...
    @staticmethod
    def wellKnownHeaderName(name: PySide6.QtNetwork.QHttpHeaders.WellKnownHeader) -> PySide6.QtCore.QByteArray: ...


class QHttpMultiPart(PySide6.QtCore.QObject):

    class ContentType(enum.Enum):

        MixedType                : QHttpMultiPart.ContentType = ... # 0x0
        RelatedType              : QHttpMultiPart.ContentType = ... # 0x1
        FormDataType             : QHttpMultiPart.ContentType = ... # 0x2
        AlternativeType          : QHttpMultiPart.ContentType = ... # 0x3


    @overload
    def __init__(self, contentType: PySide6.QtNetwork.QHttpMultiPart.ContentType, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def append(self, httpPart: PySide6.QtNetwork.QHttpPart) -> None: ...
    def boundary(self) -> PySide6.QtCore.QByteArray: ...
    def setBoundary(self, boundary: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def setContentType(self, contentType: PySide6.QtNetwork.QHttpMultiPart.ContentType) -> None: ...


class QHttpPart(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QHttpPart) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def setBody(self, body: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def setBodyDevice(self, device: PySide6.QtCore.QIODevice) -> None: ...
    def setHeader(self, header: PySide6.QtNetwork.QNetworkRequest.KnownHeaders, value: Any) -> None: ...
    def setRawHeader(self, headerName: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], headerValue: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def swap(self, other: PySide6.QtNetwork.QHttpPart) -> None: ...


class QIPv6Address(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QIPv6Address: PySide6.QtNetwork.QIPv6Address) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QIntList(object): ...


class QLocalServer(PySide6.QtCore.QObject):

    newConnection            : ClassVar[Signal] = ... # newConnection()

    class SocketOption(enum.Flag):

        NoOptions                : QLocalServer.SocketOption = ... # 0x0
        UserAccessOption         : QLocalServer.SocketOption = ... # 0x1
        GroupAccessOption        : QLocalServer.SocketOption = ... # 0x2
        OtherAccessOption        : QLocalServer.SocketOption = ... # 0x4
        WorldAccessOption        : QLocalServer.SocketOption = ... # 0x7
        AbstractNamespaceOption  : QLocalServer.SocketOption = ... # 0x8


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def close(self) -> None: ...
    def errorString(self) -> str: ...
    def fullServerName(self) -> str: ...
    def hasPendingConnections(self) -> bool: ...
    def incomingConnection(self, socketDescriptor: int) -> None: ...
    def isListening(self) -> bool: ...
    @overload
    def listen(self, name: str) -> bool: ...
    @overload
    def listen(self, socketDescriptor: int) -> bool: ...
    def listenBacklogSize(self) -> int: ...
    def maxPendingConnections(self) -> int: ...
    def nextPendingConnection(self) -> PySide6.QtNetwork.QLocalSocket: ...
    @staticmethod
    def removeServer(name: str) -> bool: ...
    def serverError(self) -> PySide6.QtNetwork.QAbstractSocket.SocketError: ...
    def serverName(self) -> str: ...
    def setListenBacklogSize(self, size: int) -> None: ...
    def setMaxPendingConnections(self, numConnections: int) -> None: ...
    def setSocketOptions(self, options: PySide6.QtNetwork.QLocalServer.SocketOption) -> None: ...
    def socketDescriptor(self) -> int: ...
    def socketOptions(self) -> PySide6.QtNetwork.QLocalServer.SocketOption: ...
    def waitForNewConnection(self, msec: int) -> Tuple[bool, bool]: ...


class QLocalSocket(PySide6.QtCore.QIODevice):

    connected                : ClassVar[Signal] = ... # connected()
    disconnected             : ClassVar[Signal] = ... # disconnected()
    errorOccurred            : ClassVar[Signal] = ... # errorOccurred(QLocalSocket::LocalSocketError)
    stateChanged             : ClassVar[Signal] = ... # stateChanged(QLocalSocket::LocalSocketState)

    class LocalSocketError(enum.Enum):

        UnknownSocketError       : QLocalSocket.LocalSocketError = ... # -0x1
        ConnectionRefusedError   : QLocalSocket.LocalSocketError = ... # 0x0
        PeerClosedError          : QLocalSocket.LocalSocketError = ... # 0x1
        ServerNotFoundError      : QLocalSocket.LocalSocketError = ... # 0x2
        SocketAccessError        : QLocalSocket.LocalSocketError = ... # 0x3
        SocketResourceError      : QLocalSocket.LocalSocketError = ... # 0x4
        SocketTimeoutError       : QLocalSocket.LocalSocketError = ... # 0x5
        DatagramTooLargeError    : QLocalSocket.LocalSocketError = ... # 0x6
        ConnectionError          : QLocalSocket.LocalSocketError = ... # 0x7
        UnsupportedSocketOperationError: QLocalSocket.LocalSocketError = ... # 0xa
        OperationError           : QLocalSocket.LocalSocketError = ... # 0x13

    class LocalSocketState(enum.Enum):

        UnconnectedState         : QLocalSocket.LocalSocketState = ... # 0x0
        ConnectingState          : QLocalSocket.LocalSocketState = ... # 0x2
        ConnectedState           : QLocalSocket.LocalSocketState = ... # 0x3
        ClosingState             : QLocalSocket.LocalSocketState = ... # 0x6

    class SocketOption(enum.Flag):

        NoOptions                : QLocalSocket.SocketOption = ... # 0x0
        AbstractNamespaceOption  : QLocalSocket.SocketOption = ... # 0x1


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def abort(self) -> None: ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def canReadLine(self) -> bool: ...
    def close(self) -> None: ...
    @overload
    def connectToServer(self, name: str, openMode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ...) -> None: ...
    @overload
    def connectToServer(self, openMode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ...) -> None: ...
    def disconnectFromServer(self) -> None: ...
    def error(self) -> PySide6.QtNetwork.QLocalSocket.LocalSocketError: ...
    def flush(self) -> bool: ...
    def fullServerName(self) -> str: ...
    def isSequential(self) -> bool: ...
    def isValid(self) -> bool: ...
    def open(self, openMode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ...) -> bool: ...
    def readBufferSize(self) -> int: ...
    def readData(self, arg__2: int) -> object: ...
    def readLineData(self, maxSize: int) -> object: ...
    def serverName(self) -> str: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def setServerName(self, name: str) -> None: ...
    def setSocketDescriptor(self, socketDescriptor: int, socketState: PySide6.QtNetwork.QLocalSocket.LocalSocketState = ..., openMode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ...) -> bool: ...
    def setSocketOptions(self, option: PySide6.QtNetwork.QLocalSocket.SocketOption) -> None: ...
    def skipData(self, maxSize: int) -> int: ...
    def socketDescriptor(self) -> int: ...
    def socketOptions(self) -> PySide6.QtNetwork.QLocalSocket.SocketOption: ...
    def state(self) -> PySide6.QtNetwork.QLocalSocket.LocalSocketState: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def waitForConnected(self, msecs: int = ...) -> bool: ...
    def waitForDisconnected(self, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def writeData(self, arg__1: Union[bytes, bytearray, memoryview], arg__2: int) -> int: ...


class QNetworkAccessManager(PySide6.QtCore.QObject):

    authenticationRequired   : ClassVar[Signal] = ... # authenticationRequired(QNetworkReply*,QAuthenticator*)
    encrypted                : ClassVar[Signal] = ... # encrypted(QNetworkReply*)
    finished                 : ClassVar[Signal] = ... # finished(QNetworkReply*)
    preSharedKeyAuthenticationRequired: ClassVar[Signal] = ... # preSharedKeyAuthenticationRequired(QNetworkReply*,QSslPreSharedKeyAuthenticator*)
    proxyAuthenticationRequired: ClassVar[Signal] = ... # proxyAuthenticationRequired(QNetworkProxy,QAuthenticator*)
    sslErrors                : ClassVar[Signal] = ... # sslErrors(QNetworkReply*,QList<QSslError>)

    class Operation(enum.Enum):

        UnknownOperation         : QNetworkAccessManager.Operation = ... # 0x0
        HeadOperation            : QNetworkAccessManager.Operation = ... # 0x1
        GetOperation             : QNetworkAccessManager.Operation = ... # 0x2
        PutOperation             : QNetworkAccessManager.Operation = ... # 0x3
        PostOperation            : QNetworkAccessManager.Operation = ... # 0x4
        DeleteOperation          : QNetworkAccessManager.Operation = ... # 0x5
        CustomOperation          : QNetworkAccessManager.Operation = ... # 0x6


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def addStrictTransportSecurityHosts(self, knownHosts: Sequence[PySide6.QtNetwork.QHstsPolicy]) -> None: ...
    def autoDeleteReplies(self) -> bool: ...
    def cache(self) -> PySide6.QtNetwork.QAbstractNetworkCache: ...
    def clearAccessCache(self) -> None: ...
    def clearConnectionCache(self) -> None: ...
    def connectToHost(self, hostName: str, port: int = ...) -> None: ...
    @overload
    def connectToHostEncrypted(self, hostName: str, port: int, sslConfiguration: PySide6.QtNetwork.QSslConfiguration, peerName: str) -> None: ...
    @overload
    def connectToHostEncrypted(self, hostName: str, port: int = ..., sslConfiguration: PySide6.QtNetwork.QSslConfiguration = ...) -> None: ...
    def cookieJar(self) -> PySide6.QtNetwork.QNetworkCookieJar: ...
    def createRequest(self, op: PySide6.QtNetwork.QNetworkAccessManager.Operation, request: PySide6.QtNetwork.QNetworkRequest, outgoingData: Optional[PySide6.QtCore.QIODevice] = ...) -> PySide6.QtNetwork.QNetworkReply: ...
    def deleteResource(self, request: PySide6.QtNetwork.QNetworkRequest) -> PySide6.QtNetwork.QNetworkReply: ...
    def enableStrictTransportSecurityStore(self, enabled: bool, storeDir: str = ...) -> None: ...
    @overload
    def get(self, request: PySide6.QtNetwork.QNetworkRequest) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def get(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QIODevice) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def get(self, request: PySide6.QtNetwork.QNetworkRequest, data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> PySide6.QtNetwork.QNetworkReply: ...
    def head(self, request: PySide6.QtNetwork.QNetworkRequest) -> PySide6.QtNetwork.QNetworkReply: ...
    def isStrictTransportSecurityEnabled(self) -> bool: ...
    def isStrictTransportSecurityStoreEnabled(self) -> bool: ...
    @overload
    def post(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QIODevice) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def post(self, request: PySide6.QtNetwork.QNetworkRequest, data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def post(self, request: PySide6.QtNetwork.QNetworkRequest, multiPart: PySide6.QtNetwork.QHttpMultiPart) -> PySide6.QtNetwork.QNetworkReply: ...
    def proxy(self) -> PySide6.QtNetwork.QNetworkProxy: ...
    def proxyFactory(self) -> PySide6.QtNetwork.QNetworkProxyFactory: ...
    @overload
    def put(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QIODevice) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def put(self, request: PySide6.QtNetwork.QNetworkRequest, data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def put(self, request: PySide6.QtNetwork.QNetworkRequest, multiPart: PySide6.QtNetwork.QHttpMultiPart) -> PySide6.QtNetwork.QNetworkReply: ...
    def redirectPolicy(self) -> PySide6.QtNetwork.QNetworkRequest.RedirectPolicy: ...
    @overload
    def sendCustomRequest(self, request: PySide6.QtNetwork.QNetworkRequest, verb: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], data: Optional[PySide6.QtCore.QIODevice] = ...) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def sendCustomRequest(self, request: PySide6.QtNetwork.QNetworkRequest, verb: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def sendCustomRequest(self, request: PySide6.QtNetwork.QNetworkRequest, verb: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], multiPart: PySide6.QtNetwork.QHttpMultiPart) -> PySide6.QtNetwork.QNetworkReply: ...
    def setAutoDeleteReplies(self, autoDelete: bool) -> None: ...
    def setCache(self, cache: PySide6.QtNetwork.QAbstractNetworkCache) -> None: ...
    def setCookieJar(self, cookieJar: PySide6.QtNetwork.QNetworkCookieJar) -> None: ...
    def setProxy(self, proxy: Union[PySide6.QtNetwork.QNetworkProxy, PySide6.QtNetwork.QNetworkProxy.ProxyType]) -> None: ...
    def setProxyFactory(self, factory: PySide6.QtNetwork.QNetworkProxyFactory) -> None: ...
    def setRedirectPolicy(self, policy: PySide6.QtNetwork.QNetworkRequest.RedirectPolicy) -> None: ...
    def setStrictTransportSecurityEnabled(self, enabled: bool) -> None: ...
    def setTransferTimeout(self, timeout: int) -> None: ...
    def strictTransportSecurityHosts(self) -> List[PySide6.QtNetwork.QHstsPolicy]: ...
    def supportedSchemes(self) -> List[str]: ...
    def supportedSchemesImplementation(self) -> List[str]: ...
    def transferTimeout(self) -> int: ...


class QNetworkAddressEntry(Shiboken.Object):

    class DnsEligibilityStatus(enum.Enum):

        DnsEligibilityUnknown    : QNetworkAddressEntry.DnsEligibilityStatus = ... # -0x1
        DnsIneligible            : QNetworkAddressEntry.DnsEligibilityStatus = ... # 0x0
        DnsEligible              : QNetworkAddressEntry.DnsEligibilityStatus = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QNetworkAddressEntry) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def broadcast(self) -> PySide6.QtNetwork.QHostAddress: ...
    def clearAddressLifetime(self) -> None: ...
    def dnsEligibility(self) -> PySide6.QtNetwork.QNetworkAddressEntry.DnsEligibilityStatus: ...
    def ip(self) -> PySide6.QtNetwork.QHostAddress: ...
    def isLifetimeKnown(self) -> bool: ...
    def isPermanent(self) -> bool: ...
    def isTemporary(self) -> bool: ...
    def netmask(self) -> PySide6.QtNetwork.QHostAddress: ...
    def preferredLifetime(self) -> PySide6.QtCore.QDeadlineTimer: ...
    def prefixLength(self) -> int: ...
    def setAddressLifetime(self, preferred: Union[PySide6.QtCore.QDeadlineTimer, PySide6.QtCore.QDeadlineTimer.ForeverConstant, int], validity: Union[PySide6.QtCore.QDeadlineTimer, PySide6.QtCore.QDeadlineTimer.ForeverConstant, int]) -> None: ...
    def setBroadcast(self, newBroadcast: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress]) -> None: ...
    def setDnsEligibility(self, status: PySide6.QtNetwork.QNetworkAddressEntry.DnsEligibilityStatus) -> None: ...
    def setIp(self, newIp: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress]) -> None: ...
    def setNetmask(self, newNetmask: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress]) -> None: ...
    def setPrefixLength(self, length: int) -> None: ...
    def swap(self, other: PySide6.QtNetwork.QNetworkAddressEntry) -> None: ...
    def validityLifetime(self) -> PySide6.QtCore.QDeadlineTimer: ...


class QNetworkCacheMetaData(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QNetworkCacheMetaData) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def attributes(self) -> Dict[PySide6.QtNetwork.QNetworkRequest.Attribute, Any]: ...
    def expirationDate(self) -> PySide6.QtCore.QDateTime: ...
    def isValid(self) -> bool: ...
    def lastModified(self) -> PySide6.QtCore.QDateTime: ...
    def rawHeaders(self) -> List[Tuple[PySide6.QtCore.QByteArray, PySide6.QtCore.QByteArray]]: ...
    def saveToDisk(self) -> bool: ...
    def setAttributes(self, attributes: Dict[PySide6.QtNetwork.QNetworkRequest.Attribute, Any]) -> None: ...
    def setExpirationDate(self, dateTime: PySide6.QtCore.QDateTime) -> None: ...
    def setLastModified(self, dateTime: PySide6.QtCore.QDateTime) -> None: ...
    def setRawHeaders(self, headers: Sequence[Tuple[PySide6.QtCore.QByteArray, PySide6.QtCore.QByteArray]]) -> None: ...
    def setSaveToDisk(self, allow: bool) -> None: ...
    def setUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def swap(self, other: PySide6.QtNetwork.QNetworkCacheMetaData) -> None: ...
    def url(self) -> PySide6.QtCore.QUrl: ...


class QNetworkCookie(Shiboken.Object):

    class RawForm(enum.Enum):

        NameAndValueOnly         : QNetworkCookie.RawForm = ... # 0x0
        Full                     : QNetworkCookie.RawForm = ... # 0x1

    class SameSite(enum.Enum):

        Default                  : QNetworkCookie.SameSite = ... # 0x0
        None_                    : QNetworkCookie.SameSite = ... # 0x1
        Lax                      : QNetworkCookie.SameSite = ... # 0x2
        Strict                   : QNetworkCookie.SameSite = ... # 0x3


    @overload
    def __init__(self, name: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview] = ..., value: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview] = ...) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QNetworkCookie) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def domain(self) -> str: ...
    def expirationDate(self) -> PySide6.QtCore.QDateTime: ...
    def hasSameIdentifier(self, other: PySide6.QtNetwork.QNetworkCookie) -> bool: ...
    def isHttpOnly(self) -> bool: ...
    def isSecure(self) -> bool: ...
    def isSessionCookie(self) -> bool: ...
    def name(self) -> PySide6.QtCore.QByteArray: ...
    def normalize(self, url: Union[PySide6.QtCore.QUrl, str]) -> None: ...
    @staticmethod
    def parseCookies(cookieString: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> List[PySide6.QtNetwork.QNetworkCookie]: ...
    def path(self) -> str: ...
    def sameSitePolicy(self) -> PySide6.QtNetwork.QNetworkCookie.SameSite: ...
    def setDomain(self, domain: str) -> None: ...
    def setExpirationDate(self, date: PySide6.QtCore.QDateTime) -> None: ...
    def setHttpOnly(self, enable: bool) -> None: ...
    def setName(self, cookieName: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def setPath(self, path: str) -> None: ...
    def setSameSitePolicy(self, sameSite: PySide6.QtNetwork.QNetworkCookie.SameSite) -> None: ...
    def setSecure(self, enable: bool) -> None: ...
    def setValue(self, value: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def swap(self, other: PySide6.QtNetwork.QNetworkCookie) -> None: ...
    def toRawForm(self, form: PySide6.QtNetwork.QNetworkCookie.RawForm = ...) -> PySide6.QtCore.QByteArray: ...
    def value(self) -> PySide6.QtCore.QByteArray: ...


class QNetworkCookieJar(PySide6.QtCore.QObject):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def allCookies(self) -> List[PySide6.QtNetwork.QNetworkCookie]: ...
    def cookiesForUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> List[PySide6.QtNetwork.QNetworkCookie]: ...
    def deleteCookie(self, cookie: PySide6.QtNetwork.QNetworkCookie) -> bool: ...
    def insertCookie(self, cookie: PySide6.QtNetwork.QNetworkCookie) -> bool: ...
    def setAllCookies(self, cookieList: Sequence[PySide6.QtNetwork.QNetworkCookie]) -> None: ...
    def setCookiesFromUrl(self, cookieList: Sequence[PySide6.QtNetwork.QNetworkCookie], url: Union[PySide6.QtCore.QUrl, str]) -> bool: ...
    def updateCookie(self, cookie: PySide6.QtNetwork.QNetworkCookie) -> bool: ...
    def validateCookie(self, cookie: PySide6.QtNetwork.QNetworkCookie, url: Union[PySide6.QtCore.QUrl, str]) -> bool: ...


class QNetworkDatagram(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], destinationAddress: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress] = ..., port: int = ...) -> None: ...
    @overload
    def __init__(self, other: Union[PySide6.QtNetwork.QNetworkDatagram, PySide6.QtCore.QByteArray]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def clear(self) -> None: ...
    def data(self) -> PySide6.QtCore.QByteArray: ...
    def destinationAddress(self) -> PySide6.QtNetwork.QHostAddress: ...
    def destinationPort(self) -> int: ...
    def hopLimit(self) -> int: ...
    def interfaceIndex(self) -> int: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def makeReply(self, payload: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> PySide6.QtNetwork.QNetworkDatagram: ...
    def senderAddress(self) -> PySide6.QtNetwork.QHostAddress: ...
    def senderPort(self) -> int: ...
    def setData(self, data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def setDestination(self, address: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], port: int) -> None: ...
    def setHopLimit(self, count: int) -> None: ...
    def setInterfaceIndex(self, index: int) -> None: ...
    def setSender(self, address: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], port: int = ...) -> None: ...
    def swap(self, other: Union[PySide6.QtNetwork.QNetworkDatagram, PySide6.QtCore.QByteArray]) -> None: ...


class QNetworkDiskCache(PySide6.QtNetwork.QAbstractNetworkCache):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def cacheDirectory(self) -> str: ...
    def cacheSize(self) -> int: ...
    def clear(self) -> None: ...
    def data(self, url: Union[PySide6.QtCore.QUrl, str]) -> PySide6.QtCore.QIODevice: ...
    def expire(self) -> int: ...
    def fileMetaData(self, fileName: str) -> PySide6.QtNetwork.QNetworkCacheMetaData: ...
    def insert(self, device: PySide6.QtCore.QIODevice) -> None: ...
    def maximumCacheSize(self) -> int: ...
    def metaData(self, url: Union[PySide6.QtCore.QUrl, str]) -> PySide6.QtNetwork.QNetworkCacheMetaData: ...
    def prepare(self, metaData: PySide6.QtNetwork.QNetworkCacheMetaData) -> PySide6.QtCore.QIODevice: ...
    def remove(self, url: Union[PySide6.QtCore.QUrl, str]) -> bool: ...
    def setCacheDirectory(self, cacheDir: str) -> None: ...
    def setMaximumCacheSize(self, size: int) -> None: ...
    def updateMetaData(self, metaData: PySide6.QtNetwork.QNetworkCacheMetaData) -> None: ...


class QNetworkInformation(PySide6.QtCore.QObject):

    isBehindCaptivePortalChanged: ClassVar[Signal] = ... # isBehindCaptivePortalChanged(bool)
    isMeteredChanged         : ClassVar[Signal] = ... # isMeteredChanged(bool)
    reachabilityChanged      : ClassVar[Signal] = ... # reachabilityChanged(Reachability)
    transportMediumChanged   : ClassVar[Signal] = ... # transportMediumChanged(TransportMedium)

    class Feature(enum.Flag):

        Reachability             : QNetworkInformation.Feature = ... # 0x1
        CaptivePortal            : QNetworkInformation.Feature = ... # 0x2
        TransportMedium          : QNetworkInformation.Feature = ... # 0x4
        Metered                  : QNetworkInformation.Feature = ... # 0x8

    class Reachability(enum.Enum):

        Unknown                  : QNetworkInformation.Reachability = ... # 0x0
        Disconnected             : QNetworkInformation.Reachability = ... # 0x1
        Local                    : QNetworkInformation.Reachability = ... # 0x2
        Site                     : QNetworkInformation.Reachability = ... # 0x3
        Online                   : QNetworkInformation.Reachability = ... # 0x4

    class TransportMedium(enum.Enum):

        Unknown                  : QNetworkInformation.TransportMedium = ... # 0x0
        Ethernet                 : QNetworkInformation.TransportMedium = ... # 0x1
        Cellular                 : QNetworkInformation.TransportMedium = ... # 0x2
        WiFi                     : QNetworkInformation.TransportMedium = ... # 0x3
        Bluetooth                : QNetworkInformation.TransportMedium = ... # 0x4


    @staticmethod
    def availableBackends() -> List[str]: ...
    def backendName(self) -> str: ...
    @staticmethod
    def instance() -> PySide6.QtNetwork.QNetworkInformation: ...
    def isBehindCaptivePortal(self) -> bool: ...
    def isMetered(self) -> bool: ...
    @overload
    @staticmethod
    def load(backend: str) -> bool: ...
    @overload
    @staticmethod
    def load(features: PySide6.QtNetwork.QNetworkInformation.Feature) -> bool: ...
    @staticmethod
    def loadBackendByFeatures(features: PySide6.QtNetwork.QNetworkInformation.Feature) -> bool: ...
    @staticmethod
    def loadBackendByName(backend: str) -> bool: ...
    @staticmethod
    def loadDefaultBackend() -> bool: ...
    def reachability(self) -> PySide6.QtNetwork.QNetworkInformation.Reachability: ...
    def supportedFeatures(self) -> PySide6.QtNetwork.QNetworkInformation.Feature: ...
    def supports(self, features: PySide6.QtNetwork.QNetworkInformation.Feature) -> bool: ...
    def transportMedium(self) -> PySide6.QtNetwork.QNetworkInformation.TransportMedium: ...


class QNetworkInterface(Shiboken.Object):

    class InterfaceFlag(enum.Flag):

        IsUp                     : QNetworkInterface.InterfaceFlag = ... # 0x1
        IsRunning                : QNetworkInterface.InterfaceFlag = ... # 0x2
        CanBroadcast             : QNetworkInterface.InterfaceFlag = ... # 0x4
        IsLoopBack               : QNetworkInterface.InterfaceFlag = ... # 0x8
        IsPointToPoint           : QNetworkInterface.InterfaceFlag = ... # 0x10
        CanMulticast             : QNetworkInterface.InterfaceFlag = ... # 0x20

    class InterfaceType(enum.Enum):

        Unknown                  : QNetworkInterface.InterfaceType = ... # 0x0
        Loopback                 : QNetworkInterface.InterfaceType = ... # 0x1
        Virtual                  : QNetworkInterface.InterfaceType = ... # 0x2
        Ethernet                 : QNetworkInterface.InterfaceType = ... # 0x3
        Slip                     : QNetworkInterface.InterfaceType = ... # 0x4
        CanBus                   : QNetworkInterface.InterfaceType = ... # 0x5
        Ppp                      : QNetworkInterface.InterfaceType = ... # 0x6
        Fddi                     : QNetworkInterface.InterfaceType = ... # 0x7
        Ieee80211                : QNetworkInterface.InterfaceType = ... # 0x8
        Wifi                     : QNetworkInterface.InterfaceType = ... # 0x8
        Phonet                   : QNetworkInterface.InterfaceType = ... # 0x9
        Ieee802154               : QNetworkInterface.InterfaceType = ... # 0xa
        SixLoWPAN                : QNetworkInterface.InterfaceType = ... # 0xb
        Ieee80216                : QNetworkInterface.InterfaceType = ... # 0xc
        Ieee1394                 : QNetworkInterface.InterfaceType = ... # 0xd


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QNetworkInterface) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def addressEntries(self) -> List[PySide6.QtNetwork.QNetworkAddressEntry]: ...
    @staticmethod
    def allAddresses() -> List[PySide6.QtNetwork.QHostAddress]: ...
    @staticmethod
    def allInterfaces() -> List[PySide6.QtNetwork.QNetworkInterface]: ...
    def flags(self) -> PySide6.QtNetwork.QNetworkInterface.InterfaceFlag: ...
    def hardwareAddress(self) -> str: ...
    def humanReadableName(self) -> str: ...
    def index(self) -> int: ...
    @staticmethod
    def interfaceFromIndex(index: int) -> PySide6.QtNetwork.QNetworkInterface: ...
    @staticmethod
    def interfaceFromName(name: str) -> PySide6.QtNetwork.QNetworkInterface: ...
    @staticmethod
    def interfaceIndexFromName(name: str) -> int: ...
    @staticmethod
    def interfaceNameFromIndex(index: int) -> str: ...
    def isValid(self) -> bool: ...
    def maximumTransmissionUnit(self) -> int: ...
    def name(self) -> str: ...
    def swap(self, other: PySide6.QtNetwork.QNetworkInterface) -> None: ...
    def type(self) -> PySide6.QtNetwork.QNetworkInterface.InterfaceType: ...


class QNetworkProxy(Shiboken.Object):

    class Capability(enum.Flag):

        TunnelingCapability      : QNetworkProxy.Capability = ... # 0x1
        ListeningCapability      : QNetworkProxy.Capability = ... # 0x2
        UdpTunnelingCapability   : QNetworkProxy.Capability = ... # 0x4
        CachingCapability        : QNetworkProxy.Capability = ... # 0x8
        HostNameLookupCapability : QNetworkProxy.Capability = ... # 0x10
        SctpTunnelingCapability  : QNetworkProxy.Capability = ... # 0x20
        SctpListeningCapability  : QNetworkProxy.Capability = ... # 0x40

    class ProxyType(enum.Enum):

        DefaultProxy             : QNetworkProxy.ProxyType = ... # 0x0
        Socks5Proxy              : QNetworkProxy.ProxyType = ... # 0x1
        NoProxy                  : QNetworkProxy.ProxyType = ... # 0x2
        HttpProxy                : QNetworkProxy.ProxyType = ... # 0x3
        HttpCachingProxy         : QNetworkProxy.ProxyType = ... # 0x4
        FtpCachingProxy          : QNetworkProxy.ProxyType = ... # 0x5


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: Union[PySide6.QtNetwork.QNetworkProxy, PySide6.QtNetwork.QNetworkProxy.ProxyType]) -> None: ...
    @overload
    def __init__(self, type: PySide6.QtNetwork.QNetworkProxy.ProxyType, hostName: str = ..., port: int = ..., user: str = ..., password: str = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def applicationProxy() -> PySide6.QtNetwork.QNetworkProxy: ...
    def capabilities(self) -> PySide6.QtNetwork.QNetworkProxy.Capability: ...
    def hasRawHeader(self, headerName: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> bool: ...
    def header(self, header: PySide6.QtNetwork.QNetworkRequest.KnownHeaders) -> Any: ...
    def hostName(self) -> str: ...
    def isCachingProxy(self) -> bool: ...
    def isTransparentProxy(self) -> bool: ...
    def password(self) -> str: ...
    def port(self) -> int: ...
    def rawHeader(self, headerName: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> PySide6.QtCore.QByteArray: ...
    def rawHeaderList(self) -> List[PySide6.QtCore.QByteArray]: ...
    @staticmethod
    def setApplicationProxy(proxy: Union[PySide6.QtNetwork.QNetworkProxy, PySide6.QtNetwork.QNetworkProxy.ProxyType]) -> None: ...
    def setCapabilities(self, capab: PySide6.QtNetwork.QNetworkProxy.Capability) -> None: ...
    def setHeader(self, header: PySide6.QtNetwork.QNetworkRequest.KnownHeaders, value: Any) -> None: ...
    def setHostName(self, hostName: str) -> None: ...
    def setPassword(self, password: str) -> None: ...
    def setPort(self, port: int) -> None: ...
    def setRawHeader(self, headerName: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], value: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def setType(self, type: PySide6.QtNetwork.QNetworkProxy.ProxyType) -> None: ...
    def setUser(self, userName: str) -> None: ...
    def swap(self, other: Union[PySide6.QtNetwork.QNetworkProxy, PySide6.QtNetwork.QNetworkProxy.ProxyType]) -> None: ...
    def type(self) -> PySide6.QtNetwork.QNetworkProxy.ProxyType: ...
    def user(self) -> str: ...


class QNetworkProxyFactory(Shiboken.Object):

    def __init__(self) -> None: ...

    @staticmethod
    def proxyForQuery(query: Union[PySide6.QtNetwork.QNetworkProxyQuery, PySide6.QtCore.QUrl, int]) -> List[PySide6.QtNetwork.QNetworkProxy]: ...
    def queryProxy(self, query: Union[PySide6.QtNetwork.QNetworkProxyQuery, PySide6.QtCore.QUrl, int] = ...) -> List[PySide6.QtNetwork.QNetworkProxy]: ...
    @staticmethod
    def setApplicationProxyFactory(factory: PySide6.QtNetwork.QNetworkProxyFactory) -> None: ...
    @staticmethod
    def setUseSystemConfiguration(enable: bool) -> None: ...
    @staticmethod
    def systemProxyForQuery(query: Union[PySide6.QtNetwork.QNetworkProxyQuery, PySide6.QtCore.QUrl, int] = ...) -> List[PySide6.QtNetwork.QNetworkProxy]: ...
    @staticmethod
    def usesSystemConfiguration() -> bool: ...


class QNetworkProxyQuery(Shiboken.Object):

    class QueryType(enum.Enum):

        TcpSocket                : QNetworkProxyQuery.QueryType = ... # 0x0
        UdpSocket                : QNetworkProxyQuery.QueryType = ... # 0x1
        SctpSocket               : QNetworkProxyQuery.QueryType = ... # 0x2
        TcpServer                : QNetworkProxyQuery.QueryType = ... # 0x64
        UrlRequest               : QNetworkProxyQuery.QueryType = ... # 0x65
        SctpServer               : QNetworkProxyQuery.QueryType = ... # 0x66


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, bindPort: int, protocolTag: str = ..., queryType: PySide6.QtNetwork.QNetworkProxyQuery.QueryType = ...) -> None: ...
    @overload
    def __init__(self, hostname: str, port: int, protocolTag: str = ..., queryType: PySide6.QtNetwork.QNetworkProxyQuery.QueryType = ...) -> None: ...
    @overload
    def __init__(self, other: Union[PySide6.QtNetwork.QNetworkProxyQuery, PySide6.QtCore.QUrl, int]) -> None: ...
    @overload
    def __init__(self, requestUrl: Union[PySide6.QtCore.QUrl, str], queryType: PySide6.QtNetwork.QNetworkProxyQuery.QueryType = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def localPort(self) -> int: ...
    def peerHostName(self) -> str: ...
    def peerPort(self) -> int: ...
    def protocolTag(self) -> str: ...
    def queryType(self) -> PySide6.QtNetwork.QNetworkProxyQuery.QueryType: ...
    def setLocalPort(self, port: int) -> None: ...
    def setPeerHostName(self, hostname: str) -> None: ...
    def setPeerPort(self, port: int) -> None: ...
    def setProtocolTag(self, protocolTag: str) -> None: ...
    def setQueryType(self, type: PySide6.QtNetwork.QNetworkProxyQuery.QueryType) -> None: ...
    def setUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def swap(self, other: Union[PySide6.QtNetwork.QNetworkProxyQuery, PySide6.QtCore.QUrl, int]) -> None: ...
    def url(self) -> PySide6.QtCore.QUrl: ...


class QNetworkReply(PySide6.QtCore.QIODevice):

    downloadProgress         : ClassVar[Signal] = ... # downloadProgress(qlonglong,qlonglong)
    encrypted                : ClassVar[Signal] = ... # encrypted()
    errorOccurred            : ClassVar[Signal] = ... # errorOccurred(QNetworkReply::NetworkError)
    finished                 : ClassVar[Signal] = ... # finished()
    metaDataChanged          : ClassVar[Signal] = ... # metaDataChanged()
    preSharedKeyAuthenticationRequired: ClassVar[Signal] = ... # preSharedKeyAuthenticationRequired(QSslPreSharedKeyAuthenticator*)
    redirectAllowed          : ClassVar[Signal] = ... # redirectAllowed()
    redirected               : ClassVar[Signal] = ... # redirected(QUrl)
    requestSent              : ClassVar[Signal] = ... # requestSent()
    socketStartedConnecting  : ClassVar[Signal] = ... # socketStartedConnecting()
    sslErrors                : ClassVar[Signal] = ... # sslErrors(QList<QSslError>)
    uploadProgress           : ClassVar[Signal] = ... # uploadProgress(qlonglong,qlonglong)

    class NetworkError(enum.Enum):

        NoError                  : QNetworkReply.NetworkError = ... # 0x0
        ConnectionRefusedError   : QNetworkReply.NetworkError = ... # 0x1
        RemoteHostClosedError    : QNetworkReply.NetworkError = ... # 0x2
        HostNotFoundError        : QNetworkReply.NetworkError = ... # 0x3
        TimeoutError             : QNetworkReply.NetworkError = ... # 0x4
        OperationCanceledError   : QNetworkReply.NetworkError = ... # 0x5
        SslHandshakeFailedError  : QNetworkReply.NetworkError = ... # 0x6
        TemporaryNetworkFailureError: QNetworkReply.NetworkError = ... # 0x7
        NetworkSessionFailedError: QNetworkReply.NetworkError = ... # 0x8
        BackgroundRequestNotAllowedError: QNetworkReply.NetworkError = ... # 0x9
        TooManyRedirectsError    : QNetworkReply.NetworkError = ... # 0xa
        InsecureRedirectError    : QNetworkReply.NetworkError = ... # 0xb
        UnknownNetworkError      : QNetworkReply.NetworkError = ... # 0x63
        ProxyConnectionRefusedError: QNetworkReply.NetworkError = ... # 0x65
        ProxyConnectionClosedError: QNetworkReply.NetworkError = ... # 0x66
        ProxyNotFoundError       : QNetworkReply.NetworkError = ... # 0x67
        ProxyTimeoutError        : QNetworkReply.NetworkError = ... # 0x68
        ProxyAuthenticationRequiredError: QNetworkReply.NetworkError = ... # 0x69
        UnknownProxyError        : QNetworkReply.NetworkError = ... # 0xc7
        ContentAccessDenied      : QNetworkReply.NetworkError = ... # 0xc9
        ContentOperationNotPermittedError: QNetworkReply.NetworkError = ... # 0xca
        ContentNotFoundError     : QNetworkReply.NetworkError = ... # 0xcb
        AuthenticationRequiredError: QNetworkReply.NetworkError = ... # 0xcc
        ContentReSendError       : QNetworkReply.NetworkError = ... # 0xcd
        ContentConflictError     : QNetworkReply.NetworkError = ... # 0xce
        ContentGoneError         : QNetworkReply.NetworkError = ... # 0xcf
        UnknownContentError      : QNetworkReply.NetworkError = ... # 0x12b
        ProtocolUnknownError     : QNetworkReply.NetworkError = ... # 0x12d
        ProtocolInvalidOperationError: QNetworkReply.NetworkError = ... # 0x12e
        ProtocolFailure          : QNetworkReply.NetworkError = ... # 0x18f
        InternalServerError      : QNetworkReply.NetworkError = ... # 0x191
        OperationNotImplementedError: QNetworkReply.NetworkError = ... # 0x192
        ServiceUnavailableError  : QNetworkReply.NetworkError = ... # 0x193
        UnknownServerError       : QNetworkReply.NetworkError = ... # 0x1f3


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def abort(self) -> None: ...
    def attribute(self, code: PySide6.QtNetwork.QNetworkRequest.Attribute) -> Any: ...
    def close(self) -> None: ...
    def error(self) -> PySide6.QtNetwork.QNetworkReply.NetworkError: ...
    def hasRawHeader(self, headerName: str) -> bool: ...
    def header(self, header: PySide6.QtNetwork.QNetworkRequest.KnownHeaders) -> Any: ...
    @overload
    def ignoreSslErrors(self) -> None: ...
    @overload
    def ignoreSslErrors(self, errors: Sequence[PySide6.QtNetwork.QSslError]) -> None: ...
    def ignoreSslErrorsImplementation(self, arg__1: Sequence[PySide6.QtNetwork.QSslError]) -> None: ...
    def isFinished(self) -> bool: ...
    def isRunning(self) -> bool: ...
    def isSequential(self) -> bool: ...
    def manager(self) -> PySide6.QtNetwork.QNetworkAccessManager: ...
    def operation(self) -> PySide6.QtNetwork.QNetworkAccessManager.Operation: ...
    def rawHeader(self, headerName: str) -> PySide6.QtCore.QByteArray: ...
    def rawHeaderList(self) -> List[PySide6.QtCore.QByteArray]: ...
    def rawHeaderPairs(self) -> List[Tuple[PySide6.QtCore.QByteArray, PySide6.QtCore.QByteArray]]: ...
    def readBufferSize(self) -> int: ...
    def request(self) -> PySide6.QtNetwork.QNetworkRequest: ...
    def setAttribute(self, code: PySide6.QtNetwork.QNetworkRequest.Attribute, value: Any) -> None: ...
    def setError(self, errorCode: PySide6.QtNetwork.QNetworkReply.NetworkError, errorString: str) -> None: ...
    def setFinished(self, arg__1: bool) -> None: ...
    def setHeader(self, header: PySide6.QtNetwork.QNetworkRequest.KnownHeaders, value: Any) -> None: ...
    def setOperation(self, operation: PySide6.QtNetwork.QNetworkAccessManager.Operation) -> None: ...
    def setRawHeader(self, headerName: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], value: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def setRequest(self, request: PySide6.QtNetwork.QNetworkRequest) -> None: ...
    def setSslConfiguration(self, configuration: PySide6.QtNetwork.QSslConfiguration) -> None: ...
    def setSslConfigurationImplementation(self, arg__1: PySide6.QtNetwork.QSslConfiguration) -> None: ...
    def setUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def sslConfiguration(self) -> PySide6.QtNetwork.QSslConfiguration: ...
    def sslConfigurationImplementation(self, arg__1: PySide6.QtNetwork.QSslConfiguration) -> None: ...
    def url(self) -> PySide6.QtCore.QUrl: ...
    def writeData(self, data: Union[bytes, bytearray, memoryview], len: int) -> int: ...


class QNetworkRequest(Shiboken.Object):

    class Attribute(enum.Enum):

        HttpStatusCodeAttribute  : QNetworkRequest.Attribute = ... # 0x0
        HttpReasonPhraseAttribute: QNetworkRequest.Attribute = ... # 0x1
        RedirectionTargetAttribute: QNetworkRequest.Attribute = ... # 0x2
        ConnectionEncryptedAttribute: QNetworkRequest.Attribute = ... # 0x3
        CacheLoadControlAttribute: QNetworkRequest.Attribute = ... # 0x4
        CacheSaveControlAttribute: QNetworkRequest.Attribute = ... # 0x5
        SourceIsFromCacheAttribute: QNetworkRequest.Attribute = ... # 0x6
        DoNotBufferUploadDataAttribute: QNetworkRequest.Attribute = ... # 0x7
        HttpPipeliningAllowedAttribute: QNetworkRequest.Attribute = ... # 0x8
        HttpPipeliningWasUsedAttribute: QNetworkRequest.Attribute = ... # 0x9
        CustomVerbAttribute      : QNetworkRequest.Attribute = ... # 0xa
        CookieLoadControlAttribute: QNetworkRequest.Attribute = ... # 0xb
        AuthenticationReuseAttribute: QNetworkRequest.Attribute = ... # 0xc
        CookieSaveControlAttribute: QNetworkRequest.Attribute = ... # 0xd
        MaximumDownloadBufferSizeAttribute: QNetworkRequest.Attribute = ... # 0xe
        DownloadBufferAttribute  : QNetworkRequest.Attribute = ... # 0xf
        SynchronousRequestAttribute: QNetworkRequest.Attribute = ... # 0x10
        BackgroundRequestAttribute: QNetworkRequest.Attribute = ... # 0x11
        EmitAllUploadProgressSignalsAttribute: QNetworkRequest.Attribute = ... # 0x12
        Http2AllowedAttribute    : QNetworkRequest.Attribute = ... # 0x13
        Http2WasUsedAttribute    : QNetworkRequest.Attribute = ... # 0x14
        OriginalContentLengthAttribute: QNetworkRequest.Attribute = ... # 0x15
        RedirectPolicyAttribute  : QNetworkRequest.Attribute = ... # 0x16
        Http2DirectAttribute     : QNetworkRequest.Attribute = ... # 0x17
        ResourceTypeAttribute    : QNetworkRequest.Attribute = ... # 0x18
        AutoDeleteReplyOnFinishAttribute: QNetworkRequest.Attribute = ... # 0x19
        ConnectionCacheExpiryTimeoutSecondsAttribute: QNetworkRequest.Attribute = ... # 0x1a
        Http2CleartextAllowedAttribute: QNetworkRequest.Attribute = ... # 0x1b
        UseCredentialsAttribute  : QNetworkRequest.Attribute = ... # 0x1c
        User                     : QNetworkRequest.Attribute = ... # 0x3e8
        UserMax                  : QNetworkRequest.Attribute = ... # 0x7fff

    class CacheLoadControl(enum.Enum):

        AlwaysNetwork            : QNetworkRequest.CacheLoadControl = ... # 0x0
        PreferNetwork            : QNetworkRequest.CacheLoadControl = ... # 0x1
        PreferCache              : QNetworkRequest.CacheLoadControl = ... # 0x2
        AlwaysCache              : QNetworkRequest.CacheLoadControl = ... # 0x3

    class KnownHeaders(enum.Enum):

        ContentTypeHeader        : QNetworkRequest.KnownHeaders = ... # 0x0
        ContentLengthHeader      : QNetworkRequest.KnownHeaders = ... # 0x1
        LocationHeader           : QNetworkRequest.KnownHeaders = ... # 0x2
        LastModifiedHeader       : QNetworkRequest.KnownHeaders = ... # 0x3
        CookieHeader             : QNetworkRequest.KnownHeaders = ... # 0x4
        SetCookieHeader          : QNetworkRequest.KnownHeaders = ... # 0x5
        ContentDispositionHeader : QNetworkRequest.KnownHeaders = ... # 0x6
        UserAgentHeader          : QNetworkRequest.KnownHeaders = ... # 0x7
        ServerHeader             : QNetworkRequest.KnownHeaders = ... # 0x8
        IfModifiedSinceHeader    : QNetworkRequest.KnownHeaders = ... # 0x9
        ETagHeader               : QNetworkRequest.KnownHeaders = ... # 0xa
        IfMatchHeader            : QNetworkRequest.KnownHeaders = ... # 0xb
        IfNoneMatchHeader        : QNetworkRequest.KnownHeaders = ... # 0xc

    class LoadControl(enum.Enum):

        Automatic                : QNetworkRequest.LoadControl = ... # 0x0
        Manual                   : QNetworkRequest.LoadControl = ... # 0x1

    class Priority(enum.Enum):

        HighPriority             : QNetworkRequest.Priority = ... # 0x1
        NormalPriority           : QNetworkRequest.Priority = ... # 0x3
        LowPriority              : QNetworkRequest.Priority = ... # 0x5

    class RedirectPolicy(enum.Enum):

        ManualRedirectPolicy     : QNetworkRequest.RedirectPolicy = ... # 0x0
        NoLessSafeRedirectPolicy : QNetworkRequest.RedirectPolicy = ... # 0x1
        SameOriginRedirectPolicy : QNetworkRequest.RedirectPolicy = ... # 0x2
        UserVerifiedRedirectPolicy: QNetworkRequest.RedirectPolicy = ... # 0x3

    class TransferTimeoutConstant(enum.Enum):

        DefaultTransferTimeoutConstant: QNetworkRequest.TransferTimeoutConstant = ... # 0x7530


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QNetworkRequest) -> None: ...
    @overload
    def __init__(self, url: Union[PySide6.QtCore.QUrl, str]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def attribute(self, code: PySide6.QtNetwork.QNetworkRequest.Attribute, defaultValue: Any = ...) -> Any: ...
    def decompressedSafetyCheckThreshold(self) -> int: ...
    def hasRawHeader(self, headerName: str) -> bool: ...
    def header(self, header: PySide6.QtNetwork.QNetworkRequest.KnownHeaders) -> Any: ...
    def http2Configuration(self) -> PySide6.QtNetwork.QHttp2Configuration: ...
    def maximumRedirectsAllowed(self) -> int: ...
    def originatingObject(self) -> PySide6.QtCore.QObject: ...
    def peerVerifyName(self) -> str: ...
    def priority(self) -> PySide6.QtNetwork.QNetworkRequest.Priority: ...
    def rawHeader(self, headerName: str) -> PySide6.QtCore.QByteArray: ...
    def rawHeaderList(self) -> List[PySide6.QtCore.QByteArray]: ...
    def setAttribute(self, code: PySide6.QtNetwork.QNetworkRequest.Attribute, value: Any) -> None: ...
    def setDecompressedSafetyCheckThreshold(self, threshold: int) -> None: ...
    def setHeader(self, header: PySide6.QtNetwork.QNetworkRequest.KnownHeaders, value: Any) -> None: ...
    def setHttp2Configuration(self, configuration: PySide6.QtNetwork.QHttp2Configuration) -> None: ...
    def setMaximumRedirectsAllowed(self, maximumRedirectsAllowed: int) -> None: ...
    def setOriginatingObject(self, object: PySide6.QtCore.QObject) -> None: ...
    def setPeerVerifyName(self, peerName: str) -> None: ...
    def setPriority(self, priority: PySide6.QtNetwork.QNetworkRequest.Priority) -> None: ...
    def setRawHeader(self, headerName: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], value: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def setSslConfiguration(self, configuration: PySide6.QtNetwork.QSslConfiguration) -> None: ...
    def setTransferTimeout(self, timeout: int) -> None: ...
    def setUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def sslConfiguration(self) -> PySide6.QtNetwork.QSslConfiguration: ...
    def swap(self, other: PySide6.QtNetwork.QNetworkRequest) -> None: ...
    def transferTimeout(self) -> int: ...
    def url(self) -> PySide6.QtCore.QUrl: ...


class QNetworkRequestFactory(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, baseUrl: Union[PySide6.QtCore.QUrl, str]) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QNetworkRequestFactory) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def baseUrl(self) -> PySide6.QtCore.QUrl: ...
    def bearerToken(self) -> PySide6.QtCore.QByteArray: ...
    def clearBearerToken(self) -> None: ...
    def clearCommonHeaders(self) -> None: ...
    def clearPassword(self) -> None: ...
    def clearQueryParameters(self) -> None: ...
    def clearUserName(self) -> None: ...
    def commonHeaders(self) -> PySide6.QtNetwork.QHttpHeaders: ...
    @overload
    def createRequest(self) -> PySide6.QtNetwork.QNetworkRequest: ...
    @overload
    def createRequest(self, path: str) -> PySide6.QtNetwork.QNetworkRequest: ...
    @overload
    def createRequest(self, path: str, query: PySide6.QtCore.QUrlQuery) -> PySide6.QtNetwork.QNetworkRequest: ...
    @overload
    def createRequest(self, query: PySide6.QtCore.QUrlQuery) -> PySide6.QtNetwork.QNetworkRequest: ...
    def password(self) -> str: ...
    def queryParameters(self) -> PySide6.QtCore.QUrlQuery: ...
    def setBaseUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def setBearerToken(self, token: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def setCommonHeaders(self, headers: PySide6.QtNetwork.QHttpHeaders) -> None: ...
    def setPassword(self, password: str) -> None: ...
    def setQueryParameters(self, query: PySide6.QtCore.QUrlQuery) -> None: ...
    def setSslConfiguration(self, configuration: PySide6.QtNetwork.QSslConfiguration) -> None: ...
    def setUserName(self, userName: str) -> None: ...
    def sslConfiguration(self) -> PySide6.QtNetwork.QSslConfiguration: ...
    def swap(self, other: PySide6.QtNetwork.QNetworkRequestFactory) -> None: ...
    def userName(self) -> str: ...


class QOcspCertificateStatus(enum.Enum):

    Good                     : QOcspCertificateStatus = ... # 0x0
    Revoked                  : QOcspCertificateStatus = ... # 0x1
    Unknown                  : QOcspCertificateStatus = ... # 0x2


class QOcspResponse(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QOcspResponse) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def certificateStatus(self) -> PySide6.QtNetwork.QOcspCertificateStatus: ...
    def responder(self) -> PySide6.QtNetwork.QSslCertificate: ...
    def revocationReason(self) -> PySide6.QtNetwork.QOcspRevocationReason: ...
    def subject(self) -> PySide6.QtNetwork.QSslCertificate: ...
    def swap(self, other: PySide6.QtNetwork.QOcspResponse) -> None: ...


class QOcspRevocationReason(enum.Enum):

    None_                    : QOcspRevocationReason = ... # -0x1
    Unspecified              : QOcspRevocationReason = ... # 0x0
    KeyCompromise            : QOcspRevocationReason = ... # 0x1
    CACompromise             : QOcspRevocationReason = ... # 0x2
    AffiliationChanged       : QOcspRevocationReason = ... # 0x3
    Superseded               : QOcspRevocationReason = ... # 0x4
    CessationOfOperation     : QOcspRevocationReason = ... # 0x5
    CertificateHold          : QOcspRevocationReason = ... # 0x6
    RemoveFromCRL            : QOcspRevocationReason = ... # 0x7


class QPasswordDigestor(Shiboken.Object):
    @staticmethod
    def deriveKeyPbkdf1(algorithm: PySide6.QtCore.QCryptographicHash.Algorithm, password: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], salt: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], iterations: int, dkLen: int) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def deriveKeyPbkdf2(algorithm: PySide6.QtCore.QCryptographicHash.Algorithm, password: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], salt: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], iterations: int, dkLen: int) -> PySide6.QtCore.QByteArray: ...


class QRestAccessManager(PySide6.QtCore.QObject):

    def __init__(self, manager: PySide6.QtNetwork.QNetworkAccessManager, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    @overload
    def deleteResource(self, request: PySide6.QtNetwork.QNetworkRequest) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def deleteResource(self, request: PySide6.QtNetwork.QNetworkRequest, context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def get(self, request: PySide6.QtNetwork.QNetworkRequest) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def get(self, request: PySide6.QtNetwork.QNetworkRequest, context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def get(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QIODevice) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def get(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QIODevice, context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def get(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QJsonDocument) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def get(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QJsonDocument, context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def get(self, request: PySide6.QtNetwork.QNetworkRequest, data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def get(self, request: PySide6.QtNetwork.QNetworkRequest, data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def head(self, request: PySide6.QtNetwork.QNetworkRequest) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def head(self, request: PySide6.QtNetwork.QNetworkRequest, context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    def networkAccessManager(self) -> PySide6.QtNetwork.QNetworkAccessManager: ...
    @overload
    def patch(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QIODevice) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def patch(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QIODevice, context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def patch(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QJsonDocument) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def patch(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QJsonDocument, context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def patch(self, request: PySide6.QtNetwork.QNetworkRequest, data: Dict[str, Any]) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def patch(self, request: PySide6.QtNetwork.QNetworkRequest, data: Dict[str, Any], context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def patch(self, request: PySide6.QtNetwork.QNetworkRequest, data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def patch(self, request: PySide6.QtNetwork.QNetworkRequest, data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def post(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QIODevice) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def post(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QIODevice, context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def post(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QJsonDocument) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def post(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QJsonDocument, context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def post(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtNetwork.QHttpMultiPart) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def post(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtNetwork.QHttpMultiPart, context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def post(self, request: PySide6.QtNetwork.QNetworkRequest, data: Dict[str, Any]) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def post(self, request: PySide6.QtNetwork.QNetworkRequest, data: Dict[str, Any], context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def post(self, request: PySide6.QtNetwork.QNetworkRequest, data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def post(self, request: PySide6.QtNetwork.QNetworkRequest, data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def put(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QIODevice) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def put(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QIODevice, context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def put(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QJsonDocument) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def put(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtCore.QJsonDocument, context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def put(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtNetwork.QHttpMultiPart) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def put(self, request: PySide6.QtNetwork.QNetworkRequest, data: PySide6.QtNetwork.QHttpMultiPart, context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def put(self, request: PySide6.QtNetwork.QNetworkRequest, data: Dict[str, Any]) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def put(self, request: PySide6.QtNetwork.QNetworkRequest, data: Dict[str, Any], context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def put(self, request: PySide6.QtNetwork.QNetworkRequest, data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def put(self, request: PySide6.QtNetwork.QNetworkRequest, data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def sendCustomRequest(self, request: PySide6.QtNetwork.QNetworkRequest, method: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], data: PySide6.QtCore.QIODevice) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def sendCustomRequest(self, request: PySide6.QtNetwork.QNetworkRequest, method: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], data: PySide6.QtCore.QIODevice, context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def sendCustomRequest(self, request: PySide6.QtNetwork.QNetworkRequest, method: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], data: PySide6.QtNetwork.QHttpMultiPart) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def sendCustomRequest(self, request: PySide6.QtNetwork.QNetworkRequest, method: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], data: PySide6.QtNetwork.QHttpMultiPart, context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def sendCustomRequest(self, request: PySide6.QtNetwork.QNetworkRequest, method: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> PySide6.QtNetwork.QNetworkReply: ...
    @overload
    def sendCustomRequest(self, request: PySide6.QtNetwork.QNetworkRequest, method: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], context: PySide6.QtCore.QObject, slot: Callable) -> PySide6.QtNetwork.QNetworkReply: ...


class QRestReply(Shiboken.Object):

    def __init__(self, reply: PySide6.QtNetwork.QNetworkReply) -> None: ...

    def error(self) -> PySide6.QtNetwork.QNetworkReply.NetworkError: ...
    def errorString(self) -> str: ...
    def hasError(self) -> bool: ...
    def httpStatus(self) -> int: ...
    def isHttpStatusSuccess(self) -> bool: ...
    def isSuccess(self) -> bool: ...
    def networkReply(self) -> PySide6.QtNetwork.QNetworkReply: ...
    def readBody(self) -> PySide6.QtCore.QByteArray: ...
    def readJson(self) -> Tuple[Optional[PySide6.QtCore.QJsonDocument], PySide6.QtCore.QJsonParseError]: ...
    def readText(self) -> str: ...
    def swap(self, other: PySide6.QtNetwork.QRestReply) -> None: ...


class QSsl(Shiboken.Object):

    class AlertLevel(enum.Enum):

        Warning                  : QSsl.AlertLevel = ... # 0x0
        Fatal                    : QSsl.AlertLevel = ... # 0x1
        Unknown                  : QSsl.AlertLevel = ... # 0x2

    class AlertType(enum.Enum):

        CloseNotify              : QSsl.AlertType = ... # 0x0
        UnexpectedMessage        : QSsl.AlertType = ... # 0xa
        BadRecordMac             : QSsl.AlertType = ... # 0x14
        RecordOverflow           : QSsl.AlertType = ... # 0x16
        DecompressionFailure     : QSsl.AlertType = ... # 0x1e
        HandshakeFailure         : QSsl.AlertType = ... # 0x28
        NoCertificate            : QSsl.AlertType = ... # 0x29
        BadCertificate           : QSsl.AlertType = ... # 0x2a
        UnsupportedCertificate   : QSsl.AlertType = ... # 0x2b
        CertificateRevoked       : QSsl.AlertType = ... # 0x2c
        CertificateExpired       : QSsl.AlertType = ... # 0x2d
        CertificateUnknown       : QSsl.AlertType = ... # 0x2e
        IllegalParameter         : QSsl.AlertType = ... # 0x2f
        UnknownCa                : QSsl.AlertType = ... # 0x30
        AccessDenied             : QSsl.AlertType = ... # 0x31
        DecodeError              : QSsl.AlertType = ... # 0x32
        DecryptError             : QSsl.AlertType = ... # 0x33
        ExportRestriction        : QSsl.AlertType = ... # 0x3c
        ProtocolVersion          : QSsl.AlertType = ... # 0x46
        InsufficientSecurity     : QSsl.AlertType = ... # 0x47
        InternalError            : QSsl.AlertType = ... # 0x50
        InappropriateFallback    : QSsl.AlertType = ... # 0x56
        UserCancelled            : QSsl.AlertType = ... # 0x5a
        NoRenegotiation          : QSsl.AlertType = ... # 0x64
        MissingExtension         : QSsl.AlertType = ... # 0x6d
        UnsupportedExtension     : QSsl.AlertType = ... # 0x6e
        CertificateUnobtainable  : QSsl.AlertType = ... # 0x6f
        UnrecognizedName         : QSsl.AlertType = ... # 0x70
        BadCertificateStatusResponse: QSsl.AlertType = ... # 0x71
        BadCertificateHashValue  : QSsl.AlertType = ... # 0x72
        UnknownPskIdentity       : QSsl.AlertType = ... # 0x73
        CertificateRequired      : QSsl.AlertType = ... # 0x74
        NoApplicationProtocol    : QSsl.AlertType = ... # 0x78
        UnknownAlertMessage      : QSsl.AlertType = ... # 0xff

    class AlternativeNameEntryType(enum.Enum):

        EmailEntry               : QSsl.AlternativeNameEntryType = ... # 0x0
        DnsEntry                 : QSsl.AlternativeNameEntryType = ... # 0x1
        IpAddressEntry           : QSsl.AlternativeNameEntryType = ... # 0x2

    class EncodingFormat(enum.Enum):

        Pem                      : QSsl.EncodingFormat = ... # 0x0
        Der                      : QSsl.EncodingFormat = ... # 0x1

    class ImplementedClass(enum.Enum):

        Key                      : QSsl.ImplementedClass = ... # 0x0
        Certificate              : QSsl.ImplementedClass = ... # 0x1
        Socket                   : QSsl.ImplementedClass = ... # 0x2
        DiffieHellman            : QSsl.ImplementedClass = ... # 0x3
        EllipticCurve            : QSsl.ImplementedClass = ... # 0x4
        Dtls                     : QSsl.ImplementedClass = ... # 0x5
        DtlsCookie               : QSsl.ImplementedClass = ... # 0x6

    class KeyAlgorithm(enum.Enum):

        Opaque                   : QSsl.KeyAlgorithm = ... # 0x0
        Rsa                      : QSsl.KeyAlgorithm = ... # 0x1
        Dsa                      : QSsl.KeyAlgorithm = ... # 0x2
        Ec                       : QSsl.KeyAlgorithm = ... # 0x3
        Dh                       : QSsl.KeyAlgorithm = ... # 0x4

    class KeyType(enum.Enum):

        PrivateKey               : QSsl.KeyType = ... # 0x0
        PublicKey                : QSsl.KeyType = ... # 0x1

    class SslOption(enum.Flag):

        SslOptionDisableEmptyFragments: QSsl.SslOption = ... # 0x1
        SslOptionDisableSessionTickets: QSsl.SslOption = ... # 0x2
        SslOptionDisableCompression: QSsl.SslOption = ... # 0x4
        SslOptionDisableServerNameIndication: QSsl.SslOption = ... # 0x8
        SslOptionDisableLegacyRenegotiation: QSsl.SslOption = ... # 0x10
        SslOptionDisableSessionSharing: QSsl.SslOption = ... # 0x20
        SslOptionDisableSessionPersistence: QSsl.SslOption = ... # 0x40
        SslOptionDisableServerCipherPreference: QSsl.SslOption = ... # 0x80

    class SslProtocol(enum.Enum):

        UnknownProtocol          : QSsl.SslProtocol = ... # -0x1
        TlsV1_0                  : QSsl.SslProtocol = ... # 0x0
        TlsV1_1                  : QSsl.SslProtocol = ... # 0x1
        TlsV1_2                  : QSsl.SslProtocol = ... # 0x2
        AnyProtocol              : QSsl.SslProtocol = ... # 0x3
        SecureProtocols          : QSsl.SslProtocol = ... # 0x4
        TlsV1_0OrLater           : QSsl.SslProtocol = ... # 0x5
        TlsV1_1OrLater           : QSsl.SslProtocol = ... # 0x6
        TlsV1_2OrLater           : QSsl.SslProtocol = ... # 0x7
        DtlsV1_0                 : QSsl.SslProtocol = ... # 0x8
        DtlsV1_0OrLater          : QSsl.SslProtocol = ... # 0x9
        DtlsV1_2                 : QSsl.SslProtocol = ... # 0xa
        DtlsV1_2OrLater          : QSsl.SslProtocol = ... # 0xb
        TlsV1_3                  : QSsl.SslProtocol = ... # 0xc
        TlsV1_3OrLater           : QSsl.SslProtocol = ... # 0xd

    class SupportedFeature(enum.Enum):

        CertificateVerification  : QSsl.SupportedFeature = ... # 0x0
        ClientSideAlpn           : QSsl.SupportedFeature = ... # 0x1
        ServerSideAlpn           : QSsl.SupportedFeature = ... # 0x2
        Ocsp                     : QSsl.SupportedFeature = ... # 0x3
        Psk                      : QSsl.SupportedFeature = ... # 0x4
        SessionTicket            : QSsl.SupportedFeature = ... # 0x5
        Alerts                   : QSsl.SupportedFeature = ... # 0x6


class QSslCertificate(Shiboken.Object):

    class PatternSyntax(enum.Enum):

        RegularExpression        : QSslCertificate.PatternSyntax = ... # 0x0
        Wildcard                 : QSslCertificate.PatternSyntax = ... # 0x1
        FixedString              : QSslCertificate.PatternSyntax = ... # 0x2

    class SubjectInfo(enum.Enum):

        Organization             : QSslCertificate.SubjectInfo = ... # 0x0
        CommonName               : QSslCertificate.SubjectInfo = ... # 0x1
        LocalityName             : QSslCertificate.SubjectInfo = ... # 0x2
        OrganizationalUnitName   : QSslCertificate.SubjectInfo = ... # 0x3
        CountryName              : QSslCertificate.SubjectInfo = ... # 0x4
        StateOrProvinceName      : QSslCertificate.SubjectInfo = ... # 0x5
        DistinguishedNameQualifier: QSslCertificate.SubjectInfo = ... # 0x6
        SerialNumber             : QSslCertificate.SubjectInfo = ... # 0x7
        EmailAddress             : QSslCertificate.SubjectInfo = ... # 0x8


    @overload
    def __init__(self, data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview] = ..., format: PySide6.QtNetwork.QSsl.EncodingFormat = ...) -> None: ...
    @overload
    def __init__(self, device: PySide6.QtCore.QIODevice, format: PySide6.QtNetwork.QSsl.EncodingFormat = ...) -> None: ...
    @overload
    def __init__(self, other: Union[PySide6.QtNetwork.QSslCertificate, PySide6.QtCore.QIODevice]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def clear(self) -> None: ...
    def digest(self, algorithm: PySide6.QtCore.QCryptographicHash.Algorithm = ...) -> PySide6.QtCore.QByteArray: ...
    def effectiveDate(self) -> PySide6.QtCore.QDateTime: ...
    def expiryDate(self) -> PySide6.QtCore.QDateTime: ...
    def extensions(self) -> List[PySide6.QtNetwork.QSslCertificateExtension]: ...
    @staticmethod
    def fromData(data: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], format: PySide6.QtNetwork.QSsl.EncodingFormat = ...) -> List[PySide6.QtNetwork.QSslCertificate]: ...
    @staticmethod
    def fromDevice(device: PySide6.QtCore.QIODevice, format: PySide6.QtNetwork.QSsl.EncodingFormat = ...) -> List[PySide6.QtNetwork.QSslCertificate]: ...
    @staticmethod
    def fromPath(path: str, format: PySide6.QtNetwork.QSsl.EncodingFormat = ..., syntax: PySide6.QtNetwork.QSslCertificate.PatternSyntax = ...) -> List[PySide6.QtNetwork.QSslCertificate]: ...
    def handle(self) -> int: ...
    @staticmethod
    def importPkcs12(device: PySide6.QtCore.QIODevice, key: Union[PySide6.QtNetwork.QSslKey, int], cert: Union[PySide6.QtNetwork.QSslCertificate, PySide6.QtCore.QIODevice], caCertificates: Optional[Sequence[PySide6.QtNetwork.QSslCertificate]] = ..., passPhrase: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview] = ...) -> bool: ...
    def isBlacklisted(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isSelfSigned(self) -> bool: ...
    def issuerDisplayName(self) -> str: ...
    @overload
    def issuerInfo(self, attribute: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> List[str]: ...
    @overload
    def issuerInfo(self, info: PySide6.QtNetwork.QSslCertificate.SubjectInfo) -> List[str]: ...
    def issuerInfoAttributes(self) -> List[PySide6.QtCore.QByteArray]: ...
    def publicKey(self) -> PySide6.QtNetwork.QSslKey: ...
    def serialNumber(self) -> PySide6.QtCore.QByteArray: ...
    def subjectAlternativeNames(self) -> OrderedDict[PySide6.QtNetwork.QSsl.AlternativeNameEntryType, List[str]]: ...
    def subjectDisplayName(self) -> str: ...
    @overload
    def subjectInfo(self, attribute: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> List[str]: ...
    @overload
    def subjectInfo(self, info: PySide6.QtNetwork.QSslCertificate.SubjectInfo) -> List[str]: ...
    def subjectInfoAttributes(self) -> List[PySide6.QtCore.QByteArray]: ...
    def swap(self, other: Union[PySide6.QtNetwork.QSslCertificate, PySide6.QtCore.QIODevice]) -> None: ...
    def toDer(self) -> PySide6.QtCore.QByteArray: ...
    def toPem(self) -> PySide6.QtCore.QByteArray: ...
    def toText(self) -> str: ...
    @staticmethod
    def verify(certificateChain: Sequence[PySide6.QtNetwork.QSslCertificate], hostName: str = ...) -> List[PySide6.QtNetwork.QSslError]: ...
    def version(self) -> PySide6.QtCore.QByteArray: ...


class QSslCertificateExtension(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QSslCertificateExtension) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def isCritical(self) -> bool: ...
    def isSupported(self) -> bool: ...
    def name(self) -> str: ...
    def oid(self) -> str: ...
    def swap(self, other: PySide6.QtNetwork.QSslCertificateExtension) -> None: ...
    def value(self) -> Any: ...


class QSslCipher(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, name: str) -> None: ...
    @overload
    def __init__(self, name: str, protocol: PySide6.QtNetwork.QSsl.SslProtocol) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QSslCipher) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def authenticationMethod(self) -> str: ...
    def encryptionMethod(self) -> str: ...
    def isNull(self) -> bool: ...
    def keyExchangeMethod(self) -> str: ...
    def name(self) -> str: ...
    def protocol(self) -> PySide6.QtNetwork.QSsl.SslProtocol: ...
    def protocolString(self) -> str: ...
    def supportedBits(self) -> int: ...
    def swap(self, other: PySide6.QtNetwork.QSslCipher) -> None: ...
    def usedBits(self) -> int: ...


class QSslConfiguration(Shiboken.Object):

    class NextProtocolNegotiationStatus(enum.Enum):

        NextProtocolNegotiationNone: QSslConfiguration.NextProtocolNegotiationStatus = ... # 0x0
        NextProtocolNegotiationNegotiated: QSslConfiguration.NextProtocolNegotiationStatus = ... # 0x1
        NextProtocolNegotiationUnsupported: QSslConfiguration.NextProtocolNegotiationStatus = ... # 0x2


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QSslConfiguration) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def addCaCertificate(self, certificate: Union[PySide6.QtNetwork.QSslCertificate, PySide6.QtCore.QIODevice]) -> None: ...
    @overload
    def addCaCertificates(self, certificates: Sequence[PySide6.QtNetwork.QSslCertificate]) -> None: ...
    @overload
    def addCaCertificates(self, path: str, format: PySide6.QtNetwork.QSsl.EncodingFormat = ..., syntax: PySide6.QtNetwork.QSslCertificate.PatternSyntax = ...) -> bool: ...
    def allowedNextProtocols(self) -> List[PySide6.QtCore.QByteArray]: ...
    def backendConfiguration(self) -> Dict[PySide6.QtCore.QByteArray, Any]: ...
    def caCertificates(self) -> List[PySide6.QtNetwork.QSslCertificate]: ...
    def ciphers(self) -> List[PySide6.QtNetwork.QSslCipher]: ...
    @staticmethod
    def defaultConfiguration() -> PySide6.QtNetwork.QSslConfiguration: ...
    @staticmethod
    def defaultDtlsConfiguration() -> PySide6.QtNetwork.QSslConfiguration: ...
    def diffieHellmanParameters(self) -> PySide6.QtNetwork.QSslDiffieHellmanParameters: ...
    def dtlsCookieVerificationEnabled(self) -> bool: ...
    def ellipticCurves(self) -> List[PySide6.QtNetwork.QSslEllipticCurve]: ...
    def ephemeralServerKey(self) -> PySide6.QtNetwork.QSslKey: ...
    def handshakeMustInterruptOnError(self) -> bool: ...
    def isNull(self) -> bool: ...
    def localCertificate(self) -> PySide6.QtNetwork.QSslCertificate: ...
    def localCertificateChain(self) -> List[PySide6.QtNetwork.QSslCertificate]: ...
    def missingCertificateIsFatal(self) -> bool: ...
    def nextNegotiatedProtocol(self) -> PySide6.QtCore.QByteArray: ...
    def nextProtocolNegotiationStatus(self) -> PySide6.QtNetwork.QSslConfiguration.NextProtocolNegotiationStatus: ...
    def ocspStaplingEnabled(self) -> bool: ...
    def peerCertificate(self) -> PySide6.QtNetwork.QSslCertificate: ...
    def peerCertificateChain(self) -> List[PySide6.QtNetwork.QSslCertificate]: ...
    def peerVerifyDepth(self) -> int: ...
    def peerVerifyMode(self) -> PySide6.QtNetwork.QSslSocket.PeerVerifyMode: ...
    def preSharedKeyIdentityHint(self) -> PySide6.QtCore.QByteArray: ...
    def privateKey(self) -> PySide6.QtNetwork.QSslKey: ...
    def protocol(self) -> PySide6.QtNetwork.QSsl.SslProtocol: ...
    def sessionCipher(self) -> PySide6.QtNetwork.QSslCipher: ...
    def sessionProtocol(self) -> PySide6.QtNetwork.QSsl.SslProtocol: ...
    def sessionTicket(self) -> PySide6.QtCore.QByteArray: ...
    def sessionTicketLifeTimeHint(self) -> int: ...
    def setAllowedNextProtocols(self, protocols: Sequence[PySide6.QtCore.QByteArray]) -> None: ...
    def setBackendConfiguration(self, backendConfiguration: Dict[PySide6.QtCore.QByteArray, Any] = ...) -> None: ...
    def setBackendConfigurationOption(self, name: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], value: Any) -> None: ...
    def setCaCertificates(self, certificates: Sequence[PySide6.QtNetwork.QSslCertificate]) -> None: ...
    @overload
    def setCiphers(self, ciphers: Sequence[PySide6.QtNetwork.QSslCipher]) -> None: ...
    @overload
    def setCiphers(self, ciphers: str) -> None: ...
    @staticmethod
    def setDefaultConfiguration(configuration: PySide6.QtNetwork.QSslConfiguration) -> None: ...
    @staticmethod
    def setDefaultDtlsConfiguration(configuration: PySide6.QtNetwork.QSslConfiguration) -> None: ...
    def setDiffieHellmanParameters(self, dhparams: PySide6.QtNetwork.QSslDiffieHellmanParameters) -> None: ...
    def setDtlsCookieVerificationEnabled(self, enable: bool) -> None: ...
    def setEllipticCurves(self, curves: Sequence[PySide6.QtNetwork.QSslEllipticCurve]) -> None: ...
    def setHandshakeMustInterruptOnError(self, interrupt: bool) -> None: ...
    def setLocalCertificate(self, certificate: Union[PySide6.QtNetwork.QSslCertificate, PySide6.QtCore.QIODevice]) -> None: ...
    def setLocalCertificateChain(self, localChain: Sequence[PySide6.QtNetwork.QSslCertificate]) -> None: ...
    def setMissingCertificateIsFatal(self, cannotRecover: bool) -> None: ...
    def setOcspStaplingEnabled(self, enable: bool) -> None: ...
    def setPeerVerifyDepth(self, depth: int) -> None: ...
    def setPeerVerifyMode(self, mode: PySide6.QtNetwork.QSslSocket.PeerVerifyMode) -> None: ...
    def setPreSharedKeyIdentityHint(self, hint: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def setPrivateKey(self, key: Union[PySide6.QtNetwork.QSslKey, int]) -> None: ...
    def setProtocol(self, protocol: PySide6.QtNetwork.QSsl.SslProtocol) -> None: ...
    def setSessionTicket(self, sessionTicket: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def setSslOption(self, option: PySide6.QtNetwork.QSsl.SslOption, on: bool) -> None: ...
    @staticmethod
    def supportedCiphers() -> List[PySide6.QtNetwork.QSslCipher]: ...
    @staticmethod
    def supportedEllipticCurves() -> List[PySide6.QtNetwork.QSslEllipticCurve]: ...
    def swap(self, other: PySide6.QtNetwork.QSslConfiguration) -> None: ...
    @staticmethod
    def systemCaCertificates() -> List[PySide6.QtNetwork.QSslCertificate]: ...
    def testSslOption(self, option: PySide6.QtNetwork.QSsl.SslOption) -> bool: ...


class QSslDiffieHellmanParameters(Shiboken.Object):

    class Error(enum.Enum):

        NoError                  : QSslDiffieHellmanParameters.Error = ... # 0x0
        InvalidInputDataError    : QSslDiffieHellmanParameters.Error = ... # 0x1
        UnsafeParametersError    : QSslDiffieHellmanParameters.Error = ... # 0x2


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QSslDiffieHellmanParameters) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def defaultParameters() -> PySide6.QtNetwork.QSslDiffieHellmanParameters: ...
    def error(self) -> PySide6.QtNetwork.QSslDiffieHellmanParameters.Error: ...
    def errorString(self) -> str: ...
    @overload
    @staticmethod
    def fromEncoded(device: PySide6.QtCore.QIODevice, format: PySide6.QtNetwork.QSsl.EncodingFormat = ...) -> PySide6.QtNetwork.QSslDiffieHellmanParameters: ...
    @overload
    @staticmethod
    def fromEncoded(encoded: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], format: PySide6.QtNetwork.QSsl.EncodingFormat = ...) -> PySide6.QtNetwork.QSslDiffieHellmanParameters: ...
    def isEmpty(self) -> bool: ...
    def isValid(self) -> bool: ...
    def swap(self, other: PySide6.QtNetwork.QSslDiffieHellmanParameters) -> None: ...


class QSslEllipticCurve(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QSslEllipticCurve: PySide6.QtNetwork.QSslEllipticCurve) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def fromLongName(name: str) -> PySide6.QtNetwork.QSslEllipticCurve: ...
    @staticmethod
    def fromShortName(name: str) -> PySide6.QtNetwork.QSslEllipticCurve: ...
    def isTlsNamedCurve(self) -> bool: ...
    def isValid(self) -> bool: ...
    def longName(self) -> str: ...
    def shortName(self) -> str: ...


class QSslError(Shiboken.Object):

    class SslError(enum.Enum):

        UnspecifiedError         : QSslError.SslError = ... # -0x1
        NoError                  : QSslError.SslError = ... # 0x0
        UnableToGetIssuerCertificate: QSslError.SslError = ... # 0x1
        UnableToDecryptCertificateSignature: QSslError.SslError = ... # 0x2
        UnableToDecodeIssuerPublicKey: QSslError.SslError = ... # 0x3
        CertificateSignatureFailed: QSslError.SslError = ... # 0x4
        CertificateNotYetValid   : QSslError.SslError = ... # 0x5
        CertificateExpired       : QSslError.SslError = ... # 0x6
        InvalidNotBeforeField    : QSslError.SslError = ... # 0x7
        InvalidNotAfterField     : QSslError.SslError = ... # 0x8
        SelfSignedCertificate    : QSslError.SslError = ... # 0x9
        SelfSignedCertificateInChain: QSslError.SslError = ... # 0xa
        UnableToGetLocalIssuerCertificate: QSslError.SslError = ... # 0xb
        UnableToVerifyFirstCertificate: QSslError.SslError = ... # 0xc
        CertificateRevoked       : QSslError.SslError = ... # 0xd
        InvalidCaCertificate     : QSslError.SslError = ... # 0xe
        PathLengthExceeded       : QSslError.SslError = ... # 0xf
        InvalidPurpose           : QSslError.SslError = ... # 0x10
        CertificateUntrusted     : QSslError.SslError = ... # 0x11
        CertificateRejected      : QSslError.SslError = ... # 0x12
        SubjectIssuerMismatch    : QSslError.SslError = ... # 0x13
        AuthorityIssuerSerialNumberMismatch: QSslError.SslError = ... # 0x14
        NoPeerCertificate        : QSslError.SslError = ... # 0x15
        HostNameMismatch         : QSslError.SslError = ... # 0x16
        NoSslSupport             : QSslError.SslError = ... # 0x17
        CertificateBlacklisted   : QSslError.SslError = ... # 0x18
        CertificateStatusUnknown : QSslError.SslError = ... # 0x19
        OcspNoResponseFound      : QSslError.SslError = ... # 0x1a
        OcspMalformedRequest     : QSslError.SslError = ... # 0x1b
        OcspMalformedResponse    : QSslError.SslError = ... # 0x1c
        OcspInternalError        : QSslError.SslError = ... # 0x1d
        OcspTryLater             : QSslError.SslError = ... # 0x1e
        OcspSigRequred           : QSslError.SslError = ... # 0x1f
        OcspUnauthorized         : QSslError.SslError = ... # 0x20
        OcspResponseCannotBeTrusted: QSslError.SslError = ... # 0x21
        OcspResponseCertIdUnknown: QSslError.SslError = ... # 0x22
        OcspResponseExpired      : QSslError.SslError = ... # 0x23
        OcspStatusUnknown        : QSslError.SslError = ... # 0x24


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, error: PySide6.QtNetwork.QSslError.SslError) -> None: ...
    @overload
    def __init__(self, error: PySide6.QtNetwork.QSslError.SslError, certificate: Union[PySide6.QtNetwork.QSslCertificate, PySide6.QtCore.QIODevice]) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtNetwork.QSslError) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def certificate(self) -> PySide6.QtNetwork.QSslCertificate: ...
    def error(self) -> PySide6.QtNetwork.QSslError.SslError: ...
    def errorString(self) -> str: ...
    def swap(self, other: PySide6.QtNetwork.QSslError) -> None: ...


class QSslKey(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, device: PySide6.QtCore.QIODevice, algorithm: PySide6.QtNetwork.QSsl.KeyAlgorithm, format: PySide6.QtNetwork.QSsl.EncodingFormat = ..., type: PySide6.QtNetwork.QSsl.KeyType = ..., passPhrase: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview] = ...) -> None: ...
    @overload
    def __init__(self, encoded: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], algorithm: PySide6.QtNetwork.QSsl.KeyAlgorithm, format: PySide6.QtNetwork.QSsl.EncodingFormat = ..., type: PySide6.QtNetwork.QSsl.KeyType = ..., passPhrase: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview] = ...) -> None: ...
    @overload
    def __init__(self, handle: int, type: PySide6.QtNetwork.QSsl.KeyType = ...) -> None: ...
    @overload
    def __init__(self, other: Union[PySide6.QtNetwork.QSslKey, int]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def algorithm(self) -> PySide6.QtNetwork.QSsl.KeyAlgorithm: ...
    def clear(self) -> None: ...
    def handle(self) -> int: ...
    def isNull(self) -> bool: ...
    def length(self) -> int: ...
    def swap(self, other: Union[PySide6.QtNetwork.QSslKey, int]) -> None: ...
    def toDer(self, passPhrase: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview] = ...) -> PySide6.QtCore.QByteArray: ...
    def toPem(self, passPhrase: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview] = ...) -> PySide6.QtCore.QByteArray: ...
    def type(self) -> PySide6.QtNetwork.QSsl.KeyType: ...


class QSslPreSharedKeyAuthenticator(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, authenticator: PySide6.QtNetwork.QSslPreSharedKeyAuthenticator) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def identity(self) -> PySide6.QtCore.QByteArray: ...
    def identityHint(self) -> PySide6.QtCore.QByteArray: ...
    def maximumIdentityLength(self) -> int: ...
    def maximumPreSharedKeyLength(self) -> int: ...
    def preSharedKey(self) -> PySide6.QtCore.QByteArray: ...
    def setIdentity(self, identity: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def setPreSharedKey(self, preSharedKey: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def swap(self, other: PySide6.QtNetwork.QSslPreSharedKeyAuthenticator) -> None: ...


class QSslServer(PySide6.QtNetwork.QTcpServer):

    alertReceived            : ClassVar[Signal] = ... # alertReceived(QSslSocket*,QSsl::AlertLevel,QSsl::AlertType,QString)
    alertSent                : ClassVar[Signal] = ... # alertSent(QSslSocket*,QSsl::AlertLevel,QSsl::AlertType,QString)
    errorOccurred            : ClassVar[Signal] = ... # errorOccurred(QSslSocket*,QAbstractSocket::SocketError)
    handshakeInterruptedOnError: ClassVar[Signal] = ... # handshakeInterruptedOnError(QSslSocket*,QSslError)
    peerVerifyError          : ClassVar[Signal] = ... # peerVerifyError(QSslSocket*,QSslError)
    preSharedKeyAuthenticationRequired: ClassVar[Signal] = ... # preSharedKeyAuthenticationRequired(QSslSocket*,QSslPreSharedKeyAuthenticator*)
    sslErrors                : ClassVar[Signal] = ... # sslErrors(QSslSocket*,QList<QSslError>)
    startedEncryptionHandshake: ClassVar[Signal] = ... # startedEncryptionHandshake(QSslSocket*)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def handshakeTimeout(self) -> int: ...
    def incomingConnection(self, socket: int) -> None: ...
    def setHandshakeTimeout(self, timeout: int) -> None: ...
    def setSslConfiguration(self, sslConfiguration: PySide6.QtNetwork.QSslConfiguration) -> None: ...
    def sslConfiguration(self) -> PySide6.QtNetwork.QSslConfiguration: ...


class QSslSocket(PySide6.QtNetwork.QTcpSocket):

    alertReceived            : ClassVar[Signal] = ... # alertReceived(QSsl::AlertLevel,QSsl::AlertType,QString)
    alertSent                : ClassVar[Signal] = ... # alertSent(QSsl::AlertLevel,QSsl::AlertType,QString)
    encrypted                : ClassVar[Signal] = ... # encrypted()
    encryptedBytesWritten    : ClassVar[Signal] = ... # encryptedBytesWritten(qlonglong)
    handshakeInterruptedOnError: ClassVar[Signal] = ... # handshakeInterruptedOnError(QSslError)
    modeChanged              : ClassVar[Signal] = ... # modeChanged(QSslSocket::SslMode)
    newSessionTicketReceived : ClassVar[Signal] = ... # newSessionTicketReceived()
    peerVerifyError          : ClassVar[Signal] = ... # peerVerifyError(QSslError)
    preSharedKeyAuthenticationRequired: ClassVar[Signal] = ... # preSharedKeyAuthenticationRequired(QSslPreSharedKeyAuthenticator*)
    sslErrors                : ClassVar[Signal] = ... # sslErrors(QList<QSslError>)

    class PeerVerifyMode(enum.Enum):

        VerifyNone               : QSslSocket.PeerVerifyMode = ... # 0x0
        QueryPeer                : QSslSocket.PeerVerifyMode = ... # 0x1
        VerifyPeer               : QSslSocket.PeerVerifyMode = ... # 0x2
        AutoVerifyPeer           : QSslSocket.PeerVerifyMode = ... # 0x3

    class SslMode(enum.Enum):

        UnencryptedMode          : QSslSocket.SslMode = ... # 0x0
        SslClientMode            : QSslSocket.SslMode = ... # 0x1
        SslServerMode            : QSslSocket.SslMode = ... # 0x2


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    @staticmethod
    def activeBackend() -> str: ...
    def atEnd(self) -> bool: ...
    @staticmethod
    def availableBackends() -> List[str]: ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def canReadLine(self) -> bool: ...
    def close(self) -> None: ...
    @overload
    def connectToHost(self, address: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], port: int, mode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ...) -> None: ...
    @overload
    def connectToHost(self, hostName: str, port: int, openMode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ..., protocol: PySide6.QtNetwork.QAbstractSocket.NetworkLayerProtocol = ...) -> None: ...
    @overload
    def connectToHostEncrypted(self, hostName: str, port: int, mode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ..., protocol: PySide6.QtNetwork.QAbstractSocket.NetworkLayerProtocol = ...) -> None: ...
    @overload
    def connectToHostEncrypted(self, hostName: str, port: int, sslPeerName: str, mode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ..., protocol: PySide6.QtNetwork.QAbstractSocket.NetworkLayerProtocol = ...) -> None: ...
    def continueInterruptedHandshake(self) -> None: ...
    def disconnectFromHost(self) -> None: ...
    def encryptedBytesAvailable(self) -> int: ...
    def encryptedBytesToWrite(self) -> int: ...
    @overload
    def ignoreSslErrors(self) -> None: ...
    @overload
    def ignoreSslErrors(self, errors: Sequence[PySide6.QtNetwork.QSslError]) -> None: ...
    @staticmethod
    def implementedClasses(backendName: str = ...) -> List[PySide6.QtNetwork.QSsl.ImplementedClass]: ...
    @staticmethod
    def isClassImplemented(cl: PySide6.QtNetwork.QSsl.ImplementedClass, backendName: str = ...) -> bool: ...
    def isEncrypted(self) -> bool: ...
    @staticmethod
    def isFeatureSupported(feat: PySide6.QtNetwork.QSsl.SupportedFeature, backendName: str = ...) -> bool: ...
    @staticmethod
    def isProtocolSupported(protocol: PySide6.QtNetwork.QSsl.SslProtocol, backendName: str = ...) -> bool: ...
    def localCertificate(self) -> PySide6.QtNetwork.QSslCertificate: ...
    def localCertificateChain(self) -> List[PySide6.QtNetwork.QSslCertificate]: ...
    def mode(self) -> PySide6.QtNetwork.QSslSocket.SslMode: ...
    def ocspResponses(self) -> List[PySide6.QtNetwork.QOcspResponse]: ...
    def peerCertificate(self) -> PySide6.QtNetwork.QSslCertificate: ...
    def peerCertificateChain(self) -> List[PySide6.QtNetwork.QSslCertificate]: ...
    def peerVerifyDepth(self) -> int: ...
    def peerVerifyMode(self) -> PySide6.QtNetwork.QSslSocket.PeerVerifyMode: ...
    def peerVerifyName(self) -> str: ...
    def privateKey(self) -> PySide6.QtNetwork.QSslKey: ...
    def protocol(self) -> PySide6.QtNetwork.QSsl.SslProtocol: ...
    def readData(self, maxlen: int) -> object: ...
    def resume(self) -> None: ...
    def sessionCipher(self) -> PySide6.QtNetwork.QSslCipher: ...
    def sessionProtocol(self) -> PySide6.QtNetwork.QSsl.SslProtocol: ...
    @staticmethod
    def setActiveBackend(backendName: str) -> bool: ...
    @overload
    def setLocalCertificate(self, certificate: Union[PySide6.QtNetwork.QSslCertificate, PySide6.QtCore.QIODevice]) -> None: ...
    @overload
    def setLocalCertificate(self, fileName: str, format: PySide6.QtNetwork.QSsl.EncodingFormat = ...) -> None: ...
    def setLocalCertificateChain(self, localChain: Sequence[PySide6.QtNetwork.QSslCertificate]) -> None: ...
    def setPeerVerifyDepth(self, depth: int) -> None: ...
    def setPeerVerifyMode(self, mode: PySide6.QtNetwork.QSslSocket.PeerVerifyMode) -> None: ...
    def setPeerVerifyName(self, hostName: str) -> None: ...
    @overload
    def setPrivateKey(self, fileName: str, algorithm: PySide6.QtNetwork.QSsl.KeyAlgorithm = ..., format: PySide6.QtNetwork.QSsl.EncodingFormat = ..., passPhrase: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview] = ...) -> None: ...
    @overload
    def setPrivateKey(self, key: Union[PySide6.QtNetwork.QSslKey, int]) -> None: ...
    def setProtocol(self, protocol: PySide6.QtNetwork.QSsl.SslProtocol) -> None: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def setSocketDescriptor(self, socketDescriptor: int, state: PySide6.QtNetwork.QAbstractSocket.SocketState = ..., openMode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ...) -> bool: ...
    def setSocketOption(self, option: PySide6.QtNetwork.QAbstractSocket.SocketOption, value: Any) -> None: ...
    def setSslConfiguration(self, config: PySide6.QtNetwork.QSslConfiguration) -> None: ...
    def skipData(self, maxSize: int) -> int: ...
    def socketOption(self, option: PySide6.QtNetwork.QAbstractSocket.SocketOption) -> Any: ...
    def sslConfiguration(self) -> PySide6.QtNetwork.QSslConfiguration: ...
    def sslHandshakeErrors(self) -> List[PySide6.QtNetwork.QSslError]: ...
    @staticmethod
    def sslLibraryBuildVersionNumber() -> int: ...
    @staticmethod
    def sslLibraryBuildVersionString() -> str: ...
    @staticmethod
    def sslLibraryVersionNumber() -> int: ...
    @staticmethod
    def sslLibraryVersionString() -> str: ...
    def startClientEncryption(self) -> None: ...
    def startServerEncryption(self) -> None: ...
    @staticmethod
    def supportedFeatures(backendName: str = ...) -> List[PySide6.QtNetwork.QSsl.SupportedFeature]: ...
    @staticmethod
    def supportedProtocols(backendName: str = ...) -> List[PySide6.QtNetwork.QSsl.SslProtocol]: ...
    @staticmethod
    def supportsSsl() -> bool: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def waitForConnected(self, msecs: int = ...) -> bool: ...
    def waitForDisconnected(self, msecs: int = ...) -> bool: ...
    def waitForEncrypted(self, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def writeData(self, data: Union[bytes, bytearray, memoryview], len: int) -> int: ...


class QTcpServer(PySide6.QtCore.QObject):

    acceptError              : ClassVar[Signal] = ... # acceptError(QAbstractSocket::SocketError)
    newConnection            : ClassVar[Signal] = ... # newConnection()
    pendingConnectionAvailable: ClassVar[Signal] = ... # pendingConnectionAvailable()

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def addPendingConnection(self, socket: PySide6.QtNetwork.QTcpSocket) -> None: ...
    def close(self) -> None: ...
    def errorString(self) -> str: ...
    def hasPendingConnections(self) -> bool: ...
    def incomingConnection(self, handle: int) -> None: ...
    def isListening(self) -> bool: ...
    def listen(self, address: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress] = ..., port: int = ...) -> bool: ...
    def listenBacklogSize(self) -> int: ...
    def maxPendingConnections(self) -> int: ...
    def nextPendingConnection(self) -> PySide6.QtNetwork.QTcpSocket: ...
    def pauseAccepting(self) -> None: ...
    def proxy(self) -> PySide6.QtNetwork.QNetworkProxy: ...
    def resumeAccepting(self) -> None: ...
    def serverAddress(self) -> PySide6.QtNetwork.QHostAddress: ...
    def serverError(self) -> PySide6.QtNetwork.QAbstractSocket.SocketError: ...
    def serverPort(self) -> int: ...
    def setListenBacklogSize(self, size: int) -> None: ...
    def setMaxPendingConnections(self, numConnections: int) -> None: ...
    def setProxy(self, networkProxy: Union[PySide6.QtNetwork.QNetworkProxy, PySide6.QtNetwork.QNetworkProxy.ProxyType]) -> None: ...
    def setSocketDescriptor(self, socketDescriptor: int) -> bool: ...
    def socketDescriptor(self) -> int: ...
    def waitForNewConnection(self, msec: int) -> Tuple[bool, bool]: ...


class QTcpSocket(PySide6.QtNetwork.QAbstractSocket):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    @overload
    def bind(self, addr: PySide6.QtNetwork.QHostAddress.SpecialAddress, port: int = ..., mode: PySide6.QtNetwork.QAbstractSocket.BindFlag = ...) -> bool: ...
    @overload
    def bind(self, address: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], port: int = ..., mode: PySide6.QtNetwork.QAbstractSocket.BindFlag = ...) -> bool: ...
    @overload
    def bind(self, port: int = ..., mode: PySide6.QtNetwork.QAbstractSocket.BindFlag = ...) -> bool: ...


class QUdpSocket(PySide6.QtNetwork.QAbstractSocket):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    @overload
    def bind(self, addr: PySide6.QtNetwork.QHostAddress.SpecialAddress, port: int = ..., mode: PySide6.QtNetwork.QAbstractSocket.BindFlag = ...) -> bool: ...
    @overload
    def bind(self, address: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], port: int = ..., mode: PySide6.QtNetwork.QAbstractSocket.BindFlag = ...) -> bool: ...
    @overload
    def bind(self, port: int = ..., mode: PySide6.QtNetwork.QAbstractSocket.BindFlag = ...) -> bool: ...
    def hasPendingDatagrams(self) -> bool: ...
    @overload
    def joinMulticastGroup(self, groupAddress: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress]) -> bool: ...
    @overload
    def joinMulticastGroup(self, groupAddress: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], iface: PySide6.QtNetwork.QNetworkInterface) -> bool: ...
    @overload
    def leaveMulticastGroup(self, groupAddress: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress]) -> bool: ...
    @overload
    def leaveMulticastGroup(self, groupAddress: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], iface: PySide6.QtNetwork.QNetworkInterface) -> bool: ...
    def multicastInterface(self) -> PySide6.QtNetwork.QNetworkInterface: ...
    def pendingDatagramSize(self) -> int: ...
    def readDatagram(self, maxlen: int) -> Tuple[PySide6.QtCore.QByteArray, PySide6.QtNetwork.QHostAddress, int]: ...
    def receiveDatagram(self, maxSize: int = ...) -> PySide6.QtNetwork.QNetworkDatagram: ...
    def setMulticastInterface(self, iface: PySide6.QtNetwork.QNetworkInterface) -> None: ...
    @overload
    def writeDatagram(self, datagram: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], host: Union[PySide6.QtNetwork.QHostAddress, PySide6.QtNetwork.QHostAddress.SpecialAddress], port: int) -> int: ...
    @overload
    def writeDatagram(self, datagram: Union[PySide6.QtNetwork.QNetworkDatagram, PySide6.QtCore.QByteArray]) -> int: ...


# eof
