#!/usr/bin/bash.exe
# Test suite for Python examples.
#
# Copyright (C) 2004  Alan W. Irwin
# Copyright (C) 2004  Rafael Laboissiere
#
# This file is part of PLplot.
#
# PLplot is free software; you can redistribute it and/or modify
# it under the terms of the GNU Library General Public License as published
# by the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# PLplot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public License
# along with PLplot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

# This is called from plplot-test.sh with $pythondir, $device, $dsuffix,
# $options, and possibly $verbose_test defined.

# $pythondir must be the build tree and not the source tree (if separate from
# build tree) since must access plplot_python_start.py in build tree and
# paths in that file are relative to build tree.
# Skip 21 if using Numeric - it doesn't work
# For 24 you need special fonts installed to get good result.
lang="p"
for index in 00 01 02 03 04 05 06 07 08 09 10 11 12 13 15 16 18 19 \
    20 21 22 23 24 25 26 27 28 30 31 33 ${critical_examples} ; do
    if [ "$verbose_test" ] ; then
	echo "x${index}"
    fi
    if [ "$index" = "14" ] ; then
	echo "${OUTPUT_DIR}"/x${index}a${lang}%n.$dsuffix | \
	/clangarm64/bin/python3.exe "$pythondir"/x$index -dev $device -o "${OUTPUT_DIR}"/x${index}${lang}%n.$dsuffix \
	    $options 2> python_${device}_test.error >| "${OUTPUT_DIR}"/x${index}${lang}_${dsuffix}.txt
	status_code=$?
    else
	/clangarm64/bin/python3.exe "$pythondir"/x$index -dev $device -o "${OUTPUT_DIR}"/x${index}${lang}%n.$dsuffix $options 2> python_${device}_test.error >| "${OUTPUT_DIR}"/x${index}${lang}_${dsuffix}.txt
	status_code=$?
    fi
    cat python_${device}_test.error
    if [ "$status_code" -ne 0 ] ; then
	exit $status_code
    fi
  # Look for any PLPLOT ERROR messages from plwarn that do not result in an
  # exit code.
    is_error=`grep -l 'PLPLOT ERROR' python_${device}_test.error`
    if [ -n "$is_error" ] ; then
	exit 1
    fi
done
