%feature("docstring") OT::PlatformInfo
"Informations about platform.

No constructor, only static methods are available."

// ---------------------------------------------------------------------

%feature("docstring") OT::PlatformInfo::GetDate
"Accessor to the build date.

Returns
-------
date : str
    Build date."

// ---------------------------------------------------------------------

%feature("docstring") OT::PlatformInfo::GetInstallationDirectory
"Accessor to the install prefix.

Returns
-------
prefix : str
    Installation prefix."

// ---------------------------------------------------------------------

%feature("docstring") OT::PlatformInfo::GetVersion
"Accessor to the version string.

Returns
-------
version : str
    Version string."

// ---------------------------------------------------------------------

%feature("docstring") OT::PlatformInfo::GetRevision
"Accessor to the revision string.

Returns
-------
revision : str
    Git revision."

// ---------------------------------------------------------------------

%feature("docstring") OT::PlatformInfo::SetNumericalPrecision
"Accessor to the output numerical precision.

Parameters
----------
precision : int
    String output numerical precision."

// ---------------------------------------------------------------------

%feature("docstring") OT::PlatformInfo::GetNumericalPrecision
"Accessor to the output numerical precision.

Returns
-------
precision : int
    String output numerical precision."

// ---------------------------------------------------------------------

%feature("docstring") OT::PlatformInfo::GetFeatures
"Accessor to the features list.

Returns
-------
features : :class:`~openturns.Description`
    Features list.

Examples
--------
>>> import openturns as ot
>>> print(ot.PlatformInfo.GetFeatures())
[bison,bonmin,...
"

// ---------------------------------------------------------------------

%feature("docstring") OT::PlatformInfo::HasFeature
"Test a feature's availability.

Parameters
----------
feature : str
    The desired feature, often associated to a software dependency,
    Call :meth:`GetFeatures` for the possible feature values.

Returns
-------
has_feature : bool
    Whether the designated feature is available.

Examples
--------
>>> import openturns as ot
>>> have_xml_support = ot.PlatformInfo.HasFeature('libxml2')
"
