%feature("docstring") OT::LinearModelResult
"Result of a LinearModelAlgorithm.

Parameters
----------
inputSample : 2-d sequence of float
    The input sample of a model.
basis : :class:`~openturns.Basis`
    Functional basis to estimate the trend.
design : :class:`~openturns.Matrix`
    The design matrix :math:`X`.
outputSample : 2-d sequence of float
   The output sample of a model.
metaModel : :class:`~openturns.Function`
    The meta model.
trendCoefficients : sequence of float
    The trend coeffients associated to the linearmodel. 
formula : str
     The formula description. 
coefficientsNames : sequence of str
     The coefficients names of the basis.  
sampleResiduals : 2-d sequence of float
    The residual errors.
standardizedSampleResiduals : 2-d sequence of float
    The normalized residual errors.
diagonalGramInverse : sequence of float
    The diagonal of the Gram inverse matrix.
leverages : sequence of float
    The leverage score. 
cookDistances : sequence of float
    The cook's distances.
sigma2 : float
    The unbiased noise variance.


See Also
--------
LinearModelAlgorithm
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearModelResult::getBasis
"Accessor to the basis.

Returns
-------
basis : :class:`~openturns.Basis`
    The basis which had been passed to the constructor."

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearModelResult::getFittedSample
"Accessor to the fitted sample.

Returns
-------
outputSample : :class:`~openturns.Sample`
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearModelResult::getCoefficients
"Accessor to the coefficients of the linear model of the trend.

Returns
-------
beta : :class:`~openturns.Point`
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearModelResult::getCoefficientsStandardErrors
"Accessor to the coefficients of standard error.

Returns
-------
standardErrors : :class:`~openturns.Point`
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearModelResult::getFormula
"Accessor to the formula.

Returns
-------
condensedFormula : str
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearModelResult::getCoefficientsNames
"Accessor to the coefficients names.

Returns
-------
coefficientsNames : :class:`~openturns.Description`
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearModelResult::getSampleResiduals
"Accessor to the residuals.

Returns
-------
sampleResiduals : :class:`~openturns.Sample`
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearModelResult::getDegreesOfFreedom
"Accessor to the degrees of freedom.

Returns
-------
dof : int
    Sample size minus basis size, a null value is allowed.
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearModelResult::getNoiseDistribution
"Accessor to the noise distribution, ie the underlying distribution of the residual.

Returns
-------
noiseDistribution : :class:`~openturns.Distribution`
    Not defined when degrees of freedom is null.
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearModelResult::getStandardizedResiduals
"Accessor to the standardized residuals.

Returns
-------
standardizedResiduals : :class:`~openturns.Sample`
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearModelResult::getLeverages
"Accessor to the leverages.

Returns
-------
leverages : :class:`~openturns.Point`
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearModelResult::getDiagonalGramInverse
"Accessor to the diagonal gram inverse matrix.

Returns
-------
diagonalGramInverse : :class:`~openturns.Point`
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearModelResult::getCookDistances
"Accessor to the cook's distances.

Returns
-------
cookDistances : :class:`~openturns.Point`
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearModelResult::getRSquared
"Accessor to the R-squared test.

Returns
-------
rSquared : float
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearModelResult::getAdjustedRSquared
"Accessor to the Adjusted R-squared test.

Returns
-------
adjustedRSquared : float
    Not defined when degrees of freedom is null.
"

// ---------------------------------------------------------------------

%feature("docstring") OT::LinearModelResult::hasIntercept
"Returns if intercept is provided in the basis or not.

Returns
-------
intercept : Bool
"
