// Created on: 1997-09-03
// Created by: Christian CAILLET
// Copyright (c) 1997-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _Interface_IntVal_HeaderFile
#define _Interface_IntVal_HeaderFile

#include <Standard.hxx>
#include <Standard_Type.hxx>

#include <Standard_Integer.hxx>
#include <Standard_Transient.hxx>


class Interface_IntVal;
DEFINE_STANDARD_HANDLE(Interface_IntVal, Standard_Transient)

//! An Integer through a Handle (i.e. managed as TShared)
class Standard_EXPORT Interface_IntVal : public Standard_Transient
{

public:

  
  Standard_EXPORT Interface_IntVal();
  
  Standard_EXPORT Standard_Integer Value() const;
  
  Standard_EXPORT Standard_Integer& CValue();




  DEFINE_STANDARD_RTTIEXT(Interface_IntVal,Standard_Transient)

protected:




private:


  Standard_Integer theval;


};







#endif // _Interface_IntVal_HeaderFile
