﻿!mod$ v1 sum:c3d4cc4f5e62119e
module gridxc_fft_gpfa
use gridxc_sys,only:die
use gridxc_gpfa_core_sp,only:gpfa
use gridxc_gpfa_core_dp,only:gpfa
private::die
integer(4),parameter,private::dp=8_4
intrinsic::selected_real_kind
private::selected_real_kind
integer(4),parameter,private::sp=4_4
real(8),allocatable,private,save::trigs(:)
integer(4),private,save::nold
character(20_4,1),private::msg
private::fft_gpfa_ez_sp
private::fft_gpfa_ez_dp
private::fft_gpfa_sp
private::fft_gpfa_dp
private::setgpfa_alloc
interface gpfa
end interface
interface fft_gpfa_ez
procedure::fft_gpfa_ez_dp
procedure::fft_gpfa_ez_sp
end interface
interface fft_gpfa
procedure::fft_gpfa_dp
procedure::fft_gpfa_sp
end interface
contains
subroutine nfft(n)
integer(4),intent(inout)::n
end
subroutine fft_gpfa_ez_sp(data,n,isign)
integer(4),intent(in)::n
real(4),intent(inout)::data(1_8:int(2_4*n,kind=8))
integer(4),intent(in)::isign
end
subroutine fft_gpfa_ez_dp(data,n,isign)
integer(4),intent(in)::n
real(8),intent(inout)::data(1_8:int(2_4*n,kind=8))
integer(4),intent(in)::isign
end
subroutine fft_gpfa_sp(realdata,imagdata,dataspan,vectorspan,n,numvectors,isign)
real(4),intent(inout)::realdata(:)
real(4),intent(inout)::imagdata(:)
integer(4),intent(in)::dataspan
integer(4),intent(in)::vectorspan
integer(4),intent(in)::n
integer(4),intent(in)::numvectors
integer(4),intent(in)::isign
end
subroutine fft_gpfa_dp(realdata,imagdata,dataspan,vectorspan,n,numvectors,isign)
real(8),intent(inout)::realdata(:)
real(8),intent(inout)::imagdata(:)
integer(4),intent(in)::dataspan
integer(4),intent(in)::vectorspan
integer(4),intent(in)::n
integer(4),intent(in)::numvectors
integer(4),intent(in)::isign
end
subroutine setgpfa_alloc(trigs,n)
real(8),allocatable,intent(inout)::trigs(:)
integer(4),intent(in)::n
end
subroutine setgpfa_check(trigs,maxtrigs,ntrigs,n)
integer(4),intent(in)::maxtrigs
real(8)::trigs(1_8:int(maxtrigs,kind=8))
integer(4),intent(out)::ntrigs
integer(4),intent(in)::n
end
subroutine setgpfa(trigs,n)
real(8)::trigs(1_8:*)
integer(4)::n
end
end
