
#ifndef KIOGUI_EXPORT_H
#define KIOGUI_EXPORT_H

#ifdef KIOGUI_STATIC_DEFINE
#  define KIOGUI_EXPORT
#  define KIOGUI_NO_EXPORT
#else
#  ifndef KIOGUI_EXPORT
#    ifdef KF5KIOGui_EXPORTS
        /* We are building this library */
#      define KIOGUI_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define KIOGUI_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef KIOGUI_NO_EXPORT
#    define KIOGUI_NO_EXPORT 
#  endif
#endif

#ifndef KIOGUI_DECL_DEPRECATED
#  define KIOGUI_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef KIOGUI_DECL_DEPRECATED_EXPORT
#  define KIOGUI_DECL_DEPRECATED_EXPORT KIOGUI_EXPORT KIOGUI_DECL_DEPRECATED
#endif

#ifndef KIOGUI_DECL_DEPRECATED_NO_EXPORT
#  define KIOGUI_DECL_DEPRECATED_NO_EXPORT KIOGUI_NO_EXPORT KIOGUI_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KIOGUI_NO_DEPRECATED
#    define KIOGUI_NO_DEPRECATED
#  endif
#endif

#define KIOGUI_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KIOGUI_NO_DEPRECATED) && !defined(KIOGUI_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KIOGUI_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KIOGUI_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KIOGUI_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KIOGUI_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KIOGUI_NO_DEPRECATED_WARNINGS) && !defined(KIOGUI_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KIOGUI_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KIOGUI_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KIOGUI_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KIOGUI_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KIOGUI_NO_DEPRECATED)
#  undef KIOGUI_DEPRECATED
#  define KIOGUI_DEPRECATED_EXPORT KIOGUI_EXPORT
#  define KIOGUI_DEPRECATED_NO_EXPORT KIOGUI_NO_EXPORT
#elif defined(KIOGUI_NO_DEPRECATED_WARNINGS)
#  define KIOGUI_DEPRECATED
#  define KIOGUI_DEPRECATED_EXPORT KIOGUI_EXPORT
#  define KIOGUI_DEPRECATED_NO_EXPORT KIOGUI_NO_EXPORT
#else
#  define KIOGUI_DEPRECATED KIOGUI_DECL_DEPRECATED
#  define KIOGUI_DEPRECATED_EXPORT KIOGUI_DECL_DEPRECATED_EXPORT
#  define KIOGUI_DEPRECATED_NO_EXPORT KIOGUI_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KIOGUI_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KIOGUI_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KIOGUI_NO_DEPRECATED
#  define KIOGUI_DISABLE_DEPRECATED_BEFORE_AND_AT 0x57400
#endif
#ifdef KIOGUI_NO_DEPRECATED_WARNINGS
#  define KIOGUI_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KIOGUI_DEPRECATED_WARNINGS_SINCE
#  ifdef KIOGUI_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KIOGUI_DEPRECATED_WARNINGS_SINCE KIOGUI_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KIOGUI_DEPRECATED_WARNINGS_SINCE 0x57400
#  endif
#endif

#ifndef KIOGUI_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KIOGUI_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KIOGUI_DEPRECATED
#  define KIOGUI_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KIOGUI_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KIOGUI_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KIOGUI_DEPRECATED_WARNINGS_SINCE >= 0x56500
#  define KIOGUI_DEPRECATED_VERSION_5_101(text) KIOGUI_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOGUI_DEPRECATED_VERSION_5_101(text)
#endif

#if KIOGUI_DEPRECATED_WARNINGS_SINCE >= 0x56700
#  define KIOGUI_DEPRECATED_VERSION_5_103(text) KIOGUI_DECL_DEPRECATED_TEXT(text)
#else
#  define KIOGUI_DEPRECATED_VERSION_5_103(text)
#endif
#define KIOGUI_DEPRECATED_VERSION_5(minor, text)      KIOGUI_DEPRECATED_VERSION_5_##minor(text)
#define KIOGUI_DEPRECATED_VERSION(major, minor, text) KIOGUI_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KIOGUI_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KIOGUI_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KIOGUI_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KIOGUI_DEPRECATED_VERSION(major, minor, text)
#  define KIOGUI_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KIOGUI_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KIOGUI_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KIOGUI_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KIOGUI_EXPORT_H */
