/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * A type-safe enum for tool-related errors.
 */
export declare enum ToolErrorType {
    INVALID_TOOL_PARAMS = "invalid_tool_params",
    UNKNOWN = "unknown",
    UNHANDLED_EXCEPTION = "unhandled_exception",
    TOOL_NOT_REGISTERED = "tool_not_registered",
    EXECUTION_FAILED = "execution_failed",
    FILE_NOT_FOUND = "file_not_found",
    FILE_WRITE_FAILURE = "file_write_failure",
    READ_CONTENT_FAILURE = "read_content_failure",
    ATTEMPT_TO_CREATE_EXISTING_FILE = "attempt_to_create_existing_file",
    FILE_TOO_LARGE = "file_too_large",
    PERMISSION_DENIED = "permission_denied",
    NO_SPACE_LEFT = "no_space_left",
    TARGET_IS_DIRECTORY = "target_is_directory",
    EDIT_PREPARATION_FAILURE = "edit_preparation_failure",
    EDIT_NO_OCCURRENCE_FOUND = "edit_no_occurrence_found",
    EDIT_EXPECTED_OCCURRENCE_MISMATCH = "edit_expected_occurrence_mismatch",
    EDIT_NO_CHANGE = "edit_no_change"
}
