﻿!mod$ v1 sum:8c7ee6ec831cc172
module w90_utility
use w90_constants,only:dp
private::dp
private::qe_erf
private::qe_erfc
private::gauss_freq
contains
subroutine utility_zgemm(c,a,transa,b,transb,n)
integer(4),intent(in)::n
complex(8),intent(out)::c(1_8:int(n,kind=8),1_8:int(n,kind=8))
complex(8),intent(in)::a(1_8:int(n,kind=8),1_8:int(n,kind=8))
character(1_4,1),intent(in)::transa
complex(8),intent(in)::b(1_8:int(n,kind=8),1_8:int(n,kind=8))
character(1_4,1),intent(in)::transb
end
function utility_det3(a)
real(8),intent(in)::a(1_8:3_8,1_8:3_8)
real(8)::utility_det3
end
subroutine utility_zgemm_new(a,b,c,transa_opt,transb_opt)
complex(8),intent(in)::a(:,:)
complex(8),intent(in)::b(:,:)
complex(8),intent(out)::c(:,:)
character(1_4,1),intent(in),optional::transa_opt
character(1_4,1),intent(in),optional::transb_opt
end
function utility_zdotu(a,b)
complex(8),intent(in)::a(:)
complex(8),intent(in)::b(:)
complex(8)::utility_zdotu
end
subroutine utility_zgemmm(a,transa,b,transb,c,transc,prod1,eigval,prod2)
complex(8),intent(in)::a(:,:)
character(1_4,1),intent(in)::transa
complex(8),intent(in)::b(:,:)
character(1_4,1),intent(in)::transb
complex(8),intent(in)::c(:,:)
character(1_4,1),intent(in)::transc
complex(8),intent(out),optional::prod1(:,:)
real(8),intent(in),optional::eigval(:)
complex(8),intent(out),optional::prod2(:,:)
end
subroutine utility_inv3(a,b,det)
real(8),intent(in)::a(1_8:3_8,1_8:3_8)
real(8),intent(out)::b(1_8:3_8,1_8:3_8)
real(8),intent(out)::det
end
subroutine utility_inv2(a,b,det)
real(8),intent(in)::a(1_8:2_8,1_8:2_8)
real(8),intent(out)::b(1_8:2_8,1_8:2_8)
real(8),intent(out)::det
end
subroutine utility_recip_lattice(real_lat,recip_lat,volume)
real(8),intent(in)::real_lat(1_8:3_8,1_8:3_8)
real(8),intent(out)::recip_lat(1_8:3_8,1_8:3_8)
real(8),intent(out)::volume
end
subroutine utility_compar(a,b,ifpos,ifneg)
real(8),intent(in)::a(1_8:3_8)
real(8),intent(in)::b(1_8:3_8)
integer(4),intent(out)::ifpos
integer(4),intent(out)::ifneg
end
subroutine utility_metric(real_lat,recip_lat,real_metric,recip_metric)
real(8),intent(in)::real_lat(1_8:3_8,1_8:3_8)
real(8),intent(in)::recip_lat(1_8:3_8,1_8:3_8)
real(8),intent(out)::real_metric(1_8:3_8,1_8:3_8)
real(8),intent(out)::recip_metric(1_8:3_8,1_8:3_8)
end
subroutine utility_frac_to_cart(frac,cart,real_lat)
real(8),intent(in)::frac(1_8:3_8)
real(8),intent(out)::cart(1_8:3_8)
real(8),intent(in)::real_lat(1_8:3_8,1_8:3_8)
end
subroutine utility_cart_to_frac(cart,frac,recip_lat)
real(8),intent(in)::cart(1_8:3_8)
real(8),intent(out)::frac(1_8:3_8)
real(8),intent(in)::recip_lat(1_8:3_8,1_8:3_8)
end
function utility_strip(string)
character(*,1),intent(in)::string
character(255_4,1)::utility_strip
end
function utility_lowercase(string)
character(*,1),intent(in)::string
character(255_4,1)::utility_lowercase
end
subroutine utility_string_to_coord(string_tmp,outvec)
character(255_4,1),intent(in)::string_tmp
real(8),intent(out)::outvec(1_8:3_8)
end
subroutine utility_translate_home(vec,real_lat,recip_lat)
real(8),intent(inout)::vec(1_8:3_8)
real(8),intent(in)::real_lat(1_8:3_8,1_8:3_8)
real(8),intent(in)::recip_lat(1_8:3_8,1_8:3_8)
end
subroutine utility_diagonalize(mat,dim,eig,rot)
integer(4),intent(in)::dim
complex(8),intent(in)::mat(1_8:int(dim,kind=8),1_8:int(dim,kind=8))
real(8),intent(out)::eig(1_8:int(dim,kind=8))
complex(8),intent(out)::rot(1_8:int(dim,kind=8),1_8:int(dim,kind=8))
end
function utility_rotate(mat,rot,dim)
integer(4)::dim
complex(8)::mat(1_8:int(dim,kind=8),1_8:int(dim,kind=8))
complex(8)::rot(1_8:int(dim,kind=8),1_8:int(dim,kind=8))
complex(8)::utility_rotate(1_8:int(dim,kind=8),1_8:int(dim,kind=8))
end
subroutine utility_rotate_new(mat,rot,n,reverse)
integer(4),intent(in)::n
complex(8),intent(inout)::mat(1_8:int(n,kind=8),1_8:int(n,kind=8))
complex(8),intent(in)::rot(1_8:int(n,kind=8),1_8:int(n,kind=8))
logical(4),intent(in),optional::reverse
end
function utility_matmul_diag(mat1,mat2,dim)
integer(4)::dim
complex(8)::mat1(1_8:int(dim,kind=8),1_8:int(dim,kind=8))
complex(8)::mat2(1_8:int(dim,kind=8),1_8:int(dim,kind=8))
complex(8)::utility_matmul_diag(1_8:int(dim,kind=8))
end
function utility_rotate_diag(mat,rot,dim)
integer(4)::dim
complex(8)::mat(1_8:int(dim,kind=8),1_8:int(dim,kind=8))
complex(8)::rot(1_8:int(dim,kind=8),1_8:int(dim,kind=8))
complex(8)::utility_rotate_diag(1_8:int(dim,kind=8))
end
function utility_commutator_diag(mat1,mat2,dim)
integer(4)::dim
complex(8)::mat1(1_8:int(dim,kind=8),1_8:int(dim,kind=8))
complex(8)::mat2(1_8:int(dim,kind=8),1_8:int(dim,kind=8))
complex(8)::utility_commutator_diag(1_8:int(dim,kind=8))
end
function utility_re_tr_prod(a,b)
complex(8),intent(in)::a(:,:)
complex(8),intent(in)::b(:,:)
real(8)::utility_re_tr_prod
end
function utility_im_tr_prod(a,b)
complex(8),intent(in)::a(:,:)
complex(8),intent(in)::b(:,:)
real(8)::utility_im_tr_prod
end
function utility_re_tr(mat)
complex(8)::mat(:,:)
real(8)::utility_re_tr
end
function utility_im_tr(mat)
complex(8)::mat(:,:)
real(8)::utility_im_tr
end
function utility_wgauss(x,n)
real(8)::x
integer(4)::n
real(8)::utility_wgauss
end
function utility_w0gauss(x,n)
real(8)::x
integer(4)::n
real(8)::utility_w0gauss
end
function utility_w0gauss_vec(x,n) result(res)
real(8),intent(in)::x(:)
integer(4)::n
real(8),allocatable::res(:)
end
function qe_erf(x)
real(8),intent(in)::x
real(8)::qe_erf
end
function qe_erfc(x)
real(8),intent(in)::x
real(8)::qe_erfc
end
function gauss_freq(x)
real(8),intent(in)::x
real(8)::gauss_freq
end
end
