# @HEADER
# ************************************************************************
#
#            TriBITS: Tribal Build, Integrate, and Test System
#                    Copyright 2013 Sandia Corporation
#
# Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
# the U.S. Government retains certain rights in this software.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. Neither the name of the Corporation nor the names of the
# contributors may be used to endorse or promote products derived from
# this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# ************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/TrilinosSS clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "TrilinosSS requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Trilinos/TrilinosSS build
## ---------------------------------------------------------------------------

set(TrilinosSS_CXX_COMPILER "D:/a/msys64/clang64/bin/clang++.exe")

set(TrilinosSS_C_COMPILER "D:/a/msys64/clang64/bin/clang.exe")

set(TrilinosSS_Fortran_COMPILER "D:/a/msys64/clang64/bin/flang.exe")
# Deprecated!
set(TrilinosSS_FORTRAN_COMPILER "D:/a/msys64/clang64/bin/flang.exe") 


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/TrilinosSS build
## ---------------------------------------------------------------------------

## Give the build type
set(TrilinosSS_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(TrilinosSS_CXX_FLAGS [[ ]])

set(TrilinosSS_C_FLAGS [[-march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong ]])

set(TrilinosSS_Fortran_FLAGS [[ ]])
# Deprecated
set(TrilinosSS_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(TrilinosSS_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(TrilinosSS_SHARED_LIB_RPATH_COMMAND "/clang64/lib")
set(TrilinosSS_BUILD_SHARED_LIBS "ON")

set(TrilinosSS_LINKER D:/a/msys64/clang64/bin/ld.lld.exe)
set(TrilinosSS_AR D:/a/msys64/clang64/bin/llvm-ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(TrilinosSS_INSTALL_DIR "/clang64")

## List of package libraries
set(TrilinosSS_LIBRARIES TrilinosSS::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(TrilinosSS_MPI_LIBRARIES "")
set(TrilinosSS_MPI_LIBRARY_DIRS "")
set(TrilinosSS_MPI_INCLUDE_DIRS "")
set(TrilinosSS_MPI_EXEC "")
set(TrilinosSS_MPI_EXEC_MAX_NUMPROCS "")
set(TrilinosSS_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies

# Exported cache variables
set(TrilinosSS_ENABLE_OpenMP "OFF")
set(TRILINOSSS_HAVE_OMP "OFF")

# Include configuration of dependent packages

# Import TrilinosSS targets
include("${CMAKE_CURRENT_LIST_DIR}/TrilinosSSTargets.cmake")

# Standard TriBITS-compliant external package variables
set(TrilinosSS_IS_TRIBITS_COMPLIANT TRUE)
set(TrilinosSS_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(TrilinosSS_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(TrilinosSS_EXPORTED_PACKAGE_LIBS_NAMES "trilinosss")

foreach(libname IN LISTS TrilinosSS_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE TrilinosSS::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Trilinos', then use the"
      " new namespaced target 'TrilinosSS::${libname}', or better yet,"
      " 'TrilinosSS::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'TrilinosSS'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Trilinos', instead link against the"
      " libraries specified by the variable 'TrilinosSS_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
