Object.assign(window.search, {"doc_urls":["introduction.html#introduction","requirements.html#requirements","requirements.html#clang","requirements.html#installing-clang","library-usage.html#library-usage-with-buildrs","library-usage.html#library-api-documentation","library-usage.html#tutorial","tutorial-0.html#tutorial","tutorial-1.html#add-bindgen-as-a-build-dependency","tutorial-2.html#create-a-wrapperh-header","tutorial-3.html#create-a-buildrs-file","tutorial-4.html#include-the-generated-bindings-in-srclibrs","tutorial-5.html#write-a-sanity-test","tutorial-6.html#publish-your-crate","non-system-libraries.html","command-line-usage.html#command-line-usage","customizing-generated-bindings.html#customizing-the-generated-bindings","allowlisting.html#allowlisting","allowlisting.html#library","allowlisting.html#command-line","allowlisting.html#annotations","blocklisting.html#blocklisting","blocklisting.html#library","blocklisting.html#command-line","blocklisting.html#annotations","opaque.html#treating-a-type-as-an-opaque-blob-of-bytes","opaque.html#library","opaque.html#command-line","opaque.html#annotation","replacing-types.html#replacing-one-type-with-another","nocopy.html#preventing-the-derivation-of-copy-and-clone","nocopy.html#library","nocopy.html#command-line","nocopy.html#annotations","nodebug.html#preventing-the-derivation-of-debug","nodebug.html#library","nodebug.html#command-line","nodebug.html#annotations","nodefault.html#preventing-the-derivation-of-default","nodefault.html#library","nodefault.html#command-line","nodefault.html#annotations","nodefault.html#customize-implements","must-use-types.html#annotating-types-with-must-use","must-use-types.html#library","must-use-types.html#command-line","must-use-types.html#annotations","visibility.html#making-fields-private","visibility.html#annotation","code-formatting.html#code-formatting","code-formatting.html#passing-a-rustfmttoml-configuration-file","code-formatting.html#using-a-nightly-release-of-rustfmt","code-formatting.html#when-using-bindgen-as-a-cli-application","code-formatting.html#when-using-bindgen-as-a-library","code-formatting.html#using-prettyplease","code-formatting.html#how-can-i-normalize-doc-attributes","code-formatting.html#use-rustfmt","code-formatting.html#use-prettyplease","cpp.html#generating-bindings-to-c","cpp.html#supported-features","cpp.html#unsupported-features","cpp.html#constructor-semantics","objc.html#generating-bindings-to-objective-c","objc.html#supported-features","objc.html#useful-notes","objc.html#not-yet-supported","objc.html#example-crates","using-unions.html#using-the-union-types-generated-by-bindgen","using-unions.html#relevant-bindgen-options","using-unions.html#library","using-unions.html#command-line","using-unions.html#which-union-type-will-bindgen-generate","using-unions.html#using-the-union-builtin","using-unions.html#using-the-bindgenunion-type","using-bitfields.html#using-the-bitfield-types-generated-by-bindgen","using-bitfields.html#bitfield-strategy-overview","using-bitfields.html#bitfield-examples","using-fam.html#using-c-structures-with-flexible-array-members","using-fam.html#__incompletearrayfield","using-fam.html#using-dynamically-sized-types","faq.html#frequently-asked-questions","faq.html#why-isnt-bindgen-generating-methods-for-this-allowlisted-class","faq.html#why-isnt-bindgen-generating-bindings-to-inline-functions","faq.html#does-bindgen-support-the-c-standard-template-library-stl","faq.html#how-to-deal-with-bindgen-generated-padding-fields","faq.html#how-to-generate-bindings-for-a-custom-target"],"index":{"documentStore":{"docInfo":{"0":{"body":66,"breadcrumbs":2,"title":1},"1":{"body":5,"breadcrumbs":2,"title":1},"10":{"body":150,"breadcrumbs":10,"title":3},"11":{"body":160,"breadcrumbs":12,"title":4},"12":{"body":635,"breadcrumbs":10,"title":3},"13":{"body":43,"breadcrumbs":8,"title":2},"14":{"body":241,"breadcrumbs":7,"title":3},"15":{"body":63,"breadcrumbs":6,"title":3},"16":{"body":62,"breadcrumbs":6,"title":3},"17":{"body":60,"breadcrumbs":5,"title":1},"18":{"body":5,"breadcrumbs":5,"title":1},"19":{"body":15,"breadcrumbs":6,"title":2},"2":{"body":16,"breadcrumbs":2,"title":1},"20":{"body":1,"breadcrumbs":5,"title":1},"21":{"body":60,"breadcrumbs":5,"title":1},"22":{"body":5,"breadcrumbs":5,"title":1},"23":{"body":15,"breadcrumbs":6,"title":2},"24":{"body":5,"breadcrumbs":5,"title":1},"25":{"body":32,"breadcrumbs":13,"title":5},"26":{"body":1,"breadcrumbs":9,"title":1},"27":{"body":3,"breadcrumbs":10,"title":2},"28":{"body":5,"breadcrumbs":9,"title":1},"29":{"body":66,"breadcrumbs":11,"title":4},"3":{"body":125,"breadcrumbs":3,"title":2},"30":{"body":35,"breadcrumbs":11,"title":4},"31":{"body":1,"breadcrumbs":8,"title":1},"32":{"body":2,"breadcrumbs":9,"title":2},"33":{"body":19,"breadcrumbs":8,"title":1},"34":{"body":32,"breadcrumbs":9,"title":3},"35":{"body":1,"breadcrumbs":7,"title":1},"36":{"body":2,"breadcrumbs":8,"title":2},"37":{"body":51,"breadcrumbs":7,"title":1},"38":{"body":25,"breadcrumbs":9,"title":3},"39":{"body":1,"breadcrumbs":7,"title":1},"4":{"body":65,"breadcrumbs":6,"title":3},"40":{"body":2,"breadcrumbs":8,"title":2},"41":{"body":18,"breadcrumbs":7,"title":1},"42":{"body":17,"breadcrumbs":8,"title":2},"43":{"body":28,"breadcrumbs":9,"title":3},"44":{"body":1,"breadcrumbs":7,"title":1},"45":{"body":3,"breadcrumbs":8,"title":2},"46":{"body":5,"breadcrumbs":7,"title":1},"47":{"body":23,"breadcrumbs":8,"title":3},"48":{"body":52,"breadcrumbs":6,"title":1},"49":{"body":14,"breadcrumbs":7,"title":2},"5":{"body":5,"breadcrumbs":6,"title":3},"50":{"body":24,"breadcrumbs":9,"title":4},"51":{"body":12,"breadcrumbs":9,"title":4},"52":{"body":10,"breadcrumbs":9,"title":4},"53":{"body":60,"breadcrumbs":8,"title":3},"54":{"body":24,"breadcrumbs":7,"title":2},"55":{"body":15,"breadcrumbs":8,"title":3},"56":{"body":28,"breadcrumbs":7,"title":2},"57":{"body":12,"breadcrumbs":7,"title":2},"58":{"body":95,"breadcrumbs":6,"title":3},"59":{"body":23,"breadcrumbs":5,"title":2},"6":{"body":12,"breadcrumbs":4,"title":1},"60":{"body":177,"breadcrumbs":5,"title":2},"61":{"body":151,"breadcrumbs":5,"title":2},"62":{"body":156,"breadcrumbs":8,"title":4},"63":{"body":28,"breadcrumbs":6,"title":2},"64":{"body":98,"breadcrumbs":6,"title":2},"65":{"body":11,"breadcrumbs":5,"title":1},"66":{"body":2,"breadcrumbs":6,"title":2},"67":{"body":89,"breadcrumbs":7,"title":5},"68":{"body":0,"breadcrumbs":5,"title":3},"69":{"body":2,"breadcrumbs":3,"title":1},"7":{"body":26,"breadcrumbs":5,"title":1},"70":{"body":4,"breadcrumbs":4,"title":2},"71":{"body":47,"breadcrumbs":6,"title":4},"72":{"body":62,"breadcrumbs":5,"title":3},"73":{"body":114,"breadcrumbs":5,"title":3},"74":{"body":0,"breadcrumbs":7,"title":5},"75":{"body":76,"breadcrumbs":5,"title":3},"76":{"body":140,"breadcrumbs":4,"title":2},"77":{"body":59,"breadcrumbs":10,"title":6},"78":{"body":105,"breadcrumbs":5,"title":1},"79":{"body":329,"breadcrumbs":8,"title":4},"8":{"body":54,"breadcrumbs":12,"title":4},"80":{"body":28,"breadcrumbs":4,"title":3},"81":{"body":45,"breadcrumbs":7,"title":6},"82":{"body":98,"breadcrumbs":7,"title":6},"83":{"body":55,"breadcrumbs":8,"title":7},"84":{"body":64,"breadcrumbs":6,"title":5},"85":{"body":37,"breadcrumbs":5,"title":4},"9":{"body":51,"breadcrumbs":10,"title":3}},"docs":{"0":{"body":"bindgen automatically generates Rust FFI bindings to C and C++ libraries. For example, given the C header cool.h: typedef struct CoolStruct { int x; int y;\n} CoolStruct; void cool_function(int i, char c, CoolStruct* cs); bindgen produces Rust FFI code allowing you to call into the cool library's functions and use its types: /* automatically generated by rust-bindgen 0.99.9 */ #[repr(C)]\npub struct CoolStruct { pub x: ::std::os::raw::c_int, pub y: ::std::os::raw::c_int,\n} extern \"C\" { pub fn cool_function(i: ::std::os::raw::c_int, c: ::std::os::raw::c_char, cs: *mut CoolStruct);\n}","breadcrumbs":"Introduction » Introduction","id":"0","title":"Introduction"},"1":{"body":"This page lists the requirements for running bindgen and how to get them.","breadcrumbs":"Requirements » Requirements","id":"1","title":"Requirements"},"10":{"body":"We create a build.rs file in our crate's root. Cargo will pick up on the existence of this file, then compile and execute it before the rest of the crate is built. This can be used to generate code at compile time. And of course in our case, we will be generating Rust FFI bindings to bzip2 at compile time. The resulting bindings will be written to $OUT_DIR/bindings.rs where $OUT_DIR is chosen by cargo and is something like ./target/debug/build/bindgen-tutorial-bzip2-sys-afc7747d7eafd720/out/. Note that the associated shared object to bz2 is libbz2.so. In general, a lib<name>.so should be referenced in the build file by <name>. use std::env;\nuse std::path::PathBuf; fn main() { // Tell cargo to look for shared libraries in the specified directory println!(\"cargo:rustc-link-search=/path/to/lib\"); // Tell cargo to tell rustc to link the system bzip2 // shared library. println!(\"cargo:rustc-link-lib=bz2\"); // The bindgen::Builder is the main entry point // to bindgen, and lets you build up options for // the resulting bindings. let bindings = bindgen::Builder::default() // The input header we would like to generate // bindings for. .header(\"wrapper.h\") // Tell cargo to invalidate the built crate whenever any of the // included header files changed. .parse_callbacks(Box::new(bindgen::CargoCallbacks::new())) // Finish the builder and generate the bindings. .generate() // Unwrap the Result and panic on failure. .expect(\"Unable to generate bindings\"); // Write the bindings to the $OUT_DIR/bindings.rs file. let out_path = PathBuf::from(env::var(\"OUT_DIR\").unwrap()); bindings .write_to_file(out_path.join(\"bindings.rs\")) .expect(\"Couldn't write bindings!\");\n} Now, when we run cargo build, our bindings to bzip2 are generated on the fly! There's more info about build.rs files in the Cargo documentation.","breadcrumbs":"Library Usage with build.rs » Tutorial » Create a build.rs File » Create a build.rs File","id":"10","title":"Create a build.rs File"},"11":{"body":"We can use the include! macro to dump our generated bindings right into our crate's main entry point, src/lib.rs: #![allow(non_upper_case_globals)]\n#![allow(non_camel_case_types)]\n#![allow(non_snake_case)] include!(concat!(env!(\"OUT_DIR\"), \"/bindings.rs\")); Because bzip2's symbols do not follow Rust's style conventions, we suppress a bunch of warnings with a few #![allow(...)] pragmas. We can run cargo build again to check that the bindings themselves compile: $ cargo build Compiling bindgen-tutorial-bzip2-sys v0.1.0 Finished debug [unoptimized + debuginfo] target(s) in 62.8 secs And we can run cargo test to verify that the layout, size, and alignment of our generated Rust FFI structs match what bindgen thinks they should be: $ cargo test Compiling bindgen-tutorial-bzip2-sys v0.1.0 Finished debug [unoptimized + debuginfo] target(s) in 0.0 secs Running target/debug/deps/bzip2_sys-10413fc2af207810 running 14 tests\ntest bindgen_test_layout___darwin_pthread_handler_rec ... ok\ntest bindgen_test_layout___sFILE ... ok\ntest bindgen_test_layout___sbuf ... ok\ntest bindgen_test_layout__bindgen_ty_1 ... ok\ntest bindgen_test_layout__bindgen_ty_2 ... ok\ntest bindgen_test_layout__opaque_pthread_attr_t ... ok\ntest bindgen_test_layout__opaque_pthread_cond_t ... ok\ntest bindgen_test_layout__opaque_pthread_mutex_t ... ok\ntest bindgen_test_layout__opaque_pthread_condattr_t ... ok\ntest bindgen_test_layout__opaque_pthread_mutexattr_t ... ok\ntest bindgen_test_layout__opaque_pthread_once_t ... ok\ntest bindgen_test_layout__opaque_pthread_rwlock_t ... ok\ntest bindgen_test_layout__opaque_pthread_rwlockattr_t ... ok\ntest bindgen_test_layout__opaque_pthread_t ... ok test result: ok. 14 passed; 0 failed; 0 ignored; 0 measured Doc-tests bindgen-tutorial-bzip2-sys running 0 tests test result: ok. 0 passed; 0 failed; 0 ignored; 0 measured","breadcrumbs":"Library Usage with build.rs » Tutorial » Include the Generated Bindings in src/lib.rs » Include the Generated Bindings in src/lib.rs","id":"11","title":"Include the Generated Bindings in src/lib.rs"},"12":{"body":"Finally, to tie everything together, let's write a sanity test that round trips some text through compression and decompression, and then asserts that it came back out the same as it went in. This is a little wordy using the raw FFI bindings, but hopefully we wouldn't usually ask people to do this, we'd provide a nice Rust-y API on top of the raw FFI bindings for them. However, since this is for testing the bindings directly, our sanity test will use the bindings directly. The test data I'm round tripping are some Futurama quotes I got off the internet and put in the futurama-quotes.txt file, which is read into a &'static str at compile time via the include_str!(\"../futurama-quotes.txt\") macro invocation. Without further ado, here is the test, which should be appended to the bottom of our src/lib.rs file: #[cfg(test)]\nmod tests { use super::*; use std::mem; #[test] fn round_trip_compression_decompression() { unsafe { let input = include_str!(\"../futurama-quotes.txt\").as_bytes(); let mut compressed_output: Vec<u8> = vec![0; input.len()]; let mut decompressed_output: Vec<u8> = vec![0; input.len()]; // Construct a compression stream. let mut stream: bz_stream = mem::zeroed(); let result = BZ2_bzCompressInit(&mut stream as *mut _, 1, // 1 x 100000 block size 4, // verbosity (4 = most verbose) 0); // default work factor match result { r if r == (BZ_CONFIG_ERROR as _) => panic!(\"BZ_CONFIG_ERROR\"), r if r == (BZ_PARAM_ERROR as _) => panic!(\"BZ_PARAM_ERROR\"), r if r == (BZ_MEM_ERROR as _) => panic!(\"BZ_MEM_ERROR\"), r if r == (BZ_OK as _) => {}, r => panic!(\"Unknown return value = {}\", r), } // Compress `input` into `compressed_output`. stream.next_in = input.as_ptr() as *mut _; stream.avail_in = input.len() as _; stream.next_out = compressed_output.as_mut_ptr() as *mut _; stream.avail_out = compressed_output.len() as _; let result = BZ2_bzCompress(&mut stream as *mut _, BZ_FINISH as _); match result { r if r == (BZ_RUN_OK as _) => panic!(\"BZ_RUN_OK\"), r if r == (BZ_FLUSH_OK as _) => panic!(\"BZ_FLUSH_OK\"), r if r == (BZ_FINISH_OK as _) => panic!(\"BZ_FINISH_OK\"), r if r == (BZ_SEQUENCE_ERROR as _) => panic!(\"BZ_SEQUENCE_ERROR\"), r if r == (BZ_STREAM_END as _) => {}, r => panic!(\"Unknown return value = {}\", r), } // Finish the compression stream. let result = BZ2_bzCompressEnd(&mut stream as *mut _); match result { r if r == (BZ_PARAM_ERROR as _) => panic!(\"BZ_PARAM_ERROR\"), r if r == (BZ_OK as _) => {}, r => panic!(\"Unknown return value = {}\", r), } // Construct a decompression stream. let mut stream: bz_stream = mem::zeroed(); let result = BZ2_bzDecompressInit(&mut stream as *mut _, 4, // verbosity (4 = most verbose) 0); // default small factor match result { r if r == (BZ_CONFIG_ERROR as _) => panic!(\"BZ_CONFIG_ERROR\"), r if r == (BZ_PARAM_ERROR as _) => panic!(\"BZ_PARAM_ERROR\"), r if r == (BZ_MEM_ERROR as _) => panic!(\"BZ_MEM_ERROR\"), r if r == (BZ_OK as _) => {}, r => panic!(\"Unknown return value = {}\", r), } // Decompress `compressed_output` into `decompressed_output`. stream.next_in = compressed_output.as_ptr() as *mut _; stream.avail_in = compressed_output.len() as _; stream.next_out = decompressed_output.as_mut_ptr() as *mut _; stream.avail_out = decompressed_output.len() as _; let result = BZ2_bzDecompress(&mut stream as *mut _); match result { r if r == (BZ_PARAM_ERROR as _) => panic!(\"BZ_PARAM_ERROR\"), r if r == (BZ_DATA_ERROR as _) => panic!(\"BZ_DATA_ERROR\"), r if r == (BZ_DATA_ERROR_MAGIC as _) => panic!(\"BZ_DATA_ERROR\"), r if r == (BZ_MEM_ERROR as _) => panic!(\"BZ_MEM_ERROR\"), r if r == (BZ_OK as _) => panic!(\"BZ_OK\"), r if r == (BZ_STREAM_END as _) => {}, r => panic!(\"Unknown return value = {}\", r), } // Close the decompression stream. let result = BZ2_bzDecompressEnd(&mut stream as *mut _); match result { r if r == (BZ_PARAM_ERROR as _) => panic!(\"BZ_PARAM_ERROR\"), r if r == (BZ_OK as _) => {}, r => panic!(\"Unknown return value = {}\", r), } assert_eq!(input, &decompressed_output[..]); } }\n} Now let's run cargo test again and verify that everything is linking and binding properly! $ cargo test Compiling bindgen-tutorial-bzip2-sys v0.1.0 Finished debug [unoptimized + debuginfo] target(s) in 0.54 secs Running target/debug/deps/bindgen_tutorial_bzip2_sys-1c5626bbc4401c3a running 15 tests\ntest bindgen_test_layout___darwin_pthread_handler_rec ... ok\ntest bindgen_test_layout___sFILE ... ok\ntest bindgen_test_layout___sbuf ... ok\ntest bindgen_test_layout__bindgen_ty_1 ... ok\ntest bindgen_test_layout__bindgen_ty_2 ... ok\ntest bindgen_test_layout__opaque_pthread_attr_t ... ok\ntest bindgen_test_layout__opaque_pthread_cond_t ... ok\ntest bindgen_test_layout__opaque_pthread_condattr_t ... ok\ntest bindgen_test_layout__opaque_pthread_mutex_t ... ok\ntest bindgen_test_layout__opaque_pthread_mutexattr_t ... ok\ntest bindgen_test_layout__opaque_pthread_once_t ... ok\ntest bindgen_test_layout__opaque_pthread_rwlock_t ... ok\ntest bindgen_test_layout__opaque_pthread_rwlockattr_t ... ok\ntest bindgen_test_layout__opaque_pthread_t ... ok block 1: crc = 0x47bfca17, combined CRC = 0x47bfca17, size = 2857 bucket sorting ... depth 1 has 2849 unresolved strings depth 2 has 2702 unresolved strings depth 4 has 1508 unresolved strings depth 8 has 538 unresolved strings depth 16 has 148 unresolved strings depth 32 has 0 unresolved strings reconstructing block ... 2857 in block, 2221 after MTF & 1-2 coding, 61+2 syms in use initial group 5, [0 .. 1], has 570 syms (25.7%) initial group 4, [2 .. 2], has 256 syms (11.5%) initial group 3, [3 .. 6], has 554 syms (24.9%) initial group 2, [7 .. 12], has 372 syms (16.7%) initial group 1, [13 .. 62], has 469 syms (21.1%) pass 1: size is 2743, grp uses are 13 6 15 0 11 pass 2: size is 1216, grp uses are 13 7 15 0 10 pass 3: size is 1214, grp uses are 13 8 14 0 10 pass 4: size is 1213, grp uses are 13 9 13 0 10 bytes: mapping 19, selectors 17, code lengths 79, codes 1213 final combined CRC = 0x47bfca17 [1: huff+mtf rt+rld {0x47bfca17, 0x47bfca17}] combined CRCs: stored = 0x47bfca17, computed = 0x47bfca17\ntest tests::round_trip_compression_decompression ... ok test result: ok. 15 passed; 0 failed; 0 ignored; 0 measured Doc-tests bindgen-tutorial-bzip2-sys running 0 tests test result: ok. 0 passed; 0 failed; 0 ignored; 0 measured","breadcrumbs":"Library Usage with build.rs » Tutorial » Write a Sanity Test » Write a Sanity Test","id":"12","title":"Write a Sanity Test"},"13":{"body":"That's it! Now we can publish our crate on crates.io and we can write a nice, Rust-y API wrapping the raw FFI bindings in a safe interface. However, there is already a bzip2-sys crate providing raw FFI bindings, and there is already a bzip2 crate providing a nice, safe, Rust-y API on top of the bindings, so we have nothing left to do here! Check out the full code on Github!","breadcrumbs":"Library Usage with build.rs » Tutorial » Publish Your Crate! » Publish Your Crate!","id":"13","title":"Publish Your Crate!"},"14":{"body":"Now let's suppose we want to generate bindings for a non-system library. We will be the same crate setup as the previous tutorial. First let's create a new directory hello with two files inside it. A C source file hello.c containing int hello() { return 42;\n} and a C header file hello.h containing int hello(); Given that the library has not been compiled yet, we need to modify the build.rs build script to compile the hello.c source file into a static library: use std::env;\nuse std::path::PathBuf; use bindgen::CargoCallbacks; fn main() { // This is the directory where the `c` library is located. let libdir_path = PathBuf::from(\"hello\") // Canonicalize the path as `rustc-link-search` requires an absolute // path. .canonicalize() .expect(\"cannot canonicalize path\"); // This is the path to the `c` headers file. let headers_path = libdir_path.join(\"hello.h\"); let headers_path_str = headers_path.to_str().expect(\"Path is not a valid string\"); // This is the path to the intermediate object file for our library. let obj_path = libdir_path.join(\"hello.o\"); // This is the path to the static library file. let lib_path = libdir_path.join(\"libhello.a\"); // Tell cargo to look for shared libraries in the specified directory println!(\"cargo:rustc-link-search={}\", libdir_path.to_str().unwrap()); // Tell cargo to tell rustc to link our `hello` library. Cargo will // automatically know it must look for a `libhello.a` file. println!(\"cargo:rustc-link-lib=hello\"); // Run `clang` to compile the `hello.c` file into a `hello.o` object file. // Unwrap if it is not possible to spawn the process. if !std::process::Command::new(\"clang\") .arg(\"-c\") .arg(\"-o\") .arg(&obj_path) .arg(libdir_path.join(\"hello.c\")) .output() .expect(\"could not spawn `clang`\") .status .success() { // Panic if the command was not successful. panic!(\"could not compile object file\"); } // Run `ar` to generate the `libhello.a` file from the `hello.o` file. // Unwrap if it is not possible to spawn the process. if !std::process::Command::new(\"ar\") .arg(\"rcs\") .arg(lib_path) .arg(obj_path) .output() .expect(\"could not spawn `ar`\") .status .success() { // Panic if the command was not successful. panic!(\"could not emit library file\"); } // The bindgen::Builder is the main entry point // to bindgen, and lets you build up options for // the resulting bindings. let bindings = bindgen::Builder::default() // The input header we would like to generate // bindings for. .header(headers_path_str) // Tell cargo to invalidate the built crate whenever any of the // included header files changed. .parse_callbacks(Box::new(CargoCallbacks::new())) // Finish the builder and generate the bindings. .generate() // Unwrap the Result and panic on failure. .expect(\"Unable to generate bindings\"); // Write the bindings to the $OUT_DIR/bindings.rs file. let out_path = PathBuf::from(env::var(\"OUT_DIR\").unwrap()).join(\"bindings.rs\"); bindings .write_to_file(out_path) .expect(\"Couldn't write bindings!\");\n}","breadcrumbs":"Library Usage with build.rs » Bindings for non-system libraries","id":"14","title":"Library Usage with build.rs"},"15":{"body":"Install the bindgen executable with cargo: $ cargo install bindgen-cli The bindgen executable is installed to ~/.cargo/bin. You have to add that directory to your $PATH to use bindgen. bindgen takes the path to an input C or C++ header file, and optionally an output file path for the generated bindings. If the output file path is not supplied, the bindings are printed to stdout. If we wanted to generated Rust FFI bindings from a C header named input.h and put them in the bindings.rs file, we would invoke bindgen like this: $ bindgen input.h -o bindings.rs For more details, pass the --help flag: $ bindgen --help","breadcrumbs":"Command Line Usage » Command Line Usage","id":"15","title":"Command Line Usage"},"16":{"body":"The translation of classes, structs, enums, and typedefs can be adjusted in a few ways: By using the bindgen::Builder's configuration methods, when using bindgen as a library. By passing extra flags and options to the bindgen executable. By adding an annotation comment to the C/C++ source code. Annotations are specially formatted HTML tags inside doxygen style comments: For single line comments: /// <div rustbindgen></div> For multi-line comments: /** * <div rustbindgen></div> */ We'll leave the nitty-gritty details to the docs.rs API reference and bindgen --help, but provide higher level concept documentation here.","breadcrumbs":"Customizing the Generated Bindings » Customizing the Generated Bindings","id":"16","title":"Customizing the Generated Bindings"},"17":{"body":"Allowlisting allows us to be precise about which type, function, and global variable definitions bindgen generates bindings for. By default, if we don't specify any allowlisting rules, everything is considered allowlisted. This may not be desirable because of either the generated bindings contain a lot of extra definitions we don't plan on using, or the header file contains C++ features for which Rust does not have a corresponding form (such as partial template specialization), and we would like to avoid these definitions If we specify allowlisting rules, then bindgen will only generate bindings to types, functions, and global variables that match the allowlisting rules, or are transitively used by a definition that matches them.","breadcrumbs":"Customizing the Generated Bindings » Allowlisting » Allowlisting","id":"17","title":"Allowlisting"},"18":{"body":"bindgen::Builder::allowlist_type bindgen::Builder::allowlist_function bindgen::Builder::allowlist_var bindgen::Builder::allowlist_file bindgen::Builder::allowlist_item","breadcrumbs":"Customizing the Generated Bindings » Allowlisting » Library","id":"18","title":"Library"},"19":{"body":"--allowlist-type <type> --allowlist-function <function> --allowlist-var <var> --allowlist-file <path> --allowlist-item <item>","breadcrumbs":"Customizing the Generated Bindings » Allowlisting » Command Line","id":"19","title":"Command Line"},"2":{"body":"bindgen leverages libclang to preprocess, parse, and type check C and C++ header files. It is required to use Clang 5.0 or greater.","breadcrumbs":"Requirements » Clang","id":"2","title":"Clang"},"20":{"body":"None.","breadcrumbs":"Customizing the Generated Bindings » Allowlisting » Annotations","id":"20","title":"Annotations"},"21":{"body":"If you need to provide your own custom translation of some type (for example, because you need to wrap one of its fields in an UnsafeCell), you can explicitly blocklist generation of its definition. Uses of the blocklisted type will still appear in other types' definitions. (If you don't want the type to appear in the bindings at all, make it opaque instead of blocklisting it.) Blocklisted types are pessimistically assumed not to be able to derive any traits, which can transitively affect other types' ability to derive traits or not. The blocklist-file option also allows the blocklisting of all items from a particular path regex, for example to block all types defined in system headers that are transitively included.","breadcrumbs":"Customizing the Generated Bindings » Blocklisting » Blocklisting","id":"21","title":"Blocklisting"},"22":{"body":"bindgen::Builder::blocklist_file bindgen::Builder::blocklist_function bindgen::Builder::blocklist_item bindgen::Builder::blocklist_type bindgen::Builder::blocklist_var","breadcrumbs":"Customizing the Generated Bindings » Blocklisting » Library","id":"22","title":"Library"},"23":{"body":"--blocklist-file <path> --blocklist-function <function> --blocklist-item <item> --blocklist-type <type> --blocklist-var <var>","breadcrumbs":"Customizing the Generated Bindings » Blocklisting » Command Line","id":"23","title":"Command Line"},"24":{"body":"/// <div rustbindgen hide></div>\nclass Foo { // ...\n};","breadcrumbs":"Customizing the Generated Bindings » Blocklisting » Annotations","id":"24","title":"Annotations"},"25":{"body":"Sometimes a type definition is simply not translatable to Rust, for example it uses C++'s SFINAE for which Rust has no equivalent. In these cases, it is best to treat all occurrences of the type as an opaque blob of bytes with a size and alignment. bindgen will attempt to detect such cases and do this automatically, but other times it needs some explicit help from you.","breadcrumbs":"Customizing the Generated Bindings » Treating a Type as an Opaque Blob of Bytes » Treating a Type as an Opaque Blob of Bytes","id":"25","title":"Treating a Type as an Opaque Blob of Bytes"},"26":{"body":"bindgen::Builder::opaque_type","breadcrumbs":"Customizing the Generated Bindings » Treating a Type as an Opaque Blob of Bytes » Library","id":"26","title":"Library"},"27":{"body":"--opaque-type <type>","breadcrumbs":"Customizing the Generated Bindings » Treating a Type as an Opaque Blob of Bytes » Command Line","id":"27","title":"Command Line"},"28":{"body":"/// <div rustbindgen opaque></div>\nclass Foo { // ...\n};","breadcrumbs":"Customizing the Generated Bindings » Treating a Type as an Opaque Blob of Bytes » Annotation","id":"28","title":"Annotation"},"29":{"body":"The replaces annotation can be used to use a type as a replacement for other (presumably more complex) type. This is used in Stylo to generate bindings for structures that for multiple reasons are too complex for bindgen to understand. For example, in a C++ header: /** * <div rustbindgen replaces=\"nsTArray\"></div> */\ntemplate<typename T>\nclass nsTArray_Simple { T* mBuffer;\npublic: // The existence of a destructor here prevents bindgen from deriving the Clone // trait via a simple memory copy. ~nsTArray_Simple() {};\n}; That way, after code generation, the bindings for the nsTArray type are the ones that would be generated for nsTArray_Simple. Replacing is only available as an annotation. To replace a C or C++ definition with a Rust definition, use blocklisting .","breadcrumbs":"Customizing the Generated Bindings » Replacing One Type with Another » Replacing One Type with Another","id":"29","title":"Replacing One Type with Another"},"3":{"body":"Windows If you use winget: winget install LLVM.LLVM Alternatively, you can download and install the official pre-built binary from LLVM download page . You will also need to set LIBCLANG_PATH as an environment variable pointing to the bin directory of your LLVM install. For example, if you installed LLVM to D:\\programs\\LLVM, then you'd set the value to be D:\\programs\\LLVM\\bin. Alternatively, for Mingw64, you can install clang via pacman -S mingw64/mingw-w64-x86_64-clang macOS If you use Homebrew: $ brew install llvm If you use MacPorts: $ port install clang Debian-based Linuxes # apt install llvm-dev libclang-dev clang Ubuntu 18.04 provides the necessary packages directly. Arch # pacman -S clang Fedora # dnf install clang-devel OpenBSD # pkg_add llvm Add export LIBCLANG_PATH=/usr/local/lib to your profile. From source If your package manager doesn't yet offer Clang 5.0, you'll need to build from source. For that, follow the instructions here . Those instructions list optional steps. For bindgen: Checkout and build clang Checkout and build the extra-clang-tools You do not need to checkout or build compiler-rt You do not need to checkout or build libcxx","breadcrumbs":"Requirements » Installing Clang","id":"3","title":"Installing Clang"},"30":{"body":"bindgen will attempt to derive the Copy and Clone traits on a best-effort basis. Sometimes, it might not understand that although adding #[derive(Copy, Clone)] to a translated type definition will compile, it still shouldn't do that for reasons it can't know. In these cases, the nocopy annotation can be used to prevent bindgen to autoderive the Copy and Clone traits for a type.","breadcrumbs":"Customizing the Generated Bindings » Preventing the Derivation of Copy and Clone » Preventing the Derivation of Copy and Clone","id":"30","title":"Preventing the Derivation of Copy and Clone"},"31":{"body":"bindgen::Builder::no_copy","breadcrumbs":"Customizing the Generated Bindings » Preventing the Derivation of Copy and Clone » Library","id":"31","title":"Library"},"32":{"body":"--no-copy <regex>","breadcrumbs":"Customizing the Generated Bindings » Preventing the Derivation of Copy and Clone » Command Line","id":"32","title":"Command Line"},"33":{"body":"/** * Although bindgen can't know, this struct is not safe to move because pthread * mutexes can't move in memory! * * <div rustbindgen nocopy></div> */\nstruct MyMutexWrapper { pthread_mutex_t raw; // ...\n};","breadcrumbs":"Customizing the Generated Bindings » Preventing the Derivation of Copy and Clone » Annotations","id":"33","title":"Annotations"},"34":{"body":"bindgen will attempt to derive the Debug traits on a best-effort basis. Sometimes, it might not understand that although adding #[derive(Debug)] to a translated type definition will compile, it still shouldn't do that for reasons it can't know. In these cases, the nodebug annotation can be used to prevent bindgen to autoderive the Debug traits for a type.","breadcrumbs":"Customizing the Generated Bindings » Preventing the Derivation of Debug » Preventing the Derivation of Debug","id":"34","title":"Preventing the Derivation of Debug"},"35":{"body":"bindgen::Builder::no_debug","breadcrumbs":"Customizing the Generated Bindings » Preventing the Derivation of Debug » Library","id":"35","title":"Library"},"36":{"body":"--no-debug <regex>","breadcrumbs":"Customizing the Generated Bindings » Preventing the Derivation of Debug » Command Line","id":"36","title":"Command Line"},"37":{"body":"/** * Although bindgen can't know, this enum is not safe to format the output. * the value may be combined with multiple bits in many C/C++ cases, * for example: * * <div rustbindgen nodebug></div> */\nenum AVRounding { AV_ROUND_ZERO = 0, AV_ROUND_INF = 1, AV_ROUND_DOWN = 2, AV_ROUND_UP = 3, AV_ROUND_NEAR_INF = 5, AV_ROUND_PASS_MINMAX = 8192,\n}; // Prototype\nint64_t av_rescale_rnd(int64_t a, int64_t b, int64_t c, enum AVRounding) av_const; // Call\nint64_t pts = av_rescale_rnd(40000, 3600, 90000, AV_ROUND_NEAR_INF | AV_ROUND_PASS_MINMAX);","breadcrumbs":"Customizing the Generated Bindings » Preventing the Derivation of Debug » Annotations","id":"37","title":"Annotations"},"38":{"body":"bindgen will attempt to derive/impl the Default traits on a best-effort basis. Sometimes, we need customize the implement of Default for certain types, In these cases, the nodefault annotation can be used to prevent bindgen to autoderive the Default traits for a type.","breadcrumbs":"Customizing the Generated Bindings » Preventing the Derivation of Default » Preventing the Derivation of Default","id":"38","title":"Preventing the Derivation of Default"},"39":{"body":"bindgen::Builder::no_default","breadcrumbs":"Customizing the Generated Bindings » Preventing the Derivation of Default » Library","id":"39","title":"Library"},"4":{"body":"💡 This is the recommended way to use bindgen. 💡 Often times C and C++ headers will have platform- and architecture-specific #ifdefs that affect the shape of the Rust FFI bindings we need to create to interface Rust code with the outside world. By using bindgen as a library inside your build.rs, you can generate bindings for the current target on-the-fly. Otherwise, you would need to generate and maintain x86_64-unknown-linux-gnu-bindings.rs, x86_64-apple-darwin-bindings.rs, etc... separate bindings files for each of your supported targets, which can be a huge pain. The downside is that everyone building your crate also needs libclang available to run bindgen.","breadcrumbs":"Library Usage with build.rs » Library Usage with build.rs","id":"4","title":"Library Usage with build.rs"},"40":{"body":"--no-default <regex>","breadcrumbs":"Customizing the Generated Bindings » Preventing the Derivation of Default » Command Line","id":"40","title":"Command Line"},"41":{"body":"/** * We need to specify some preset values as the Default of Header. * * for example: * * <div rustbindgen nodefault></div> */\nstruct Header { unsigned int magic; unsigned char data[252];\n}; ...","breadcrumbs":"Customizing the Generated Bindings » Preventing the Derivation of Default » Annotations","id":"41","title":"Annotations"},"42":{"body":"// Include the generated bindings.\ninclude!(concat!(env!(\"OUT_DIR\"), \"/bindings.rs\")); impl Default for Header { fn default() -> Self { Self { magic: 0x10203040u32, data: [0; 252usize], } }\n}","breadcrumbs":"Customizing the Generated Bindings » Preventing the Derivation of Default » Customize Implements","id":"42","title":"Customize Implements"},"43":{"body":"bindgen can be instructed to annotate certain types with #[must_use] . Some libraries have a common error type, returned by lots of their functions, which needs to be checked after every call. In these cases it's useful to add #[must_use] to this type, so the Rust compiler emits a warning when the check is missing.","breadcrumbs":"Customizing the Generated Bindings » Annotating types with #[must-use] » Annotating types with #[must-use]","id":"43","title":"Annotating types with #[must-use]"},"44":{"body":"bindgen::Builder::must_use_type","breadcrumbs":"Customizing the Generated Bindings » Annotating types with #[must-use] » Library","id":"44","title":"Library"},"45":{"body":"--must-use-type <regex>","breadcrumbs":"Customizing the Generated Bindings » Annotating types with #[must-use] » Command Line","id":"45","title":"Command Line"},"46":{"body":"/** <div rustbindgen mustusetype></div> */\nstruct ErrorType { // ...\n}; ...","breadcrumbs":"Customizing the Generated Bindings » Annotating types with #[must-use] » Annotations","id":"46","title":"Annotations"},"47":{"body":"Fields can be made private for various reasons. You may wish to enforce some invariant on the fields of a structure, which cannot be achieved if the field is public and can be set by any code. For example, you may wish to ensure that a pointer always points to something appropriate.","breadcrumbs":"Customizing the Generated Bindings » Field visibility » Making fields private","id":"47","title":"Making fields private"},"48":{"body":"struct OneFieldPrivate { /** Null-terminated, static string. <div rustbindgen private> */ const char *s; bool b;\n}; /** <div rustbindgen private> */\nstruct MostFieldsPrivate { int a; bool b; /** <div rustbindgen private=\"false\"></div> */ char c;\n}; Then in Rust: # #[repr(C)]\n# pub struct OneFieldPrivate {\n# s: *const ::std::os::raw::c_char,\n# pub b: bool,\n# } impl OneFieldPrivate { pub fn new(s: &'static std::ffi::CStr, b: bool) -> Self { OneFieldPrivate { s: s.as_ptr(), b } }\n}","breadcrumbs":"Customizing the Generated Bindings » Field visibility » Annotation","id":"48","title":"Annotation"},"49":{"body":"bindgen uses rustfmt to format the emitted bindings. This section describes how to adjust the rustfmt behavior when being used from bindgen.","breadcrumbs":"Customizing the Generated Bindings » Code formatting » Code Formatting","id":"49","title":"Code Formatting"},"5":{"body":"📚 There is complete API reference documentation on docs.rs 📚","breadcrumbs":"Library Usage with build.rs » Library API Documentation","id":"5","title":"Library API Documentation"},"50":{"body":"rustfmt should automatically use any rustfmt.toml file that is present in the directory from where bindgen will be run. If you want to use a configuration file that has a different name or that is in a different directory you can use the --rustfmt-configuration-file flag or the Builder::rustfmt_configuration_file method.","breadcrumbs":"Customizing the Generated Bindings » Code formatting » Passing a rustfmt.toml configuration file","id":"50","title":"Passing a rustfmt.toml configuration file"},"51":{"body":"If the rustfmt command does not correspond to a nightly release of rustfmt but you have rustup available, you can use nightly by following these steps:","breadcrumbs":"Customizing the Generated Bindings » Code formatting » Using a nightly release of rustfmt","id":"51","title":"Using a nightly release of rustfmt"},"52":{"body":"Use rustup run to run bindgen: $ rustup run nightly bindgen [ARGS]","breadcrumbs":"Customizing the Generated Bindings » Code formatting » When using bindgen as a CLI application","id":"52","title":"When using bindgen as a CLI application"},"53":{"body":"Take the output of the following command: $ rustup which rustfmt --toolchain=nightly and pass it to Builder::with_rustfmt : use bindgen::Builder;\nuse std::process::Command; fn main() { let output = Command::new(\"rustup\") .args([\"which\", \"rustfmt\", \"--toolchain\", \"nightly\"]) .output() .expect(\"Could not spawn `rustup` command\"); assert!( output.status.success(), \"Unsuccessful status code when running `rustup`: {:?}\", output ); let rustfmt_path = String::from_utf8(output.stdout).expect(\"The `rustfmt` path is not valid `utf-8`\"); let bindings = Builder::default() .header(\"path/to/input.h\") .with_rustfmt(rustfmt_path) .generate() .expect(\"Could not generate bindings\"); bindings .write_to_file(\"path/to/output.rs\") .expect(\"Could not write bindings\");\n} These two methods also apply to any other toolchain available in your system.","breadcrumbs":"Customizing the Generated Bindings » Code formatting » When using bindgen as a library","id":"53","title":"When using bindgen as a library"},"54":{"body":"The prettyplease crate is a minimal formatter for generated code. To format bindings using prettyplease you have to invoke bindgen with either the --formatter=prettyplease flag or the bindgen::Builder::formatter(bindgen::Formatter::Prettyplease). One of its advantages is that prettyplease can be used in minimal environments where the Rust toolchain is not installed.","breadcrumbs":"Customizing the Generated Bindings » Code formatting » Using prettyplease","id":"54","title":"Using prettyplease"},"55":{"body":"bindgen emits all the documentation using #[doc] attributes by default. If you want to use the more user-friendly /// syntax, you have two options:","breadcrumbs":"Customizing the Generated Bindings » Code formatting » How can I normalize #[doc] attributes?","id":"55","title":"How can I normalize #[doc] attributes?"},"56":{"body":"rustfmt can be configured to normalize documentation. To do so, you have to create a rustfmt.toml file with the following contents: normalize_doc_attributes = true Then, you have set up bindgen so it passes this file to rustfmt. Given that the normalize_doc_attributes option is unstable , you also have to set up bindgen to use a nightly release of rustfmt.","breadcrumbs":"Customizing the Generated Bindings » Code formatting » Use rustfmt","id":"56","title":"Use rustfmt"},"57":{"body":"prettyplease normalizes documentation without any additional configuration. Then you just have to tell bindgen to use prettyplease as the code formatter.","breadcrumbs":"Customizing the Generated Bindings » Code formatting » Use prettyplease","id":"57","title":"Use prettyplease"},"58":{"body":"bindgen can handle some C++ features, but not all of them. To set expectations: bindgen will give you the type definitions and FFI declarations you need to build an API to the C++ library, but using those types in Rust will be nowhere near as nice as using them in C++. You will have to manually call constructors, destructors, overloaded operators, etc yourself. When passing in header files, the file will automatically be treated as C++ if it ends in .hpp. If it doesn't, adding -x c++ clang args can be used to force C++ mode. You probably also want to use -std=c++14 or similar clang args as well. You pretty much must use allowlisting when working with C++ to avoid pulling in all of the std::.* types, many of which bindgen cannot handle. Additionally, you may want to mark other types as opaque that bindgen stumbles on. It is recommended to mark all of std::.* opaque, and to allowlist only precisely the functions and types you intend to use. You should read up on the FAQs as well.","breadcrumbs":"Generating Bindings to C++ » Generating Bindings to C++","id":"58","title":"Generating Bindings to C++"},"59":{"body":"Inheritance (for the most part; there are some outstanding bugs ) Methods Bindings to constructors and destructors (but they aren't implicitly or automatically invoked) Function and method overloading Templates without specialization. You should be able to access individual fields of the class or struct.","breadcrumbs":"Generating Bindings to C++ » Supported Features","id":"59","title":"Supported Features"},"6":{"body":"The next section contains a detailed, step-by-step tutorial for using bindgen as a library inside build.rs.","breadcrumbs":"Library Usage with build.rs » Tutorial","id":"6","title":"Tutorial"},"60":{"body":"When bindgen finds a type that is too difficult or impossible to translate into Rust, it will automatically treat it as an opaque blob of bytes. The philosophy is that we should always get layout, size, and alignment correct, and just because one type uses specialization, that shouldn't cause bindgen to give up on everything else. Without further ado, here are C++ features that bindgen does not support or cannot translate into Rust: Inline functions and methods: see \"Why isn't bindgen generating bindings to inline functions?\" Template functions, methods of template classes and structs. We don't know which monomorphizations exist, and can't create new ones because we aren't a C++ compiler. Anything related to template specialization: Partial template specialization Traits templates Substitution Failure Is Not An Error (SFINAE) Cross language inheritance, for example inheriting from a Rust struct in C++. Automatically calling copy and/or move constructors or destructors. Supporting this isn't possible with Rust's move semantics. Exceptions: if a function called through a bindgen-generated interface raises an exception that is not caught by the function itself, this will generate undefined behaviour. See the tracking issue for exceptions for more details. Many C++ specific aspects of calling conventions. For example in the Itanium abi types that are \" non trivial for the purposes of calls \" should be passed by pointer, even if they are otherwise eligible to be passed in a register. Similarly in both the Itanium and MSVC ABIs such types are returned by \"hidden parameter\", much like large structs in C that would not fit into a register. This also applies to types with any base classes in the MSVC ABI (see x64 calling convention ). Because bindgen does not know about these rules generated interfaces using such types are currently invalid.","breadcrumbs":"Generating Bindings to C++ » Unsupported Features","id":"60","title":"Unsupported Features"},"61":{"body":"bindgen will generate a wrapper for any class constructor declared in the input headers. For example, this headers file class MyClass { public: MyClass(); void method();\n}; Will produce the following code: #[repr(C)]\n#[derive(Debug, Copy, Clone)]\npub struct MyClass { pub _address: u8,\n}\nextern \"C\" { #[link_name = \"\\u{1}_ZN7MyClass6methodEv\"] pub fn MyClass_method(this: *mut MyClass);\n}\nextern \"C\" { #[link_name = \"\\u{1}_ZN7MyClassC1Ev\"] pub fn MyClass_MyClass(this: *mut MyClass);\n}\nimpl MyClass { #[inline] pub unsafe fn method(&mut self) { MyClass_method(self) } #[inline] pub unsafe fn new() -> Self { let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit(); MyClass_MyClass(__bindgen_tmp.as_mut_ptr()); __bindgen_tmp.assume_init() }\n} This MyClass::new Rust method can be used as a substitute for the MyClass C++ constructor. However, the address of the value from inside the method will be different than from the outside. This is because the __bindgen_tmp value is moved when the MyClass::new method returns. In contrast, the C++ constructor will not move the value, meaning that the address of the value will be the same inside and outside the constructor. If the original C++ relies on this semantic difference somehow, you should use the MyClass_MyClass binding directly instead of the MyClass::new method. In other words, the Rust equivalent for the following C++ code MyClass instance = MyClass();\ninstance.method(); is not this let instance = MyClass::new();\ninstance.method(); but this let instance = std::mem::MaybeUninit::<MyClass>::uninit();\nMyClass_MyClass(instance.as_mut_ptr());\ninstance.assume_init_mut().method(); You can easily verify this fact if you provide a implementation for MyClass and method that prints the this pointer address. However, you can ignore this fact if you know that the original C++ code does not rely on the instance address in its internal logic.","breadcrumbs":"Generating Bindings to C++ » Constructor semantics","id":"61","title":"Constructor semantics"},"62":{"body":"bindgen does not (yet) have full objective-c support but it can generate bindings for a lot of the apple frameworks without too much blocklisting. In order to generate bindings, you will need -x objective-c as the clang args. If you'd like to use block you will need -fblocks as a clang arg as well. Depending on your setup, you may need --generate-block to generate the block function aliases and --block-extern-crate to insert a extern crate block at the beginning of the generated bindings. The same logic applies to the --objc-extern-crate parameter. The objective-c classes will be represented as a struct Foo(id) and a trait IFoo where Foo is the objective-c class and id is an alias for *mut objc::runtime::Object (the pointer to the objective-c instance). The trait IFoo is needed to allow for the generated inheritance. Functions that use or return objective-c pointers of instance Foo will return Foo. The reason this works is because Foo represented as transparent. This will be helpful for a lot of objective-c frameworks however there are some cases where functions return instancetype which is a type alias for id so an occasional foo.0 may be required. An example of this would in the UIKit framework should you want to add a UILabel to a UIStackView you will need to convert the UILabel to a UIView via UIView(label.0). Each class (struct) has an alloc and a dealloc to match that of some of the alloc methods found in NSObject. In order to initialize a class Foo, you will have to do something like let foo = Foo(Foo::alloc().initWithStuff()). To blocklist an Objective-C method, you should add the bindgen generated method path (e.g. IFoo::method or IFoo::class_method) as a blocklist item.","breadcrumbs":"Generating Bindings to Objective-c » Generating Bindings to Objective-C","id":"62","title":"Generating Bindings to Objective-C"},"63":{"body":"Inheritance matched to rust traits with prefixes of I which stands for interface. Protocols which match to rust traits with prefixes of P which stands for Protocol. Classes will generate struct Foo(id) where Foo is the class name and id is a pointer to the objective-c Object. Blocks","breadcrumbs":"Generating Bindings to Objective-c » Supported Features","id":"63","title":"Supported Features"},"64":{"body":"If you're targeting aarch64-apple-ios, you'll need to have the clang arg --target=arm64-apple-ios as mentioned here . The generated bindings will almost certainly have some conflicts so you will have to blocklist a few things. There are a few cases of the parameters being poorly named in the objective-c headers. But if you're using anything with Core Foundation, you'll find that time.h as has a variable called timezone that conflicts with some of the things in NSCalendar.h. Some small subset of the function headers in the apple frameworks go against apple's guidelines for parameter names and duplicate the names in the header which won't compile as mentioned here . instancetype return methods does not return Self for you given class, it returns a mut * objc::runtime::Objc which is aliased as id. This is because objective-c's inheritance doesn't perfectly match that of rusts. Depending on what you're trying bindgen against, you may end up including all of Core Foundation and any other frameworks. This will result in a very long compile time.","breadcrumbs":"Generating Bindings to Objective-c » Useful Notes","id":"64","title":"Useful Notes"},"65":{"body":"Nullability attributes which return Options. Probably many other things. Feel free to open an issue .","breadcrumbs":"Generating Bindings to Objective-c » Not (yet) Supported","id":"65","title":"Not (yet) Supported"},"66":{"body":"uikit-sys","breadcrumbs":"Generating Bindings to Objective-c » Example crate(s)","id":"66","title":"Example crate(s)"},"67":{"body":"NOTE : Rust 1.19 stabilized the union type (see Rust issue #32836 ). You can pass the --rust-target option to tell bindgen to target a specific version of Rust. By default, bindgen will target the latest stable Rust. The --rust-target option accepts a specific stable version (such as \"1.0\" or \"1.19\") or \"nightly\". NOTE : The --unstable-rust option is deprecated; use --rust-target nightly instead. In general, most interactions with unions (either reading or writing) are unsafe, meaning you must surround union accesses in an unsafe {} block. For this discussion, we will use the following C type definitions: typedef struct { int32_t a; int32_t b;\n} alpha_t; typedef struct { uint32_t c; uint16_t d; uint16_t e; uint8_t f;\n} beta_t; typedef union { alpha_t alfa; beta_t bravo;\n} greek_t;","breadcrumbs":"Using Unions » Using the Union Types Generated by Bindgen","id":"67","title":"Using the Union Types Generated by Bindgen"},"68":{"body":"","breadcrumbs":"Using Unions » Relevant Bindgen Options","id":"68","title":"Relevant Bindgen Options"},"69":{"body":"bindgen::Builder::rust_target() bindgen::Builder::derive_default()","breadcrumbs":"Using Unions » Library","id":"69","title":"Library"},"7":{"body":"The following tutorial is adapted from this blog post . What follows is a whirlwind introductory tutorial to using bindgen from inside build.rs. We'll generate bindings to bzip2 (which is available on most systems) on-the-fly. TL;DR? The full tutorial code is available here.","breadcrumbs":"Library Usage with build.rs » Tutorial » Tutorial","id":"7","title":"Tutorial"},"70":{"body":"--rust-target --with-derive-default","breadcrumbs":"Using Unions » Command Line","id":"70","title":"Command Line"},"71":{"body":"Bindgen can emit one of two Rust types that correspond to C unions: Rust's union builtin (only available in Rust >= 1.19, including nightly) Bindgen's BindgenUnion (available for all Rust targets) Bindgen uses the following logic to determine which Rust union type to emit: If the Rust target is >= 1.19 (including nightly) AND each field of the union can derive Copy, then generate a union builtin. Otherwise, generate a BindgenUnion.","breadcrumbs":"Using Unions » Which union type will Bindgen generate?","id":"71","title":"Which union type will Bindgen generate?"},"72":{"body":"When using the union builtin type, there are two choices for initialization: Zero With a specific variant mod bindings_builtin_union; fn union_builtin() { // Initialize the union to zero let x = bindings_builtin_union::greek_t::default(); // If `--with-derive-default` option is not used, the following may be used // to initialize the union to zero: let x = unsafe { std::mem::zeroed::<bindings_builtin_union::greek_t>() }; // Or, it is possible to initialize exactly one variant of the enum: let x = bindings_builtin_union::greek_t { alfa: bindings_builtin_union::alpha_t { a: 1, b: -1, }, }; unsafe { println!(\"{:?}\", z.alfa); // alpha_t { a: 1, b: -1 } println!(\"{:?}\", z.bravo); // beta_t { c: 1, d: 65535, e: 65535, f: 127 } }\n}","breadcrumbs":"Using Unions » Using the union builtin","id":"72","title":"Using the union builtin"},"73":{"body":"If the target Rust version does not support the new union type or there is a field that cannot derive Copy, then bindgen will provide union-like access to a struct. Interacting with these unions is slightly different than the new union types. You must access union variants through a reference. mod bindings; fn bindgenunion() { // `default()` or `zeroed()` may still be used with Bindgen's Union types let mut x = bindings::greek_t::default(); // This will not work: // let x = bindings::greek_t { // alfa: bindings::alpha_t { // a: 1, // b: -1, // }, // }; // Instead, access the field through `.as_ref()` and `.as_mut()` helpers: unsafe { *x.alfa.as_mut() = bindings::alpha_t { a: 1, b: -1, }; println!(\"{:?}\", x.alfa.as_ref()); // alpha_t { a: 1, b: -1 } println!(\"{:?}\", x.bravo.as_ref()); // beta_t { c: 1, d: 65535, e: 65535, f: 0 } } If you attempt to access a BindgenUnion field directly, you will see errors like this: error[E0308]: mismatched types --> src/main.rs:44:15 |\n44 | alfa: bindings::alpha_t { | _______________^\n45 | | a: 1,\n46 | | b: -1,\n47 | | }, | |_________^ expected struct `bindings::__BindgenUnionField`, found struct `bindings::alpha_t` | = note: expected type `bindings::__BindgenUnionField<bindings::alpha_t>` found type `bindings::alpha_t`","breadcrumbs":"Using Unions » Using the BindgenUnion type","id":"73","title":"Using the BindgenUnion type"},"74":{"body":"","breadcrumbs":"Using Bitfields » Using the Bitfield Types Generated by Bindgen","id":"74","title":"Using the Bitfield Types Generated by Bindgen"},"75":{"body":"As Rust does not support bitfields, Bindgen generates a struct for each with the following characteristics Immutable getter functions for each bitfield named <bitfield> Setter functions for each contiguous block of bitfields named set_<bitfield> For each contiguous block of bitfields, Bindgen emits an opaque physical field that contains one or more logical bitfields A static constructor new_bitfield_{1, 2, ...} with a parameter for each bitfield contained within the opaque physical field. To keep bindgen from generating the bitfield unit struct, it can be blocklisted like any other type, i.e. --blocklist-type \"__BindgenBitfieldUnit\". This may be useful if you want to define a custom implementation, or your generated bindings import a pre-existing definition for the bitfield unit type.","breadcrumbs":"Using Bitfields » Bitfield Strategy Overview","id":"75","title":"Bitfield Strategy Overview"},"76":{"body":"For this discussion, we will use the following C type definitions and functions. typedef struct { unsigned int a: 1; unsigned int b: 1; unsigned int c: 2; } StructWithBitfields; // Create a default bitfield\nStructWithBitfields create_bitfield(); // Print a bitfield\nvoid print_bitfield(StructWithBitfields bfield); Bindgen creates a set of field getters and setters for interacting with the bitset. For example, let mut bfield = unsafe { create_bitfield() }; bfield.set_a(1); println!(\"a set to {}\", bfield.a()); bfield.set_b(1); println!(\"b set to {}\", bfield.b()); bfield.set_c(3); println!(\"c set to {}\", bfield.c()); unsafe { print_bitfield(bfield) }; will print out a set to 1\nb set to 1\nc set to 3\nStructWithBitfields: a:1, b:1, c:3 Overflowing a bitfield will result in the same behavior as in C/C++: the bitfield will be set to 0. let mut bfield = unsafe { create_bitfield() }; bfield.set_a(1); bfield.set_b(1); bfield.set_c(12); println!(\"c set to {} due to overflow\", bfield.c()); unsafe { print_bitfield(bfield) }; will print out c set to 0 due to overflow\nStructWithBitfields: a:1, b:1, c:0 To create a new bitfield in Rust, use the bitfield allocation unit constructor. Note: This requires the Builder's derive_default to be set to true, otherwise the necessary Default functions won't be generated. let bfield = StructWithBitfields{ _bitfield_1: StructWithBitfields::new_bitfield_1(0,0,0), ..Default::default() }; unsafe { print_bitfield(bfield) }; This will print out StructWithBitfields: a:0, b:0, c:0","breadcrumbs":"Using Bitfields » Bitfield examples","id":"76","title":"Bitfield examples"},"77":{"body":"Since time immemorial, C programmers have been using what was called \"the struct hack\". This is a technique for packing a fixed-size structure and a variable-sized tail within the same memory allocation. Typically this looks like: struct MyRecord { time_t timestamp; unsigned seq; size_t len; char payload[0];\n}; Because this is so useful, it was standardized in C99 as \"flexible array members\", using almost identical syntax: struct MyRecord { time_t timestamp; unsigned seq; size_t len; char payload[]; // NOTE: empty []\n}; Bindgen supports these structures in two different ways.","breadcrumbs":"Using Flexible Array Members » Using C structures with Flexible Array Members","id":"77","title":"Using C structures with Flexible Array Members"},"78":{"body":"By default, bindgen will generate the corresponding Rust structure: #[repr(C)]\nstruct MyRecord { pub timestamp: time_t, pub seq: ::std::os::raw::c_uint, pub len: usize, pub payload: __IncompleteArrayField<::std::os::raw::c_char>,\n} The __IncompleteArrayField type is zero-sized, so this structure represents the prefix without any trailing data. In order to access that data, it provides the as_slice unsafe method: // SAFETY: there's at least `len` bytes allocated and initialized after `myrecord` let payload = unsafe { myrecord.payload.as_slice(myrecord.len) }; There's also as_mut_slice which does the obvious. These are unsafe simply because it's up to you to provide the right length (in elements of whatever type payload is) as there's no way for Rust or Bindgen to know. In this example, the length is a very straightforward len field in the structure, but it could be encoded in any number of ways within the structure, or come from somewhere else entirely. One big caveat with this technique is that std::mem::size_of (or size_of_val) will only include the size of the prefix structure. if you're working out how much storage the whole structure is using, you'll need to add the suffix yourself.","breadcrumbs":"Using Flexible Array Members » __IncompleteArrayField","id":"78","title":"__IncompleteArrayField"},"79":{"body":"If you invoke bindgen with the --flexarray-dst option, it will generate something not quite like this: #[repr(C)]\nstruct MyRecord { pub timestamp: time_t, pub seq: ::std::os::raw::c_uint, pub len: usize, pub payload: [::std::os::raw::c_char],\n} Rust has a set of types which are almost exact analogs for these Flexible Array Member types: the Dynamically Sized Type (\"DST\"). This looks almost identical to a normal Rust structure, except that you'll note the type of the payload field is a raw slice [...] rather than the usual reference to slice &[...]. That payload: [c_char] is telling Rust that it can't directly know the total size of this structure - the payload field takes an amount of space that's determined at runtime. This means you can't directly use values of this type, only references: &MyRecord. In practice, this is very awkward. So instead, bindgen generates: #[repr(C)]\nstruct MyRecord<FAM: ?Sized = [::std::os::raw::c_char; 0]> { pub timestamp: time_t, pub seq: ::std::os::raw::c_uint, pub len: usize, pub payload: FAM,\n} That is: a type parameter FAM which represents the type of the payload field, it's ?Sized meaning it can be unsized (ie, a DST) it has the default type of [c_char; 0] - that is a zero-sized array of characters This means that referencing plain MyRecord will be exactly like MyRecord with __IncompleteArrayField: it is a fixed-sized structure which you can manipulate like a normal Rust value. But how do you get to the DST part? Bindgen will also implement a set of helper methods for this: // Static sized variant\nimpl MyRecord<[::std::os::raw::c_char; 0]> { pub unsafe fn flex_ref(&self, len: usize) -> &MyRecord<[::std::os::raw::c_char]> { ... } pub unsafe fn flex_mut_ref(&mut self, len: usize) -> &mut MyRecord<[::std::os::raw::c_char]> { ... } // And some raw pointer variants\n} These will take a sized MyRecord<[c_char; 0]> and a length in elements, and return a reference to a DST MyRecord<[c_char]> where the payload field is a fully usable slice of len characters. The magic here is that the reference is a fat pointer, which not only encodes the address, but also the dynamic size of the final field, just like a reference to a slice is. This means that you get full bounds checked access to the payload field like any other Rust slice. It also means that doing mem::size_of_val(myrecord) will return the complete size of this structure, including the suffix. You can go the other way: // Dynamic sized variant\nimpl MyRecord<[::std::os::raw::c_char]> { pub fn fixed(&self) -> (&MyRecord<[::std::os::raw::c_char; 0]>, usize) { ... } pub fn fixed_mut(&mut self) -> (&mut MyRecord<[::std::os::raw::c_char; 0]>, usize) { ... } pub fn layout(len: usize) -> std::alloc::Layout { ... }\n} which takes the DST variant of the structure and returns the sized variant, along with the number of elements are after it. These are all completely safe because all the information needed is part of the fat &self reference. The layout function takes a length and returns the Layout - that is, size and alignment, so that you can allocate memory for the structure (for example, using malloc so you can pass it to a C function). Unfortunately the language features needed to support these methods are still unstable: ptr_metadata , which enables all the fixed<->DST conversions, and layout_for_ptr , which allows he layout method As a result, if you don't specify --rust-target nightly you'll just get the bare type definitions, but no real way to use them. It's often convenient to add the --raw-line '#![feature(ptr_metadata,layout_for_ptr)]' option if you're generating Rust as a stand-alone crate. Otherwise you'll need to add the feature line to your containing crate.","breadcrumbs":"Using Flexible Array Members » Using Dynamically Sized Types","id":"79","title":"Using Dynamically Sized Types"},"8":{"body":"First we need to declare a build-time dependency on bindgen by adding it to the [build-dependencies] section of our crate's Cargo.toml file. Please always use the latest version of bindgen, as it has the most fixes and best compatibility. You can always check the latest version at the bindgen page in crates.io . [build-dependencies]\nbindgen = \"0.65.1\" ⚠️ Warning bindgen needs to be added to the [build-dependencies] section, not the normal [dependencies] section. If you add it as a regular dependency, you will get errors like the following: error[E0463]: can't find crate for `bindgen`","breadcrumbs":"Library Usage with build.rs » Tutorial » Add bindgen as a Build Dependency » Add bindgen as a Build Dependency","id":"8","title":"Add bindgen as a Build Dependency"},"80":{"body":"Why isn't bindgen generating methods for this allowlisted class? Why isn't bindgen generating bindings to inline functions? Does bindgen support the C++ Standard Template Library (STL)? How to deal with bindgen generated padding fields? How to generate bindings for a custom target?","breadcrumbs":"FAQ » Frequently Asked Questions","id":"80","title":"Frequently Asked Questions"},"81":{"body":"Are the methods inline methods, or defined inline in the class? For example: class Dooder { public: // Function defined inline in the class. int example_one() { return 1; } // `inline` function whose definition is supplied later in the header, or in // another header. inline bool example_two();\n}; inline bool Dooder::example_two() { return true;\n} If so, see \"Why isn't bindgen generating bindings to inline functions?\" If not, consider filing an issue!","breadcrumbs":"FAQ » Why isn't bindgen generating methods for this allowlisted class?","id":"81","title":"Why isn't bindgen generating methods for this allowlisted class?"},"82":{"body":"These functions don't typically end up in object files or shared libraries with symbols that we can reliably link to, since they are instead inlined into each of their call sites. Therefore, we don't generate bindings to them, since that creates linking errors. However, if you are compiling the C/C++ yourself (rather than using a system shared library, for example), then you can pass -fkeep-inline-functions or -fno-inline-functions to gcc or clang, and invoke bindgen with either the bindgen::Builder::generate_inline_functions method or the --generate-inline-functions flag. Note that these functions and methods are usually marked inline for a reason: they tend to be hot. The above workaround makes them an out-of-line call, which might not provide acceptable performance. As an alternative, you can invoke bindgen with either the bindgen::Builder::wrap_static_fns method or the --wrap-static-fns flag. Which generates a C source file that can be compiled against the input headers to produce Rust headers for static and static inline functions. See How to handle static inline functions for further information.","breadcrumbs":"FAQ » Why isn't bindgen generating bindings to inline functions?","id":"82","title":"Why isn't bindgen generating bindings to inline functions?"},"83":{"body":"Sort of. A little. Depends what you mean by \"support\". Most functions, methods, constructors, and destructors are inline in the STL. That ties our hands when it comes to linking: \"Why isn't bindgen generating bindings to inline functions?\" As far as generating opaque blobs of bytes with the correct size and alignment, bindgen can do pretty well. This is typically enough to let you use types that transitively contain STL things. We generally recommend marking std::.* as opaque, and then allowlisting only the specific things you need from the library you're binding to that is pulling in STL headers.","breadcrumbs":"FAQ » Does bindgen support the C++ Standard Template Library (STL)?","id":"83","title":"Does bindgen support the C++ Standard Template Library (STL)?"},"84":{"body":"Depending the architecture, toolchain versions and source struct, it is possible that bindgen will generate padding fields named __bindgen_padding_N. As these fields might be present when compiling for one architecture but not for an other, you should not initialize these fields manually when initializing the struct. Instead, use the Default trait. You can either enable this when constructing the Builder using the derive_default method, or you can implement this per struct using: impl Default for SRC_DATA { fn default() -> Self { unsafe { std::mem::zeroed() } }\n} This makes it possible to initialize SRC_DATA by: SRC_DATA { field_a: \"foo\", field_b: \"bar\", ..Default::default()\n} In the case bindgen generates a padding field, then this field will be automatically initialized by ..Default::default().","breadcrumbs":"FAQ » How to deal with bindgen generated padding fields?","id":"84","title":"How to deal with bindgen generated padding fields?"},"85":{"body":"To generate bindings for a custom target you only need to pass the --target argument to libclang. For example, if you want to generate bindings for the armv7a-none-eabi target using the command line, you need to invoke bindgen like so: $ bindgen <input_headers> -- --target=armv7a-none-eabi If you are using bindgen as a library, you should call builder.clang_arg(\"--target=armv7a-none-eabi\") on your builder.","breadcrumbs":"FAQ » How to generate bindings for a custom target?","id":"85","title":"How to generate bindings for a custom target?"},"9":{"body":"The wrapper.h file will include all the various headers containing declarations of structs and functions we would like bindings for. In the particular case of bzip2, this is pretty easy since the entire public API is contained in a single header. For a project like SpiderMonkey , where the public API is split across multiple header files and grouped by functionality, we'd want to include all those headers we want to bind to in this single wrapper.h entry point for bindgen. Here is our wrapper.h: #include <bzlib.h> This is also where we would add any replacement types , if we were using some.","breadcrumbs":"Library Usage with build.rs » Tutorial » Create a wrapper.h Header » Create a wrapper.h Header","id":"9","title":"Create a wrapper.h Header"}},"length":86,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"0":{"df":1,"docs":{"11":{"tf":1.0}}},"5":{"4":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"6":{"5":{".":{"1":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"9":{".":{"9":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"11":{"tf":2.8284271247461903},"12":{"tf":4.0},"37":{"tf":1.0},"42":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"79":{"tf":2.449489742783178}},"x":{"1":{"0":{"2":{"0":{"3":{"0":{"4":{"0":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"7":{"b":{"df":0,"docs":{},"f":{"c":{"a":{"1":{"7":{"df":1,"docs":{"12":{"tf":2.6457513110645907}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"1":{".":{"0":{"df":1,"docs":{"67":{"tf":1.0}}},"1":{"9":{"df":2,"docs":{"67":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"1":{"3":{"df":0,"docs":{},"f":{"c":{"2":{"a":{"df":0,"docs":{},"f":{"2":{"0":{"7":{"8":{"1":{"0":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.7320508075688772}}},"1":{".":{"5":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}},"2":{"1":{"3":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"4":{"df":1,"docs":{"12":{"tf":1.0}}},"6":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"7":{"df":1,"docs":{"72":{"tf":1.0}}},"df":1,"docs":{"12":{"tf":1.0}}},"3":{"df":1,"docs":{"12":{"tf":2.449489742783178}}},"4":{"8":{"df":1,"docs":{"12":{"tf":1.0}}},"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0}}},"5":{"0":{"8":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":2.0}}},"6":{".":{"7":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}},"7":{"df":1,"docs":{"12":{"tf":1.0}}},"8":{".":{"0":{"4":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"df":1,"docs":{"12":{"tf":1.0}}},"c":{"5":{"6":{"2":{"6":{"b":{"b":{"c":{"4":{"4":{"0":{"1":{"c":{"3":{"a":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"12":{"tf":3.0},"37":{"tf":1.0},"72":{"tf":2.23606797749979},"73":{"tf":3.0},"76":{"tf":2.0},"81":{"tf":1.0}}},"2":{"1":{".":{"1":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"2":{"1":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{".":{"9":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{".":{"7":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"2":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"6":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"7":{"0":{"2":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"4":{"3":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"4":{"9":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"5":{"7":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"12":{"tf":2.449489742783178},"37":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}}},"3":{"2":{"8":{"3":{"6":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}},"6":{"0":{"0":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"2":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"12":{"tf":1.7320508075688772},"37":{"tf":1.0},"76":{"tf":1.0}}},"4":{"2":{"df":1,"docs":{"14":{"tf":1.0}}},"4":{"df":1,"docs":{"73":{"tf":1.0}}},"5":{"df":1,"docs":{"73":{"tf":1.0}}},"6":{"9":{"df":1,"docs":{"12":{"tf":1.0}}},"df":1,"docs":{"73":{"tf":1.0}}},"7":{"df":1,"docs":{"73":{"tf":1.0}}},"df":1,"docs":{"12":{"tf":2.6457513110645907}}},"5":{".":{"0":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}},"3":{"8":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"5":{"4":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"7":{"0":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"12":{"tf":1.0},"37":{"tf":1.0}}},"6":{"1":{"+":{"2":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"8":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}},"5":{"5":{"3":{"5":{"df":2,"docs":{"72":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"7":{"9":{"df":1,"docs":{"12":{"tf":1.0}}},"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"8":{"1":{"9":{"2":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"12":{"tf":1.4142135623730951},"53":{"tf":1.0}}},"9":{"0":{"0":{"0":{"0":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}},"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"a":{"d":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{".":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"<":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{":":{":":{"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"78":{"tf":1.4142135623730951},"79":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"1":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":1,"docs":{"12":{"tf":6.164414002968976}}},"a":{":":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"1":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.7320508075688772}},"l":{"df":1,"docs":{"21":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"82":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":1.0},"82":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"59":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":2.0},"78":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"47":{"tf":1.0}}}}}}},"d":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"d":{"df":8,"docs":{"15":{"tf":1.0},"3":{"tf":1.0},"43":{"tf":1.0},"62":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"61":{"tf":2.0},"79":{"tf":1.0}}}}}}},"df":5,"docs":{"16":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":1.4142135623730951}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"49":{"tf":1.0}}}}}},"o":{"df":2,"docs":{"12":{"tf":1.0},"60":{"tf":1.0}}},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"c":{"7":{"7":{"4":{"7":{"d":{"7":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"f":{"d":{"7":{"2":{"0":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"64":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"f":{"a":{"df":3,"docs":{"67":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"i":{"a":{"df":1,"docs":{"62":{"tf":1.4142135623730951}},"s":{"df":2,"docs":{"62":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":5,"docs":{"11":{"tf":1.0},"25":{"tf":1.0},"60":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":5,"docs":{"62":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":6,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0},"62":{"tf":1.0},"79":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"17":{"tf":2.449489742783178},"19":{"tf":2.23606797749979},"58":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.0},"83":{"tf":1.0}}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}},"g":{"df":1,"docs":{"79":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"h":{"a":{"_":{"df":0,"docs":{},"t":{"df":3,"docs":{"67":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"30":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"47":{"tf":1.0},"60":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":14,"docs":{"16":{"tf":1.4142135623730951},"20":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.4142135623730951},"46":{"tf":1.0},"48":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"29":{"tf":1.0},"81":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"60":{"tf":1.0},"64":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"5":{"tf":1.4142135623730951},"58":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":3,"docs":{"4":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.7320508075688772}},"e":{"'":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}},"i":{"c":{"df":1,"docs":{"52":{"tf":1.0}}},"df":3,"docs":{"53":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"47":{"tf":1.0}}}}}}}},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"3":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"4":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"14":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"(":{"\"":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}},"&":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"j":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":5,"docs":{"14":{"tf":1.4142135623730951},"52":{"tf":1.0},"58":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"64":{"tf":1.0}},"s":{"(":{"[":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"v":{"7":{"a":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"y":{"df":2,"docs":{"77":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"73":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"73":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"k":{"df":2,"docs":{"12":{"tf":1.0},"80":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"12":{"tf":1.0},"53":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"25":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"73":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.4142135623730951},"65":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"30":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"14":{"tf":1.0},"25":{"tf":1.0},"50":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"d":{"(":{"4":{"0":{"0":{"0":{"0":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"6":{"4":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"37":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"37":{"tf":1.0}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":6,"docs":{"29":{"tf":1.0},"4":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"17":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"b":{":":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"1":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}},"e":{"df":1,"docs":{"79":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"3":{"tf":1.0},"60":{"tf":1.0}}},"i":{"df":3,"docs":{"30":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0}}}}},"df":6,"docs":{"37":{"tf":1.0},"48":{"tf":2.23606797749979},"67":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":2.0},"76":{"tf":1.4142135623730951}},"e":{"df":2,"docs":{"49":{"tf":1.0},"64":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"49":{"tf":1.0},"76":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"25":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"a":{"_":{"df":0,"docs":{},"t":{"df":3,"docs":{"67":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{".":{"a":{"df":1,"docs":{"76":{"tf":1.0}}},"b":{"df":1,"docs":{"76":{"tf":1.0}}},"c":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"a":{"(":{"1":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"(":{"1":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"(":{"1":{"2":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"3":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"76":{"tf":2.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}},"d":{"df":31,"docs":{"0":{"tf":1.0},"10":{"tf":3.3166247903554},"11":{"tf":1.7320508075688772},"12":{"tf":2.23606797749979},"13":{"tf":1.7320508075688772},"14":{"tf":3.0},"15":{"tf":1.7320508075688772},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"21":{"tf":1.0},"29":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"42":{"tf":1.0},"49":{"tf":1.0},"53":{"tf":2.0},"54":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":2.0},"64":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.7320508075688772},"9":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":2,"docs":{"71":{"tf":1.0},"73":{"tf":1.0}}},":":{":":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"53":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"16":{"tf":1.0}}},":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"18":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"22":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"_":{"_":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"_":{"1":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}},"2":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":53,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":2.0},"12":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":2.8284271247461903},"16":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"43":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":2.0},"6":{"tf":1.0},"60":{"tf":2.449489742783178},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"7":{"tf":1.0},"71":{"tf":1.7320508075688772},"73":{"tf":1.0},"74":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772},"8":{"tf":2.6457513110645907},"80":{"tf":2.0},"81":{"tf":1.4142135623730951},"82":{"tf":1.7320508075688772},"83":{"tf":1.7320508075688772},"84":{"tf":1.7320508075688772},"85":{"tf":1.7320508075688772},"9":{"tf":1.0}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"71":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772}}}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":4,"docs":{"11":{"tf":1.0},"15":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"42":{"tf":1.0}}}},":":{":":{"_":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"<":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"72":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"3":{"tf":1.0}}},"t":{"df":1,"docs":{"37":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"74":{"tf":1.0},"75":{"tf":3.1622776601683795},"76":{"tf":2.6457513110645907}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":3,"docs":{"25":{"tf":1.4142135623730951},"60":{"tf":1.0},"83":{"tf":1.0}}},"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"12":{"tf":2.0},"21":{"tf":1.0},"62":{"tf":2.23606797749979},"63":{"tf":1.0},"67":{"tf":1.0},"75":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"21":{"tf":2.6457513110645907},"23":{"tf":2.23606797749979},"29":{"tf":1.0},"62":{"tf":1.7320508075688772},"64":{"tf":1.0},"75":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":2.0},"81":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"60":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"3":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"59":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}}},"df":7,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"3":{"tf":2.23606797749979},"4":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":2.23606797749979}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"76":{"tf":1.0}}},".":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":4,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.0},"3":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"71":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951}}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":5,"docs":{"12":{"tf":1.0},"25":{"tf":1.4142135623730951},"60":{"tf":1.0},"78":{"tf":1.0},"83":{"tf":1.0}}}}},"z":{"2":{"_":{"b":{"df":0,"docs":{},"z":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}},"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":1.0}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":1,"docs":{"12":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":2.23606797749979}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":2.23606797749979}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":1,"docs":{"12":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"2":{"'":{"df":1,"docs":{"11":{"tf":1.0}}},"df":6,"docs":{"10":{"tf":2.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"'":{"df":1,"docs":{"64":{"tf":1.0}}},"+":{"+":{"'":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"/":{"c":{"df":4,"docs":{"16":{"tf":1.0},"37":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}},"9":{"9":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},":":{"0":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":9,"docs":{"0":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":2.23606797749979},"64":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.4142135623730951},"85":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":7,"docs":{"30":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"37":{"tf":1.0},"60":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"14":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"df":5,"docs":{"10":{"tf":2.6457513110645907},"11":{"tf":2.0},"12":{"tf":1.4142135623730951},"14":{"tf":2.0},"15":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"e":{"df":11,"docs":{"10":{"tf":1.0},"25":{"tf":1.4142135623730951},"30":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"s":{"df":1,"docs":{"60":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":25,"docs":{"0":{"tf":2.449489742783178},"14":{"tf":2.23606797749979},"15":{"tf":1.7320508075688772},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"37":{"tf":1.0},"4":{"tf":1.4142135623730951},"48":{"tf":1.0},"58":{"tf":2.8284271247461903},"60":{"tf":2.23606797749979},"61":{"tf":2.6457513110645907},"62":{"tf":3.0},"63":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":2.0},"77":{"tf":1.4142135623730951},"79":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"38":{"tf":1.0},"43":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"0":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"2":{"tf":1.0},"43":{"tf":1.4142135623730951},"79":{"tf":1.0},"8":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":2.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":7,"docs":{"14":{"tf":1.4142135623730951},"2":{"tf":1.4142135623730951},"3":{"tf":3.1622776601683795},"58":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"82":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":12,"docs":{"16":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"62":{"tf":2.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":2.0}}}}},"df":0,"docs":{},"i":{"df":2,"docs":{"15":{"tf":1.0},"52":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":3,"docs":{"29":{"tf":1.0},"30":{"tf":2.0},"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":14,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"16":{"tf":1.0},"29":{"tf":1.0},"4":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"57":{"tf":1.0},"61":{"tf":1.7320508075688772},"7":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.7320508075688772},"37":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"78":{"tf":1.0},"83":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":13,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"70":{"tf":1.0},"85":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":2.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":12,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"14":{"tf":2.0},"3":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"79":{"tf":1.4142135623730951}}},"x":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":2.0}},"e":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"12":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"16":{"tf":1.0},"50":{"tf":1.7320508075688772},"56":{"tf":1.0},"57":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"17":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"48":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"84":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":2.23606797749979},"75":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"14":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"6":{"tf":1.0},"75":{"tf":1.4142135623730951},"79":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"79":{"tf":1.0}}},"t":{"df":2,"docs":{"11":{"tf":1.0},"60":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"79":{"tf":1.0}}},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"0":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"i":{"df":7,"docs":{"29":{"tf":1.0},"30":{"tf":1.7320508075688772},"32":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"17":{"tf":1.0},"51":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"8":{"tf":1.0}}},"(":{"df":1,"docs":{"66":{"tf":1.0}}},"df":8,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":2.0},"14":{"tf":1.4142135623730951},"4":{"tf":1.0},"54":{"tf":1.0},"62":{"tf":1.7320508075688772},"79":{"tf":1.4142135623730951},"8":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":2,"docs":{"13":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"df":1,"docs":{"12":{"tf":2.0}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.0},"4":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"76":{"tf":1.7320508075688772},"82":{"tf":1.0},"9":{"tf":1.0}},"e":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"s":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"4":{"tf":1.0},"60":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":7,"docs":{"16":{"tf":1.0},"21":{"tf":1.0},"38":{"tf":1.0},"42":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.4142135623730951}}}}}}}},"d":{":":{"\\":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"\\":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"\\":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"t":{"a":{"[":{"2":{"5":{"2":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"12":{"tf":1.0},"42":{"tf":1.0},"78":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":3,"docs":{"67":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"80":{"tf":1.0},"84":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}}},"b":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":4,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"34":{"tf":1.7320508075688772},"36":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0}}}}}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":2.0}},"e":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":1,"docs":{"12":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":15,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"38":{"tf":2.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"55":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"21":{"tf":1.0},"75":{"tf":1.0},"81":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":12,"docs":{"17":{"tf":2.0},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"34":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"62":{"tf":1.0},"64":{"tf":1.0},"8":{"tf":2.6457513110645907},"83":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"12":{"tf":2.449489742783178}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":9,"docs":{"21":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"38":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}},"e":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"34":{"tf":1.0},"61":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"29":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"83":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"71":{"tf":1.0},"79":{"tf":1.0}}}}}}}},"v":{"df":1,"docs":{"3":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"50":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"12":{"tf":1.4142135623730951},"3":{"tf":1.0},"61":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"10":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"3":{"tf":1.0},"50":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"s":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"67":{"tf":1.0},"76":{"tf":1.0}}}}}},"df":0,"docs":{}},"v":{"df":9,"docs":{"16":{"tf":1.4142135623730951},"24":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"3":{"tf":1.0}}}},"o":{"c":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"55":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"5":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}}}}}}}},"df":1,"docs":{"79":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"3":{"tf":1.0},"58":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"60":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"81":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}}},"x":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":2.6457513110645907}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"11":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"79":{"tf":2.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":1,"docs":{"62":{"tf":1.0}}}},"a":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"85":{"tf":1.7320508075688772}}}},"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"4":{"tf":1.0},"62":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":2.23606797749979},"82":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":3,"docs":{"67":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"60":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"14":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"55":{"tf":1.0},"71":{"tf":1.4142135623730951},"75":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"79":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"df":3,"docs":{"58":{"tf":1.0},"64":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"47":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"78":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.0},"9":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"16":{"tf":1.0},"37":{"tf":1.7320508075688772},"72":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.0},"54":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"25":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"[":{"df":0,"docs":{},"e":{"0":{"3":{"0":{"8":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"6":{"3":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":5,"docs":{"43":{"tf":1.0},"60":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}}},"t":{"c":{"df":2,"docs":{"4":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"72":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":18,"docs":{"0":{"tf":1.0},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.0},"76":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.0}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.7320508075688772},"79":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":1.0},"29":{"tf":1.0},"60":{"tf":1.0},"75":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"58":{"tf":1.0},"73":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.7320508075688772}}}}},"r":{"a":{"df":3,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"60":{"tf":1.0}}}}}},"m":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}},"q":{"df":1,"docs":{"58":{"tf":1.0}}},"r":{"df":1,"docs":{"83":{"tf":1.0}}},"t":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}}},"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":3,"docs":{"67":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"17":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"63":{"tf":1.0},"79":{"tf":1.4142135623730951}},"e":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{",":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}},"w":{"df":3,"docs":{"11":{"tf":1.0},"16":{"tf":1.0},"64":{"tf":1.4142135623730951}}}},"f":{"df":0,"docs":{},"i":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"4":{"tf":1.0},"58":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"a":{"df":1,"docs":{"84":{"tf":1.0}}},"b":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":11,"docs":{"21":{"tf":1.0},"47":{"tf":2.0},"59":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":2.449489742783178},"80":{"tf":1.0},"84":{"tf":2.449489742783178}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":18,"docs":{"10":{"tf":2.6457513110645907},"12":{"tf":1.4142135623730951},"14":{"tf":4.0},"15":{"tf":2.0},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"4":{"tf":1.0},"50":{"tf":2.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"61":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"79":{"tf":1.0}}}},"d":{"df":3,"docs":{"60":{"tf":1.0},"64":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"14":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"df":1,"docs":{"60":{"tf":1.0}}},"x":{"df":3,"docs":{"77":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.0}},"e":{"d":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":5,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"50":{"tf":1.0},"54":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"77":{"tf":1.4142135623730951},"79":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":3,"docs":{"10":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0}}}},"n":{"df":13,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"61":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":2.23606797749979},"82":{"tf":1.0},"84":{"tf":1.0}},"o":{"df":1,"docs":{"82":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":13,"docs":{"11":{"tf":1.0},"3":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.4142135623730951},"67":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0}}}}}},"o":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"(":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"d":{"df":2,"docs":{"62":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}}},".":{"0":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}},"df":5,"docs":{"24":{"tf":1.0},"28":{"tf":1.0},"62":{"tf":2.449489742783178},"63":{"tf":1.0},"84":{"tf":1.0}}},"r":{"c":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":4,"docs":{"16":{"tf":1.0},"37":{"tf":1.0},"49":{"tf":1.4142135623730951},"54":{"tf":1.0}},"t":{"df":2,"docs":{"54":{"tf":1.0},"57":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"=":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"17":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}},"df":2,"docs":{"62":{"tf":1.0},"73":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"62":{"tf":1.7320508075688772},"64":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"65":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"13":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.0},"79":{"tf":1.0}},"i":{"df":1,"docs":{"79":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":18,"docs":{"0":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"43":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":2.23606797749979},"62":{"tf":1.7320508075688772},"64":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":2.8284271247461903},"83":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.0},"60":{"tf":1.0},"82":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"c":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":33,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":2.8284271247461903},"11":{"tf":1.7320508075688772},"14":{"tf":2.449489742783178},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.7320508075688772},"21":{"tf":1.0},"29":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"42":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":2.0},"61":{"tf":1.0},"62":{"tf":2.8284271247461903},"63":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.4142135623730951},"7":{"tf":1.0},"71":{"tf":1.7320508075688772},"74":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"80":{"tf":2.0},"81":{"tf":1.4142135623730951},"82":{"tf":2.0},"83":{"tf":1.7320508075688772},"84":{"tf":1.7320508075688772},"85":{"tf":1.7320508075688772}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"58":{"tf":1.0},"60":{"tf":1.0}},"n":{"df":4,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"56":{"tf":1.0},"64":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"4":{"tf":1.0}}}},"o":{"df":2,"docs":{"64":{"tf":1.0},"79":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"12":{"tf":2.23606797749979},"9":{"tf":1.0}}}}},"p":{"df":1,"docs":{"12":{"tf":2.0}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"64":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"83":{"tf":1.0}},"l":{"df":2,"docs":{"58":{"tf":1.4142135623730951},"82":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":18,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"14":{"tf":2.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"29":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.4142135623730951},"64":{"tf":1.7320508075688772},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"9":{"tf":2.23606797749979}},"s":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"c":{"df":1,"docs":{"14":{"tf":1.7320508075688772}}},"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}},"o":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}},"df":1,"docs":{"14":{"tf":2.0}}}},"p":{"df":4,"docs":{"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"25":{"tf":1.0},"62":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"73":{"tf":1.0},"79":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":10,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.4142135623730951},"7":{"tf":1.0},"79":{"tf":1.0},"9":{"tf":1.0}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{},"e":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}}},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"58":{"tf":1.0}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"+":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"i":{"'":{"df":0,"docs":{},"m":{"df":1,"docs":{"12":{"tf":1.0}}}},".":{"df":1,"docs":{"75":{"tf":1.0}}},"d":{"df":3,"docs":{"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"77":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"79":{"tf":1.0}}},"f":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"61":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"42":{"tf":1.0},"48":{"tf":1.0},"61":{"tf":1.0},"79":{"tf":1.4142135623730951},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"38":{"tf":1.0},"42":{"tf":1.0},"61":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":10,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"14":{"tf":1.0},"21":{"tf":1.0},"42":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"9":{"tf":1.7320508075688772}},"e":{"!":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"!":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"42":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"!":{"(":{"\"":{".":{".":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"10":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"79":{"tf":1.0},"82":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":5,"docs":{"12":{"tf":2.23606797749979},"62":{"tf":1.0},"72":{"tf":2.0},"78":{"tf":1.0},"84":{"tf":2.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":2.6457513110645907},"82":{"tf":2.8284271247461903},"83":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.7320508075688772}}}}}},"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":6,"docs":{"10":{"tf":1.0},"12":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"61":{"tf":1.0},"82":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}},"i":{"d":{"df":6,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"15":{"tf":1.7320508075688772},"3":{"tf":3.1622776601683795},"54":{"tf":1.0}}},"n":{"c":{"df":2,"docs":{"61":{"tf":2.0},"62":{"tf":1.4142135623730951}},"e":{".":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":2,"docs":{"62":{"tf":1.0},"64":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":7,"docs":{"21":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"43":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"3":{"2":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"4":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"0":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"41":{"tf":1.0},"48":{"tf":1.0},"76":{"tf":1.7320508075688772},"81":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"67":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"a":{"c":{"df":4,"docs":{"13":{"tf":1.0},"4":{"tf":1.0},"60":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"61":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":6,"docs":{"15":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.4142135623730951},"85":{"tf":1.0}}}}}},"o":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"60":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":4,"docs":{"60":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"81":{"tf":1.0}}}}},"t":{"'":{"df":3,"docs":{"43":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951}}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"19":{"tf":1.4142135623730951},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"62":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"75":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":9,"docs":{"14":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"60":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"60":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"81":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":3,"docs":{"11":{"tf":1.0},"60":{"tf":1.0},"79":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"n":{"df":3,"docs":{"77":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"79":{"tf":2.23606797749979}},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"12":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951}}}}}},"t":{"'":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951}}},"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"b":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{">":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"=":{"b":{"df":0,"docs":{},"z":{"2":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"z":{"2":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":4,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"85":{"tf":1.0}}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"x":{"df":1,"docs":{"3":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}},"o":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"a":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"a":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":22,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"14":{"tf":3.1622776601683795},"16":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"58":{"tf":1.0},"6":{"tf":1.0},"69":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951},"85":{"tf":1.0}}},"y":{"'":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":13,"docs":{"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"19":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.0},"70":{"tf":1.0},"79":{"tf":1.4142135623730951},"82":{"tf":1.0},"85":{"tf":1.0}}},"k":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":5,"docs":{"10":{"tf":1.7320508075688772},"12":{"tf":1.0},"14":{"tf":2.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0}}},"u":{"df":0,"docs":{},"x":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"3":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"83":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":1,"docs":{"3":{"tf":2.449489742783178}}}}},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"61":{"tf":1.0},"62":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"64":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":4,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"77":{"tf":1.0},"79":{"tf":1.0}}}},"t":{"df":3,"docs":{"17":{"tf":1.0},"43":{"tf":1.0},"62":{"tf":1.4142135623730951}}}}},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"3":{"tf":1.0}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"41":{"tf":1.0},"42":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"14":{"tf":1.4142135623730951},"53":{"tf":1.0}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"e":{"df":4,"docs":{"21":{"tf":1.0},"47":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":4,"docs":{"37":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"58":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"12":{"tf":1.0}}},"r":{"df":0,"docs":{},"k":{"df":3,"docs":{"58":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"11":{"tf":1.0},"12":{"tf":2.449489742783178},"17":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":4,"docs":{"61":{"tf":1.0},"67":{"tf":1.0},"79":{"tf":2.23606797749979},"83":{"tf":1.0}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"77":{"tf":1.4142135623730951},"79":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"29":{"tf":1.0},"33":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":15,"docs":{"16":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":2.449489742783178},"62":{"tf":1.7320508075688772},"64":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"w":{"6":{"4":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"w":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}},"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":1,"docs":{"43":{"tf":1.0}}}}},"o":{"d":{"df":3,"docs":{"12":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}},"e":{"df":1,"docs":{"58":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":6,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"29":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"75":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"33":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"v":{"c":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"12":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"58":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"29":{"tf":1.0},"37":{"tf":1.0},"9":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"t":{"df":8,"docs":{"0":{"tf":1.0},"12":{"tf":3.7416573867739413},"61":{"tf":1.7320508075688772},"62":{"tf":1.0},"64":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"y":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"61":{"tf":2.0}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"y":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"_":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":1,"docs":{"61":{"tf":3.1622776601683795}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"<":{"[":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{":":{":":{"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":2.449489742783178}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}},"df":3,"docs":{"77":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":2.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":7,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"50":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"3":{"tf":1.0},"76":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":16,"docs":{"14":{"tf":1.0},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"3":{"tf":2.0},"38":{"tf":1.0},"4":{"tf":1.7320508075688772},"41":{"tf":1.0},"43":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":2.23606797749979},"64":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"83":{"tf":1.0},"85":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"w":{"(":{"df":1,"docs":{"48":{"tf":1.0}}},"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"{":{"1":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":5,"docs":{"14":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"73":{"tf":1.4142135623730951},"76":{"tf":1.0}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"58":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":7,"docs":{"51":{"tf":1.7320508075688772},"52":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"67":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"79":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}},"y":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.0},"60":{"tf":1.0}},"e":{"df":2,"docs":{"20":{"tf":1.0},"85":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":8,"docs":{"10":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0}}},"h":{"df":1,"docs":{"13":{"tf":1.0}}}},"w":{"df":4,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.7320508075688772}}}}}}}},"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"48":{"tf":1.0}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"c":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.0},"14":{"tf":1.7320508075688772},"62":{"tf":3.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"82":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"c":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":2,"docs":{"14":{"tf":1.0},"15":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":2,"docs":{"11":{"tf":4.0},"12":{"tf":4.123105625617661}}},"n":{"df":9,"docs":{"21":{"tf":1.0},"29":{"tf":1.4142135623730951},"54":{"tf":1.0},"60":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"48":{"tf":2.0}}}}}}},"df":0,"docs":{}}}}}}},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":7,"docs":{"21":{"tf":1.0},"25":{"tf":1.4142135623730951},"27":{"tf":1.0},"58":{"tf":1.4142135623730951},"60":{"tf":1.0},"75":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}},"e":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"65":{"tf":1.0}}},"r":{"df":1,"docs":{"58":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":13,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.0},"72":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"62":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":5,"docs":{"4":{"tf":1.0},"60":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":5,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"76":{"tf":1.7320508075688772},"78":{"tf":1.0},"82":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":4,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"37":{"tf":1.0},"53":{"tf":2.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"4":{"tf":1.0},"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"df":1,"docs":{"77":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"d":{"df":2,"docs":{"80":{"tf":1.0},"84":{"tf":1.7320508075688772}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":3,"docs":{"1":{"tf":1.0},"3":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\"":{"b":{"df":0,"docs":{},"z":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":2.23606797749979}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":2.449489742783178}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"60":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.4142135623730951},"75":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.0}},"e":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":2,"docs":{"59":{"tf":1.0},"79":{"tf":1.4142135623730951}},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"17":{"tf":1.0},"60":{"tf":1.0}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":13,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":2.449489742783178},"15":{"tf":1.0},"16":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.4142135623730951},"67":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{")":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"\"":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":7,"docs":{"14":{"tf":2.449489742783178},"15":{"tf":2.0},"19":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"53":{"tf":1.0},"62":{"tf":1.0}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"[":{"0":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"77":{"tf":1.0},"78":{"tf":1.7320508075688772},"79":{"tf":2.8284271247461903}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"63":{"tf":1.0}},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}},"r":{"df":1,"docs":{"84":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"g":{"_":{"a":{"d":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}},"n":{"df":1,"docs":{"17":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.0},"3":{"tf":1.0},"47":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"47":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"14":{"tf":1.4142135623730951},"60":{"tf":1.0},"72":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"17":{"tf":1.0},"58":{"tf":1.0}}}}},"df":2,"docs":{"3":{"tf":1.0},"75":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"63":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"50":{"tf":1.0},"84":{"tf":1.0}}}},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"58":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"54":{"tf":2.0},"57":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"(":{"b":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"15":{"tf":1.0},"61":{"tf":1.0},"76":{"tf":2.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"a":{"df":1,"docs":{"76":{"tf":1.0}}},"b":{"df":1,"docs":{"76":{"tf":1.0}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"72":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951}},"e":{"=":{"\"":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"\"":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"58":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":3,"docs":{"0":{"tf":1.0},"61":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":9,"docs":{"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.0},"61":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.4142135623730951},"82":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"37":{"tf":1.0}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"u":{"b":{"df":5,"docs":{"0":{"tf":2.0},"48":{"tf":1.7320508075688772},"61":{"tf":2.449489742783178},"78":{"tf":2.0},"79":{"tf":3.605551275463989}},"l":{"df":0,"docs":{},"i":{"c":{"df":5,"docs":{"29":{"tf":1.0},"47":{"tf":1.0},"61":{"tf":1.0},"81":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"58":{"tf":1.0},"83":{"tf":1.0}}}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"12":{"tf":1.0},"15":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"\"":{")":{".":{"a":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}},"w":{"df":4,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"33":{"tf":1.0},"79":{"tf":1.7320508075688772}}}},"df":1,"docs":{"12":{"tf":7.615773105863909}},"e":{"a":{"d":{"df":3,"docs":{"12":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"79":{"tf":1.0}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"47":{"tf":1.0},"62":{"tf":1.0},"82":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"4":{"tf":1.0},"58":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"16":{"tf":1.0},"5":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"10":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":5,"docs":{"21":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.0}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"51":{"tf":1.4142135623730951},"56":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"68":{"tf":1.0}}}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":2,"docs":{"29":{"tf":2.23606797749979},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"=":{"\"":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"\"":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"(":{"c":{"df":5,"docs":{"0":{"tf":1.0},"48":{"tf":1.0},"61":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":3,"docs":{"62":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":5,"docs":{"1":{"tf":1.4142135623730951},"14":{"tf":1.0},"2":{"tf":1.0},"62":{"tf":1.0},"76":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":7,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"12":{"tf":3.7416573867739413},"14":{"tf":1.4142135623730951},"64":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":10,"docs":{"12":{"tf":2.449489742783178},"14":{"tf":1.0},"43":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.7320508075688772},"64":{"tf":1.7320508075688772},"65":{"tf":1.0},"79":{"tf":2.0},"81":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"78":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"+":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"3":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"17":{"tf":1.7320508075688772},"60":{"tf":1.0}}}},"n":{"df":9,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":2.23606797749979},"12":{"tf":2.0},"14":{"tf":1.4142135623730951},"4":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":3,"docs":{"11":{"tf":1.0},"60":{"tf":1.0},"71":{"tf":1.0}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"24":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"c":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951}}},"df":27,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"17":{"tf":1.0},"25":{"tf":1.4142135623730951},"29":{"tf":1.0},"4":{"tf":1.4142135623730951},"43":{"tf":1.0},"48":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"67":{"tf":2.8284271247461903},"70":{"tf":1.0},"71":{"tf":2.23606797749979},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":2.6457513110645907},"82":{"tf":1.0}},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"50":{"tf":1.4142135623730951},"56":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":5,"docs":{"49":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"56":{"tf":2.0}}}}},"u":{"df":0,"docs":{},"p":{"df":3,"docs":{"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772}}}}}}}},"s":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"33":{"tf":1.0},"37":{"tf":1.0},"79":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":6,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.7320508075688772}}}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"df":2,"docs":{"3":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"=":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"14":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"c":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"49":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"60":{"tf":1.7320508075688772},"67":{"tf":1.0},"73":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"f":{"df":6,"docs":{"42":{"tf":1.4142135623730951},"48":{"tf":1.0},"61":{"tf":1.4142135623730951},"64":{"tf":1.0},"79":{"tf":1.7320508075688772},"84":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"61":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":3,"docs":{"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.4142135623730951}}},"t":{"_":{"<":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"3":{"tf":1.4142135623730951},"47":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"76":{"tf":3.3166247903554},"79":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"14":{"tf":1.0},"62":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":2,"docs":{"25":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"10":{"tf":1.7320508075688772},"14":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"34":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}},"i":{"df":2,"docs":{"25":{"tf":1.0},"78":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"82":{"tf":1.0}}}},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}}},"df":8,"docs":{"11":{"tf":1.0},"12":{"tf":2.449489742783178},"25":{"tf":1.0},"60":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":3.7416573867739413},"83":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"79":{"tf":2.23606797749979}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"64":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"61":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"10":{"tf":1.0},"47":{"tf":1.0},"62":{"tf":1.0},"79":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":4,"docs":{"25":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"83":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":5,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":1.0},"3":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":2.0},"53":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"f":{"df":5,"docs":{"4":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.4142135623730951},"72":{"tf":1.0},"83":{"tf":1.0}},"i":{"df":5,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"41":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"4":{"4":{":":{"1":{"5":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"84":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}},"l":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"77":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"63":{"tf":1.4142135623730951},"79":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"c":{"df":6,"docs":{"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"75":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":2.0}}},"df":0,"docs":{}},"u":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"53":{"tf":1.0}}}}},"d":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{":":{":":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{":":{":":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{">":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"84":{"tf":1.0}},"e":{"d":{":":{":":{"<":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{":":{":":{"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"48":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\"":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"=":{"c":{"+":{"+":{"1":{"4":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"58":{"tf":1.4142135623730951},"83":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"3":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"21":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0}}}}},"l":{"df":2,"docs":{"80":{"tf":1.0},"83":{"tf":2.0}}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"df":1,"docs":{"12":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{".":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"12":{"tf":3.4641016151377544}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"8":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":3,"docs":{"12":{"tf":2.449489742783178},"14":{"tf":1.0},"48":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":21,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"16":{"tf":1.0},"33":{"tf":1.4142135623730951},"41":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.7320508075688772},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"67":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"9":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"29":{"tf":1.0},"47":{"tf":1.0},"77":{"tf":1.7320508075688772},"78":{"tf":2.449489742783178},"79":{"tf":2.449489742783178}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"76":{"tf":2.449489742783178}},"s":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"1":{"(":{"0":{",":{"0":{",":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"11":{"tf":1.0},"16":{"tf":1.0}}},"o":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"u":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"61":{"tf":1.0}}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":2.0}}}}}},"df":0,"docs":{},"h":{"df":4,"docs":{"17":{"tf":1.0},"25":{"tf":1.0},"60":{"tf":1.4142135623730951},"67":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"15":{"tf":1.0},"81":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":12,"docs":{"4":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.4142135623730951}}}},"s":{"df":1,"docs":{"14":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"y":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"66":{"tf":1.0}},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"82":{"tf":1.0}}}}},"df":1,"docs":{"12":{"tf":2.449489742783178}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":2,"docs":{"55":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":6,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"21":{"tf":1.0},"53":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0}}}}}}}},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"16":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"77":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":3,"docs":{"15":{"tf":1.0},"53":{"tf":1.0},"79":{"tf":2.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0}}},"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"_":{"b":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"2":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"2":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"=":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"6":{"4":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"7":{"a":{"df":1,"docs":{"85":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":9,"docs":{"4":{"tf":1.4142135623730951},"64":{"tf":1.0},"67":{"tf":2.23606797749979},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":2.0}}}}}}},"df":1,"docs":{"29":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"77":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"10":{"tf":2.0},"14":{"tf":2.0},"57":{"tf":1.0},"67":{"tf":1.0},"79":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":2.23606797749979},"80":{"tf":1.0},"83":{"tf":1.0}},"e":{"<":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"n":{"d":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":4.58257569495584},"12":{"tf":5.477225575051661}},"s":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"13":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":2,"docs":{"10":{"tf":1.0},"78":{"tf":1.7320508075688772}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"83":{"tf":1.4142135623730951}}},"k":{"df":1,"docs":{"11":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"3":{"tf":1.0},"58":{"tf":1.0},"9":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"12":{"tf":1.0},"60":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}}}}},"i":{"df":1,"docs":{"83":{"tf":1.0}},"e":{"df":1,"docs":{"12":{"tf":1.0}}},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"64":{"tf":1.0}}}},"_":{"df":0,"docs":{},"t":{"df":3,"docs":{"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"df":7,"docs":{"10":{"tf":1.4142135623730951},"12":{"tf":1.0},"25":{"tf":1.0},"4":{"tf":1.0},"64":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":3,"docs":{"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}},"l":{";":{"d":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}}},"df":3,"docs":{"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"84":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":1,"docs":{"3":{"tf":1.0}}}},"p":{"df":2,"docs":{"12":{"tf":1.0},"13":{"tf":1.0}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}},"t":{"df":9,"docs":{"21":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"60":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"21":{"tf":1.4142135623730951},"83":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"16":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"60":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"25":{"tf":1.4142135623730951},"58":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":1,"docs":{"64":{"tf":1.0}},"p":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":3,"docs":{"56":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"14":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":2.0}}}}}}},"w":{"df":0,"docs":{},"o":{"df":6,"docs":{"14":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":4,"docs":{"0":{"tf":1.0},"16":{"tf":1.0},"67":{"tf":1.7320508075688772},"76":{"tf":1.0}}}}},"df":28,"docs":{"0":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":2.6457513110645907},"23":{"tf":1.4142135623730951},"25":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"29":{"tf":2.0},"30":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"43":{"tf":2.0},"45":{"tf":1.0},"58":{"tf":2.23606797749979},"60":{"tf":2.449489742783178},"62":{"tf":1.0},"67":{"tf":1.7320508075688772},"71":{"tf":1.7320508075688772},"72":{"tf":1.0},"73":{"tf":2.6457513110645907},"74":{"tf":1.0},"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":3.1622776601683795},"83":{"tf":1.0},"9":{"tf":1.0}}},"i":{"c":{"df":3,"docs":{"77":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"8":{"df":1,"docs":{"61":{"tf":1.0}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"62":{"tf":1.0},"66":{"tf":1.0}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"1":{"6":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"2":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{".":{"0":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"62":{"tf":1.0}}}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"72":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"67":{"tf":2.23606797749979},"71":{"tf":2.449489742783178},"72":{"tf":2.0},"73":{"tf":2.449489742783178}}}},"t":{"df":2,"docs":{"75":{"tf":1.4142135623730951},"76":{"tf":1.0}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"12":{"tf":2.449489742783178}}}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":9,"docs":{"12":{"tf":1.0},"61":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":2.23606797749979},"78":{"tf":1.7320508075688772},"79":{"tf":1.4142135623730951},"84":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"41":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951}}}},"z":{"df":1,"docs":{"79":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"56":{"tf":1.0},"67":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"p":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"4":{"tf":1.0}}}},"df":51,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":3.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":2.0},"3":{"tf":1.7320508075688772},"30":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"45":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772},"54":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"57":{"tf":1.4142135623730951},"58":{"tf":2.449489742783178},"6":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"67":{"tf":1.7320508075688772},"7":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":2.0},"73":{"tf":1.4142135623730951},"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.4142135623730951},"77":{"tf":2.0},"78":{"tf":1.0},"79":{"tf":2.0},"8":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.7320508075688772},"85":{"tf":1.4142135623730951},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":2.6457513110645907}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"12":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"53":{"tf":1.0}}}},"{":{"1":{"df":0,"docs":{},"}":{"_":{"df":0,"docs":{},"z":{"df":0,"docs":{},"n":{"7":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"6":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"c":{"1":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"v":{"0":{".":{"1":{".":{"0":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"14":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":6,"docs":{"12":{"tf":2.449489742783178},"3":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"61":{"tf":2.0},"79":{"tf":1.4142135623730951}}}},"r":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"17":{"tf":1.4142135623730951},"3":{"tf":1.0},"64":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"79":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"47":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"!":{"[":{"0":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":2.0}}}}},"df":0,"docs":{},"i":{"df":3,"docs":{"64":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"61":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"67":{"tf":1.4142135623730951},"73":{"tf":1.0},"8":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}}}}},"i":{"a":{"df":4,"docs":{"12":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"0":{"tf":1.0},"61":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"6":{"4":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":10,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.0},"50":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.4142135623730951},"62":{"tf":1.0},"75":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"11":{"tf":1.0},"43":{"tf":1.0},"8":{"tf":1.0}}}},"y":{"df":6,"docs":{"16":{"tf":1.0},"29":{"tf":1.0},"4":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"'":{"d":{"df":2,"docs":{"12":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"58":{"tf":1.4142135623730951},"62":{"tf":1.0},"83":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"78":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"75":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"12":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"64":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"61":{"tf":1.0}},"i":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"12":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0}}},"l":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"13":{"tf":1.0},"21":{"tf":1.0},"82":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":2.0}}}},"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"\"":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":6,"docs":{"10":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"53":{"tf":1.0},"67":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}},"x":{".":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"a":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"8":{"6":{"_":{"6":{"4":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"72":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951}}},"y":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":2,"docs":{"3":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"3":{"tf":1.0},"64":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.7320508075688772}}}},"r":{"df":4,"docs":{"64":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"58":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0}}}}}}}}}},"z":{".":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"a":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":4,"docs":{"72":{"tf":1.7320508075688772},"73":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}}}}}}}},"breadcrumbs":{"root":{"0":{".":{"0":{"df":1,"docs":{"11":{"tf":1.0}}},"5":{"4":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"6":{"5":{".":{"1":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"9":{".":{"9":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":7,"docs":{"11":{"tf":2.8284271247461903},"12":{"tf":4.0},"37":{"tf":1.0},"42":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"79":{"tf":2.449489742783178}},"x":{"1":{"0":{"2":{"0":{"3":{"0":{"4":{"0":{"df":0,"docs":{},"u":{"3":{"2":{"df":1,"docs":{"42":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"7":{"b":{"df":0,"docs":{},"f":{"c":{"a":{"1":{"7":{"df":1,"docs":{"12":{"tf":2.6457513110645907}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"1":{".":{"0":{"df":1,"docs":{"67":{"tf":1.0}}},"1":{"9":{"df":2,"docs":{"67":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"0":{"0":{"0":{"0":{"0":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"1":{"3":{"df":0,"docs":{},"f":{"c":{"2":{"a":{"df":0,"docs":{},"f":{"2":{"0":{"7":{"8":{"1":{"0":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.7320508075688772}}},"1":{".":{"5":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}},"2":{"1":{"3":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"4":{"df":1,"docs":{"12":{"tf":1.0}}},"6":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"7":{"df":1,"docs":{"72":{"tf":1.0}}},"df":1,"docs":{"12":{"tf":1.0}}},"3":{"df":1,"docs":{"12":{"tf":2.449489742783178}}},"4":{"8":{"df":1,"docs":{"12":{"tf":1.0}}},"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0}}},"5":{"0":{"8":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":2.0}}},"6":{".":{"7":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}},"7":{"df":1,"docs":{"12":{"tf":1.0}}},"8":{".":{"0":{"4":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"df":1,"docs":{"12":{"tf":1.0}}},"c":{"5":{"6":{"2":{"6":{"b":{"b":{"c":{"4":{"4":{"0":{"1":{"c":{"3":{"a":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"12":{"tf":3.0},"37":{"tf":1.0},"72":{"tf":2.23606797749979},"73":{"tf":3.0},"76":{"tf":2.0},"81":{"tf":1.0}}},"2":{"1":{".":{"1":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{"2":{"1":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{".":{"9":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"5":{".":{"7":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"2":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"42":{"tf":1.0}}}}}}},"6":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"7":{"0":{"2":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"4":{"3":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"4":{"9":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"5":{"7":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":4,"docs":{"12":{"tf":2.449489742783178},"37":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}}},"3":{"2":{"8":{"3":{"6":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}},"6":{"0":{"0":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"2":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"12":{"tf":1.7320508075688772},"37":{"tf":1.0},"76":{"tf":1.0}}},"4":{"2":{"df":1,"docs":{"14":{"tf":1.0}}},"4":{"df":1,"docs":{"73":{"tf":1.0}}},"5":{"df":1,"docs":{"73":{"tf":1.0}}},"6":{"9":{"df":1,"docs":{"12":{"tf":1.0}}},"df":1,"docs":{"73":{"tf":1.0}}},"7":{"df":1,"docs":{"73":{"tf":1.0}}},"df":1,"docs":{"12":{"tf":2.6457513110645907}}},"5":{".":{"0":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}},"3":{"8":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"5":{"4":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"7":{"0":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":2,"docs":{"12":{"tf":1.0},"37":{"tf":1.0}}},"6":{"1":{"+":{"2":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{".":{"8":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}},"5":{"5":{"3":{"5":{"df":2,"docs":{"72":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"7":{"9":{"df":1,"docs":{"12":{"tf":1.0}}},"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"8":{"1":{"9":{"2":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"12":{"tf":1.4142135623730951},"53":{"tf":1.0}}},"9":{"0":{"0":{"0":{"0":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}},"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"_":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"a":{"d":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"n":{"df":1,"docs":{"84":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{".":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"<":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{":":{":":{"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"78":{"tf":1.7320508075688772},"79":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"a":{"d":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"1":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":1,"docs":{"12":{"tf":6.164414002968976}}},"a":{":":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"1":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"6":{"4":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.7320508075688772}},"l":{"df":1,"docs":{"21":{"tf":1.0}}}},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"82":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":1.0},"82":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":5,"docs":{"59":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":2.0},"78":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"47":{"tf":1.0}}}}}}},"d":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"d":{"df":8,"docs":{"15":{"tf":1.0},"3":{"tf":1.0},"43":{"tf":1.0},"62":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":2.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"57":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"61":{"tf":2.0},"79":{"tf":1.0}}}}}}},"df":5,"docs":{"16":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":1.4142135623730951}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"16":{"tf":1.0},"49":{"tf":1.0}}}}}},"o":{"df":2,"docs":{"12":{"tf":1.0},"60":{"tf":1.0}}},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"c":{"7":{"7":{"4":{"7":{"d":{"7":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"f":{"d":{"7":{"2":{"0":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"64":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"f":{"a":{"df":3,"docs":{"67":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"i":{"a":{"df":1,"docs":{"62":{"tf":1.4142135623730951}},"s":{"df":2,"docs":{"62":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":5,"docs":{"11":{"tf":1.0},"25":{"tf":1.0},"60":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"c":{"df":5,"docs":{"62":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":6,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0},"62":{"tf":1.0},"79":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"17":{"tf":2.8284271247461903},"18":{"tf":1.0},"19":{"tf":2.449489742783178},"20":{"tf":1.0},"58":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.4142135623730951},"83":{"tf":1.0}}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}},"g":{"df":1,"docs":{"79":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"h":{"a":{"_":{"df":0,"docs":{},"t":{"df":3,"docs":{"67":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"82":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":4,"docs":{"30":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"47":{"tf":1.0},"60":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":16,"docs":{"16":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"28":{"tf":1.4142135623730951},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"37":{"tf":1.4142135623730951},"38":{"tf":1.0},"41":{"tf":1.4142135623730951},"43":{"tf":2.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"29":{"tf":1.7320508075688772},"81":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"60":{"tf":1.0},"64":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"5":{"tf":1.7320508075688772},"58":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":3,"docs":{"4":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.7320508075688772}},"e":{"'":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}},"i":{"c":{"df":1,"docs":{"52":{"tf":1.4142135623730951}}},"df":3,"docs":{"53":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"47":{"tf":1.0}}}}}}}},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"3":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"4":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"14":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"59":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"g":{"(":{"\"":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}}},"&":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"c":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"j":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":5,"docs":{"14":{"tf":1.4142135623730951},"52":{"tf":1.0},"58":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"64":{"tf":1.0}},"s":{"(":{"[":{"\"":{"df":0,"docs":{},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"v":{"7":{"a":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"77":{"tf":2.0},"78":{"tf":1.0},"79":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"73":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"73":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"k":{"df":2,"docs":{"12":{"tf":1.0},"80":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"!":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":2,"docs":{"12":{"tf":1.0},"53":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":5,"docs":{"25":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"73":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"55":{"tf":1.7320508075688772},"65":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"30":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"14":{"tf":1.0},"25":{"tf":1.0},"50":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"df":0,"docs":{}}}}},"v":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"d":{"(":{"4":{"0":{"0":{"0":{"0":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"6":{"4":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"37":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"37":{"tf":1.0}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":6,"docs":{"29":{"tf":1.0},"4":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"17":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"b":{":":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"1":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"84":{"tf":1.0}},"e":{"df":1,"docs":{"79":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"3":{"tf":1.0},"60":{"tf":1.0}}},"i":{"df":3,"docs":{"30":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0}}}}},"df":6,"docs":{"37":{"tf":1.0},"48":{"tf":2.23606797749979},"67":{"tf":1.0},"72":{"tf":1.4142135623730951},"73":{"tf":2.0},"76":{"tf":1.4142135623730951}},"e":{"df":2,"docs":{"49":{"tf":1.0},"64":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"49":{"tf":1.0},"76":{"tf":1.0}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":5,"docs":{"25":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"8":{"tf":1.0}}}},"t":{"a":{"_":{"df":0,"docs":{},"t":{"df":3,"docs":{"67":{"tf":1.4142135623730951},"72":{"tf":1.0},"73":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{".":{"a":{"df":1,"docs":{"76":{"tf":1.0}}},"b":{"df":1,"docs":{"76":{"tf":1.0}}},"c":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"_":{"a":{"(":{"1":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"b":{"(":{"1":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"(":{"1":{"2":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"3":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"76":{"tf":2.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}},"d":{"df":68,"docs":{"0":{"tf":1.0},"10":{"tf":3.3166247903554},"11":{"tf":2.23606797749979},"12":{"tf":2.23606797749979},"13":{"tf":1.7320508075688772},"14":{"tf":3.1622776601683795},"15":{"tf":1.7320508075688772},"16":{"tf":1.7320508075688772},"17":{"tf":2.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.7320508075688772},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":2.23606797749979},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"62":{"tf":2.449489742783178},"63":{"tf":1.0},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0},"7":{"tf":1.0},"73":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.4142135623730951},"81":{"tf":1.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.4142135623730951},"85":{"tf":2.0},"9":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":2,"docs":{"71":{"tf":1.0},"73":{"tf":1.0}}},":":{":":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"53":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"16":{"tf":1.0}}},":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"18":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"18":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"18":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"18":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}}},"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"22":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"44":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"o":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"69":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"n":{"df":1,"docs":{"82":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"_":{"_":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"_":{"1":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}},"2":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":53,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":2.0},"12":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":2.8284271247461903},"16":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":1.4142135623730951},"3":{"tf":1.0},"30":{"tf":1.4142135623730951},"33":{"tf":1.0},"34":{"tf":1.4142135623730951},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"43":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.0},"52":{"tf":2.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.4142135623730951},"57":{"tf":1.0},"58":{"tf":2.0},"6":{"tf":1.0},"60":{"tf":2.449489742783178},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"67":{"tf":2.0},"68":{"tf":1.4142135623730951},"7":{"tf":1.0},"71":{"tf":2.0},"73":{"tf":1.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.7320508075688772},"8":{"tf":3.0},"80":{"tf":2.0},"81":{"tf":1.7320508075688772},"82":{"tf":2.0},"83":{"tf":2.0},"84":{"tf":2.0},"85":{"tf":1.7320508075688772},"9":{"tf":1.0}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"71":{"tf":1.4142135623730951},"73":{"tf":2.0}}}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":4,"docs":{"11":{"tf":1.0},"15":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"42":{"tf":1.0}}}},":":{":":{"_":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"<":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":2.23606797749979}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"72":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"3":{"tf":1.0}}},"t":{"df":1,"docs":{"37":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"74":{"tf":1.7320508075688772},"75":{"tf":3.4641016151377544},"76":{"tf":3.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"76":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":6,"docs":{"25":{"tf":2.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"60":{"tf":1.0},"83":{"tf":1.0}}},"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"12":{"tf":2.0},"21":{"tf":1.0},"62":{"tf":2.23606797749979},"63":{"tf":1.0},"67":{"tf":1.0},"75":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":8,"docs":{"21":{"tf":3.0},"22":{"tf":1.0},"23":{"tf":2.449489742783178},"24":{"tf":1.0},"29":{"tf":1.0},"62":{"tf":1.7320508075688772},"64":{"tf":1.0},"75":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"48":{"tf":2.0},"81":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"60":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":1,"docs":{"67":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"3":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":1,"docs":{"59":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"r":{"df":11,"docs":{"10":{"tf":2.449489742783178},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.7320508075688772},"4":{"tf":2.0},"5":{"tf":1.0},"6":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":7,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"3":{"tf":2.23606797749979},"4":{"tf":1.0},"58":{"tf":1.0},"8":{"tf":2.6457513110645907}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"76":{"tf":1.0}}},".":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"85":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"50":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":4,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.0},"3":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"71":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772}}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":8,"docs":{"12":{"tf":1.0},"25":{"tf":2.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"60":{"tf":1.0},"78":{"tf":1.0},"83":{"tf":1.0}}}}},"z":{"2":{"_":{"b":{"df":0,"docs":{},"z":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}},"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":1.0}}},"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":1,"docs":{"12":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":2.23606797749979}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":2.23606797749979}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":1,"docs":{"12":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"2":{"'":{"df":1,"docs":{"11":{"tf":1.0}}},"df":6,"docs":{"10":{"tf":2.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"7":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"c":{"'":{"df":1,"docs":{"64":{"tf":1.0}}},"+":{"+":{"'":{"df":1,"docs":{"25":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"/":{"c":{"df":4,"docs":{"16":{"tf":1.0},"37":{"tf":1.0},"76":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}},"9":{"9":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},":":{"0":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"3":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":9,"docs":{"0":{"tf":1.0},"37":{"tf":1.0},"43":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":2.23606797749979},"64":{"tf":1.0},"77":{"tf":1.0},"82":{"tf":1.4142135623730951},"85":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":7,"docs":{"30":{"tf":1.0},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"37":{"tf":1.0},"60":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"14":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}}}}},"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"15":{"tf":1.0}}}}},"df":0,"docs":{}},"df":5,"docs":{"10":{"tf":2.6457513110645907},"11":{"tf":2.0},"12":{"tf":1.4142135623730951},"14":{"tf":2.0},"15":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"e":{"df":11,"docs":{"10":{"tf":1.0},"25":{"tf":1.4142135623730951},"30":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"43":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.0},"84":{"tf":1.0},"9":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}},"s":{"df":1,"docs":{"60":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":28,"docs":{"0":{"tf":2.449489742783178},"14":{"tf":2.23606797749979},"15":{"tf":1.7320508075688772},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"37":{"tf":1.0},"4":{"tf":1.4142135623730951},"48":{"tf":1.0},"58":{"tf":3.1622776601683795},"59":{"tf":1.0},"60":{"tf":2.449489742783178},"61":{"tf":2.8284271247461903},"62":{"tf":3.3166247903554},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":2.0},"77":{"tf":1.7320508075688772},"79":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"38":{"tf":1.0},"43":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"g":{"(":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":4,"docs":{"0":{"tf":1.0},"41":{"tf":1.0},"48":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":6,"docs":{"11":{"tf":1.0},"13":{"tf":1.0},"2":{"tf":1.0},"43":{"tf":1.4142135623730951},"79":{"tf":1.0},"8":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":2.0}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":7,"docs":{"14":{"tf":1.4142135623730951},"2":{"tf":1.7320508075688772},"3":{"tf":3.3166247903554},"58":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"64":{"tf":1.0},"82":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":12,"docs":{"16":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"62":{"tf":2.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"i":{"df":2,"docs":{"15":{"tf":1.0},"52":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":6,"docs":{"29":{"tf":1.0},"30":{"tf":2.449489742783178},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"61":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":19,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"16":{"tf":1.0},"29":{"tf":1.0},"4":{"tf":1.0},"47":{"tf":1.0},"49":{"tf":1.7320508075688772},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.4142135623730951},"61":{"tf":1.7320508075688772},"7":{"tf":1.0}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.7320508075688772},"37":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":2,"docs":{"78":{"tf":1.0},"83":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\"":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":13,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"19":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"51":{"tf":1.0},"53":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"85":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":2.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"43":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":12,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"14":{"tf":2.0},"3":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"43":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"5":{"tf":1.0},"79":{"tf":1.4142135623730951}}},"x":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":2.0}},"e":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}},"df":1,"docs":{"12":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":4,"docs":{"16":{"tf":1.0},"50":{"tf":2.0},"56":{"tf":1.0},"57":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"17":{"tf":1.0},"81":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"48":{"tf":1.4142135623730951}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"84":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":7,"docs":{"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":2.449489742783178},"75":{"tf":1.0},"76":{"tf":1.0},"83":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":7,"docs":{"14":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"6":{"tf":1.0},"75":{"tf":1.4142135623730951},"79":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"79":{"tf":1.0}}},"t":{"df":2,"docs":{"11":{"tf":1.0},"60":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"79":{"tf":1.0}}},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"0":{"tf":1.0}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"(":{"df":0,"docs":{},"i":{"df":1,"docs":{"0":{"tf":1.0}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"0":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"i":{"df":9,"docs":{"29":{"tf":1.0},"30":{"tf":2.23606797749979},"31":{"tf":1.0},"32":{"tf":1.4142135623730951},"33":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":4,"docs":{"17":{"tf":1.0},"51":{"tf":1.0},"71":{"tf":1.0},"78":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"8":{"tf":1.0}}},"(":{"df":1,"docs":{"66":{"tf":1.4142135623730951}}},"df":8,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":2.449489742783178},"14":{"tf":1.4142135623730951},"4":{"tf":1.0},"54":{"tf":1.0},"62":{"tf":1.7320508075688772},"79":{"tf":1.4142135623730951},"8":{"tf":1.0}},"s":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":2,"docs":{"13":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"df":1,"docs":{"12":{"tf":2.0}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":2.0},"14":{"tf":1.0},"4":{"tf":1.0},"56":{"tf":1.0},"60":{"tf":1.0},"76":{"tf":1.7320508075688772},"82":{"tf":1.0},"9":{"tf":1.7320508075688772}},"e":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"s":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"4":{"tf":1.0},"60":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":45,"docs":{"16":{"tf":1.7320508075688772},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.4142135623730951},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.7320508075688772},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"75":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":1.7320508075688772}}}}}}}},"d":{":":{"\\":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"\\":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"\\":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}},"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"t":{"a":{"[":{"2":{"5":{"2":{"df":1,"docs":{"41":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"12":{"tf":1.0},"42":{"tf":1.0},"78":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":3,"docs":{"67":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"80":{"tf":1.0},"84":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}}},"b":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"g":{"df":6,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0},"34":{"tf":2.23606797749979},"35":{"tf":1.0},"36":{"tf":1.4142135623730951},"37":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0}}}}}}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":4,"docs":{"58":{"tf":1.0},"61":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":2.0}},"e":{"d":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":1,"docs":{"12":{"tf":1.7320508075688772}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{":":{":":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.0},"84":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":16,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"38":{"tf":2.449489742783178},"39":{"tf":1.0},"40":{"tf":1.4142135623730951},"41":{"tf":1.4142135623730951},"42":{"tf":1.7320508075688772},"55":{"tf":1.0},"67":{"tf":1.0},"70":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"21":{"tf":1.0},"75":{"tf":1.0},"81":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"t":{"df":12,"docs":{"17":{"tf":2.0},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"29":{"tf":1.4142135623730951},"30":{"tf":1.0},"34":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":5,"docs":{"62":{"tf":1.0},"64":{"tf":1.0},"8":{"tf":3.0},"83":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"12":{"tf":2.449489742783178}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":19,"docs":{"21":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":2.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.7320508075688772},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}},"e":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"34":{"tf":1.0},"61":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}}}},"_":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"76":{"tf":1.0},"84":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"49":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":5,"docs":{"29":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"83":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":4,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"6":{"tf":1.0},"60":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"71":{"tf":1.0},"79":{"tf":1.0}}}}}}}},"v":{"df":1,"docs":{"3":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"50":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"73":{"tf":1.0},"77":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":5,"docs":{"12":{"tf":1.4142135623730951},"3":{"tf":1.0},"61":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"10":{"tf":1.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"3":{"tf":1.0},"50":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}},"s":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"67":{"tf":1.0},"76":{"tf":1.0}}}}}},"df":0,"docs":{}},"v":{"df":9,"docs":{"16":{"tf":1.4142135623730951},"24":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.7320508075688772}}}},"n":{"df":0,"docs":{},"f":{"df":1,"docs":{"3":{"tf":1.0}}}},"o":{"c":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"55":{"tf":1.7320508075688772}},"s":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.0},"16":{"tf":1.0},"5":{"tf":1.7320508075688772},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}}}}}}}},"df":1,"docs":{"79":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"3":{"tf":1.0},"58":{"tf":1.0},"64":{"tf":1.0}}}},"df":0,"docs":{}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.4142135623730951},"21":{"tf":1.0},"60":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{":":{":":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"81":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}}},"x":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":2.6457513110645907}}}},"u":{"df":0,"docs":{},"e":{"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"11":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"79":{"tf":2.23606797749979}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":1,"docs":{"62":{"tf":1.0}}}},"a":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"85":{"tf":1.7320508075688772}}}},"c":{"df":0,"docs":{},"h":{"df":5,"docs":{"4":{"tf":1.0},"62":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":2.23606797749979},"82":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":3,"docs":{"67":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"60":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":6,"docs":{"14":{"tf":1.0},"43":{"tf":1.0},"49":{"tf":1.0},"55":{"tf":1.0},"71":{"tf":1.4142135623730951},"75":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"79":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"df":3,"docs":{"58":{"tf":1.0},"64":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"47":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"83":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"47":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"78":{"tf":1.0},"9":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.0},"9":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":3,"docs":{"16":{"tf":1.0},"37":{"tf":1.7320508075688772},"72":{"tf":1.0}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"3":{"tf":1.0},"54":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"25":{"tf":1.0},"61":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"[":{"df":0,"docs":{},"e":{"0":{"3":{"0":{"8":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"6":{"3":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":5,"docs":{"43":{"tf":1.0},"60":{"tf":1.0},"73":{"tf":1.0},"8":{"tf":1.0},"82":{"tf":1.0}},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"46":{"tf":1.0}}}}}}}}},"t":{"c":{"df":2,"docs":{"4":{"tf":1.0},"58":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"12":{"tf":1.4142135623730951},"17":{"tf":1.0},"60":{"tf":1.0}}}}}}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"72":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":18,"docs":{"0":{"tf":1.0},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"47":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"62":{"tf":1.0},"66":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"81":{"tf":1.0}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.7320508075688772},"79":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"10":{"tf":1.0},"15":{"tf":1.4142135623730951},"16":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":1.0},"29":{"tf":1.0},"60":{"tf":1.0},"75":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"c":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772}},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}}}},"df":0,"docs":{}},"df":2,"docs":{"58":{"tf":1.0},"73":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"61":{"tf":1.4142135623730951},"62":{"tf":1.7320508075688772}}}}},"r":{"a":{"df":3,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"60":{"tf":1.0}}}}}},"m":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}},"q":{"df":7,"docs":{"58":{"tf":1.0},"80":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}},"r":{"df":1,"docs":{"83":{"tf":1.0}}},"t":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}}},"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":3,"docs":{"67":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":6,"docs":{"17":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772},"63":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951}},"e":{"(":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{",":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}},"w":{"df":3,"docs":{"11":{"tf":1.0},"16":{"tf":1.0},"64":{"tf":1.4142135623730951}}}},"f":{"df":0,"docs":{},"i":{"df":8,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"4":{"tf":1.0},"58":{"tf":1.0}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"a":{"df":1,"docs":{"84":{"tf":1.0}}},"b":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{}},"df":12,"docs":{"21":{"tf":1.0},"47":{"tf":2.449489742783178},"48":{"tf":1.0},"59":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":2.449489742783178},"80":{"tf":1.0},"84":{"tf":2.6457513110645907}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":18,"docs":{"10":{"tf":3.0},"12":{"tf":1.4142135623730951},"14":{"tf":4.0},"15":{"tf":2.0},"17":{"tf":1.0},"19":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"4":{"tf":1.0},"50":{"tf":2.23606797749979},"56":{"tf":1.4142135623730951},"58":{"tf":1.4142135623730951},"61":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"79":{"tf":1.0}}}},"d":{"df":3,"docs":{"60":{"tf":1.0},"64":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"14":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"8":{"tf":1.0}}}}},"t":{"df":1,"docs":{"60":{"tf":1.0}}},"x":{"df":3,"docs":{"77":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.0}},"e":{"d":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"82":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":5,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"50":{"tf":1.0},"54":{"tf":1.0},"82":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"(":{"&":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"77":{"tf":2.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"i":{"df":3,"docs":{"10":{"tf":1.0},"4":{"tf":1.0},"7":{"tf":1.0}}}},"n":{"df":13,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"12":{"tf":1.0},"14":{"tf":1.0},"42":{"tf":1.0},"48":{"tf":1.0},"53":{"tf":1.0},"61":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":2.23606797749979},"82":{"tf":1.0},"84":{"tf":1.0}},"o":{"df":1,"docs":{"82":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":13,"docs":{"11":{"tf":1.0},"3":{"tf":1.0},"51":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"61":{"tf":1.4142135623730951},"67":{"tf":1.0},"7":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"8":{"tf":1.0}}}}}},"o":{"(":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"(":{")":{".":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"d":{"df":2,"docs":{"62":{"tf":1.0},"63":{"tf":1.0}}},"df":0,"docs":{}}},".":{"0":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}},"df":5,"docs":{"24":{"tf":1.0},"28":{"tf":1.0},"62":{"tf":2.449489742783178},"63":{"tf":1.0},"84":{"tf":1.0}}},"r":{"c":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":11,"docs":{"16":{"tf":1.0},"37":{"tf":1.0},"49":{"tf":2.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0}},"t":{"df":2,"docs":{"54":{"tf":1.0},"57":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"=":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"54":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"17":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}},"df":2,"docs":{"62":{"tf":1.0},"73":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":2,"docs":{"62":{"tf":1.7320508075688772},"64":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"65":{"tf":1.0}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"13":{"tf":1.0},"62":{"tf":1.0},"7":{"tf":1.0},"79":{"tf":1.0}},"i":{"df":1,"docs":{"79":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":18,"docs":{"0":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"43":{"tf":1.0},"58":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":2.23606797749979},"62":{"tf":1.7320508075688772},"64":{"tf":1.0},"75":{"tf":1.4142135623730951},"76":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":1.7320508075688772},"82":{"tf":3.0},"83":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"12":{"tf":1.0},"60":{"tf":1.0},"82":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"g":{"c":{"c":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":71,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":2.8284271247461903},"11":{"tf":2.23606797749979},"14":{"tf":2.449489742783178},"15":{"tf":1.4142135623730951},"16":{"tf":1.7320508075688772},"17":{"tf":2.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.4142135623730951},"22":{"tf":1.0},"23":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":2.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.4142135623730951},"43":{"tf":1.0},"44":{"tf":1.0},"45":{"tf":1.0},"46":{"tf":1.0},"47":{"tf":1.0},"48":{"tf":1.0},"49":{"tf":1.0},"50":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.7320508075688772},"54":{"tf":1.4142135623730951},"55":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"58":{"tf":1.7320508075688772},"59":{"tf":1.0},"60":{"tf":2.23606797749979},"61":{"tf":1.4142135623730951},"62":{"tf":3.1622776601683795},"63":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"66":{"tf":1.0},"67":{"tf":1.7320508075688772},"7":{"tf":1.0},"71":{"tf":2.0},"74":{"tf":1.4142135623730951},"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"80":{"tf":2.0},"81":{"tf":1.7320508075688772},"82":{"tf":2.23606797749979},"83":{"tf":1.7320508075688772},"84":{"tf":2.0},"85":{"tf":2.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":2,"docs":{"58":{"tf":1.0},"60":{"tf":1.0}},"n":{"df":4,"docs":{"0":{"tf":1.0},"14":{"tf":1.0},"56":{"tf":1.0},"64":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"4":{"tf":1.0}}}},"o":{"df":2,"docs":{"64":{"tf":1.0},"79":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"12":{"tf":2.23606797749979},"9":{"tf":1.0}}}}},"p":{"df":1,"docs":{"12":{"tf":2.0}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"64":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"83":{"tf":1.0}},"l":{"df":2,"docs":{"58":{"tf":1.4142135623730951},"82":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":18,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"14":{"tf":2.0},"15":{"tf":1.4142135623730951},"17":{"tf":1.0},"2":{"tf":1.0},"21":{"tf":1.0},"29":{"tf":1.0},"4":{"tf":1.0},"41":{"tf":1.4142135623730951},"42":{"tf":1.0},"58":{"tf":1.0},"61":{"tf":1.4142135623730951},"64":{"tf":1.7320508075688772},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"83":{"tf":1.0},"9":{"tf":2.6457513110645907}},"s":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"c":{"df":1,"docs":{"14":{"tf":1.7320508075688772}}},"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}},"o":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}},"df":1,"docs":{"14":{"tf":2.0}}}},"p":{"df":4,"docs":{"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"25":{"tf":1.0},"62":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"73":{"tf":1.0},"79":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":10,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.4142135623730951},"7":{"tf":1.0},"79":{"tf":1.0},"9":{"tf":1.0}}}}},"i":{"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}},"df":0,"docs":{},"e":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"24":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"16":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}}},"t":{"df":1,"docs":{"82":{"tf":1.0}}}},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"58":{"tf":1.0}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"+":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"i":{"'":{"df":0,"docs":{},"m":{"df":1,"docs":{"12":{"tf":1.0}}}},".":{"df":1,"docs":{"75":{"tf":1.0}}},"d":{"df":3,"docs":{"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"64":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"77":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"79":{"tf":1.0}}},"f":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{":":{":":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":3,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"61":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"77":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":5,"docs":{"42":{"tf":1.0},"48":{"tf":1.0},"61":{"tf":1.0},"79":{"tf":1.4142135623730951},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"38":{"tf":1.0},"42":{"tf":1.4142135623730951},"61":{"tf":1.0},"75":{"tf":1.0},"79":{"tf":1.0},"84":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"59":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"75":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":10,"docs":{"10":{"tf":1.0},"11":{"tf":2.0},"14":{"tf":1.0},"21":{"tf":1.0},"42":{"tf":1.0},"64":{"tf":1.0},"71":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0},"9":{"tf":1.7320508075688772}},"e":{"!":{"(":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"c":{"a":{"df":0,"docs":{},"t":{"!":{"(":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"!":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"42":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"!":{"(":{"\"":{".":{".":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":1,"docs":{"59":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":1,"docs":{"10":{"tf":1.0}},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"79":{"tf":1.0},"82":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":5,"docs":{"59":{"tf":1.0},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":5,"docs":{"12":{"tf":2.23606797749979},"62":{"tf":1.0},"72":{"tf":2.0},"78":{"tf":1.0},"84":{"tf":2.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":6,"docs":{"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"80":{"tf":1.0},"81":{"tf":2.6457513110645907},"82":{"tf":3.0},"83":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.7320508075688772}}}}}},"_":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"85":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":6,"docs":{"10":{"tf":1.0},"12":{"tf":1.4142135623730951},"14":{"tf":1.0},"15":{"tf":1.0},"61":{"tf":1.0},"82":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}}},"i":{"d":{"df":6,"docs":{"14":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.0},"61":{"tf":1.4142135623730951},"7":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"15":{"tf":1.7320508075688772},"3":{"tf":3.3166247903554},"54":{"tf":1.0}}},"n":{"c":{"df":2,"docs":{"61":{"tf":2.0},"62":{"tf":1.4142135623730951}},"e":{".":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{")":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"61":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":2,"docs":{"62":{"tf":1.0},"64":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":7,"docs":{"21":{"tf":1.0},"61":{"tf":1.0},"67":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.4142135623730951},"43":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"3":{"2":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"6":{"4":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":2.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"0":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"41":{"tf":1.0},"48":{"tf":1.0},"76":{"tf":1.7320508075688772},"81":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":3,"docs":{"67":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"a":{"c":{"df":4,"docs":{"13":{"tf":1.0},"4":{"tf":1.0},"60":{"tf":1.4142135623730951},"63":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"61":{"tf":1.0}},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.7320508075688772}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":6,"docs":{"15":{"tf":1.0},"54":{"tf":1.0},"59":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.4142135623730951},"85":{"tf":1.0}}}}}},"o":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":5,"docs":{"60":{"tf":1.4142135623730951},"80":{"tf":1.4142135623730951},"81":{"tf":1.7320508075688772},"82":{"tf":1.4142135623730951},"83":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"u":{"df":4,"docs":{"60":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.0},"81":{"tf":1.0}}}}},"t":{"'":{"df":3,"docs":{"43":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951}}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":4,"docs":{"19":{"tf":1.4142135623730951},"21":{"tf":1.0},"23":{"tf":1.4142135623730951},"62":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"75":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":9,"docs":{"14":{"tf":1.0},"30":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"37":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"60":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"60":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"81":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"67":{"tf":1.0},"8":{"tf":1.4142135623730951}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":3,"docs":{"11":{"tf":1.0},"60":{"tf":1.0},"79":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"n":{"df":3,"docs":{"77":{"tf":1.4142135623730951},"78":{"tf":1.7320508075688772},"79":{"tf":2.23606797749979}},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"12":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951}}}}}},"t":{"'":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951}}},"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"2":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"b":{"<":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{">":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"=":{"b":{"df":0,"docs":{},"z":{"2":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"z":{"2":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"=":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":4,"docs":{"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"85":{"tf":1.0}}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"x":{"df":1,"docs":{"3":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}},"o":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"a":{"df":1,"docs":{"14":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"(":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{".":{"a":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":28,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":3.4641016151377544},"16":{"tf":1.0},"18":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"31":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"4":{"tf":2.0},"43":{"tf":1.0},"44":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"53":{"tf":1.4142135623730951},"58":{"tf":1.0},"6":{"tf":1.4142135623730951},"69":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"80":{"tf":1.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.7320508075688772},"85":{"tf":1.0},"9":{"tf":1.0}}},"y":{"'":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":13,"docs":{"15":{"tf":1.7320508075688772},"16":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"36":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"70":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951},"82":{"tf":1.0},"85":{"tf":1.0}}},"k":{"_":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":5,"docs":{"10":{"tf":1.7320508075688772},"12":{"tf":1.0},"14":{"tf":2.0},"82":{"tf":1.4142135623730951},"83":{"tf":1.0}}},"u":{"df":0,"docs":{},"x":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"1":{"tf":1.0},"3":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"83":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":1,"docs":{"3":{"tf":2.449489742783178}}}}},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":4,"docs":{"61":{"tf":1.0},"62":{"tf":1.0},"71":{"tf":1.0},"75":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"64":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":4,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"77":{"tf":1.0},"79":{"tf":1.0}}}},"t":{"df":3,"docs":{"17":{"tf":1.0},"43":{"tf":1.0},"62":{"tf":1.4142135623730951}}}}},"m":{"a":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"3":{"tf":1.0}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"c":{"df":3,"docs":{"41":{"tf":1.0},"42":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"14":{"tf":1.4142135623730951},"53":{"tf":1.0}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"e":{"df":4,"docs":{"21":{"tf":1.0},"47":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":4,"docs":{"37":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0},"65":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"58":{"tf":1.0},"84":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":1,"docs":{"12":{"tf":1.0}}},"r":{"df":0,"docs":{},"k":{"df":3,"docs":{"58":{"tf":1.4142135623730951},"82":{"tf":1.0},"83":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":6,"docs":{"11":{"tf":1.0},"12":{"tf":2.449489742783178},"17":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"64":{"tf":1.0}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":4,"docs":{"61":{"tf":1.0},"67":{"tf":1.0},"79":{"tf":2.23606797749979},"83":{"tf":1.0}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":3,"docs":{"77":{"tf":2.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":4,"docs":{"29":{"tf":1.0},"33":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"64":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"(":{"&":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":15,"docs":{"16":{"tf":1.0},"50":{"tf":1.0},"53":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":2.449489742783178},"62":{"tf":1.7320508075688772},"64":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"80":{"tf":1.0},"81":{"tf":2.0},"82":{"tf":1.7320508075688772},"83":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"w":{"6":{"4":{"/":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"w":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}},"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"54":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"73":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":1,"docs":{"43":{"tf":1.0}}}}},"o":{"d":{"df":3,"docs":{"12":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0}},"e":{"df":1,"docs":{"58":{"tf":1.0}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":6,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"29":{"tf":1.0},"55":{"tf":1.0},"60":{"tf":1.0},"75":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"48":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"e":{"df":3,"docs":{"33":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951}}}}},"s":{"df":0,"docs":{},"v":{"c":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"12":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":4,"docs":{"58":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"78":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}},"p":{"df":0,"docs":{},"l":{"df":3,"docs":{"29":{"tf":1.0},"37":{"tf":1.0},"9":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"43":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"46":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}},"t":{"df":8,"docs":{"0":{"tf":1.0},"12":{"tf":3.7416573867739413},"61":{"tf":1.7320508075688772},"62":{"tf":1.0},"64":{"tf":1.0},"73":{"tf":1.0},"76":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"y":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"61":{"tf":2.0}}}}}},"df":0,"docs":{}},"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"(":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"y":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"(":{"_":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":1,"docs":{"61":{"tf":3.1622776601683795}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{".":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{".":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"<":{"[":{":":{":":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{":":{":":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{":":{":":{"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":2.449489742783178}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"79":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}},"df":3,"docs":{"77":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":2.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":7,"docs":{"10":{"tf":1.0},"15":{"tf":1.0},"50":{"tf":1.0},"63":{"tf":1.0},"64":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"3":{"tf":1.0},"76":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":16,"docs":{"14":{"tf":1.0},"21":{"tf":1.4142135623730951},"25":{"tf":1.0},"3":{"tf":2.0},"38":{"tf":1.0},"4":{"tf":1.7320508075688772},"41":{"tf":1.0},"43":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":2.23606797749979},"64":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"83":{"tf":1.0},"85":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"w":{"(":{"df":1,"docs":{"48":{"tf":1.0}}},"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"df":0,"docs":{},"{":{"1":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":5,"docs":{"14":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"73":{"tf":1.4142135623730951},"76":{"tf":1.0}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"6":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"e":{"df":3,"docs":{"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"58":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":7,"docs":{"51":{"tf":2.0},"52":{"tf":1.0},"53":{"tf":1.0},"56":{"tf":1.0},"67":{"tf":1.4142135623730951},"71":{"tf":1.4142135623730951},"79":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}},"y":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"41":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"60":{"tf":1.0}},"e":{"df":2,"docs":{"20":{"tf":1.0},"85":{"tf":1.7320508075688772}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":5,"docs":{"55":{"tf":1.4142135623730951},"56":{"tf":1.0},"57":{"tf":1.0},"79":{"tf":1.4142135623730951},"8":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"d":{"df":0,"docs":{},"o":{"c":{"_":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"56":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":8,"docs":{"10":{"tf":1.0},"64":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0}}},"h":{"df":1,"docs":{"13":{"tf":1.0}}}},"w":{"df":4,"docs":{"10":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"64":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.7320508075688772}}}}}}}},"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"48":{"tf":1.0}}}},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"b":{"df":0,"docs":{},"j":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{":":{":":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"j":{"c":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":8,"docs":{"10":{"tf":1.0},"14":{"tf":1.7320508075688772},"62":{"tf":3.3166247903554},"63":{"tf":1.7320508075688772},"64":{"tf":1.7320508075688772},"65":{"tf":1.0},"66":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"78":{"tf":1.0}}}}}}},"c":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"62":{"tf":1.0}}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":2,"docs":{"14":{"tf":1.0},"15":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":2,"docs":{"11":{"tf":4.0},"12":{"tf":4.123105625617661}}},"n":{"df":9,"docs":{"21":{"tf":1.0},"29":{"tf":2.0},"54":{"tf":1.0},"60":{"tf":1.4142135623730951},"71":{"tf":1.0},"72":{"tf":1.0},"75":{"tf":1.0},"78":{"tf":1.0},"84":{"tf":1.0}},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"48":{"tf":2.0}}}}}}},"df":0,"docs":{}}}}}}},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":9,"docs":{"21":{"tf":1.0},"25":{"tf":2.0},"26":{"tf":1.0},"27":{"tf":1.4142135623730951},"28":{"tf":1.0},"58":{"tf":1.4142135623730951},"60":{"tf":1.0},"75":{"tf":1.4142135623730951},"83":{"tf":1.4142135623730951}},"e":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"s":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"65":{"tf":1.0}}},"r":{"df":1,"docs":{"58":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":13,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.0},"55":{"tf":1.0},"56":{"tf":1.0},"65":{"tf":1.0},"67":{"tf":1.7320508075688772},"68":{"tf":1.4142135623730951},"72":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"62":{"tf":1.4142135623730951},"78":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"61":{"tf":1.4142135623730951}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":5,"docs":{"4":{"tf":1.0},"60":{"tf":1.0},"71":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":5,"docs":{"12":{"tf":1.0},"13":{"tf":1.0},"76":{"tf":1.7320508075688772},"78":{"tf":1.0},"82":{"tf":1.0}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":4,"docs":{"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"37":{"tf":1.0},"53":{"tf":2.0}}}}},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"4":{"tf":1.0},"61":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"59":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}}}}},"l":{"df":0,"docs":{},"o":{"a":{"d":{"df":2,"docs":{"58":{"tf":1.0},"59":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"df":1,"docs":{"77":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"d":{"df":2,"docs":{"80":{"tf":1.0},"84":{"tf":2.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":3,"docs":{"1":{"tf":1.0},"3":{"tf":1.0},"8":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"c":{"!":{"(":{"\"":{"b":{"df":0,"docs":{},"z":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.7320508075688772}}}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":2.23606797749979}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":2.449489742783178}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":5,"docs":{"60":{"tf":1.0},"62":{"tf":1.0},"64":{"tf":1.4142135623730951},"75":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.0}},"e":{"_":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"(":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{":":{":":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"14":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":2,"docs":{"59":{"tf":1.0},"79":{"tf":1.4142135623730951}},"i":{"a":{"df":0,"docs":{},"l":{"df":2,"docs":{"17":{"tf":1.0},"60":{"tf":1.0}}}},"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"21":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"df":13,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":2.449489742783178},"15":{"tf":1.0},"16":{"tf":1.0},"50":{"tf":1.4142135623730951},"53":{"tf":1.0},"56":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.4142135623730951},"67":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"\"":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{":":{":":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"r":{"(":{"\"":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"\"":{")":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"(":{")":{")":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"\"":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":7,"docs":{"14":{"tf":2.449489742783178},"15":{"tf":2.0},"19":{"tf":1.0},"21":{"tf":1.0},"23":{"tf":1.0},"53":{"tf":1.0},"62":{"tf":1.0}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"a":{"d":{"[":{"0":{"df":1,"docs":{"77":{"tf":1.0}}},"df":0,"docs":{}},"df":3,"docs":{"77":{"tf":1.0},"78":{"tf":1.7320508075688772},"79":{"tf":2.8284271247461903}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":1,"docs":{"63":{"tf":1.0}},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"12":{"tf":1.0}}}}},"r":{"df":1,"docs":{"84":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"g":{"_":{"a":{"d":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}},"n":{"df":1,"docs":{"17":{"tf":1.0}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":6,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"14":{"tf":1.0},"3":{"tf":1.0},"47":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"47":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"14":{"tf":1.4142135623730951},"60":{"tf":1.0},"72":{"tf":1.0},"84":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"7":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"17":{"tf":1.0},"58":{"tf":1.0}}}}},"df":2,"docs":{"3":{"tf":1.0},"75":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"63":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"2":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"50":{"tf":1.0},"84":{"tf":1.0}}}},"t":{"df":1,"docs":{"41":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":3,"docs":{"58":{"tf":1.0},"83":{"tf":1.0},"9":{"tf":1.0}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"54":{"tf":2.23606797749979},"57":{"tf":2.0}}}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":14,"docs":{"29":{"tf":1.0},"30":{"tf":2.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":2.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":2.0},"39":{"tf":1.0},"40":{"tf":1.0},"41":{"tf":1.0},"42":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"(":{"b":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"76":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"15":{"tf":1.0},"61":{"tf":1.0},"76":{"tf":2.0}},"l":{"df":0,"docs":{},"n":{"!":{"(":{"\"":{"a":{"df":1,"docs":{"76":{"tf":1.0}}},"b":{"df":1,"docs":{"76":{"tf":1.0}}},"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"c":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"76":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"72":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"47":{"tf":1.7320508075688772},"48":{"tf":1.4142135623730951}},"e":{"=":{"\"":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"\"":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"48":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"58":{"tf":1.0},"65":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.4142135623730951}}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":3,"docs":{"0":{"tf":1.0},"61":{"tf":1.0},"82":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"63":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"d":{"df":9,"docs":{"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"16":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.0},"61":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.4142135623730951},"82":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"37":{"tf":1.0}},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"d":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"79":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"u":{"b":{"df":5,"docs":{"0":{"tf":2.0},"48":{"tf":1.7320508075688772},"61":{"tf":2.449489742783178},"78":{"tf":2.0},"79":{"tf":3.605551275463989}},"l":{"df":0,"docs":{},"i":{"c":{"df":5,"docs":{"29":{"tf":1.0},"47":{"tf":1.0},"61":{"tf":1.0},"81":{"tf":1.0},"9":{"tf":1.4142135623730951}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"13":{"tf":2.0}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"58":{"tf":1.0},"83":{"tf":1.0}}}},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"12":{"tf":1.0},"15":{"tf":1.0}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"80":{"tf":1.4142135623730951}}}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"\"":{")":{".":{"a":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"60":{"tf":1.0}}}},"w":{"df":4,"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"33":{"tf":1.0},"79":{"tf":1.7320508075688772}}}},"df":1,"docs":{"12":{"tf":7.615773105863909}},"e":{"a":{"d":{"df":3,"docs":{"12":{"tf":1.0},"58":{"tf":1.0},"67":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":1,"docs":{"79":{"tf":1.0}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"47":{"tf":1.0},"62":{"tf":1.0},"82":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"4":{"tf":1.0},"58":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"16":{"tf":1.0},"5":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":2.449489742783178}},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"10":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":5,"docs":{"21":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.0}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"51":{"tf":1.7320508075688772},"56":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"68":{"tf":1.4142135623730951}}}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"82":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"61":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":2,"docs":{"29":{"tf":2.6457513110645907},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"=":{"\"":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"\"":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"(":{"c":{"df":5,"docs":{"0":{"tf":1.0},"48":{"tf":1.0},"61":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":3,"docs":{"62":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":6,"docs":{"1":{"tf":2.0},"14":{"tf":1.0},"2":{"tf":1.4142135623730951},"3":{"tf":1.0},"62":{"tf":1.0},"76":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":7,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.4142135623730951},"12":{"tf":3.7416573867739413},"14":{"tf":1.4142135623730951},"64":{"tf":1.0},"76":{"tf":1.0},"79":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":10,"docs":{"12":{"tf":2.449489742783178},"14":{"tf":1.0},"43":{"tf":1.0},"60":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.7320508075688772},"64":{"tf":1.7320508075688772},"65":{"tf":1.0},"79":{"tf":2.0},"81":{"tf":1.4142135623730951}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"78":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"t":{"+":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"12":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"3":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"17":{"tf":1.7320508075688772},"60":{"tf":1.0}}}},"n":{"df":9,"docs":{"1":{"tf":1.0},"10":{"tf":1.0},"11":{"tf":2.23606797749979},"12":{"tf":2.0},"14":{"tf":1.4142135623730951},"4":{"tf":1.0},"50":{"tf":1.0},"52":{"tf":1.7320508075688772},"53":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"79":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":3,"docs":{"11":{"tf":1.0},"60":{"tf":1.0},"71":{"tf":1.0}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{">":{"<":{"/":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"16":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":8,"docs":{"24":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.7320508075688772}}}}}},"df":0,"docs":{}}}},"c":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951}}},"df":27,"docs":{"0":{"tf":1.7320508075688772},"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"17":{"tf":1.0},"25":{"tf":1.4142135623730951},"29":{"tf":1.0},"4":{"tf":1.4142135623730951},"43":{"tf":1.0},"48":{"tf":1.0},"54":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"64":{"tf":1.0},"67":{"tf":2.8284271247461903},"70":{"tf":1.0},"71":{"tf":2.23606797749979},"73":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":2.6457513110645907},"82":{"tf":1.0}},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"50":{"tf":1.7320508075688772},"56":{"tf":1.0}}}}}}},"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":5,"docs":{"49":{"tf":1.4142135623730951},"50":{"tf":1.4142135623730951},"51":{"tf":2.0},"53":{"tf":1.7320508075688772},"56":{"tf":2.23606797749979}}}}},"u":{"df":0,"docs":{},"p":{"df":3,"docs":{"51":{"tf":1.0},"52":{"tf":1.4142135623730951},"53":{"tf":1.7320508075688772}}}}}}}},"s":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":4,"docs":{"13":{"tf":1.4142135623730951},"33":{"tf":1.0},"37":{"tf":1.0},"79":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":6,"docs":{"12":{"tf":1.0},"14":{"tf":1.0},"61":{"tf":1.0},"62":{"tf":1.0},"76":{"tf":1.0},"77":{"tf":1.0}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":2.23606797749979}}}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}},"df":2,"docs":{"3":{"tf":1.4142135623730951},"48":{"tf":1.7320508075688772}},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"=":{"/":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"14":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"c":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"49":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"60":{"tf":1.7320508075688772},"67":{"tf":1.0},"73":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"f":{"df":6,"docs":{"42":{"tf":1.4142135623730951},"48":{"tf":1.0},"61":{"tf":1.4142135623730951},"64":{"tf":1.0},"79":{"tf":1.7320508075688772},"84":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"61":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":3,"docs":{"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.4142135623730951}}},"t":{"_":{"<":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"75":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"3":{"tf":1.4142135623730951},"47":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"76":{"tf":3.3166247903554},"79":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"75":{"tf":1.0},"76":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"p":{"df":2,"docs":{"14":{"tf":1.0},"62":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":2,"docs":{"25":{"tf":1.0},"60":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"10":{"tf":1.7320508075688772},"14":{"tf":1.0},"82":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"34":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"58":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"60":{"tf":1.0}}}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}},"i":{"df":2,"docs":{"25":{"tf":1.0},"78":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"82":{"tf":1.0}}}},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"_":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"77":{"tf":1.4142135623730951}}}},"df":8,"docs":{"11":{"tf":1.0},"12":{"tf":2.449489742783178},"25":{"tf":1.0},"60":{"tf":1.0},"77":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"79":{"tf":3.872983346207417},"83":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"79":{"tf":2.23606797749979}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"12":{"tf":1.0},"64":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"61":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"10":{"tf":1.0},"47":{"tf":1.0},"62":{"tf":1.0},"79":{"tf":1.0}}},"i":{"df":0,"docs":{},"m":{"df":4,"docs":{"25":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"78":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"t":{"df":2,"docs":{"12":{"tf":1.0},"83":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"c":{"df":5,"docs":{"14":{"tf":1.4142135623730951},"16":{"tf":1.0},"3":{"tf":1.4142135623730951},"82":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":2,"docs":{"14":{"tf":2.0},"53":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":4,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"f":{"df":5,"docs":{"4":{"tf":1.0},"60":{"tf":1.0},"67":{"tf":1.4142135623730951},"72":{"tf":1.0},"83":{"tf":1.0}},"i":{"df":5,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.4142135623730951},"41":{"tf":1.0},"79":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":2.0},"12":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{":":{"4":{"4":{":":{"1":{"5":{"df":1,"docs":{"73":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"_":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"84":{"tf":1.7320508075688772}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"67":{"tf":1.0}}}},"l":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":3,"docs":{"77":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":2,"docs":{"63":{"tf":1.4142135623730951},"79":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"c":{"df":6,"docs":{"12":{"tf":1.0},"14":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"75":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":2.0}}},"df":0,"docs":{}},"u":{"df":2,"docs":{"14":{"tf":1.4142135623730951},"53":{"tf":1.0}}}}},"d":{":":{":":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"c":{":":{":":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"79":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{":":{":":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{":":{":":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{":":{":":{"<":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{">":{":":{":":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":1,"docs":{"78":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"84":{"tf":1.0}},"e":{"d":{":":{":":{"<":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{":":{":":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"72":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"12":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{":":{":":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{":":{":":{"c":{"_":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"0":{"tf":1.0},"48":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{":":{":":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"f":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{":":{":":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"\"":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}},"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"53":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"=":{"c":{"+":{"+":{"1":{"4":{"df":1,"docs":{"58":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"58":{"tf":1.4142135623730951},"83":{"tf":1.0}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"3":{"tf":1.0},"51":{"tf":1.0},"6":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"21":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"73":{"tf":1.0},"79":{"tf":1.0}}}}},"l":{"df":2,"docs":{"80":{"tf":1.0},"83":{"tf":2.23606797749979}}},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"78":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.4142135623730951}}}}}}},"df":1,"docs":{"12":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"m":{".":{"a":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"12":{"tf":3.4641016151377544}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{":":{":":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"8":{"(":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{")":{".":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"(":{"\"":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":3,"docs":{"12":{"tf":2.449489742783178},"14":{"tf":1.0},"48":{"tf":1.0}}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":21,"docs":{"0":{"tf":1.4142135623730951},"11":{"tf":1.0},"16":{"tf":1.0},"33":{"tf":1.4142135623730951},"41":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.7320508075688772},"59":{"tf":1.0},"60":{"tf":1.7320508075688772},"61":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.0},"67":{"tf":1.4142135623730951},"73":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"76":{"tf":1.0},"77":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.4142135623730951},"84":{"tf":1.7320508075688772},"9":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"29":{"tf":1.0},"47":{"tf":1.0},"77":{"tf":2.0},"78":{"tf":2.449489742783178},"79":{"tf":2.449489742783178}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"76":{"tf":2.449489742783178}},"s":{":":{":":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"_":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"_":{"1":{"(":{"0":{",":{"0":{",":{"0":{"df":1,"docs":{"76":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"58":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"11":{"tf":1.0},"16":{"tf":1.0}}},"o":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"u":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"64":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"60":{"tf":1.0},"61":{"tf":1.0}}}}}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":2.0}}}}}},"df":0,"docs":{},"h":{"df":4,"docs":{"17":{"tf":1.0},"25":{"tf":1.0},"60":{"tf":1.4142135623730951},"67":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"15":{"tf":1.0},"81":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":12,"docs":{"4":{"tf":1.0},"59":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951},"62":{"tf":1.0},"63":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"73":{"tf":1.0},"75":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"83":{"tf":1.7320508075688772}}}},"s":{"df":1,"docs":{"14":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"11":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"67":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"y":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.7320508075688772},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"66":{"tf":1.0}},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"82":{"tf":1.0}}}}},"df":1,"docs":{"12":{"tf":2.449489742783178}}},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"x":{"df":2,"docs":{"55":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":6,"docs":{"10":{"tf":1.0},"14":{"tf":1.4142135623730951},"21":{"tf":1.0},"53":{"tf":1.0},"7":{"tf":1.0},"82":{"tf":1.0}}}}}}}},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"16":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"77":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":3,"docs":{"15":{"tf":1.0},"53":{"tf":1.0},"79":{"tf":2.0}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"(":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0}}},"/":{"d":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"/":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"_":{"b":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"2":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"2":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"11":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"=":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"6":{"4":{"df":1,"docs":{"64":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"v":{"7":{"a":{"df":1,"docs":{"85":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":9,"docs":{"4":{"tf":1.4142135623730951},"64":{"tf":1.0},"67":{"tf":2.23606797749979},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"73":{"tf":1.0},"79":{"tf":1.0},"80":{"tf":1.0},"85":{"tf":2.23606797749979}}}}}}},"df":1,"docs":{"29":{"tf":1.4142135623730951}},"e":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":2,"docs":{"77":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":5,"docs":{"10":{"tf":2.0},"14":{"tf":2.0},"57":{"tf":1.0},"67":{"tf":1.0},"79":{"tf":1.0}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"17":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":2.23606797749979},"80":{"tf":1.0},"83":{"tf":1.4142135623730951}},"e":{"<":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"n":{"d":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"48":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":4.58257569495584},"12":{"tf":5.656854249492381}},"s":{":":{":":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"13":{"tf":1.0},"79":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"'":{"df":2,"docs":{"10":{"tf":1.0},"78":{"tf":1.7320508075688772}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"82":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":3,"docs":{"64":{"tf":1.4142135623730951},"65":{"tf":1.0},"83":{"tf":1.4142135623730951}}},"k":{"df":1,"docs":{"11":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"3":{"tf":1.0},"58":{"tf":1.0},"9":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":3,"docs":{"12":{"tf":1.0},"60":{"tf":1.0},"73":{"tf":1.4142135623730951}}}}}}}},"i":{"df":1,"docs":{"83":{"tf":1.0}},"e":{"df":1,"docs":{"12":{"tf":1.0}}},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"64":{"tf":1.0}}}},"_":{"df":0,"docs":{},"t":{"df":3,"docs":{"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.4142135623730951}}}},"df":7,"docs":{"10":{"tf":1.4142135623730951},"12":{"tf":1.0},"25":{"tf":1.0},"4":{"tf":1.0},"64":{"tf":1.0},"77":{"tf":1.0},"8":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":3,"docs":{"77":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"64":{"tf":1.0}}}}}}}},"l":{";":{"d":{"df":0,"docs":{},"r":{"df":1,"docs":{"7":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"=":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"53":{"tf":1.0}}}}}}}}}},"df":3,"docs":{"53":{"tf":1.4142135623730951},"54":{"tf":1.0},"84":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":1,"docs":{"3":{"tf":1.0}}}},"p":{"df":2,"docs":{"12":{"tf":1.0},"13":{"tf":1.0}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"78":{"tf":1.0}}},"t":{"df":9,"docs":{"21":{"tf":1.4142135623730951},"29":{"tf":1.0},"30":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"60":{"tf":1.0},"62":{"tf":1.4142135623730951},"63":{"tf":1.4142135623730951},"84":{"tf":1.0}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"21":{"tf":1.4142135623730951},"83":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"16":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0},"60":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":6,"docs":{"25":{"tf":2.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"58":{"tf":1.0},"60":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":1,"docs":{"64":{"tf":1.0}},"p":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"60":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"e":{"df":3,"docs":{"56":{"tf":1.0},"76":{"tf":1.0},"81":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":9,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":2.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"14":{"tf":1.0},"6":{"tf":1.7320508075688772},"7":{"tf":2.449489742783178},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"w":{"df":0,"docs":{},"o":{"df":6,"docs":{"14":{"tf":1.0},"53":{"tf":1.0},"55":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0},"77":{"tf":1.0}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":4,"docs":{"0":{"tf":1.0},"16":{"tf":1.0},"67":{"tf":1.7320508075688772},"76":{"tf":1.0}}}}},"df":32,"docs":{"0":{"tf":1.0},"17":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":2.6457513110645907},"23":{"tf":1.4142135623730951},"25":{"tf":2.23606797749979},"26":{"tf":1.0},"27":{"tf":1.7320508075688772},"28":{"tf":1.0},"29":{"tf":2.449489742783178},"30":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"43":{"tf":2.449489742783178},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"58":{"tf":2.23606797749979},"60":{"tf":2.449489742783178},"62":{"tf":1.0},"67":{"tf":2.0},"71":{"tf":2.0},"72":{"tf":1.0},"73":{"tf":2.8284271247461903},"74":{"tf":1.4142135623730951},"75":{"tf":1.7320508075688772},"76":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":3.3166247903554},"83":{"tf":1.0},"9":{"tf":1.0}}},"i":{"c":{"df":3,"docs":{"77":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0}}},"df":0,"docs":{}}}}},"u":{"8":{"df":1,"docs":{"61":{"tf":1.0}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"62":{"tf":1.0},"66":{"tf":1.0}}}}},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"62":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"1":{"6":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{"2":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"8":{"_":{"df":0,"docs":{},"t":{"df":1,"docs":{"67":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"62":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"(":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{".":{"0":{"df":1,"docs":{"62":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":1,"docs":{"62":{"tf":1.0}}}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"60":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":3,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"79":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"72":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"df":7,"docs":{"67":{"tf":2.6457513110645907},"68":{"tf":1.0},"69":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":2.8284271247461903},"72":{"tf":2.449489742783178},"73":{"tf":2.6457513110645907}}}},"t":{"df":2,"docs":{"75":{"tf":1.4142135623730951},"76":{"tf":1.0}}}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"12":{"tf":2.449489742783178}}}}}}}},"s":{"a":{"df":0,"docs":{},"f":{"df":9,"docs":{"12":{"tf":1.0},"61":{"tf":1.4142135623730951},"67":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"76":{"tf":2.23606797749979},"78":{"tf":1.7320508075688772},"79":{"tf":1.4142135623730951},"84":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"41":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"77":{"tf":1.4142135623730951}}}},"z":{"df":1,"docs":{"79":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":3,"docs":{"56":{"tf":1.0},"67":{"tf":1.0},"79":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"53":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.4142135623730951}}}}}}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.7320508075688772}}}},"df":0,"docs":{}}}},"p":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"14":{"tf":1.0},"56":{"tf":1.4142135623730951},"58":{"tf":1.0},"60":{"tf":1.0},"64":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":12,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"4":{"tf":1.7320508075688772},"5":{"tf":1.0},"6":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}}}},"df":56,"docs":{"0":{"tf":1.0},"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"12":{"tf":3.0},"14":{"tf":1.7320508075688772},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":1.0},"25":{"tf":1.0},"29":{"tf":2.0},"3":{"tf":1.7320508075688772},"30":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.4142135623730951},"43":{"tf":2.0},"44":{"tf":1.0},"45":{"tf":1.4142135623730951},"46":{"tf":1.0},"49":{"tf":1.4142135623730951},"50":{"tf":1.7320508075688772},"51":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"53":{"tf":2.0},"54":{"tf":2.0},"55":{"tf":1.4142135623730951},"56":{"tf":1.7320508075688772},"57":{"tf":1.7320508075688772},"58":{"tf":2.449489742783178},"6":{"tf":1.0},"60":{"tf":1.4142135623730951},"61":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"64":{"tf":1.7320508075688772},"67":{"tf":2.23606797749979},"68":{"tf":1.0},"69":{"tf":1.0},"7":{"tf":1.0},"70":{"tf":1.0},"71":{"tf":1.4142135623730951},"72":{"tf":2.449489742783178},"73":{"tf":2.0},"74":{"tf":1.7320508075688772},"75":{"tf":1.4142135623730951},"76":{"tf":1.7320508075688772},"77":{"tf":2.449489742783178},"78":{"tf":1.4142135623730951},"79":{"tf":2.449489742783178},"8":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.7320508075688772},"85":{"tf":1.4142135623730951},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"55":{"tf":1.0}}}},"i":{"df":0,"docs":{},"z":{"df":2,"docs":{"78":{"tf":1.0},"79":{"tf":2.6457513110645907}}}},"u":{"a":{"df":0,"docs":{},"l":{"df":3,"docs":{"12":{"tf":1.0},"79":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"f":{"df":1,"docs":{"53":{"tf":1.0}}}},"{":{"1":{"df":0,"docs":{},"}":{"_":{"df":0,"docs":{},"z":{"df":0,"docs":{},"n":{"7":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"6":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"c":{"1":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"v":{"0":{".":{"1":{".":{"0":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"12":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"14":{"tf":1.0},"53":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":6,"docs":{"12":{"tf":2.449489742783178},"3":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"61":{"tf":2.0},"79":{"tf":1.4142135623730951}}}},"r":{"df":2,"docs":{"19":{"tf":1.4142135623730951},"23":{"tf":1.4142135623730951}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"17":{"tf":1.4142135623730951},"3":{"tf":1.0},"64":{"tf":1.0},"77":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"72":{"tf":1.4142135623730951},"73":{"tf":1.0},"79":{"tf":2.23606797749979}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"47":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"c":{"!":{"[":{"0":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"<":{"df":0,"docs":{},"u":{"8":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":2.0}}}}},"df":0,"docs":{},"i":{"df":3,"docs":{"64":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":3,"docs":{"11":{"tf":1.0},"12":{"tf":1.0},"61":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":4,"docs":{"67":{"tf":1.4142135623730951},"73":{"tf":1.0},"8":{"tf":1.4142135623730951},"84":{"tf":1.0}}}}}}}},"i":{"a":{"df":4,"docs":{"12":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"47":{"tf":1.0},"48":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"0":{"tf":1.0},"61":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"6":{"4":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":10,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"21":{"tf":1.0},"50":{"tf":1.0},"55":{"tf":1.0},"58":{"tf":1.4142135623730951},"62":{"tf":1.0},"75":{"tf":1.0},"85":{"tf":1.0},"9":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"11":{"tf":1.0},"43":{"tf":1.0},"8":{"tf":1.0}}}},"y":{"df":6,"docs":{"16":{"tf":1.0},"29":{"tf":1.0},"4":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.4142135623730951},"79":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"'":{"d":{"df":2,"docs":{"12":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"16":{"tf":1.0},"7":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":3,"docs":{"58":{"tf":1.4142135623730951},"62":{"tf":1.0},"83":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"78":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":2,"docs":{"10":{"tf":1.0},"14":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"78":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"81":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"3":{"tf":1.4142135623730951}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"47":{"tf":1.4142135623730951}}}},"t":{"df":0,"docs":{},"h":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"(":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"53":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"75":{"tf":1.0},"77":{"tf":1.0},"78":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":6,"docs":{"12":{"tf":1.0},"57":{"tf":1.0},"59":{"tf":1.0},"60":{"tf":1.0},"62":{"tf":1.0},"78":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"64":{"tf":1.0},"76":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"d":{"df":1,"docs":{"61":{"tf":1.0}},"i":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"82":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":5,"docs":{"12":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"73":{"tf":1.0},"78":{"tf":1.0}}},"l":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"p":{"df":3,"docs":{"13":{"tf":1.0},"21":{"tf":1.0},"82":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":2.449489742783178}}}},"df":1,"docs":{"61":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"\"":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"/":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"/":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"53":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{".":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"(":{"\"":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":6,"docs":{"10":{"tf":1.4142135623730951},"12":{"tf":2.0},"13":{"tf":1.0},"14":{"tf":1.4142135623730951},"53":{"tf":1.0},"67":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}},"x":{".":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"a":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"73":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{".":{"a":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"73":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"6":{"4":{"df":1,"docs":{"60":{"tf":1.0}}},"df":0,"docs":{}},"8":{"6":{"_":{"6":{"4":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":6,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"72":{"tf":1.7320508075688772},"73":{"tf":1.4142135623730951}}},"y":{"df":3,"docs":{"0":{"tf":1.4142135623730951},"12":{"tf":1.0},"13":{"tf":1.4142135623730951}},"o":{"df":0,"docs":{},"u":{"'":{"d":{"df":2,"docs":{"3":{"tf":1.0},"62":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":4,"docs":{"3":{"tf":1.0},"64":{"tf":1.4142135623730951},"78":{"tf":1.0},"79":{"tf":1.7320508075688772}}}},"r":{"df":4,"docs":{"64":{"tf":1.7320508075688772},"78":{"tf":1.0},"79":{"tf":1.0},"83":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":3,"docs":{"58":{"tf":1.0},"78":{"tf":1.0},"82":{"tf":1.0}}}}}}}}}},"z":{".":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"a":{"df":1,"docs":{"72":{"tf":1.0}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":1,"docs":{"72":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":4,"docs":{"72":{"tf":1.7320508075688772},"73":{"tf":1.0},"78":{"tf":1.0},"79":{"tf":1.0}}}}}}}},"title":{"root":{"_":{"_":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"78":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"a":{"d":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"81":{"tf":1.0}}}}}}}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":9,"docs":{"20":{"tf":1.0},"24":{"tf":1.0},"28":{"tf":1.0},"33":{"tf":1.0},"37":{"tf":1.0},"41":{"tf":1.0},"43":{"tf":1.0},"46":{"tf":1.0},"48":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"52":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"80":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"55":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":6,"docs":{"11":{"tf":1.0},"16":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"82":{"tf":1.0},"85":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":11,"docs":{"52":{"tf":1.0},"53":{"tf":1.0},"67":{"tf":1.0},"68":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"8":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"83":{"tf":1.0},"84":{"tf":1.0}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"73":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"74":{"tf":1.0},"75":{"tf":1.0},"76":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"l":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"25":{"tf":1.0}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{".":{"df":0,"docs":{},"r":{"df":3,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"4":{"tf":1.0}}}},"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"72":{"tf":1.0}}}}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"25":{"tf":1.0}}}}}},"c":{"df":4,"docs":{"58":{"tf":1.0},"62":{"tf":1.0},"77":{"tf":1.0},"83":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"2":{"tf":1.0},"3":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"81":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"52":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":9,"docs":{"15":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.0},"70":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"61":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"(":{"df":1,"docs":{"66":{"tf":1.0}}},"df":1,"docs":{"13":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":3,"docs":{"16":{"tf":1.0},"42":{"tf":1.0},"85":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"84":{"tf":1.0}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":3,"docs":{"30":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0}}}}}},"o":{"c":{"df":1,"docs":{"55":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"79":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":2,"docs":{"66":{"tf":1.0},"76":{"tf":1.0}}}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"59":{"tf":1.0},"60":{"tf":1.0},"63":{"tf":1.0}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":2,"docs":{"47":{"tf":1.0},"84":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.0},"50":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"77":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"49":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"82":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":11,"docs":{"11":{"tf":1.0},"16":{"tf":1.0},"58":{"tf":1.0},"62":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"74":{"tf":1.0},"81":{"tf":1.0},"82":{"tf":1.0},"84":{"tf":1.0},"85":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"42":{"tf":1.0}}}}}}}}}},"n":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"82":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"n":{"'":{"df":0,"docs":{},"t":{"df":2,"docs":{"81":{"tf":1.0},"82":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":13,"docs":{"14":{"tf":1.0},"18":{"tf":1.0},"22":{"tf":1.0},"26":{"tf":1.0},"31":{"tf":1.0},"35":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.0},"44":{"tf":1.0},"5":{"tf":1.0},"53":{"tf":1.0},"69":{"tf":1.0},"83":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":9,"docs":{"15":{"tf":1.0},"19":{"tf":1.0},"23":{"tf":1.0},"27":{"tf":1.0},"32":{"tf":1.0},"36":{"tf":1.0},"40":{"tf":1.0},"45":{"tf":1.0},"70":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"47":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"81":{"tf":1.0}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"51":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"55":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"64":{"tf":1.0}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"62":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}},"p":{"a":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"68":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"75":{"tf":1.0}}}}}}}}}},"p":{"a":{"d":{"df":1,"docs":{"84":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"50":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"54":{"tf":1.0},"57":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"34":{"tf":1.0},"38":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"47":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"13":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"80":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"51":{"tf":1.0}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"68":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"a":{"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"m":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"50":{"tf":1.0}}}}}}},"df":2,"docs":{"51":{"tf":1.0},"56":{"tf":1.0}}}}}}}}},"s":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"12":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"61":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":1,"docs":{"79":{"tf":1.0}}}}},"r":{"c":{"/":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"b":{".":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"83":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":1,"docs":{"83":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"75":{"tf":1.0}}}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"77":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":4,"docs":{"59":{"tf":1.0},"63":{"tf":1.0},"65":{"tf":1.0},"83":{"tf":1.0}}}}}}}}},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"85":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"83":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"25":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"6":{"tf":1.0},"7":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":8,"docs":{"25":{"tf":1.0},"29":{"tf":1.0},"43":{"tf":1.0},"67":{"tf":1.0},"71":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"79":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"67":{"tf":1.0},"71":{"tf":1.0},"72":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"60":{"tf":1.0}}}}}}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"14":{"tf":1.0},"15":{"tf":1.0},"4":{"tf":1.0}}}},"df":14,"docs":{"43":{"tf":1.0},"51":{"tf":1.0},"52":{"tf":1.0},"53":{"tf":1.0},"54":{"tf":1.0},"56":{"tf":1.0},"57":{"tf":1.0},"64":{"tf":1.0},"67":{"tf":1.0},"72":{"tf":1.0},"73":{"tf":1.0},"74":{"tf":1.0},"77":{"tf":1.0},"79":{"tf":1.0}}}},"w":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{".":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}}}}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"AND","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});