%feature("docstring") OT::GumbelLambdaGamma
"Gumbel rate/location parametrization.

Parameters
----------
lambda : float
    Rate parameter :math:`\\lambda > 0`.

    Default value is 0.0.
gamma : float
    Location parameter.

    Default value is 1.0.

Notes
-----
The native parameters :math:`(\\beta, \\gamma)` are defined as follows:

.. math::

   \\beta &= \\frac{1}{\\lambda} \\\\

The :math:`\\gamma` parameter is the same.

See also
--------
Gumbel

Examples
--------
Create the parameters :math:`(\\lambda, \\gamma)` of the Gumbel distribution:

>>> import openturns as ot
>>> parameters = ot.GumbelLambdaGamma(2.0, 0.5)

Convert parameters into the native parameters :math:`(\\beta, \\gamma)`:

>>> print(parameters.evaluate())
[0.5,0.5]"
