%feature("docstring") OT::KernelMixture
"Build a particular linear combination of probability density functions.

Parameters
----------
kernel : :class:`~openturns.Distribution`
    Univariate distribution of the kernel that will be used, :math:`K`.
bandwidth : sequence of float
    Contains the bandwidth in each direction, :math:`(h_1, \\dots, h_d)`.
sample : 2-d sequence of float
    The data on which each kernel is centered,
    :math:`(\\vect{X}_1, \\dots, \\vect{X}_N) \\in \\Rset^d`.

Notes
-----
A *KernelMixture* is a particular *Mixture*: all the weights are identical and
the all the probability density functions of the combination are of the same
family. They are centered on :math:`N` points. The treatment is optimized.

The pdf of a *KernelMixture* is defined by:

.. math::

    f(\\vect{x}) =  \\sum_{i=1}^N \\dfrac{1}{N} \\Pi_{j=1}^d \\dfrac{1}{h_j}K(\\frac{x^j-X^j_i}{h})

where :math:`N` is the number of points in the sample
:math:`(\\vect{X}_1, \\dots, \\vect{X}_N) \\in \\Rset^d` and :math:`K` a univariate
distribution.

Examples
--------
Create a *KernelMixture*:

>>> import openturns as ot
>>> kernel = ot.Uniform()
>>> sample = ot.Normal().getSample(5)
>>> bandwidth = [1.0]
>>> distribution = ot.KernelMixture(kernel, bandwidth, sample)
 
Draw a sample:

>>> sample = distribution.getSample(5)"

// ---------------------------------------------------------------------
%feature("docstring") OT::KernelMixture::getKernel
"Accessor to kernel used in the linear combination.

Returns
-------
kernel : :class:`~openturns.Distribution`
    Univariate distribution used to build the kernel."


// ---------------------------------------------------------------------
%feature("docstring") OT::KernelMixture::setKernel
"Set the kernel used in the linear combination.

Parameters
----------
kernel : :class:`~openturns.Distribution`
    Univariate distribution used to build the kernel."

// ---------------------------------------------------------------------
%feature("docstring") OT::KernelMixture::getBandwidth
"Accessor to the bandwidth used in the linear combination.

Returns
-------
bandwidth : :class:`~openturns.Point`
    Bandwidth used in each direction."

// ---------------------------------------------------------------------
%feature("docstring") OT::KernelMixture::setBandwidth
"Set the bandwidth used in the linear combination.

Parameters
----------
bandwidth : sequence of float
    Bandwidth used in each direction."

// ---------------------------------------------------------------------
%feature("docstring") OT::KernelMixture::setInternalSample
"Set the sample used in the linear combination.

Parameters
----------
sample : 2-d sequence of float
    Sample on which the kernels are centered."

// ---------------------------------------------------------------------

%feature("docstring") OT::KernelMixture::getInternalSample
"Get the sample used in the linear combination.

Returns
-------
sample : :class:`~openturns.Sample`
    Sample on which the kernels are centered."
