"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const expect_1 = __importDefault(require("expect"));
const jestMock = __importStar(require("jest-mock"));
const plugin_1 = require("./plugin");
const NvimPlugin_1 = require("../host/NvimPlugin");
const function_1 = require("./function");
const command_1 = require("./command");
const autocmd_1 = require("./autocmd");
const testUtil_1 = require("../testUtil");
const instantiateOrRun = (Fn, ...args) => {
    try {
        return new Fn(...args);
    }
    catch (err) {
        if (err instanceof TypeError) {
            return Fn(...args);
        }
        throw err;
    }
};
describe('Plugin class decorator', () => {
    it('decorates class with no options', () => {
        class MyClass {
        }
        const plugin = (0, plugin_1.plugin)(MyClass);
        (0, expect_1.default)(typeof plugin).toEqual('function');
    });
    it('decorates class with dev mode option', () => {
        class MyClass {
        }
        const plugin = (0, plugin_1.plugin)({ dev: true })(MyClass);
        (0, expect_1.default)(typeof plugin).toEqual('function');
        const pluginObject = {
            setOptions: jestMock.fn(),
            nvim: (0, testUtil_1.getFakeNvimClient)(),
        };
        instantiateOrRun(plugin, pluginObject);
        (0, expect_1.default)(pluginObject.setOptions).toHaveBeenCalledWith({ dev: true });
    });
    it('decorates class methods', () => {
        class MyClass {
            testF() { }
            testC() { }
            testA() { }
        }
        // This is how (closeish) babel applies decorators
        (0, function_1.nvimFunction)('TestF', { eval: 'test', range: [1, 10] })(MyClass.prototype, 'testF');
        (0, command_1.command)('TestCommand', { range: 'test', nargs: '3' })(MyClass.prototype, 'testC');
        (0, autocmd_1.autocmd)('TestAutocmd', {
            pattern: '*.js',
            eval: 'test',
        })(MyClass.prototype, 'testA');
        const plugin = (0, plugin_1.plugin)(MyClass);
        const pluginObject = {
            registerAutocmd: jestMock.fn(),
            registerCommand: jestMock.fn(),
            registerFunction: jestMock.fn(),
            nvim: (0, testUtil_1.getFakeNvimClient)(),
        };
        const instance = instantiateOrRun(plugin, pluginObject);
        (0, expect_1.default)(pluginObject.registerAutocmd).toHaveBeenCalledWith('TestAutocmd', [instance, MyClass.prototype.testA], {
            pattern: '*.js',
            sync: false,
            eval: 'test',
        });
        (0, expect_1.default)(pluginObject.registerCommand).toHaveBeenCalledWith('TestCommand', [instance, MyClass.prototype.testC], { sync: false, range: 'test', nargs: '3' });
        (0, expect_1.default)(pluginObject.registerFunction).toHaveBeenCalledWith('TestF', [instance, MyClass.prototype.testF], { sync: false, eval: 'test', range: [1, 10] });
    });
    it('generates specs from decorated methods', () => {
        class MyClass {
            testF() { }
            testC() { }
            testA() { }
        }
        // This is how (closeish) babel applies decorators
        (0, function_1.nvimFunction)('TestF')(MyClass.prototype, 'testF');
        (0, command_1.command)('TestCommand')(MyClass.prototype, 'testC');
        (0, autocmd_1.autocmd)('TestAutocmd', {
            pattern: '*.js',
        })(MyClass.prototype, 'testA');
        const plugin = (0, plugin_1.plugin)(MyClass);
        const pluginObject = new NvimPlugin_1.NvimPlugin('/tmp/filename', plugin, (0, testUtil_1.getFakeNvimClient)());
        (0, expect_1.default)(pluginObject.specs).toEqual([
            {
                type: 'autocmd',
                name: 'TestAutocmd',
                sync: false,
                opts: {
                    pattern: '*.js',
                },
            },
            {
                type: 'command',
                name: 'TestCommand',
                sync: false,
                opts: {},
            },
            {
                type: 'function',
                name: 'TestF',
                sync: false,
                opts: {},
            },
        ]);
    });
});
