// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Data_Xml_Xsl_H
#define WINRT_Windows_Data_Xml_Xsl_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/impl/Windows.Data.Xml.Dom.2.h"
#include "winrt/impl/Windows.Data.Xml.Xsl.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Data_Xml_Xsl_IXsltProcessor<D>::TransformToString(winrt::Windows::Data::Xml::Dom::IXmlNode const& inputNode) const
    {
        void* output{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Data::Xml::Xsl::IXsltProcessor>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Data::Xml::Xsl::IXsltProcessor, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Data::Xml::Xsl::IXsltProcessor>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TransformToString(*(void**)(&inputNode), &output));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Data::Xml::Xsl::IXsltProcessor>**)this;
            check_hresult(_winrt_abi_type->TransformToString(*(void**)(&inputNode), &output));
        }
        return hstring{ output, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Data_Xml_Xsl_IXsltProcessor2<D>::TransformToDocument(winrt::Windows::Data::Xml::Dom::IXmlNode const& inputNode) const
    {
        void* output{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Data::Xml::Xsl::IXsltProcessor2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Data::Xml::Xsl::IXsltProcessor2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Data::Xml::Xsl::IXsltProcessor2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TransformToDocument(*(void**)(&inputNode), &output));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Data::Xml::Xsl::IXsltProcessor2>**)this;
            check_hresult(_winrt_abi_type->TransformToDocument(*(void**)(&inputNode), &output));
        }
        return winrt::Windows::Data::Xml::Dom::XmlDocument{ output, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Data_Xml_Xsl_IXsltProcessorFactory<D>::CreateInstance(winrt::Windows::Data::Xml::Dom::XmlDocument const& document) const
    {
        void* xsltProcessor{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Data::Xml::Xsl::IXsltProcessorFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Data::Xml::Xsl::IXsltProcessorFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Data::Xml::Xsl::IXsltProcessorFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&document), &xsltProcessor));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Data::Xml::Xsl::IXsltProcessorFactory>**)this;
            check_hresult(_winrt_abi_type->CreateInstance(*(void**)(&document), &xsltProcessor));
        }
        return winrt::Windows::Data::Xml::Xsl::XsltProcessor{ xsltProcessor, take_ownership_from_abi };
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Data::Xml::Xsl::IXsltProcessor> : produce_base<D, winrt::Windows::Data::Xml::Xsl::IXsltProcessor>
    {
        int32_t __stdcall TransformToString(void* inputNode, void** output) noexcept final try
        {
            clear_abi(output);
            typename D::abi_guard guard(this->shim());
            *output = detach_from<hstring>(this->shim().TransformToString(*reinterpret_cast<winrt::Windows::Data::Xml::Dom::IXmlNode const*>(&inputNode)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Data::Xml::Xsl::IXsltProcessor2> : produce_base<D, winrt::Windows::Data::Xml::Xsl::IXsltProcessor2>
    {
        int32_t __stdcall TransformToDocument(void* inputNode, void** output) noexcept final try
        {
            clear_abi(output);
            typename D::abi_guard guard(this->shim());
            *output = detach_from<winrt::Windows::Data::Xml::Dom::XmlDocument>(this->shim().TransformToDocument(*reinterpret_cast<winrt::Windows::Data::Xml::Dom::IXmlNode const*>(&inputNode)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Data::Xml::Xsl::IXsltProcessorFactory> : produce_base<D, winrt::Windows::Data::Xml::Xsl::IXsltProcessorFactory>
    {
        int32_t __stdcall CreateInstance(void* document, void** xsltProcessor) noexcept final try
        {
            clear_abi(xsltProcessor);
            typename D::abi_guard guard(this->shim());
            *xsltProcessor = detach_from<winrt::Windows::Data::Xml::Xsl::XsltProcessor>(this->shim().CreateInstance(*reinterpret_cast<winrt::Windows::Data::Xml::Dom::XmlDocument const*>(&document)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::Data::Xml::Xsl
{
    inline XsltProcessor::XsltProcessor(winrt::Windows::Data::Xml::Dom::XmlDocument const& document) :
        XsltProcessor(impl::call_factory<XsltProcessor, IXsltProcessorFactory>([&](IXsltProcessorFactory const& f) { return f.CreateInstance(document); }))
    {
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Data::Xml::Xsl::IXsltProcessor> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Data::Xml::Xsl::IXsltProcessor2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Data::Xml::Xsl::IXsltProcessorFactory> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Data::Xml::Xsl::XsltProcessor> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
