// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_ApplicationModel_Chat_H
#define WINRT_Windows_ApplicationModel_Chat_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.ApplicationModel.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Media.MediaProperties.2.h"
#include "winrt/impl/Windows.Security.Credentials.2.h"
#include "winrt/impl/Windows.Storage.Streams.2.h"
#include "winrt/impl/Windows.ApplicationModel.Chat.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatCapabilities<D>::IsOnline() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsOnline(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsOnline(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatCapabilities<D>::IsChatCapable() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsChatCapable(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsChatCapable(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatCapabilities<D>::IsFileTransferCapable() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsFileTransferCapable(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsFileTransferCapable(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatCapabilities<D>::IsGeoLocationPushCapable() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsGeoLocationPushCapable(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsGeoLocationPushCapable(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatCapabilities<D>::IsIntegratedMessagingCapable() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatCapabilities>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatCapabilities, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilities>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsIntegratedMessagingCapable(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilities>**)this;
            check_hresult(_winrt_abi_type->get_IsIntegratedMessagingCapable(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatCapabilitiesManagerStatics<D>::GetCachedCapabilitiesAsync(param::hstring const& address) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCachedCapabilitiesAsync(*(void**)(&address), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics>**)this;
            check_hresult(_winrt_abi_type->GetCachedCapabilitiesAsync(*(void**)(&address), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatCapabilities>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatCapabilitiesManagerStatics<D>::GetCapabilitiesFromNetworkAsync(param::hstring const& address) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCapabilitiesFromNetworkAsync(*(void**)(&address), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics>**)this;
            check_hresult(_winrt_abi_type->GetCapabilitiesFromNetworkAsync(*(void**)(&address), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatCapabilities>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatCapabilitiesManagerStatics2<D>::GetCachedCapabilitiesAsync(param::hstring const& address, param::hstring const& transportId) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCachedCapabilitiesForTransportAsync(*(void**)(&address), *(void**)(&transportId), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics2>**)this;
            check_hresult(_winrt_abi_type->GetCachedCapabilitiesForTransportAsync(*(void**)(&address), *(void**)(&transportId), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatCapabilities>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatCapabilitiesManagerStatics2<D>::GetCapabilitiesFromNetworkAsync(param::hstring const& address, param::hstring const& transportId) const
    {
        void* operation{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetCapabilitiesFromNetworkForTransportAsync(*(void**)(&address), *(void**)(&transportId), &operation));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics2>**)this;
            check_hresult(_winrt_abi_type->GetCapabilitiesFromNetworkForTransportAsync(*(void**)(&address), *(void**)(&transportId), &operation));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatCapabilities>{ operation, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::HasUnreadMessages() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_HasUnreadMessages(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->get_HasUnreadMessages(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::Id() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->get_Id(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::Subject() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Subject(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->get_Subject(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::Subject(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Subject(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->put_Subject(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::IsConversationMuted() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsConversationMuted(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->get_IsConversationMuted(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::IsConversationMuted(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsConversationMuted(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->put_IsConversationMuted(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::MostRecentMessageId() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MostRecentMessageId(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->get_MostRecentMessageId(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::Participants() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Participants(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->get_Participants(&result));
        }
        return winrt::Windows::Foundation::Collections::IVector<hstring>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::ThreadingInfo() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ThreadingInfo(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->get_ThreadingInfo(&result));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatConversationThreadingInfo{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::DeleteAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DeleteAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->DeleteAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::GetMessageReader() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetMessageReader(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->GetMessageReader(&result));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatMessageReader{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::MarkMessagesAsReadAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MarkAllMessagesAsReadAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->MarkAllMessagesAsReadAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::MarkMessagesAsReadAsync(winrt::Windows::Foundation::DateTime const& value) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MarkMessagesAsReadAsync(impl::bind_in(value), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->MarkMessagesAsReadAsync(impl::bind_in(value), &result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::SaveAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SaveAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->SaveAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::NotifyLocalParticipantComposing(param::hstring const& transportId, param::hstring const& participantAddress, bool isComposing) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->NotifyLocalParticipantComposing(*(void**)(&transportId), *(void**)(&participantAddress), isComposing));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->NotifyLocalParticipantComposing(*(void**)(&transportId), *(void**)(&participantAddress), isComposing));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::NotifyRemoteParticipantComposing(param::hstring const& transportId, param::hstring const& participantAddress, bool isComposing) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->NotifyRemoteParticipantComposing(*(void**)(&transportId), *(void**)(&participantAddress), isComposing));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->NotifyRemoteParticipantComposing(*(void**)(&transportId), *(void**)(&participantAddress), isComposing));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::RemoteParticipantComposingChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Chat::ChatConversation, winrt::Windows::ApplicationModel::Chat::RemoteParticipantComposingChangedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_RemoteParticipantComposingChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            check_hresult(_winrt_abi_type->add_RemoteParticipantComposingChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::RemoteParticipantComposingChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Chat::ChatConversation, winrt::Windows::ApplicationModel::Chat::RemoteParticipantComposingChangedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, RemoteParticipantComposingChanged_revoker>(this, RemoteParticipantComposingChanged(handler));
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation<D>::RemoteParticipantComposingChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)&_winrt_casted_result;
            _winrt_abi_type->remove_RemoteParticipantComposingChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation>**)this;
            _winrt_abi_type->remove_RemoteParticipantComposingChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation2<D>::CanModifyParticipants() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_CanModifyParticipants(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation2>**)this;
            check_hresult(_winrt_abi_type->get_CanModifyParticipants(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversation2<D>::CanModifyParticipants(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversation2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversation2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_CanModifyParticipants(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversation2>**)this;
            check_hresult(_winrt_abi_type->put_CanModifyParticipants(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversationReader<D>::ReadBatchAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversationReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversationReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadBatchAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationReader>**)this;
            check_hresult(_winrt_abi_type->ReadBatchAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::ChatConversation>>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversationReader<D>::ReadBatchAsync(int32_t count) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversationReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversationReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadBatchWithCountAsync(count, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationReader>**)this;
            check_hresult(_winrt_abi_type->ReadBatchWithCountAsync(count, &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::ChatConversation>>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversationThreadingInfo<D>::ContactId() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ContactId(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)this;
            check_hresult(_winrt_abi_type->get_ContactId(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversationThreadingInfo<D>::ContactId(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ContactId(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)this;
            check_hresult(_winrt_abi_type->put_ContactId(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversationThreadingInfo<D>::Custom() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Custom(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)this;
            check_hresult(_winrt_abi_type->get_Custom(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversationThreadingInfo<D>::Custom(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Custom(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)this;
            check_hresult(_winrt_abi_type->put_Custom(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversationThreadingInfo<D>::ConversationId() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ConversationId(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)this;
            check_hresult(_winrt_abi_type->get_ConversationId(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversationThreadingInfo<D>::ConversationId(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ConversationId(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)this;
            check_hresult(_winrt_abi_type->put_ConversationId(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversationThreadingInfo<D>::Participants() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Participants(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)this;
            check_hresult(_winrt_abi_type->get_Participants(&result));
        }
        return winrt::Windows::Foundation::Collections::IVector<hstring>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversationThreadingInfo<D>::Kind() const
    {
        winrt::Windows::ApplicationModel::Chat::ChatConversationThreadingKind result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Kind(reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)this;
            check_hresult(_winrt_abi_type->get_Kind(reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatConversationThreadingInfo<D>::Kind(winrt::Windows::ApplicationModel::Chat::ChatConversationThreadingKind const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Kind(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>**)this;
            check_hresult(_winrt_abi_type->put_Kind(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatItem<D>::ItemKind() const
    {
        winrt::Windows::ApplicationModel::Chat::ChatItemKind result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatItem>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatItem, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatItem>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ItemKind(reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatItem>**)this;
            check_hresult(_winrt_abi_type->get_ItemKind(reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::Attachments() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Attachments(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->get_Attachments(&value));
        }
        return winrt::Windows::Foundation::Collections::IVector<winrt::Windows::ApplicationModel::Chat::ChatMessageAttachment>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::Body() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Body(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->get_Body(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::Body(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Body(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->put_Body(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::From() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_From(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->get_From(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::Id() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::IsForwardingDisabled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsForwardingDisabled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->get_IsForwardingDisabled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::IsIncoming() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsIncoming(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->get_IsIncoming(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::IsRead() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsRead(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->get_IsRead(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::LocalTimestamp() const
    {
        winrt::Windows::Foundation::DateTime value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_LocalTimestamp(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->get_LocalTimestamp(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::NetworkTimestamp() const
    {
        winrt::Windows::Foundation::DateTime value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_NetworkTimestamp(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->get_NetworkTimestamp(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::Recipients() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Recipients(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->get_Recipients(&value));
        }
        return winrt::Windows::Foundation::Collections::IVector<hstring>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::RecipientSendStatuses() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RecipientSendStatuses(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->get_RecipientSendStatuses(&value));
        }
        return winrt::Windows::Foundation::Collections::IMapView<hstring, winrt::Windows::ApplicationModel::Chat::ChatMessageStatus>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::Status() const
    {
        winrt::Windows::ApplicationModel::Chat::ChatMessageStatus value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::Subject() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Subject(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->get_Subject(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::TransportFriendlyName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransportFriendlyName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->get_TransportFriendlyName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::TransportId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransportId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->get_TransportId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage<D>::TransportId(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TransportId(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage>**)this;
            check_hresult(_winrt_abi_type->put_TransportId(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::EstimatedDownloadSize() const
    {
        uint64_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_EstimatedDownloadSize(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->get_EstimatedDownloadSize(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::EstimatedDownloadSize(uint64_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_EstimatedDownloadSize(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_EstimatedDownloadSize(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::From(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_From(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_From(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::IsAutoReply() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsAutoReply(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->get_IsAutoReply(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::IsAutoReply(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsAutoReply(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_IsAutoReply(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::IsForwardingDisabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsForwardingDisabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_IsForwardingDisabled(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::IsReplyDisabled() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsReplyDisabled(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->get_IsReplyDisabled(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::IsIncoming(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsIncoming(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_IsIncoming(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::IsRead(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsRead(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_IsRead(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::IsSeen() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsSeen(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->get_IsSeen(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::IsSeen(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsSeen(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_IsSeen(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::IsSimMessage() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsSimMessage(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->get_IsSimMessage(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::LocalTimestamp(winrt::Windows::Foundation::DateTime const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_LocalTimestamp(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_LocalTimestamp(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::MessageKind() const
    {
        winrt::Windows::ApplicationModel::Chat::ChatMessageKind result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MessageKind(reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->get_MessageKind(reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::MessageKind(winrt::Windows::ApplicationModel::Chat::ChatMessageKind const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MessageKind(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_MessageKind(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::MessageOperatorKind() const
    {
        winrt::Windows::ApplicationModel::Chat::ChatMessageOperatorKind result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MessageOperatorKind(reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->get_MessageOperatorKind(reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::MessageOperatorKind(winrt::Windows::ApplicationModel::Chat::ChatMessageOperatorKind const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MessageOperatorKind(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_MessageOperatorKind(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::NetworkTimestamp(winrt::Windows::Foundation::DateTime const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_NetworkTimestamp(impl::bind_in(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_NetworkTimestamp(impl::bind_in(value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::IsReceivedDuringQuietHours() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsReceivedDuringQuietHours(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->get_IsReceivedDuringQuietHours(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::IsReceivedDuringQuietHours(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsReceivedDuringQuietHours(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_IsReceivedDuringQuietHours(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::RemoteId(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RemoteId(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_RemoteId(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::Status(winrt::Windows::ApplicationModel::Chat::ChatMessageStatus const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Status(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_Status(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::Subject(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Subject(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_Subject(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::ShouldSuppressNotification() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ShouldSuppressNotification(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->get_ShouldSuppressNotification(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::ShouldSuppressNotification(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ShouldSuppressNotification(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_ShouldSuppressNotification(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::ThreadingInfo() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ThreadingInfo(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->get_ThreadingInfo(&result));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatConversationThreadingInfo{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::ThreadingInfo(winrt::Windows::ApplicationModel::Chat::ChatConversationThreadingInfo const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ThreadingInfo(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->put_ThreadingInfo(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage2<D>::RecipientsDeliveryInfos() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RecipientsDeliveryInfos(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage2>**)this;
            check_hresult(_winrt_abi_type->get_RecipientsDeliveryInfos(&result));
        }
        return winrt::Windows::Foundation::Collections::IVector<winrt::Windows::ApplicationModel::Chat::ChatRecipientDeliveryInfo>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage3<D>::RemoteId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RemoteId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage3>**)this;
            check_hresult(_winrt_abi_type->get_RemoteId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage4<D>::SyncId() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SyncId(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage4>**)this;
            check_hresult(_winrt_abi_type->get_SyncId(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessage4<D>::SyncId(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessage4>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessage4, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage4>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_SyncId(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessage4>**)this;
            check_hresult(_winrt_abi_type->put_SyncId(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageAttachment<D>::DataStreamReference() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DataStreamReference(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>**)this;
            check_hresult(_winrt_abi_type->get_DataStreamReference(&value));
        }
        return winrt::Windows::Storage::Streams::IRandomAccessStreamReference{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageAttachment<D>::DataStreamReference(winrt::Windows::Storage::Streams::IRandomAccessStreamReference const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DataStreamReference(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>**)this;
            check_hresult(_winrt_abi_type->put_DataStreamReference(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageAttachment<D>::GroupId() const
    {
        uint32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_GroupId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>**)this;
            check_hresult(_winrt_abi_type->get_GroupId(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageAttachment<D>::GroupId(uint32_t value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_GroupId(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>**)this;
            check_hresult(_winrt_abi_type->put_GroupId(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageAttachment<D>::MimeType() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MimeType(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>**)this;
            check_hresult(_winrt_abi_type->get_MimeType(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageAttachment<D>::MimeType(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_MimeType(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>**)this;
            check_hresult(_winrt_abi_type->put_MimeType(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageAttachment<D>::Text() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Text(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>**)this;
            check_hresult(_winrt_abi_type->get_Text(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageAttachment<D>::Text(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Text(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>**)this;
            check_hresult(_winrt_abi_type->put_Text(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageAttachment2<D>::Thumbnail() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Thumbnail(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>**)this;
            check_hresult(_winrt_abi_type->get_Thumbnail(&result));
        }
        return winrt::Windows::Storage::Streams::IRandomAccessStreamReference{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageAttachment2<D>::Thumbnail(winrt::Windows::Storage::Streams::IRandomAccessStreamReference const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Thumbnail(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>**)this;
            check_hresult(_winrt_abi_type->put_Thumbnail(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageAttachment2<D>::TransferProgress() const
    {
        double result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransferProgress(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>**)this;
            check_hresult(_winrt_abi_type->get_TransferProgress(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageAttachment2<D>::TransferProgress(double value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TransferProgress(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>**)this;
            check_hresult(_winrt_abi_type->put_TransferProgress(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageAttachment2<D>::OriginalFileName() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_OriginalFileName(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>**)this;
            check_hresult(_winrt_abi_type->get_OriginalFileName(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageAttachment2<D>::OriginalFileName(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_OriginalFileName(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>**)this;
            check_hresult(_winrt_abi_type->put_OriginalFileName(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageAttachmentFactory<D>::CreateChatMessageAttachment(param::hstring const& mimeType, winrt::Windows::Storage::Streams::IRandomAccessStreamReference const& dataStreamReference) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachmentFactory>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachmentFactory, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachmentFactory>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CreateChatMessageAttachment(*(void**)(&mimeType), *(void**)(&dataStreamReference), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachmentFactory>**)this;
            check_hresult(_winrt_abi_type->CreateChatMessageAttachment(*(void**)(&mimeType), *(void**)(&dataStreamReference), &value));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatMessageAttachment{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageBlockingStatic<D>::MarkMessageAsBlockedAsync(param::hstring const& localChatMessageId, bool blocked) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageBlockingStatic>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageBlockingStatic, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageBlockingStatic>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MarkMessageAsBlockedAsync(*(void**)(&localChatMessageId), blocked, &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageBlockingStatic>**)this;
            check_hresult(_winrt_abi_type->MarkMessageAsBlockedAsync(*(void**)(&localChatMessageId), blocked, &value));
        }
        return winrt::Windows::Foundation::IAsyncAction{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageChange<D>::ChangeType() const
    {
        winrt::Windows::ApplicationModel::Chat::ChatMessageChangeType value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChange>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageChange, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChange>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChangeType(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChange>**)this;
            check_hresult(_winrt_abi_type->get_ChangeType(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageChange<D>::Message() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChange>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageChange, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChange>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Message(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChange>**)this;
            check_hresult(_winrt_abi_type->get_Message(&value));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatMessage{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageChangeReader<D>::AcceptChanges() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChangeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AcceptChanges());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeReader>**)this;
            check_hresult(_winrt_abi_type->AcceptChanges());
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageChangeReader<D>::AcceptChangesThrough(winrt::Windows::ApplicationModel::Chat::ChatMessageChange const& lastChangeToAcknowledge) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChangeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AcceptChangesThrough(*(void**)(&lastChangeToAcknowledge)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeReader>**)this;
            check_hresult(_winrt_abi_type->AcceptChangesThrough(*(void**)(&lastChangeToAcknowledge)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageChangeReader<D>::ReadBatchAsync() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChangeReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadBatchAsync(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeReader>**)this;
            check_hresult(_winrt_abi_type->ReadBatchAsync(&value));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::ChatMessageChange>>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageChangeTracker<D>::Enable() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChangeTracker>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeTracker, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeTracker>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Enable());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeTracker>**)this;
            check_hresult(_winrt_abi_type->Enable());
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageChangeTracker<D>::GetChangeReader() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChangeTracker>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeTracker, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeTracker>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetChangeReader(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeTracker>**)this;
            check_hresult(_winrt_abi_type->GetChangeReader(&value));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatMessageChangeReader{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageChangeTracker<D>::Reset() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChangeTracker>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeTracker, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeTracker>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Reset());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeTracker>**)this;
            check_hresult(_winrt_abi_type->Reset());
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageChangedDeferral<D>::Complete() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChangedDeferral>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageChangedDeferral, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChangedDeferral>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Complete());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChangedDeferral>**)this;
            check_hresult(_winrt_abi_type->Complete());
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageChangedEventArgs<D>::GetDeferral() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeferral(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->GetDeferral(&result));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatMessageChangedDeferral{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageManager2Statics<D>::RegisterTransportAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageManager2Statics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageManager2Statics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageManager2Statics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RegisterTransportAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageManager2Statics>**)this;
            check_hresult(_winrt_abi_type->RegisterTransportAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<hstring>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageManager2Statics<D>::GetTransportAsync(param::hstring const& transportId) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageManager2Statics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageManager2Statics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageManager2Statics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetTransportAsync(*(void**)(&transportId), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageManager2Statics>**)this;
            check_hresult(_winrt_abi_type->GetTransportAsync(*(void**)(&transportId), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatMessageTransport>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageManagerStatic<D>::GetTransportsAsync() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetTransportsAsync(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic>**)this;
            check_hresult(_winrt_abi_type->GetTransportsAsync(&value));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::ChatMessageTransport>>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageManagerStatic<D>::RequestStoreAsync() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestStoreAsync(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic>**)this;
            check_hresult(_winrt_abi_type->RequestStoreAsync(&value));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatMessageStore>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageManagerStatic<D>::ShowComposeSmsMessageAsync(winrt::Windows::ApplicationModel::Chat::ChatMessage const& message) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ShowComposeSmsMessageAsync(*(void**)(&message), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic>**)this;
            check_hresult(_winrt_abi_type->ShowComposeSmsMessageAsync(*(void**)(&message), &value));
        }
        return winrt::Windows::Foundation::IAsyncAction{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageManagerStatic<D>::ShowSmsSettings() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ShowSmsSettings());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic>**)this;
            check_hresult(_winrt_abi_type->ShowSmsSettings());
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageManagerStatics3<D>::RequestSyncManagerAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatics3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatics3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatics3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestSyncManagerAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatics3>**)this;
            check_hresult(_winrt_abi_type->RequestSyncManagerAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatSyncManager>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageNotificationTriggerDetails<D>::ChatMessage() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChatMessage(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails>**)this;
            check_hresult(_winrt_abi_type->get_ChatMessage(&value));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatMessage{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageNotificationTriggerDetails2<D>::ShouldDisplayToast() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ShouldDisplayToast(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2>**)this;
            check_hresult(_winrt_abi_type->get_ShouldDisplayToast(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageNotificationTriggerDetails2<D>::ShouldUpdateDetailText() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ShouldUpdateDetailText(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2>**)this;
            check_hresult(_winrt_abi_type->get_ShouldUpdateDetailText(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageNotificationTriggerDetails2<D>::ShouldUpdateBadge() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ShouldUpdateBadge(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2>**)this;
            check_hresult(_winrt_abi_type->get_ShouldUpdateBadge(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageNotificationTriggerDetails2<D>::ShouldUpdateActionCenter() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ShouldUpdateActionCenter(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2>**)this;
            check_hresult(_winrt_abi_type->get_ShouldUpdateActionCenter(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageReader<D>::ReadBatchAsync() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadBatchAsync(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageReader>**)this;
            check_hresult(_winrt_abi_type->ReadBatchAsync(&value));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::ChatMessage>>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageReader2<D>::ReadBatchAsync(int32_t count) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageReader2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageReader2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageReader2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadBatchWithCountAsync(count, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageReader2>**)this;
            check_hresult(_winrt_abi_type->ReadBatchWithCountAsync(count, &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::ChatMessage>>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore<D>::ChangeTracker() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChangeTracker(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)this;
            check_hresult(_winrt_abi_type->get_ChangeTracker(&value));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatMessageChangeTracker{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore<D>::DeleteMessageAsync(param::hstring const& localMessageId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DeleteMessageAsync(*(void**)(&localMessageId), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)this;
            check_hresult(_winrt_abi_type->DeleteMessageAsync(*(void**)(&localMessageId), &value));
        }
        return winrt::Windows::Foundation::IAsyncAction{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore<D>::DownloadMessageAsync(param::hstring const& localChatMessageId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->DownloadMessageAsync(*(void**)(&localChatMessageId), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)this;
            check_hresult(_winrt_abi_type->DownloadMessageAsync(*(void**)(&localChatMessageId), &value));
        }
        return winrt::Windows::Foundation::IAsyncAction{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore<D>::GetMessageAsync(param::hstring const& localChatMessageId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetMessageAsync(*(void**)(&localChatMessageId), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)this;
            check_hresult(_winrt_abi_type->GetMessageAsync(*(void**)(&localChatMessageId), &value));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatMessage>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore<D>::GetMessageReader() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetMessageReader1(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)this;
            check_hresult(_winrt_abi_type->GetMessageReader1(&value));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatMessageReader{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore<D>::GetMessageReader(winrt::Windows::Foundation::TimeSpan const& recentTimeLimit) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetMessageReader2(impl::bind_in(recentTimeLimit), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)this;
            check_hresult(_winrt_abi_type->GetMessageReader2(impl::bind_in(recentTimeLimit), &value));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatMessageReader{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore<D>::MarkMessageReadAsync(param::hstring const& localChatMessageId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MarkMessageReadAsync(*(void**)(&localChatMessageId), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)this;
            check_hresult(_winrt_abi_type->MarkMessageReadAsync(*(void**)(&localChatMessageId), &value));
        }
        return winrt::Windows::Foundation::IAsyncAction{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore<D>::RetrySendMessageAsync(param::hstring const& localChatMessageId) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RetrySendMessageAsync(*(void**)(&localChatMessageId), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)this;
            check_hresult(_winrt_abi_type->RetrySendMessageAsync(*(void**)(&localChatMessageId), &value));
        }
        return winrt::Windows::Foundation::IAsyncAction{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore<D>::SendMessageAsync(winrt::Windows::ApplicationModel::Chat::ChatMessage const& chatMessage) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SendMessageAsync(*(void**)(&chatMessage), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)this;
            check_hresult(_winrt_abi_type->SendMessageAsync(*(void**)(&chatMessage), &value));
        }
        return winrt::Windows::Foundation::IAsyncAction{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore<D>::ValidateMessage(winrt::Windows::ApplicationModel::Chat::ChatMessage const& chatMessage) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ValidateMessage(*(void**)(&chatMessage), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)this;
            check_hresult(_winrt_abi_type->ValidateMessage(*(void**)(&chatMessage), &value));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatMessageValidationResult{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore<D>::MessageChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Chat::ChatMessageStore, winrt::Windows::ApplicationModel::Chat::ChatMessageChangedEventArgs> const& value) const
    {
        winrt::event_token returnValue{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_MessageChanged(*(void**)(&value), put_abi(returnValue)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)this;
            check_hresult(_winrt_abi_type->add_MessageChanged(*(void**)(&value), put_abi(returnValue)));
        }
        return returnValue;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore<D>::MessageChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Chat::ChatMessageStore, winrt::Windows::ApplicationModel::Chat::ChatMessageChangedEventArgs> const& value) const
    {
        return impl::make_event_revoker<D, MessageChanged_revoker>(this, MessageChanged(value));
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore<D>::MessageChanged(winrt::event_token const& value) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)&_winrt_casted_result;
            _winrt_abi_type->remove_MessageChanged(impl::bind_in(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore>**)this;
            _winrt_abi_type->remove_MessageChanged(impl::bind_in(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::ForwardMessageAsync(param::hstring const& localChatMessageId, param::async_iterable<hstring> const& addresses) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ForwardMessageAsync(*(void**)(&localChatMessageId), *(void**)(&addresses), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            check_hresult(_winrt_abi_type->ForwardMessageAsync(*(void**)(&localChatMessageId), *(void**)(&addresses), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatMessage>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::GetConversationAsync(param::hstring const& conversationId) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetConversationAsync(*(void**)(&conversationId), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            check_hresult(_winrt_abi_type->GetConversationAsync(*(void**)(&conversationId), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatConversation>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::GetConversationAsync(param::hstring const& conversationId, param::async_iterable<hstring> const& transportIds) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetConversationForTransportsAsync(*(void**)(&conversationId), *(void**)(&transportIds), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            check_hresult(_winrt_abi_type->GetConversationForTransportsAsync(*(void**)(&conversationId), *(void**)(&transportIds), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatConversation>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::GetConversationFromThreadingInfoAsync(winrt::Windows::ApplicationModel::Chat::ChatConversationThreadingInfo const& threadingInfo) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetConversationFromThreadingInfoAsync(*(void**)(&threadingInfo), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            check_hresult(_winrt_abi_type->GetConversationFromThreadingInfoAsync(*(void**)(&threadingInfo), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatConversation>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::GetConversationReader() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetConversationReader(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            check_hresult(_winrt_abi_type->GetConversationReader(&result));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatConversationReader{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::GetConversationReader(param::iterable<hstring> const& transportIds) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetConversationForTransportsReader(*(void**)(&transportIds), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            check_hresult(_winrt_abi_type->GetConversationForTransportsReader(*(void**)(&transportIds), &result));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatConversationReader{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::GetMessageByRemoteIdAsync(param::hstring const& transportId, param::hstring const& remoteId) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetMessageByRemoteIdAsync(*(void**)(&transportId), *(void**)(&remoteId), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            check_hresult(_winrt_abi_type->GetMessageByRemoteIdAsync(*(void**)(&transportId), *(void**)(&remoteId), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatMessage>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::GetUnseenCountAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetUnseenCountAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            check_hresult(_winrt_abi_type->GetUnseenCountAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<int32_t>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::GetUnseenCountAsync(param::async_iterable<hstring> const& transportIds) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetUnseenCountForTransportsReaderAsync(*(void**)(&transportIds), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            check_hresult(_winrt_abi_type->GetUnseenCountForTransportsReaderAsync(*(void**)(&transportIds), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<int32_t>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::MarkAsSeenAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MarkAsSeenAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            check_hresult(_winrt_abi_type->MarkAsSeenAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::MarkAsSeenAsync(param::async_iterable<hstring> const& transportIds) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->MarkAsSeenForTransportsAsync(*(void**)(&transportIds), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            check_hresult(_winrt_abi_type->MarkAsSeenForTransportsAsync(*(void**)(&transportIds), &result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::GetSearchReader(winrt::Windows::ApplicationModel::Chat::ChatQueryOptions const& value) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetSearchReader(*(void**)(&value), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            check_hresult(_winrt_abi_type->GetSearchReader(*(void**)(&value), &result));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatSearchReader{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::SaveMessageAsync(winrt::Windows::ApplicationModel::Chat::ChatMessage const& chatMessage) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SaveMessageAsync(*(void**)(&chatMessage), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            check_hresult(_winrt_abi_type->SaveMessageAsync(*(void**)(&chatMessage), &result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::TryCancelDownloadMessageAsync(param::hstring const& localChatMessageId) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryCancelDownloadMessageAsync(*(void**)(&localChatMessageId), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            check_hresult(_winrt_abi_type->TryCancelDownloadMessageAsync(*(void**)(&localChatMessageId), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::TryCancelSendMessageAsync(param::hstring const& localChatMessageId) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TryCancelSendMessageAsync(*(void**)(&localChatMessageId), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            check_hresult(_winrt_abi_type->TryCancelSendMessageAsync(*(void**)(&localChatMessageId), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<bool>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::StoreChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Chat::ChatMessageStore, winrt::Windows::ApplicationModel::Chat::ChatMessageStoreChangedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_StoreChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            check_hresult(_winrt_abi_type->add_StoreChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::StoreChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Chat::ChatMessageStore, winrt::Windows::ApplicationModel::Chat::ChatMessageStoreChangedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, StoreChanged_revoker>(this, StoreChanged(handler));
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore2<D>::StoreChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)&_winrt_casted_result;
            _winrt_abi_type->remove_StoreChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>**)this;
            _winrt_abi_type->remove_StoreChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStore3<D>::GetMessageBySyncIdAsync(param::hstring const& syncId) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore3>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStore3, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore3>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetMessageBySyncIdAsync(*(void**)(&syncId), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStore3>**)this;
            check_hresult(_winrt_abi_type->GetMessageBySyncIdAsync(*(void**)(&syncId), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatMessage>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStoreChangedEventArgs<D>::Id() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStoreChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStoreChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStoreChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStoreChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Id(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageStoreChangedEventArgs<D>::Kind() const
    {
        winrt::Windows::ApplicationModel::Chat::ChatStoreChangedEventKind result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStoreChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageStoreChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStoreChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Kind(reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageStoreChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Kind(reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageTransport<D>::IsAppSetAsNotificationProvider() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsAppSetAsNotificationProvider(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport>**)this;
            check_hresult(_winrt_abi_type->get_IsAppSetAsNotificationProvider(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageTransport<D>::IsActive() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsActive(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport>**)this;
            check_hresult(_winrt_abi_type->get_IsActive(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageTransport<D>::TransportFriendlyName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransportFriendlyName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport>**)this;
            check_hresult(_winrt_abi_type->get_TransportFriendlyName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageTransport<D>::TransportId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransportId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport>**)this;
            check_hresult(_winrt_abi_type->get_TransportId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageTransport<D>::RequestSetAsNotificationProviderAsync() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RequestSetAsNotificationProviderAsync(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport>**)this;
            check_hresult(_winrt_abi_type->RequestSetAsNotificationProviderAsync(&value));
        }
        return winrt::Windows::Foundation::IAsyncAction{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageTransport2<D>::Configuration() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransport2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Configuration(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport2>**)this;
            check_hresult(_winrt_abi_type->get_Configuration(&result));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatMessageTransportConfiguration{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageTransport2<D>::TransportKind() const
    {
        winrt::Windows::ApplicationModel::Chat::ChatMessageTransportKind result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransport2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransportKind(reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport2>**)this;
            check_hresult(_winrt_abi_type->get_TransportKind(reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageTransportConfiguration<D>::MaxAttachmentCount() const
    {
        int32_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxAttachmentCount(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_MaxAttachmentCount(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageTransportConfiguration<D>::MaxMessageSizeInKilobytes() const
    {
        int32_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxMessageSizeInKilobytes(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_MaxMessageSizeInKilobytes(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageTransportConfiguration<D>::MaxRecipientCount() const
    {
        int32_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxRecipientCount(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_MaxRecipientCount(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageTransportConfiguration<D>::SupportedVideoFormat() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SupportedVideoFormat(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_SupportedVideoFormat(&result));
        }
        return winrt::Windows::Media::MediaProperties::MediaEncodingProfile{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageTransportConfiguration<D>::ExtendedProperties() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExtendedProperties(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_ExtendedProperties(&result));
        }
        return winrt::Windows::Foundation::Collections::IMapView<hstring, winrt::Windows::Foundation::IInspectable>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageValidationResult<D>::MaxPartCount() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxPartCount(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult>**)this;
            check_hresult(_winrt_abi_type->get_MaxPartCount(&value));
        }
        return winrt::Windows::Foundation::IReference<uint32_t>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageValidationResult<D>::PartCount() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_PartCount(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult>**)this;
            check_hresult(_winrt_abi_type->get_PartCount(&value));
        }
        return winrt::Windows::Foundation::IReference<uint32_t>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageValidationResult<D>::RemainingCharacterCountInPart() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RemainingCharacterCountInPart(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult>**)this;
            check_hresult(_winrt_abi_type->get_RemainingCharacterCountInPart(&value));
        }
        return winrt::Windows::Foundation::IReference<uint32_t>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatMessageValidationResult<D>::Status() const
    {
        winrt::Windows::ApplicationModel::Chat::ChatMessageValidationStatus value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult>**)this;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatQueryOptions<D>::SearchString() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatQueryOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatQueryOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatQueryOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SearchString(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatQueryOptions>**)this;
            check_hresult(_winrt_abi_type->get_SearchString(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatQueryOptions<D>::SearchString(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatQueryOptions>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatQueryOptions, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatQueryOptions>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_SearchString(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatQueryOptions>**)this;
            check_hresult(_winrt_abi_type->put_SearchString(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatRecipientDeliveryInfo<D>::TransportAddress() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransportAddress(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)this;
            check_hresult(_winrt_abi_type->get_TransportAddress(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatRecipientDeliveryInfo<D>::TransportAddress(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TransportAddress(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)this;
            check_hresult(_winrt_abi_type->put_TransportAddress(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatRecipientDeliveryInfo<D>::DeliveryTime() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_DeliveryTime(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)this;
            check_hresult(_winrt_abi_type->get_DeliveryTime(&result));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::DateTime>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatRecipientDeliveryInfo<D>::DeliveryTime(winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::DateTime> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_DeliveryTime(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)this;
            check_hresult(_winrt_abi_type->put_DeliveryTime(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatRecipientDeliveryInfo<D>::ReadTime() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ReadTime(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)this;
            check_hresult(_winrt_abi_type->get_ReadTime(&result));
        }
        return winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::DateTime>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatRecipientDeliveryInfo<D>::ReadTime(winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::DateTime> const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ReadTime(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)this;
            check_hresult(_winrt_abi_type->put_ReadTime(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatRecipientDeliveryInfo<D>::TransportErrorCodeCategory() const
    {
        winrt::Windows::ApplicationModel::Chat::ChatTransportErrorCodeCategory result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransportErrorCodeCategory(reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)this;
            check_hresult(_winrt_abi_type->get_TransportErrorCodeCategory(reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatRecipientDeliveryInfo<D>::TransportInterpretedErrorCode() const
    {
        winrt::Windows::ApplicationModel::Chat::ChatTransportInterpretedErrorCode result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransportInterpretedErrorCode(reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)this;
            check_hresult(_winrt_abi_type->get_TransportInterpretedErrorCode(reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatRecipientDeliveryInfo<D>::TransportErrorCode() const
    {
        int32_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransportErrorCode(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)this;
            check_hresult(_winrt_abi_type->get_TransportErrorCode(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatRecipientDeliveryInfo<D>::IsErrorPermanent() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsErrorPermanent(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)this;
            check_hresult(_winrt_abi_type->get_IsErrorPermanent(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatRecipientDeliveryInfo<D>::Status() const
    {
        winrt::Windows::ApplicationModel::Chat::ChatMessageStatus result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>**)this;
            check_hresult(_winrt_abi_type->get_Status(reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatSearchReader<D>::ReadBatchAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatSearchReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatSearchReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSearchReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadBatchAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSearchReader>**)this;
            check_hresult(_winrt_abi_type->ReadBatchAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::IChatItem>>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatSearchReader<D>::ReadBatchAsync(int32_t count) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatSearchReader>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatSearchReader, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSearchReader>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadBatchWithCountAsync(count, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSearchReader>**)this;
            check_hresult(_winrt_abi_type->ReadBatchWithCountAsync(count, &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::IChatItem>>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatSyncConfiguration<D>::IsSyncEnabled() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsSyncEnabled(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_IsSyncEnabled(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatSyncConfiguration<D>::IsSyncEnabled(bool value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_IsSyncEnabled(value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration>**)this;
            check_hresult(_winrt_abi_type->put_IsSyncEnabled(value));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatSyncConfiguration<D>::RestoreHistorySpan() const
    {
        winrt::Windows::ApplicationModel::Chat::ChatRestoreHistorySpan result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_RestoreHistorySpan(reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_RestoreHistorySpan(reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatSyncConfiguration<D>::RestoreHistorySpan(winrt::Windows::ApplicationModel::Chat::ChatRestoreHistorySpan const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_RestoreHistorySpan(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration>**)this;
            check_hresult(_winrt_abi_type->put_RestoreHistorySpan(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatSyncManager<D>::Configuration() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatSyncManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatSyncManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Configuration(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncManager>**)this;
            check_hresult(_winrt_abi_type->get_Configuration(&result));
        }
        return winrt::Windows::ApplicationModel::Chat::ChatSyncConfiguration{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatSyncManager<D>::AssociateAccountAsync(winrt::Windows::Security::Credentials::WebAccount const& webAccount) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatSyncManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatSyncManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AssociateAccountAsync(*(void**)(&webAccount), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncManager>**)this;
            check_hresult(_winrt_abi_type->AssociateAccountAsync(*(void**)(&webAccount), &result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatSyncManager<D>::UnassociateAccountAsync() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatSyncManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatSyncManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->UnassociateAccountAsync(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncManager>**)this;
            check_hresult(_winrt_abi_type->UnassociateAccountAsync(&result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatSyncManager<D>::IsAccountAssociated(winrt::Windows::Security::Credentials::WebAccount const& webAccount) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatSyncManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatSyncManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->IsAccountAssociated(*(void**)(&webAccount), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncManager>**)this;
            check_hresult(_winrt_abi_type->IsAccountAssociated(*(void**)(&webAccount), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatSyncManager<D>::StartSync() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatSyncManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatSyncManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->StartSync());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncManager>**)this;
            check_hresult(_winrt_abi_type->StartSync());
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IChatSyncManager<D>::SetConfigurationAsync(winrt::Windows::ApplicationModel::Chat::ChatSyncConfiguration const& configuration) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IChatSyncManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IChatSyncManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SetConfigurationAsync(*(void**)(&configuration), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IChatSyncManager>**)this;
            check_hresult(_winrt_abi_type->SetConfigurationAsync(*(void**)(&configuration), &result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsEndUserMessage<D>::TransportId() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransportId(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>**)this;
            check_hresult(_winrt_abi_type->get_TransportId(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsEndUserMessage<D>::Title() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Title(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>**)this;
            check_hresult(_winrt_abi_type->get_Title(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsEndUserMessage<D>::Text() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Text(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>**)this;
            check_hresult(_winrt_abi_type->get_Text(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsEndUserMessage<D>::IsPinRequired() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsPinRequired(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>**)this;
            check_hresult(_winrt_abi_type->get_IsPinRequired(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsEndUserMessage<D>::Actions() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Actions(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>**)this;
            check_hresult(_winrt_abi_type->get_Actions(&result));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageAction>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsEndUserMessage<D>::SendResponseAsync(winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageAction const& action) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SendResponseAsync(*(void**)(&action), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>**)this;
            check_hresult(_winrt_abi_type->SendResponseAsync(*(void**)(&action), &result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsEndUserMessage<D>::SendResponseWithPinAsync(winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageAction const& action, param::hstring const& pin) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->SendResponseWithPinAsync(*(void**)(&action), *(void**)(&pin), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>**)this;
            check_hresult(_winrt_abi_type->SendResponseWithPinAsync(*(void**)(&action), *(void**)(&pin), &result));
        }
        return winrt::Windows::Foundation::IAsyncAction{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsEndUserMessageAction<D>::Label() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAction>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAction, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAction>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Label(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAction>**)this;
            check_hresult(_winrt_abi_type->get_Label(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsEndUserMessageAvailableEventArgs<D>::IsMessageAvailable() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsMessageAvailable(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_IsMessageAvailable(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsEndUserMessageAvailableEventArgs<D>::Message() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Message(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Message(&result));
        }
        return winrt::Windows::ApplicationModel::Chat::RcsEndUserMessage{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsEndUserMessageAvailableTriggerDetails<D>::Title() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableTriggerDetails>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableTriggerDetails, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableTriggerDetails>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Title(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableTriggerDetails>**)this;
            check_hresult(_winrt_abi_type->get_Title(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsEndUserMessageAvailableTriggerDetails<D>::Text() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableTriggerDetails>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableTriggerDetails, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableTriggerDetails>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Text(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableTriggerDetails>**)this;
            check_hresult(_winrt_abi_type->get_Text(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsEndUserMessageManager<D>::MessageAvailableChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageManager, winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageAvailableEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageManager>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_MessageAvailableChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageManager>**)this;
            check_hresult(_winrt_abi_type->add_MessageAvailableChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsEndUserMessageManager<D>::MessageAvailableChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageManager, winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageAvailableEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, MessageAvailableChanged_revoker>(this, MessageAvailableChanged(handler));
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsEndUserMessageManager<D>::MessageAvailableChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageManager>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageManager, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageManager>**)&_winrt_casted_result;
            _winrt_abi_type->remove_MessageAvailableChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageManager>**)this;
            _winrt_abi_type->remove_MessageAvailableChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsManagerStatics<D>::GetEndUserMessageManager() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetEndUserMessageManager(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics>**)this;
            check_hresult(_winrt_abi_type->GetEndUserMessageManager(&result));
        }
        return winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageManager{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsManagerStatics<D>::GetTransportsAsync() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetTransportsAsync(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics>**)this;
            check_hresult(_winrt_abi_type->GetTransportsAsync(&value));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::RcsTransport>>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsManagerStatics<D>::GetTransportAsync(param::hstring const& transportId) const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetTransportAsync(*(void**)(&transportId), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics>**)this;
            check_hresult(_winrt_abi_type->GetTransportAsync(*(void**)(&transportId), &result));
        }
        return winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::RcsTransport>{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsManagerStatics<D>::LeaveConversationAsync(winrt::Windows::ApplicationModel::Chat::ChatConversation const& conversation) const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->LeaveConversationAsync(*(void**)(&conversation), &value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics>**)this;
            check_hresult(_winrt_abi_type->LeaveConversationAsync(*(void**)(&conversation), &value));
        }
        return winrt::Windows::Foundation::IAsyncAction{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsManagerStatics2<D>::TransportListChanged(winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics2>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_TransportListChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics2>**)this;
            check_hresult(_winrt_abi_type->add_TransportListChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsManagerStatics2<D>::TransportListChanged(auto_revoke_t, winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, TransportListChanged_revoker>(this, TransportListChanged(handler));
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsManagerStatics2<D>::TransportListChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics2>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics2, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics2>**)&_winrt_casted_result;
            _winrt_abi_type->remove_TransportListChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics2>**)this;
            _winrt_abi_type->remove_TransportListChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsServiceKindSupportedChangedEventArgs<D>::ServiceKind() const
    {
        winrt::Windows::ApplicationModel::Chat::RcsServiceKind result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsServiceKindSupportedChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsServiceKindSupportedChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsServiceKindSupportedChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ServiceKind(reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsServiceKindSupportedChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_ServiceKind(reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsTransport<D>::ExtendedProperties() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsTransport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsTransport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ExtendedProperties(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)this;
            check_hresult(_winrt_abi_type->get_ExtendedProperties(&value));
        }
        return winrt::Windows::Foundation::Collections::IMapView<hstring, winrt::Windows::Foundation::IInspectable>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsTransport<D>::IsActive() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsTransport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsTransport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsActive(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)this;
            check_hresult(_winrt_abi_type->get_IsActive(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsTransport<D>::TransportFriendlyName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsTransport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsTransport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransportFriendlyName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)this;
            check_hresult(_winrt_abi_type->get_TransportFriendlyName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsTransport<D>::TransportId() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsTransport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsTransport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransportId(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)this;
            check_hresult(_winrt_abi_type->get_TransportId(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsTransport<D>::Configuration() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsTransport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsTransport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Configuration(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)this;
            check_hresult(_winrt_abi_type->get_Configuration(&result));
        }
        return winrt::Windows::ApplicationModel::Chat::RcsTransportConfiguration{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsTransport<D>::IsStoreAndForwardEnabled(winrt::Windows::ApplicationModel::Chat::RcsServiceKind const& serviceKind) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsTransport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsTransport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->IsStoreAndForwardEnabled(static_cast<int32_t>(serviceKind), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)this;
            check_hresult(_winrt_abi_type->IsStoreAndForwardEnabled(static_cast<int32_t>(serviceKind), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsTransport<D>::IsServiceKindSupported(winrt::Windows::ApplicationModel::Chat::RcsServiceKind const& serviceKind) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsTransport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsTransport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->IsServiceKindSupported(static_cast<int32_t>(serviceKind), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)this;
            check_hresult(_winrt_abi_type->IsServiceKindSupported(static_cast<int32_t>(serviceKind), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsTransport<D>::ServiceKindSupportedChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Chat::RcsTransport, winrt::Windows::ApplicationModel::Chat::RcsServiceKindSupportedChangedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsTransport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsTransport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_ServiceKindSupportedChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)this;
            check_hresult(_winrt_abi_type->add_ServiceKindSupportedChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsTransport<D>::ServiceKindSupportedChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Chat::RcsTransport, winrt::Windows::ApplicationModel::Chat::RcsServiceKindSupportedChangedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, ServiceKindSupportedChanged_revoker>(this, ServiceKindSupportedChanged(handler));
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsTransport<D>::ServiceKindSupportedChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsTransport>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsTransport, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)&_winrt_casted_result;
            _winrt_abi_type->remove_ServiceKindSupportedChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransport>**)this;
            _winrt_abi_type->remove_ServiceKindSupportedChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsTransportConfiguration<D>::MaxAttachmentCount() const
    {
        int32_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxAttachmentCount(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_MaxAttachmentCount(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsTransportConfiguration<D>::MaxMessageSizeInKilobytes() const
    {
        int32_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxMessageSizeInKilobytes(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_MaxMessageSizeInKilobytes(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsTransportConfiguration<D>::MaxGroupMessageSizeInKilobytes() const
    {
        int32_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxGroupMessageSizeInKilobytes(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_MaxGroupMessageSizeInKilobytes(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsTransportConfiguration<D>::MaxRecipientCount() const
    {
        int32_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxRecipientCount(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_MaxRecipientCount(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsTransportConfiguration<D>::MaxFileSizeInKilobytes() const
    {
        int32_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxFileSizeInKilobytes(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_MaxFileSizeInKilobytes(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRcsTransportConfiguration<D>::WarningFileSizeInKilobytes() const
    {
        int32_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_WarningFileSizeInKilobytes(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>**)this;
            check_hresult(_winrt_abi_type->get_WarningFileSizeInKilobytes(&result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRemoteParticipantComposingChangedEventArgs<D>::TransportId() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRemoteParticipantComposingChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRemoteParticipantComposingChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRemoteParticipantComposingChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TransportId(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRemoteParticipantComposingChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_TransportId(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRemoteParticipantComposingChangedEventArgs<D>::ParticipantAddress() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRemoteParticipantComposingChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRemoteParticipantComposingChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRemoteParticipantComposingChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ParticipantAddress(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRemoteParticipantComposingChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_ParticipantAddress(&result));
        }
        return hstring{ result, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_ApplicationModel_Chat_IRemoteParticipantComposingChangedEventArgs<D>::IsComposing() const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::ApplicationModel::Chat::IRemoteParticipantComposingChangedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::ApplicationModel::Chat::IRemoteParticipantComposingChangedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRemoteParticipantComposingChangedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsComposing(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::ApplicationModel::Chat::IRemoteParticipantComposingChangedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_IsComposing(&result));
        }
        return result;
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatCapabilities> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatCapabilities>
    {
        int32_t __stdcall get_IsOnline(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsOnline());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsChatCapable(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsChatCapable());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsFileTransferCapable(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsFileTransferCapable());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsGeoLocationPushCapable(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsGeoLocationPushCapable());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsIntegratedMessagingCapable(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsIntegratedMessagingCapable());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics>
    {
        int32_t __stdcall GetCachedCapabilitiesAsync(void* address, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatCapabilities>>(this->shim().GetCachedCapabilitiesAsync(*reinterpret_cast<hstring const*>(&address)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetCapabilitiesFromNetworkAsync(void* address, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatCapabilities>>(this->shim().GetCapabilitiesFromNetworkAsync(*reinterpret_cast<hstring const*>(&address)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics2> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics2>
    {
        int32_t __stdcall GetCachedCapabilitiesForTransportAsync(void* address, void* transportId, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatCapabilities>>(this->shim().GetCachedCapabilitiesAsync(*reinterpret_cast<hstring const*>(&address), *reinterpret_cast<hstring const*>(&transportId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetCapabilitiesFromNetworkForTransportAsync(void* address, void* transportId, void** operation) noexcept final try
        {
            clear_abi(operation);
            typename D::abi_guard guard(this->shim());
            *operation = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatCapabilities>>(this->shim().GetCapabilitiesFromNetworkAsync(*reinterpret_cast<hstring const*>(&address), *reinterpret_cast<hstring const*>(&transportId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatConversation> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatConversation>
    {
        int32_t __stdcall get_HasUnreadMessages(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().HasUnreadMessages());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Id(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Subject(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().Subject());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Subject(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Subject(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsConversationMuted(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsConversationMuted());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsConversationMuted(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsConversationMuted(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MostRecentMessageId(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().MostRecentMessageId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Participants(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Collections::IVector<hstring>>(this->shim().Participants());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ThreadingInfo(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatConversationThreadingInfo>(this->shim().ThreadingInfo());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DeleteAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().DeleteAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetMessageReader(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessageReader>(this->shim().GetMessageReader());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall MarkAllMessagesAsReadAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().MarkMessagesAsReadAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall MarkMessagesAsReadAsync(int64_t value, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().MarkMessagesAsReadAsync(*reinterpret_cast<winrt::Windows::Foundation::DateTime const*>(&value)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SaveAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().SaveAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall NotifyLocalParticipantComposing(void* transportId, void* participantAddress, bool isComposing) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().NotifyLocalParticipantComposing(*reinterpret_cast<hstring const*>(&transportId), *reinterpret_cast<hstring const*>(&participantAddress), isComposing);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall NotifyRemoteParticipantComposing(void* transportId, void* participantAddress, bool isComposing) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().NotifyRemoteParticipantComposing(*reinterpret_cast<hstring const*>(&transportId), *reinterpret_cast<hstring const*>(&participantAddress), isComposing);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_RemoteParticipantComposingChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().RemoteParticipantComposingChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Chat::ChatConversation, winrt::Windows::ApplicationModel::Chat::RemoteParticipantComposingChangedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_RemoteParticipantComposingChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RemoteParticipantComposingChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatConversation2> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatConversation2>
    {
        int32_t __stdcall get_CanModifyParticipants(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().CanModifyParticipants());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_CanModifyParticipants(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().CanModifyParticipants(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatConversationReader> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatConversationReader>
    {
        int32_t __stdcall ReadBatchAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::ChatConversation>>>(this->shim().ReadBatchAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReadBatchWithCountAsync(int32_t count, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::ChatConversation>>>(this->shim().ReadBatchAsync(count));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo>
    {
        int32_t __stdcall get_ContactId(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().ContactId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ContactId(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ContactId(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Custom(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().Custom());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Custom(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Custom(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ConversationId(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().ConversationId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ConversationId(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ConversationId(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Participants(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Collections::IVector<hstring>>(this->shim().Participants());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Kind(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatConversationThreadingKind>(this->shim().Kind());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Kind(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Kind(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::ChatConversationThreadingKind const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatItem> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatItem>
    {
        int32_t __stdcall get_ItemKind(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatItemKind>(this->shim().ItemKind());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessage> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessage>
    {
        int32_t __stdcall get_Attachments(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVector<winrt::Windows::ApplicationModel::Chat::ChatMessageAttachment>>(this->shim().Attachments());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Body(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Body());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Body(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Body(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_From(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().From());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Id(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsForwardingDisabled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsForwardingDisabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsIncoming(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsIncoming());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsRead(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsRead());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_LocalTimestamp(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::DateTime>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::DateTime>(this->shim().LocalTimestamp());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_NetworkTimestamp(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::DateTime>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::DateTime>(this->shim().NetworkTimestamp());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Recipients(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVector<hstring>>(this->shim().Recipients());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RecipientSendStatuses(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IMapView<hstring, winrt::Windows::ApplicationModel::Chat::ChatMessageStatus>>(this->shim().RecipientSendStatuses());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Status(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessageStatus>(this->shim().Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Subject(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Subject());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransportFriendlyName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().TransportFriendlyName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransportId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().TransportId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TransportId(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TransportId(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessage2>
    {
        int32_t __stdcall get_EstimatedDownloadSize(uint64_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<uint64_t>(this->shim().EstimatedDownloadSize());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_EstimatedDownloadSize(uint64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().EstimatedDownloadSize(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_From(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().From(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsAutoReply(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsAutoReply());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsAutoReply(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsAutoReply(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsForwardingDisabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsForwardingDisabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsReplyDisabled(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsReplyDisabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsIncoming(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsIncoming(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsRead(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsRead(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsSeen(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsSeen());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsSeen(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsSeen(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsSimMessage(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsSimMessage());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_LocalTimestamp(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().LocalTimestamp(*reinterpret_cast<winrt::Windows::Foundation::DateTime const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MessageKind(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessageKind>(this->shim().MessageKind());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_MessageKind(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MessageKind(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::ChatMessageKind const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MessageOperatorKind(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessageOperatorKind>(this->shim().MessageOperatorKind());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_MessageOperatorKind(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MessageOperatorKind(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::ChatMessageOperatorKind const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_NetworkTimestamp(int64_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().NetworkTimestamp(*reinterpret_cast<winrt::Windows::Foundation::DateTime const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsReceivedDuringQuietHours(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsReceivedDuringQuietHours());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsReceivedDuringQuietHours(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsReceivedDuringQuietHours(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RemoteId(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RemoteId(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Status(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Status(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::ChatMessageStatus const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Subject(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Subject(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ShouldSuppressNotification(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().ShouldSuppressNotification());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ShouldSuppressNotification(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ShouldSuppressNotification(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ThreadingInfo(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatConversationThreadingInfo>(this->shim().ThreadingInfo());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ThreadingInfo(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ThreadingInfo(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::ChatConversationThreadingInfo const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RecipientsDeliveryInfos(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Collections::IVector<winrt::Windows::ApplicationModel::Chat::ChatRecipientDeliveryInfo>>(this->shim().RecipientsDeliveryInfos());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessage3> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessage3>
    {
        int32_t __stdcall get_RemoteId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().RemoteId());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessage4> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessage4>
    {
        int32_t __stdcall get_SyncId(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().SyncId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_SyncId(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SyncId(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment>
    {
        int32_t __stdcall get_DataStreamReference(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Streams::IRandomAccessStreamReference>(this->shim().DataStreamReference());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_DataStreamReference(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DataStreamReference(*reinterpret_cast<winrt::Windows::Storage::Streams::IRandomAccessStreamReference const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_GroupId(uint32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<uint32_t>(this->shim().GroupId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_GroupId(uint32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().GroupId(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MimeType(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().MimeType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_MimeType(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MimeType(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Text(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Text());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Text(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Text(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2>
    {
        int32_t __stdcall get_Thumbnail(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Storage::Streams::IRandomAccessStreamReference>(this->shim().Thumbnail());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Thumbnail(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Thumbnail(*reinterpret_cast<winrt::Windows::Storage::Streams::IRandomAccessStreamReference const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransferProgress(double* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<double>(this->shim().TransferProgress());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TransferProgress(double value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TransferProgress(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_OriginalFileName(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().OriginalFileName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_OriginalFileName(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().OriginalFileName(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachmentFactory> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageAttachmentFactory>
    {
        int32_t __stdcall CreateChatMessageAttachment(void* mimeType, void* dataStreamReference, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessageAttachment>(this->shim().CreateChatMessageAttachment(*reinterpret_cast<hstring const*>(&mimeType), *reinterpret_cast<winrt::Windows::Storage::Streams::IRandomAccessStreamReference const*>(&dataStreamReference)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageBlockingStatic> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageBlockingStatic>
    {
        int32_t __stdcall MarkMessageAsBlockedAsync(void* localChatMessageId, bool blocked, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().MarkMessageAsBlockedAsync(*reinterpret_cast<hstring const*>(&localChatMessageId), blocked));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChange> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChange>
    {
        int32_t __stdcall get_ChangeType(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessageChangeType>(this->shim().ChangeType());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Message(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessage>(this->shim().Message());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChangeReader> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChangeReader>
    {
        int32_t __stdcall AcceptChanges() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AcceptChanges();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AcceptChangesThrough(void* lastChangeToAcknowledge) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AcceptChangesThrough(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::ChatMessageChange const*>(&lastChangeToAcknowledge));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReadBatchAsync(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::ChatMessageChange>>>(this->shim().ReadBatchAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChangeTracker> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChangeTracker>
    {
        int32_t __stdcall Enable() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Enable();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetChangeReader(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessageChangeReader>(this->shim().GetChangeReader());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall Reset() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Reset();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChangedDeferral> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChangedDeferral>
    {
        int32_t __stdcall Complete() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Complete();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChangedEventArgs> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageChangedEventArgs>
    {
        int32_t __stdcall GetDeferral(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessageChangedDeferral>(this->shim().GetDeferral());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageManager2Statics> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageManager2Statics>
    {
        int32_t __stdcall RegisterTransportAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<hstring>>(this->shim().RegisterTransportAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetTransportAsync(void* transportId, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatMessageTransport>>(this->shim().GetTransportAsync(*reinterpret_cast<hstring const*>(&transportId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic>
    {
        int32_t __stdcall GetTransportsAsync(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::ChatMessageTransport>>>(this->shim().GetTransportsAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RequestStoreAsync(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatMessageStore>>(this->shim().RequestStoreAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ShowComposeSmsMessageAsync(void* message, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().ShowComposeSmsMessageAsync(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::ChatMessage const*>(&message)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ShowSmsSettings() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ShowSmsSettings();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatics3> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatics3>
    {
        int32_t __stdcall RequestSyncManagerAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatSyncManager>>(this->shim().RequestSyncManagerAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails>
    {
        int32_t __stdcall get_ChatMessage(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessage>(this->shim().ChatMessage());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2>
    {
        int32_t __stdcall get_ShouldDisplayToast(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().ShouldDisplayToast());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ShouldUpdateDetailText(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().ShouldUpdateDetailText());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ShouldUpdateBadge(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().ShouldUpdateBadge());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ShouldUpdateActionCenter(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().ShouldUpdateActionCenter());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageReader> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageReader>
    {
        int32_t __stdcall ReadBatchAsync(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::ChatMessage>>>(this->shim().ReadBatchAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageReader2> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageReader2>
    {
        int32_t __stdcall ReadBatchWithCountAsync(int32_t count, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::ChatMessage>>>(this->shim().ReadBatchAsync(count));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore>
    {
        int32_t __stdcall get_ChangeTracker(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessageChangeTracker>(this->shim().ChangeTracker());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DeleteMessageAsync(void* localMessageId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().DeleteMessageAsync(*reinterpret_cast<hstring const*>(&localMessageId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall DownloadMessageAsync(void* localChatMessageId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().DownloadMessageAsync(*reinterpret_cast<hstring const*>(&localChatMessageId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetMessageAsync(void* localChatMessageId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatMessage>>(this->shim().GetMessageAsync(*reinterpret_cast<hstring const*>(&localChatMessageId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetMessageReader1(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessageReader>(this->shim().GetMessageReader());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetMessageReader2(int64_t recentTimeLimit, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessageReader>(this->shim().GetMessageReader(*reinterpret_cast<winrt::Windows::Foundation::TimeSpan const*>(&recentTimeLimit)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall MarkMessageReadAsync(void* localChatMessageId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().MarkMessageReadAsync(*reinterpret_cast<hstring const*>(&localChatMessageId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RetrySendMessageAsync(void* localChatMessageId, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().RetrySendMessageAsync(*reinterpret_cast<hstring const*>(&localChatMessageId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SendMessageAsync(void* chatMessage, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().SendMessageAsync(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::ChatMessage const*>(&chatMessage)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ValidateMessage(void* chatMessage, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessageValidationResult>(this->shim().ValidateMessage(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::ChatMessage const*>(&chatMessage)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_MessageChanged(void* value, winrt::event_token* returnValue) noexcept final try
        {
            zero_abi<winrt::event_token>(returnValue);
            typename D::abi_guard guard(this->shim());
            *returnValue = detach_from<winrt::event_token>(this->shim().MessageChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Chat::ChatMessageStore, winrt::Windows::ApplicationModel::Chat::ChatMessageChangedEventArgs> const*>(&value)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_MessageChanged(winrt::event_token value) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MessageChanged(*reinterpret_cast<winrt::event_token const*>(&value));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore2>
    {
        int32_t __stdcall ForwardMessageAsync(void* localChatMessageId, void* addresses, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatMessage>>(this->shim().ForwardMessageAsync(*reinterpret_cast<hstring const*>(&localChatMessageId), *reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&addresses)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetConversationAsync(void* conversationId, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatConversation>>(this->shim().GetConversationAsync(*reinterpret_cast<hstring const*>(&conversationId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetConversationForTransportsAsync(void* conversationId, void* transportIds, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatConversation>>(this->shim().GetConversationAsync(*reinterpret_cast<hstring const*>(&conversationId), *reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&transportIds)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetConversationFromThreadingInfoAsync(void* threadingInfo, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatConversation>>(this->shim().GetConversationFromThreadingInfoAsync(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::ChatConversationThreadingInfo const*>(&threadingInfo)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetConversationReader(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatConversationReader>(this->shim().GetConversationReader());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetConversationForTransportsReader(void* transportIds, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatConversationReader>(this->shim().GetConversationReader(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&transportIds)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetMessageByRemoteIdAsync(void* transportId, void* remoteId, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatMessage>>(this->shim().GetMessageByRemoteIdAsync(*reinterpret_cast<hstring const*>(&transportId), *reinterpret_cast<hstring const*>(&remoteId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetUnseenCountAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<int32_t>>(this->shim().GetUnseenCountAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetUnseenCountForTransportsReaderAsync(void* transportIds, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<int32_t>>(this->shim().GetUnseenCountAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&transportIds)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall MarkAsSeenAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().MarkAsSeenAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall MarkAsSeenForTransportsAsync(void* transportIds, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().MarkAsSeenAsync(*reinterpret_cast<winrt::Windows::Foundation::Collections::IIterable<hstring> const*>(&transportIds)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetSearchReader(void* value, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatSearchReader>(this->shim().GetSearchReader(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::ChatQueryOptions const*>(&value)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SaveMessageAsync(void* chatMessage, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().SaveMessageAsync(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::ChatMessage const*>(&chatMessage)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryCancelDownloadMessageAsync(void* localChatMessageId, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryCancelDownloadMessageAsync(*reinterpret_cast<hstring const*>(&localChatMessageId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TryCancelSendMessageAsync(void* localChatMessageId, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<bool>>(this->shim().TryCancelSendMessageAsync(*reinterpret_cast<hstring const*>(&localChatMessageId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_StoreChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().StoreChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Chat::ChatMessageStore, winrt::Windows::ApplicationModel::Chat::ChatMessageStoreChangedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_StoreChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StoreChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore3> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStore3>
    {
        int32_t __stdcall GetMessageBySyncIdAsync(void* syncId, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatMessage>>(this->shim().GetMessageBySyncIdAsync(*reinterpret_cast<hstring const*>(&syncId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStoreChangedEventArgs> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageStoreChangedEventArgs>
    {
        int32_t __stdcall get_Id(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Kind(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatStoreChangedEventKind>(this->shim().Kind());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransport> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransport>
    {
        int32_t __stdcall get_IsAppSetAsNotificationProvider(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsAppSetAsNotificationProvider());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsActive(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsActive());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransportFriendlyName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().TransportFriendlyName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransportId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().TransportId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RequestSetAsNotificationProviderAsync(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().RequestSetAsNotificationProviderAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransport2> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransport2>
    {
        int32_t __stdcall get_Configuration(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessageTransportConfiguration>(this->shim().Configuration());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransportKind(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessageTransportKind>(this->shim().TransportKind());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration>
    {
        int32_t __stdcall get_MaxAttachmentCount(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<int32_t>(this->shim().MaxAttachmentCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxMessageSizeInKilobytes(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<int32_t>(this->shim().MaxMessageSizeInKilobytes());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxRecipientCount(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<int32_t>(this->shim().MaxRecipientCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SupportedVideoFormat(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Media::MediaProperties::MediaEncodingProfile>(this->shim().SupportedVideoFormat());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ExtendedProperties(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Collections::IMapView<hstring, winrt::Windows::Foundation::IInspectable>>(this->shim().ExtendedProperties());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult>
    {
        int32_t __stdcall get_MaxPartCount(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<uint32_t>>(this->shim().MaxPartCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_PartCount(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<uint32_t>>(this->shim().PartCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RemainingCharacterCountInPart(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IReference<uint32_t>>(this->shim().RemainingCharacterCountInPart());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Status(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessageValidationStatus>(this->shim().Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatQueryOptions> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatQueryOptions>
    {
        int32_t __stdcall get_SearchString(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().SearchString());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_SearchString(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().SearchString(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo>
    {
        int32_t __stdcall get_TransportAddress(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().TransportAddress());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TransportAddress(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TransportAddress(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_DeliveryTime(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::DateTime>>(this->shim().DeliveryTime());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_DeliveryTime(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().DeliveryTime(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::DateTime> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ReadTime(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::DateTime>>(this->shim().ReadTime());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ReadTime(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReadTime(*reinterpret_cast<winrt::Windows::Foundation::IReference<winrt::Windows::Foundation::DateTime> const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransportErrorCodeCategory(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatTransportErrorCodeCategory>(this->shim().TransportErrorCodeCategory());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransportInterpretedErrorCode(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatTransportInterpretedErrorCode>(this->shim().TransportInterpretedErrorCode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransportErrorCode(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<int32_t>(this->shim().TransportErrorCode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsErrorPermanent(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsErrorPermanent());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Status(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatMessageStatus>(this->shim().Status());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatSearchReader> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatSearchReader>
    {
        int32_t __stdcall ReadBatchAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::IChatItem>>>(this->shim().ReadBatchAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReadBatchWithCountAsync(int32_t count, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::IChatItem>>>(this->shim().ReadBatchAsync(count));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration>
    {
        int32_t __stdcall get_IsSyncEnabled(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsSyncEnabled());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_IsSyncEnabled(bool value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().IsSyncEnabled(value);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_RestoreHistorySpan(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatRestoreHistorySpan>(this->shim().RestoreHistorySpan());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_RestoreHistorySpan(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RestoreHistorySpan(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::ChatRestoreHistorySpan const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IChatSyncManager> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IChatSyncManager>
    {
        int32_t __stdcall get_Configuration(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::ChatSyncConfiguration>(this->shim().Configuration());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AssociateAccountAsync(void* webAccount, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().AssociateAccountAsync(*reinterpret_cast<winrt::Windows::Security::Credentials::WebAccount const*>(&webAccount)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall UnassociateAccountAsync(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().UnassociateAccountAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall IsAccountAssociated(void* webAccount, bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsAccountAssociated(*reinterpret_cast<winrt::Windows::Security::Credentials::WebAccount const*>(&webAccount)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall StartSync() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().StartSync();
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SetConfigurationAsync(void* configuration, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().SetConfigurationAsync(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::ChatSyncConfiguration const*>(&configuration)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage>
    {
        int32_t __stdcall get_TransportId(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().TransportId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Title(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().Title());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Text(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().Text());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsPinRequired(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsPinRequired());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Actions(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageAction>>(this->shim().Actions());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SendResponseAsync(void* action, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().SendResponseAsync(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageAction const*>(&action)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall SendResponseWithPinAsync(void* action, void* pin, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().SendResponseWithPinAsync(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageAction const*>(&action), *reinterpret_cast<hstring const*>(&pin)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAction> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAction>
    {
        int32_t __stdcall get_Label(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().Label());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableEventArgs> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableEventArgs>
    {
        int32_t __stdcall get_IsMessageAvailable(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsMessageAvailable());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Message(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::RcsEndUserMessage>(this->shim().Message());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableTriggerDetails> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableTriggerDetails>
    {
        int32_t __stdcall get_Title(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Title());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Text(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Text());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageManager> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageManager>
    {
        int32_t __stdcall add_MessageAvailableChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().MessageAvailableChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageManager, winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageAvailableEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_MessageAvailableChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().MessageAvailableChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics>
    {
        int32_t __stdcall GetEndUserMessageManager(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageManager>(this->shim().GetEndUserMessageManager());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetTransportsAsync(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::RcsTransport>>>(this->shim().GetTransportsAsync());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetTransportAsync(void* transportId, void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::RcsTransport>>(this->shim().GetTransportAsync(*reinterpret_cast<hstring const*>(&transportId)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall LeaveConversationAsync(void* conversation, void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::IAsyncAction>(this->shim().LeaveConversationAsync(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::ChatConversation const*>(&conversation)));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics2> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics2>
    {
        int32_t __stdcall add_TransportListChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().TransportListChanged(*reinterpret_cast<winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_TransportListChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TransportListChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IRcsServiceKindSupportedChangedEventArgs> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IRcsServiceKindSupportedChangedEventArgs>
    {
        int32_t __stdcall get_ServiceKind(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::RcsServiceKind>(this->shim().ServiceKind());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IRcsTransport> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IRcsTransport>
    {
        int32_t __stdcall get_ExtendedProperties(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IMapView<hstring, winrt::Windows::Foundation::IInspectable>>(this->shim().ExtendedProperties());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsActive(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsActive());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransportFriendlyName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().TransportFriendlyName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_TransportId(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().TransportId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Configuration(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::ApplicationModel::Chat::RcsTransportConfiguration>(this->shim().Configuration());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall IsStoreAndForwardEnabled(int32_t serviceKind, bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsStoreAndForwardEnabled(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::RcsServiceKind const*>(&serviceKind)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall IsServiceKindSupported(int32_t serviceKind, bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsServiceKindSupported(*reinterpret_cast<winrt::Windows::ApplicationModel::Chat::RcsServiceKind const*>(&serviceKind)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_ServiceKindSupportedChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().ServiceKindSupportedChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::ApplicationModel::Chat::RcsTransport, winrt::Windows::ApplicationModel::Chat::RcsServiceKindSupportedChangedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_ServiceKindSupportedChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ServiceKindSupportedChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration>
    {
        int32_t __stdcall get_MaxAttachmentCount(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<int32_t>(this->shim().MaxAttachmentCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxMessageSizeInKilobytes(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<int32_t>(this->shim().MaxMessageSizeInKilobytes());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxGroupMessageSizeInKilobytes(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<int32_t>(this->shim().MaxGroupMessageSizeInKilobytes());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxRecipientCount(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<int32_t>(this->shim().MaxRecipientCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxFileSizeInKilobytes(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<int32_t>(this->shim().MaxFileSizeInKilobytes());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_WarningFileSizeInKilobytes(int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<int32_t>(this->shim().WarningFileSizeInKilobytes());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::ApplicationModel::Chat::IRemoteParticipantComposingChangedEventArgs> : produce_base<D, winrt::Windows::ApplicationModel::Chat::IRemoteParticipantComposingChangedEventArgs>
    {
        int32_t __stdcall get_TransportId(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().TransportId());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ParticipantAddress(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<hstring>(this->shim().ParticipantAddress());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsComposing(bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsComposing());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::ApplicationModel::Chat
{
    inline auto ChatCapabilitiesManager::GetCachedCapabilitiesAsync(param::hstring const& address)
    {
        return impl::call_factory<ChatCapabilitiesManager, IChatCapabilitiesManagerStatics>([&](IChatCapabilitiesManagerStatics const& f) { return f.GetCachedCapabilitiesAsync(address); });
    }
    inline auto ChatCapabilitiesManager::GetCapabilitiesFromNetworkAsync(param::hstring const& address)
    {
        return impl::call_factory<ChatCapabilitiesManager, IChatCapabilitiesManagerStatics>([&](IChatCapabilitiesManagerStatics const& f) { return f.GetCapabilitiesFromNetworkAsync(address); });
    }
    inline auto ChatCapabilitiesManager::GetCachedCapabilitiesAsync(param::hstring const& address, param::hstring const& transportId)
    {
        return impl::call_factory<ChatCapabilitiesManager, IChatCapabilitiesManagerStatics2>([&](IChatCapabilitiesManagerStatics2 const& f) { return f.GetCachedCapabilitiesAsync(address, transportId); });
    }
    inline auto ChatCapabilitiesManager::GetCapabilitiesFromNetworkAsync(param::hstring const& address, param::hstring const& transportId)
    {
        return impl::call_factory<ChatCapabilitiesManager, IChatCapabilitiesManagerStatics2>([&](IChatCapabilitiesManagerStatics2 const& f) { return f.GetCapabilitiesFromNetworkAsync(address, transportId); });
    }
    inline ChatConversationThreadingInfo::ChatConversationThreadingInfo() :
        ChatConversationThreadingInfo(impl::call_factory_cast<ChatConversationThreadingInfo(*)(winrt::Windows::Foundation::IActivationFactory const&), ChatConversationThreadingInfo>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<ChatConversationThreadingInfo>(); }))
    {
    }
    inline ChatMessage::ChatMessage() :
        ChatMessage(impl::call_factory_cast<ChatMessage(*)(winrt::Windows::Foundation::IActivationFactory const&), ChatMessage>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<ChatMessage>(); }))
    {
    }
    inline ChatMessageAttachment::ChatMessageAttachment(param::hstring const& mimeType, winrt::Windows::Storage::Streams::IRandomAccessStreamReference const& dataStreamReference) :
        ChatMessageAttachment(impl::call_factory<ChatMessageAttachment, IChatMessageAttachmentFactory>([&](IChatMessageAttachmentFactory const& f) { return f.CreateChatMessageAttachment(mimeType, dataStreamReference); }))
    {
    }
    inline auto ChatMessageBlocking::MarkMessageAsBlockedAsync(param::hstring const& localChatMessageId, bool blocked)
    {
        return impl::call_factory<ChatMessageBlocking, IChatMessageBlockingStatic>([&](IChatMessageBlockingStatic const& f) { return f.MarkMessageAsBlockedAsync(localChatMessageId, blocked); });
    }
    inline auto ChatMessageManager::RegisterTransportAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<hstring>(*)(IChatMessageManager2Statics const&), ChatMessageManager, IChatMessageManager2Statics>([](IChatMessageManager2Statics const& f) { return f.RegisterTransportAsync(); });
    }
    inline auto ChatMessageManager::GetTransportAsync(param::hstring const& transportId)
    {
        return impl::call_factory<ChatMessageManager, IChatMessageManager2Statics>([&](IChatMessageManager2Statics const& f) { return f.GetTransportAsync(transportId); });
    }
    inline auto ChatMessageManager::GetTransportsAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::ChatMessageTransport>>(*)(IChatMessageManagerStatic const&), ChatMessageManager, IChatMessageManagerStatic>([](IChatMessageManagerStatic const& f) { return f.GetTransportsAsync(); });
    }
    inline auto ChatMessageManager::RequestStoreAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatMessageStore>(*)(IChatMessageManagerStatic const&), ChatMessageManager, IChatMessageManagerStatic>([](IChatMessageManagerStatic const& f) { return f.RequestStoreAsync(); });
    }
    inline auto ChatMessageManager::ShowComposeSmsMessageAsync(winrt::Windows::ApplicationModel::Chat::ChatMessage const& message)
    {
        return impl::call_factory<ChatMessageManager, IChatMessageManagerStatic>([&](IChatMessageManagerStatic const& f) { return f.ShowComposeSmsMessageAsync(message); });
    }
    inline auto ChatMessageManager::ShowSmsSettings()
    {
        impl::call_factory_cast<void(*)(IChatMessageManagerStatic const&), ChatMessageManager, IChatMessageManagerStatic>([](IChatMessageManagerStatic const& f) { return f.ShowSmsSettings(); });
    }
    inline auto ChatMessageManager::RequestSyncManagerAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::ApplicationModel::Chat::ChatSyncManager>(*)(IChatMessageManagerStatics3 const&), ChatMessageManager, IChatMessageManagerStatics3>([](IChatMessageManagerStatics3 const& f) { return f.RequestSyncManagerAsync(); });
    }
    inline ChatQueryOptions::ChatQueryOptions() :
        ChatQueryOptions(impl::call_factory_cast<ChatQueryOptions(*)(winrt::Windows::Foundation::IActivationFactory const&), ChatQueryOptions>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<ChatQueryOptions>(); }))
    {
    }
    inline ChatRecipientDeliveryInfo::ChatRecipientDeliveryInfo() :
        ChatRecipientDeliveryInfo(impl::call_factory_cast<ChatRecipientDeliveryInfo(*)(winrt::Windows::Foundation::IActivationFactory const&), ChatRecipientDeliveryInfo>([](winrt::Windows::Foundation::IActivationFactory const& f) { return f.template ActivateInstance<ChatRecipientDeliveryInfo>(); }))
    {
    }
    inline auto RcsManager::GetEndUserMessageManager()
    {
        return impl::call_factory_cast<winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageManager(*)(IRcsManagerStatics const&), RcsManager, IRcsManagerStatics>([](IRcsManagerStatics const& f) { return f.GetEndUserMessageManager(); });
    }
    inline auto RcsManager::GetTransportsAsync()
    {
        return impl::call_factory_cast<winrt::Windows::Foundation::IAsyncOperation<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::ApplicationModel::Chat::RcsTransport>>(*)(IRcsManagerStatics const&), RcsManager, IRcsManagerStatics>([](IRcsManagerStatics const& f) { return f.GetTransportsAsync(); });
    }
    inline auto RcsManager::GetTransportAsync(param::hstring const& transportId)
    {
        return impl::call_factory<RcsManager, IRcsManagerStatics>([&](IRcsManagerStatics const& f) { return f.GetTransportAsync(transportId); });
    }
    inline auto RcsManager::LeaveConversationAsync(winrt::Windows::ApplicationModel::Chat::ChatConversation const& conversation)
    {
        return impl::call_factory<RcsManager, IRcsManagerStatics>([&](IRcsManagerStatics const& f) { return f.LeaveConversationAsync(conversation); });
    }
    inline auto RcsManager::TransportListChanged(winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler)
    {
        return impl::call_factory<RcsManager, IRcsManagerStatics2>([&](IRcsManagerStatics2 const& f) { return f.TransportListChanged(handler); });
    }
    inline auto RcsManager::TransportListChanged(auto_revoke_t, winrt::Windows::Foundation::EventHandler<winrt::Windows::Foundation::IInspectable> const& handler)
    {
        auto f = get_activation_factory<RcsManager, winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics2>();
        return RcsManager::TransportListChanged_revoker{ f, f.TransportListChanged(handler) };
    }
    inline auto RcsManager::TransportListChanged(winrt::event_token const& token)
    {
        impl::call_factory<RcsManager, IRcsManagerStatics2>([&](IRcsManagerStatics2 const& f) { return f.TransportListChanged(token); });
    }
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatCapabilities> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatCapabilitiesManagerStatics2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatConversation> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatConversation2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatConversationReader> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatConversationThreadingInfo> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatItem> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessage> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessage2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessage3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessage4> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachment2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageAttachmentFactory> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageBlockingStatic> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageChange> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeReader> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageChangeTracker> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageChangedDeferral> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageChangedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageManager2Statics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatic> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageManagerStatics3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageNotificationTriggerDetails2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageReader> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageReader2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageStore> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageStore2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageStore3> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageStoreChangedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageTransport2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageTransportConfiguration> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatMessageValidationResult> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatQueryOptions> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatRecipientDeliveryInfo> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatSearchReader> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatSyncConfiguration> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IChatSyncManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessage> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAction> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageAvailableTriggerDetails> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IRcsEndUserMessageManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IRcsManagerStatics2> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IRcsServiceKindSupportedChangedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IRcsTransport> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IRcsTransportConfiguration> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::IRemoteParticipantComposingChangedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatCapabilities> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatCapabilitiesManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatConversation> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatConversationReader> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatConversationThreadingInfo> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatMessage> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatMessageAttachment> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatMessageBlocking> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatMessageChange> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatMessageChangeReader> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatMessageChangeTracker> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatMessageChangedDeferral> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatMessageChangedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatMessageManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatMessageNotificationTriggerDetails> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatMessageReader> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatMessageStore> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatMessageStoreChangedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatMessageTransport> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatMessageTransportConfiguration> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatMessageValidationResult> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatQueryOptions> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatRecipientDeliveryInfo> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatSearchReader> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatSyncConfiguration> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::ChatSyncManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::RcsEndUserMessage> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageAction> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageAvailableEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageAvailableTriggerDetails> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::RcsEndUserMessageManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::RcsManager> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::RcsServiceKindSupportedChangedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::RcsTransport> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::RcsTransportConfiguration> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::ApplicationModel::Chat::RemoteParticipantComposingChangedEventArgs> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
