#
# This file attempts to locate the TileDB library. If found, the following
# imported targets are created:
#   - TileDB::tiledb_shared
#   - TileDB::tiledb_static
# And the following variables are defined:
#   - TILEDB_FOUND
#   - TileDB_FOUND
#


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was Config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include("${CMAKE_CURRENT_LIST_DIR}/TileDBTargets.cmake")
check_required_components("TileDB")

# Targets required for linking against tiledb_static:
if (NOT TARGET Bzip2::Bzip2)
  add_library(Bzip2::Bzip2 UNKNOWN IMPORTED)
  set_target_properties(Bzip2::Bzip2 PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libbz2.dll.a)
endif()
if (NOT TARGET LZ4::LZ4)
  add_library(LZ4::LZ4 UNKNOWN IMPORTED)
  set_target_properties(LZ4::LZ4 PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/liblz4.dll.a)
endif()
if (NOT TARGET ZLIB::ZLIB)
  add_library(ZLIB::ZLIB UNKNOWN IMPORTED)
  set_target_properties(ZLIB::ZLIB PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libz.dll.a)
endif()
if (NOT TARGET Zstd::Zstd)
  add_library(Zstd::Zstd UNKNOWN IMPORTED)
  set_target_properties(Zstd::Zstd PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libzstd.dll.a)
endif()
if (NOT TARGET aws-cpp-sdk-identity-management)
  add_library(aws-cpp-sdk-identity-management UNKNOWN IMPORTED)
  set_target_properties(aws-cpp-sdk-identity-management PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-cpp-sdk-identity-management.dll.a)
endif()
if (NOT TARGET aws-cpp-sdk-cognito-identity)
  add_library(aws-cpp-sdk-cognito-identity UNKNOWN IMPORTED)
  set_target_properties(aws-cpp-sdk-cognito-identity PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-cpp-sdk-cognito-identity.dll.a)
endif()
if (NOT TARGET aws-cpp-sdk-sts)
  add_library(aws-cpp-sdk-sts UNKNOWN IMPORTED)
  set_target_properties(aws-cpp-sdk-sts PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-cpp-sdk-sts.dll.a)
endif()
if (NOT TARGET aws-cpp-sdk-s3)
  add_library(aws-cpp-sdk-s3 UNKNOWN IMPORTED)
  set_target_properties(aws-cpp-sdk-s3 PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-cpp-sdk-s3.dll.a)
endif()
if (NOT TARGET aws-cpp-sdk-core)
  add_library(aws-cpp-sdk-core UNKNOWN IMPORTED)
  set_target_properties(aws-cpp-sdk-core PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-cpp-sdk-core.dll.a)
endif()
if (NOT TARGET AWS::aws-crt-cpp)
  add_library(AWS::aws-crt-cpp UNKNOWN IMPORTED)
  set_target_properties(AWS::aws-crt-cpp PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-crt-cpp.dll.a)
endif()
if (NOT TARGET AWS::aws-c-auth)
  add_library(AWS::aws-c-auth UNKNOWN IMPORTED)
  set_target_properties(AWS::aws-c-auth PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-c-auth.dll.a)
endif()
if (NOT TARGET AWS::aws-c-cal)
  add_library(AWS::aws-c-cal UNKNOWN IMPORTED)
  set_target_properties(AWS::aws-c-cal PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-c-cal.dll.a)
endif()
if (NOT TARGET AWS::aws-c-common)
  add_library(AWS::aws-c-common UNKNOWN IMPORTED)
  set_target_properties(AWS::aws-c-common PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-c-common.dll.a)
endif()
if (NOT TARGET AWS::aws-c-compression)
  add_library(AWS::aws-c-compression UNKNOWN IMPORTED)
  set_target_properties(AWS::aws-c-compression PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-c-compression.dll.a)
endif()
if (NOT TARGET AWS::aws-c-event-stream)
  add_library(AWS::aws-c-event-stream UNKNOWN IMPORTED)
  set_target_properties(AWS::aws-c-event-stream PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-c-event-stream.dll.a)
endif()
if (NOT TARGET AWS::aws-c-http)
  add_library(AWS::aws-c-http UNKNOWN IMPORTED)
  set_target_properties(AWS::aws-c-http PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-c-http.dll.a)
endif()
if (NOT TARGET AWS::aws-c-io)
  add_library(AWS::aws-c-io UNKNOWN IMPORTED)
  set_target_properties(AWS::aws-c-io PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-c-io.dll.a)
endif()
if (NOT TARGET AWS::aws-c-mqtt)
  add_library(AWS::aws-c-mqtt UNKNOWN IMPORTED)
  set_target_properties(AWS::aws-c-mqtt PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-c-mqtt.dll.a)
endif()
if (NOT TARGET AWS::aws-c-s3)
  add_library(AWS::aws-c-s3 UNKNOWN IMPORTED)
  set_target_properties(AWS::aws-c-s3 PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-c-s3.dll.a)
endif()
if (NOT TARGET AWS::aws-checksums)
  add_library(AWS::aws-checksums UNKNOWN IMPORTED)
  set_target_properties(AWS::aws-checksums PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-checksums.dll.a)
endif()
if (NOT TARGET AWS::aws-c-sdkutils)
  add_library(AWS::aws-c-sdkutils UNKNOWN IMPORTED)
  set_target_properties(AWS::aws-c-sdkutils PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libaws-c-sdkutils.dll.a)
endif()
if (NOT TARGET fmt::fmt)
  add_library(fmt::fmt UNKNOWN IMPORTED)
  set_target_properties(fmt::fmt PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libfmt.dll.a)
endif()
if (NOT TARGET spdlog::spdlog)
  add_library(spdlog::spdlog UNKNOWN IMPORTED)
  set_target_properties(spdlog::spdlog PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libspdlog.dll.a)
endif()
if (NOT TARGET libmagic)
  add_library(libmagic UNKNOWN IMPORTED)
  set_target_properties(libmagic PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libmagic.dll.a)
endif()
if (NOT TARGET unofficial::libmagic::libmagic)
  add_library(unofficial::libmagic::libmagic UNKNOWN IMPORTED)
  set_target_properties(unofficial::libmagic::libmagic PROPERTIES IMPORTED_LOCATION ${PACKAGE_PREFIX_DIR}/lib/libmagic.dll.a)
endif()

# -- End required targets for static

# Define a convenience all-caps variable
if (NOT DEFINED TILEDB_FOUND)
  if (TARGET TileDB::tiledb_shared)
    set(TILEDB_FOUND TRUE)
  else()
    set(TILEDB_FOUND FALSE)
  endif()
endif()
