# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Iterative statistics."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _iterative_statistics
else:
    import _iterative_statistics

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _iterative_statistics.delete_SwigPyIterator

    def value(self):
        return _iterative_statistics.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _iterative_statistics.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _iterative_statistics.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _iterative_statistics.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _iterative_statistics.SwigPyIterator_equal(self, x)

    def copy(self):
        return _iterative_statistics.SwigPyIterator_copy(self)

    def next(self):
        return _iterative_statistics.SwigPyIterator_next(self)

    def __next__(self):
        return _iterative_statistics.SwigPyIterator___next__(self)

    def previous(self):
        return _iterative_statistics.SwigPyIterator_previous(self)

    def advance(self, n):
        return _iterative_statistics.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _iterative_statistics.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _iterative_statistics.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _iterative_statistics.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _iterative_statistics.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _iterative_statistics.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _iterative_statistics.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _iterative_statistics:
_iterative_statistics.SwigPyIterator_swigregister(SwigPyIterator)
import openturns.common
import openturns.typ
class IterativeAlgorithmImplementation(openturns.common.PersistentObject):
    r"""

    Iterative algorithm

    Parameters
    ----------
    dimension : int, default=1
        Dimension of the input data.

    Notes
    -----
    Base class for iterative algorithms: persistent objects that can be incremented iteratively.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _iterative_statistics.IterativeAlgorithmImplementation_getClassName(self)

    def increment(self, *args):
        r"""
        Increment the internal data.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            New input point or sample.
        """
        return _iterative_statistics.IterativeAlgorithmImplementation_increment(self, *args)

    def getIterationNumber(self):
        r"""
        Get the current iteration of the algorithm

        Returns
        -------
        iteration : int
            Current iteration of the algorithm
        """
        return _iterative_statistics.IterativeAlgorithmImplementation_getIterationNumber(self)

    def getDimension(self):
        r"""
        Get the dimension of the algorithm

        Returns
        -------
        dimension : int
            Dimension of the algorithm
        """
        return _iterative_statistics.IterativeAlgorithmImplementation_getDimension(self)

    def __repr__(self):
        return _iterative_statistics.IterativeAlgorithmImplementation___repr__(self)

    def __str__(self, *args):
        return _iterative_statistics.IterativeAlgorithmImplementation___str__(self, *args)

    def __init__(self, *args):
        _iterative_statistics.IterativeAlgorithmImplementation_swiginit(self, _iterative_statistics.new_IterativeAlgorithmImplementation(*args))
    __swig_destroy__ = _iterative_statistics.delete_IterativeAlgorithmImplementation

# Register IterativeAlgorithmImplementation in _iterative_statistics:
_iterative_statistics.IterativeAlgorithmImplementation_swigregister(IterativeAlgorithmImplementation)
class IterativeAlgorithmImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _iterative_statistics.IterativeAlgorithmImplementationTypedInterfaceObject_swiginit(self, _iterative_statistics.new_IterativeAlgorithmImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _iterative_statistics.IterativeAlgorithmImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _iterative_statistics.IterativeAlgorithmImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _iterative_statistics.IterativeAlgorithmImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _iterative_statistics.IterativeAlgorithmImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _iterative_statistics.IterativeAlgorithmImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _iterative_statistics.delete_IterativeAlgorithmImplementationTypedInterfaceObject

# Register IterativeAlgorithmImplementationTypedInterfaceObject in _iterative_statistics:
_iterative_statistics.IterativeAlgorithmImplementationTypedInterfaceObject_swigregister(IterativeAlgorithmImplementationTypedInterfaceObject)
class IterativeAlgorithm(IterativeAlgorithmImplementationTypedInterfaceObject):
    r"""

    Iterative algorithm

    Parameters
    ----------
    dimension : int, default=1
        Dimension of the input data.

    Notes
    -----
    Base class for iterative algorithms: persistent objects that can be incremented iteratively.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _iterative_statistics.IterativeAlgorithm_getClassName(self)

    def increment(self, *args):
        r"""
        Increment the internal data.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            New input point or sample.
        """
        return _iterative_statistics.IterativeAlgorithm_increment(self, *args)

    def getIterationNumber(self):
        r"""
        Get the current iteration of the algorithm

        Returns
        -------
        iteration : int
            Current iteration of the algorithm
        """
        return _iterative_statistics.IterativeAlgorithm_getIterationNumber(self)

    def getDimension(self):
        r"""
        Get the dimension of the algorithm

        Returns
        -------
        dimension : int
            Dimension of the algorithm
        """
        return _iterative_statistics.IterativeAlgorithm_getDimension(self)

    def __repr__(self):
        return _iterative_statistics.IterativeAlgorithm___repr__(self)

    def __str__(self, *args):
        return _iterative_statistics.IterativeAlgorithm___str__(self, *args)

    def __init__(self, *args):
        _iterative_statistics.IterativeAlgorithm_swiginit(self, _iterative_statistics.new_IterativeAlgorithm(*args))
    __swig_destroy__ = _iterative_statistics.delete_IterativeAlgorithm

# Register IterativeAlgorithm in _iterative_statistics:
_iterative_statistics.IterativeAlgorithm_swigregister(IterativeAlgorithm)
class IterativeExtrema(IterativeAlgorithmImplementation):
    r"""
    Iterative minimum and maximum.

    Parameters
    ----------
    dimension : int
        Dimension of the input data

    Notes
    -----
    This class iteratively computes the minimum and maximum over an iteratively increasing
    dataset without storing any data in memory.

    See also
    --------
    IterativeAlgorithm

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> dim = 5
    >>> myExtrema = ot.IterativeExtrema(dim)
    >>> n = ot.Normal(dim)
    >>> size = 50

    Increment the data one point at a time:

    >>> for i in range(size):
    ...     point = n.getRealization()
    ...     myExtrema.increment(point)
    >>> print(myExtrema.getIterationNumber())
    50
    >>> print(myExtrema.getMin())
    [-2.4067,-2.53986,-2.29006,-3.09737,-2.18139]
    >>> print(myExtrema.getMax())
    [3.01263,3.02799,1.85579,2.11968,1.36783]

    Increment with 50 additional points simultaneously and recompute the extrema:

    >>> sample = n.getSample(size)
    >>> myExtrema.increment(sample)
    >>> print(myExtrema.getIterationNumber())
    100
    >>> print(myExtrema.getMin())
    [-2.4067,-2.53986,-2.72106,-3.09737,-2.18139]
    >>> print(myExtrema.getMax())
    [3.01263,3.02799,2.24097,2.11968,2.55533]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _iterative_statistics.IterativeExtrema_getClassName(self)

    def increment(self, *args):
        r"""
        Increment the internal data.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            New input point or sample.
        """
        return _iterative_statistics.IterativeExtrema_increment(self, *args)

    def __eq__(self, *args):
        return _iterative_statistics.IterativeExtrema___eq__(self, *args)

    def __ne__(self, *args):
        return _iterative_statistics.IterativeExtrema___ne__(self, *args)

    def __repr__(self):
        return _iterative_statistics.IterativeExtrema___repr__(self)

    def __str__(self, arg2):
        return _iterative_statistics.IterativeExtrema___str__(self, arg2)

    def getMin(self):
        r"""
        Returns the values of the minimum over the inputs component per component

        Returns
        -------
        min : :class:`~openturns.Point`
            current values of the iterative minimum.
        """
        return _iterative_statistics.IterativeExtrema_getMin(self)

    def getMax(self):
        r"""
        Returns the values of the maximum over the inputs component per component

        Returns
        -------
        max : :class:`~openturns.Point`
            current values of the iterative maximum.
        """
        return _iterative_statistics.IterativeExtrema_getMax(self)

    def __init__(self, *args):
        _iterative_statistics.IterativeExtrema_swiginit(self, _iterative_statistics.new_IterativeExtrema(*args))
    __swig_destroy__ = _iterative_statistics.delete_IterativeExtrema

# Register IterativeExtrema in _iterative_statistics:
_iterative_statistics.IterativeExtrema_swigregister(IterativeExtrema)
class IterativeThresholdExceedance(IterativeAlgorithmImplementation):
    r"""
    Iterative threshold exceedance.

    Parameters
    ----------
    dimension : int, default=1
        Dimension of the input data

    thresholdValue : float, default=0.0
        Threshold value

    Notes
    -----
    This class iteratively counts the number of threshold exceedances
    of an iteratively increasing
    dataset without storing any data in memory.

    See also
    --------
    IterativeAlgorithm

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> dim = 5
    >>> threshold = 0.5
    >>> myThresholdExceedance = ot.IterativeThresholdExceedance(dim, threshold)
    >>> n = ot.Normal(dim)
    >>> size = 50

    Increment with 50 points:

    >>> for i in range(size):
    ...     point = n.getRealization()
    ...     myThresholdExceedance.increment(point)
    >>> print(myThresholdExceedance.getThresholdExceedance())
    [14,14,14,17,12]
    >>> print(myThresholdExceedance.getIterationNumber())
    50

    Increment with one sample of size 50:

    >>> sample = n.getSample(size)
    >>> myThresholdExceedance.increment(sample)
    >>> print(myThresholdExceedance.getIterationNumber())
    100
    >>> print(myThresholdExceedance.getThresholdExceedance())
    [38,30,35,27,32]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _iterative_statistics.IterativeThresholdExceedance_getClassName(self)

    def increment(self, *args):
        r"""
        Increment the internal data.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            New input point or sample.
        """
        return _iterative_statistics.IterativeThresholdExceedance_increment(self, *args)

    def __eq__(self, *args):
        return _iterative_statistics.IterativeThresholdExceedance___eq__(self, *args)

    def __ne__(self, *args):
        return _iterative_statistics.IterativeThresholdExceedance___ne__(self, *args)

    def __repr__(self):
        return _iterative_statistics.IterativeThresholdExceedance___repr__(self)

    def __str__(self, *args):
        return _iterative_statistics.IterativeThresholdExceedance___str__(self, *args)

    def getThresholdValue(self):
        r"""
        Returns the value of the threshold

        Returns
        -------
        thresholdValue : float
            the value of the threshold.
        """
        return _iterative_statistics.IterativeThresholdExceedance_getThresholdValue(self)

    def getThresholdExceedance(self):
        r"""
        Returns the number of threshold exceedances component per component

        Returns
        -------
        thresholdExceedance : :class:`~openturns.Point`
            current number of threshold exceedances component per component.
        """
        return _iterative_statistics.IterativeThresholdExceedance_getThresholdExceedance(self)

    def __init__(self, *args):
        _iterative_statistics.IterativeThresholdExceedance_swiginit(self, _iterative_statistics.new_IterativeThresholdExceedance(*args))
    __swig_destroy__ = _iterative_statistics.delete_IterativeThresholdExceedance

# Register IterativeThresholdExceedance in _iterative_statistics:
_iterative_statistics.IterativeThresholdExceedance_swigregister(IterativeThresholdExceedance)
class IterativeMoments(IterativeAlgorithmImplementation):
    r"""
    Iterative moments.

    Parameters
    ----------
    order : int
        Maximum order of the moments wanted

    dimension : int
        Dimension of the input data

    Notes
    -----
    This class iteratively computes the central moments of an iteratively increasing
    dataset without storing any data in memory.

    See also
    --------
    IterativeAlgorithm

    Examples
    --------

    In the following example, we iteratively compute the sample statistics of a
    sample.
    This is based on a sample with size equal to 2000.
    In the `for` loop, each realization of the distribution is used to update
    the statistics up to the 4th order moments.

    >>> import openturns as ot
    >>> distNormal = ot.Normal()
    >>> order = 4
    >>> dim = 1
    >>> iterMoments = ot.IterativeMoments(order, dim)
    >>> size = 2000
    >>> meanEvolution = ot.Sample()
    >>> for i in range(size):
    ...     point = distNormal.getRealization()
    ...     iterMoments.increment(point)
    >>> print('Mean:     ', iterMoments.getMean())
    Mean:      [-0.00726852]
    >>> print('Variance: ', iterMoments.getVariance())
    Variance:  [0.99156]
    >>> print('Skewness: ', iterMoments.getSkewness())
    Skewness:  [0.0577277]
    >>> print('Kurtosis: ', iterMoments.getKurtosis())
    Kurtosis:  [3.11128]

    The statistics can also be updated with a single sample.

    >>> distNormal = ot.Normal()
    >>> dim = 1
    >>> order = 1
    >>> iterMoments = ot.IterativeMoments(order, dim)
    >>> size = 2000
    >>> sample = distNormal.getSample(size)
    >>> iterMoments.increment(sample)
    >>> print('Mean: ', iterMoments.getMean())
    Mean:  [-0.017342]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _iterative_statistics.IterativeMoments_getClassName(self)

    def increment(self, *args):
        r"""
        Increment the internal data.

        Parameters
        ----------
        data : sequence of float or 2-d sequence of float
            New input point or sample.
        """
        return _iterative_statistics.IterativeMoments_increment(self, *args)

    def __eq__(self, *args):
        return _iterative_statistics.IterativeMoments___eq__(self, *args)

    def __ne__(self, *args):
        return _iterative_statistics.IterativeMoments___ne__(self, *args)

    def __repr__(self):
        return _iterative_statistics.IterativeMoments___repr__(self)

    def __str__(self, *args):
        return _iterative_statistics.IterativeMoments___str__(self, *args)

    def getMean(self):
        r"""
        Returns the values of the mean

        Returns
        -------
        mean : :class:`~openturns.Point`
            Current value of the mean.
        """
        return _iterative_statistics.IterativeMoments_getMean(self)

    def getVariance(self):
        r"""
        Returns the current value of the unbiased estimator of the variance

        Returns
        -------
        variance : :class:`~openturns.Point`
            Current values of the variance.
        """
        return _iterative_statistics.IterativeMoments_getVariance(self)

    def getSkewness(self):
        r"""
        Returns the current value of the unbiased estimator of the skewness

        Returns
        -------
        skewness : :class:`~openturns.Point`
            Current values of the skewness.
        """
        return _iterative_statistics.IterativeMoments_getSkewness(self)

    def getKurtosis(self):
        r"""
        Returns the current value of the unbiased estimator of the kurtosis

        Returns
        -------
        kurtosis : :class:`~openturns.Point`
            Current values of the iterative kurtosis.
        """
        return _iterative_statistics.IterativeMoments_getKurtosis(self)

    def getCentralMoments(self):
        r"""
        Returns the central moments

        Returns
        -------
        centralMoments : :class:`~openturns.Sample`
            Current value of the central moments.
        """
        return _iterative_statistics.IterativeMoments_getCentralMoments(self)

    def getOrder(self):
        r"""
        Returns the maximum order prescribed

        Returns
        -------
        order : int
            Prescribed order of the iterative object.
        """
        return _iterative_statistics.IterativeMoments_getOrder(self)

    def getStandardErrorOfTheMean(self):
        r"""
        Returns the standard error of the mean

        Returns
        -------
        error : :class:`~openturns.Point`
            Current value of the standard error of the mean.
        """
        return _iterative_statistics.IterativeMoments_getStandardErrorOfTheMean(self)

    def getCoefficientOfVariation(self):
        r"""
        Returns the coefficient of variation

        Returns
        -------
        coefficientOfvariation : :class:`~openturns.Point`
            Current value of the coefficients of variation.
        """
        return _iterative_statistics.IterativeMoments_getCoefficientOfVariation(self)

    def getStandardDeviation(self):
        r"""
        Returns the standard deviation

        Returns
        -------
        standardDeviation : :class:`~openturns.Point`
            Current value of the standard deviation.
        """
        return _iterative_statistics.IterativeMoments_getStandardDeviation(self)

    def __init__(self, *args):
        _iterative_statistics.IterativeMoments_swiginit(self, _iterative_statistics.new_IterativeMoments(*args))
    __swig_destroy__ = _iterative_statistics.delete_IterativeMoments

# Register IterativeMoments in _iterative_statistics:
_iterative_statistics.IterativeMoments_swigregister(IterativeMoments)

