%feature("docstring") OT::TrapezoidalFactory
"Trapezoidal factory.

Available constructor:
    TrapezoidalFactory()

The parameters are estimated by numerical maximum likelihood estimation.

See also
--------
DistributionFactory, Trapezoidal"

// ---------------------------------------------------------------------

%define OT_DistributionFactory_buildAsTrapezoidal_doc
"Build the Trapezoidal distribution.

**Available usages**:

    buildAsTrapezoidal(*sample*)

    buildAsTrapezoidal(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
dist : :class:`~openturns.Trapezoidal`
    The built distribution."
%enddef
%feature("docstring") OT::TrapezoidalFactory::buildAsTrapezoidal
OT_DistributionFactory_buildAsTrapezoidal_doc

