%feature("docstring") OT::SimulatedAnnealingLHS
"LHS optimization using simulated annealing.

Performs the optimization of an LHS using simulated annealing algorithm.

Available constructors:

    SimulatedAnnealingLHS(*lhsDesign*)

    SimulatedAnnealingLHS(*lhsDesign, spaceFilling*)

    SimulatedAnnealingLHS(*lhsDesign, spaceFilling, profile*)

    SimulatedAnnealingLHS(*initialDesign, distribution*)

    SimulatedAnnealingLHS(*initialDesign, distribution, spaceFilling*)

    SimulatedAnnealingLHS(*initialDesign, distribution, spaceFilling, profile*)

Parameters
----------
lhsDesign : :class:`~openturns.LHSExperiment`
    Factory that generate designs
initialDesign : 2d-array sequence
    Initial design to be optimized
distribution : :class:`~openturns.Distribution`
    Distribution of designs
spaceFilling : :class:`~openturns.SpaceFilling`
    Criterion to be optimized
    Default is :class:`~openturns.SpaceFillingPhiP`
profile : :class:`~openturns.TemperatureProfile`
    Temperature profile used by the simulated annealing algorithm
    Default is :class:`~GeometricProfile`

Notes
-----

With the first constructor, the initial design is generated thanks to lhsDesign.
With the second usage (initialDesign), it must be already generated.
Starting from this design, a new design is obtained by swapping one random
coordinate of two randomly chosen elements; by construction, this design is also an LHS design.
If the new design is better than the previous one, it is kept.  
If it is worse, it may anyway be kept with some probability, which depends on
how these designs compare, but also on a temperature profile T which decreases over time.
This means that jumping away from local extrema becomes less probable over time.

Examples
--------
>>> import openturns as ot
>>> dimension = 3
>>> size = 100
>>> # Build standard randomized LHS algorithm
>>> distribution = ot.ComposedDistribution([ot.Uniform(0.0, 1.0)]*dimension)
>>> lhs = ot.LHSExperiment(distribution, size)
>>> lhs.setAlwaysShuffle(True) # randomized
>>> # Defining space fillings
>>> spaceFilling = ot.SpaceFillingC2()
>>> # Geometric profile
>>> geomProfile = ot.GeometricProfile(10.0, 0.95, 2000)
>>> # Simulated Annealing LHS with geometric temperature profile, C2 optimization
>>> optimalLHSAlgorithm = ot.SimulatedAnnealingLHS(lhs, spaceFilling, geomProfile)"

// ---------------------------------------------------------------------
