%feature("docstring") OT::LaplaceFactory
"Laplace factory.

Available constructor:
    LaplaceFactory()

The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle\\Hat{\\mu}_n = x_{1/2}\\\\
      \\displaystyle\\Hat{\\lambda}_n = \\frac{1}{n}\\sum_{i=1}^n|x_i-\\Hat{\\mu}_n|
    \\end{eqnarray*}

See also
--------
DistributionFactory, Laplace"

// ---------------------------------------------------------------------

%define OT_DistributionFactory_buildAsLaplace_doc
"Build the Laplace distribution.

**Available usages**:

    buildAsLaplace(*sample*)

    buildAsLaplace(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
dist : :class:`~openturns.Laplace`
    The built distribution."
%enddef
%feature("docstring") OT::LaplaceFactory::buildAsLaplace
OT_DistributionFactory_buildAsLaplace_doc

