%feature("docstring") OT::FunctionalChaosResult
"Functional chaos result.

Returned by functional chaos algorithms, see :class:`~openturns.FunctionalChaosAlgorithm`.

Parameters
----------
sampleX : 2-d sequence of float
    Input sample of :math:`\\vect{X} \\in \\mathbb{R}^{n_X}`.
sampleY : 2-d sequence of float
    Output sample of :math:`\\vect{Y} \\in \\mathbb{R}^{n_Y}`.
distribution : :class:`~openturns.Distribution`
    Distribution of the random vector :math:`\\vect{X}`
transformation : :class:`~openturns.Function`
    The function that maps the physical input :math:`\\vect{X}` to the 
    standardized input :math:`\\vect{\\xi}`.
inverseTransformation : :class:`~openturns.Function`
    The function that maps standardized input :math:`\\vect{\\xi}` to the 
    the physical input :math:`\\vect{X}`.
orthogonalBasis : :class:`~openturns.OrthogonalBasis`
    The multivariate orthogonal basis.
indices : sequence of `int`
    The indices of the selected basis function within the orthogonal basis.
alpha_k : 2-d sequence of `float`
    The coefficients of the functional chaos expansion.
Psi_k : sequence of :class:`~openturns.Function`
    The functions of the multivariate basis selected by the algorithm.
residuals : sequence of `float`, :math:`\\hat{\\vect{r}} \\in \\mathbb{R}^{n_Y}`
    For each output component, the residual is the square root of the sum of 
    squared differences between the model and the meta model, divided by the 
    sample size.
relativeErrors : sequence of `float`, :math:`\\widehat{\\vect{re}} \\in \\mathbb{R}^{n_Y}`
    The relative error is the empirical error divided by the 
    sample variance of the output.

Notes
-----
Let :math:`n \\in \\mathbb{N}` be the sample size. 
Let :math:`n_Y \\in \\mathbb{N}` be the dimension of the output of the 
physical model. 
For any :math:`j = 1, ..., n` and any :math:`i = 1, ..., n_Y`, 
let :math:`y_{j, i} \\in \\mathbb{R}` be the output of the physical 
model and let :math:`\\hat{y}_{j, i} \\in \\mathbb{R}` be the output of the 
metamodel. 
For any :math:`i = 1, ..., n_Y`, let :math:`\\vect{y}_i \\in \\mathbb{R}^n` be 
the sample output and let :math:`\\hat{\\vect{y}}_i \\in \\mathbb{R}^n` be the 
output predicted by the metamodel. 
The marginal residual is:

.. math::

    \\hat{r}_i = \\frac{\\sqrt{SS_i}}{n} 

for :math:`i = 1, ..., n_Y`, where :math:`SS_i` is the marginal sum of squares:

.. math::

    SS_i = \\sum_{j = 1}^n (y_{j, i} - \\hat{y}_{j, i})^2.

The marginal relative error is:

.. math::

    \\widehat{re}_i = \\frac{\\hat{r}_i / n}{\\hat{s}_{Y, i}^2}

for :math:`i = 1, ..., n_Y`, where :math:`\\hat{s}_{Y, i}^2` is the unbiased 
sample variance of the :math:`i`-th output.

This structure is created by the method `run()` of
:class:`~openturns.FunctionalChaosAlgorithm`, and obtained thanks to the 
`getResult()` method."

// ---------------------------------------------------------------------

%feature("docstring") OT::FunctionalChaosResult::getCoefficients
"Get the coefficients.

Returns
-------
coefficients : 2-d sequence of float
    Coefficients :math:`(\\vect{\\alpha_k})_{k \\in K}`."

// ---------------------------------------------------------------------

%feature("docstring") OT::FunctionalChaosResult::getComposedMetaModel
"Get the composed metamodel.

Returns
-------
composedMetamodel : :class:`~openturns.Function`
    :math:`\\tilde{f} =  \\sum_{k \\in K} \\vect{\\alpha}_k \\Psi_k`"

// ---------------------------------------------------------------------

%feature("docstring") OT::FunctionalChaosResult::getMetaModel
"Get the metamodel.

Returns
-------
metamodel : :class:`~openturns.Function`
    :math:`\\tilde{g} = \\sum_{k \\in K} \\vect{\\alpha}_k \\Psi_k \\circ T`."

// ---------------------------------------------------------------------

%feature("docstring") OT::FunctionalChaosResult::getDistribution
"Get the input distribution.

Returns
-------
distribution : :class:`~openturns.Distribution`
    Distribution of the  input random vector :math:`\\vect{X}`."

// ---------------------------------------------------------------------

%feature("docstring") OT::FunctionalChaosResult::getIndices
"Get the indices of the final basis.

Returns
-------
indices : :class:`~openturns.Indices`
    Indices of the elements of the multivariate basis used in the decomposition."

// ---------------------------------------------------------------------

%feature("docstring") OT::FunctionalChaosResult::getInverseTransformation
"Get the inverse isoprobabilistic transformation.

Returns
-------
invTransf : :class:`~openturns.Function`
     :math:`T^{-1}` such that :math:`T(\\vect{X}) = \\vect{Z}`."

// ---------------------------------------------------------------------

%feature("docstring") OT::FunctionalChaosResult::getOrthogonalBasis
"Get the orthogonal basis.

Returns
-------
basis : :class:`~openturns.OrthogonalBasis`
    Factory of the orthogonal basis."

// ---------------------------------------------------------------------

%feature("docstring") OT::FunctionalChaosResult::getReducedBasis
"Get the reduced basis.

Returns
-------
basis : list of :class:`~openturns.Function`
    Collection of the *K* functions  :math:`(\\Psi_k)_{k\\in K}`  used in the 
    decomposition."

// ---------------------------------------------------------------------

%feature("docstring") OT::FunctionalChaosResult::getTransformation
"Get the isoprobabilistic transformation.

Returns
-------
transformation : :class:`~openturns.Function`
    Transformation :math:`T` such that :math:`T(\\vect{X}) = \\vect{Z}`."
