%define OT_DistributionFactory_doc
"Base class for probability distribution factories.

Notes
-----
This class generally describes the factory mechanism of each OpenTURNS
distribution. Refer to :ref:`parametric_estimation` for information on the specific
estimators used for each distribution.
"
%enddef
%feature("docstring") OT::DistributionFactoryImplementation
OT_DistributionFactory_doc

// ---------------------------------------------------------------------

%define OT_DistributionFactory_build_doc
"Build the distribution.

**Available usages**:

    build(*sample*)

    build(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
dist : :class:`~openturns.Distribution`
    The built distribution."
%enddef
%feature("docstring") OT::DistributionFactoryImplementation::build
OT_DistributionFactory_build_doc

// ---------------------------------------------------------------------

%define OT_DistributionFactory_buildEstimator_doc
"Build the distribution and the parameter distribution.

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
parameters : :class:`~openturns.DistributionParameters`
    Optional, the parametrization.

Returns
-------
resDist : :class:`~openturns.DistributionFactoryResult`
    The results.

Notes
-----
According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

    - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
    - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
    - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

    - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
    - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.
"
%enddef
%feature("docstring") OT::DistributionFactoryImplementation::buildEstimator
OT_DistributionFactory_buildEstimator_doc

// ---------------------------------------------------------------------

%define OT_DistributionFactory_getBootstrapSize_doc
"Accessor to the bootstrap size.

Returns
-------
size : integer
    Size of the bootstrap."
%enddef
%feature("docstring") OT::DistributionFactoryImplementation::getBootstrapSize
OT_DistributionFactory_getBootstrapSize_doc

// ---------------------------------------------------------------------

%define OT_DistributionFactory_setBootstrapSize_doc
"Accessor to the bootstrap size.

Parameters
----------
size : integer
    Size of the bootstrap."
%enddef
%feature("docstring") OT::DistributionFactoryImplementation::setBootstrapSize
OT_DistributionFactory_setBootstrapSize_doc

