/* libgit2-glib-1.0.vapi generated by vapigen.EXE, do not modify. */

[CCode (cprefix = "Ggit", gir_namespace = "Ggit", gir_version = "1.0", lower_case_cprefix = "ggit_")]
namespace Ggit {
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_annotated_commit_ref", type_id = "ggit_annotated_commit_get_type ()", unref_function = "ggit_annotated_commit_unref")]
	[Compact]
	public class AnnotatedCommit {
		[CCode (has_construct_function = false)]
		public AnnotatedCommit.from_ref (Ggit.Repository repository, Ggit.Ref @ref) throws GLib.Error;
		public Ggit.OId? get_id ();
		public unowned Ggit.AnnotatedCommit? @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_blame_get_type ()")]
	public class Blame : Ggit.Native {
		[CCode (has_construct_function = false)]
		protected Blame ();
		public Ggit.Blame? from_buffer ([CCode (array_length_cname = "buffer_length", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] buffer) throws GLib.Error;
		public static Ggit.BlameFlags get_flags (Ggit.BlameOptions blame_options);
		public Ggit.BlameHunk get_hunk_by_index (uint32 idx);
		public Ggit.BlameHunk get_hunk_by_line (uint32 line);
		public uint32 get_hunk_count ();
		public static void set_flags (Ggit.BlameOptions blame_options, Ggit.BlameFlags flags);
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_blame_hunk_ref", type_id = "ggit_blame_hunk_get_type ()", unref_function = "ggit_blame_hunk_unref")]
	[Compact]
	public class BlameHunk {
		public unowned Ggit.OId? get_final_commit_id ();
		public unowned Ggit.Signature? get_final_signature ();
		public uint16 get_final_start_line_number ();
		public uint16 get_lines_in_hunk ();
		public unowned Ggit.OId? get_orig_commit_id ();
		public unowned string? get_orig_path ();
		public unowned Ggit.Signature? get_orig_signature ();
		public uint16 get_orig_start_line_number ();
		public bool is_boundary ();
		public unowned Ggit.BlameHunk? @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ggit_blame_options_get_type ()")]
	[Compact]
	public class BlameOptions {
		[CCode (has_construct_function = false)]
		public BlameOptions ();
		public Ggit.BlameOptions? copy ();
		public void free ();
		public uint32 get_maximum_line ();
		public uint32 get_minimum_line ();
		public uint16 get_minimum_match_characters ();
		public Ggit.OId? get_newest_commit ();
		public Ggit.OId? get_oldest_commit ();
		public void set_maximum_line (uint32 line);
		public void set_minimum_line (uint32 line);
		public void set_minimum_match_characters (uint16 characters);
		public void set_newest_commit (Ggit.OId? oid);
		public void set_oldest_commit (Ggit.OId? oid);
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_blob_get_type ()")]
	public class Blob : Ggit.Object {
		[CCode (has_construct_function = false)]
		protected Blob ();
		[CCode (array_length_pos = 0.1, array_length_type = "gsize")]
		public unowned uint8[]? get_raw_content ();
		public bool is_binary ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_blob_output_stream_get_type ()")]
	public class BlobOutputStream : GLib.OutputStream {
		[CCode (has_construct_function = false)]
		protected BlobOutputStream ();
		public Ggit.OId? get_id () throws GLib.Error;
		[NoAccessorMethod]
		public Ggit.Repository repository { construct; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_branch_get_type ()")]
	public class Branch : Ggit.Ref {
		[CCode (has_construct_function = false)]
		protected Branch ();
		public void @delete () throws GLib.Error;
		public unowned string? get_name () throws GLib.Error;
		public Ggit.Ref? get_upstream () throws GLib.Error;
		public bool is_head () throws GLib.Error;
		public Ggit.Branch? move (string new_branch_name, Ggit.CreateFlags flags) throws GLib.Error;
		public void set_upstream (string upstream_branch_name) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_branch_enumerator_ref", type_id = "ggit_branch_enumerator_get_type ()", unref_function = "ggit_branch_enumerator_unref")]
	[Compact]
	public class BranchEnumerator {
		public Ggit.Ref? @get ();
		public unowned Ggit.BranchEnumerator? iterator ();
		public bool next ();
		public Ggit.BranchEnumerator? @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_checkout_options_get_type ()")]
	public class CheckoutOptions : GLib.Object {
		[CCode (has_construct_function = false)]
		public CheckoutOptions ();
		public unowned string? get_ancestor_label ();
		public unowned Ggit.Tree? get_baseline ();
		public uint get_dir_mode ();
		public bool get_disable_filters ();
		public uint get_file_mode ();
		public int get_file_open_flags ();
		public Ggit.CheckoutNotifyFlags get_notify_flags ();
		public unowned string? get_our_label ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[]? get_paths ();
		public Ggit.CheckoutStrategy get_strategy ();
		public unowned string? get_target_directory ();
		public unowned string? get_their_label ();
		[NoWrapper]
		public virtual int notify (Ggit.CheckoutNotifyFlags why, string path, Ggit.DiffFile baseline, Ggit.DiffFile target, Ggit.DiffFile workdir);
		[NoWrapper]
		public virtual void progress (string path, size_t completed_steps, size_t total_steps);
		public void set_ancestor_label (string? label);
		public void set_baseline (Ggit.Tree? tree);
		public void set_dir_mode (uint dir_mode);
		public void set_disable_filters (bool disable);
		public void set_file_mode (uint file_mode);
		public void set_file_open_flags (int flags);
		public void set_notify_flags (Ggit.CheckoutNotifyFlags flags);
		public void set_our_label (string? label);
		public void set_paths ([CCode (array_length = false, array_null_terminated = true)] string[]? paths);
		public void set_strategy (Ggit.CheckoutStrategy strategy);
		public void set_target_directory (string? directory);
		public void set_their_label (string? label);
		public string ancestor_label { get; set; }
		public Ggit.Tree baseline { get; set; }
		public uint dir_mode { get; set; }
		public bool disable_filters { get; set; }
		public uint file_mode { get; set; }
		public int file_open_flags { get; set; }
		public Ggit.CheckoutNotifyFlags notify_flags { get; set; }
		public string our_label { get; set; }
		public Ggit.CheckoutStrategy strategy { get; set; }
		public string target_directory { get; set; }
		public string their_label { get; set; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_cherry_pick_options_get_type ()")]
	public class CherryPickOptions : GLib.Object {
		[CCode (has_construct_function = false)]
		public CherryPickOptions ();
		public unowned Ggit.CheckoutOptions get_checkout_options ();
		public uint get_mainline ();
		public Ggit.MergeOptions get_merge_options ();
		public void set_checkout_options (Ggit.CheckoutOptions? checkout_options);
		public void set_mainline (uint mainline);
		public void set_merge_options (Ggit.MergeOptions? merge_options);
		public Ggit.CheckoutOptions checkout_options { get; set; }
		public uint mainline { get; set; }
		public Ggit.MergeOptions merge_options { owned get; set; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_clone_options_get_type ()")]
	public class CloneOptions : GLib.Object {
		[CCode (has_construct_function = false)]
		public CloneOptions ();
		[NoWrapper]
		public virtual Ggit.Remote? create_remote (Ggit.Repository repository, string name, string url) throws GLib.Error;
		[NoWrapper]
		public virtual Ggit.Repository? create_repository (string path, bool is_bare) throws GLib.Error;
		public unowned string get_checkout_branch ();
		public unowned Ggit.FetchOptions get_fetch_options ();
		public bool get_is_bare ();
		public Ggit.CloneLocal get_local ();
		public void set_checkout_branch (string? checkout_branch);
		public void set_fetch_options (Ggit.FetchOptions? fetch_options);
		public void set_is_bare (bool bare);
		public void set_local (Ggit.CloneLocal local);
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_commit_get_type ()")]
	public class Commit : Ggit.Object {
		[CCode (has_construct_function = false)]
		protected Commit ();
		public Ggit.OId? amend (string? update_ref, Ggit.Signature author, Ggit.Signature committer, string? message_encoding, string message, Ggit.Tree tree) throws GLib.Error;
		public Ggit.Signature? get_author ();
		public Ggit.Signature? get_committer ();
		public unowned string? get_message ();
		public unowned string? get_message_encoding ();
		public Ggit.Commit? get_nth_ancestor (uint n) throws GLib.Error;
		public Ggit.CommitParents? get_parents ();
		public unowned string? get_subject ();
		public Ggit.Tree? get_tree ();
		public Ggit.OId? get_tree_id ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_commit_parents_get_type ()")]
	public class CommitParents : GLib.Object {
		[CCode (has_construct_function = false)]
		public CommitParents (Ggit.Commit commit);
		public Ggit.Commit? @get (uint idx);
		public Ggit.OId? get_id (uint idx);
		public uint get_size ();
		[NoAccessorMethod]
		public Ggit.Commit commit { owned get; construct; }
		public uint size { get; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_config_get_type ()")]
	public class Config : Ggit.Native {
		[CCode (has_construct_function = false)]
		public Config ();
		public void add_file (GLib.File file, Ggit.ConfigLevel level, bool force) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Config.@default () throws GLib.Error;
		public bool delete_entry (string name) throws GLib.Error;
		public static GLib.File find_global ();
		public static GLib.File find_system ();
		public bool @foreach (Ggit.ConfigCallback callback) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Config.from_file (GLib.File file) throws GLib.Error;
		public bool get_bool (string name) throws GLib.Error;
		public Ggit.ConfigEntry get_entry (string name) throws GLib.Error;
		public int32 get_int32 (string name) throws GLib.Error;
		public int64 get_int64 (string name) throws GLib.Error;
		public unowned string? get_string (string name) throws GLib.Error;
		public string? match (GLib.Regex regex, out GLib.MatchInfo match_info) throws GLib.Error;
		public bool match_foreach (GLib.Regex regex, Ggit.ConfigMatchCallback callback) throws GLib.Error;
		public Ggit.Config open_level (Ggit.ConfigLevel level) throws GLib.Error;
		public bool set_bool (string name, bool value) throws GLib.Error;
		public bool set_int32 (string name, int32 value) throws GLib.Error;
		public bool set_int64 (string name, int64 value) throws GLib.Error;
		public bool set_string (string name, string value) throws GLib.Error;
		public Ggit.Config snapshot () throws GLib.Error;
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_config_entry_ref", type_id = "ggit_config_entry_get_type ()", unref_function = "ggit_config_entry_unref")]
	[Compact]
	public class ConfigEntry {
		public Ggit.ConfigLevel get_level ();
		public unowned string? get_name ();
		public unowned string? get_value ();
		public unowned Ggit.ConfigEntry? @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_cred_get_type ()")]
	public class Cred : Ggit.Native {
		[CCode (has_construct_function = false)]
		protected Cred ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_cred_plaintext_get_type ()")]
	public class CredPlaintext : Ggit.Cred, GLib.Initable {
		[CCode (has_construct_function = false)]
		public CredPlaintext (string username, string password) throws GLib.Error;
		public unowned string get_password ();
		public unowned string get_username ();
		public string password { get; construct; }
		public string username { get; construct; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_cred_ssh_interactive_get_type ()")]
	public class CredSshInteractive : Ggit.Cred, GLib.Initable {
		[CCode (has_construct_function = false)]
		public CredSshInteractive (string username) throws GLib.Error;
		public unowned string get_username ();
		[NoWrapper]
		public virtual void prompt ([CCode (array_length_cname = "num_prompts", array_length_pos = 1.1, array_length_type = "gsize")] Ggit.CredSshInteractivePrompt[] prompts);
		public string username { get; construct; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_cred_ssh_interactive_prompt_ref", type_id = "ggit_cred_ssh_interactive_prompt_get_type ()", unref_function = "ggit_cred_ssh_interactive_prompt_unref")]
	[Compact]
	public class CredSshInteractivePrompt {
		[CCode (has_construct_function = false)]
		public CredSshInteractivePrompt (string name, string instruction, string text, bool is_masked);
		public unowned string get_instruction ();
		public unowned string get_name ();
		public unowned string get_response ();
		public unowned string get_text ();
		public bool is_masked ();
		public Ggit.CredSshInteractivePrompt @ref ();
		public void set_response (string response);
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_cred_ssh_key_from_agent_get_type ()")]
	public class CredSshKeyFromAgent : Ggit.Cred, GLib.Initable {
		[CCode (has_construct_function = false)]
		public CredSshKeyFromAgent (string username) throws GLib.Error;
		public unowned string? get_username ();
		public string username { get; construct; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_diff_get_type ()")]
	public class Diff : Ggit.Native {
		[CCode (has_construct_function = false)]
		protected Diff ();
		public static void blob_to_buffer (Ggit.Blob? old_blob, string? old_as_path, [CCode (array_length_cname = "buffer_len", array_length_pos = 3.5, array_length_type = "gssize")] uint8[]? buffer, string? buffer_as_path, Ggit.DiffOptions? diff_options, [CCode (delegate_target_pos = 9.1)] Ggit.DiffFileCallback? file_cb, [CCode (delegate_target_pos = 9.1)] Ggit.DiffBinaryCallback? binary_cb, [CCode (delegate_target_pos = 9.1)] Ggit.DiffHunkCallback? hunk_cb, Ggit.DiffLineCallback? line_cb) throws GLib.Error;
		public static void blobs (Ggit.Blob? old_blob, string? old_as_path, Ggit.Blob? new_blob, string? new_as_path, Ggit.DiffOptions? diff_options, [CCode (delegate_target_pos = 9.1)] Ggit.DiffFileCallback? file_cb, [CCode (delegate_target_pos = 9.1)] Ggit.DiffBinaryCallback? binary_cb, [CCode (delegate_target_pos = 9.1)] Ggit.DiffHunkCallback? hunk_cb, Ggit.DiffLineCallback? line_cb) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Diff.buffers ([CCode (array_length_cname = "buffer1_len", array_length_pos = 1.5, array_length_type = "gssize")] uint8[]? buffer1, string? buffer1_as_path, [CCode (array_length_cname = "buffer2_len", array_length_pos = 3.5, array_length_type = "gssize")] uint8[]? buffer2, string? buffer2_as_path, Ggit.DiffOptions? diff_options) throws GLib.Error;
		public bool find_similar (Ggit.DiffFindOptions? options) throws GLib.Error;
		public void @foreach ([CCode (delegate_target_pos = 4.1)] Ggit.DiffFileCallback? file_cb, [CCode (delegate_target_pos = 4.1)] Ggit.DiffBinaryCallback? binary_cb, [CCode (delegate_target_pos = 4.1)] Ggit.DiffHunkCallback? hunk_cb, Ggit.DiffLineCallback? line_cb) throws GLib.Error;
		public string? format_email (Ggit.DiffFormatEmailOptions options) throws GLib.Error;
		public Ggit.DiffDelta? get_delta (size_t index);
		public size_t get_num_deltas ();
		[CCode (has_construct_function = false)]
		public Diff.index_to_workdir (Ggit.Repository repository, Ggit.Index? index, Ggit.DiffOptions? diff_options) throws GLib.Error;
		public void merge (Ggit.Diff from) throws GLib.Error;
		public void print (Ggit.DiffFormatType type, Ggit.DiffLineCallback print_cb) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Diff.tree_to_index (Ggit.Repository repository, Ggit.Tree? old_tree, Ggit.Index? index, Ggit.DiffOptions? diff_options) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Diff.tree_to_tree (Ggit.Repository repository, Ggit.Tree? old_tree, Ggit.Tree? new_tree, Ggit.DiffOptions? diff_options) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Diff.tree_to_workdir (Ggit.Repository repository, Ggit.Tree? old_tree, Ggit.DiffOptions? diff_options) throws GLib.Error;
		[NoAccessorMethod]
		public Ggit.Repository repository { owned get; construct; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_diff_binary_ref", type_id = "ggit_diff_binary_get_type ()", unref_function = "ggit_diff_binary_unref")]
	[Compact]
	public class DiffBinary {
		public unowned Ggit.DiffBinaryFile? get_new_file ();
		public unowned Ggit.DiffBinaryFile? get_old_file ();
		public unowned Ggit.DiffBinary? @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_diff_binary_file_ref", type_id = "ggit_diff_binary_file_get_type ()", unref_function = "ggit_diff_binary_file_unref")]
	[Compact]
	public class DiffBinaryFile {
		public Ggit.DiffBinaryType get_binary_type ();
		public uint8 get_data (size_t? size);
		public size_t get_inflated_size ();
		public Ggit.DiffBinaryFile @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_diff_delta_ref", type_id = "ggit_diff_delta_get_type ()", unref_function = "ggit_diff_delta_unref")]
	[Compact]
	public class DiffDelta {
		public Ggit.DiffFlag get_flags ();
		public unowned Ggit.DiffFile? get_new_file ();
		public unowned Ggit.DiffFile? get_old_file ();
		public uint get_similarity ();
		public Ggit.DeltaType get_status ();
		public unowned Ggit.DiffDelta? @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_diff_file_ref", type_id = "ggit_diff_file_get_type ()", unref_function = "ggit_diff_file_unref")]
	[Compact]
	public class DiffFile {
		public Ggit.DiffFlag get_flags ();
		public uint16 get_mode ();
		public unowned Ggit.OId? get_oid ();
		public unowned string? get_path ();
		public int64 get_size ();
		public unowned Ggit.DiffFile? @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_diff_find_options_get_type ()")]
	public class DiffFindOptions : GLib.Object {
		[CCode (has_construct_function = false)]
		public DiffFindOptions ();
		public uint get_copy_threshold ();
		public Ggit.DiffFindFlags get_flags ();
		public unowned Ggit.DiffSimilarityMetric? get_metric ();
		public uint get_rename_from_rewrite_threshold ();
		public size_t get_rename_limit ();
		public uint get_rename_threshold ();
		public void set_copy_threshold (uint threshold);
		public void set_flags (Ggit.DiffFindFlags flags);
		public void set_metric (Ggit.DiffSimilarityMetric metric);
		public void set_rename_from_rewrite_threshold (uint threshold);
		public void set_rename_limit (size_t limit);
		public void set_rename_threshold (uint threshold);
		public uint copy_threshold { get; set; }
		public Ggit.DiffFindFlags flags { get; set; }
		public Ggit.DiffSimilarityMetric metric { get; set; }
		public uint rename_from_rewrite_threshold { get; set; }
		public uint rename_limit { get; set; }
		public uint rename_threshold { get; set; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_diff_format_email_options_get_type ()")]
	public class DiffFormatEmailOptions : GLib.Object {
		[CCode (has_construct_function = false)]
		public DiffFormatEmailOptions ();
		public unowned Ggit.Signature? get_author ();
		public unowned string? get_body ();
		public Ggit.DiffFormatEmailFlags get_flags ();
		public unowned Ggit.OId? get_id ();
		public size_t get_patch_number ();
		public unowned string? get_summary ();
		public size_t get_total_patches ();
		public void set_author (Ggit.Signature? author);
		public void set_body (string? body);
		public void set_flags (Ggit.DiffFormatEmailFlags flags);
		public void set_id (Ggit.OId? id);
		public void set_patch_number (size_t number);
		public void set_summary (string? summary);
		public void set_total_patches (size_t patches);
		public Ggit.Signature author { get; set; }
		public string body { get; set; }
		public Ggit.DiffFormatEmailFlags flags { get; set; }
		public Ggit.OId id { get; set; }
		public uint64 patch_number { get; set; }
		public string summary { get; set; }
		public uint64 total_patches { get; set; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_diff_hunk_ref", type_id = "ggit_diff_hunk_get_type ()", unref_function = "ggit_diff_hunk_unref")]
	[Compact]
	public class DiffHunk {
		public unowned string get_header ();
		public int get_new_lines ();
		public int get_new_start ();
		public int get_old_lines ();
		public int get_old_start ();
		public unowned Ggit.DiffHunk? @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_diff_line_ref", type_id = "ggit_diff_line_get_type ()", unref_function = "ggit_diff_line_unref")]
	[Compact]
	public class DiffLine {
		[CCode (array_length_pos = 0.1, array_length_type = "gsize")]
		public unowned uint8[] get_content ();
		public int64 get_content_offset ();
		public int get_new_lineno ();
		public int get_old_lineno ();
		public Ggit.DiffLineType get_origin ();
		public unowned string? get_text ();
		public unowned Ggit.DiffLine? @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_diff_options_get_type ()")]
	public class DiffOptions : GLib.Object {
		[CCode (has_construct_function = false)]
		public DiffOptions ();
		public Ggit.DiffOption get_flags ();
		public int get_n_context_lines ();
		public int get_n_interhunk_lines ();
		public unowned string? get_new_prefix ();
		public string? get_old_prefix ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[]? get_pathspec ();
		public void set_flags (Ggit.DiffOption flags);
		public void set_n_context_lines (int n);
		public void set_n_interhunk_lines (int n);
		public void set_new_prefix (string prefix);
		public void set_old_prefix (string prefix);
		public void set_pathspec ([CCode (array_length = false, array_null_terminated = true)] string[]? pathspec);
		public Ggit.DiffOption flags { get; set construct; }
		public int n_context_lines { get; set construct; }
		public int n_interhunk_lines { get; set construct; }
		public string new_prefix { get; set construct; }
		public string old_prefix { owned get; set construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] pathspec { get; set construct; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ggit_diff_similarity_metric_get_type ()")]
	[Compact]
	public class DiffSimilarityMetric {
		[CCode (has_construct_function = false)]
		public DiffSimilarityMetric (Ggit.DiffSimilarityMetricFileSignatureCallback file_signature, Ggit.DiffSimilarityMetricBufferSignatureCallback buffer_signature, Ggit.DiffSimilarityMetricFreeSignatureCallback free_signature, Ggit.DiffSimilarityMetricSimilarityCallback similarity);
		public Ggit.DiffSimilarityMetric? copy ();
		public void free ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ggit_fetch_options_get_type ()")]
	[Compact]
	public class FetchOptions {
		[CCode (has_construct_function = false)]
		public FetchOptions ();
		public Ggit.FetchOptions? copy ();
		public void free ();
		public Ggit.RemoteDownloadTagsType get_download_tags ();
		public unowned Ggit.RemoteCallbacks? get_remote_callbacks ();
		public void set_download_tags (Ggit.RemoteDownloadTagsType download_tags);
		public void set_remote_callbacks (Ggit.RemoteCallbacks? callbacks);
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_index_get_type ()")]
	public class Index : Ggit.Native, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected Index ();
		public bool add (Ggit.IndexEntry entry) throws GLib.Error;
		public bool add_file (GLib.File file) throws GLib.Error;
		public bool add_path (string path) throws GLib.Error;
		public Ggit.IndexEntries? get_entries ();
		public Ggit.IndexEntriesResolveUndo? get_entries_resolve_undo ();
		public Ggit.Repository? get_owner ();
		public bool has_conflicts ();
		public static Ggit.Index? open (GLib.File file) throws GLib.Error;
		public bool read (bool force) throws GLib.Error;
		public bool remove (GLib.File file, int stage) throws GLib.Error;
		public bool write () throws GLib.Error;
		public Ggit.OId? write_tree () throws GLib.Error;
		public Ggit.OId? write_tree_to (Ggit.Repository repository) throws GLib.Error;
		[NoAccessorMethod]
		public GLib.File file { owned get; construct; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_index_entries_ref", type_id = "ggit_index_entries_get_type ()", unref_function = "ggit_index_entries_unref")]
	[Compact]
	public class IndexEntries {
		public Ggit.IndexEntry? get_by_index (size_t idx);
		public Ggit.IndexEntry? get_by_path (GLib.File file, int stage);
		public unowned Ggit.IndexEntries? @ref ();
		public uint size ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_index_entries_resolve_undo_ref", type_id = "ggit_index_entries_resolve_undo_get_type ()", unref_function = "ggit_index_entries_resolve_undo_unref")]
	[Compact]
	public class IndexEntriesResolveUndo {
		public Ggit.IndexEntryResolveUndo? @get (uint idx);
		public Ggit.IndexEntryResolveUndo? get_by_file (GLib.File file);
		public unowned Ggit.IndexEntriesResolveUndo? @ref ();
		public uint size ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_index_entry_ref", type_id = "ggit_index_entry_get_type ()", unref_function = "ggit_index_entry_unref")]
	[Compact]
	public class IndexEntry {
		public uint get_dev ();
		public int64 get_file_size ();
		public uint get_flags ();
		public uint get_flags_extended ();
		public uint get_gid ();
		public Ggit.OId? get_id ();
		public uint get_ino ();
		public uint get_mode ();
		public unowned string get_path ();
		public uint get_uid ();
		public bool is_conflict ();
		public unowned Ggit.IndexEntry? @ref ();
		public void set_commit (Ggit.Commit commit);
		public void set_dev (uint dev);
		public void set_file_size (int64 file_size);
		public void set_flags (uint flags);
		public void set_flags_extended (uint flags_extended);
		public void set_gid (uint gid);
		public void set_id (Ggit.OId? id);
		public void set_ino (uint ino);
		public void set_mode (uint mode);
		public void set_path (string? path);
		public void set_uid (uint uid);
		public bool stat (GLib.File file) throws GLib.Error;
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_index_entry_resolve_undo_ref", type_id = "ggit_index_entry_resolve_undo_get_type ()", unref_function = "ggit_index_entry_resolve_undo_unref")]
	[Compact]
	public class IndexEntryResolveUndo {
		public GLib.File? get_file ();
		public Ggit.OId? get_id (int stage);
		public uint get_mode (int stage);
		public unowned Ggit.IndexEntryResolveUndo? @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_mailmap_get_type ()")]
	public class Mailmap : Ggit.Native {
		[CCode (has_construct_function = false)]
		public Mailmap () throws GLib.Error;
		public void add_entry (string? real_name, string? real_email, string? replace_name, string replace_email) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Mailmap.from_repository (Ggit.Repository repository) throws GLib.Error;
		public void resolve (out unowned string real_name, out unowned string real_email, string replace_name, string replace_email) throws GLib.Error;
		public Ggit.Signature? resolve_signature (Ggit.Signature signature) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ggit_merge_options_get_type ()")]
	[Compact]
	public class MergeOptions {
		[CCode (has_construct_function = false)]
		public MergeOptions ();
		public Ggit.MergeOptions? copy ();
		public void free ();
		public Ggit.MergeFileFavor get_file_favor ();
		public Ggit.MergeFileFlags get_file_flags ();
		public Ggit.MergeFlags get_flags ();
		public uint get_rename_threshold ();
		public unowned Ggit.DiffSimilarityMetric? get_similarity_metric ();
		public uint get_target_limit ();
		public void set_file_favor (Ggit.MergeFileFavor file_favor);
		public void set_file_flags (Ggit.MergeFileFlags file_flags);
		public void set_flags (Ggit.MergeFlags flags);
		public void set_rename_threshold (uint rename_threshold);
		public void set_similarity_metric (Ggit.DiffSimilarityMetric metric);
		public void set_target_limit (uint target_limit);
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_native_get_type ()")]
	public abstract class Native : Ggit.ObjectFactoryBase {
		[CCode (has_construct_function = false)]
		protected Native ();
		[NoAccessorMethod]
		public void* native { construct; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_note_ref", type_id = "ggit_note_get_type ()", unref_function = "ggit_note_unref")]
	[Compact]
	public class Note {
		public unowned Ggit.OId? get_id ();
		public unowned string? get_message ();
		public unowned Ggit.Note? @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ggit_oid_get_type ()")]
	[Compact]
	public class OId {
		public int compare (Ggit.OId b);
		public Ggit.OId? copy ();
		public bool equal (Ggit.OId b);
		public void free ();
		[CCode (has_construct_function = false)]
		public OId.from_raw ([CCode (array_length = false, array_null_terminated = true)] uint8[] raw);
		[CCode (has_construct_function = false)]
		public OId.from_string (string str);
		public bool has_prefix (string prefix);
		public uint hash ();
		public bool is_zero ();
		public string? to_string ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_object_get_type ()")]
	public abstract class Object : Ggit.Native {
		[CCode (has_construct_function = false)]
		protected Object ();
		public Ggit.OId? get_id ();
		public Ggit.Repository? get_owner ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_object_factory_get_type ()")]
	public class ObjectFactory : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ObjectFactory ();
		public GLib.Object? @construct (GLib.ObjectClass parent_class, GLib.Type basetype, [CCode (array_length_cname = "n_construct_properties", array_length_pos = 2.5, array_length_type = "guint")] GLib.ObjectConstructParam[] construct_properties);
		public static unowned Ggit.ObjectFactory get_default ();
		public void register (GLib.Type basetype, GLib.Type subtype);
		public void unregister (GLib.Type basetype, GLib.Type subtype);
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_object_factory_base_get_type ()")]
	public abstract class ObjectFactoryBase : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ObjectFactoryBase ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_patch_ref", type_id = "ggit_patch_get_type ()", unref_function = "ggit_patch_unref")]
	[Compact]
	public class Patch {
		[CCode (has_construct_function = false)]
		public Patch.from_blobs (Ggit.Blob? old_blob, string? old_as_path, Ggit.Blob? new_blob, string? new_as_path, Ggit.DiffOptions? diff_options) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Patch.from_diff (Ggit.Diff diff, size_t idx) throws GLib.Error;
		public Ggit.DiffDelta? get_delta ();
		public Ggit.DiffHunk? get_hunk (size_t idx) throws GLib.Error;
		public bool get_line_stats (out size_t total_context, out size_t total_additions, out size_t total_deletions) throws GLib.Error;
		public size_t get_num_hunks ();
		public int get_num_lines_in_hunk (size_t hunk);
		public unowned Ggit.Patch? @ref ();
		public bool to_stream (GLib.OutputStream stream) throws GLib.Error;
		public string? to_string () throws GLib.Error;
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_proxy_options_get_type ()")]
	public class ProxyOptions : GLib.Object {
		[CCode (has_construct_function = false)]
		public ProxyOptions ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_push_options_get_type ()")]
	public class PushOptions : GLib.Object {
		[CCode (has_construct_function = false)]
		public PushOptions ();
		public int get_parallelism ();
		public unowned Ggit.RemoteCallbacks? get_remote_callbacks ();
		public void set_parallelism (int parallelism);
		public void set_remote_callbacks (Ggit.RemoteCallbacks callbacks);
		[NoAccessorMethod]
		public Ggit.RemoteCallbacks callbacks { owned get; set; }
		public int parallelism { get; set construct; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_rebase_get_type ()")]
	public class Rebase : Ggit.Native {
		[CCode (has_construct_function = false)]
		protected Rebase ();
		public void abort () throws GLib.Error;
		public Ggit.OId? commit (Ggit.Signature? author, Ggit.Signature committer, string? message) throws GLib.Error;
		public void finish (Ggit.Signature? signature) throws GLib.Error;
		public Ggit.RebaseOperation? get_operation_by_index (size_t idx);
		public size_t get_operation_entry_count ();
		public size_t get_operation_index ();
		public Ggit.RebaseOperation? next () throws GLib.Error;
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_rebase_operation_ref", type_id = "ggit_rebase_operation_get_type ()", unref_function = "ggit_rebase_operation_unref")]
	[Compact]
	public class RebaseOperation {
		public unowned string? get_exec ();
		public Ggit.OId? get_id ();
		public Ggit.RebaseOperationType get_operation_type ();
		public unowned Ggit.RebaseOperation? @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ggit_rebase_options_get_type ()")]
	[Compact]
	public class RebaseOptions {
		[CCode (has_construct_function = false)]
		public RebaseOptions ();
		public Ggit.RebaseOptions? copy ();
		public void free ();
		public unowned Ggit.CheckoutOptions? get_checkout_options ();
		public bool get_quiet ();
		public unowned string? get_rewrite_notes_ref ();
		public void set_checkout_options (Ggit.CheckoutOptions checkout_options);
		public void set_quiet (bool quiet);
		public void set_rewrite_notes_ref (string rewrite_notes_ref);
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_ref_get_type ()")]
	public class Ref : Ggit.Native {
		[CCode (has_construct_function = false)]
		protected Ref ();
		public void @delete () throws GLib.Error;
		public void delete_log () throws GLib.Error;
		public Ggit.Reflog? get_log () throws GLib.Error;
		public unowned string? get_name ();
		public Ggit.Repository? get_owner ();
		public Ggit.RefType get_reference_type ();
		public unowned string? get_shorthand ();
		public unowned string? get_symbolic_target ();
		public Ggit.OId? get_target ();
		public bool has_log ();
		public bool is_branch ();
		public bool is_note ();
		public bool is_remote ();
		public bool is_tag ();
		public static bool is_valid_name (string name);
		public Ggit.Object? lookup () throws GLib.Error;
		public Ggit.Ref? rename (string new_name, bool force, string log_message) throws GLib.Error;
		public Ggit.Ref? resolve () throws GLib.Error;
		public Ggit.Ref? set_symbolic_target (string target, string? log_message) throws GLib.Error;
		public Ggit.Ref? set_target (Ggit.OId oid, string? log_message) throws GLib.Error;
		public unowned string? to_string ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_ref_spec_ref", type_id = "ggit_ref_spec_get_type ()", unref_function = "ggit_ref_spec_unref")]
	[Compact]
	public class RefSpec {
		public unowned string? get_destination ();
		public unowned string? get_source ();
		public bool is_forced ();
		public unowned Ggit.RefSpec? @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_reflog_ref", type_id = "ggit_reflog_get_type ()", unref_function = "ggit_reflog_unref")]
	[Compact]
	public class Reflog {
		public bool append (Ggit.OId oid, Ggit.Signature committer, string message) throws GLib.Error;
		public uint get_entry_count ();
		public Ggit.ReflogEntry? get_entry_from_index (uint idx);
		public unowned Ggit.Reflog? @ref ();
		public bool rename (string new_name) throws GLib.Error;
		public void unref ();
		public bool write () throws GLib.Error;
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_reflog_entry_ref", type_id = "ggit_reflog_entry_get_type ()", unref_function = "ggit_reflog_entry_unref")]
	[Compact]
	public class ReflogEntry {
		public unowned Ggit.Signature? get_committer ();
		public unowned string? get_message ();
		public Ggit.OId? get_new_id ();
		public Ggit.OId? get_old_id ();
		public unowned Ggit.ReflogEntry? @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_remote_get_type ()")]
	public class Remote : Ggit.Native {
		[CCode (has_construct_function = false)]
		public Remote (Ggit.Repository repository, string name, string url) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Remote.anonymous (Ggit.Repository repository, string url) throws GLib.Error;
		public void connect (Ggit.Direction direction, Ggit.RemoteCallbacks callbacks, Ggit.ProxyOptions? proxy_options, string? custom_headers) throws GLib.Error;
		public void disconnect ();
		public bool download ([CCode (array_length = false, array_null_terminated = true)] string[]? specs, Ggit.FetchOptions fetch_options) throws GLib.Error;
		public bool get_connected ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[]? get_fetch_specs () throws GLib.Error;
		public unowned string? get_name ();
		public Ggit.Repository? get_owner ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[]? get_push_specs () throws GLib.Error;
		public unowned string? get_url ();
		[CCode (array_length = false, array_null_terminated = true)]
		public Ggit.RemoteHead[]? list () throws GLib.Error;
		public void prune (Ggit.RemoteCallbacks callbacks) throws GLib.Error;
		public bool push ([CCode (array_length = false, array_null_terminated = true)] string[]? specs, Ggit.PushOptions push_options) throws GLib.Error;
		public bool update_tips (Ggit.RemoteCallbacks callbacks, bool update_fetch_head, Ggit.RemoteDownloadTagsType tags_type, string? message) throws GLib.Error;
		public bool upload ([CCode (array_length = false, array_null_terminated = true)] string[]? specs, Ggit.PushOptions push_options) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_remote_callbacks_get_type ()")]
	public class RemoteCallbacks : GLib.Object {
		[CCode (has_construct_function = false)]
		protected RemoteCallbacks ();
		[NoWrapper]
		public virtual Ggit.Cred? credentials (string url, string? username_from_url, Ggit.Credtype allowed_types) throws GLib.Error;
		public virtual signal void completion (Ggit.RemoteCompletionType type);
		public virtual signal void progress (string message);
		public virtual signal void transfer_progress (Ggit.TransferProgress stats);
		public virtual signal void update_tips (string refname, Ggit.OId a, Ggit.OId b);
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_remote_head_ref", type_id = "ggit_remote_head_get_type ()", unref_function = "ggit_remote_head_unref")]
	[Compact]
	public class RemoteHead {
		public unowned Ggit.OId? get_local_oid ();
		public unowned string? get_name ();
		public unowned Ggit.OId? get_oid ();
		public bool is_local ();
		public Ggit.RemoteHead @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_repository_get_type ()")]
	public class Repository : Ggit.Native, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected Repository ();
		public void add_remote_fetch (Ggit.Remote remote, string refspec) throws GLib.Error;
		public void add_remote_push (Ggit.Remote remote, string refspec) throws GLib.Error;
		public Ggit.Blame? blame_file (GLib.File file, Ggit.BlameOptions? blame_options) throws GLib.Error;
		public bool checkout_head (Ggit.CheckoutOptions? options) throws GLib.Error;
		public bool checkout_index (Ggit.Index? index, Ggit.CheckoutOptions? options) throws GLib.Error;
		public bool checkout_tree (Ggit.Object? tree, Ggit.CheckoutOptions? options) throws GLib.Error;
		public bool cherry_pick (Ggit.Commit commit, Ggit.CherryPickOptions options) throws GLib.Error;
		public Ggit.Index? cherry_pick_commit (Ggit.Commit commit, Ggit.Commit our_commit, uint mainline, Ggit.MergeOptions? merge_options) throws GLib.Error;
		public static Ggit.Repository? clone (string url, GLib.File location, Ggit.CloneOptions? options) throws GLib.Error;
		public Ggit.BlobOutputStream? create_blob ();
		public Ggit.OId? create_blob_from_buffer ([CCode (array_length_cname = "size", array_length_pos = 1.1, array_length_type = "gsize")] uint8[] buffer) throws GLib.Error;
		public Ggit.OId create_blob_from_file (GLib.File file) throws GLib.Error;
		public Ggit.OId? create_blob_from_path (string path) throws GLib.Error;
		public Ggit.Branch? create_branch (string branch_name, Ggit.Object target, Ggit.CreateFlags flags) throws GLib.Error;
		public Ggit.OId? create_commit (string? update_ref, Ggit.Signature author, Ggit.Signature committer, string? message_encoding, string message, Ggit.Tree tree, [CCode (array_length_cname = "parent_count", array_length_pos = 7.1)] Ggit.Commit[] parents) throws GLib.Error;
		public string? create_commit_buffer (Ggit.Signature author, Ggit.Signature committer, string? message_encoding, string message, Ggit.Tree tree, [CCode (array_length_cname = "parent_count", array_length_pos = 6.1)] Ggit.Commit[] parents) throws GLib.Error;
		public Ggit.OId? create_commit_from_ids (string? update_ref, Ggit.Signature author, Ggit.Signature committer, string? message_encoding, string message, Ggit.OId tree, [CCode (array_length_cname = "parent_count", array_length_pos = 7.1)] Ggit.OId[] parents) throws GLib.Error;
		public Ggit.OId? create_commit_with_signature (string commit_content, string? signature, string? signature_field) throws GLib.Error;
		public Ggit.IndexEntry? create_index_entry_for_file (GLib.File? file, Ggit.OId? id) throws GLib.Error;
		public Ggit.IndexEntry? create_index_entry_for_path (string? path, Ggit.OId? id) throws GLib.Error;
		public Ggit.OId? create_note (string? notes_ref, Ggit.Signature author, Ggit.Signature committer, Ggit.OId id, string note, bool force) throws GLib.Error;
		public Ggit.Ref? create_reference (string name, Ggit.OId oid, string log_message) throws GLib.Error;
		public Ggit.Remote? create_remote (string name, string url) throws GLib.Error;
		public Ggit.Ref? create_symbolic_reference (string name, string target, string log_message) throws GLib.Error;
		public Ggit.OId? create_tag (string tag_name, Ggit.Object target, Ggit.Signature tagger, string message, Ggit.CreateFlags flags) throws GLib.Error;
		public Ggit.OId? create_tag_annotation (string tag_name, Ggit.Object target, Ggit.Signature signature, string message) throws GLib.Error;
		public Ggit.OId? create_tag_from_buffer (string tag, Ggit.CreateFlags flags) throws GLib.Error;
		public Ggit.OId? create_tag_lightweight (string tag_name, Ggit.Object target, Ggit.CreateFlags flags) throws GLib.Error;
		public Ggit.TreeBuilder? create_tree_builder () throws GLib.Error;
		public Ggit.TreeBuilder? create_tree_builder_from_tree (Ggit.Tree tree) throws GLib.Error;
		public bool delete_tag (string name) throws GLib.Error;
		public static GLib.File? discover (GLib.File location) throws GLib.Error;
		public static GLib.File? discover_full (GLib.File location, bool across_fs, [CCode (array_length = false, array_null_terminated = true)] string[]? ceiling_dirs) throws GLib.Error;
		public void drop_stash (size_t index) throws GLib.Error;
		public Ggit.BranchEnumerator? enumerate_branches (Ggit.BranchType list_type) throws GLib.Error;
		public Ggit.StatusFlags file_status (GLib.File location) throws GLib.Error;
		public bool file_status_foreach (Ggit.StatusOptions? options, Ggit.StatusCallback callback) throws GLib.Error;
		public void get_ahead_behind (Ggit.OId local, Ggit.OId upstream, out size_t ahead, out size_t behind) throws GLib.Error;
		public unowned string? get_attribute (string path, string name, Ggit.AttributeCheckFlags flags) throws GLib.Error;
		public Ggit.Config? get_config () throws GLib.Error;
		public string? get_default_notes_ref () throws GLib.Error;
		public bool get_descendant_of (Ggit.OId commit, Ggit.OId ancestor) throws GLib.Error;
		public Ggit.Ref? get_head () throws GLib.Error;
		public Ggit.Index? get_index () throws GLib.Error;
		public GLib.File? get_location ();
		public Ggit.SubmoduleStatus get_submodule_status (string name, Ggit.SubmoduleIgnore ignore) throws GLib.Error;
		public GLib.File? get_workdir ();
		public static Ggit.Repository? init_repository (GLib.File location, bool is_bare) throws GLib.Error;
		public bool is_empty () throws GLib.Error;
		public bool is_head_detached () throws GLib.Error;
		public bool is_head_unborn () throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public string[]? list_remotes () throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public string[]? list_tags () throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public string[]? list_tags_match (string? pattern) throws GLib.Error;
		public Ggit.Object? lookup (Ggit.OId oid, GLib.Type gtype) throws GLib.Error;
		public Ggit.Blob? lookup_blob (Ggit.OId oid) throws GLib.Error;
		public Ggit.Branch? lookup_branch (string branch_name, Ggit.BranchType branch_type) throws GLib.Error;
		public Ggit.Commit? lookup_commit (Ggit.OId oid) throws GLib.Error;
		public Ggit.Ref? lookup_reference (string name) throws GLib.Error;
		public Ggit.Ref? lookup_reference_dwim (string short_name) throws GLib.Error;
		public Ggit.Remote? lookup_remote (string name) throws GLib.Error;
		public Ggit.Submodule? lookup_submodule (string name) throws GLib.Error;
		public Ggit.Tag? lookup_tag (Ggit.OId oid) throws GLib.Error;
		public Ggit.Tree? lookup_tree (Ggit.OId oid) throws GLib.Error;
		public void merge ([CCode (array_length_cname = "their_heads_length", array_length_pos = 1.5, array_length_type = "gsize")] Ggit.AnnotatedCommit[] their_heads, Ggit.MergeOptions merge_opts, Ggit.CheckoutOptions checkout_opts) throws GLib.Error;
		public Ggit.OId? merge_base (Ggit.OId oid_one, Ggit.OId oid_two) throws GLib.Error;
		public Ggit.Index? merge_commits (Ggit.Commit our_commit, Ggit.Commit their_commit, Ggit.MergeOptions merge_options) throws GLib.Error;
		public Ggit.Index? merge_trees (Ggit.Tree ancestor_tree, Ggit.Tree our_tree, Ggit.Tree their_tree, Ggit.MergeOptions merge_options) throws GLib.Error;
		public bool note_foreach (string? notes_ref, Ggit.NoteCallback callback) throws GLib.Error;
		public static Ggit.Repository? open (GLib.File location) throws GLib.Error;
		public bool path_is_ignored (string path) throws GLib.Error;
		public Ggit.Note? read_note (string? notes_ref, Ggit.OId id) throws GLib.Error;
		public Ggit.Rebase? rebase_init (Ggit.AnnotatedCommit? branch, Ggit.AnnotatedCommit? upstream, Ggit.AnnotatedCommit? onto, Ggit.RebaseOptions options) throws GLib.Error;
		public Ggit.Rebase? rebase_open (Ggit.RebaseOptions options) throws GLib.Error;
		public bool references_foreach (Ggit.ReferencesCallback callback) throws GLib.Error;
		public bool references_foreach_name (Ggit.ReferencesNameCallback callback) throws GLib.Error;
		public bool remove_note (string? notes_ref, Ggit.Signature author, Ggit.Signature committer, Ggit.OId id) throws GLib.Error;
		public bool remove_remote (string name) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public string[]? rename_remote (string name, string new_name) throws GLib.Error;
		public void reset (Ggit.Object target, Ggit.ResetType reset_type, Ggit.CheckoutOptions checkout_options) throws GLib.Error;
		public void reset_default (Ggit.Object? target, [CCode (array_length = false, array_null_terminated = true)] string[] pathspecs) throws GLib.Error;
		public bool revert (Ggit.Commit commit, Ggit.RevertOptions options) throws GLib.Error;
		public Ggit.Object? revparse (string spec) throws GLib.Error;
		public Ggit.OId? save_stash (Ggit.Signature stasher, string message, Ggit.StashFlags flags) throws GLib.Error;
		public bool set_head (string ref_name) throws GLib.Error;
		public bool set_head_detached (Ggit.OId oid) throws GLib.Error;
		public bool set_remote_url (string remote, string url) throws GLib.Error;
		public void set_submodule_fetch_recurse (string name, Ggit.SubmoduleRecurse fetch_recurse_submodules) throws GLib.Error;
		public void set_submodule_ignore (string name, Ggit.SubmoduleIgnore ignore) throws GLib.Error;
		public void set_submodule_update (string name, Ggit.SubmoduleUpdate update) throws GLib.Error;
		public void set_submodule_url (string name, string url) throws GLib.Error;
		public void set_workdir (GLib.File workdir, bool update_gitlink);
		public bool stash_foreach (Ggit.StashCallback callback) throws GLib.Error;
		public bool submodule_foreach (Ggit.SubmoduleCallback callback) throws GLib.Error;
		public bool tag_foreach (Ggit.TagCallback callback) throws GLib.Error;
		[NoAccessorMethod]
		public Ggit.CloneOptions clone_options { owned get; construct; }
		[NoAccessorMethod]
		public Ggit.Ref head { owned get; }
		[NoAccessorMethod]
		public bool init { get; construct; }
		[NoAccessorMethod]
		public bool is_bare { get; construct; }
		public GLib.File location { owned get; construct; }
		[NoAccessorMethod]
		public string url { owned get; construct; }
		[NoAccessorMethod]
		public GLib.File workdir { owned get; set construct; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ggit_revert_options_get_type ()")]
	[Compact]
	public class RevertOptions {
		[CCode (has_construct_function = false)]
		public RevertOptions (uint mainline, Ggit.MergeOptions? merge_options, Ggit.CheckoutOptions? checkout_options);
		public Ggit.RevertOptions? copy ();
		public void free ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_revision_walker_get_type ()")]
	public class RevisionWalker : Ggit.Native, GLib.Initable {
		[CCode (has_construct_function = false)]
		public RevisionWalker (Ggit.Repository repository) throws GLib.Error;
		public unowned Ggit.Repository? get_repository ();
		public void hide (Ggit.OId oid) throws GLib.Error;
		public void hide_glob (string item) throws GLib.Error;
		public void hide_head () throws GLib.Error;
		public void hide_ref (string item) throws GLib.Error;
		public Ggit.OId? next () throws GLib.Error;
		public void push (Ggit.OId oid) throws GLib.Error;
		public void push_glob (string item) throws GLib.Error;
		public void push_head () throws GLib.Error;
		public void push_range (string range) throws GLib.Error;
		public void push_ref (string item) throws GLib.Error;
		public void reset ();
		public void set_sort_mode (Ggit.SortMode sort_mode);
		[NoAccessorMethod]
		public Ggit.Repository repository { owned get; set construct; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_signature_get_type ()")]
	public class Signature : Ggit.Native {
		[CCode (has_construct_function = false)]
		public Signature (string name, string email, GLib.DateTime signature_time) throws GLib.Error;
		public Ggit.Signature? copy ();
		public unowned string? get_email ();
		public unowned string? get_name ();
		public GLib.DateTime? get_time ();
		public GLib.TimeZone? get_time_zone ();
		[CCode (has_construct_function = false)]
		public Signature.now (string name, string email) throws GLib.Error;
		[NoAccessorMethod]
		public string encoding { owned get; construct; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ggit_status_options_get_type ()")]
	[Compact]
	public class StatusOptions {
		[CCode (has_construct_function = false)]
		public StatusOptions (Ggit.StatusOption options, Ggit.StatusShow show, [CCode (array_length = false, array_null_terminated = true)] string[]? pathspec);
		public Ggit.StatusOptions? copy ();
		public void free ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_submodule_ref", type_id = "ggit_submodule_get_type ()", unref_function = "ggit_submodule_unref")]
	[Compact]
	public class Submodule {
		public bool get_fetch_recurse ();
		public Ggit.OId get_head_id ();
		public Ggit.SubmoduleIgnore get_ignore ();
		public Ggit.OId? get_index_id ();
		public unowned string? get_name ();
		public Ggit.Repository? get_owner ();
		public unowned string? get_path ();
		public Ggit.SubmoduleUpdate get_update ();
		public unowned string? get_url ();
		public Ggit.OId? get_workdir_id ();
		public void init (bool overwrite) throws GLib.Error;
		public Ggit.Repository? open () throws GLib.Error;
		public unowned Ggit.Submodule? @ref ();
		public void reload (bool force) throws GLib.Error;
		public void sync () throws GLib.Error;
		public void unref ();
		public void update (bool init, Ggit.SubmoduleUpdateOptions options) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_submodule_update_options_get_type ()")]
	public class SubmoduleUpdateOptions : GLib.Object {
		[CCode (has_construct_function = false)]
		public SubmoduleUpdateOptions ();
		public unowned Ggit.CheckoutOptions? get_checkout_options ();
		public Ggit.FetchOptions get_fetch_options ();
		public void set_checkout_options (Ggit.CheckoutOptions? checkout_options);
		public void set_fetch_options (Ggit.FetchOptions? fetch_options);
		public Ggit.CheckoutOptions checkout_options { get; set; }
		public Ggit.FetchOptions fetch_options { owned get; set; }
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_tag_get_type ()")]
	public class Tag : Ggit.Object {
		[CCode (has_construct_function = false)]
		protected Tag ();
		public unowned string? get_message ();
		public unowned string? get_name ();
		public Ggit.Signature? get_tagger ();
		public Ggit.Object? get_target () throws GLib.Error;
		public Ggit.OId? get_target_id ();
		public GLib.Type get_target_type ();
		public Ggit.Object? peel () throws GLib.Error;
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ggit_transfer_progress_get_type ()")]
	[Compact]
	public class TransferProgress {
		public Ggit.TransferProgress? copy ();
		public void free ();
		public uint get_indexed_objects ();
		public size_t get_received_bytes ();
		public uint get_received_objects ();
		public uint get_total_objects ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_tree_get_type ()")]
	public class Tree : Ggit.Object {
		[CCode (has_construct_function = false)]
		protected Tree ();
		public Ggit.TreeEntry? @get (uint i);
		public Ggit.TreeEntry? get_by_name (string name);
		public Ggit.TreeEntry? get_by_path (string path) throws GLib.Error;
		public Ggit.OId? get_id ();
		public uint size ();
		public void walk (Ggit.TreeWalkMode mode, Ggit.TreeWalkCallback callback) throws GLib.Error;
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", type_id = "ggit_tree_builder_get_type ()")]
	public class TreeBuilder : Ggit.Native {
		[CCode (has_construct_function = false)]
		protected TreeBuilder ();
		public void clear ();
		public Ggit.TreeEntry? get_entry (string path);
		public Ggit.TreeEntry? insert (string filename, Ggit.OId oid, Ggit.FileMode file_mode) throws GLib.Error;
		public void remove (string path) throws GLib.Error;
		public Ggit.OId? write () throws GLib.Error;
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", ref_function = "ggit_tree_entry_ref", type_id = "ggit_tree_entry_get_type ()", unref_function = "ggit_tree_entry_unref")]
	[Compact]
	public class TreeEntry {
		public Ggit.FileMode get_file_mode ();
		public Ggit.OId? get_id ();
		public unowned string? get_name ();
		public GLib.Type get_object_type ();
		public unowned Ggit.TreeEntry? @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_ATTRIBUTE_CHECK_", type_id = "ggit_attribute_check_flags_get_type ()")]
	[Flags]
	public enum AttributeCheckFlags {
		FILE_THEN_INDEX,
		INDEX_THEN_FILE,
		INDEX_ONLY,
		NO_SYSTEM
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_BLAME_", type_id = "ggit_blame_flags_get_type ()")]
	[Flags]
	public enum BlameFlags {
		NORMAL,
		TRACK_COPIES_SAME_FILE
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_BRANCH_", type_id = "ggit_branch_type_get_type ()")]
	public enum BranchType {
		LOCAL,
		REMOTE
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_CHECKOUT_NOTIFY_", type_id = "ggit_checkout_notify_flags_get_type ()")]
	[Flags]
	public enum CheckoutNotifyFlags {
		NONE,
		CONFLICT,
		DIRTY,
		UPDATED,
		UNTRACKED,
		IGNORED,
		ALL
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_CHECKOUT_", type_id = "ggit_checkout_strategy_get_type ()")]
	[Flags]
	public enum CheckoutStrategy {
		NONE,
		SAFE,
		FORCE,
		RECREATE_MISSING,
		ALLOW_CONFLICTS,
		REMOVE_UNTRACKED,
		REMOVE_IGNORED,
		UPDATE_ONLY,
		DONT_UPDATE_INDEX,
		NO_REFRESH,
		SKIP_UNMERGED,
		USE_OURS,
		USE_THEIRS,
		DISABLE_PATHSPEC_MATCH,
		SKIP_LOCKED_DIRECTORIES,
		DONT_OVERWRITE_IGNORED,
		CONFLICT_STYLE_MERGE,
		CONFLICT_STYLE_DIFF3,
		DONT_REMOVE_EXISTING,
		DONT_WRITE_INDEX,
		UPDATE_SUBMODULES,
		UPDATE_SUBMODULES_IF_CHANGED
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_CLONE_LOCAL_", type_id = "ggit_clone_local_get_type ()")]
	public enum CloneLocal {
		AUTO,
		LOCAL,
		NO_LOCAL,
		NO_LINKS
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_CONFIG_LEVEL_", type_id = "ggit_config_level_get_type ()")]
	public enum ConfigLevel {
		PROGRAMDATA,
		SYSTEM,
		XDG,
		GLOBAL,
		LOCAL,
		APP,
		HIGHEST
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_CREATE_", type_id = "ggit_create_flags_get_type ()")]
	[Flags]
	public enum CreateFlags {
		NONE,
		FORCE
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_CREDTYPE_", type_id = "ggit_credtype_get_type ()")]
	[Flags]
	public enum Credtype {
		USERPASS_PLAINTEXT,
		SSH_KEY,
		SSH_CUSTOM,
		DEFAULT,
		SSH_INTERACTIVE
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_DELTA_", type_id = "ggit_delta_type_get_type ()")]
	public enum DeltaType {
		UNMODIFIED,
		ADDED,
		DELETED,
		MODIFIED,
		RENAMED,
		COPIED,
		IGNORED,
		UNTRACKED,
		TYPECHANGE,
		UNREADABLE,
		CONFLICTED
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_DIFF_BINARY_", type_id = "ggit_diff_binary_type_get_type ()")]
	public enum DiffBinaryType {
		NONE,
		LITERAL,
		DELTA
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_DIFF_", type_id = "ggit_diff_find_flags_get_type ()")]
	[Flags]
	public enum DiffFindFlags {
		FIND_BY_CONFIG,
		FIND_RENAMES,
		FIND_RENAMES_FROM_REWRITES,
		FIND_COPIES,
		FIND_COPIES_FROM_UNMODIFIED,
		FIND_REWRITES,
		BREAK_REWRITES,
		FIND_AND_BREAK_REWRITES,
		FIND_FOR_UNTRACKED,
		FIND_ALL,
		FIND_IGNORE_LEADING_WHITESPACE,
		FIND_IGNORE_WHITESPACE,
		FIND_DONT_IGNORE_WHITESPACE,
		FIND_EXACT_MATCH_ONLY,
		BREAK_REWRITES_FOR_RENAMES_ONLY,
		FIND_REMOVE_UNMODIFIED
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_DIFF_FLAG_", type_id = "ggit_diff_flag_get_type ()")]
	[Flags]
	public enum DiffFlag {
		BINARY,
		NOT_BINARY,
		VALID_ID
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_DIFF_FORMAT_EMAIL_", type_id = "ggit_diff_format_email_flags_get_type ()")]
	[Flags]
	public enum DiffFormatEmailFlags {
		NONE,
		EXCLUDE_SUBJECT_PATCH_MARKER
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_DIFF_FORMAT_", type_id = "ggit_diff_format_type_get_type ()")]
	public enum DiffFormatType {
		PATCH,
		PATCH_HEADER,
		RAW,
		NAME_ONLY,
		NAME_STATUS
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_DIFF_LINE_", type_id = "ggit_diff_line_type_get_type ()")]
	public enum DiffLineType {
		CONTEXT,
		ADDITION,
		DELETION,
		CONTEXT_EOFNL,
		ADD_EOFNL,
		DEL_EOFNL,
		FILE_HDR,
		HUNK_HDR,
		BINARY
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_DIFF_", type_id = "ggit_diff_option_get_type ()")]
	[Flags]
	public enum DiffOption {
		NORMAL,
		REVERSE,
		INCLUDE_IGNORED,
		RECURSE_IGNORED_DIRS,
		INCLUDE_UNTRACKED,
		RECURSE_UNTRACKED_DIRS,
		INCLUDE_UNMODIFIED,
		INCLUDE_TYPECHANGE,
		INCLUDE_TYPECHANGE_TREES,
		IGNORE_FILE_MODE,
		IGNORE_SUBMODULES,
		IGNORE_CASE,
		DISABLE_PATHSPEC_MATCH,
		SKIP_BINARY_CHECK,
		ENABLE_FAST_UNTRACKED_DIRS,
		FORCE_TEXT,
		FORCE_BINARY,
		IGNORE_WHITESPACE,
		IGNORE_WHITESPACE_CHANGE,
		IGNORE_WHITESPACE_EOL,
		SHOW_UNTRACKED_CONTENT,
		SHOW_UNMODIFIED,
		PATIENCE,
		MINIMAL,
		SHOW_BINARY
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_DIRECTION_", type_id = "ggit_direction_get_type ()")]
	public enum Direction {
		FETCH,
		PUSH
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_FEATURE_", type_id = "ggit_feature_flags_get_type ()")]
	[Flags]
	public enum FeatureFlags {
		THREADS,
		HTTPS,
		SSH
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_FILE_MODE_", type_id = "ggit_file_mode_get_type ()")]
	public enum FileMode {
		UNREADABLE,
		TREE,
		BLOB,
		BLOB_EXECUTABLE,
		LINK,
		COMMIT
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_MERGE_FILE_FAVOR_", type_id = "ggit_merge_file_favor_get_type ()")]
	public enum MergeFileFavor {
		NORMAL,
		OURS,
		THEIRS,
		UNION
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_MERGE_FILE_", type_id = "ggit_merge_file_flags_get_type ()")]
	[Flags]
	public enum MergeFileFlags {
		DEFAULT,
		STYLE_MERGE,
		STYLE_DIFF3,
		SIMPLIFY_ALNUM,
		IGNORE_WHITESPACE,
		IGNORE_WHITESPACE_CHANGE,
		IGNORE_WHITESPACE_EOL,
		DIFF_PATIENCE,
		DIFF_MINIMAL
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_MERGE_", type_id = "ggit_merge_flags_get_type ()")]
	[Flags]
	public enum MergeFlags {
		FIND_RENAMES,
		FAIL_ON_CONFLICT,
		SKIP_REUC,
		NO_RECURSIVE
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_PACKBUILDER_STAGE_", type_id = "ggit_packbuilder_stage_get_type ()")]
	public enum PackbuilderStage {
		ADDING_OBJECTS,
		DELTAFICATION
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_PROXY_", type_id = "ggit_proxy_type_get_type ()")]
	public enum ProxyType {
		NONE,
		AUTO,
		SPECIFIED
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_REBASE_OPERATION_", type_id = "ggit_rebase_operation_type_get_type ()")]
	public enum RebaseOperationType {
		PICK,
		REWORD,
		EDIT,
		SQUASH,
		FIXUP,
		EXEC
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_REF_", type_id = "ggit_ref_type_get_type ()")]
	public enum RefType {
		INVALID,
		OID,
		SYMBOLIC,
		LISTALL
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_REMOTE_COMPLETION_", type_id = "ggit_remote_completion_type_get_type ()")]
	public enum RemoteCompletionType {
		DOWNLOAD,
		INDEXING,
		ERROR
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_REMOTE_DOWNLOAD_TAGS_", type_id = "ggit_remote_download_tags_type_get_type ()")]
	public enum RemoteDownloadTagsType {
		UNSPECIFIED,
		AUTO,
		NONE,
		ALL
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_RESET_", type_id = "ggit_reset_type_get_type ()")]
	public enum ResetType {
		SOFT,
		MIXED,
		HARD
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_SORT_", type_id = "ggit_sort_mode_get_type ()")]
	[Flags]
	public enum SortMode {
		NONE,
		TOPOLOGICAL,
		TIME,
		REVERSE
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_STASH_", type_id = "ggit_stash_flags_get_type ()")]
	[Flags]
	public enum StashFlags {
		DEFAULT,
		KEEP_INDEX,
		INCLUDE_UNTRACKED,
		INCLUDE_IGNORED
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_STATUS_", type_id = "ggit_status_flags_get_type ()")]
	[Flags]
	public enum StatusFlags {
		CURRENT,
		INDEX_NEW,
		INDEX_MODIFIED,
		INDEX_DELETED,
		INDEX_RENAMED,
		INDEX_TYPECHANGE,
		WORKING_TREE_NEW,
		WORKING_TREE_MODIFIED,
		WORKING_TREE_DELETED,
		WORKING_TREE_TYPECHANGE,
		WORKING_TREE_RENAMED,
		WORKING_TREE_UNREADABLE,
		IGNORED,
		CONFLICTED
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_STATUS_OPTION_", type_id = "ggit_status_option_get_type ()")]
	[Flags]
	public enum StatusOption {
		INCLUDE_UNTRACKED,
		INCLUDE_IGNORED,
		INCLUDE_UNMODIFIED,
		EXCLUDE_SUBMODULES,
		RECURSE_UNTRACKED_DIRS,
		DISABLE_PATHSPEC_MATCH,
		RECURSE_IGNORED_DIRS,
		RENAMES_HEAD_TO_INDEX,
		RENAMES_INDEX_TO_WORKDIR,
		SORT_CASE_SENSITIVELY,
		SORT_CASE_INSENSITIVELY,
		DEFAULT
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_STATUS_SHOW_", type_id = "ggit_status_show_get_type ()")]
	public enum StatusShow {
		INDEX_AND_WORKDIR,
		INDEX_ONLY,
		WORKDIR_ONLY
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_SUBMODULE_IGNORE_", type_id = "ggit_submodule_ignore_get_type ()")]
	public enum SubmoduleIgnore {
		UNSPECIFIED,
		NONE,
		UNTRACKED,
		DIRTY,
		ALL
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_SUBMODULE_RECURSE_", type_id = "ggit_submodule_recurse_get_type ()")]
	public enum SubmoduleRecurse {
		NO,
		YES,
		ONDEMAND
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_SUBMODULE_STATUS_", type_id = "ggit_submodule_status_get_type ()")]
	[Flags]
	public enum SubmoduleStatus {
		IN_HEAD,
		IN_INDEX,
		IN_CONFIG,
		IN_WD,
		INDEX_ADDED,
		INDEX_DELETED,
		INDEX_MODIFIED,
		WD_UNINITIALIZED,
		WD_ADDED,
		WD_DELETED,
		WD_MODIFIED,
		WD_INDEX_MODIFIED,
		WD_WD_MODIFIED,
		WD_UNTRACKED
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_SUBMODULE_UPDATE_", type_id = "ggit_submodule_update_get_type ()")]
	public enum SubmoduleUpdate {
		CHECKOUT,
		REBASE,
		MERGE,
		NONE,
		DEFAULT
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_TREE_WALK_MODE_", type_id = "ggit_tree_walk_mode_get_type ()")]
	public enum TreeWalkMode {
		PRE,
		POST
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cprefix = "GGIT_ERROR_", type_id = "ggit_error_get_type ()")]
	public errordomain Error {
		GIT_ERROR,
		NOTFOUND,
		EXISTS,
		AMBIGUOUS,
		BUFS,
		PASSTHROUGH,
		ITEROVER;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 1.9)]
	public delegate int ConfigCallback (Ggit.ConfigEntry entry);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 2.9)]
	public delegate int ConfigMatchCallback (GLib.MatchInfo match_info, string value);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 4.9)]
	public delegate int CredAcquireCallback (string url, string? username_from_url, uint allowed_types, owned Ggit.Cred cred);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 2.9)]
	public delegate int DiffBinaryCallback (Ggit.DiffDelta delta, Ggit.DiffBinary binary);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 2.9)]
	public delegate int DiffFileCallback (Ggit.DiffDelta delta, float progress);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 2.9)]
	public delegate int DiffHunkCallback (Ggit.DiffDelta delta, Ggit.DiffHunk hunk);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 3.9)]
	public delegate int DiffLineCallback (Ggit.DiffDelta delta, Ggit.DiffHunk? hunk, Ggit.DiffLine line);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 4.9)]
	public delegate int DiffSimilarityMetricBufferSignatureCallback (Ggit.DiffFile file, string buf, size_t buflen, void* @out);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 3.9)]
	public delegate int DiffSimilarityMetricFileSignatureCallback (Ggit.DiffFile file, string fullpath, void* @out);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 1.9)]
	public delegate void DiffSimilarityMetricFreeSignatureCallback (void* signature);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 3.9)]
	public delegate int DiffSimilarityMetricSimilarityCallback (int score, void* signature_a, void* signature_b);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 2.9)]
	public delegate int NoteCallback (Ggit.OId blob_id, Ggit.OId annotated_object_id);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 1.9)]
	public delegate int ReferencesCallback (owned Ggit.Ref reference);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 1.9)]
	public delegate int ReferencesNameCallback (string name);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 4.9)]
	public delegate int RemoteListCallback (string name, Ggit.OId oid, Ggit.OId loid, bool local);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 3.9)]
	public delegate int StashCallback (size_t index, string message, Ggit.OId stash_oid);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 2.9)]
	public delegate int StatusCallback (string path, Ggit.StatusFlags status_flags);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 2.9)]
	public delegate int SubmoduleCallback (Ggit.Submodule submodule, string name);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 2.9)]
	public delegate int TagCallback (string name, Ggit.OId tag_oid);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 1.9)]
	public delegate int TransferProgressCallback (Ggit.TransferProgress stats);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", instance_pos = 2.9)]
	public delegate int TreeWalkCallback (string root, Ggit.TreeEntry entry);
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cname = "GGIT_BUILD_TYPE")]
	public const string BUILD_TYPE;
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cname = "GGIT_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cname = "GGIT_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "libgit2-glib/ggit.h", cname = "GGIT_VERSION_S")]
	public const string VERSION_S;
	[CCode (cheader_filename = "libgit2-glib/ggit.h")]
	[Version (replacement = "Error.quark")]
	public static GLib.Quark error_quark ();
	[CCode (cheader_filename = "libgit2-glib/ggit.h")]
	public static Ggit.FeatureFlags get_features ();
	[CCode (cheader_filename = "libgit2-glib/ggit.h")]
	public static void init ();
	[CCode (cheader_filename = "libgit2-glib/ggit.h")]
	public static string message_prettify (string message, bool strip_comments, char comment_char);
}
