#ifndef _CEGOGROUPNODE_H_INCLUDED_
#define _CEGOGROUPNODE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoGroupNode.h
// ---------------
// Cego group node class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoGroupNode
// 
// Description: Grouping entry handle for grouped select queries
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDE
#include <lfcbase/ListT.h>

// CEGO INCLUDES
#include "CegoField.h"

class CegoGroupNode {

public:
    
    CegoGroupNode();
    CegoGroupNode(ListT<CegoField>& key);
    CegoGroupNode(ListT<CegoField>& key, ListT<CegoField>& grouping);
    ~CegoGroupNode();
    
    ListT<CegoField>& getKey();
    ListT<CegoField>& getGrouping();
    void setGrouping(ListT<CegoField>& grouping);

    CegoGroupNode& operator = ( const CegoGroupNode& n);    
    bool operator == ( const CegoGroupNode& n);
    bool operator < ( const CegoGroupNode& n);
    bool operator > ( const CegoGroupNode& n);
    
private:
    
    ListT<CegoField> _key;
    ListT<CegoField> _grouping;
    
};

#endif
