/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.Message;
import sun.plugin2.message.Queue;
import sun.plugin2.message.transport.Transport;
import sun.plugin2.util.SystemUtil;

public class Pipe {
    private static final boolean DEBUG = SystemUtil.isDebug();
    private Transport transport;
    private boolean initiatingSide;
    private static final ThreadLocal perThreadMsgQueue = new ThreadLocal();
    private Queue mainMsgQueue = new Queue();
    private Map activeConversations = new HashMap();
    private int curConversationID;
    private volatile boolean shouldShutdown;
    private volatile boolean shutdownComplete;

    public Pipe(Transport transport, boolean bl) {
        if (DEBUG) {
            System.out.println("Pipe.cstr: " + transport.toString());
        }
        this.transport = transport;
        this.initiatingSide = bl;
        WorkerThread workerThread = new WorkerThread();
        workerThread.setDaemon(true);
        workerThread.start();
    }

    public void send(Message message) throws IOException {
        this.transport.write(message);
    }

    public Message poll() throws IOException {
        this.checkForShutdown();
        return this.mainMsgQueue.get();
    }

    public Message poll(Conversation conversation) throws IOException {
        this.checkForShutdown();
        Queue queue = (Queue)perThreadMsgQueue.get();
        if (queue == null) {
            return null;
        }
        return queue.get(-1, conversation);
    }

    public Message receive(long l) throws InterruptedException, IOException {
        this.checkForShutdown();
        return this.mainMsgQueue.waitForMessage(l);
    }

    public Message receive(long l, Conversation conversation) throws InterruptedException, IOException {
        this.checkForShutdown();
        Queue queue = (Queue)perThreadMsgQueue.get();
        if (queue == null) {
            return null;
        }
        return queue.waitForMessage(l, -1, conversation);
    }

    public synchronized Conversation beginConversation() {
        int n = this.curConversationID++;
        Conversation conversation = new Conversation(this.initiatingSide, n);
        Queue queue = (Queue)perThreadMsgQueue.get();
        if (queue == null) {
            queue = new Queue();
            perThreadMsgQueue.set(queue);
        }
        this.activeConversations.put(conversation, queue);
        return conversation;
    }

    public synchronized boolean joinConversation(Conversation conversation) {
        Queue queue = (Queue)this.activeConversations.get(conversation);
        Queue queue2 = (Queue)perThreadMsgQueue.get();
        if (queue != null) {
            return queue == queue2;
        }
        if (queue2 == null) {
            queue2 = new Queue();
            perThreadMsgQueue.set(queue2);
        }
        this.activeConversations.put(conversation, queue2);
        return true;
    }

    public void endConversation(Conversation conversation) {
        this.activeConversations.remove(conversation);
    }

    public void shutdown() {
        this.shouldShutdown = true;
    }

    private synchronized Queue getQueue(Conversation conversation) {
        return (Queue)this.activeConversations.get(conversation);
    }

    private synchronized void interruptActiveQueues() {
        this.mainMsgQueue.interrupt();
        Iterator iterator = this.activeConversations.values().iterator();
        while (iterator.hasNext()) {
            ((Queue)iterator.next()).interrupt();
        }
    }

    public boolean shutdownComplete() {
        return this.shutdownComplete;
    }

    private void checkForShutdown() throws IOException {
        if (this.shutdownComplete) {
            throw new IOException("Pipe is already shut down");
        }
    }

    class WorkerThread
    extends Thread {
        public WorkerThread() {
            super("Java Plug-In Pipe Worker Thread (" + (Pipe.this.initiatingSide ? "Server-Side" : "Client-Side") + ")");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                block12: {
                    try {
                        while (!Pipe.this.shouldShutdown) {
                            Message message = null;
                            Pipe.this.transport.waitForData(500L);
                            while ((message = Pipe.this.transport.read()) != null) {
                                Queue queue;
                                Conversation conversation = message.getConversation();
                                boolean bl = false;
                                if (conversation != null && (queue = Pipe.this.getQueue(conversation)) != null) {
                                    queue.put(message);
                                    bl = true;
                                }
                                if (bl) continue;
                                Pipe.this.mainMsgQueue.put(message);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        Pipe.this.interruptActiveQueues();
                        if (!DEBUG) break block12;
                        System.out.println("Terminating " + Thread.currentThread().getName() + " due to exception:");
                        iOException.printStackTrace();
                    }
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                Pipe.this.shutdownComplete = true;
                Pipe pipe = Pipe.this;
                synchronized (pipe) {
                    Pipe.this.notifyAll();
                }
                throw throwable;
            }
            Pipe.this.shutdownComplete = true;
            Pipe pipe = Pipe.this;
            synchronized (pipe) {
                Pipe.this.notifyAll();
            }
        }
    }
}

