/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.cache.DeployCacheJarAccess;
import com.sun.deploy.cache.DeployCacheJarAccessImpl;
import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CPCallbackClassLoaderIf;
import com.sun.deploy.security.DeployURLClassPathCallback;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class CPCallbackHandler {
    private List childURLs = Collections.synchronizedList(new ArrayList());
    private HashMap assertJars = new HashMap();
    private DeployURLClassPathCallback pcb;
    private DeployURLClassPathCallback ccb;
    private Map resource2trust = new HashMap();
    private Map package2trust = new HashMap();
    private Map defaultCS = new HashMap();
    private Set trustedCS = new HashSet();
    private Set authenticatedCS = new HashSet();
    private Set unauthenticatedCS = new HashSet();
    static CodeSource untrustedCS = new CodeSource(null, (Certificate[])null);
    private static DeployCacheJarAccess jarAccess = DeployCacheJarAccessImpl.getJarAccess();
    private CPCallbackClassLoaderIf parent;
    private CPCallbackClassLoaderIf child;

    public CPCallbackHandler(CPCallbackClassLoaderIf cPCallbackClassLoaderIf, CPCallbackClassLoaderIf cPCallbackClassLoaderIf2) {
        this.parent = cPCallbackClassLoaderIf;
        this.child = cPCallbackClassLoaderIf2;
        this.pcb = new ParentCallback();
        this.ccb = new ChildCallback();
    }

    public DeployURLClassPathCallback getParentCallback() {
        return this.pcb;
    }

    public DeployURLClassPathCallback getChildCallback() {
        return this.ccb;
    }

    private boolean hasTrustedLibraryAssertion(JarFile jarFile) {
        try {
            Attributes attributes;
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null) {
                Attributes.Name name = new Attributes.Name("Trusted-Library");
                boolean bl = Boolean.valueOf(attributes.getValue(name));
                Attributes.Name name2 = new Attributes.Name("X-Trusted-Library");
                boolean bl2 = Boolean.valueOf(attributes.getValue(name2));
                if (bl2) {
                    Trace.println("old X-Trusted-Library assertion in JAR", TraceLevel.SECURITY);
                }
                return bl || bl2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean hasTrustedOnlyAssertion(JarFile jarFile) {
        try {
            Attributes attributes;
            Manifest manifest = jarFile.getManifest();
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null) {
                Attributes.Name name = new Attributes.Name("Trusted-Only");
                boolean bl = Boolean.valueOf(attributes.getValue(name));
                Attributes.Name name2 = new Attributes.Name("X-Signed-Only");
                boolean bl2 = Boolean.valueOf(attributes.getValue(name2));
                if (bl2) {
                    Trace.println("old X-Signed-Only assertion in JAR", TraceLevel.SECURITY);
                }
                return bl || bl2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private synchronized String assertTrust(JarFile jarFile, CodeSource[] codeSourceArray) {
        HashMap<String, CodeSource> hashMap = new HashMap<String, CodeSource>();
        HashMap<String, CodeSource> hashMap2 = new HashMap<String, CodeSource>();
        String string = null;
        for (int i = 0; i < codeSourceArray.length; ++i) {
            Enumeration enumeration = jarAccess.entryNames(jarFile, new CodeSource[]{codeSourceArray[i]});
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2.endsWith(".class")) {
                    string2 = string2.replace('/', '.');
                    string2 = this.getPackage(string2.substring(0, string2.length() - 6));
                    hashMap.put(string2, codeSourceArray[i]);
                    continue;
                }
                if (string2.endsWith("/")) continue;
                hashMap2.put(string2, codeSourceArray[i]);
            }
        }
        Set set = hashMap.entrySet();
        Set set2 = hashMap2.entrySet();
        Map.Entry[] entryArray = set.toArray(new Map.Entry[set.size()]);
        Map.Entry[] entryArray2 = set2.toArray(new Map.Entry[set2.size()]);
        int n = this.setTrust(this.resource2trust, entryArray2);
        if (n != -1) {
            string = "untrusted resource \"" + (String)entryArray2[n].getKey() + "\" in class path";
        }
        if ((n = this.setTrust(this.package2trust, entryArray)) != -1) {
            this.unwindTrust(this.resource2trust, entryArray2);
            string = "untrusted class package \"" + (String)entryArray[n].getKey() + "\" in class path";
        }
        return string;
    }

    private String getPackage(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? "" : string.substring(0, n);
    }

    private int setTrust(Map map, Map.Entry[] entryArray) {
        int n;
        for (n = 0; n < entryArray.length; ++n) {
            CodeSource codeSource = this.setTrust(map, (String)entryArray[n].getKey(), (CodeSource)entryArray[n].getValue());
            if (codeSource == null) continue;
            CodeSource codeSource2 = (CodeSource)entryArray[n].getValue();
            if (!codeSource.equals(codeSource2) && this.isTrusted(codeSource) != this.isTrusted(codeSource2)) break;
            entryArray[n] = null;
        }
        if (n == entryArray.length) {
            return -1;
        }
        this.unwindTrust(map, entryArray, n);
        return n;
    }

    private CodeSource setTrust(Map map, String string, CodeSource codeSource) {
        CodeSource codeSource2 = (CodeSource)map.get(string);
        if (codeSource2 == null) {
            map.put(string, codeSource);
            return null;
        }
        return codeSource2;
    }

    private void unwindTrust(Map map, Map.Entry[] entryArray, int n) {
        if (n == 0) {
            return;
        }
        --n;
        while (n >= 0) {
            if (entryArray[n] != null) {
                map.remove(entryArray[n].getKey());
            }
            --n;
        }
    }

    private void unwindTrust(Map map, Map.Entry[] entryArray) {
        this.unwindTrust(map, entryArray, entryArray.length);
    }

    private synchronized boolean checkPackage(String string, CodeSource codeSource, Boolean bl) {
        CodeSource codeSource2 = this.setTrust(this.package2trust, string, codeSource);
        return codeSource2 == null || codeSource2.equals(codeSource) || this.isTrusted(codeSource2) == bl;
    }

    private synchronized boolean checkResource(String string, CodeSource codeSource, Boolean bl) {
        CodeSource codeSource2 = this.setTrust(this.resource2trust, string, codeSource);
        return codeSource2 == null || codeSource2.equals(codeSource) || this.isTrusted(codeSource2) == bl;
    }

    private synchronized void mergeTrustedSources(CodeSource[] codeSourceArray) {
        for (int i = 0; i < codeSourceArray.length; ++i) {
            this.trustedCS.add(codeSourceArray[i]);
        }
    }

    private synchronized Boolean isTrusted(CodeSource codeSource) {
        if (codeSource == untrustedCS) {
            return Boolean.FALSE;
        }
        return this.trustedCS.contains(codeSource);
    }

    private synchronized Boolean isAuthenticated(CodeSource codeSource) {
        if (codeSource == untrustedCS) {
            return Boolean.FALSE;
        }
        boolean bl = this.authenticatedCS.contains(codeSource);
        if (bl) {
            return Boolean.TRUE;
        }
        if (!this.unauthenticatedCS.contains(codeSource)) {
            Iterator iterator = this.trustedCS.iterator();
            while (iterator.hasNext()) {
                CodeSource codeSource2 = (CodeSource)iterator.next();
                CodeSource codeSource3 = Config.isJavaVersionAtLeast15() ? new CodeSource(codeSource.getLocation(), codeSource2.getCodeSigners()) : new CodeSource(codeSource.getLocation(), codeSource2.getCertificates());
                if (codeSource3.equals(codeSource)) {
                    this.authenticatedCS.add(codeSource);
                    return Boolean.TRUE;
                }
                this.unauthenticatedCS.add(codeSource);
            }
        }
        return Boolean.FALSE;
    }

    private synchronized CodeSource getDefaultCodeSource(URL uRL) {
        if (!this.trustedCS.isEmpty()) {
            CodeSource codeSource = (CodeSource)this.defaultCS.get(uRL);
            if (codeSource == null) {
                codeSource = new CodeSource(uRL, (Certificate[])null);
                this.defaultCS.put(uRL, codeSource);
            }
            return codeSource;
        }
        return untrustedCS;
    }

    private static int showMixedTrustDialog() {
        UIFactory uIFactory = ToolkitStore.getUI();
        ToolkitStore.getUI();
        return uIFactory.showMessageDialog(null, null, 4, ResourceManager.getString("security.dialog.mixcode.title"), ResourceManager.getString("security.dialog.mixcode.header"), ResourceManager.getString("security.dialog.mixcode.question"), ResourceManager.getString("security.dialog.mixcode.alert"), ResourceManager.getString("security.dialog.mixcode.buttonYes"), ResourceManager.getString("security.dialog.mixcode.buttonNo"), null);
    }

    private class ChildElement
    extends DeployURLClassPathCallback.Element {
        boolean skip;
        Boolean trusted;
        Boolean authenticated;
        CodeSource cs;

        ChildElement(JarFile jarFile, URL uRL) {
            super(jarFile, uRL);
            CodeSource[] codeSourceArray;
            this.cs = jarFile != null ? ((codeSourceArray = jarAccess.getCodeSources(jarFile, uRL)) != null ? codeSourceArray[0] : null) : CPCallbackHandler.this.getDefaultCodeSource(uRL);
            this.trusted = CPCallbackHandler.this.isTrusted(this.cs);
            this.authenticated = this.trusted == false && this.cs.getCertificates() != null ? CPCallbackHandler.this.isAuthenticated(this.cs) : Boolean.FALSE;
        }

        public void checkResource(String string) {
            Boolean bl;
            Boolean bl2;
            Boolean bl3;
            CodeSource codeSource;
            String string2 = null;
            if (string == null || string.endsWith("/")) {
                return;
            }
            if (this.jar != null) {
                codeSource = jarAccess.getCodeSource(this.jar, this.url, string);
                bl3 = codeSource == this.cs ? this.trusted : CPCallbackHandler.this.isTrusted(codeSource);
                Boolean bl4 = bl2 = this.authenticated != false ? this.authenticated : CPCallbackHandler.this.isAuthenticated(codeSource);
                bl = !bl3.booleanValue() && this.trusted.booleanValue() && string.startsWith("META-INF/") ? Boolean.TRUE : bl3;
            } else {
                codeSource = this.cs;
                bl = bl3 = this.trusted;
                bl2 = this.authenticated;
            }
            ((ParentCallback)CPCallbackHandler.this.pcb).check(this.url, bl, bl2);
            if (string.endsWith(".class")) {
                string2 = string.replace('/', '.');
                string2 = CPCallbackHandler.this.getPackage(string2.substring(0, string2.length() - 6));
            }
            if (string2 != null) {
                if (!CPCallbackHandler.this.checkPackage(string2, codeSource, bl3)) {
                    String string3 = string.replace('/', '.').substring(0, string.length() - 6);
                    String string4 = "class \"" + string3 + "\" does not match trust level of other classes in the same package";
                    throw new SecurityException(string4);
                }
            } else if (!CPCallbackHandler.this.checkResource(string, codeSource, bl3)) {
                String string5 = "resource \"" + string + "\" does not match trust level of other resources of the same name";
                throw new SecurityException(string5);
            }
        }

        void skip(boolean bl) {
            this.skip = bl;
        }

        public boolean skip() {
            return this.skip;
        }
    }

    private class ChildCallback
    extends DeployURLClassPathCallback {
        private ChildCallback() {
        }

        public DeployURLClassPathCallback.Element openClassPathElement(JarFile jarFile, URL uRL) throws IOException {
            ChildElement childElement = new ChildElement(jarFile, uRL);
            if (CPCallbackHandler.this.childURLs.contains(uRL)) {
                if (jarFile != null) {
                    jarAccess.setEagerValidation(jarFile, true);
                }
                return childElement;
            }
            childElement.skip(true);
            return childElement;
        }

        public DeployURLClassPathCallback.Element openClassPathElement(URL uRL) throws IOException {
            return this.openClassPathElement(null, uRL);
        }
    }

    private class ParentElement
    extends DeployURLClassPathCallback.Element {
        String pendingException;
        boolean defer;

        ParentElement(JarFile jarFile, URL uRL) {
            super(jarFile, uRL);
        }

        public void checkResource(String string) {
            if (this.pendingException != null) {
                throw new SecurityException(this.pendingException);
            }
            if (this.jar == null) {
                throw new SecurityException("invalid class path element " + this.url + " on Trusted-Library loader");
            }
        }

        void setPendingException(String string) {
            this.pendingException = string;
        }

        void defer(boolean bl) {
            this.defer = bl;
        }

        public boolean defer() {
            return this.defer;
        }

        public String toString() {
            return "defer: " + this.defer + ", pending: " + this.pendingException;
        }
    }

    private class ParentCallback
    extends DeployURLClassPathCallback {
        private boolean trustedChild;
        private boolean authenticatedChild;
        private boolean untrustedChild;
        private boolean trustedOnly;
        private boolean allowMixedTrust;
        private boolean checkMixedTrust;

        private ParentCallback() {
            if (Config.getMixcodeValue() == 0) {
                this.checkMixedTrust = true;
            }
            if (!this.checkMixedTrust && Config.getMixcodeValue() == 1) {
                this.allowMixedTrust = true;
            }
        }

        public synchronized DeployURLClassPathCallback.Element openClassPathElement(JarFile jarFile, URL uRL) throws IOException {
            jarAccess.setEagerValidation(jarFile, true);
            return this.strategy(jarFile, uRL, jarAccess.getCodeSources(jarFile, uRL));
        }

        public synchronized DeployURLClassPathCallback.Element openClassPathElement(URL uRL) throws IOException {
            return this.strategy(null, uRL, new CodeSource[]{new CodeSource(uRL, (Certificate[])null)});
        }

        private DeployURLClassPathCallback.Element strategy(JarFile jarFile, URL uRL, CodeSource[] codeSourceArray) {
            String string;
            CodeSource[] codeSourceArray2;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = this.trustedOnly;
            boolean bl4 = this.trustedChild;
            boolean bl5 = false;
            boolean bl6 = false;
            ParentElement parentElement = new ParentElement(jarFile, uRL);
            if (jarFile != null) {
                bl5 = CPCallbackHandler.this.hasTrustedLibraryAssertion(jarFile);
                bl6 = CPCallbackHandler.this.hasTrustedOnlyAssertion(jarFile);
            }
            if (bl6) {
                Trace.println(uRL + " is asserting Trusted-Only", TraceLevel.SECURITY);
                if (this.authenticatedChild || this.untrustedChild) {
                    parentElement.setPendingException("attempted to open Trusted-Only jar " + uRL + " on sandboxed loader");
                    return parentElement;
                }
            }
            if ((codeSourceArray2 = CPCallbackHandler.this.parent.getTrustedCodeSources(codeSourceArray)) != null && codeSourceArray2.length > 0) {
                bl = true;
                if (codeSourceArray2.length == codeSourceArray.length) {
                    bl2 = true;
                } else {
                    boolean bl7 = false;
                    for (int i = codeSourceArray.length - 1; i >= 0; --i) {
                        if (codeSourceArray[i].getCertificates() != null) continue;
                        CodeSource[] codeSourceArray3 = new CodeSource[]{codeSourceArray[i]};
                        Enumeration enumeration = jarAccess.entryNames(jarFile, codeSourceArray3);
                        while (enumeration.hasMoreElements()) {
                            String string2 = (String)enumeration.nextElement();
                            if (string2.startsWith("META-INF/")) continue;
                            bl7 = true;
                            break;
                        }
                        if (bl7) break;
                    }
                    bl2 = !bl7;
                }
                CPCallbackHandler.this.mergeTrustedSources(codeSourceArray2);
            }
            if (bl2) {
                if (bl5) {
                    if (this.authenticatedChild || this.untrustedChild) {
                        parentElement.setPendingException(CPCallbackHandler.this.assertTrust(jarFile, codeSourceArray2));
                        return parentElement;
                    }
                    CPCallbackHandler.this.assertJars.put(jarFile, codeSourceArray2);
                    return parentElement;
                }
                if (bl6 && !this.trustedOnly) {
                    Trace.println(uRL + " is newly asserting Trusted-Only", TraceLevel.SECURITY);
                    bl3 = true;
                }
            } else {
                if (bl6) {
                    parentElement.setPendingException("attempted to open sandboxed jar " + uRL + " as Trusted-Only");
                    return parentElement;
                }
                if (bl5) {
                    parentElement.setPendingException("attempted to open sandboxed jar " + uRL + " as a Trusted-Library");
                    return parentElement;
                }
            }
            if (bl && jarFile != null) {
                bl4 = true;
            }
            if (bl4 && this.untrustedChild && (string = this.checkAllowed(uRL, bl4 && this.trustedChild)) != null) {
                parentElement.setPendingException(string);
                return parentElement;
            }
            if (this.authenticatedChild || this.untrustedChild) {
                String string3;
                if (!CPCallbackHandler.this.assertJars.isEmpty()) {
                    Iterator iterator = CPCallbackHandler.this.assertJars.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        CPCallbackHandler.this.assertTrust((JarFile)entry.getKey(), (CodeSource[])entry.getValue());
                    }
                    CPCallbackHandler.this.assertJars.clear();
                }
                if (jarFile != null && bl && (string3 = CPCallbackHandler.this.assertTrust(jarFile, codeSourceArray2)) != null) {
                    parentElement.setPendingException(string3);
                    return parentElement;
                }
            } else if (jarFile != null && bl) {
                CPCallbackHandler.this.assertJars.put(jarFile, codeSourceArray2);
            }
            CPCallbackHandler.this.childURLs.add(uRL);
            this.trustedOnly = bl3;
            this.trustedChild = bl4;
            parentElement.defer(true);
            return parentElement;
        }

        private synchronized void check(URL uRL, boolean bl, boolean bl2) {
            Object object;
            boolean bl3 = this.trustedChild;
            boolean bl4 = this.untrustedChild;
            boolean bl5 = this.authenticatedChild;
            if (!bl && this.trustedOnly) {
                throw new SecurityException("Trusted-Only loader attempted to load sandboxed resource from " + uRL);
            }
            if (bl) {
                bl3 = true;
            } else if (bl2) {
                bl5 = true;
            } else {
                bl4 = true;
            }
            if (bl3 && bl4 && (object = this.checkAllowed(uRL, bl3 && this.trustedChild)) != null) {
                throw new SecurityException((String)object);
            }
            if ((bl5 || bl4) && !CPCallbackHandler.this.assertJars.isEmpty()) {
                object = CPCallbackHandler.this.assertJars.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    CPCallbackHandler.this.assertTrust((JarFile)entry.getKey(), (CodeSource[])entry.getValue());
                }
                CPCallbackHandler.this.assertJars.clear();
            }
            this.trustedChild = bl3;
            this.authenticatedChild = bl5;
            this.untrustedChild = bl4;
        }

        private String checkAllowed(URL uRL, boolean bl) {
            if (this.checkMixedTrust) {
                int n = CPCallbackHandler.showMixedTrustDialog();
                ToolkitStore.getUI();
                if (n == 1) {
                    this.allowMixedTrust = true;
                }
                this.checkMixedTrust = false;
            }
            if (!this.allowMixedTrust) {
                if (bl) {
                    return "trusted loader attempted to load sandboxed resource from " + uRL;
                }
                return "sandboxed loader attempted to load trusted resource from " + uRL;
            }
            return null;
        }
    }
}

