/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.asn1.ASN1Object;
import iaik.asn1.BOOLEAN;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.utils.InternalErrorException;
import iaik.utils.ObjectFactory;
import iaik.x509.UnknownExtension;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.AuthorityInfoAccess;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.CRLDistributionPoints;
import iaik.x509.extensions.CRLNumber;
import iaik.x509.extensions.CertificateIssuer;
import iaik.x509.extensions.CertificatePolicies;
import iaik.x509.extensions.DeltaCRLIndicator;
import iaik.x509.extensions.ErrorExtension;
import iaik.x509.extensions.ExtendedKeyUsage;
import iaik.x509.extensions.FreshestCRL;
import iaik.x509.extensions.HoldInstructionCode;
import iaik.x509.extensions.InhibitAnyPolicy;
import iaik.x509.extensions.InvalidityDate;
import iaik.x509.extensions.IssuerAltName;
import iaik.x509.extensions.IssuingDistributionPoint;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.NameConstraints;
import iaik.x509.extensions.PolicyConstraints;
import iaik.x509.extensions.PolicyMappings;
import iaik.x509.extensions.PrivateKeyUsagePeriod;
import iaik.x509.extensions.ReasonCode;
import iaik.x509.extensions.SubjectAltName;
import iaik.x509.extensions.SubjectDirectoryAttributes;
import iaik.x509.extensions.SubjectInfoAccess;
import iaik.x509.extensions.SubjectKeyIdentifier;
import iaik.x509.extensions.netscape.NetscapeBaseUrl;
import iaik.x509.extensions.netscape.NetscapeCaPolicyUrl;
import iaik.x509.extensions.netscape.NetscapeCaRevocationUrl;
import iaik.x509.extensions.netscape.NetscapeCertRenewalUrl;
import iaik.x509.extensions.netscape.NetscapeCertType;
import iaik.x509.extensions.netscape.NetscapeComment;
import iaik.x509.extensions.netscape.NetscapeRevocationUrl;
import iaik.x509.extensions.netscape.NetscapeSSLServerName;
import iaik.x509.extensions.ocsp.NoCheck;
import iaik.x509.extensions.priv.PublicAuthorityIdentifier;
import iaik.x509.extensions.priv.PublicServiceProvider;
import iaik.x509.extensions.qualified.BiometricInfo;
import iaik.x509.extensions.qualified.QCStatements;
import iaik.x509.extensions.smime.SMIMECapabilities;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class X509Extensions {
    static /* synthetic */ Class e;
    static /* synthetic */ Class f;
    static /* synthetic */ Class j;
    static /* synthetic */ Class c;
    static /* synthetic */ Class d;
    static /* synthetic */ Class k;
    static /* synthetic */ Class l;
    static /* synthetic */ Class m;
    static /* synthetic */ Class n;
    static /* synthetic */ Class o;
    static /* synthetic */ Class p;
    static /* synthetic */ Class q;
    static /* synthetic */ Class r;
    static /* synthetic */ Class lb;
    static /* synthetic */ Class eb;
    static /* synthetic */ Class gb;
    static /* synthetic */ Class w;
    static /* synthetic */ Class cb;
    static /* synthetic */ Class jb;
    static /* synthetic */ Class mb;
    static /* synthetic */ Class b;
    static /* synthetic */ Class hb;
    static /* synthetic */ Class fb;
    static /* synthetic */ Class t;
    static /* synthetic */ Class qb;
    static /* synthetic */ Class u;
    static /* synthetic */ Class s;
    static /* synthetic */ Class v;
    static /* synthetic */ Class x;
    static /* synthetic */ Class y;
    static /* synthetic */ Class z;
    static /* synthetic */ Class ab;
    static /* synthetic */ Class bb;
    static /* synthetic */ Class db;
    static /* synthetic */ Class ib;
    static /* synthetic */ Class nb;
    static /* synthetic */ Class kb;
    static /* synthetic */ Class ob;
    static /* synthetic */ Class pb;
    static /* synthetic */ Class rb;
    protected Hashtable noncritical_extensions;
    protected Hashtable critical_extensions = new Hashtable(20);
    private static ObjectFactory a;
    private static final Class g;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        V3Extension v3Extension = null;
        Enumeration enumeration = this.listExtensions();
        int n2 = 1;
        while (enumeration.hasMoreElements()) {
            v3Extension = (V3Extension)enumeration.nextElement();
            stringBuffer.append("Extension " + n2 + ":     ");
            if (v3Extension.isCritical()) {
                stringBuffer.append("critical        ");
            } else {
                stringBuffer.append("not critical    ");
            }
            String string = v3Extension.getName();
            if (string == null || string.trim().length() == 0) {
                stringBuffer.append("Unknown Extension");
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append("\n");
            stringBuffer.append(String.valueOf(v3Extension) + "\n\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        Object object;
        Object object2;
        SEQUENCE sEQUENCE = null;
        SEQUENCE sEQUENCE2 = null;
        sEQUENCE2 = new SEQUENCE();
        Enumeration enumeration = this.critical_extensions.keys();
        while (enumeration.hasMoreElements()) {
            sEQUENCE = new SEQUENCE();
            object2 = (ObjectID)enumeration.nextElement();
            sEQUENCE.addComponent((ASN1Object)object2);
            sEQUENCE.addComponent(new BOOLEAN(true));
            object = (byte[])this.critical_extensions.get(object2);
            if (object == null) {
                throw new InternalErrorException("Extension value = null!");
            }
            sEQUENCE.addComponent(new OCTET_STRING((byte[])object));
            sEQUENCE2.addComponent(sEQUENCE);
        }
        object2 = this.noncritical_extensions.keys();
        while (object2.hasMoreElements()) {
            sEQUENCE = new SEQUENCE();
            object = (ObjectID)object2.nextElement();
            sEQUENCE.addComponent((ASN1Object)object);
            byte[] byArray = (byte[])this.noncritical_extensions.get(object);
            if (byArray == null) {
                throw new InternalErrorException("Extension value = null!");
            }
            sEQUENCE.addComponent(new OCTET_STRING(byArray));
            sEQUENCE2.addComponent(sEQUENCE);
        }
        return sEQUENCE2;
    }

    public boolean removeExtension(ObjectID objectID) {
        if (this.critical_extensions.remove(objectID) != null) {
            return true;
        }
        if (this.noncritical_extensions.remove(objectID) != null) {
            return true;
        }
        return true;
    }

    public void removeAllExtensions() {
        this.critical_extensions.clear();
        this.noncritical_extensions.clear();
    }

    public static void register(ObjectID objectID, Class clazz) {
        if (!g.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz + " is no V3Extension implementation!");
        }
        a.register(objectID, clazz);
    }

    protected void parseExtensions(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            int n2 = 0;
            while (n2 < aSN1Object.countComponents()) {
                boolean bl = false;
                ASN1Object aSN1Object2 = aSN1Object.getComponentAt(n2);
                ObjectID objectID = (ObjectID)aSN1Object2.getComponentAt(0);
                int n3 = aSN1Object2.countComponents();
                if (n3 == 3) {
                    bl = (Boolean)aSN1Object2.getComponentAt(1).getValue();
                }
                byte[] byArray = (byte[])aSN1Object2.getComponentAt(n3 - 1).getValue();
                if (bl) {
                    this.critical_extensions.put(objectID, byArray);
                } else {
                    this.noncritical_extensions.put(objectID, byArray);
                }
                ++n2;
            }
            return;
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.getMessage());
        }
    }

    public Enumeration listExtensions() {
        Object object;
        Vector<V3Extension> vector = new Vector<V3Extension>();
        Enumeration enumeration = this.critical_extensions.keys();
        while (enumeration.hasMoreElements()) {
            object = (ObjectID)enumeration.nextElement();
            try {
                vector.addElement(this.getExtension((ObjectID)object));
            }
            catch (X509ExtensionInitException x509ExtensionInitException) {
                vector.addElement(new ErrorExtension((ObjectID)object, true, x509ExtensionInitException.getMessage()));
            }
        }
        object = this.noncritical_extensions.keys();
        while (object.hasMoreElements()) {
            ObjectID objectID = (ObjectID)object.nextElement();
            try {
                vector.addElement(this.getExtension(objectID));
            }
            catch (X509ExtensionInitException x509ExtensionInitException) {
                vector.addElement(new ErrorExtension(objectID, false, x509ExtensionInitException.getMessage()));
            }
        }
        return vector.elements();
    }

    public boolean hasUnsupportedCriticalExtension() {
        try {
            Enumeration enumeration = this.critical_extensions.keys();
            while (enumeration.hasMoreElements()) {
                V3Extension v3Extension = this.getExtension((ObjectID)enumeration.nextElement());
                if (!(v3Extension instanceof UnknownExtension)) continue;
                return true;
            }
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            return true;
        }
        return false;
    }

    public boolean hasExtensions() {
        return !this.critical_extensions.isEmpty() || !this.noncritical_extensions.isEmpty();
    }

    public Set getNonCriticalExtensionOIDs() {
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration enumeration = this.noncritical_extensions.keys();
        while (enumeration.hasMoreElements()) {
            ObjectID objectID = (ObjectID)enumeration.nextElement();
            hashSet.add(objectID.getID());
        }
        return hashSet;
    }

    public byte[] getExtensionValue(String string) {
        Object v2 = this.critical_extensions.get(new ObjectID(string));
        byte[] byArray = v2 != null ? (byte[])v2 : (byte[])this.noncritical_extensions.get(new ObjectID(string));
        if (byArray != null) {
            return DerCoder.encode(new OCTET_STRING(byArray));
        }
        return null;
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        boolean bl = true;
        byte[] byArray = (byte[])this.critical_extensions.get(objectID);
        if (byArray == null) {
            byArray = (byte[])this.noncritical_extensions.get(objectID);
            if (byArray == null) {
                return null;
            }
            bl = false;
        }
        V3Extension v3Extension = null;
        try {
            v3Extension = X509Extensions.create(objectID);
        }
        catch (InstantiationException instantiationException) {
            v3Extension = new UnknownExtension(objectID);
        }
        v3Extension.setCritical(bl);
        if (byArray.length > 0) {
            try {
                ASN1Object aSN1Object = DerCoder.decode(byArray);
                v3Extension.init(aSN1Object);
            }
            catch (X509ExtensionException x509ExtensionException) {
                throw new X509ExtensionInitException(objectID, bl, x509ExtensionException.toString());
            }
            catch (CodingException codingException) {
                throw new X509ExtensionInitException(objectID, bl, codingException.toString());
            }
        }
        return v3Extension;
    }

    public Set getCriticalExtensionOIDs() {
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration enumeration = this.critical_extensions.keys();
        while (enumeration.hasMoreElements()) {
            ObjectID objectID = (ObjectID)enumeration.nextElement();
            hashSet.add(objectID.getID());
        }
        return hashSet;
    }

    public static V3Extension create(ObjectID objectID) throws InstantiationException {
        return (V3Extension)a.create(objectID);
    }

    public int countExtensions() {
        return this.critical_extensions.size() + this.noncritical_extensions.size();
    }

    public boolean addExtension(V3Extension v3Extension) throws X509ExtensionException {
        ASN1Object aSN1Object = v3Extension.toASN1Object();
        byte[] byArray = aSN1Object == null ? new byte[]{} : DerCoder.encode(aSN1Object);
        if (v3Extension.isCritical()) {
            return this.critical_extensions.put(v3Extension.getObjectID(), byArray) != null;
        }
        return this.noncritical_extensions.put(v3Extension.getObjectID(), byArray) != null;
    }

    public X509Extensions(ASN1Object aSN1Object) throws X509ExtensionException {
        this();
        this.parseExtensions(aSN1Object);
    }

    public X509Extensions() {
        this.noncritical_extensions = new Hashtable(20);
    }

    static {
        g = rb != null ? rb : (rb = X509Extensions.a("iaik.x509.V3Extension"));
        a = new ObjectFactory();
        X509Extensions.register(AuthorityKeyIdentifier.oid, pb != null ? pb : (pb = X509Extensions.a("iaik.x509.extensions.AuthorityKeyIdentifier")));
        X509Extensions.register(BasicConstraints.oid, ob != null ? ob : (ob = X509Extensions.a("iaik.x509.extensions.BasicConstraints")));
        X509Extensions.register(CertificatePolicies.oid, kb != null ? kb : (kb = X509Extensions.a("iaik.x509.extensions.CertificatePolicies")));
        X509Extensions.register(CRLDistributionPoints.oid, nb != null ? nb : (nb = X509Extensions.a("iaik.x509.extensions.CRLDistributionPoints")));
        X509Extensions.register(ExtendedKeyUsage.oid, ib != null ? ib : (ib = X509Extensions.a("iaik.x509.extensions.ExtendedKeyUsage")));
        X509Extensions.register(IssuerAltName.oid, db != null ? db : (db = X509Extensions.a("iaik.x509.extensions.IssuerAltName")));
        X509Extensions.register(KeyUsage.oid, bb != null ? bb : (bb = X509Extensions.a("iaik.x509.extensions.KeyUsage")));
        X509Extensions.register(NameConstraints.oid, ab != null ? ab : (ab = X509Extensions.a("iaik.x509.extensions.NameConstraints")));
        X509Extensions.register(PolicyConstraints.oid, z != null ? z : (z = X509Extensions.a("iaik.x509.extensions.PolicyConstraints")));
        X509Extensions.register(PolicyMappings.oid, y != null ? y : (y = X509Extensions.a("iaik.x509.extensions.PolicyMappings")));
        X509Extensions.register(PrivateKeyUsagePeriod.oid, x != null ? x : (x = X509Extensions.a("iaik.x509.extensions.PrivateKeyUsagePeriod")));
        X509Extensions.register(SubjectAltName.oid, v != null ? v : (v = X509Extensions.a("iaik.x509.extensions.SubjectAltName")));
        X509Extensions.register(SubjectKeyIdentifier.oid, s != null ? s : (s = X509Extensions.a("iaik.x509.extensions.SubjectKeyIdentifier")));
        X509Extensions.register(SubjectDirectoryAttributes.oid, u != null ? u : (u = X509Extensions.a("iaik.x509.extensions.SubjectDirectoryAttributes")));
        X509Extensions.register(AuthorityInfoAccess.oid, qb != null ? qb : (qb = X509Extensions.a("iaik.x509.extensions.AuthorityInfoAccess")));
        X509Extensions.register(SubjectInfoAccess.oid, t != null ? t : (t = X509Extensions.a("iaik.x509.extensions.SubjectInfoAccess")));
        X509Extensions.register(InhibitAnyPolicy.oid, fb != null ? fb : (fb = X509Extensions.a("iaik.x509.extensions.InhibitAnyPolicy")));
        X509Extensions.register(FreshestCRL.oid, hb != null ? hb : (hb = X509Extensions.a("iaik.x509.extensions.FreshestCRL")));
        X509Extensions.register(SMIMECapabilities.oid, b != null ? b : (b = X509Extensions.a("iaik.x509.extensions.smime.SMIMECapabilities")));
        X509Extensions.register(CRLNumber.oid, mb != null ? mb : (mb = X509Extensions.a("iaik.x509.extensions.CRLNumber")));
        X509Extensions.register(DeltaCRLIndicator.oid, jb != null ? jb : (jb = X509Extensions.a("iaik.x509.extensions.DeltaCRLIndicator")));
        X509Extensions.register(IssuingDistributionPoint.oid, cb != null ? cb : (cb = X509Extensions.a("iaik.x509.extensions.IssuingDistributionPoint")));
        X509Extensions.register(ReasonCode.oid, w != null ? w : (w = X509Extensions.a("iaik.x509.extensions.ReasonCode")));
        X509Extensions.register(HoldInstructionCode.oid, gb != null ? gb : (gb = X509Extensions.a("iaik.x509.extensions.HoldInstructionCode")));
        X509Extensions.register(InvalidityDate.oid, eb != null ? eb : (eb = X509Extensions.a("iaik.x509.extensions.InvalidityDate")));
        X509Extensions.register(CertificateIssuer.oid, lb != null ? lb : (lb = X509Extensions.a("iaik.x509.extensions.CertificateIssuer")));
        X509Extensions.register(NetscapeBaseUrl.oid, r != null ? r : (r = X509Extensions.a("iaik.x509.extensions.netscape.NetscapeBaseUrl")));
        X509Extensions.register(NetscapeCaPolicyUrl.oid, q != null ? q : (q = X509Extensions.a("iaik.x509.extensions.netscape.NetscapeCaPolicyUrl")));
        X509Extensions.register(NetscapeCaRevocationUrl.oid, p != null ? p : (p = X509Extensions.a("iaik.x509.extensions.netscape.NetscapeCaRevocationUrl")));
        X509Extensions.register(NetscapeCertRenewalUrl.oid, o != null ? o : (o = X509Extensions.a("iaik.x509.extensions.netscape.NetscapeCertRenewalUrl")));
        X509Extensions.register(NetscapeCertType.oid, n != null ? n : (n = X509Extensions.a("iaik.x509.extensions.netscape.NetscapeCertType")));
        X509Extensions.register(NetscapeComment.oid, m != null ? m : (m = X509Extensions.a("iaik.x509.extensions.netscape.NetscapeComment")));
        X509Extensions.register(NetscapeRevocationUrl.oid, l != null ? l : (l = X509Extensions.a("iaik.x509.extensions.netscape.NetscapeRevocationUrl")));
        X509Extensions.register(NetscapeSSLServerName.oid, k != null ? k : (k = X509Extensions.a("iaik.x509.extensions.netscape.NetscapeSSLServerName")));
        X509Extensions.register(BiometricInfo.oid, d != null ? d : (d = X509Extensions.a("iaik.x509.extensions.qualified.BiometricInfo")));
        X509Extensions.register(QCStatements.oid, c != null ? c : (c = X509Extensions.a("iaik.x509.extensions.qualified.QCStatements")));
        X509Extensions.register(NoCheck.oid, j != null ? j : (j = X509Extensions.a("iaik.x509.extensions.ocsp.NoCheck")));
        X509Extensions.register(PublicAuthorityIdentifier.oid, f != null ? f : (f = X509Extensions.a("iaik.x509.extensions.priv.PublicAuthorityIdentifier")));
        X509Extensions.register(PublicServiceProvider.oid, e != null ? e : (e = X509Extensions.a("iaik.x509.extensions.priv.PublicServiceProvider")));
    }
}

