/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.structures.Attribute;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class Attributes {
    ASN b;
    byte[] a;
    protected Vector attributes_ = new Vector();

    public void writeToAsn1SET(OutputStream outputStream, boolean bl) throws IOException {
        try {
            DerCoder.encodeTo(this.toAsn1SET(bl), outputStream);
            return;
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.toString());
        }
    }

    public void writeToAsn1SET(OutputStream outputStream) throws IOException {
        try {
            if (this.a != null && this.b.equals(ASN.SET)) {
                outputStream.write(this.a);
                return;
            }
            DerCoder.encodeTo(this.toAsn1SET(false), outputStream);
            return;
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.toString());
        }
    }

    public void writeToAsn1SEQUENCE(OutputStream outputStream) throws IOException {
        try {
            if (this.a != null && this.b.equals(ASN.SEQUENCE)) {
                outputStream.write(this.a);
                return;
            }
            DerCoder.encodeTo(this.toAsn1SEQUENCE(), outputStream);
            return;
        }
        catch (CodingException codingException) {
            throw new IOException(codingException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.attributes_.elements();
        int n2 = 1;
        while (enumeration.hasMoreElements()) {
            if (n2 > 1) {
                stringBuffer.append("\n");
            }
            stringBuffer.append("Attribute No. " + n2++ + ": ");
            stringBuffer.append(enumeration.nextElement());
        }
        return stringBuffer.toString();
    }

    public SET toAsn1SET(boolean bl) throws CodingException {
        return (SET)ASN.createSetOf(this.toArray(), bl);
    }

    public SET toAsn1SET() throws CodingException {
        return this.toAsn1SET(false);
    }

    public SEQUENCE toAsn1SEQUENCE() throws CodingException {
        return (SEQUENCE)ASN.createSequenceOf(this.toArray());
    }

    public Attribute[] toArray() {
        Object[] objectArray = new Attribute[this.attributes_.size()];
        this.attributes_.copyInto(objectArray);
        return objectArray;
    }

    public int size() {
        return this.attributes_.size();
    }

    public boolean removeAttributes(Attribute attribute) {
        boolean bl = false;
        while (bl = this.attributes_.removeElement(attribute)) {
        }
        return bl;
    }

    public Attribute[] removeAttributes(ObjectID objectID) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.attributes_.elements();
        while (enumeration.hasMoreElements()) {
            object = (Attribute)enumeration.nextElement();
            if (!((Attribute)object).getType().equals(objectID)) continue;
            vector.addElement(object);
            this.attributes_.removeElement(object);
            this.a();
        }
        object = new Attribute[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public boolean removeAttribute(Attribute attribute) {
        return this.attributes_.removeElement(attribute);
    }

    public Attribute removeAttribute(ObjectID objectID) {
        Enumeration enumeration = this.attributes_.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (!attribute.getType().equals(objectID)) continue;
            this.attributes_.removeElement(attribute);
            this.a();
            return attribute;
        }
        return null;
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isConstructed()) {
            throw new CodingException("Cannot parse attributes. Expected SET of SEQUENCE!");
        }
        this.b = aSN1Object.getAsnType();
        int n2 = 0;
        while (n2 < aSN1Object.countComponents()) {
            this.attributes_.addElement(new Attribute(aSN1Object.getComponentAt(n2)));
            ++n2;
        }
    }

    public void insertAttributeAt(Attribute attribute, int n2) {
        this.attributes_.insertElementAt(attribute, n2);
        this.a();
    }

    public Attribute[] getAttributes(ObjectID objectID) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.attributes_.elements();
        while (enumeration.hasMoreElements()) {
            object = (Attribute)enumeration.nextElement();
            if (!((Attribute)object).getType().equals(objectID)) continue;
            vector.addElement(object);
        }
        object = new Attribute[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public Enumeration getAttributes() {
        return this.attributes_.elements();
    }

    public Attribute getAttribute(ObjectID objectID) {
        Enumeration enumeration = this.attributes_.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (!attribute.getType().equals(objectID)) continue;
            return attribute;
        }
        return null;
    }

    private void a() {
        this.a = null;
        this.b = null;
    }

    public void clearAll() {
        this.attributes_.removeAllElements();
        this.a();
    }

    public void addAttributes(Attribute[] attributeArray) {
        if (attributeArray != null) {
            int n2 = this.attributes_.size();
            int n3 = 0;
            while (n3 < attributeArray.length) {
                if (attributeArray[n3] != null) {
                    this.attributes_.addElement(attributeArray[n3]);
                }
                ++n3;
            }
            if (this.attributes_.size() > n2) {
                this.a();
            }
        }
    }

    public void addAttribute(Attribute attribute, boolean bl) {
        if (attribute != null) {
            if (bl) {
                int n2 = 0;
                Enumeration enumeration = this.attributes_.elements();
                while (enumeration.hasMoreElements()) {
                    if (((Attribute)enumeration.nextElement()).getType().equals(attribute.getType())) {
                        this.attributes_.setElementAt(attribute, n2);
                        break;
                    }
                    ++n2;
                }
            } else {
                this.attributes_.addElement(attribute);
            }
            this.a();
        }
    }

    public void addAttribute(Attribute attribute) {
        this.addAttribute(attribute, false);
    }

    public Attributes(Attribute[] attributeArray) {
        this();
        this.addAttributes(attributeArray);
    }

    public Attributes(byte[] byArray) throws CodingException {
        this();
        ASN1 aSN1 = new ASN1(byArray);
        this.a(aSN1.toASN1Object());
        this.a = aSN1.toByteArray();
    }

    public Attributes(InputStream inputStream) throws IOException, CodingException {
        this();
        ASN1 aSN1 = new ASN1(inputStream);
        this.a(aSN1.toASN1Object());
        this.a = aSN1.toByteArray();
    }

    public Attributes(ASN1Object aSN1Object) throws CodingException {
        this();
        this.a(aSN1Object);
    }

    public Attributes() {
    }
}

