/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.MaterialPreparedStatement;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.PreparedStatementCallbackInterface;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;

public class CallableStatement
extends PreparedStatement
implements java.sql.PreparedStatement,
java.sql.CallableStatement,
PreparedStatementCallbackInterface {
    public MaterialPreparedStatement materialCallableStatement_ = null;
    private int wasNull_ = 0;
    private static final int WAS_NULL = 1;
    private static final int WAS_NOT_NULL = 2;
    private static final int WAS_NULL_UNSET = 0;

    private void initCallableStatement() {
        this.materialCallableStatement_ = null;
        this.wasNull_ = 0;
    }

    public void reset(boolean bl) throws SqlException {
        if (bl) {
            this.connection_.resetPrepareCall(this);
        } else {
            super.reset(bl);
        }
        this.wasNull_ = 0;
    }

    public CallableStatement(Agent agent, Connection connection, String string, int n, int n2, int n3, ClientPooledConnection clientPooledConnection) throws SqlException {
        super(agent, connection, string, n, n2, n3, 2, null, null, clientPooledConnection);
        this.initCallableStatement();
    }

    public void resetCallableStatement(Agent agent, Connection connection, String string, int n, int n2, int n3) throws SqlException {
        super.resetPreparedStatement(agent, connection, string, n, n2, n3, 2, null, null);
        this.initCallableStatement();
    }

    public void resetCallableStatement(Agent agent, Connection connection, String string, Section section) throws SqlException {
        super.resetPreparedStatement(agent, connection, string, section);
        this.initCallableStatement();
    }

    public void resetCallableStatement(Agent agent, Connection connection, String string, Section section, ColumnMetaData columnMetaData, ColumnMetaData columnMetaData2) throws SqlException {
        super.resetPreparedStatement(agent, connection, string, section, columnMetaData, columnMetaData2);
        this.initCallableStatement();
    }

    protected void finalize() throws Throwable {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "finalize");
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameters() throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearParameters");
            }
            super.clearParameters();
            this.outputRegistered_ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int n, int n2) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", n, n2);
                }
                this.registerOutParameterX(n, n2);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    void registerOutParameterX(int n, int n2) throws SqlException {
        super.checkForClosedStatement();
        int n3 = 0;
        this.registerOutParameterX(n, n2, n3);
    }

    private int guessScaleForDecimalOrNumeric(int n) throws SqlException {
        if (this.parameterMetaData_.types_[n - 1] == 3 && this.parameters_[n - 1] != null) {
            return this.parameterMetaData_.sqlScale_[n - 1];
        }
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", n, n2, n3);
                }
                super.checkForClosedStatement();
                this.registerOutParameterX(n, n2, n3);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void registerOutParameterX(int n, int n2, int n3) throws SqlException {
        super.checkForValidParameterIndex(n);
        this.checkForValidScale(n3);
        this.outputRegistered_ = true;
        this.parameterRegistered_[n - 1] = true;
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", n, n2, (Object)string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public boolean wasNull() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "wasNull");
            }
            boolean bl = this.wasNullX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "wasNull", bl);
            }
            return bl;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private boolean wasNullX() throws SqlException {
        super.checkForClosedStatement();
        if (this.wasNull_ == 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ088.S"));
        }
        return this.wasNull_ == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                boolean bl;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getBoolean", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                boolean bl2 = bl = this.wasNullX() ? false : this.singletonRowData_.getBoolean(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBoolean", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                byte by;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getByte", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                byte by2 = by = this.wasNullX() ? (byte)0 : this.singletonRowData_.getByte(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getByte", by);
                }
                return by;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                short s;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getShort", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                short s2 = s = this.wasNullX() ? (short)0 : this.singletonRowData_.getShort(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getShort", s);
                }
                return s;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getInt", n);
                }
                int n2 = this.getIntX(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getInt", n2);
                }
                return n2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    int getIntX(int n) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(n);
        this.setWasNull(n);
        return this.wasNullX() ? 0 : this.singletonRowData_.getInt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getLong", n);
                }
                long l = this.getLongX(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getLong", l);
                }
                return l;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    long getLongX(int n) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(n);
        this.setWasNull(n);
        return this.wasNullX() ? 0L : this.singletonRowData_.getLong(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                float f;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getFloat", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                float f2 = f = this.wasNullX() ? 0.0f : this.singletonRowData_.getFloat(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getFloat", f);
                }
                return f;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                double d;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getDouble", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                double d2 = d = this.wasNullX() ? 0.0 : this.singletonRowData_.getDouble(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getDouble", d);
                }
                return d;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException, ArithmeticException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                BigDecimal bigDecimal;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceDeprecatedEntry((Object)this, "getBigDecimal", n, n2);
                }
                super.checkForClosedStatement();
                this.checkForValidScale(n2);
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                BigDecimal bigDecimal2 = bigDecimal = this.wasNullX() ? null : this.singletonRowData_.getBigDecimal(n);
                if (bigDecimal != null) {
                    bigDecimal = bigDecimal.setScale(n2, 1);
                }
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceDeprecatedExit((Object)this, "getBigDecimal", bigDecimal);
                }
                return bigDecimal;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                BigDecimal bigDecimal;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getBigDecimal", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                BigDecimal bigDecimal2 = bigDecimal = this.wasNullX() ? null : this.singletonRowData_.getBigDecimal(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBigDecimal", bigDecimal);
                }
                return bigDecimal;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                Date date;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getDate", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                Date date2 = date = this.wasNullX() ? null : this.singletonRowData_.getDate(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getDate", date);
                }
                return date;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getDate", n, (Object)calendar);
            }
            Date date = this.getDate(n);
            if (calendar == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S")).getSQLException();
            }
            if (date != null) {
                Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
                calendar2.clear();
                calendar2.setTime(date);
                Calendar calendar3 = Calendar.getInstance();
                calendar3.clear();
                calendar3.setTime(date);
                long l = calendar2.get(15) - calendar3.get(15) + calendar2.get(16) - calendar3.get(16);
                date.setTime(date.getTime() - l);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getDate", date);
            }
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                Time time;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getTime", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                Time time2 = time = this.wasNullX() ? null : this.singletonRowData_.getTime(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getTime", time);
                }
                return time;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTime", n, (Object)calendar);
            }
            Time time = this.getTime(n);
            if (calendar == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S")).getSQLException();
            }
            if (time != null) {
                Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
                calendar2.clear();
                calendar2.setTime(time);
                Calendar calendar3 = Calendar.getInstance();
                calendar3.clear();
                calendar3.setTime(time);
                long l = calendar2.get(15) - calendar3.get(15) + calendar2.get(16) - calendar3.get(16);
                time.setTime(time.getTime() - l);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTime", time);
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                Timestamp timestamp;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                Timestamp timestamp2 = timestamp = this.wasNullX() ? null : this.singletonRowData_.getTimestamp(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getTimestamp", timestamp);
                }
                return timestamp;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", n, (Object)calendar);
            }
            Timestamp timestamp = this.getTimestamp(n);
            if (calendar == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S")).getSQLException();
            }
            if (timestamp != null) {
                int n2 = timestamp.getNanos();
                Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
                calendar2.clear();
                calendar2.setTime(timestamp);
                Calendar calendar3 = Calendar.getInstance();
                calendar3.clear();
                calendar3.setTime(timestamp);
                long l = calendar2.get(15) - calendar3.get(15) + calendar2.get(16) - calendar3.get(16);
                timestamp.setTime(timestamp.getTime() - l);
                timestamp.setNanos(n2);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTimestamp", timestamp);
            }
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getString", n);
                }
                String string = this.getStringX(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getString", string);
                }
                return string;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    String getStringX(int n) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(n);
        this.setWasNull(n);
        return this.wasNullX() ? null : this.singletonRowData_.getString(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getBytes", n);
                }
                byte[] byArray = this.getBytesX(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBytes", byArray);
                }
                return byArray;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    byte[] getBytesX(int n) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(n);
        this.setWasNull(n);
        return this.wasNullX() ? null : this.singletonRowData_.getBytes(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                Blob blob;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getBlob", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                Blob blob2 = blob = this.wasNullX() ? null : this.singletonRowData_.getBlob(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBlob", blob);
                }
                return blob;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                Clob clob;
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                Clob clob2 = clob = this.wasNullX() ? null : this.singletonRowData_.getClob(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getClob", clob);
                }
                return clob;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public Array getArray(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getArray", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                Array array = this.wasNullX() ? null : this.singletonRowData_.getArray(n);
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public Ref getRef(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getRef", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                Ref ref = this.wasNullX() ? null : this.singletonRowData_.getRef(n);
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                Object object;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getObject", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                Object object2 = object = this.wasNullX() ? null : this.singletonRowData_.getObject(n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getObject", object);
                }
                return object;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getObject", n, (Object)map);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"));
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", (Object)string, n);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", (Object)string, n, n2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", (Object)string, n, (Object)string2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public URL getURL(int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getURL", n);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setURL(String string, URL uRL) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setURL", (Object)string, (Object)uRL);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setNull(String string, int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setNull", (Object)string, n);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setBoolean", (Object)string, bl);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setByte(String string, byte by) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setByte", (Object)string, by);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setShort(String string, short s) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setShort", (Object)string, s);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setInt(String string, int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setInt", (Object)string, n);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setLong(String string, long l) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setLong", (Object)string, l);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setFloat(String string, float f) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setFloat", (Object)string, f);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setDouble(String string, double d) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setDouble", (Object)string, d);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setBigDecimal", (Object)string, (Object)bigDecimal);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setString(String string, String string2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setString", (Object)string, (Object)string2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setBytes", (Object)string, (Object)byArray);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setDate(String string, Date date) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setDate", (Object)string, (Object)date);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setTime(String string, Time time) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setTime", (Object)string, (Object)time);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setTimestamp", (Object)string, (Object)timestamp);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setAsciiStream", (Object)string, (Object)inputStream, n);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setBinaryStream", (Object)string, (Object)inputStream, n);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setObject", (Object)string, object, n, n2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setObject", (Object)string, object, n);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setObject(String string, Object object) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setObject", (Object)string, object);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setCharacterStream", (Object)string, (Object)reader, n);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setDate", (Object)string, (Object)date, (Object)calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setTime", (Object)string, (Object)time, (Object)calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setTimestamp", (Object)string, (Object)timestamp, (Object)calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setNull", (Object)string, n, (Object)string2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public String getString(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getString", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public boolean getBoolean(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBoolean", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public byte getByte(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getByte", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public short getShort(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getShort", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public int getInt(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getInt", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public long getLong(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getLong", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public float getFloat(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getFloat", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public double getDouble(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getDouble", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public byte[] getBytes(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBytes", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Date getDate(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getDate", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Time getTime(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTime", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Object getObject(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getObject", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBigDecimal", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Object getObject(String string, Map map) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getObject", (Object)string, (Object)map);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Ref getRef(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getRef", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Blob getBlob(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBlob", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Clob getClob(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getClob", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Array getArray(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getArray", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getDate", (Object)string, (Object)calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTime", (Object)string, (Object)calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", (Object)string, (Object)calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public URL getURL(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getURL", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int n) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getCharacterStream", n);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n);
                this.setWasNull(n);
                Reader reader = null;
                if (this.wasNull_ == 2) {
                    reader = this.singletonRowData_.getCharacterStream(n);
                }
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", reader);
                }
                return reader;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    protected String getJdbcStatementInterfaceName() {
        return "java.sql.CallableStatement";
    }

    private void checkGetterPreconditions(int n) throws SqlException {
        super.checkForValidParameterIndex(n);
        this.checkForValidOutParameter(n);
    }

    private void checkForValidOutParameter(int n) throws SqlException {
        if (this.parameterMetaData_ == null || this.parameterMetaData_.sqlxParmmode_[n - 1] < 2) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ091.S"), new Integer(n));
        }
    }

    private void setWasNull(int n) {
        this.wasNull_ = this.singletonRowData_ == null ? 0 : (this.singletonRowData_.isNull_[n - 1] ? 1 : 2);
    }

    private SQLException jdbcMethodNotImplemented() throws SQLException {
        try {
            super.checkForClosedStatement();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        return new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1")).getSQLException();
    }
}

