/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2010;

import finanze.IDTE.generale2010.CheckedBufferedReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.zip.CRC32;

public class CheckedBufferedReaderUTF8
extends BufferedReader
implements CheckedBufferedReader {
    private CRC32 cksum;
    private char commentChar;
    public static final char DEFAULT_COMMENT_CHAR = '#';

    public CheckedBufferedReaderUTF8(InputStream inStream) throws FileNotFoundException, UnsupportedEncodingException {
        this((Reader)new InputStreamReader(inStream, "UTF-8"), new CRC32());
    }

    public CheckedBufferedReaderUTF8(Reader reader) {
        this(reader, new CRC32());
    }

    public CheckedBufferedReaderUTF8(Reader reader, CRC32 cksum) {
        super(reader);
        this.cksum = cksum;
        this.commentChar = (char)35;
    }

    public long getCheckValue() {
        return this.cksum.getValue();
    }

    public boolean isCommentLine(String line) {
        if (line.length() == 0) {
            return true;
        }
        return line.charAt(0) == this.commentChar;
    }

    public void readAll() throws IOException {
        while (this.readLine() != null) {
        }
    }

    public String readLine() throws IOException {
        String line = super.readLine();
        if (line != null && !this.isCommentLine(line)) {
            this.cksum.update(line.getBytes("UTF-8"));
        }
        return line;
    }

    public void setCommentChar(char newChar) {
        this.commentChar = newChar;
    }
}

