/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dom;

import iaik.utils.Base64Exception;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xsect.com.fourthpass.a;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class DOMStructure
extends javax.xml.crypto.dom.DOMStructure
implements XMLStructure {
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$javax$xml$crypto$dom$DOMCryptoContext;
    static /* synthetic */ Class class$iaik$xml$crypto$dom$DOMStructure;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    private static boolean compatibilityPrior1_14;
    static final Method IS_DEFAULT_NS;
    static final Method LOOKUP_NS_URI;
    private DOMStructure parentStructure_;
    private Node node_;
    protected int state_ = 0;
    public static final int STATE_UNMARSHALED = 3;
    public static final int STATE_MARSHALED = 1;
    public static final int STATE_CREATED = 0;
    public static final int STATE_UNINITIALIZED = -1;
    protected static final Map implMap_;

    public static DOMStructure wrapNode(Node node) {
        return new NodeWrapper(node);
    }

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        if (nodeList == null) {
            return;
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            DOMStructure dOMStructure;
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && (dOMStructure = DOMStructure.getInstance(node, dOMCryptoContext)) != null) {
                this.putChildStructure(dOMStructure);
            }
            ++n;
        }
    }

    protected String unmarshalIDAttribute(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext, String string) throws MarshalException {
        Attr attr = (Attr)namedNodeMap.getNamedItemNS(null, string);
        if (attr != null) {
            String string2 = attr.getLocalName();
            String string3 = attr.getNamespaceURI();
            dOMCryptoContext.setIdAttributeNS((Element)this.getNode(), string3, string2);
            return attr.getValue();
        }
        return null;
    }

    protected void unmarshalElement(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            String string;
            Node node = namedNodeMap.item(n);
            if ("xmlns".equals(node.getPrefix()) && dOMCryptoContext.getNamespacePrefix(string = node.getNodeValue(), null) == null) {
                if (string == null || string.equals("")) {
                    throw new MarshalException("Invalid Namespace Declaration");
                }
                dOMCryptoContext.putNamespacePrefix(string, node.getLocalName());
            }
            ++n;
        }
        if (element.getNamespaceURI() != null && dOMCryptoContext.getNamespacePrefix(element.getNamespaceURI(), null) == null && element.getPrefix() != null) {
            dOMCryptoContext.putNamespacePrefix(element.getNamespaceURI(), element.getPrefix());
        }
    }

    protected void unmarshalAttributes(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext) throws MarshalException {
    }

    public void unmarshal(DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Object object;
        if (this.state_ < 3) {
            this.unmarshalElement(dOMCryptoContext, (Element)this.getNode());
            object = this.getNode().getAttributes();
            if (object != null && object.getLength() > 0) {
                this.unmarshalAttributes((NamedNodeMap)object, dOMCryptoContext);
            }
            this.state_ = 3;
        }
        if ((object = this.getNode().getChildNodes()) != null && object.getLength() > 0) {
            this.unmarshalStructures((NodeList)object, dOMCryptoContext);
        }
    }

    protected void setParentStructure(DOMStructure dOMStructure) throws MarshalException {
        if (this.parentStructure_ != null && this.parentStructure_ == dOMStructure) {
            throw new MarshalException("ParentStructure cannot be set twice to the same value");
        }
        if (this.parentStructure_ != null && dOMStructure != null) {
            throw new MarshalException("ParentStructure cannot be set twice");
        }
        this.parentStructure_ = dOMStructure;
    }

    protected final void setNode(Node node) throws MarshalException {
        if (this.node_ != null && node != null && this.getParentStructure() != null && this.getParentStructure().getNode() != node.getParentNode()) {
            throw new MarshalException("Inconsistent Data Structure, please contact IAIK");
        }
        this.node_ = node;
    }

    public static void setBackToCompatibilityPrior1_14(boolean bl) {
        compatibilityPrior1_14 = bl;
    }

    protected static final void putImplClass(String string, String string2, String string3) {
        implMap_.put(String.valueOf(string) + " " + string2, string3);
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        if (dOMStructure != null) {
            dOMStructure.setParentStructure(this);
        }
    }

    protected Attr marshalIDAttribute(DOMCryptoContext dOMCryptoContext, Element element) {
        return null;
    }

    protected Element marshalElement(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Document document = DOMUtils.getOwnerDocument(node);
        String string = this.getQualifiedName(dOMCryptoContext.getNamespacePrefix(this.getNamespace(), dOMCryptoContext.getDefaultNamespacePrefix()));
        return (Element)node.insertBefore(document.createElementNS(this.getNamespace(), string), node2);
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        String string = this.getNamespace();
        String string2 = dOMCryptoContext.getNamespacePrefix(string, dOMCryptoContext.getDefaultNamespacePrefix());
        DOMStructure dOMStructure = this.getParentStructure();
        if (dOMStructure == null || !dOMStructure.isNSDeclInScope(string2, string)) {
            DOMUtils.createNSDeclAttribute(dOMCryptoContext, element, this.getNamespace());
        }
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Object object;
        if (this.getParentStructure() != null && node != this.getParentStructure().getNode()) {
            throw new MarshalException("Inconsistent Data Structure, please contact IAIK");
        }
        if (this.state_ < 1 || this.getNode() == null || node.getOwnerDocument() != this.getNode().getOwnerDocument()) {
            this.setNode(this.marshalElement(dOMCryptoContext, node, node2));
            this.marshalAttributes(dOMCryptoContext, (Element)this.getNode());
            if (this.getNode().getNodeType() == 1 && (object = this.marshalIDAttribute(dOMCryptoContext, (Element)this.getNode())) != null) {
                ((Element)this.getNode()).setAttributeNodeNS((Attr)object);
                dOMCryptoContext.setIdAttributeNS((Element)this.node_, null, object.getLocalName());
            }
            this.state_ = 1;
        }
        if ((object = this.getChildStructures()) != null && !object.isEmpty()) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object2;
                XMLStructure xMLStructure = (XMLStructure)iterator.next();
                if (xMLStructure instanceof DOMStructure) {
                    object2 = (DOMStructure)xMLStructure;
                    ((DOMStructure)object2).setParentStructure(this);
                    ((DOMStructure)object2).marshal(dOMCryptoContext, this.getNode(), null);
                    continue;
                }
                if (xMLStructure instanceof javax.xml.crypto.dom.DOMStructure) {
                    object2 = ((javax.xml.crypto.dom.DOMStructure)xMLStructure).getNode();
                    Node node3 = this.getNode();
                    if (object2.getOwnerDocument() != node3.getOwnerDocument()) {
                        object2 = node3.getOwnerDocument().importNode((Node)object2, true);
                    }
                    node3.appendChild((Node)object2);
                    continue;
                }
                throw new MarshalException(String.valueOf(this.getClass().getName()) + " supports the DOM marshaling mechanism only");
            }
        }
        return this.getNode();
    }

    protected boolean isNSDeclInScope(String string, String string2) throws MarshalException {
        try {
            Node node = this.getNode();
            if ((string == null || string.equals("")) && IS_DEFAULT_NS != null) {
                return IS_DEFAULT_NS.invoke((Object)node, (Object[])new String[]{string2}).equals(Boolean.TRUE);
            }
            if (LOOKUP_NS_URI != null) {
                return string2.equals((String)LOOKUP_NS_URI.invoke((Object)node, (Object[])new String[]{string}));
            }
            if (IS_DEFAULT_NS == null && LOOKUP_NS_URI == null) {
                return this.hasNSDeclAttrInScope(string, string2);
            }
            throw new MarshalException("Either both isDefaultNamespace and lookupNamespaceURI or none MUST be available" + node.getClass());
        }
        catch (Throwable throwable) {
            throw new MarshalException(throwable);
        }
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    protected boolean hasNSDeclAttrInScope(String string, String string2) {
        Node node = this.getNode();
        while (node != null && node.getNodeType() != 9) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Node node2 = namedNodeMap.item(n);
                String string3 = node2.getPrefix();
                String string4 = node2.getLocalName();
                String string5 = node2.getNodeValue();
                if ((string == null || string.equals("")) && "xmlns".equals(string4)) {
                    return string5.equals(string2);
                }
                if ("xmlns".equals(string3) && string4.equals(string)) {
                    return string5.equals(string2);
                }
                ++n;
            }
            node = node.getParentNode();
        }
        return false;
    }

    public static String getQualifiedName(String string, String string2) {
        if (string != null && string.length() > 0) {
            return String.valueOf(string) + ":" + string2;
        }
        return string2;
    }

    public String getQualifiedName(String string) {
        return DOMStructure.getQualifiedName(string, this.getLocalName());
    }

    protected static DOMStructure getParentStructureOf(DOMStructure dOMStructure) {
        return dOMStructure.getParentStructure();
    }

    protected DOMStructure getParentStructure() {
        return this.parentStructure_;
    }

    public final Node getNode() {
        return this.node_;
    }

    public abstract String getNamespace();

    public abstract String getLocalName();

    public static DOMStructure getInstance(Node node, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        if (node == null) {
            throw new NullPointerException("Argument 'node' must not be null");
        }
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("Given node '" + node + "' must be of type '" + (class$org$w3c$dom$Element != null ? class$org$w3c$dom$Element : (class$org$w3c$dom$Element = DOMStructure.class$("org.w3c.dom.Element"))).getName() + "'.");
        }
        String string = node.getLocalName();
        String string2 = node.getNamespaceURI();
        String string3 = DOMStructure.getImplClass(string2, string);
        if (string3 != null) {
            DOMStructure dOMStructure;
            Class<?> clazz;
            ClassLoader classLoader = (class$iaik$xml$crypto$dom$DOMStructure != null ? class$iaik$xml$crypto$dom$DOMStructure : (class$iaik$xml$crypto$dom$DOMStructure = DOMStructure.class$("iaik.xml.crypto.dom.DOMStructure"))).getClassLoader();
            if (classLoader != null) {
                try {
                    clazz = classLoader.loadClass(string3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new MarshalException("Implementation class '" + string3 + "' of element '" + string2 + ":" + string + "' not found. " + classNotFoundException.getMessage());
                }
            }
            try {
                clazz = a.a(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MarshalException("Implementation class '" + string3 + "' of element '" + string2 + ":" + string + "' not found. " + classNotFoundException.getMessage());
            }
            Class[] classArray = new Class[]{class$javax$xml$crypto$dom$DOMCryptoContext != null ? class$javax$xml$crypto$dom$DOMCryptoContext : (class$javax$xml$crypto$dom$DOMCryptoContext = DOMStructure.class$("javax.xml.crypto.dom.DOMCryptoContext")), class$org$w3c$dom$Node != null ? class$org$w3c$dom$Node : (class$org$w3c$dom$Node = DOMStructure.class$("org.w3c.dom.Node"))};
            try {
                Constructor<?> constructor = clazz.getConstructor(classArray);
                dOMStructure = (DOMStructure)constructor.newInstance(dOMCryptoContext, node);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof MarshalException) {
                    throw (MarshalException)throwable;
                }
                throw new MarshalException("Invocation failed when creating an instance of class '" + string3 + "' for element '" + string2 + ":" + string + "'. " + invocationTargetException.getTargetException().getMessage(), invocationTargetException);
            }
            catch (Exception exception) {
                throw new MarshalException("Failed to create instance of class '" + string3 + "' for element '" + string2 + ":" + string + "'. " + exception.getMessage(), exception);
            }
            return dOMStructure;
        }
        return null;
    }

    protected static final String getImplClass(String string, String string2) {
        return (String)implMap_.get(String.valueOf(string) + " " + string2);
    }

    protected Node getHere() {
        Node node;
        NamedNodeMap namedNodeMap;
        Node node2 = this.getNode();
        if (node2 != null && !compatibilityPrior1_14 && (namedNodeMap = node2.getAttributes()) != null && (node = namedNodeMap.getNamedItemNS(null, "URI")) != null) {
            node2 = node;
        }
        return node2;
    }

    protected List getChildStructures() {
        return new ArrayList();
    }

    protected static InputStream getBytesFromElementStream(Element element) throws MarshalException {
        try {
            return DOMUtils.getBytesFromElementChildrensStream(element);
        }
        catch (IOException iOException) {
            throw new MarshalException(iOException);
        }
    }

    protected static byte[] getBytesFromElement(Element element) throws MarshalException {
        try {
            return DOMUtils.getBytesFromElementChildrens(element);
        }
        catch (Base64Exception base64Exception) {
            throw new MarshalException("Unmarshaling failed", base64Exception);
        }
        catch (IOException iOException) {
            throw new MarshalException("Unmarshaling failed", iOException);
        }
    }

    protected static void clearMarshalling(DOMStructure dOMStructure) {
        dOMStructure.clearMarshalling();
    }

    protected void clearMarshalling() {
        List list = this.getChildStructures();
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DOMStructure dOMStructure = (DOMStructure)iterator.next();
                dOMStructure.clearMarshalling();
            }
        }
        this.getNode().getParentNode().removeChild(this.node_);
        this.node_ = null;
        this.parentStructure_ = null;
        this.state_ = 0;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static void addBytesToElement(Element element, byte[] byArray, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        try {
            DOMUtils.addBytesToElement(element, byArray, (byte[])dOMCryptoContext.getProperty("iaik.xml.crypto.base64.linebreak"));
        }
        catch (IOException iOException) {
            throw new MarshalException("Failed to marshal property", iOException);
        }
    }

    protected static void addBytesToElement(Element element, InputStream inputStream, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        try {
            DOMUtils.addBytesToElement(element, inputStream, (byte[])dOMCryptoContext.getProperty("iaik.xml.crypto.base64.linebreak"));
        }
        catch (IOException iOException) {
            throw new MarshalException(iOException);
        }
    }

    protected DOMStructure(Node node) {
        super(new DummyNode());
        if (node == null) {
            throw new NullPointerException("Argument 'node' must not be null");
        }
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("Given node '" + node + "' must be of type '" + (class$org$w3c$dom$Element != null ? class$org$w3c$dom$Element : (class$org$w3c$dom$Element = DOMStructure.class$("org.w3c.dom.Element"))).getName() + "'.");
        }
        this.node_ = node;
        this.state_ = 0;
    }

    protected DOMStructure() {
        super(new DummyNode());
        this.state_ = 0;
    }

    static {
        implMap_ = new HashMap();
        Method method = null;
        Method method2 = null;
        try {
            method = a.b(class$org$w3c$dom$Element != null ? class$org$w3c$dom$Element : (class$org$w3c$dom$Element = DOMStructure.class$("org.w3c.dom.Element")), "lookupNamespaceURI", new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = DOMStructure.class$("java.lang.String"))});
            method2 = a.b(class$org$w3c$dom$Element != null ? class$org$w3c$dom$Element : (class$org$w3c$dom$Element = DOMStructure.class$("org.w3c.dom.Element")), "isDefaultNamespace", new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = DOMStructure.class$("java.lang.String"))});
        }
        catch (Throwable throwable) {}
        LOOKUP_NS_URI = method;
        IS_DEFAULT_NS = method2;
        compatibilityPrior1_14 = false;
    }

    protected static final class NodeWrapper
    extends DOMStructure {
        public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
            Document document = node.getOwnerDocument();
            Node node3 = this.getNode();
            if (node3.getOwnerDocument() != document) {
                this.setNode(node.appendChild(document.importNode(this.getNode(), true)));
            } else if (node != node3.getParentNode()) {
                this.setNode(node.appendChild(node3.cloneNode(true)));
            } else {
                throw new MarshalException("A wrapped Node either has to be in another document so it can be imported, but it should not be marhalled twice into the same parent.");
            }
            return this.getNode();
        }

        public String getNamespace() {
            return this.getNode().getNamespaceURI();
        }

        public String getLocalName() {
            return this.getNode().getLocalName();
        }

        protected void clearMarshalling() {
            List list = this.getChildStructures();
            if (list != null && list.size() > 0) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    DOMStructure dOMStructure = (DOMStructure)iterator.next();
                    dOMStructure.clearMarshalling();
                }
            }
            try {
                this.setParentStructure(null);
            }
            catch (MarshalException marshalException) {}
        }

        protected NodeWrapper(Node node) {
            try {
                this.setNode(node);
            }
            catch (MarshalException marshalException) {
                marshalException.printStackTrace();
                throw new RuntimeException(marshalException.getMessage());
            }
        }
    }

    private static class DummyNode
    implements Node {
        public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public void setTextContent(String string) throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public void setPrefix(String string) throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public void setNodeValue(String string) throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node replaceChild(Node node, Node node2) throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node removeChild(Node node) throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public void normalize() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String lookupPrefix(String string) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String lookupNamespaceURI(String string) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public boolean isSupported(String string, String string2) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public boolean isSameNode(Node node) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public boolean isEqualNode(Node node) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public boolean isDefaultNamespace(String string) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node insertBefore(Node node, Node node2) throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public boolean hasChildNodes() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public boolean hasAttributes() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Object getUserData(String string) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String getTextContent() throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node getPreviousSibling() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String getPrefix() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node getParentNode() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Document getOwnerDocument() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String getNodeValue() throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public short getNodeType() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String getNodeName() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node getNextSibling() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String getNamespaceURI() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String getLocalName() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node getLastChild() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node getFirstChild() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Object getFeature(String string, String string2) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public NodeList getChildNodes() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public String getBaseURI() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public NamedNodeMap getAttributes() {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public short compareDocumentPosition(Node node) throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node cloneNode(boolean bl) {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        public Node appendChild(Node node) throws DOMException {
            throw new IllegalStateException("Internal Error, please contact IAIK");
        }

        DummyNode() {
        }
    }
}

