/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.transform;

import iaik.xml.crypto.alg.transform.TransformServiceImpl;
import iaik.xml.crypto.dsig.spec.ExcC14NParameterImpl;
import iaik.xml.filter.impl.dsig.CanonInputStream;
import iaik.xml.filter.impl.dsig.Canonicalizer;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;

public class C14NTransformService
extends TransformServiceImpl
implements CanonicalizationMethod {
    private boolean initialized_ = false;
    private ExcC14NParameterImpl param_;
    private ExcC14NParameterSpec spec_;
    private boolean withComments_;
    private boolean exclusive_;
    private boolean c14n11_;

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws TransformException {
        Iterator iterator;
        if (!this.initialized_) {
            this.init(this.getAlgorithm());
        }
        if (data instanceof OctetStreamData) {
            iterator = this.parse((OctetStreamData)data);
        } else if (data instanceof NodeSetData) {
            iterator = ((NodeSetData)data).iterator();
        } else {
            throw new ClassCastException("The data type " + data.getClass().getName() + " is not compatible with this " + this.getClass().getName() + ".");
        }
        List list = this.exclusive_ && this.spec_ != null ? this.spec_.getPrefixList() : null;
        CanonInputStream canonInputStream = new CanonInputStream(new Canonicalizer(iterator, this.withComments_, this.exclusive_, this.c14n11_, list));
        return new OctetStreamData(canonInputStream);
    }

    protected void setParameterSpec(List list) throws InvalidAlgorithmParameterException {
        this.init(this.getAlgorithm());
        if (this.exclusive_ && list.size() == 1 && list.get(0) instanceof ExcC14NParameterImpl) {
            this.param_ = (ExcC14NParameterImpl)list.get(0);
            this.spec_ = new ExcC14NParameterSpec(this.param_.getPrefixList());
        } else if (list.size() != 0) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameters not supported by CanonicalizationMethod " + this.getAlgorithm() + ".");
        }
    }

    protected void setParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.init(this.getAlgorithm());
        if (this.exclusive_ && algorithmParameterSpec instanceof C14NMethodParameterSpec) {
            this.spec_ = (ExcC14NParameterSpec)algorithmParameterSpec;
        } else if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec '" + algorithmParameterSpec.getClass().getName() + "' not supported by CanonicalizationMethod " + this.getAlgorithm() + ".");
        }
    }

    private void init(String string) {
        if ("http://www.w3.org/2006/12/xml-c14n11".equals(string)) {
            this.c14n11_ = true;
            this.exclusive_ = false;
            this.withComments_ = false;
        } else if ("http://www.w3.org/2006/12/xml-c14n11#WithComments".equals(string)) {
            this.c14n11_ = true;
            this.exclusive_ = false;
            this.withComments_ = true;
        } else if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315".equals(string)) {
            this.c14n11_ = false;
            this.exclusive_ = false;
            this.withComments_ = false;
        } else if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments".equals(string)) {
            this.c14n11_ = false;
            this.exclusive_ = false;
            this.withComments_ = true;
        } else if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(string)) {
            this.c14n11_ = false;
            this.exclusive_ = true;
            this.withComments_ = false;
        } else if ("http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(string)) {
            this.c14n11_ = false;
            this.exclusive_ = true;
            this.withComments_ = true;
        }
        this.initialized_ = true;
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.spec_;
    }

    public List getAlgorithmParameters() {
        if (this.spec_ != null) {
            ArrayList<ExcC14NParameterImpl> arrayList = new ArrayList<ExcC14NParameterImpl>(1);
            if (this.param_ == null) {
                this.param_ = new ExcC14NParameterImpl(this.spec_.getPrefixList());
            }
            arrayList.add(this.param_);
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }
}

