/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.cipher;

import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.xml.crypto.alg.cipher.ProxyCipher;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

public class AESKWProxyCipher
extends ProxyCipher {
    protected int opmode_;
    protected ByteArrayOutputStream buffer_ = new ByteArrayOutputStream();
    public static final byte[] NIST_KEY_WRAP_IV = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};

    protected String getCipherName() {
        return "AES/ECB/NoPadding";
    }

    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] byArray = key.getEncoded();
        try {
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        this.buffer_.write(byArray, n, n2);
        return 0;
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.buffer_.write(byArray, n, n2);
        return null;
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] byArray2;
        try {
            byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
        return Util.decodeKey((int)n, (String)string, (byte[])byArray2);
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        switch (n) {
            case 4: {
                this.opmode_ = 2;
                break;
            }
            case 3: {
                this.opmode_ = 1;
                break;
            }
            default: {
                this.opmode_ = n;
            }
        }
        super.engineInit(this.opmode_, key, algorithmParameterSpec, secureRandom);
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        switch (n) {
            case 4: {
                this.opmode_ = 2;
                break;
            }
            case 3: {
                this.opmode_ = 1;
                break;
            }
            default: {
                this.opmode_ = n;
            }
        }
        super.engineInit(this.opmode_, key, secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        switch (n) {
            case 4: {
                this.opmode_ = 2;
                break;
            }
            case 3: {
                this.opmode_ = 1;
                break;
            }
            default: {
                this.opmode_ = n;
            }
        }
        super.engineInit(this.opmode_, key, algorithmParameters, secureRandom);
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof SecretKey) {
            return key.getEncoded().length << 3;
        }
        throw new InvalidKeyException("Not a AES key.");
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        byte[] byArray3 = this.engineDoFinal(byArray, n, n2);
        if (byArray3 == null) {
            return 0;
        }
        if (byArray3.length > byArray2.length - n3) {
            throw new ShortBufferException();
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
        byte[] byArray2;
        if (this.buffer_.size() == 0) {
            if (n == 0 && n2 == byArray.length) {
                byArray2 = byArray;
            } else {
                byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
            }
        } else {
            this.buffer_.write(byArray, n, n2);
            byArray2 = this.buffer_.toByteArray();
            this.buffer_.reset();
        }
        if (byArray == null) throw new IllegalBlockSizeException();
        if (byArray.length % 8 != 0) {
            throw new IllegalBlockSizeException();
        }
        if (this.opmode_ == 1 || this.opmode_ == 3) {
            int n3;
            byte[] byArray3 = new byte[8];
            byte[] byArray4 = new byte[16];
            int n4 = byArray2.length / 8;
            int n5 = 6 * n4;
            byte[][] byArray5 = new byte[n4][8];
            if (byArray2.length == 8) {
                System.arraycopy(NIST_KEY_WRAP_IV, 0, byArray4, 0, NIST_KEY_WRAP_IV.length);
                System.arraycopy(byArray2, 0, byArray4, NIST_KEY_WRAP_IV.length, byArray2.length);
                return this.cipher_.doFinal(byArray4);
            }
            System.arraycopy(NIST_KEY_WRAP_IV, 0, byArray3, 0, NIST_KEY_WRAP_IV.length);
            int n6 = 0;
            while (n6 < n4) {
                System.arraycopy(byArray2, n6 * 8, byArray5[n6], 0, 8);
                ++n6;
            }
            int n7 = 0;
            while (n7 < 6) {
                n3 = 1;
                while (n3 <= n4) {
                    int n8 = n3 + n7 * n4;
                    int[] nArray = new int[2];
                    nArray[1] = n8;
                    int[] nArray2 = nArray;
                    byte[] byArray6 = new byte[8];
                    CryptoUtils.spreadIntsToBytes((int[])nArray2, (int)0, (byte[])byArray6, (int)0, (int)2);
                    byte[] byArray7 = new byte[16];
                    System.arraycopy(byArray3, 0, byArray7, 0, byArray3.length);
                    System.arraycopy(byArray5[n3 - 1], 0, byArray7, byArray3.length, byArray5[n3 - 1].length);
                    byArray4 = this.cipher_.doFinal(byArray7);
                    byte[] byArray8 = new byte[8];
                    byte[] byArray9 = new byte[8];
                    System.arraycopy(byArray4, 0, byArray8, 0, 8);
                    CryptoUtils.xorBlock((byte[])byArray6, (byte[])byArray8, (byte[])byArray3);
                    System.arraycopy(byArray4, 8, byArray5[n3 - 1], 0, 8);
                    ++n3;
                }
                ++n7;
            }
            byte[] byArray10 = new byte[8 * (n4 + 1)];
            System.arraycopy(byArray3, 0, byArray10, 0, 8);
            n3 = 0;
            while (n3 < n4) {
                System.arraycopy(byArray5[n3], 0, byArray10, 8 * (n3 + 1), 8);
                ++n3;
            }
            return byArray10;
        }
        byte[] byArray11 = null;
        Object var6_6 = null;
        byte[] byArray12 = new byte[8];
        byte[] byArray13 = new byte[16];
        int n9 = byArray2.length / 8 - 1;
        byte[][] byArray14 = new byte[n9][8];
        byArray11 = new byte[n9 * 8];
        if (byArray2.length == 16) {
            byArray13 = this.cipher_.doFinal(byArray2);
            if (CryptoUtils.compareBlock((byte[])byArray13, (int)0, (byte[])NIST_KEY_WRAP_IV, (int)0, (int)8) >= 0) throw new BadPaddingException();
            System.arraycopy(byArray13, 8, byArray11, 0, 8);
            return byArray11;
        } else {
            int n10;
            System.arraycopy(byArray2, 0, byArray12, 0, 8);
            int n11 = 0;
            while (n11 < n9) {
                System.arraycopy(byArray2, 8 * (n11 + 1), byArray14[n11], 0, 8);
                ++n11;
            }
            int n12 = 5;
            while (n12 >= 0) {
                n10 = n9;
                while (n10 > 0) {
                    int n13 = n10 + n12 * n9;
                    int[] nArray = new int[2];
                    nArray[1] = n13;
                    int[] nArray3 = nArray;
                    byte[] byArray15 = new byte[8];
                    CryptoUtils.spreadIntsToBytes((int[])nArray3, (int)0, (byte[])byArray15, (int)0, (int)2);
                    byte[] byArray16 = new byte[8];
                    CryptoUtils.xorBlock((byte[])byArray15, (byte[])byArray12, (byte[])byArray16);
                    byte[] byArray17 = new byte[16];
                    System.arraycopy(byArray16, 0, byArray17, 0, 8);
                    System.arraycopy(byArray14[n10 - 1], 0, byArray17, 8, 8);
                    byArray13 = this.cipher_.doFinal(byArray17);
                    System.arraycopy(byArray13, 0, byArray12, 0, 8);
                    System.arraycopy(byArray13, 8, byArray14[n10 - 1], 0, 8);
                    --n10;
                }
                --n12;
            }
            if (CryptoUtils.compareBlock((byte[])byArray12, (byte[])NIST_KEY_WRAP_IV) >= 0) throw new BadPaddingException();
            n10 = 0;
            while (n10 < n9) {
                System.arraycopy(byArray14[n10], 0, byArray11, 8 * n10, 8);
                ++n10;
            }
        }
        return byArray11;
    }
}

