/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.DecoderStateTables;
import com.sun.xml.internal.fastinfoset.EncodingConstants;
import com.sun.xml.internal.fastinfoset.Notation;
import com.sun.xml.internal.fastinfoset.OctetBufferListener;
import com.sun.xml.internal.fastinfoset.QualifiedName;
import com.sun.xml.internal.fastinfoset.UnparsedEntity;
import com.sun.xml.internal.fastinfoset.alphabet.BuiltInRestrictedAlphabets;
import com.sun.xml.internal.fastinfoset.org.apache.xerces.util.XMLChar;
import com.sun.xml.internal.fastinfoset.util.CharArray;
import com.sun.xml.internal.fastinfoset.util.CharArrayArray;
import com.sun.xml.internal.fastinfoset.util.CharArrayString;
import com.sun.xml.internal.fastinfoset.util.ContiguousCharArrayArray;
import com.sun.xml.internal.fastinfoset.util.DuplicateAttributeVerifier;
import com.sun.xml.internal.fastinfoset.util.PrefixArray;
import com.sun.xml.internal.fastinfoset.util.QualifiedNameArray;
import com.sun.xml.internal.fastinfoset.util.StringArray;
import com.sun.xml.internal.fastinfoset.vocab.ParserVocabulary;
import com.sun.xml.internal.org.jvnet.fastinfoset.ExternalVocabulary;
import com.sun.xml.internal.org.jvnet.fastinfoset.FastInfosetException;
import com.sun.xml.internal.org.jvnet.fastinfoset.FastInfosetParser;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Decoder
implements FastInfosetParser {
    private static final char[] XML_NAMESPACE_NAME_CHARS = "http://www.w3.org/XML/1998/namespace".toCharArray();
    private static final char[] XMLNS_NAMESPACE_PREFIX_CHARS = "xmlns".toCharArray();
    private static final char[] XMLNS_NAMESPACE_NAME_CHARS = "http://www.w3.org/2000/xmlns/".toCharArray();
    public static final String STRING_INTERNING_SYSTEM_PROPERTY = "com.sun.xml.internal.fastinfoset.parser.string-interning";
    public static final String BUFFER_SIZE_SYSTEM_PROPERTY = "com.sun.xml.internal.fastinfoset.parser.buffer-size";
    private static boolean _stringInterningSystemDefault = false;
    private static int _bufferSizeSystemDefault = 1024;
    private boolean _stringInterning = _stringInterningSystemDefault;
    private InputStream _s;
    private Map _externalVocabularies;
    protected boolean _parseFragments;
    protected boolean _needForceStreamClose;
    private boolean _vIsInternal;
    protected List _notations;
    protected List _unparsedEntities;
    protected Map _registeredEncodingAlgorithms = new HashMap();
    protected ParserVocabulary _v;
    protected PrefixArray _prefixTable;
    protected QualifiedNameArray _elementNameTable;
    protected QualifiedNameArray _attributeNameTable;
    protected ContiguousCharArrayArray _characterContentChunkTable;
    protected StringArray _attributeValueTable;
    protected int _b;
    protected boolean _terminate;
    protected boolean _doubleTerminate;
    protected boolean _addToTable;
    protected int _integer;
    protected int _identifier;
    protected int _bufferSize = _bufferSizeSystemDefault;
    protected byte[] _octetBuffer = new byte[_bufferSizeSystemDefault];
    protected int _octetBufferStart;
    protected int _octetBufferOffset;
    protected int _octetBufferEnd;
    protected int _octetBufferLength;
    protected char[] _charBuffer = new char[512];
    protected int _charBufferLength;
    protected DuplicateAttributeVerifier _duplicateAttributeVerifier = new DuplicateAttributeVerifier();
    protected static final int NISTRING_STRING = 0;
    protected static final int NISTRING_INDEX = 1;
    protected static final int NISTRING_ENCODING_ALGORITHM = 2;
    protected static final int NISTRING_EMPTY_STRING = 3;
    protected int _prefixIndex;
    protected int _namespaceNameIndex;
    private int _bitsLeftInOctet;
    private char _utf8_highSurrogate;
    private char _utf8_lowSurrogate;

    protected Decoder() {
        this._v = new ParserVocabulary();
        this._prefixTable = this._v.prefix;
        this._elementNameTable = this._v.elementName;
        this._attributeNameTable = this._v.attributeName;
        this._characterContentChunkTable = this._v.characterContentChunk;
        this._attributeValueTable = this._v.attributeValue;
        this._vIsInternal = true;
    }

    @Override
    public void setStringInterning(boolean bl) {
        this._stringInterning = bl;
    }

    @Override
    public boolean getStringInterning() {
        return this._stringInterning;
    }

    @Override
    public void setBufferSize(int n) {
        if (this._bufferSize > this._octetBuffer.length) {
            this._bufferSize = n;
        }
    }

    @Override
    public int getBufferSize() {
        return this._bufferSize;
    }

    @Override
    public void setRegisteredEncodingAlgorithms(Map map) {
        this._registeredEncodingAlgorithms = map;
        if (this._registeredEncodingAlgorithms == null) {
            this._registeredEncodingAlgorithms = new HashMap();
        }
    }

    @Override
    public Map getRegisteredEncodingAlgorithms() {
        return this._registeredEncodingAlgorithms;
    }

    @Override
    public void setExternalVocabularies(Map map) {
        if (map != null) {
            this._externalVocabularies = new HashMap();
            this._externalVocabularies.putAll(map);
        } else {
            this._externalVocabularies = null;
        }
    }

    @Override
    public Map getExternalVocabularies() {
        return this._externalVocabularies;
    }

    @Override
    public void setParseFragments(boolean bl) {
        this._parseFragments = bl;
    }

    @Override
    public boolean getParseFragments() {
        return this._parseFragments;
    }

    @Override
    public void setForceStreamClose(boolean bl) {
        this._needForceStreamClose = bl;
    }

    @Override
    public boolean getForceStreamClose() {
        return this._needForceStreamClose;
    }

    public void reset() {
        this._doubleTerminate = false;
        this._terminate = false;
    }

    public void setVocabulary(ParserVocabulary parserVocabulary) {
        this._v = parserVocabulary;
        this._prefixTable = this._v.prefix;
        this._elementNameTable = this._v.elementName;
        this._attributeNameTable = this._v.attributeName;
        this._characterContentChunkTable = this._v.characterContentChunk;
        this._attributeValueTable = this._v.attributeValue;
        this._vIsInternal = false;
    }

    public void setInputStream(InputStream inputStream) {
        this._s = inputStream;
        this._octetBufferOffset = 0;
        this._octetBufferEnd = 0;
        if (this._vIsInternal) {
            this._v.clear();
        }
    }

    protected final void decodeDII() throws FastInfosetException, IOException {
        int n = this.read();
        if (n == 32) {
            this.decodeInitialVocabulary();
        } else if (n != 0) {
            throw new IOException(CommonResourceBundle.getInstance().getString("message.optinalValues"));
        }
    }

    protected final void decodeAdditionalData() throws FastInfosetException, IOException {
        int n = this.decodeNumberOfItemsOfSequence();
        for (int i = 0; i < n; ++i) {
            String string = this.decodeNonEmptyOctetStringOnSecondBitAsUtf8String();
            this.decodeNonEmptyOctetStringLengthOnSecondBit();
            this.ensureOctetBufferSize();
            this._octetBufferStart = this._octetBufferOffset;
            this._octetBufferOffset += this._octetBufferLength;
        }
    }

    protected final void decodeInitialVocabulary() throws FastInfosetException, IOException {
        int n = this.read();
        int n2 = this.read();
        if (n == 16 && n2 == 0) {
            this.decodeExternalVocabularyURI();
            return;
        }
        if ((n & 0x10) > 0) {
            this.decodeExternalVocabularyURI();
        }
        if ((n & 8) > 0) {
            this.decodeTableItems(this._v.restrictedAlphabet);
        }
        if ((n & 4) > 0) {
            this.decodeTableItems(this._v.encodingAlgorithm);
        }
        if ((n & 2) > 0) {
            this.decodeTableItems(this._v.prefix);
        }
        if ((n & 1) > 0) {
            this.decodeTableItems(this._v.namespaceName);
        }
        if ((n2 & 0x80) > 0) {
            this.decodeTableItems(this._v.localName);
        }
        if ((n2 & 0x40) > 0) {
            this.decodeTableItems(this._v.otherNCName);
        }
        if ((n2 & 0x20) > 0) {
            this.decodeTableItems(this._v.otherURI);
        }
        if ((n2 & 0x10) > 0) {
            this.decodeTableItems(this._v.attributeValue);
        }
        if ((n2 & 8) > 0) {
            this.decodeTableItems(this._v.characterContentChunk);
        }
        if ((n2 & 4) > 0) {
            this.decodeTableItems(this._v.otherString);
        }
        if ((n2 & 2) > 0) {
            this.decodeTableItems(this._v.elementName, false);
        }
        if ((n2 & 1) > 0) {
            this.decodeTableItems(this._v.attributeName, true);
        }
    }

    private void decodeExternalVocabularyURI() throws FastInfosetException, IOException {
        if (this._externalVocabularies == null) {
            throw new IOException(CommonResourceBundle.getInstance().getString("message.noExternalVocabularies"));
        }
        String string = this.decodeNonEmptyOctetStringOnSecondBitAsUtf8String();
        Object v = this._externalVocabularies.get(string);
        if (v instanceof ParserVocabulary) {
            this._v.setReferencedVocabulary(string, (ParserVocabulary)v, false);
        } else if (v instanceof ExternalVocabulary) {
            ExternalVocabulary externalVocabulary = (ExternalVocabulary)v;
            ParserVocabulary parserVocabulary = new ParserVocabulary(externalVocabulary.vocabulary);
            this._externalVocabularies.put(string, parserVocabulary);
            this._v.setReferencedVocabulary(string, parserVocabulary, false);
        } else {
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.externalVocabularyNotRegistered", new Object[]{string}));
        }
    }

    private void decodeTableItems(StringArray stringArray) throws FastInfosetException, IOException {
        int n = this.decodeNumberOfItemsOfSequence();
        for (int i = 0; i < n; ++i) {
            stringArray.add(this.decodeNonEmptyOctetStringOnSecondBitAsUtf8String());
        }
    }

    private void decodeTableItems(PrefixArray prefixArray) throws FastInfosetException, IOException {
        int n = this.decodeNumberOfItemsOfSequence();
        for (int i = 0; i < n; ++i) {
            prefixArray.add(this.decodeNonEmptyOctetStringOnSecondBitAsUtf8String());
        }
    }

    private void decodeTableItems(ContiguousCharArrayArray contiguousCharArrayArray) throws FastInfosetException, IOException {
        int n = this.decodeNumberOfItemsOfSequence();
        block3: for (int i = 0; i < n; ++i) {
            switch (this.decodeNonIdentifyingStringOnFirstBit()) {
                case 0: {
                    contiguousCharArrayArray.add(this._charBuffer, this._charBufferLength);
                    continue block3;
                }
                default: {
                    throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.illegalState"));
                }
            }
        }
    }

    private void decodeTableItems(CharArrayArray charArrayArray) throws FastInfosetException, IOException {
        int n = this.decodeNumberOfItemsOfSequence();
        block3: for (int i = 0; i < n; ++i) {
            switch (this.decodeNonIdentifyingStringOnFirstBit()) {
                case 0: {
                    charArrayArray.add(new CharArray(this._charBuffer, 0, this._charBufferLength, true));
                    continue block3;
                }
                default: {
                    throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.illegalState"));
                }
            }
        }
    }

    private void decodeTableItems(QualifiedNameArray qualifiedNameArray, boolean bl) throws FastInfosetException, IOException {
        int n = this.decodeNumberOfItemsOfSequence();
        for (int i = 0; i < n; ++i) {
            int n2 = this.read();
            String string = "";
            int n3 = -1;
            if ((n2 & 2) > 0) {
                n3 = this.decodeIntegerIndexOnSecondBit();
                string = this._v.prefix.get(n3);
            }
            String string2 = "";
            int n4 = -1;
            if ((n2 & 1) > 0) {
                n4 = this.decodeIntegerIndexOnSecondBit();
                string2 = this._v.namespaceName.get(n4);
            }
            if (string2 == "" && string != "") {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.missingNamespace"));
            }
            int n5 = this.decodeIntegerIndexOnSecondBit();
            String string3 = this._v.localName.get(n5);
            QualifiedName qualifiedName = new QualifiedName(string, string2, string3, n3, n4, n5, this._charBuffer);
            if (bl) {
                qualifiedName.createAttributeValues(256);
            }
            qualifiedNameArray.add(qualifiedName);
        }
    }

    private int decodeNumberOfItemsOfSequence() throws IOException {
        int n = this.read();
        if (n < 128) {
            return n + 1;
        }
        return ((n & 0xF) << 16 | this.read() << 8 | this.read()) + 129;
    }

    protected final void decodeNotations() throws FastInfosetException, IOException {
        if (this._notations == null) {
            this._notations = new ArrayList();
        } else {
            this._notations.clear();
        }
        int n = this.read();
        while ((n & 0xFC) == 192) {
            String string = this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherNCName);
            String string2 = (this._b & 2) > 0 ? this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherURI) : "";
            String string3 = (this._b & 1) > 0 ? this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherURI) : "";
            Notation notation = new Notation(string, string2, string3);
            this._notations.add(notation);
            n = this.read();
        }
        if (n != 240) {
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.IIsNotTerminatedCorrectly"));
        }
    }

    protected final void decodeUnparsedEntities() throws FastInfosetException, IOException {
        if (this._unparsedEntities == null) {
            this._unparsedEntities = new ArrayList();
        } else {
            this._unparsedEntities.clear();
        }
        int n = this.read();
        while ((n & 0xFE) == 208) {
            String string = this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherNCName);
            String string2 = this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherURI);
            String string3 = (this._b & 1) > 0 ? this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherURI) : "";
            String string4 = this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherNCName);
            UnparsedEntity unparsedEntity = new UnparsedEntity(string, string2, string3, string4);
            this._unparsedEntities.add(unparsedEntity);
            n = this.read();
        }
        if (n != 240) {
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.unparsedEntities"));
        }
    }

    protected final String decodeCharacterEncodingScheme() throws FastInfosetException, IOException {
        return this.decodeNonEmptyOctetStringOnSecondBitAsUtf8String();
    }

    protected final String decodeVersion() throws FastInfosetException, IOException {
        switch (this.decodeNonIdentifyingStringOnFirstBit()) {
            case 0: {
                String string = new String(this._charBuffer, 0, this._charBufferLength);
                if (this._addToTable) {
                    this._v.otherString.add(new CharArrayString(string));
                }
                return string;
            }
            case 2: {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.decodingNotSupported"));
            }
            case 1: {
                return this._v.otherString.get(this._integer).toString();
            }
        }
        return "";
    }

    protected final QualifiedName decodeEIIIndexMedium() throws FastInfosetException, IOException {
        int n = ((this._b & 7) << 8 | this.read()) + 32;
        return this._v.elementName._array[n];
    }

    protected final QualifiedName decodeEIIIndexLarge() throws FastInfosetException, IOException {
        int n = (this._b & 0x30) == 32 ? ((this._b & 7) << 16 | this.read() << 8 | this.read()) + 2080 : ((this.read() & 0xF) << 16 | this.read() << 8 | this.read()) + 526368;
        return this._v.elementName._array[n];
    }

    protected final QualifiedName decodeLiteralQualifiedName(int n, QualifiedName qualifiedName) throws FastInfosetException, IOException {
        if (qualifiedName == null) {
            qualifiedName = new QualifiedName();
        }
        switch (n) {
            case 0: {
                return qualifiedName.set("", "", this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.localName), -1, -1, this._identifier, null);
            }
            case 1: {
                return qualifiedName.set("", this.decodeIdentifyingNonEmptyStringIndexOnFirstBitAsNamespaceName(false), this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.localName), -1, this._namespaceNameIndex, this._identifier, null);
            }
            case 2: {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.qNameMissingNamespaceName"));
            }
            case 3: {
                return qualifiedName.set(this.decodeIdentifyingNonEmptyStringIndexOnFirstBitAsPrefix(true), this.decodeIdentifyingNonEmptyStringIndexOnFirstBitAsNamespaceName(true), this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.localName), this._prefixIndex, this._namespaceNameIndex, this._identifier, this._charBuffer);
            }
        }
        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.decodingEII"));
    }

    protected final int decodeNonIdentifyingStringOnFirstBit() throws FastInfosetException, IOException {
        int n = this.read();
        switch (DecoderStateTables.NISTRING(n)) {
            case 0: {
                this._addToTable = (n & 0x40) > 0;
                this._octetBufferLength = (n & 7) + 1;
                this.decodeUtf8StringAsCharBuffer();
                return 0;
            }
            case 1: {
                this._addToTable = (n & 0x40) > 0;
                this._octetBufferLength = this.read() + 9;
                this.decodeUtf8StringAsCharBuffer();
                return 0;
            }
            case 2: {
                this._addToTable = (n & 0x40) > 0;
                int n2 = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
                this._octetBufferLength = n2 + 265;
                this.decodeUtf8StringAsCharBuffer();
                return 0;
            }
            case 3: {
                this._addToTable = (n & 0x40) > 0;
                this._octetBufferLength = (n & 7) + 1;
                this.decodeUtf16StringAsCharBuffer();
                return 0;
            }
            case 4: {
                this._addToTable = (n & 0x40) > 0;
                this._octetBufferLength = this.read() + 9;
                this.decodeUtf16StringAsCharBuffer();
                return 0;
            }
            case 5: {
                this._addToTable = (n & 0x40) > 0;
                int n3 = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
                this._octetBufferLength = n3 + 265;
                this.decodeUtf16StringAsCharBuffer();
                return 0;
            }
            case 6: {
                this._addToTable = (n & 0x40) > 0;
                this._identifier = (n & 0xF) << 4;
                int n4 = this.read();
                this._identifier |= (n4 & 0xF0) >> 4;
                this.decodeOctetsOnFifthBitOfNonIdentifyingStringOnFirstBit(n4);
                this.decodeRestrictedAlphabetAsCharBuffer();
                return 0;
            }
            case 7: {
                this._addToTable = (n & 0x40) > 0;
                this._identifier = (n & 0xF) << 4;
                int n5 = this.read();
                this._identifier |= (n5 & 0xF0) >> 4;
                this.decodeOctetsOnFifthBitOfNonIdentifyingStringOnFirstBit(n5);
                return 2;
            }
            case 8: {
                this._integer = n & 0x3F;
                return 1;
            }
            case 9: {
                this._integer = ((n & 0x1F) << 8 | this.read()) + 64;
                return 1;
            }
            case 10: {
                this._integer = ((n & 0xF) << 16 | this.read() << 8 | this.read()) + 8256;
                return 1;
            }
            case 11: {
                return 3;
            }
        }
        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.decodingNonIdentifyingString"));
    }

    protected final void decodeOctetsOnFifthBitOfNonIdentifyingStringOnFirstBit(int n) throws FastInfosetException, IOException {
        switch (DecoderStateTables.NISTRING(n &= 0xF)) {
            case 0: {
                this._octetBufferLength = n + 1;
                break;
            }
            case 1: {
                this._octetBufferLength = this.read() + 9;
                break;
            }
            case 2: {
                int n2 = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
                this._octetBufferLength = n2 + 265;
                break;
            }
            default: {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.decodingOctets"));
            }
        }
        this.ensureOctetBufferSize();
        this._octetBufferStart = this._octetBufferOffset;
        this._octetBufferOffset += this._octetBufferLength;
    }

    protected final void decodeOctetsOnSeventhBitOfNonIdentifyingStringOnThirdBit(int n) throws FastInfosetException, IOException {
        switch (n & 3) {
            case 0: {
                this._octetBufferLength = 1;
                break;
            }
            case 1: {
                this._octetBufferLength = 2;
                break;
            }
            case 2: {
                this._octetBufferLength = this.read() + 3;
                break;
            }
            case 3: {
                this._octetBufferLength = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
                this._octetBufferLength += 259;
            }
        }
        this.ensureOctetBufferSize();
        this._octetBufferStart = this._octetBufferOffset;
        this._octetBufferOffset += this._octetBufferLength;
    }

    protected final String decodeIdentifyingNonEmptyStringOnFirstBit(StringArray stringArray) throws FastInfosetException, IOException {
        int n = this.read();
        switch (DecoderStateTables.ISTRING(n)) {
            case 0: {
                this._octetBufferLength = n + 1;
                String string = this._stringInterning ? this.decodeUtf8StringAsString().intern() : this.decodeUtf8StringAsString();
                this._identifier = stringArray.add(string) - 1;
                return string;
            }
            case 1: {
                this._octetBufferLength = this.read() + 65;
                String string = this._stringInterning ? this.decodeUtf8StringAsString().intern() : this.decodeUtf8StringAsString();
                this._identifier = stringArray.add(string) - 1;
                return string;
            }
            case 2: {
                int n2 = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
                this._octetBufferLength = n2 + 321;
                String string = this._stringInterning ? this.decodeUtf8StringAsString().intern() : this.decodeUtf8StringAsString();
                this._identifier = stringArray.add(string) - 1;
                return string;
            }
            case 3: {
                this._identifier = n & 0x3F;
                return stringArray._array[this._identifier];
            }
            case 4: {
                this._identifier = ((n & 0x1F) << 8 | this.read()) + 64;
                return stringArray._array[this._identifier];
            }
            case 5: {
                this._identifier = ((n & 0xF) << 16 | this.read() << 8 | this.read()) + 8256;
                return stringArray._array[this._identifier];
            }
        }
        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.decodingIdentifyingString"));
    }

    protected final String decodeIdentifyingNonEmptyStringOnFirstBitAsPrefix(boolean bl) throws FastInfosetException, IOException {
        int n = this.read();
        switch (DecoderStateTables.ISTRING_PREFIX_NAMESPACE(n)) {
            case 6: {
                this._octetBufferLength = EncodingConstants.XML_NAMESPACE_PREFIX_LENGTH;
                this.decodeUtf8StringAsCharBuffer();
                if (this._charBuffer[0] == 'x' && this._charBuffer[1] == 'm' && this._charBuffer[2] == 'l') {
                    throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.prefixIllegal"));
                }
                String string = this._stringInterning ? new String(this._charBuffer, 0, this._charBufferLength).intern() : new String(this._charBuffer, 0, this._charBufferLength);
                this._prefixIndex = this._v.prefix.add(string);
                return string;
            }
            case 7: {
                this._octetBufferLength = EncodingConstants.XMLNS_NAMESPACE_PREFIX_LENGTH;
                this.decodeUtf8StringAsCharBuffer();
                if (this._charBuffer[0] == 'x' && this._charBuffer[1] == 'm' && this._charBuffer[2] == 'l' && this._charBuffer[3] == 'n' && this._charBuffer[4] == 's') {
                    throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.xmlns"));
                }
                String string = this._stringInterning ? new String(this._charBuffer, 0, this._charBufferLength).intern() : new String(this._charBuffer, 0, this._charBufferLength);
                this._prefixIndex = this._v.prefix.add(string);
                return string;
            }
            case 0: 
            case 8: 
            case 9: {
                this._octetBufferLength = n + 1;
                String string = this._stringInterning ? this.decodeUtf8StringAsString().intern() : this.decodeUtf8StringAsString();
                this._prefixIndex = this._v.prefix.add(string);
                return string;
            }
            case 1: {
                this._octetBufferLength = this.read() + 65;
                String string = this._stringInterning ? this.decodeUtf8StringAsString().intern() : this.decodeUtf8StringAsString();
                this._prefixIndex = this._v.prefix.add(string);
                return string;
            }
            case 2: {
                int n2 = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
                this._octetBufferLength = n2 + 321;
                String string = this._stringInterning ? this.decodeUtf8StringAsString().intern() : this.decodeUtf8StringAsString();
                this._prefixIndex = this._v.prefix.add(string);
                return string;
            }
            case 10: {
                if (bl) {
                    this._prefixIndex = 0;
                    if (DecoderStateTables.ISTRING_PREFIX_NAMESPACE(this.peek()) != 10) {
                        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.wrongNamespaceName"));
                    }
                    return "xml";
                }
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.missingNamespaceName"));
            }
            case 3: {
                this._prefixIndex = n & 0x3F;
                return this._v.prefix._array[this._prefixIndex - 1];
            }
            case 4: {
                this._prefixIndex = ((n & 0x1F) << 8 | this.read()) + 64;
                return this._v.prefix._array[this._prefixIndex - 1];
            }
            case 5: {
                this._prefixIndex = ((n & 0xF) << 16 | this.read() << 8 | this.read()) + 8256;
                return this._v.prefix._array[this._prefixIndex - 1];
            }
        }
        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.decodingIdentifyingStringForPrefix"));
    }

    protected final String decodeIdentifyingNonEmptyStringIndexOnFirstBitAsPrefix(boolean bl) throws FastInfosetException, IOException {
        int n = this.read();
        switch (DecoderStateTables.ISTRING_PREFIX_NAMESPACE(n)) {
            case 10: {
                if (bl) {
                    this._prefixIndex = 0;
                    if (DecoderStateTables.ISTRING_PREFIX_NAMESPACE(this.peek()) != 10) {
                        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.wrongNamespaceName"));
                    }
                    return "xml";
                }
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.missingNamespaceName"));
            }
            case 3: {
                this._prefixIndex = n & 0x3F;
                return this._v.prefix._array[this._prefixIndex - 1];
            }
            case 4: {
                this._prefixIndex = ((n & 0x1F) << 8 | this.read()) + 64;
                return this._v.prefix._array[this._prefixIndex - 1];
            }
            case 5: {
                this._prefixIndex = ((n & 0xF) << 16 | this.read() << 8 | this.read()) + 8256;
                return this._v.prefix._array[this._prefixIndex - 1];
            }
        }
        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.decodingIdentifyingStringForPrefix"));
    }

    protected final String decodeIdentifyingNonEmptyStringOnFirstBitAsNamespaceName(boolean bl) throws FastInfosetException, IOException {
        int n = this.read();
        switch (DecoderStateTables.ISTRING_PREFIX_NAMESPACE(n)) {
            case 0: 
            case 6: 
            case 7: {
                this._octetBufferLength = n + 1;
                String string = this._stringInterning ? this.decodeUtf8StringAsString().intern() : this.decodeUtf8StringAsString();
                this._namespaceNameIndex = this._v.namespaceName.add(string);
                return string;
            }
            case 8: {
                this._octetBufferLength = EncodingConstants.XMLNS_NAMESPACE_NAME_LENGTH;
                this.decodeUtf8StringAsCharBuffer();
                if (this.compareCharsWithCharBufferFromEndToStart(XMLNS_NAMESPACE_NAME_CHARS)) {
                    throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.xmlnsConnotBeBoundToPrefix"));
                }
                String string = this._stringInterning ? new String(this._charBuffer, 0, this._charBufferLength).intern() : new String(this._charBuffer, 0, this._charBufferLength);
                this._namespaceNameIndex = this._v.namespaceName.add(string);
                return string;
            }
            case 9: {
                this._octetBufferLength = EncodingConstants.XML_NAMESPACE_NAME_LENGTH;
                this.decodeUtf8StringAsCharBuffer();
                if (this.compareCharsWithCharBufferFromEndToStart(XML_NAMESPACE_NAME_CHARS)) {
                    throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.illegalNamespaceName"));
                }
                String string = this._stringInterning ? new String(this._charBuffer, 0, this._charBufferLength).intern() : new String(this._charBuffer, 0, this._charBufferLength);
                this._namespaceNameIndex = this._v.namespaceName.add(string);
                return string;
            }
            case 1: {
                this._octetBufferLength = this.read() + 65;
                String string = this._stringInterning ? this.decodeUtf8StringAsString().intern() : this.decodeUtf8StringAsString();
                this._namespaceNameIndex = this._v.namespaceName.add(string);
                return string;
            }
            case 2: {
                int n2 = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
                this._octetBufferLength = n2 + 321;
                String string = this._stringInterning ? this.decodeUtf8StringAsString().intern() : this.decodeUtf8StringAsString();
                this._namespaceNameIndex = this._v.namespaceName.add(string);
                return string;
            }
            case 10: {
                if (bl) {
                    this._namespaceNameIndex = 0;
                    return "http://www.w3.org/XML/1998/namespace";
                }
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.namespaceWithoutPrefix"));
            }
            case 3: {
                this._namespaceNameIndex = n & 0x3F;
                return this._v.namespaceName._array[this._namespaceNameIndex - 1];
            }
            case 4: {
                this._namespaceNameIndex = ((n & 0x1F) << 8 | this.read()) + 64;
                return this._v.namespaceName._array[this._namespaceNameIndex - 1];
            }
            case 5: {
                this._namespaceNameIndex = ((n & 0xF) << 16 | this.read() << 8 | this.read()) + 8256;
                return this._v.namespaceName._array[this._namespaceNameIndex - 1];
            }
        }
        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.decodingForNamespaceName"));
    }

    protected final String decodeIdentifyingNonEmptyStringIndexOnFirstBitAsNamespaceName(boolean bl) throws FastInfosetException, IOException {
        int n = this.read();
        switch (DecoderStateTables.ISTRING_PREFIX_NAMESPACE(n)) {
            case 10: {
                if (bl) {
                    this._namespaceNameIndex = 0;
                    return "http://www.w3.org/XML/1998/namespace";
                }
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.namespaceWithoutPrefix"));
            }
            case 3: {
                this._namespaceNameIndex = n & 0x3F;
                return this._v.namespaceName._array[this._namespaceNameIndex - 1];
            }
            case 4: {
                this._namespaceNameIndex = ((n & 0x1F) << 8 | this.read()) + 64;
                return this._v.namespaceName._array[this._namespaceNameIndex - 1];
            }
            case 5: {
                this._namespaceNameIndex = ((n & 0xF) << 16 | this.read() << 8 | this.read()) + 8256;
                return this._v.namespaceName._array[this._namespaceNameIndex - 1];
            }
        }
        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.decodingForNamespaceName"));
    }

    private boolean compareCharsWithCharBufferFromEndToStart(char[] cArray) {
        int n = this._charBufferLength;
        while (--n >= 0) {
            if (cArray[n] == this._charBuffer[n]) continue;
            return false;
        }
        return true;
    }

    protected final String decodeNonEmptyOctetStringOnSecondBitAsUtf8String() throws FastInfosetException, IOException {
        this.decodeNonEmptyOctetStringOnSecondBitAsUtf8CharArray();
        return new String(this._charBuffer, 0, this._charBufferLength);
    }

    protected final void decodeNonEmptyOctetStringOnSecondBitAsUtf8CharArray() throws FastInfosetException, IOException {
        this.decodeNonEmptyOctetStringLengthOnSecondBit();
        this.decodeUtf8StringAsCharBuffer();
    }

    protected final void decodeNonEmptyOctetStringLengthOnSecondBit() throws FastInfosetException, IOException {
        int n = this.read();
        switch (DecoderStateTables.ISTRING(n)) {
            case 0: {
                this._octetBufferLength = n + 1;
                break;
            }
            case 1: {
                this._octetBufferLength = this.read() + 65;
                break;
            }
            case 2: {
                int n2 = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
                this._octetBufferLength = n2 + 321;
                break;
            }
            default: {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.decodingNonEmptyOctet"));
            }
        }
    }

    protected final int decodeIntegerIndexOnSecondBit() throws FastInfosetException, IOException {
        int n = this.read() | 0x80;
        switch (DecoderStateTables.ISTRING(n)) {
            case 3: {
                return n & 0x3F;
            }
            case 4: {
                return ((n & 0x1F) << 8 | this.read()) + 64;
            }
            case 5: {
                return ((n & 0xF) << 16 | this.read() << 8 | this.read()) + 8256;
            }
        }
        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.decodingIndexOnSecondBit"));
    }

    protected final void decodeHeader() throws FastInfosetException, IOException {
        if (!this._isFastInfosetDocument()) {
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.notFIDocument"));
        }
    }

    protected final void decodeRestrictedAlphabetAsCharBuffer() throws FastInfosetException, IOException {
        if (this._identifier <= 1) {
            this.decodeFourBitAlphabetOctetsAsCharBuffer(BuiltInRestrictedAlphabets.table[this._identifier]);
        } else if (this._identifier >= 32) {
            CharArray charArray = this._v.restrictedAlphabet.get(this._identifier - 32);
            if (charArray == null) {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.alphabetNotPresent", new Object[]{this._identifier}));
            }
            this.decodeAlphabetOctetsAsCharBuffer(charArray.ch);
        } else {
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.alphabetIdentifiersReserved"));
        }
    }

    protected final String decodeRestrictedAlphabetAsString() throws FastInfosetException, IOException {
        this.decodeRestrictedAlphabetAsCharBuffer();
        return new String(this._charBuffer, 0, this._charBufferLength);
    }

    protected final String decodeRAOctetsAsString(char[] cArray) throws FastInfosetException, IOException {
        this.decodeAlphabetOctetsAsCharBuffer(cArray);
        return new String(this._charBuffer, 0, this._charBufferLength);
    }

    protected final void decodeFourBitAlphabetOctetsAsCharBuffer(char[] cArray) throws FastInfosetException, IOException {
        this._charBufferLength = 0;
        int n = this._octetBufferLength * 2;
        if (this._charBuffer.length < n) {
            this._charBuffer = new char[n];
        }
        int n2 = 0;
        for (int i = 0; i < this._octetBufferLength - 1; ++i) {
            n2 = this._octetBuffer[this._octetBufferStart++] & 0xFF;
            this._charBuffer[this._charBufferLength++] = cArray[n2 >> 4];
            this._charBuffer[this._charBufferLength++] = cArray[n2 & 0xF];
        }
        n2 = this._octetBuffer[this._octetBufferStart++] & 0xFF;
        this._charBuffer[this._charBufferLength++] = cArray[n2 >> 4];
        if ((n2 &= 0xF) != 15) {
            this._charBuffer[this._charBufferLength++] = cArray[n2 & 0xF];
        }
    }

    protected final void decodeAlphabetOctetsAsCharBuffer(char[] cArray) throws FastInfosetException, IOException {
        if (cArray.length < 2) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.alphabetMustContain2orMoreChars"));
        }
        int n = 1;
        while (1 << n <= cArray.length) {
            ++n;
        }
        int n2 = (1 << n) - 1;
        int n3 = (this._octetBufferLength << 3) / n;
        if (n3 == 0) {
            throw new IOException("");
        }
        this._charBufferLength = 0;
        if (this._charBuffer.length < n3) {
            this._charBuffer = new char[n3];
        }
        this.resetBits();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.readBits(n);
            if (n < 8 && n4 == n2) {
                int n5 = i * n >>> 3;
                if (n5 == this._octetBufferLength - 1) break;
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.alphabetIncorrectlyTerminated"));
            }
            this._charBuffer[this._charBufferLength++] = cArray[n4];
        }
    }

    private void resetBits() {
        this._bitsLeftInOctet = 0;
    }

    private int readBits(int n) throws IOException {
        int n2 = 0;
        while (n > 0) {
            if (this._bitsLeftInOctet == 0) {
                this._b = this._octetBuffer[this._octetBufferStart++] & 0xFF;
                this._bitsLeftInOctet = 8;
            }
            int n3 = (this._b & 1 << --this._bitsLeftInOctet) > 0 ? 1 : 0;
            n2 |= n3 << --n;
        }
        return n2;
    }

    protected final void decodeUtf8StringAsCharBuffer() throws IOException {
        this.ensureOctetBufferSize();
        this.decodeUtf8StringIntoCharBuffer();
    }

    protected final void decodeUtf8StringAsCharBuffer(char[] cArray, int n) throws IOException {
        this.ensureOctetBufferSize();
        this.decodeUtf8StringIntoCharBuffer(cArray, n);
    }

    protected final String decodeUtf8StringAsString() throws IOException {
        this.decodeUtf8StringAsCharBuffer();
        return new String(this._charBuffer, 0, this._charBufferLength);
    }

    protected final void decodeUtf16StringAsCharBuffer() throws IOException {
        this.ensureOctetBufferSize();
        this.decodeUtf16StringIntoCharBuffer();
    }

    protected final String decodeUtf16StringAsString() throws IOException {
        this.decodeUtf16StringAsCharBuffer();
        return new String(this._charBuffer, 0, this._charBufferLength);
    }

    private void ensureOctetBufferSize() throws IOException {
        if (this._octetBufferEnd < this._octetBufferOffset + this._octetBufferLength) {
            int n = this._octetBufferEnd - this._octetBufferOffset;
            if (this._octetBuffer.length < this._octetBufferLength) {
                byte[] byArray = new byte[this._octetBufferLength];
                System.arraycopy(this._octetBuffer, this._octetBufferOffset, byArray, 0, n);
                this._octetBuffer = byArray;
            } else {
                System.arraycopy(this._octetBuffer, this._octetBufferOffset, this._octetBuffer, 0, n);
            }
            this._octetBufferOffset = 0;
            int n2 = this._s.read(this._octetBuffer, n, this._octetBuffer.length - n);
            if (n2 < 0) {
                throw new EOFException("Unexpeceted EOF");
            }
            this._octetBufferEnd = n + n2;
            if (this._octetBufferEnd < this._octetBufferLength) {
                this.repeatedRead();
            }
        }
    }

    private void repeatedRead() throws IOException {
        while (this._octetBufferEnd < this._octetBufferLength) {
            int n = this._s.read(this._octetBuffer, this._octetBufferEnd, this._octetBuffer.length - this._octetBufferEnd);
            if (n < 0) {
                throw new EOFException("Unexpeceted EOF");
            }
            this._octetBufferEnd += n;
        }
    }

    protected final void decodeUtf8StringIntoCharBuffer() throws IOException {
        if (this._charBuffer.length < this._octetBufferLength) {
            this._charBuffer = new char[this._octetBufferLength];
        }
        this._charBufferLength = 0;
        int n = this._octetBufferLength + this._octetBufferOffset;
        while (n != this._octetBufferOffset) {
            int n2;
            if (DecoderStateTables.UTF8(n2 = this._octetBuffer[this._octetBufferOffset++] & 0xFF) == 1) {
                this._charBuffer[this._charBufferLength++] = (char)n2;
                continue;
            }
            this.decodeTwoToFourByteUtf8Character(n2, n);
        }
    }

    protected final void decodeUtf8StringIntoCharBuffer(char[] cArray, int n) throws IOException {
        this._charBufferLength = n;
        int n2 = this._octetBufferLength + this._octetBufferOffset;
        while (n2 != this._octetBufferOffset) {
            int n3;
            if (DecoderStateTables.UTF8(n3 = this._octetBuffer[this._octetBufferOffset++] & 0xFF) == 1) {
                cArray[this._charBufferLength++] = (char)n3;
                continue;
            }
            this.decodeTwoToFourByteUtf8Character(cArray, n3, n2);
        }
        this._charBufferLength -= n;
    }

    private void decodeTwoToFourByteUtf8Character(int n, int n2) throws IOException {
        switch (DecoderStateTables.UTF8(n)) {
            case 2: {
                int n3;
                if (n2 == this._octetBufferOffset) {
                    this.decodeUtf8StringLengthTooSmall();
                }
                if (((n3 = this._octetBuffer[this._octetBufferOffset++] & 0xFF) & 0xC0) != 128) {
                    this.decodeUtf8StringIllegalState();
                }
                this._charBuffer[this._charBufferLength++] = (char)((n & 0x1F) << 6 | n3 & 0x3F);
                break;
            }
            case 3: {
                char c = this.decodeUtf8ThreeByteChar(n2, n);
                if (XMLChar.isContent(c)) {
                    this._charBuffer[this._charBufferLength++] = c;
                    break;
                }
                this.decodeUtf8StringIllegalState();
                break;
            }
            case 4: {
                int n4 = this.decodeUtf8FourByteChar(n2, n);
                if (XMLChar.isContent(n4)) {
                    this._charBuffer[this._charBufferLength++] = this._utf8_highSurrogate;
                    this._charBuffer[this._charBufferLength++] = this._utf8_lowSurrogate;
                    break;
                }
                this.decodeUtf8StringIllegalState();
                break;
            }
            default: {
                this.decodeUtf8StringIllegalState();
            }
        }
    }

    private void decodeTwoToFourByteUtf8Character(char[] cArray, int n, int n2) throws IOException {
        switch (DecoderStateTables.UTF8(n)) {
            case 2: {
                int n3;
                if (n2 == this._octetBufferOffset) {
                    this.decodeUtf8StringLengthTooSmall();
                }
                if (((n3 = this._octetBuffer[this._octetBufferOffset++] & 0xFF) & 0xC0) != 128) {
                    this.decodeUtf8StringIllegalState();
                }
                cArray[this._charBufferLength++] = (char)((n & 0x1F) << 6 | n3 & 0x3F);
                break;
            }
            case 3: {
                char c = this.decodeUtf8ThreeByteChar(n2, n);
                if (XMLChar.isContent(c)) {
                    cArray[this._charBufferLength++] = c;
                    break;
                }
                this.decodeUtf8StringIllegalState();
                break;
            }
            case 4: {
                int n4 = this.decodeUtf8FourByteChar(n2, n);
                if (XMLChar.isContent(n4)) {
                    cArray[this._charBufferLength++] = this._utf8_highSurrogate;
                    cArray[this._charBufferLength++] = this._utf8_lowSurrogate;
                    break;
                }
                this.decodeUtf8StringIllegalState();
                break;
            }
            default: {
                this.decodeUtf8StringIllegalState();
            }
        }
    }

    protected final void decodeUtf8NCNameIntoCharBuffer() throws IOException {
        int n;
        this._charBufferLength = 0;
        if (this._charBuffer.length < this._octetBufferLength) {
            this._charBuffer = new char[this._octetBufferLength];
        }
        int n2 = this._octetBufferLength + this._octetBufferOffset;
        if (DecoderStateTables.UTF8_NCNAME(n = this._octetBuffer[this._octetBufferOffset++] & 0xFF) == 0) {
            this._charBuffer[this._charBufferLength++] = (char)n;
        } else {
            this.decodeUtf8NCNameStartTwoToFourByteCharacters(n, n2);
        }
        while (n2 != this._octetBufferOffset) {
            if (DecoderStateTables.UTF8_NCNAME(n = this._octetBuffer[this._octetBufferOffset++] & 0xFF) < 2) {
                this._charBuffer[this._charBufferLength++] = (char)n;
                continue;
            }
            this.decodeUtf8NCNameTwoToFourByteCharacters(n, n2);
        }
    }

    private void decodeUtf8NCNameStartTwoToFourByteCharacters(int n, int n2) throws IOException {
        switch (DecoderStateTables.UTF8_NCNAME(n)) {
            case 2: {
                char c;
                int n3;
                if (n2 == this._octetBufferOffset) {
                    this.decodeUtf8StringLengthTooSmall();
                }
                if (((n3 = this._octetBuffer[this._octetBufferOffset++] & 0xFF) & 0xC0) != 128) {
                    this.decodeUtf8StringIllegalState();
                }
                if (XMLChar.isNCNameStart(c = (char)((n & 0x1F) << 6 | n3 & 0x3F))) {
                    this._charBuffer[this._charBufferLength++] = c;
                    break;
                }
                this.decodeUtf8NCNameIllegalState();
                break;
            }
            case 3: {
                char c = this.decodeUtf8ThreeByteChar(n2, n);
                if (XMLChar.isNCNameStart(c)) {
                    this._charBuffer[this._charBufferLength++] = c;
                    break;
                }
                this.decodeUtf8NCNameIllegalState();
                break;
            }
            case 4: {
                int n4 = this.decodeUtf8FourByteChar(n2, n);
                if (XMLChar.isNCNameStart(n4)) {
                    this._charBuffer[this._charBufferLength++] = this._utf8_highSurrogate;
                    this._charBuffer[this._charBufferLength++] = this._utf8_lowSurrogate;
                    break;
                }
                this.decodeUtf8NCNameIllegalState();
                break;
            }
            default: {
                this.decodeUtf8NCNameIllegalState();
            }
        }
    }

    private void decodeUtf8NCNameTwoToFourByteCharacters(int n, int n2) throws IOException {
        switch (DecoderStateTables.UTF8_NCNAME(n)) {
            case 2: {
                char c;
                int n3;
                if (n2 == this._octetBufferOffset) {
                    this.decodeUtf8StringLengthTooSmall();
                }
                if (((n3 = this._octetBuffer[this._octetBufferOffset++] & 0xFF) & 0xC0) != 128) {
                    this.decodeUtf8StringIllegalState();
                }
                if (XMLChar.isNCName(c = (char)((n & 0x1F) << 6 | n3 & 0x3F))) {
                    this._charBuffer[this._charBufferLength++] = c;
                    break;
                }
                this.decodeUtf8NCNameIllegalState();
                break;
            }
            case 3: {
                char c = this.decodeUtf8ThreeByteChar(n2, n);
                if (XMLChar.isNCName(c)) {
                    this._charBuffer[this._charBufferLength++] = c;
                    break;
                }
                this.decodeUtf8NCNameIllegalState();
                break;
            }
            case 4: {
                int n4 = this.decodeUtf8FourByteChar(n2, n);
                if (XMLChar.isNCName(n4)) {
                    this._charBuffer[this._charBufferLength++] = this._utf8_highSurrogate;
                    this._charBuffer[this._charBufferLength++] = this._utf8_lowSurrogate;
                    break;
                }
                this.decodeUtf8NCNameIllegalState();
                break;
            }
            default: {
                this.decodeUtf8NCNameIllegalState();
            }
        }
    }

    private char decodeUtf8ThreeByteChar(int n, int n2) throws IOException {
        int n3;
        int n4;
        if (n == this._octetBufferOffset) {
            this.decodeUtf8StringLengthTooSmall();
        }
        if (((n4 = this._octetBuffer[this._octetBufferOffset++] & 0xFF) & 0xC0) != 128 || n2 == 237 && n4 >= 160 || (n2 & 0xF) == 0 && (n4 & 0x20) == 0) {
            this.decodeUtf8StringIllegalState();
        }
        if (n == this._octetBufferOffset) {
            this.decodeUtf8StringLengthTooSmall();
        }
        if (((n3 = this._octetBuffer[this._octetBufferOffset++] & 0xFF) & 0xC0) != 128) {
            this.decodeUtf8StringIllegalState();
        }
        return (char)((n2 & 0xF) << 12 | (n4 & 0x3F) << 6 | n3 & 0x3F);
    }

    private int decodeUtf8FourByteChar(int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n == this._octetBufferOffset) {
            this.decodeUtf8StringLengthTooSmall();
        }
        if (((n6 = this._octetBuffer[this._octetBufferOffset++] & 0xFF) & 0xC0) != 128 || (n6 & 0x30) == 0 && (n2 & 7) == 0) {
            this.decodeUtf8StringIllegalState();
        }
        if (n == this._octetBufferOffset) {
            this.decodeUtf8StringLengthTooSmall();
        }
        if (((n5 = this._octetBuffer[this._octetBufferOffset++] & 0xFF) & 0xC0) != 128) {
            this.decodeUtf8StringIllegalState();
        }
        if (n == this._octetBufferOffset) {
            this.decodeUtf8StringLengthTooSmall();
        }
        if (((n4 = this._octetBuffer[this._octetBufferOffset++] & 0xFF) & 0xC0) != 128) {
            this.decodeUtf8StringIllegalState();
        }
        if ((n3 = n2 << 2 & 0x1C | n6 >> 4 & 3) > 16) {
            this.decodeUtf8StringIllegalState();
        }
        int n7 = n3 - 1;
        this._utf8_highSurrogate = (char)(0xD800 | n7 << 6 & 0x3C0 | n6 << 2 & 0x3C | n5 >> 4 & 3);
        this._utf8_lowSurrogate = (char)(0xDC00 | n5 << 6 & 0x3C0 | n4 & 0x3F);
        return XMLChar.supplemental(this._utf8_highSurrogate, this._utf8_lowSurrogate);
    }

    private void decodeUtf8StringLengthTooSmall() throws IOException {
        throw new IOException(CommonResourceBundle.getInstance().getString("message.deliminatorTooSmall"));
    }

    private void decodeUtf8StringIllegalState() throws IOException {
        throw new IOException(CommonResourceBundle.getInstance().getString("message.UTF8Encoded"));
    }

    private void decodeUtf8NCNameIllegalState() throws IOException {
        throw new IOException(CommonResourceBundle.getInstance().getString("message.UTF8EncodedNCName"));
    }

    private void decodeUtf16StringIntoCharBuffer() throws IOException {
        this._charBufferLength = this._octetBufferLength / 2;
        if (this._charBuffer.length < this._charBufferLength) {
            this._charBuffer = new char[this._charBufferLength];
        }
        for (int i = 0; i < this._charBufferLength; ++i) {
            char c;
            this._charBuffer[i] = c = (char)(this.read() << 8 | this.read());
        }
    }

    protected String createQualifiedNameString(String string) {
        return this.createQualifiedNameString(XMLNS_NAMESPACE_PREFIX_CHARS, string);
    }

    protected String createQualifiedNameString(char[] cArray, String string) {
        int n = cArray.length;
        int n2 = string.length();
        int n3 = n + n2 + 1;
        if (n3 < this._charBuffer.length) {
            System.arraycopy(cArray, 0, this._charBuffer, 0, n);
            this._charBuffer[n] = 58;
            string.getChars(0, n2, this._charBuffer, n + 1);
            return new String(this._charBuffer, 0, n3);
        }
        StringBuffer stringBuffer = new StringBuffer(new String(cArray));
        stringBuffer.append(':');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected final int read() throws IOException {
        if (this._octetBufferOffset < this._octetBufferEnd) {
            return this._octetBuffer[this._octetBufferOffset++] & 0xFF;
        }
        this._octetBufferEnd = this._s.read(this._octetBuffer);
        if (this._octetBufferEnd < 0) {
            throw new EOFException(CommonResourceBundle.getInstance().getString("message.EOF"));
        }
        this._octetBufferOffset = 1;
        return this._octetBuffer[0] & 0xFF;
    }

    protected final void closeIfRequired() throws IOException {
        if (this._s != null && this._needForceStreamClose) {
            this._s.close();
        }
    }

    protected final int peek() throws IOException {
        return this.peek(null);
    }

    protected final int peek(OctetBufferListener octetBufferListener) throws IOException {
        if (this._octetBufferOffset < this._octetBufferEnd) {
            return this._octetBuffer[this._octetBufferOffset] & 0xFF;
        }
        if (octetBufferListener != null) {
            octetBufferListener.onBeforeOctetBufferOverwrite();
        }
        this._octetBufferEnd = this._s.read(this._octetBuffer);
        if (this._octetBufferEnd < 0) {
            throw new EOFException(CommonResourceBundle.getInstance().getString("message.EOF"));
        }
        this._octetBufferOffset = 0;
        return this._octetBuffer[0] & 0xFF;
    }

    protected final int peek2(OctetBufferListener octetBufferListener) throws IOException {
        if (this._octetBufferOffset + 1 < this._octetBufferEnd) {
            return this._octetBuffer[this._octetBufferOffset + 1] & 0xFF;
        }
        if (octetBufferListener != null) {
            octetBufferListener.onBeforeOctetBufferOverwrite();
        }
        int n = 0;
        if (this._octetBufferOffset < this._octetBufferEnd) {
            this._octetBuffer[0] = this._octetBuffer[this._octetBufferOffset];
            n = 1;
        }
        this._octetBufferEnd = this._s.read(this._octetBuffer, n, this._octetBuffer.length - n);
        if (this._octetBufferEnd < 0) {
            throw new EOFException(CommonResourceBundle.getInstance().getString("message.EOF"));
        }
        this._octetBufferOffset = 0;
        return this._octetBuffer[1] & 0xFF;
    }

    protected final boolean _isFastInfosetDocument() throws IOException {
        this.peek();
        this._octetBufferLength = EncodingConstants.BINARY_HEADER.length;
        this.ensureOctetBufferSize();
        this._octetBufferOffset += this._octetBufferLength;
        if (this._octetBuffer[0] != EncodingConstants.BINARY_HEADER[0] || this._octetBuffer[1] != EncodingConstants.BINARY_HEADER[1] || this._octetBuffer[2] != EncodingConstants.BINARY_HEADER[2] || this._octetBuffer[3] != EncodingConstants.BINARY_HEADER[3]) {
            for (int i = 0; i < EncodingConstants.XML_DECLARATION_VALUES.length; ++i) {
                this._octetBufferLength = EncodingConstants.XML_DECLARATION_VALUES[i].length - this._octetBufferOffset;
                this.ensureOctetBufferSize();
                this._octetBufferOffset += this._octetBufferLength;
                if (!this.arrayEquals(this._octetBuffer, 0, EncodingConstants.XML_DECLARATION_VALUES[i], EncodingConstants.XML_DECLARATION_VALUES[i].length)) continue;
                this._octetBufferLength = EncodingConstants.BINARY_HEADER.length;
                this.ensureOctetBufferSize();
                return this._octetBuffer[this._octetBufferOffset++] == EncodingConstants.BINARY_HEADER[0] && this._octetBuffer[this._octetBufferOffset++] == EncodingConstants.BINARY_HEADER[1] && this._octetBuffer[this._octetBufferOffset++] == EncodingConstants.BINARY_HEADER[2] && this._octetBuffer[this._octetBufferOffset++] == EncodingConstants.BINARY_HEADER[3];
            }
            return false;
        }
        return true;
    }

    private boolean arrayEquals(byte[] byArray, int n, byte[] byArray2, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isFastInfosetDocument(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        return byArray[0] == EncodingConstants.BINARY_HEADER[0] && byArray[1] == EncodingConstants.BINARY_HEADER[1] && byArray[2] == EncodingConstants.BINARY_HEADER[2] && byArray[3] == EncodingConstants.BINARY_HEADER[3];
    }

    static {
        String string = System.getProperty(STRING_INTERNING_SYSTEM_PROPERTY, Boolean.toString(_stringInterningSystemDefault));
        _stringInterningSystemDefault = Boolean.valueOf(string);
        string = System.getProperty(BUFFER_SIZE_SYSTEM_PROPERTY, Integer.toString(_bufferSizeSystemDefault));
        try {
            int n = Integer.valueOf(string);
            if (n > 0) {
                _bufferSizeSystemDefault = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected class EncodingAlgorithmInputStream
    extends InputStream {
        protected EncodingAlgorithmInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (Decoder.this._octetBufferStart < Decoder.this._octetBufferOffset) {
                return Decoder.this._octetBuffer[Decoder.this._octetBufferStart++] & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n3 = Decoder.this._octetBufferStart + n2;
            if (n3 < Decoder.this._octetBufferOffset) {
                System.arraycopy(Decoder.this._octetBuffer, Decoder.this._octetBufferStart, byArray, n, n2);
                Decoder.this._octetBufferStart = n3;
                return n2;
            }
            if (Decoder.this._octetBufferStart < Decoder.this._octetBufferOffset) {
                int n4 = Decoder.this._octetBufferOffset - Decoder.this._octetBufferStart;
                System.arraycopy(Decoder.this._octetBuffer, Decoder.this._octetBufferStart, byArray, n, n4);
                Decoder.this._octetBufferStart += n4;
                return n4;
            }
            return -1;
        }
    }
}

