/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.DeployCacheHandler;
import com.sun.deploy.cache.DeployCacheJarAccessImpl;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.model.DeployCacheJarAccess;
import com.sun.deploy.model.DownloadDelegate;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.FailedDownloadException;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.UpdateTracker;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;

public class ResourceProviderImpl
extends ResourceProvider {
    static void init() {
        if (instance == null) {
            ResourceProviderImpl.set(new ResourceProviderImpl());
        }
    }

    public void setBackgroundUpdateRequest(boolean bl) {
        DownloadEngine._setBackgroundUpdateRequest(bl);
    }

    public boolean isBackgroundUpdateRequest() {
        return DownloadEngine.isBackgroundUpdateRequest();
    }

    public int incrementInternalUse() {
        return DownloadEngine._incrementInternalUse();
    }

    public void decrementInternalUse(int n) {
        DownloadEngine._decrementInternalUse(n);
    }

    public boolean isUpdateAvailable(URL uRL, String string, int n, Map map) throws IOException {
        if (UpdateTracker.isUpdated(uRL.toString())) {
            return false;
        }
        URL uRL2 = HttpUtils.removeQueryStringFromURL(uRL);
        if (!DownloadEngine.isBackgroundUpdateRequest() && ResourceProviderImpl.isInBackgroundUpdateCheckList(uRL)) {
            return false;
        }
        CacheEntry cacheEntry = null;
        if (Cache.isCacheEnabled()) {
            cacheEntry = Cache.getCacheEntry(string == null ? uRL : uRL2, string);
        }
        if (cacheEntry == null) {
            return true;
        }
        if (string != null) {
            return false;
        }
        if (!this.isValidationRequired(cacheEntry)) {
            return false;
        }
        return this.checkUpdateAvailable(uRL, cacheEntry, n, map);
    }

    public boolean checkUpdateAvailable(URL uRL, Resource resource, int n, Map map) throws IOException {
        String string = resource.getVersion();
        if (!DeployOfflineManager.promptUserGoOnline(uRL)) {
            throw new FailedDownloadException(uRL, null, null, true);
        }
        if (DeployOfflineManager.isGlobalOffline()) {
            throw new FailedDownloadException(uRL, null, null, true);
        }
        URL uRL2 = DownloadEngine.getRequestURL(uRL, string, null, false, null);
        HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
        HttpResponse httpResponse = null;
        long l = -1L;
        l = resource.getLastModified();
        URL uRL3 = null;
        if (DownloadEngine.isPackContentType(n)) {
            uRL3 = URLUtil.getPack200URL(uRL2, false);
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (map != null) {
            stringArray = map.keySet().toArray(new String[0]);
            stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Object v = map.get(stringArray[i]);
                if (v == null || !(v instanceof List)) continue;
                stringArray2[i] = (String)((List)v).get(0);
            }
        }
        try {
            httpResponse = httpRequest.doGetRequestEX(uRL3 != null ? uRL3 : uRL2, stringArray, stringArray2, l);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (uRL3 == null) {
                throw fileNotFoundException;
            }
            httpResponse = httpRequest.doGetRequestEX(uRL2, l);
        }
        if (httpResponse == null) {
            return true;
        }
        int n2 = httpResponse.getStatusCode();
        httpResponse.disconnect();
        boolean bl = true;
        if (n2 == 304) {
            bl = false;
        } else if (n2 == 200) {
            int n3 = httpResponse.getContentLength();
            long l2 = httpResponse.getLastModified();
            if (l2 == l && n3 == resource.getContentLength()) {
                bl = false;
            }
            Trace.println("CacheEntry[" + uRL + "]: updateAvailable=" + bl + ",lastModified=" + new Date(l) + ",length=" + resource.getContentLength(), TraceLevel.DEFAULT);
        }
        if (!bl) {
            UpdateTracker.checkDone(uRL.toString());
            long l3 = httpResponse.getExpiration();
            if (l3 != 0L && resource instanceof CacheEntry) {
                ((CacheEntry)resource).updateExpirationInIndexFile(l3);
            }
        }
        return bl;
    }

    public Resource getResource(URL uRL, String string, boolean bl, int n, DownloadDelegate downloadDelegate) throws IOException {
        if (!Cache.isCacheEnabled() && (n == 0 || DownloadEngine.isJarContentType(n))) {
            return this.getJarResourceWithoutCache(uRL, string, bl, n, downloadDelegate);
        }
        return this.getResourceCacheEntry(uRL, string, bl, n, downloadDelegate);
    }

    private CacheEntry getResourceCacheEntry(URL uRL, String string, boolean bl, int n, DownloadDelegate downloadDelegate) throws IOException {
        return this.getResourceCacheEntry(uRL, string, bl, n, downloadDelegate, false, null);
    }

    private CacheEntry getResourceCacheEntry(URL uRL, String string, boolean bl, int n, DownloadDelegate downloadDelegate, boolean bl2, String string2) throws IOException {
        boolean bl3;
        if (!Cache.isCacheEnabled() && !bl || uRL == null) {
            return null;
        }
        CacheEntry cacheEntry = null;
        boolean bl4 = bl3 = !Cache.isCacheEnabled() || bl && this.isUpdateAvailable(uRL, string, n, null);
        if (!bl3 && (cacheEntry = (CacheEntry)MemoryCache.getLoadedResource(uRL.toString())) != null && cacheEntry.matchesVersionString(string, true)) {
            return cacheEntry;
        }
        if (Cache.isCacheEnabled()) {
            cacheEntry = Cache.getCacheEntry(uRL, string, n);
        }
        if (bl && (cacheEntry == null || this.isValidationRequired(cacheEntry))) {
            Environment.setDownloadInitiated(true);
            cacheEntry = Cache.isCacheEnabled() ? DownloadEngine._downloadCacheEntry(cacheEntry, uRL, string, downloadDelegate, bl2, string2, n, true) : DownloadEngine._downloadCacheEntry(null, uRL, string, downloadDelegate, bl2, string2, n, false);
            if (cacheEntry != null) {
                Trace.println("Downloaded " + uRL + ": " + cacheEntry.getResourceFilename(), TraceLevel.NETWORK);
                MemoryCache.addLoadedResource(uRL.toString(), cacheEntry);
            }
            if (cacheEntry != null && Cache.isCacheEnabled()) {
                Cache.touch(new File(cacheEntry.getResourceFilename() + Cache.getIndexFileExtension()));
            }
        }
        return cacheEntry;
    }

    public Resource downloadUpdate(URL uRL, String string, int n, boolean bl) throws IOException {
        return DownloadEngine._downloadCacheEntry(null, uRL, string, null, false, null, n, bl);
    }

    public void markReady(Resource[] resourceArray) throws IOException {
        for (int i = 0; i < resourceArray.length; ++i) {
            if (!(resourceArray[i] instanceof CacheEntry)) continue;
            CacheEntry cacheEntry = (CacheEntry)resourceArray[i];
            URL uRL = new URL(cacheEntry.getURL());
            CacheEntry cacheEntry2 = Cache.getCacheEntry(uRL, cacheEntry.getVersion());
            Cache.processNewCacheEntry(uRL, true, cacheEntry, cacheEntry2);
        }
    }

    public boolean isResourceCached(URL uRL, String string, int n) throws IOException {
        return this.getResourceCacheEntry(uRL, string, false, n, null) != null;
    }

    private boolean isValidationRequired(CacheEntry cacheEntry) {
        if (cacheEntry == null) {
            return true;
        }
        boolean bl = true;
        if (!cacheEntry.isExpired()) {
            bl = false;
        } else if (Trace.isEnabled(TraceLevel.CACHE)) {
            Trace.println("Resource " + cacheEntry.getURL() + " has expired.", TraceLevel.CACHE);
        }
        if (cacheEntry.isHttpNoCacheEnabled()) {
            bl = true;
            if (Trace.isEnabled(TraceLevel.CACHE)) {
                Trace.println("Resource " + cacheEntry.getURL() + " has cache control: no-cache.", TraceLevel.CACHE);
            }
        }
        return bl;
    }

    public Resource getJreResource(URL uRL, String string, boolean bl, boolean bl2, String string2) throws IOException {
        return this.getResourceCacheEntry(uRL, string, bl, 1, null, bl2, string2);
    }

    public void markRetired(Resource resource, boolean bl) {
        if (!(resource instanceof CacheEntry)) {
            return;
        }
        CacheEntry cacheEntry = (CacheEntry)resource;
        if (bl) {
            Cache.removeCacheEntry(cacheEntry);
        } else {
            Cache.markResourceIncomplete(cacheEntry);
        }
    }

    public File getShortcutImage(URL uRL, String string, boolean bl) throws IOException {
        CacheEntry cacheEntry = this.getResourceCacheEntry(uRL, string, bl, 1, null);
        if (cacheEntry != null) {
            cacheEntry.generateShortcutImage();
            return cacheEntry.getDataFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLibraryDirForJar(String string, URL uRL, String string2) throws IOException {
        int n = ResourceProvider.get().incrementInternalUse();
        try {
            File file;
            Resource resource = this.getCachedResource(uRL, string2);
            if (resource == null) {
                resource = this.getResource(uRL, string2, true, 272, null);
            }
            File file2 = file = resource != null ? resource.getDataFile() : null;
            if (file != null) {
                String string3 = file.getPath() + "-n";
                File file3 = new File(string3, string);
                Trace.println("Looking up native library in: " + file3, TraceLevel.CACHE);
                if (file3.exists()) {
                    String string4 = string3;
                    return string4;
                }
            }
        }
        finally {
            ResourceProvider.get().decrementInternalUse(n);
        }
        return null;
    }

    public Resource getSystemResource(URL uRL, String string) {
        return Cache.getSystemCacheEntry(uRL, string);
    }

    public void preverifyCachedJar(URL uRL, String string, URLClassLoader uRLClassLoader) {
        Resource resource = this.getSystemResource(uRL, string);
        if (!(resource instanceof CacheEntry)) {
            return;
        }
        CacheEntry cacheEntry = (CacheEntry)resource;
        if (cacheEntry.getClassesVerificationStatus() == 0) {
            cacheEntry.verifyJAR(uRLClassLoader);
        }
    }

    private Resource getJarResourceWithoutCache(final URL uRL, final String string, boolean bl, int n, DownloadDelegate downloadDelegate) throws IOException {
        final JarFile jarFile = this.getTemporaryJarFile(uRL, string, bl, n, downloadDelegate);
        if (jarFile == null) {
            return null;
        }
        final long l = System.currentTimeMillis();
        return new Resource(){

            public String getURL() {
                return uRL.toString();
            }

            public String getVersion() {
                return string;
            }

            public long getLastModified() {
                return 0L;
            }

            public long getExpirationDate() {
                return 0L;
            }

            public int getContentLength() {
                return 0;
            }

            public Map getHeaders() {
                return null;
            }

            public long getSize() {
                final File file = new File(jarFile.getName());
                Long l2 = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return SystemUtils.longValueOf(file.length());
                    }
                });
                return l2;
            }

            public File getDataFile() {
                return new File(jarFile.getName());
            }

            public int getState() {
                return 1;
            }

            public JarFile getJarFile() {
                return jarFile;
            }

            public long getValidationTimestamp() {
                return l;
            }

            public boolean isKnownToBeSigned() {
                return false;
            }

            public String getResourceFilename() {
                return jarFile.getName();
            }

            public boolean isJNLPFile() {
                return false;
            }

            public boolean isJarFile() {
                return true;
            }

            public void updateValidationResults(boolean bl, Map map, long l3, long l2, boolean bl2) {
            }

            public CodeSigner[] getCodeSigners() {
                return new CodeSigner[0];
            }

            public Certificate[] getCertificates() {
                return new Certificate[0];
            }

            public Map getCachedTrustedEntries() {
                return Collections.EMPTY_MAP;
            }

            public byte getClassesVerificationStatus() {
                return 0;
            }
        };
    }

    private JarFile getTemporaryJarFile(URL uRL, String string, boolean bl, int n, DownloadDelegate downloadDelegate) throws IOException {
        Object object = MemoryCache.getLoadedResource(uRL.toString());
        if (object != null && object instanceof JarFile) {
            return (JarFile)object;
        }
        JarFile jarFile = DownloadEngine.getTemporaryJarFile(uRL, string, bl, n, downloadDelegate);
        if (jarFile != null) {
            MemoryCache.addLoadedResource(uRL.toString(), jarFile);
            return jarFile;
        }
        return null;
    }

    public boolean isInternalUse() {
        return DownloadEngine.isInternalUse();
    }

    public void decrementsInternalUse(int n) {
        DownloadEngine._decrementInternalUse(n);
    }

    public LocalApplicationProperties getLocalApplicationProperties(URL uRL, String string, boolean bl) {
        return Cache.getLocalApplicationProperties(uRL, string, bl);
    }

    public boolean canCache(URL uRL) {
        if (uRL == null) {
            return Cache.isCacheEnabled();
        }
        if (Cache.isCacheEnabled() && Cache.isSupportedProtocol(uRL)) {
            try {
                boolean bl = DeployCacheHandler.resourceNotCached(uRL.toString());
                return !bl;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public File getCacheDir() {
        return Cache.getCacheDir();
    }

    public String getCurrentVersion(URL uRL) {
        return Cache.getCacheEntryVersion(uRL);
    }

    public ResourceObject getResourceObject(String string) {
        String string2 = string + ".idx";
        File file = new File(string2);
        final CacheEntry cacheEntry = Cache.getCacheEntryFromFileIncludeTempJNLP(file);
        if (cacheEntry == null) {
            return null;
        }
        if (!cacheEntry.isJNLPFile() && cacheEntry.getJarFile() instanceof ResourceObject) {
            return (ResourceObject)((Object)cacheEntry.getJarFile());
        }
        return new ResourceObject(){

            public Object clone() throws CloneNotSupportedException {
                return super.clone();
            }

            public URL getResourceURL() {
                try {
                    return new URL(cacheEntry.getURL());
                }
                catch (MalformedURLException malformedURLException) {
                    Trace.ignored(malformedURLException);
                    return null;
                }
            }

            public String getResourceVersion() {
                return cacheEntry.getVersion();
            }

            public void doClose() throws IOException {
                this.close();
            }

            public void close() throws IOException {
            }
        };
    }

    public DeployCacheJarAccess getJarAccess() {
        return DeployCacheJarAccessImpl.getJarAccess();
    }

    public boolean hasEnhancedJarAccess() {
        return CacheEntry.hasEnhancedJarAccess();
    }

    public String getCachedResourceFilePath(URL uRL, String string) throws IOException {
        return Cache.getCachedResourceFilePath(uRL, string);
    }
}

