/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.ui.model.CategoryElement;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElementWrapper;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQueryable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryElementWrapper
extends QueriedElementWrapper {
    private Set<String> referredIUs = new HashSet<String>();

    public CategoryElementWrapper(IQueryable<?> queryable, Object parent) {
        super(queryable, parent);
    }

    @Override
    protected boolean shouldWrap(Object match) {
        if (match instanceof IInstallableUnit) {
            IInstallableUnit iu = (IInstallableUnit)match;
            Collection requirements = iu.getRequirements();
            for (IRequirement requirement : requirements) {
                if (!(requirement instanceof IRequiredCapability) || !((IRequiredCapability)requirement).getNamespace().equals("org.eclipse.equinox.p2.iu")) continue;
                this.referredIUs.add(((IRequiredCapability)requirement).getName());
            }
            for (CategoryElement element : super.getCollection()) {
                if (!element.shouldMerge(iu)) continue;
                element.mergeIU(iu);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Collection<?> getElements(Collector<?> collector) {
        if (collector.isEmpty()) {
            return super.getElements(collector);
        }
        Collection<?> results = super.getElements(collector);
        this.cleanList();
        return results;
    }

    @Override
    protected Object wrap(Object item) {
        IInstallableUnit iu = (IInstallableUnit)item;
        return super.wrap(new CategoryElement(this.parent, iu));
    }

    private void cleanList() {
        this.removeNestedCategories();
    }

    private void removeNestedCategories() {
        CategoryElement[] categoryIUs = this.getCollection().toArray(new CategoryElement[this.getCollection().size()]);
        int i = 0;
        while (i < categoryIUs.length) {
            if (this.referredIUs.contains(categoryIUs[i].getIU().getId())) {
                this.getCollection().remove(categoryIUs[i]);
            }
            ++i;
        }
    }
}

