/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.TouchImpl;

public class TouchListImpl {
    protected final long contextPeer;
    protected final long rootPeer;
    protected final long peer;

    TouchListImpl(long peer, long contextPeer, long rootPeer) {
        this.peer = peer;
        this.contextPeer = contextPeer;
        this.rootPeer = rootPeer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static TouchListImpl create(long peer, long contextPeer, long rootPeer) {
        if (peer == 0L) {
            return null;
        }
        return new TouchListImpl(peer, contextPeer, rootPeer);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(TouchListImpl arg) {
        return arg == null ? 0L : arg.getPeer();
    }

    public boolean equals(Object that) {
        return that instanceof TouchListImpl && this.peer == ((TouchListImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    static TouchListImpl getImpl(long peer, long contextPeer, long rootPeer) {
        return TouchListImpl.create(peer, contextPeer, rootPeer);
    }

    public int getLength() {
        return TouchListImpl.getLengthImpl(this.getPeer());
    }

    static native int getLengthImpl(long var0);

    public TouchImpl item(int index) {
        return TouchImpl.getImpl(TouchListImpl.itemImpl(this.getPeer(), index), this.contextPeer, this.rootPeer);
    }

    static native long itemImpl(long var0, int var2);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            TouchListImpl.dispose(this.peer);
        }
    }
}

