/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.ClipboardAssistance;
import com.sun.javafx.embed.EmbeddedSceneDragSourceInterface;
import com.sun.javafx.tk.quantum.EmbeddedSceneDnD;
import com.sun.javafx.tk.quantum.FxEventLoop;
import com.sun.javafx.tk.quantum.GlassSceneDnDEventHandler;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Callable;
import javafx.scene.input.TransferMode;

final class EmbeddedSceneDragSource
implements EmbeddedSceneDragSourceInterface {
    private final EmbeddedSceneDnD dnd;
    private final GlassSceneDnDEventHandler dndHandler;

    public EmbeddedSceneDragSource(EmbeddedSceneDnD embeddedSceneDnD, GlassSceneDnDEventHandler glassSceneDnDEventHandler) {
        this.dnd = embeddedSceneDnD;
        this.dndHandler = glassSceneDnDEventHandler;
    }

    private ClipboardAssistance getClipboardAssistance() {
        assert (this.dnd.isValid(this));
        return this.dnd.getClipboardAssistance(this);
    }

    @Override
    public Set<TransferMode> getSupportedActions() {
        assert (this.dnd.isHostThread());
        return FxEventLoop.sendEvent(new Callable<Set<TransferMode>>(){

            @Override
            public Set<TransferMode> call() {
                return QuantumClipboard.clipboardActionsToTransferModes(EmbeddedSceneDragSource.this.getClipboardAssistance().getSupportedSourceActions());
            }
        });
    }

    @Override
    public Object getData(final String string) {
        assert (this.dnd.isHostThread());
        return FxEventLoop.sendEvent(new Callable(){

            public Object call() {
                return EmbeddedSceneDragSource.this.getClipboardAssistance().getData(string);
            }
        });
    }

    @Override
    public String[] getMimeTypes() {
        assert (this.dnd.isHostThread());
        return FxEventLoop.sendEvent(new Callable<String[]>(){

            @Override
            public String[] call() {
                return EmbeddedSceneDragSource.this.getClipboardAssistance().getMimeTypes();
            }
        });
    }

    @Override
    public boolean isMimeTypeAvailable(final String string) {
        assert (this.dnd.isHostThread());
        return FxEventLoop.sendEvent(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return Arrays.asList(EmbeddedSceneDragSource.this.getClipboardAssistance().getMimeTypes()).contains(string);
            }
        });
    }

    @Override
    public void dragDropEnd(final TransferMode transferMode) {
        assert (this.dnd.isHostThread());
        FxEventLoop.sendEvent(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    EmbeddedSceneDragSource.this.dndHandler.handleDragEnd(transferMode, EmbeddedSceneDragSource.this.getClipboardAssistance());
                }
                finally {
                    EmbeddedSceneDragSource.this.dnd.onDragSourceReleased(EmbeddedSceneDragSource.this);
                }
            }
        });
    }
}

