/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.BoxBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.sg.BaseCacheFilter;
import com.sun.javafx.sg.BaseEffectFilter;
import com.sun.javafx.sg.DirtyRegionContainer;
import com.sun.javafx.sg.DirtyRegionPool;
import com.sun.javafx.sg.PGGroup;
import com.sun.javafx.sg.PGNode;
import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.Effect;
import java.util.List;

public abstract class BaseNode<G>
implements PGNode {
    public boolean debug = false;
    protected static final BaseBounds TEMP_BOUNDS = new BoxBounds();
    private static boolean CLEAR_DIRTY = true;
    private BaseTransform transform = BaseTransform.IDENTITY_TRANSFORM;
    protected BaseBounds transformedBounds = new RectBounds();
    private BaseBounds contentBounds = new RectBounds();
    private BaseBounds dirtyBounds = new RectBounds();
    private boolean visible = true;
    protected boolean dirty = true;
    private BaseNode parent;
    private boolean isClip;
    private BaseNode clipNode;
    private float opacity = 1.0f;
    private Blend.Mode nodeBlendMode;
    private boolean depthTest = true;
    private BaseCacheFilter cacheFilter;
    private BaseEffectFilter effectFilter;
    protected boolean childDirty = false;
    protected int dirtyChildrenAccumulated = 0;
    protected static final int DIRTY_CHILDREN_ACCUMULATED_THRESHOLD = 12;
    protected int cullingBits = 0;

    @Override
    public void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.markDirty();
        }
    }

    @Override
    public void setContentBounds(BaseBounds baseBounds) {
        this.contentBounds = this.contentBounds.deriveWithNewBounds(baseBounds);
    }

    @Override
    public void setTransformedBounds(BaseBounds baseBounds) {
        if (this.transformedBounds.equals(baseBounds)) {
            return;
        }
        if (this.dirtyBounds.isEmpty()) {
            this.dirtyBounds = this.dirtyBounds.deriveWithNewBounds(this.transformedBounds);
            this.dirtyBounds = this.dirtyBounds.deriveWithUnion(baseBounds);
        } else {
            this.dirtyBounds = this.dirtyBounds.deriveWithUnion(this.transformedBounds);
        }
        this.transformedBounds = this.transformedBounds.deriveWithNewBounds(baseBounds);
        if (this.hasVisuals()) {
            this.markDirty();
        }
    }

    @Override
    public void setTransformMatrix(BaseTransform baseTransform) {
        this.transform = this.transform.deriveWithNewTransform(baseTransform);
        this.markDirty();
    }

    @Override
    public void setClipNode(PGNode pGNode) {
        BaseNode baseNode = (BaseNode)pGNode;
        if (baseNode != this.clipNode) {
            if (this.clipNode != null) {
                this.clipNode.setParent(null);
            }
            if (baseNode != null) {
                baseNode.setParent(this, true);
            }
            this.clipNode = baseNode;
            this.visualsChanged();
        }
    }

    @Override
    public void setOpacity(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Internal Error: The opacity must be between 0 and 1");
        }
        if (f != this.opacity) {
            this.opacity = f;
            this.markDirty();
        }
    }

    @Override
    public void setNodeBlendMode(Blend.Mode mode) {
        if (this.nodeBlendMode != mode) {
            this.nodeBlendMode = mode;
            this.markDirty();
        }
    }

    @Override
    public void setDepthTest(boolean bl) {
        if (bl != this.depthTest) {
            this.depthTest = bl;
            this.visualsChanged();
        }
    }

    @Override
    public void setCachedAsBitmap(boolean bl, PGNode.CacheHint cacheHint) {
        if (cacheHint == null) {
            throw new IllegalArgumentException("Internal Error: cacheHint must not be null");
        }
        if (bl) {
            if (this.cacheFilter == null) {
                this.cacheFilter = this.createCacheFilter(this, cacheHint);
                this.markDirty();
            } else if (!this.cacheFilter.matchesHint(cacheHint)) {
                this.cacheFilter.setHint(cacheHint);
                this.markDirty();
            }
        } else if (this.cacheFilter != null) {
            this.cacheFilter.dispose();
            this.cacheFilter = null;
            this.markDirty();
        }
    }

    @Override
    public void setEffect(Object object) {
        if (this.effectFilter == null && object != null) {
            this.effectFilter = this.createEffectFilter((Effect)object);
            this.visualsChanged();
        } else if (this.effectFilter != null && this.effectFilter.getEffect() != object) {
            this.effectFilter.dispose();
            this.effectFilter = null;
            if (object != null) {
                this.effectFilter = this.createEffectFilter((Effect)object);
            }
            this.visualsChanged();
        }
    }

    @Override
    public void effectChanged() {
        this.visualsChanged();
    }

    public boolean isContentBounds2D() {
        return this.contentBounds.is2D() || Affine3D.almostZero(this.contentBounds.getMaxZ()) && Affine3D.almostZero(this.contentBounds.getMinZ());
    }

    public BaseNode getParent() {
        return this.parent;
    }

    public void setParent(BaseNode baseNode) {
        this.setParent(baseNode, false);
    }

    private void setParent(BaseNode baseNode, boolean bl) {
        this.parent = baseNode;
        this.isClip = bl;
    }

    protected final Effect getEffect() {
        return this.effectFilter == null ? null : this.effectFilter.getEffect();
    }

    public final BaseTransform getTransform() {
        return this.transform;
    }

    public final float getOpacity() {
        return this.opacity;
    }

    public final Blend.Mode getNodeBlendMode() {
        return this.nodeBlendMode;
    }

    public final boolean isDepthTest() {
        return this.depthTest;
    }

    public final BaseCacheFilter getCacheFilter() {
        return this.cacheFilter;
    }

    public final BaseEffectFilter getEffectFilter() {
        return this.effectFilter;
    }

    public final BaseNode getClipNode() {
        return this.clipNode;
    }

    public BaseBounds getContentBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (baseTransform.isTranslateOrIdentity()) {
            baseBounds = baseBounds.deriveWithNewBounds(this.contentBounds);
            if (!baseTransform.isIdentity()) {
                float f = (float)baseTransform.getMxt();
                float f2 = (float)baseTransform.getMyt();
                float f3 = (float)baseTransform.getMzt();
                baseBounds = baseBounds.deriveWithNewBounds(baseBounds.getMinX() + f, baseBounds.getMinY() + f2, baseBounds.getMinZ() + f3, baseBounds.getMaxX() + f, baseBounds.getMaxY() + f2, baseBounds.getMaxZ() + f3);
            }
            return baseBounds;
        }
        return this.computeBounds(baseBounds, baseTransform);
    }

    private BaseBounds computeBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        baseBounds = baseBounds.deriveWithNewBounds(this.contentBounds);
        return baseTransform.transform(this.contentBounds, baseBounds);
    }

    public final BaseBounds getClippedBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        BaseBounds baseBounds2 = this.getEffectBounds(baseBounds, baseTransform);
        if (this.clipNode != null) {
            float f = baseBounds2.getMinX();
            float f2 = baseBounds2.getMinY();
            float f3 = baseBounds2.getMinZ();
            float f4 = baseBounds2.getMaxX();
            float f5 = baseBounds2.getMaxY();
            float f6 = baseBounds2.getMaxZ();
            baseBounds2 = this.clipNode.getCompleteBounds(baseBounds2, baseTransform);
            baseBounds2.intersectWith(f, f2, f3, f4, f5, f6);
        }
        return baseBounds2;
    }

    public final BaseBounds getEffectBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (this.effectFilter != null) {
            return this.effectFilter.getBounds(baseBounds, baseTransform);
        }
        return this.getContentBounds(baseBounds, baseTransform);
    }

    public final BaseBounds getCompleteBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (baseTransform.isIdentity()) {
            baseBounds = baseBounds.deriveWithNewBounds(this.transformedBounds);
            return baseBounds;
        }
        if (this.transform.isIdentity()) {
            return this.getClippedBounds(baseBounds, baseTransform);
        }
        double d = baseTransform.getMxx();
        double d2 = baseTransform.getMxy();
        double d3 = baseTransform.getMxz();
        double d4 = baseTransform.getMxt();
        double d5 = baseTransform.getMyx();
        double d6 = baseTransform.getMyy();
        double d7 = baseTransform.getMyz();
        double d8 = baseTransform.getMyt();
        double d9 = baseTransform.getMzx();
        double d10 = baseTransform.getMzy();
        double d11 = baseTransform.getMzz();
        double d12 = baseTransform.getMzt();
        BaseTransform baseTransform2 = baseTransform.deriveWithConcatenation(this.transform);
        baseBounds = this.getClippedBounds(baseBounds, baseTransform);
        if (baseTransform2 == baseTransform) {
            baseTransform.restoreTransform(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
        }
        return baseBounds;
    }

    protected void visualsChanged() {
        this.invalidateCache();
        this.markDirty();
    }

    protected void geometryChanged() {
        this.invalidateCache();
        if (this.hasVisuals()) {
            this.markDirty();
        }
    }

    public void markDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.markTreeDirty();
        }
    }

    protected final void markTreeDirtyNoIncrement() {
        if (this.parent != null && !this.parent.childDirty) {
            this.markTreeDirty();
        }
    }

    protected void markTreeDirty() {
        BaseNode baseNode = this.parent;
        boolean bl = this.isClip;
        while (!(baseNode == null || baseNode.dirty || baseNode.childDirty && !bl)) {
            if (bl) {
                baseNode.dirty = true;
            } else {
                baseNode.childDirty = true;
                ++baseNode.dirtyChildrenAccumulated;
            }
            baseNode.invalidateCache();
            bl = baseNode.isClip;
            baseNode = baseNode.parent;
        }
        if (baseNode != null && !baseNode.dirty && !bl) {
            ++baseNode.dirtyChildrenAccumulated;
        }
        if (baseNode != null) {
            baseNode.invalidateCache();
        }
    }

    protected void clearDirty() {
        this.dirty = false;
        this.childDirty = false;
        this.dirtyBounds.makeEmpty();
        this.dirtyChildrenAccumulated = 0;
    }

    public void clearDirtyTree() {
        this.clearDirty();
        if (this.getClipNode() != null) {
            this.getClipNode().clearDirtyTree();
        }
        if (this instanceof PGGroup) {
            List<PGNode> list = ((PGGroup)((Object)this)).getChildren();
            for (int i = 0; i < list.size(); ++i) {
                BaseNode baseNode = (BaseNode)list.get(i);
                if (!baseNode.dirty && !baseNode.childDirty) continue;
                baseNode.clearDirtyTree();
            }
        }
    }

    protected final void invalidateCache() {
        if (this.cacheFilter != null) {
            this.cacheFilter.invalidate();
        }
    }

    public int accumulateDirtyRegions(RectBounds rectBounds, RectBounds rectBounds2, DirtyRegionPool dirtyRegionPool, DirtyRegionContainer dirtyRegionContainer, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        if (!this.dirty && !this.childDirty) {
            return 1;
        }
        if (this.dirty) {
            return this.accumulateNodeDirtyRegion(rectBounds, rectBounds2, dirtyRegionContainer, baseTransform, generalTransform3D);
        }
        assert (this.childDirty);
        return this.accumulateGroupDirtyRegion(rectBounds, rectBounds2, dirtyRegionPool, dirtyRegionContainer, baseTransform, generalTransform3D);
    }

    protected int accumulateNodeDirtyRegion(RectBounds rectBounds, RectBounds rectBounds2, DirtyRegionContainer dirtyRegionContainer, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        BaseBounds baseBounds = this.computeDirtyRegion(rectBounds2, baseTransform, generalTransform3D);
        rectBounds2.setMinX(baseBounds.getMinX());
        rectBounds2.setMinY(baseBounds.getMinY());
        rectBounds2.setMaxX(baseBounds.getMaxX());
        rectBounds2.setMaxY(baseBounds.getMaxY());
        if (rectBounds2.isEmpty() || rectBounds.disjoint(rectBounds2)) {
            return 1;
        }
        RectBounds rectBounds3 = dirtyRegionContainer.addDirtyRegion(rectBounds2);
        assert (rectBounds3 != null);
        if (rectBounds3.getMinX() <= rectBounds.getMinX() && rectBounds3.getMinY() <= rectBounds.getMinY() && rectBounds3.getMaxX() >= rectBounds.getMaxX() && rectBounds3.getMaxY() >= rectBounds.getMaxY()) {
            return 0;
        }
        rectBounds3.setMinX(Math.max(rectBounds3.getMinX(), rectBounds.getMinX()));
        rectBounds3.setMinY(Math.max(rectBounds3.getMinY(), rectBounds.getMinY()));
        rectBounds3.setMaxX(Math.min(rectBounds3.getMaxX(), rectBounds.getMaxX()));
        rectBounds3.setMaxY(Math.min(rectBounds3.getMaxY(), rectBounds.getMaxY()));
        return 1;
    }

    protected int accumulateGroupDirtyRegion(RectBounds rectBounds, RectBounds rectBounds2, DirtyRegionPool dirtyRegionPool, DirtyRegionContainer dirtyRegionContainer, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        BaseNode baseNode;
        Object object;
        int n;
        Object object2;
        assert (this.childDirty);
        assert (!this.dirty);
        int n2 = 1;
        if (this.effectFilter != null) {
            return this.accumulateNodeDirtyRegion(rectBounds, rectBounds2, dirtyRegionContainer, baseTransform, generalTransform3D);
        }
        if (this.dirtyChildrenAccumulated > 12) {
            n2 = this.accumulateNodeDirtyRegion(rectBounds, rectBounds2, dirtyRegionContainer, baseTransform, generalTransform3D);
            return n2;
        }
        double d = baseTransform.getMxx();
        double d2 = baseTransform.getMxy();
        double d3 = baseTransform.getMxz();
        double d4 = baseTransform.getMxt();
        double d5 = baseTransform.getMyx();
        double d6 = baseTransform.getMyy();
        double d7 = baseTransform.getMyz();
        double d8 = baseTransform.getMyt();
        double d9 = baseTransform.getMzx();
        double d10 = baseTransform.getMzy();
        double d11 = baseTransform.getMzz();
        double d12 = baseTransform.getMzt();
        BaseTransform baseTransform2 = baseTransform;
        if (this.transform != null) {
            baseTransform2 = baseTransform2.deriveWithConcatenation(this.transform);
        }
        RectBounds rectBounds3 = rectBounds;
        DirtyRegionContainer dirtyRegionContainer2 = null;
        if (this.clipNode != null) {
            dirtyRegionContainer2 = dirtyRegionContainer;
            rectBounds3 = new RectBounds();
            object2 = this.clipNode.getCompleteBounds(rectBounds3, baseTransform2);
            generalTransform3D.transform((BaseBounds)object2, (BaseBounds)object2);
            rectBounds3.deriveWithNewBounds(((BaseBounds)object2).getMinX(), ((BaseBounds)object2).getMinY(), 0.0f, ((BaseBounds)object2).getMaxX(), ((BaseBounds)object2).getMaxY(), 0.0f);
            rectBounds3.intersectWith(rectBounds);
            dirtyRegionContainer = dirtyRegionPool.checkOut();
        }
        if ((object2 = ((PGGroup)((Object)this)).getRemovedChildren()) != null) {
            for (n = object2.size() - 1; n >= 0; --n) {
                object = (BaseNode)object2.get(n);
                ((BaseNode)object).dirty = true;
                n2 = ((BaseNode)object).accumulateDirtyRegions(rectBounds3, rectBounds2, dirtyRegionPool, dirtyRegionContainer, baseTransform2, generalTransform3D);
                if (n2 == 0) break;
            }
        }
        object = ((PGGroup)((Object)this)).getChildren();
        n = object.size();
        for (int i = 0; i < n && n2 == 1 && (n2 = (baseNode = (BaseNode)object.get(i)).accumulateDirtyRegions(rectBounds3, rectBounds2, dirtyRegionPool, dirtyRegionContainer, baseTransform2, generalTransform3D)) != 0; ++i) {
        }
        if (baseTransform2 == baseTransform) {
            baseTransform.restoreTransform(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
        }
        if (this.clipNode != null) {
            if (n2 == 0) {
                n2 = this.accumulateNodeDirtyRegion(rectBounds, rectBounds2, dirtyRegionContainer2, baseTransform, generalTransform3D);
            } else {
                dirtyRegionContainer2.merge(dirtyRegionContainer);
            }
            dirtyRegionPool.checkIn(dirtyRegionContainer);
        }
        return n2;
    }

    private BaseBounds computeDirtyRegion(BaseBounds baseBounds, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        baseBounds = !this.dirtyBounds.isEmpty() ? baseBounds.deriveWithNewBounds(this.dirtyBounds) : baseBounds.deriveWithNewBounds(this.transformedBounds);
        if (!baseBounds.isEmpty()) {
            baseBounds = baseBounds.deriveWithNewBounds(baseBounds.getMinX() - 1.0f, baseBounds.getMinY() - 1.0f, baseBounds.getMinZ(), baseBounds.getMaxX() + 1.0f, baseBounds.getMaxY() + 1.0f, baseBounds.getMaxZ());
            baseBounds = baseTransform.transform(baseBounds, baseBounds);
            baseBounds = generalTransform3D.transform(baseBounds, baseBounds);
        }
        return baseBounds;
    }

    protected boolean hasVisuals() {
        return true;
    }

    public void doPreCulling(DirtyRegionContainer dirtyRegionContainer, BaseTransform baseTransform, GeneralTransform3D generalTransform3D) {
        this.markCullRegions(dirtyRegionContainer, -1, baseTransform, generalTransform3D);
    }

    protected int setCullBits(BaseBounds baseBounds, int n, RectBounds rectBounds) {
        int n2 = 0;
        if (rectBounds != null && !rectBounds.isEmpty() && rectBounds.intersects(baseBounds)) {
            n2 = 1;
            if (rectBounds.contains(baseBounds.getMinX(), baseBounds.getMinY(), baseBounds.getWidth(), baseBounds.getHeight())) {
                n2 = 2;
            }
            this.cullingBits |= n2 << 2 * n;
        }
        return n2;
    }

    protected abstract void markCullRegions(DirtyRegionContainer var1, int var2, BaseTransform var3, GeneralTransform3D var4);

    public abstract void drawCullBits(G var1);

    public final void render(G g) {
        if (this.debug) {
            System.out.println("render called on " + this.getClass().getSimpleName());
        }
        if (CLEAR_DIRTY) {
            this.clearDirty();
        }
        if (!this.visible || this.opacity == 0.0f) {
            return;
        }
        this.doRender(g);
    }

    protected abstract void doRender(G var1);

    protected abstract BaseCacheFilter createCacheFilter(BaseNode var1, PGNode.CacheHint var2);

    protected abstract BaseEffectFilter createEffectFilter(Effect var1);
}

