/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.posizione;

import finanze.IDTE.studi2002.posizione.RigaTabellaControlli;
import finanze.IDTE.studi2002.risorse.RigaTabellaBeanModel;
import java.util.StringTokenizer;
import java.util.Vector;

public class SezioneTabella {
    private String record = null;
    private String nome = null;
    private String tipologiaReddito = null;
    private boolean quadroMultiplo;
    private RigaTabellaBeanModel[] righeBeansModel = null;
    private RigaTabellaControlli[] righeControlli = null;
    private SezioneTabella sezioneTabellaParteFissa = null;

    public SezioneTabella(String[] righe, int start, int end) {
        this.impostaIdentificativi(righe[start].substring(1, righe[start].length() - 1));
        this.quadroMultiplo = false;
        Vector<RigaTabellaBeanModel> tempBeanModel = new Vector<RigaTabellaBeanModel>();
        Vector<RigaTabellaControlli> tempControlli = new Vector<RigaTabellaControlli>();
        boolean flagControlli = false;
        int i = start + 1;
        while (i < end) {
            String riga = righe[i].trim();
            if (riga.equalsIgnoreCase("(NQ)")) {
                this.quadroMultiplo = true;
            } else if (riga.equalsIgnoreCase("(M)")) {
                flagControlli = false;
            } else if (riga.equals("-")) {
                flagControlli = true;
            } else {
                if (riga.equalsIgnoreCase("(F)")) {
                    this.sezioneTabellaParteFissa = new SezioneTabella(righe, i, end);
                    break;
                }
                if (flagControlli) {
                    tempControlli.addElement(new RigaTabellaControlli(riga));
                } else {
                    tempBeanModel.addElement(new RigaTabellaBeanModel(riga));
                }
            }
            ++i;
        }
        this.righeBeansModel = new RigaTabellaBeanModel[tempBeanModel.size()];
        tempBeanModel.copyInto(this.righeBeansModel);
        this.righeControlli = new RigaTabellaControlli[tempControlli.size()];
        tempControlli.copyInto(this.righeControlli);
    }

    public String getNome() {
        return this.nome;
    }

    public String getRecord() {
        return this.record;
    }

    public RigaTabellaBeanModel[] getRigheBeansModel() {
        return this.righeBeansModel;
    }

    public RigaTabellaControlli[] getRigheControlli() {
        return this.righeControlli;
    }

    public SezioneTabella getSezioneTabellaParteFissa() {
        return this.sezioneTabellaParteFissa;
    }

    public String getTipologiaReddito() {
        return this.tipologiaReddito;
    }

    public boolean hasControlli() {
        return this.righeControlli != null && this.righeControlli.length > 0;
    }

    public boolean hasParteFissa() {
        return this.sezioneTabellaParteFissa != null;
    }

    protected void impostaIdentificativi(String riga) {
        StringTokenizer st = new StringTokenizer(riga, "*");
        if (st.countTokens() == 1) {
            this.record = "T";
            this.nome = st.nextToken();
        } else if (st.countTokens() > 1) {
            this.record = st.nextToken();
            this.nome = st.nextToken();
        } else {
            this.nome = st.nextToken();
        }
        if (st.hasMoreElements()) {
            this.tipologiaReddito = st.nextToken();
        }
    }

    public boolean isQuadroMultiplo() {
        return this.quadroMultiplo;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[record=" + this.record + ", nome=" + this.nome + (this.tipologiaReddito != null ? this.tipologiaReddito : "") + "]";
    }
}

