/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.posizione;

import finanze.IDTE.studi2002.campi.AlfaNumericModel;
import finanze.IDTE.studi2002.campi.CodFiscModel;
import finanze.IDTE.studi2002.campi.ComboBoxModel;
import finanze.IDTE.studi2002.campi.ControlloFormaleException;
import finanze.IDTE.studi2002.campi.DefaultNumericModel;
import finanze.IDTE.studi2002.campi.GericoModel;
import finanze.IDTE.studi2002.campi.ListModel;
import finanze.IDTE.studi2002.campi.NonCoerenzaException;
import finanze.IDTE.studi2002.campi.RangeNumericModel;
import finanze.IDTE.studi2002.campi.ToggleButtonModel;
import finanze.IDTE.studi2002.campi.ValutaNumericModel;
import finanze.IDTE.studi2002.controlli.GericoControllo;
import finanze.IDTE.studi2002.generale.MetodiUtili;
import finanze.IDTE.studi2002.main.Anomalia;
import finanze.IDTE.studi2002.posizione.Chiave;
import finanze.IDTE.studi2002.posizione.ChiaveAnnotazione;
import finanze.IDTE.studi2002.posizione.GestioneQuadroMultiploModel;
import finanze.IDTE.studi2002.risorse.ModelloAnnotazioneSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class ModelloM
implements GestioneQuadroMultiploModel {
    private ChiaveAnnotazione chiave;
    private Vector controlli;
    private Vector campiErrati;
    private Vector vecTesta;
    private Vector controlliQM;
    private Vector specificheControlliQM;
    private Vector chiaviCampiPosizionali;
    private Vector chiaviCampiNonPosizionali;
    private Vector quadroMultiplo;
    private Vector vecMsgErrori;
    private Vector vecMsgWarning;
    private Vector warning;
    private Hashtable campi;
    private int numeroMaxQuadri;
    private String codiceNumeroQM;
    private Vector messaggioErrore;
    private StringBuffer messaggioErroreQM = null;
    private final int CODA_RECORD = 12;
    private final String RETURN = "\n";
    private final int LUNGHEZZA_TESTA = 100;
    private final int MODEL_CODE = 0;
    private final int MODEL_ERRORDESCRIPTION = 1;
    private final int MODEL_LENGTH = 2;
    public static final String CODE_FISCALE = "CodiceFiscale";
    public static final String CODE_MULTIPUNTO = "Multipunto";
    public static final String CODE_MULTIATTIVITA = "Multiattivita";
    public static final String CODE_PROGRESSIVO = "Progressivo";
    public static final String CODE_IMPRESA = "Impresa";
    public static final String VALUE_MULTIATTIVITA = "Multi Attivita'";
    public static final String VALUE_MULTIPUNTO = "Multi Punto";
    public static final String VALUE_MULTIPUNTO_MULTIATTIVITA = "Multi Punto / Multi Attivita'";
    public static final String CALCOLABILITA = "FlagCalcolabilita";
    private Vector vecMsgSalvataggio = null;
    private String nomeFile;

    public ModelloM(ChiaveAnnotazione chiaveStudio) {
        this.chiave = chiaveStudio;
        this.initialize();
        this.valorizzaBean(this.chiave);
    }

    private void aggiornaSpecificheControlliQM() {
        Vector specPrimoQM = (Vector)this.specificheControlliQM.firstElement();
        int i = 2;
        while (i < this.getNumeroMaxQuadri() + 1) {
            Vector<String> specificheCtrlQ = new Vector<String>();
            int k = 0;
            while (k < specPrimoQM.size()) {
                StringBuffer appo = new StringBuffer();
                StringTokenizer strTok = new StringTokenizer((String)specPrimoQM.elementAt(k), "%");
                String primaParte = strTok.nextToken();
                StringTokenizer strTok2 = new StringTokenizer(primaParte, "*");
                String tipoControllo = strTok2.nextToken();
                appo.append(tipoControllo);
                if (tipoControllo.equalsIgnoreCase("C2")) {
                    appo.append(this.creaSpecificaC2(primaParte, i));
                } else if (tipoControllo.equalsIgnoreCase("CVCS")) {
                    appo.append(this.creaSpecificaCVCS(strTok2, i));
                } else if (tipoControllo.equalsIgnoreCase("CCS")) {
                    appo.append(this.creaSpecificaCCS(strTok2, i));
                } else if (tipoControllo.equalsIgnoreCase("CT")) {
                    appo.append(this.creaSpecificaCT(primaParte, i));
                } else if (tipoControllo.equalsIgnoreCase("CE")) {
                    appo.append(this.creaSpecificaCE(strTok2, i));
                } else if (tipoControllo.equalsIgnoreCase("CR")) {
                    appo.append(this.creaSpecificaCR(strTok2, i));
                }
                appo.append("%");
                StringTokenizer strTok3 = new StringTokenizer(strTok.nextToken(), "&");
                appo.append(strTok3.nextToken()).append("&");
                while (strTok3.hasMoreTokens()) {
                    appo.append(strTok3.nextToken()).append("&");
                }
                specificheCtrlQ.addElement(appo.toString());
                ++k;
            }
            this.specificheControlliQM.addElement(specificheCtrlQ);
            ++i;
        }
    }

    private Vector aggiornaSpecificheControlliQN(Vector specificheControlli) {
        Vector<String[]> specificheAggiornate = new Vector<String[]>();
        int numQN = 0;
        int k = 0;
        int j = 0;
        while (j < specificheControlli.size()) {
            if (numQN > 0) {
                if (!((String[])specificheControlli.elementAt(j))[2].equalsIgnoreCase("M") && !((String[])specificheControlli.elementAt(j))[2].equalsIgnoreCase("NQ")) {
                    String nomeQuadro = ((String[])specificheControlli.elementAt(j))[1];
                    int i = 1;
                    while (i <= numQN) {
                        k = j;
                        while (k < specificheControlli.size()) {
                            StringBuffer appo = new StringBuffer();
                            String[] specificheCtrlQ = new String[3];
                            StringTokenizer strTok = new StringTokenizer(((String[])specificheControlli.elementAt(k))[0], "%");
                            String primaParte = strTok.nextToken();
                            StringTokenizer strTok2 = new StringTokenizer(primaParte, "*");
                            String tipoControllo = strTok2.nextToken();
                            appo.append(tipoControllo);
                            if (tipoControllo.equalsIgnoreCase("CE") || tipoControllo.equalsIgnoreCase("WPC") || tipoControllo.equalsIgnoreCase("WE") || tipoControllo.equalsIgnoreCase("CEPI")) {
                                appo.append(this.creaSpecificaCE(strTok2, i));
                            }
                            if (tipoControllo.equalsIgnoreCase("WT")) {
                                appo.append(this.creaSpecificaCT(primaParte, i));
                            }
                            if (tipoControllo.equalsIgnoreCase("CI")) {
                                appo.append("*").append(numQN);
                            }
                            if (tipoControllo.equalsIgnoreCase("CPU")) {
                                appo.append("*").append(numQN);
                            }
                            if (tipoControllo.equalsIgnoreCase("CPI")) {
                                appo.append(this.creaSpecificaCPI(primaParte, i));
                            }
                            if (tipoControllo.equalsIgnoreCase("WRP")) {
                                appo.append(this.creaSpecificaCRP(primaParte, i));
                            }
                            if (tipoControllo.equalsIgnoreCase("C2") || tipoControllo.equalsIgnoreCase("W2")) {
                                appo.append(this.creaSpecificaC2(primaParte, i));
                            }
                            appo.append("%").append(strTok.nextToken());
                            specificheCtrlQ[0] = appo.toString();
                            specificheCtrlQ[1] = String.valueOf(nomeQuadro) + " (" + String.valueOf(i) + ")";
                            specificheCtrlQ[2] = ((String[])specificheControlli.elementAt(k))[2];
                            specificheAggiornate.addElement(specificheCtrlQ);
                            ++k;
                        }
                        ++i;
                    }
                    j = k - 1;
                } else {
                    specificheAggiornate.addElement((String[])specificheControlli.elementAt(j));
                }
            } else if (((String[])specificheControlli.elementAt(j))[2].equalsIgnoreCase("M") || ((String[])specificheControlli.elementAt(j))[2].equalsIgnoreCase("NQ")) {
                specificheAggiornate.addElement((String[])specificheControlli.elementAt(j));
            }
            ++j;
        }
        return specificheAggiornate;
    }

    private boolean[] controllaValiditaCodice(String codice) {
        int i = 0;
        while (i < this.numeroMaxQuadri) {
            Vector vecCodici = this.getQuadroMultiplo(i, 2);
            int j = 0;
            while (j < vecCodici.size()) {
                if (vecCodici.elementAt(j).equals(codice)) {
                    if (i < this.getNumeroQuadriMultipli()) {
                        return new boolean[]{true, true};
                    }
                    return new boolean[]{false, true};
                }
                ++j;
            }
            ++i;
        }
        return new boolean[]{false, false};
    }

    /*
     * Unable to fully structure code
     */
    private void costruisciCampo(String[] specificaCampo) {
        block15: {
            try {
                gm = null;
                type = specificaCampo[0];
                spec_line = specificaCampo[1];
                specif_lineVet = new Vector<String>();
                strTok = new StringTokenizer(spec_line, "#");
                spec_block1 = strTok.nextToken();
                spec_block2 = strTok.hasMoreTokens() != false ? strTok.nextToken() : null;
                strTok = new StringTokenizer(spec_block1, "*");
                while (strTok.hasMoreTokens()) {
                    specif_lineVet.addElement(strTok.nextToken());
                }
                gm = this.creaBeanModel(type, specif_lineVet);
                if (spec_block2 != null) {
                    if (spec_block2.equalsIgnoreCase("O")) {
                        gm.setOnlyWrite(true);
                    } else {
                        MetodiUtili.logEccezioni(new Exception("Errore in tabella: blocco 2 della riga " + spec_line));
                    }
                }
                this.campi.put(gm.getCode(), gm);
                if (specificaCampo.length == 2) {
                    this.vecTesta.addElement(gm.getCode());
                } else if (specificaCampo.length == 3) {
                    if (specificaCampo[2].equalsIgnoreCase("Q") || specificaCampo[2].equalsIgnoreCase("R")) {
                        this.chiaviCampiPosizionali.addElement(gm.getCode());
                    } else if (specificaCampo[2].equalsIgnoreCase("Y") || specificaCampo[2].equalsIgnoreCase("Z")) {
                        this.chiaviCampiNonPosizionali.addElement(gm.getCode());
                    } else if (!specificaCampo[2].equalsIgnoreCase("M") && specificaCampo[2].equalsIgnoreCase("NQ")) {
                        this.codiceNumeroQM = gm.getCode();
                        this.chiaviCampiNonPosizionali.addElement(this.codiceNumeroQM);
                        this.numeroMaxQuadri = Integer.parseInt(this.estraiNumMaxQuadri(spec_line));
                    }
                }
                break block15;
            }
            catch (Exception ex) {
                System.out.print("Riga errata: ");
                i = 0;
                ** while (i < specificaCampo.length)
            }
lbl-1000:
            // 1 sources

            {
                System.out.print(String.valueOf(specificaCampo[i]) + "*");
                ++i;
                continue;
            }
lbl43:
            // 1 sources

            System.out.println(" ");
            MetodiUtili.logEccezioni(ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void costruisciControlli(Vector specificheControlli) {
        i = 0;
        while (i < specificheControlli.size()) {
            block13: {
                try {
                    spec_line = ((String[])specificheControlli.elementAt(i))[0];
                    nomeQuadroControllo = ((String[])specificheControlli.elementAt(i))[1];
                    strQuadroMultiplo = ((String[])specificheControlli.elementAt(i))[2];
                    gc = null;
                    try {
                        gc = GericoControllo.getIstanza((String[])specificheControlli.elementAt(i), this.campi);
                    }
                    catch (NonCoerenzaException nce) {
                        nce.printStackTrace();
                    }
                    if (gc == null) {
                        throw new Exception();
                    }
                    if (strQuadroMultiplo.equalsIgnoreCase("M") && this.controlliQM.isEmpty()) {
                        primoMultiplo = new Vector<E>();
                        this.controlliQM.addElement(primoMultiplo);
                        gc.setNomeQuadro(String.valueOf(nomeQuadroControllo) + " " + 1);
                        ((Vector)this.controlliQM.firstElement()).addElement(gc);
                        this.controlli.addElement(nomeQuadroControllo);
                        this.specificheControlliQM.addElement(new Vector<E>());
                        ((Vector)this.specificheControlliQM.firstElement()).addElement(spec_line);
                    } else if (strQuadroMultiplo.equalsIgnoreCase("M")) {
                        gc.setNomeQuadro(String.valueOf(nomeQuadroControllo) + " " + 1);
                        ((Vector)this.controlliQM.firstElement()).addElement(gc);
                        ((Vector)this.specificheControlliQM.firstElement()).addElement(spec_line);
                    } else {
                        try {
                            this.controlli.addElement(gc);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    break block13;
                }
                catch (Exception ex) {
                    System.out.print("Riga errata: ");
                    j = 0;
                    ** while (j < ((String[])specificheControlli.elementAt((int)i)).length)
                }
lbl-1000:
                // 1 sources

                {
                    System.out.print(String.valueOf(((String[])specificheControlli.elementAt(i))[j]) + " ");
                    ++j;
                    continue;
                }
lbl42:
                // 1 sources

                System.out.println(" ");
                MetodiUtili.logEccezioni(ex);
            }
            ++i;
        }
    }

    public void costruisciControlloQM(int indiceQuadro) {
        block6: {
            try {
                Vector specificheSingoloQ = new Vector();
                GericoControllo gc = null;
                Vector<GericoControllo> appoggio = new Vector<GericoControllo>();
                if (this.controlliQM.isEmpty()) break block6;
                String nomePrimoQuadro = ((GericoControllo)((Vector)this.controlliQM.firstElement()).firstElement()).getNomeQuadro();
                String nomeQuadro = nomePrimoQuadro.substring(0, nomePrimoQuadro.length() - 2);
                specificheSingoloQ = (Vector)this.specificheControlliQM.elementAt(indiceQuadro);
                int i = 0;
                while (i < specificheSingoloQ.size()) {
                    String[] specificaContr = new String[]{(String)specificheSingoloQ.elementAt(i), String.valueOf(nomeQuadro) + " " + (indiceQuadro + 1)};
                    try {
                        gc = GericoControllo.getIstanza(specificaContr, this.campi);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (gc == null) {
                        throw new Exception();
                    }
                    appoggio.addElement(gc);
                    ++i;
                }
                this.controlliQM.addElement(appoggio);
            }
            catch (Exception ex) {
                System.out.println("GericoControllo su QM non e' stato istanziato ");
                MetodiUtili.logEccezioni(ex);
            }
        }
    }

    private GericoModel creaAlfaNumericModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        int lunghezza = Integer.parseInt((String)v.elementAt(2));
        return new AlfaNumericModel(codiceCampo, descrErrore, lunghezza);
    }

    private GericoModel creaBeanModel(String type, Vector specif_lineVet) {
        GericoModel gm = null;
        if (type.equalsIgnoreCase("DNM")) {
            gm = this.creaNumericModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("RNM")) {
            gm = this.creaRangeModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("VNM")) {
            gm = this.creaValutaModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("AM")) {
            gm = this.creaAlfaNumericModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("CBM")) {
            gm = this.creaComboModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("TBM")) {
            gm = this.creaToggleModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("SCM")) {
            gm = this.creaAlfaNumericModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("CFM")) {
            gm = this.creaCodiceFiscaleModel(specif_lineVet);
        } else if (type.equalsIgnoreCase("CAFM")) {
            gm = this.creaCodiceFiscaleModel(specif_lineVet);
        }
        return gm;
    }

    private String creaCodCampoMsg(String string, int incremento) {
        int num1 = Integer.parseInt(string.substring(1, string.length()));
        String codice = String.valueOf(string.substring(0, 1)) + (num1 += incremento);
        return codice;
    }

    private GericoModel creaCodiceFiscaleModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        String flagobb = (String)v.elementAt(2);
        if (flagobb.equals("0")) {
            return new CodFiscModel(codiceCampo, descrErrore, false);
        }
        if (flagobb.equals("1")) {
            return new CodFiscModel(codiceCampo, descrErrore, true);
        }
        return null;
    }

    private GericoModel creaComboModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        int lunghezza = Integer.parseInt((String)v.elementAt(2));
        Vector lista = new Vector();
        int j = 3;
        while (j < v.size()) {
            lista.addElement(v.elementAt(j));
            ++j;
        }
        return new ComboBoxModel(codiceCampo, descrErrore, lunghezza, lista);
    }

    private void creaModelQM(int numeroQuadri) {
        this.setNumeroQuadriMultipli(1);
        if (numeroQuadri > this.numeroMaxQuadri) {
            return;
        }
        int i = 1;
        while (i < numeroQuadri) {
            this.getModelNuovoQuadroMultiplo();
            ++i;
        }
    }

    private GericoModel creaNumericModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        int lunghezza = Integer.parseInt((String)v.elementAt(2));
        return new DefaultNumericModel(codiceCampo, descrErrore, lunghezza);
    }

    private GericoModel creaRangeModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        int lunghezza = Integer.parseInt((String)v.elementAt(2));
        long valoreMinimo = Long.parseLong((String)v.elementAt(3));
        long valoreMassimo = Long.parseLong((String)v.elementAt(4));
        return new RangeNumericModel(codiceCampo, descrErrore, lunghezza, valoreMinimo, valoreMassimo);
    }

    private String creaSpecificaC2(String primaParte, int indice) {
        StringBuffer appo = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(primaParte, "^");
        while (strTok.hasMoreElements()) {
            String controllo = strTok.nextToken();
            StringTokenizer strTok2 = new StringTokenizer(controllo, "*");
            String tipoControllo = strTok2.nextToken();
            if (tipoControllo.equalsIgnoreCase("C2") || tipoControllo.equalsIgnoreCase("W2")) {
                appo.append(this.creaSpecificaCE(strTok2, indice));
            } else if (tipoControllo.equalsIgnoreCase("CE") || tipoControllo.equalsIgnoreCase("WE")) {
                appo.append(tipoControllo).append(this.creaSpecificaCE(strTok2, indice));
            } else if (tipoControllo.equalsIgnoreCase("WT") || tipoControllo.equalsIgnoreCase("CT")) {
                appo.append(tipoControllo).append(this.creaSpecificaCT(controllo, indice));
            } else if (tipoControllo.equalsIgnoreCase("CU")) {
                appo.append(tipoControllo).append(this.creaSpecificaCU(strTok2, indice));
            } else if (tipoControllo.equalsIgnoreCase("CVCS")) {
                appo.append(tipoControllo).append(this.creaSpecificaCVCS(strTok2, indice));
            } else if (tipoControllo.equalsIgnoreCase("CCS")) {
                appo.append(tipoControllo).append(this.creaSpecificaCCS(strTok2, indice));
            }
            appo.append("^");
        }
        return appo.toString();
    }

    private String creaSpecificaCCS(StringTokenizer strTok, int indice) {
        StringBuffer appo = new StringBuffer();
        Vector<String> codici = new Vector<String>();
        codici.addElement(strTok.nextToken());
        int x = 0;
        while (x < codici.size()) {
            String codAggiornato = MetodiUtili.modificaColonnaCodice((String)codici.elementAt(x), indice);
            appo.append("*").append(codAggiornato);
            ++x;
        }
        appo.append("*").append(strTok.nextToken());
        return appo.toString();
    }

    private String creaSpecificaCE(StringTokenizer strTok, int indice) {
        StringBuffer appo = new StringBuffer();
        Vector<String> codici = new Vector<String>();
        while (strTok.hasMoreTokens()) {
            codici.addElement(strTok.nextToken());
        }
        int x = 0;
        while (x < codici.size()) {
            String codAggiornato = MetodiUtili.modificaColonnaCodice((String)codici.elementAt(x), indice);
            appo.append("*").append(codAggiornato);
            ++x;
        }
        return appo.toString();
    }

    private String creaSpecificaCPI(String primaParte, int indiceQN) {
        StringBuffer appo = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(primaParte, "*");
        strTok.nextToken();
        appo.append("*").append(strTok.nextToken());
        return appo.toString();
    }

    private String creaSpecificaCR(StringTokenizer strTok, int indice) {
        StringBuffer appo = new StringBuffer();
        String codice = null;
        codice = strTok.nextToken();
        String codAggiornato = MetodiUtili.modificaColonnaCodice(codice, indice);
        appo.append("*").append(codAggiornato);
        while (strTok.hasMoreElements()) {
            appo.append("*").append(strTok.nextToken());
        }
        return appo.toString();
    }

    private String creaSpecificaCRP(String primaParte, int indiceQN) {
        StringBuffer appo = new StringBuffer();
        Vector<String> codici1 = new Vector<String>();
        StringTokenizer strTok = new StringTokenizer(primaParte, "*");
        strTok.nextToken();
        while (strTok.hasMoreTokens()) {
            codici1.addElement(strTok.nextToken());
        }
        int x = 0;
        while (x < codici1.size()) {
            if (((String)codici1.elementAt(x)).length() == 7) {
                String codAggiornato = String.valueOf(String.valueOf(indiceQN)) + ((String)codici1.elementAt(x)).substring(1, 7);
                appo.append("*").append(((String)codici1.elementAt(x)).substring(0, 1)).append(codAggiornato);
            } else {
                System.out.println("Valore non corrispondente a un codice di bean: lunghezza diversa da 7 !");
            }
            ++x;
        }
        return appo.toString();
    }

    private String creaSpecificaCT(String primaParte, int indice) {
        StringBuffer appo = new StringBuffer();
        Vector<String> codici1 = new Vector<String>();
        Vector<String> codici2 = new Vector<String>();
        StringTokenizer strTok = new StringTokenizer(primaParte, "_");
        StringTokenizer strTok2 = new StringTokenizer(strTok.nextToken(), "*");
        strTok2.nextToken();
        while (strTok2.hasMoreTokens()) {
            codici1.addElement(strTok2.nextToken());
        }
        int x = 0;
        while (x < codici1.size()) {
            if (((String)codici1.elementAt(x)).length() == 7) {
                String nuovoCodice = MetodiUtili.modificaColonnaCodice((String)codici1.elementAt(x), indice);
                appo.append("*").append(nuovoCodice);
            } else {
                System.out.println("Valore non corrispondente a un codice di bean: lunghezza diversa da 7 !");
            }
            ++x;
        }
        appo.append("_").append(strTok.nextToken()).append("_");
        StringTokenizer strTok3 = new StringTokenizer(strTok.nextToken(), "*");
        while (strTok3.hasMoreTokens()) {
            codici2.addElement(strTok3.nextToken());
        }
        int x2 = 0;
        while (x2 < codici2.size()) {
            if (((String)codici2.elementAt(x2)).length() == 7) {
                String nuovoCodice = MetodiUtili.modificaColonnaCodice((String)codici1.elementAt(x2), indice);
                appo.append(nuovoCodice);
            } else if (((String)codici2.elementAt(x2)).length() < 7) {
                appo.append((String)codici2.elementAt(x2));
            } else {
                System.out.println("Valore non corrispondente a un codice di bean: lunghezza diversa da 7 !");
            }
            ++x2;
        }
        return appo.toString();
    }

    private String creaSpecificaCU(StringTokenizer strTok, int indice) {
        StringBuffer appo = new StringBuffer();
        appo.append("*").append(strTok.nextToken());
        String codAggiornato = MetodiUtili.modificaColonnaCodice(strTok.nextToken(), indice);
        appo.append("*").append(codAggiornato);
        return appo.toString();
    }

    private String creaSpecificaCVCS(StringTokenizer strTok, int indice) {
        StringBuffer appo = new StringBuffer();
        Vector<String> codici = new Vector<String>();
        while (strTok.hasMoreTokens()) {
            codici.addElement(strTok.nextToken());
        }
        int x = 0;
        while (x < codici.size()) {
            String codAggiornato = MetodiUtili.modificaColonnaCodice((String)codici.elementAt(x), indice);
            appo.append("*").append(codAggiornato);
            ++x;
        }
        return appo.toString();
    }

    private GericoModel creaToggleModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        return new ToggleButtonModel(codiceCampo, descrErrore);
    }

    private GericoModel creaValutaModel(Vector v) {
        String codiceCampo = (String)v.elementAt(0);
        String descrErrore = (String)v.elementAt(1);
        int lunghezza = Integer.parseInt((String)v.elementAt(2));
        return new ValutaNumericModel(codiceCampo, descrErrore, lunghezza);
    }

    public boolean eseguiControlliDocumento() {
        this.campiErrati.removeAllElements();
        this.vecMsgErrori.removeAllElements();
        boolean ritorno = true;
        int cont = 0;
        while (cont < this.controlli.size()) {
            boolean risultato;
            GericoControllo gc;
            if (this.controlli.elementAt(cont) instanceof String) {
                int contQM = 0;
                while (contQM < this.controlliQM.size()) {
                    Vector vecSingoloQ = new Vector();
                    vecSingoloQ = (Vector)this.controlliQM.elementAt(contQM);
                    int contSingoloQ = 0;
                    while (contSingoloQ < vecSingoloQ.size()) {
                        gc = (GericoControllo)vecSingoloQ.elementAt(contSingoloQ);
                        risultato = gc.verifica();
                        if (!risultato) {
                            Anomalia anomalia = new Anomalia((Chiave)this.chiave, "Q", gc);
                            this.messaggioErrore.addElement(anomalia);
                            ritorno = false;
                        }
                        ++contSingoloQ;
                    }
                    ++contQM;
                }
            } else {
                gc = (GericoControllo)this.controlli.elementAt(cont);
                risultato = gc.verifica();
                if (!risultato) {
                    Anomalia anomalia = new Anomalia((Chiave)this.chiave, "Q", gc);
                    this.messaggioErrore.addElement(anomalia);
                    ritorno = false;
                }
            }
            ++cont;
        }
        return ritorno;
    }

    /*
     * Unable to fully structure code
     */
    public boolean eseguiControlliQuadro(String nomeQuadro) {
        block12: {
            vetControlli = new Vector();
            risultato = false;
            nomeQ = null;
            this.campiErrati.removeAllElements();
            this.vecMsgErrori.removeAllElements();
            try {
                vetControlli = this.getControlliQuadro(nomeQuadro);
                cont = 0;
                while (cont < vetControlli.size()) {
                    block11: {
                        gc = (GericoControllo)vetControlli.elementAt(cont);
                        try {
                            risultato = gc.verifica();
                            break block11;
                        }
                        catch (Exception v0) {
                            System.out.println(gc.toString());
                            System.out.print("Campi controllati nel metodo verifica: ");
                            i = 0;
                            ** while (i < gc.getCampiControllati().length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            System.out.print(String.valueOf(gc.getCampiControllati()[i]) + " ");
                            ++i;
                            continue;
                        }
                    }
                    if (!risultato) {
                        if (this.vecMsgErrori.size() == 0 || !nomeQ.equalsIgnoreCase(gc.getNomeQuadro())) {
                            if (this.vecMsgErrori.size() != 0) {
                                this.vecMsgErrori.addElement(" ");
                            }
                            this.vecMsgErrori.addElement(String.valueOf(gc.getNomeQuadro()) + ":");
                            nomeQ = gc.getNomeQuadro();
                        }
                        this.vecMsgErrori.addElement(gc.getMessaggio());
                        campiErr = new Vector();
                        campiErr = gc.getCampiErrati();
                        j = 0;
                        while (j < campiErr.size()) {
                            this.campiErrati.addElement(campiErr.elementAt(j));
                            ++j;
                        }
                    }
                    ++cont;
                }
                break block12;
            }
            catch (Exception ex) {
                System.out.println("Potrebbe essere errato il messaggio. Campi errati: ");
                i = 0;
                ** while (i < this.getCampiErrati().size())
            }
lbl-1000:
            // 1 sources

            {
                System.out.print(this.getCampiErrati().elementAt(i) + " ");
                ++i;
                continue;
            }
lbl47:
            // 1 sources

            MetodiUtili.logEccezioni(ex);
        }
        return this.getCampiErrati().isEmpty() != false;
    }

    public boolean eseguiControlliQuadroSalvataggio() {
        return true;
    }

    public boolean eseguiControlliSalvataggio() {
        return this.vecMsgSalvataggio.isEmpty();
    }

    public boolean eseguiControlloQM(int indice) {
        Vector vetControlli = new Vector();
        this.campiErrati.removeAllElements();
        this.vecMsgErrori.removeAllElements();
        vetControlli = this.getControlliQM(indice);
        if (!vetControlli.isEmpty()) {
            int i = 0;
            while (i < vetControlli.size()) {
                GericoControllo gc = (GericoControllo)vetControlli.elementAt(i);
                boolean esito = gc.verifica();
                if (!esito) {
                    if (this.vecMsgErrori.size() == 0) {
                        this.vecMsgErrori.addElement(String.valueOf(gc.getNomeQuadro()) + ":");
                    }
                    this.vecMsgErrori.addElement(gc.getMessaggio());
                    Vector campiErr = new Vector();
                    campiErr = gc.getCampiErrati();
                    int j = 0;
                    while (j < campiErr.size()) {
                        this.campiErrati.addElement(campiErr.elementAt(j));
                        ++j;
                    }
                }
                ++i;
            }
        }
        return this.getCampiErrati().isEmpty();
    }

    private String estraiNumMaxQuadri(String specLine) {
        StringTokenizer st = new StringTokenizer(specLine, "*");
        int countTokens = st.countTokens();
        int i = 0;
        while (i < countTokens - 1) {
            st.nextToken();
            ++i;
        }
        return st.nextToken();
    }

    public Hashtable getCampi() {
        return this.campi;
    }

    public Vector getCampiErrati() {
        return this.campiErrati;
    }

    public GericoModel getCampo(String chiave) {
        GericoModel gm = (GericoModel)this.campi.get(chiave);
        return gm;
    }

    private String getCampoMultiplo(int indiceCampo, int tipoCampo) {
        switch (tipoCampo) {
            case 0: {
                return this.getCampo(this.getCampoMultiplo(indiceCampo, 2)).getValue();
            }
            case 1: {
                return ((String[])this.quadroMultiplo.elementAt(indiceCampo))[0];
            }
            case 2: {
                return ((String[])this.quadroMultiplo.elementAt(indiceCampo))[1].substring(0, 6);
            }
            case 3: {
                return ((String[])this.quadroMultiplo.elementAt(indiceCampo))[1].substring(7, 10);
            }
        }
        return null;
    }

    private Object getCampoMultiplo(int indiceCampo, int indiceQuadroMultiplo, int tipoCampo) {
        if (indiceCampo > this.getNumeroCampiMultiplo()) {
            throw new ArrayIndexOutOfBoundsException(indiceCampo);
        }
        if (indiceQuadroMultiplo > this.numeroMaxQuadri) {
            throw new ArrayIndexOutOfBoundsException(indiceQuadroMultiplo);
        }
        int indice = indiceQuadroMultiplo * this.getNumeroCampiMultiplo() + indiceCampo;
        switch (tipoCampo) {
            case 4: {
                return this.quadroMultiplo.elementAt(indice);
            }
            case 5: {
                return this.getCampo(this.getCampoMultiplo(indice, 2));
            }
        }
        return this.getCampoMultiplo(indice, tipoCampo);
    }

    public ChiaveAnnotazione getChiave() {
        return this.chiave;
    }

    public Vector getControlliQM() {
        return this.controlliQM;
    }

    public Vector getControlliQM(int indice) {
        Vector vec = (Vector)this.controlliQM.elementAt(indice);
        return vec;
    }

    private Vector getControlliQuadro(String nomeQuadro) {
        GericoControllo gm = null;
        Vector<GericoControllo> controlliQuadroVet = new Vector<GericoControllo>();
        int cont = 0;
        int contQM = 0;
        if (this.controlli.size() == 0) {
            return controlliQuadroVet;
        }
        cont = 0;
        while (cont < this.controlli.size()) {
            if (this.controlli.elementAt(cont) instanceof String) {
                contQM = 0;
                while (contQM < this.controlliQM.size()) {
                    Vector vecSingoloQ = new Vector();
                    vecSingoloQ = (Vector)this.controlliQM.elementAt(contQM);
                    int contSingoloQ = 0;
                    while (contSingoloQ < vecSingoloQ.size()) {
                        gm = (GericoControllo)vecSingoloQ.elementAt(contSingoloQ);
                        if (gm.getNomeQuadro().equalsIgnoreCase(String.valueOf(nomeQuadro) + " " + (contQM + 1))) {
                            controlliQuadroVet.addElement(gm);
                        }
                        ++contSingoloQ;
                    }
                    ++contQM;
                }
            } else {
                gm = (GericoControllo)this.controlli.elementAt(cont);
                if (gm.getNomeQuadro().equalsIgnoreCase(nomeQuadro)) {
                    controlliQuadroVet.addElement(gm);
                }
            }
            ++cont;
        }
        return controlliQuadroVet;
    }

    public int getIndiceAssenzaQM() {
        int i = 0;
        while (i < Math.max(this.getNumeroQuadriMultipli(), 1)) {
            if (this.isQuadroMultiploAssente(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Vector getMessaggioErrore() {
        if (this.vecMsgErrori != null) {
            int i = 0;
            while (i < this.vecMsgErrori.size()) {
                if (((String)this.vecMsgErrori.elementAt(i)).trim().length() > 0) {
                    this.messaggioErrore.addElement(this.vecMsgErrori.elementAt(i));
                }
                ++i;
            }
        }
        return this.messaggioErrore;
    }

    public Vector getModelNuovoQuadroMultiplo() {
        int numeroQuadriMultipli = this.getNumeroQuadriMultipli();
        int i = 0;
        while (i < this.getNumeroCampiMultiplo()) {
            String[] specifiche = (String[])this.getCampoMultiplo(i, numeroQuadriMultipli, 4);
            this.costruisciCampo(specifiche);
            ++i;
        }
        Vector codici = this.getQuadroMultiplo(numeroQuadriMultipli, 2);
        Vector models = new Vector();
        int i2 = 0;
        while (i2 < codici.size()) {
            String codice = (String)codici.elementAt(i2);
            models.addElement(this.campi.get(codice));
            ++i2;
        }
        this.setNumeroQuadriMultipli(++numeroQuadriMultipli);
        return models;
    }

    public String getNomeFile() {
        return this.nomeFile;
    }

    private int getNumeroCampiMultiplo() {
        try {
            return this.quadroMultiplo.size() / this.numeroMaxQuadri;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getNumeroMaxQuadri() {
        return this.numeroMaxQuadri;
    }

    public int getNumeroQuadriMultipli() {
        try {
            return Integer.parseInt(this.getCampo(this.codiceNumeroQM).getValue());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private boolean[] getQuadriMultipliAssenti() {
        boolean[] quadriAssenti = new boolean[this.getNumeroQuadriMultipli()];
        int i = 0;
        while (i < this.getNumeroQuadriMultipli()) {
            quadriAssenti[i] = this.isQuadroMultiploAssente(i);
            ++i;
        }
        return quadriAssenti;
    }

    public Vector getQuadroMultiplo() {
        return this.quadroMultiplo;
    }

    public Vector getQuadroMultiplo(int indiceQuadro, int tipoCampo) {
        Vector<Object> riga = new Vector<Object>();
        int i = 0;
        while (i < this.getNumeroCampiMultiplo()) {
            riga.addElement(this.getCampoMultiplo(i, indiceQuadro, tipoCampo));
            ++i;
        }
        return riga;
    }

    public StringBuffer getRecordPosizionale() {
        StringBuffer recordS = new StringBuffer();
        int i = 0;
        while (i < this.vecTesta.size()) {
            String chiave = (String)this.vecTesta.elementAt(i);
            GericoModel gm = (GericoModel)this.campi.get(chiave);
            recordS.append(gm.getValue());
            ++i;
        }
        recordS.insert(0, "Q");
        return recordS;
    }

    public Hashtable getStudioDaSalvare() {
        GericoModel gericoModel;
        String chiave;
        Hashtable<String, String> campiDaSalvare = new Hashtable<String, String>();
        Enumeration chiavi = this.vecTesta.elements();
        while (chiavi.hasMoreElements()) {
            chiave = (String)chiavi.nextElement();
            gericoModel = (GericoModel)this.campi.get(chiave);
            if (gericoModel instanceof ListModel) {
                campiDaSalvare.put(chiave, gericoModel.getValue());
                continue;
            }
            campiDaSalvare.put(chiave, gericoModel.getValue());
        }
        chiavi = this.chiaviCampiPosizionali.elements();
        while (chiavi.hasMoreElements()) {
            chiave = (String)chiavi.nextElement();
            gericoModel = (GericoModel)this.campi.get(chiave);
            if (gericoModel instanceof ListModel) {
                campiDaSalvare.put(chiave, gericoModel.getValue());
                continue;
            }
            campiDaSalvare.put(chiave, gericoModel.getValue());
        }
        chiavi = this.chiaviCampiNonPosizionali.elements();
        while (chiavi.hasMoreElements()) {
            chiave = (String)chiavi.nextElement();
            gericoModel = (GericoModel)this.campi.get(chiave);
            if (gericoModel == null || gericoModel.isValorePredefinito()) continue;
            if (gericoModel instanceof ListModel) {
                campiDaSalvare.put(chiave, gericoModel.getValue());
                continue;
            }
            campiDaSalvare.put(chiave, gericoModel.getValue());
        }
        return campiDaSalvare;
    }

    public Vector getVecMsgErrori() {
        if (!this.vecMsgErrori.isEmpty()) {
            Vector vec = new Vector();
            int i = 0;
            while (i < this.vecMsgErrori.size()) {
                vec.addElement(this.vecMsgErrori.elementAt(i));
                ++i;
            }
            this.vecMsgErrori.removeAllElements();
            this.vecMsgErrori = vec;
        }
        return this.vecMsgErrori;
    }

    public Vector getVecMsgSalvataggio() {
        return this.vecMsgSalvataggio;
    }

    public Vector getVecMsgWarning() {
        if (!this.vecMsgWarning.isEmpty()) {
            Vector vec = new Vector();
            int i = 0;
            while (i < this.vecMsgWarning.size()) {
                vec.addElement(this.vecMsgWarning.elementAt(i));
                ++i;
            }
            this.vecMsgWarning.removeAllElements();
            this.vecMsgWarning = vec;
        }
        return this.vecMsgWarning;
    }

    public Vector getVecTesta() {
        return this.vecTesta;
    }

    private Vector getWarning() {
        return this.warning;
    }

    private void initialize() {
        ModelloAnnotazioneSet specifiche = new ModelloAnnotazioneSet("annosepa");
        Vector vecSpecifiche = null;
        String[] strSpecifiche = new String[2];
        this.codiceNumeroQM = "";
        this.campi = new Hashtable();
        this.chiaviCampiNonPosizionali = new Vector();
        this.chiaviCampiPosizionali = new Vector();
        this.vecTesta = new Vector();
        this.controlli = new Vector();
        this.warning = new Vector();
        this.campiErrati = new Vector();
        this.messaggioErrore = new Vector();
        this.vecMsgErrori = new Vector();
        this.vecMsgWarning = new Vector();
        this.vecMsgSalvataggio = new Vector();
        this.specificheControlliQM = new Vector();
        this.controlliQM = new Vector();
        vecSpecifiche = specifiche.getTesta("testam.ger");
        int i = 1;
        while (i < vecSpecifiche.size()) {
            strSpecifiche = (String[])vecSpecifiche.elementAt(i);
            this.costruisciCampo(strSpecifiche);
            ++i;
        }
        strSpecifiche = new String[3];
        vecSpecifiche = specifiche.getModel("annosepam.ger");
        i = 0;
        while (i < vecSpecifiche.size()) {
            strSpecifiche = (String[])vecSpecifiche.elementAt(i);
            this.costruisciCampo(strSpecifiche);
            ++i;
        }
        this.quadroMultiplo = specifiche.getVectorMultipli();
        i = 0;
        while (i < this.quadroMultiplo.size()) {
            this.chiaviCampiNonPosizionali.addElement(this.getCampoMultiplo(i, 2));
            ++i;
        }
        strSpecifiche = new String[3];
        this.costruisciControlli(specifiche.getControlli());
        if (!this.specificheControlliQM.isEmpty()) {
            this.aggiornaSpecificheControlliQM();
        }
    }

    public boolean isQuadroMultiploAssente(int indice) {
        Vector models = this.getQuadroMultiplo(indice, 5);
        GericoModel gm1 = (GericoModel)models.elementAt(0);
        GericoModel gm2 = (GericoModel)models.elementAt(1);
        return gm1.isValorePredefinito() && gm2.isValorePredefinito();
    }

    public boolean leggi(Hashtable hash) {
        boolean esitoLettura = this.leggiDatiPosizione(hash);
        this.setControlliQM();
        return esitoLettura;
    }

    private boolean leggiDatiPosizione(Hashtable hash) {
        String value = (String)hash.get(this.codiceNumeroQM);
        if (value != null) {
            try {
                int n = Integer.parseInt(value);
                this.creaModelQM(n);
            }
            catch (NumberFormatException numberFormatException) {
                Anomalia anomalia = new Anomalia(this.chiave, "Q", "scarto_confermabile", "011", this.codiceNumeroQM);
                this.messaggioErrore.addElement(anomalia);
                return false;
            }
        }
        String chiaveCampo = null;
        String valoreCampo = null;
        Enumeration chiavi = hash.keys();
        boolean esito = true;
        while (chiavi.hasMoreElements()) {
            chiaveCampo = (String)chiavi.nextElement();
            if (this.setValoreCampo(chiaveCampo, valoreCampo = (String)hash.get(chiaveCampo))) continue;
            esito = false;
        }
        int i = 0;
        while (i < this.getNumeroQuadriMultipli()) {
            if (this.isQuadroMultiploAssente(i)) {
                Anomalia anomalia = new Anomalia(this.chiave, "Q", "scarto_confermabile", "322");
                this.messaggioErrore.addElement(anomalia);
                esito = false;
                break;
            }
            ++i;
        }
        return esito;
    }

    private void rimuoviModelQuadroMultiplo(int indice) {
        Vector codici = this.getQuadroMultiplo(indice, 2);
        int i = 0;
        while (i < codici.size()) {
            this.campi.remove(codici.elementAt(i));
            ++i;
        }
    }

    public void rimuoviQuadroMultiplo(int indice) {
        int numeroQuadriMultipli = this.getNumeroQuadriMultipli();
        if (numeroQuadriMultipli == 1) {
            Vector models = this.getQuadroMultiplo(0, 5);
            int i = 0;
            while (i < models.size()) {
                ((GericoModel)models.elementAt(i)).setValorePredefinito();
                ++i;
            }
        } else {
            if (this.getControlliQM().size() > 0) {
                this.getControlliQM().removeElementAt(this.getControlliQM().size() - 1);
            }
            int i = indice;
            while (i < numeroQuadriMultipli - 1) {
                Vector valori = this.getQuadroMultiplo(i + 1, 0);
                Vector models = this.getQuadroMultiplo(i, 5);
                int j = 0;
                while (j < valori.size()) {
                    try {
                        GericoModel gm = (GericoModel)models.elementAt(j);
                        gm.setValore((String)valori.elementAt(j));
                    }
                    catch (ControlloFormaleException controlloFormaleException) {}
                    ++j;
                }
                ++i;
            }
            this.rimuoviModelQuadroMultiplo(numeroQuadriMultipli - 1);
        }
        this.setNumeroQuadriMultipli(--numeroQuadriMultipli);
    }

    private void setControlliQM() {
        int numQ = this.getNumeroQuadriMultipli();
        int i = 1;
        while (i < numQ) {
            this.costruisciControlloQM(i);
            ++i;
        }
    }

    private void setNomeFile(String newNomeFile) {
        this.nomeFile = newNomeFile;
    }

    public void setNumeroQuadriMultipli(int numero) {
        try {
            this.getCampo(this.codiceNumeroQM).setValore(String.valueOf(numero));
        }
        catch (ControlloFormaleException controlloFormaleException) {}
    }

    private boolean setValoreCampo(String chiave, String valore) {
        GericoModel gm = (GericoModel)this.campi.get(chiave);
        if (gm != null) {
            try {
                gm.setValore(valore);
                return true;
            }
            catch (ControlloFormaleException controlloFormaleException) {
                Anomalia anomalia = new Anomalia((Chiave)this.chiave, "Q", gm);
                this.messaggioErrore.addElement(anomalia);
                return false;
            }
        }
        Anomalia anomalia = new Anomalia(this.chiave, "Q", "scarto", "016", chiave);
        this.messaggioErrore.addElement(anomalia);
        return false;
    }

    private void valorizzaBean(ChiaveAnnotazione chiave) {
        GericoModel gm = null;
        try {
            gm = (GericoModel)this.campi.get(CODE_FISCALE);
            gm.setValore(chiave.getCodiceFiscale());
            gm = (GericoModel)this.campi.get(CODE_MULTIATTIVITA);
        }
        catch (ControlloFormaleException e) {
            e.printStackTrace();
        }
    }

    public boolean verificaDati() {
        return false;
    }
}

