/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.controlli;

import finanze.IDTE.studi2002.campi.GericoModel;
import finanze.IDTE.studi2002.controlli.ControlloQuadroMultiplo;
import finanze.IDTE.studi2002.generale.MetodiUtili;
import java.util.Hashtable;

public class ControlloRicaviRicag
extends ControlloQuadroMultiplo {
    protected ControlloRicaviRicag(String spec_line, Hashtable componentiModel, String nomeQuadro) {
        super(spec_line, componentiModel, nomeQuadro);
    }

    private double calcolaPercentuale(GericoModel gm1, GericoModel gm2) {
        return new Double(gm1.getValue()) / (new Double(gm1.getValue()) + new Double(gm2.getValue())) * 100.0;
    }

    protected void creaMessaggioErrore() {
        this.messaggio = "-- In presenza di un codice studio e di un ricag con ricavi non superiori al 20% utilizzare GERICO 2002";
    }

    protected void impostaErrore() {
        this.gravitaErrore = "scarto_confermabile";
        this.errore = String.valueOf(this.codErrore);
    }

    public boolean verifica() {
        this.esito = true;
        if (this.getNumeroQuadriMultipli() != 2) {
            return this.esito;
        }
        GericoModel gm1 = this.getGericoModel(0, 2);
        GericoModel gm2 = this.getGericoModel(1, 2);
        String codiceStudio1 = gm1.getValue();
        String codiceStudio2 = gm2.getValue();
        if (MetodiUtili.isCodiceStudio(codiceStudio1) && codiceStudio2.equalsIgnoreCase("ricag")) {
            double percentuale = this.calcolaPercentuale(this.getGericoModel(1, 3), this.getGericoModel(0, 3));
            this.esito = percentuale > 20.0;
        } else if (MetodiUtili.isCodiceStudio(codiceStudio2) && codiceStudio1.equalsIgnoreCase("ricag")) {
            double percentuale = this.calcolaPercentuale(this.getGericoModel(0, 3), this.getGericoModel(1, 3));
            boolean bl = this.esito = percentuale > 20.0;
        }
        if (!this.esito) {
            this.impostaErrore();
            this.creaMessaggioErrore();
        }
        return this.esito;
    }
}

