/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.xades.impl.dom.properties;

import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.ReferenceImpl;
import iaik.xml.crypto.dsig.XMLSignatureImpl;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.URI;
import iaik.xml.crypto.utils.URIDereferencerImpl;
import iaik.xml.crypto.utils.URIException;
import iaik.xml.crypto.xades.Include;
import iaik.xml.crypto.xades.dom.XadesDOMStructure;
import iaik.xml.crypto.xades.impl.dom.properties.QualifyingPropertiesImpl;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class IncludeImpl
extends XadesDOMStructure
implements DOMURIReference,
Include {
    private Boolean b;
    private String a;

    protected void unmarshalAttributes(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Attr attr;
        Attr attr2 = (Attr)namedNodeMap.getNamedItemNS(null, "URI");
        if (attr2 != null) {
            try {
                this.setTargetId(attr2.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MarshalException("Include element doesn't contain a valid URI-attribute. " + illegalArgumentException.getMessage());
            }
        }
        if ((attr = (Attr)namedNodeMap.getNamedItemNS(null, "referencedData")) != null) {
            this.b = new Boolean(attr.getValue());
        }
    }

    protected void setTargetId(String string) throws IllegalArgumentException {
        URI uRI;
        try {
            uRI = new URI(string);
        }
        catch (URIException uRIException) {
            throw new IllegalArgumentException(uRIException.getMessage());
        }
        if (!uRI.isReference()) {
            throw new IllegalArgumentException("URI '" + string + "' is not a valid barename XPointer.");
        }
        String string2 = uRI.getReference();
        if (string2.startsWith("xpointer(") || string2.startsWith("xmlns(")) {
            throw new IllegalArgumentException("URI '" + string + "' is not a valid barename XPointer.");
        }
        this.a = string2;
    }

    public boolean referencedData() {
        if (this.b == null) {
            return false;
        }
        return this.b;
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        Attr attr;
        super.marshalAttributes(dOMCryptoContext, element);
        Document document = DOMUtils.getOwnerDocument((Node)element);
        String string = this.getURI();
        if (string != null) {
            attr = document.createAttributeNS("", "URI");
            attr.setValue(string);
            element.setAttributeNodeNS(attr);
        }
        if (this.b != null) {
            attr = document.createAttributeNS("", "referencedData");
            attr.setValue(this.b.toString());
            element.setAttributeNodeNS(attr);
        }
    }

    public String getURI() {
        return this.a != null ? "#" + this.a : null;
    }

    public String getType() {
        return null;
    }

    public String getTargetId() {
        return this.a;
    }

    public String getLocalName() {
        return "Include";
    }

    public Node getHere() {
        return super.getHere();
    }

    InputStream b(XMLCryptoContext xMLCryptoContext) throws TransformException, NoSuchAlgorithmException, URIReferenceException {
        if (this.b != null && this.b.booleanValue()) {
            List<Reference> list;
            XMLSignatureImpl xMLSignatureImpl;
            IncludeImpl includeImpl = this;
            while (includeImpl != null && !(includeImpl instanceof QualifyingPropertiesImpl)) {
                includeImpl = DOMStructure.getParentStructureOf((DOMStructure)includeImpl);
            }
            if (includeImpl == null) {
                throw new URIReferenceException("Cannot dereference Include. Cannot access the ancestral QualifyingProperties.");
            }
            try {
                xMLSignatureImpl = ((QualifyingPropertiesImpl)((Object)includeImpl)).getTargetSignature();
            }
            catch (XMLSignatureException xMLSignatureException) {
                throw new URIReferenceException("Cannot dereference Include. Cannot access the ancestral Signature.");
            }
            if (xMLSignatureImpl == null) {
                throw new URIReferenceException("Cannot dereference Include. Cannot access the target Signature.");
            }
            SignedInfo signedInfo = xMLSignatureImpl.getSignedInfo();
            if (signedInfo != null && (list = signedInfo.getReferences()) != null) {
                Iterator<Reference> iterator = list.iterator();
                while (iterator.hasNext()) {
                    ReferenceImpl referenceImpl = (ReferenceImpl)iterator.next();
                    if (!this.a.equals(referenceImpl.getId())) continue;
                    if (referenceImpl.getType() != null && referenceImpl.getType().equals("http://uri.etsi.org/01903#SignedProperties")) {
                        throw new URIReferenceException("References having the type http://uri.etsi.org/01903#SignedProperties cannot be referenced.");
                    }
                    InputStream inputStream = referenceImpl.getDigestInputStream();
                    if (inputStream == null) {
                        inputStream = referenceImpl.dereferenceAndCanonicalize(xMLCryptoContext);
                    }
                    return inputStream;
                }
            }
            throw new URIReferenceException("Cannot dereference Include. No ds:Reference with Id-attribute '" + this.a + "' found.");
        }
        return null;
    }

    Data a(XMLCryptoContext xMLCryptoContext) throws TransformException, URIReferenceException {
        if (this.b != null && this.b.booleanValue()) {
            List<Reference> list;
            XMLSignatureImpl xMLSignatureImpl;
            QualifyingPropertiesImpl qualifyingPropertiesImpl;
            try {
                qualifyingPropertiesImpl = XadesDOMStructure.getParentQualifyingPropertiesOf(this);
            }
            catch (XMLSignatureException xMLSignatureException) {
                throw new URIReferenceException("Cannot dereference Include. Cannot access the ancestral QualifyingProperties.", xMLSignatureException);
            }
            try {
                xMLSignatureImpl = qualifyingPropertiesImpl.getTargetSignature();
            }
            catch (XMLSignatureException xMLSignatureException) {
                throw new URIReferenceException("Cannot dereference Include. Cannot access the ancestral Signature.", xMLSignatureException);
            }
            if (xMLSignatureImpl == null) {
                throw new URIReferenceException("Cannot dereference Include. Cannot access the target Signature.");
            }
            SignedInfo signedInfo = xMLSignatureImpl.getSignedInfo();
            if (signedInfo != null && (list = signedInfo.getReferences()) != null) {
                Iterator<Reference> iterator = list.iterator();
                while (iterator.hasNext()) {
                    ReferenceImpl referenceImpl = (ReferenceImpl)iterator.next();
                    if (!this.a.equals(referenceImpl.getId())) continue;
                    return referenceImpl.dereference(xMLCryptoContext);
                }
            }
            throw new URIReferenceException("Cannot dereference Include. No ds:Reference with Id-attribute '" + this.a + "' found.");
        }
        URIDereferencer uRIDereferencer = xMLCryptoContext.getURIDereferencer() != null ? xMLCryptoContext.getURIDereferencer() : new URIDereferencerImpl();
        Data data = uRIDereferencer.dereference(this, xMLCryptoContext);
        return data;
    }

    public IncludeImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
    }

    public IncludeImpl(String string, boolean bl) {
        this.setTargetId(string);
        this.b = new Boolean(bl);
    }

    public IncludeImpl(String string) {
        this.setTargetId(string);
    }
}

