/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.core.eclipse;

import it.sogei.rcp.core.Activator;
import it.sogei.rcp.core.controller.AdvisorStore;
import it.sogei.rcp.core.eclipse.RCPWorkbenchWindowAdvisor;
import it.sogei.rcp.core.entity.ConfigurationItems;
import it.sogei.rcp.core.properties.Messages;
import it.sogei.rcp.update.util.P2Util;
import it.sogei.utilities.log4j.LogUtil;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;

public class RCPWorkbenchAdvisor
extends WorkbenchAdvisor {
    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new RCPWorkbenchWindowAdvisor(configurer);
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        TrayDialog.setDialogHelpAvailable((boolean)true);
        IDE.registerAdapters();
        this.declareWorkbenchImages();
    }

    public String getInitialWindowPerspectiveId() {
        return ConfigurationItems.getInitialPerspectiveId();
    }

    public void preStartup() {
        if (ConfigurationItems.isSilentUpdate()) {
            try {
                P2Util.checkForUpdates();
                LogUtil.log((Object)((Object)this), (int)1, (String)"aggiornamenti controllati");
            }
            catch (Exception exception) {
                LogUtil.log((Object)((Object)this), (int)4, (String)Messages.DesktopController_UpdateImpossible);
            }
        }
        LogUtil.log((Object)((Object)this), (int)1, (String)"dopo aggiornamenti");
        AdvisorStore.getWorkbenchAdvisor().preStartup();
    }

    public void postStartup() {
        AdvisorStore.getWorkbenchAdvisor().postStartup();
    }

    public boolean preShutdown() {
        return AdvisorStore.getWorkbenchAdvisor().preShutdown();
    }

    public void postShutdown() {
        AdvisorStore.getWorkbenchAdvisor().postShutdown();
    }

    private void declareWorkbenchImages() {
        this.declareWorkbenchImage("org.eclipse.ui.ide", "IMG_ETOOL_PROBLEM_CATEGORY", "$nl$/icons/full/etool16/problem_category.gif", true);
        this.declareWorkbenchImage("org.eclipse.ui.ide", "IMG_OBJS_ERROR_PATH", "$nl$/icons/full/obj16/error_tsk.gif", true);
        this.declareWorkbenchImage("org.eclipse.ui.ide", "IMG_OBJS_WARNING_PATH", "$nl$/icons/full/obj16/warn_tsk.gif", true);
        this.declareWorkbenchImage("org.eclipse.ui.ide", "IMG_OBJS_INFO_PATH", "$nl$/icons/full/obj16/info_tsk.gif", true);
    }

    private void declareWorkbenchImage(String bundleId, String symbolicName, String path, boolean shared) {
        ImageDescriptor desc = Activator.getImageDescriptor(bundleId, path);
        this.getWorkbenchConfigurer().declareImage(symbolicName, desc, shared);
    }

    public IAdaptable getDefaultPageInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

