/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Method;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class BasicComboBoxEditor
implements ComboBoxEditor,
FocusListener {
    protected JTextField editor = this.createEditorComponent();
    private Object oldValue;

    @Override
    public Component getEditorComponent() {
        return this.editor;
    }

    protected JTextField createEditorComponent() {
        BorderlessTextField borderlessTextField = new BorderlessTextField("", 9);
        ((JComponent)borderlessTextField).setBorder(null);
        return borderlessTextField;
    }

    @Override
    public void setItem(Object object) {
        String string;
        if (object != null) {
            string = object.toString();
            this.oldValue = object;
        } else {
            string = "";
        }
        if (!string.equals(this.editor.getText())) {
            this.editor.setText(string);
        }
    }

    @Override
    public Object getItem() {
        Object object = this.editor.getText();
        if (this.oldValue != null && !(this.oldValue instanceof String)) {
            if (object.equals(this.oldValue.toString())) {
                return this.oldValue;
            }
            Class<?> clazz = this.oldValue.getClass();
            try {
                Method method = clazz.getMethod("valueOf", String.class);
                object = method.invoke(this.oldValue, this.editor.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    @Override
    public void selectAll() {
        this.editor.selectAll();
        this.editor.requestFocus();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.editor.addActionListener(actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.editor.removeActionListener(actionListener);
    }

    static class BorderlessTextField
    extends JTextField {
        public BorderlessTextField(String string, int n) {
            super(string, n);
        }

        @Override
        public void setText(String string) {
            if (this.getText().equals(string)) {
                return;
            }
            super.setText(string);
        }

        @Override
        public void setBorder(Border border) {
            if (!(border instanceof UIResource)) {
                super.setBorder(border);
            }
        }
    }

    public static class UIResource
    extends BasicComboBoxEditor
    implements javax.swing.plaf.UIResource {
    }
}

