/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsShortBufferRL;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

class ByteBufferAsShortBufferL
extends ShortBuffer {
    protected final ByteBuffer bb;
    protected final int offset;

    ByteBufferAsShortBufferL(ByteBuffer byteBuffer) {
        super(-1, 0, byteBuffer.remaining() >> 1, byteBuffer.remaining() >> 1);
        this.bb = byteBuffer;
        int n = this.capacity();
        this.limit(n);
        int n2 = this.position();
        assert (n2 <= n);
        this.offset = n2;
    }

    ByteBufferAsShortBufferL(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.bb = byteBuffer;
        this.offset = n5;
    }

    @Override
    public ShortBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = (n << 1) + this.offset;
        assert (n4 >= 0);
        return new ByteBufferAsShortBufferL(this.bb, -1, 0, n3, n3, n4);
    }

    @Override
    public ShortBuffer duplicate() {
        return new ByteBufferAsShortBufferL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        return new ByteBufferAsShortBufferRL(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n) {
        return (n << 1) + this.offset;
    }

    @Override
    public short get() {
        return Bits.getShortL(this.bb, this.ix(this.nextGetIndex()));
    }

    @Override
    public short get(int n) {
        return Bits.getShortL(this.bb, this.ix(this.checkIndex(n)));
    }

    @Override
    public ShortBuffer put(short s) {
        Bits.putShortL(this.bb, this.ix(this.nextPutIndex()), s);
        return this;
    }

    @Override
    public ShortBuffer put(int n, short s) {
        Bits.putShortL(this.bb, this.ix(this.checkIndex(n)), s);
        return this;
    }

    @Override
    public ShortBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        ByteBuffer byteBuffer = this.bb.duplicate();
        byteBuffer.limit(this.ix(n2));
        byteBuffer.position(this.ix(0));
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.position(n << 1);
        byteBuffer2.compact();
        this.position(n3);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

