/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.Encoder;
import java.beans.Expression;
import java.beans.Introspector;
import java.beans.NameGenerator;
import java.beans.ReflectionUtils;
import java.beans.Statement;
import java.beans.XMLDecoder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class XMLEncoder
extends Encoder
implements AutoCloseable {
    private final CharsetEncoder encoder;
    private final String charset;
    private final boolean declaration;
    private OutputStreamWriter out;
    private Object owner;
    private int indentation = 0;
    private boolean internal = false;
    private Map<Object, ValueData> valueToExpression;
    private Map<Object, List<Statement>> targetToStatementList;
    private boolean preambleWritten = false;
    private NameGenerator nameGenerator;

    public XMLEncoder(OutputStream outputStream) {
        this(outputStream, "UTF-8", true, 0);
    }

    public XMLEncoder(OutputStream outputStream, String string, boolean bl, int n) {
        if (outputStream == null) {
            throw new IllegalArgumentException("the output stream cannot be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("the indentation must be >= 0");
        }
        Charset charset = Charset.forName(string);
        this.encoder = charset.newEncoder();
        this.charset = string;
        this.declaration = bl;
        this.indentation = n;
        this.out = new OutputStreamWriter(outputStream, charset.newEncoder());
        this.valueToExpression = new IdentityHashMap<Object, ValueData>();
        this.targetToStatementList = new IdentityHashMap<Object, List<Statement>>();
        this.nameGenerator = new NameGenerator();
    }

    public void setOwner(Object object) {
        this.owner = object;
        this.writeExpression(new Expression(this, "getOwner", new Object[0]));
    }

    public Object getOwner() {
        return this.owner;
    }

    @Override
    public void writeObject(Object object) {
        if (this.internal) {
            super.writeObject(object);
        } else {
            this.writeStatement(new Statement(this, "writeObject", new Object[]{object}));
        }
    }

    private List<Statement> statementList(Object object) {
        List<Statement> list = this.targetToStatementList.get(object);
        if (list == null) {
            list = new ArrayList<Statement>();
            this.targetToStatementList.put(object, list);
        }
        return list;
    }

    private void mark(Object object, boolean bl) {
        if (object == null || object == this) {
            return;
        }
        ValueData valueData = this.getValueData(object);
        Expression expression = valueData.exp;
        if (object.getClass() == String.class && expression == null) {
            return;
        }
        if (bl) {
            ++valueData.refs;
        }
        if (valueData.marked) {
            return;
        }
        valueData.marked = true;
        Object object2 = expression.getTarget();
        this.mark(expression);
        if (!(object2 instanceof Class)) {
            this.statementList(object2).add(expression);
            ++valueData.refs;
        }
    }

    private void mark(Statement statement) {
        Object[] objectArray = statement.getArguments();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            this.mark(object, true);
        }
        this.mark(statement.getTarget(), false);
    }

    @Override
    public void writeStatement(Statement statement) {
        boolean bl = this.internal;
        this.internal = true;
        try {
            super.writeStatement(statement);
            this.mark(statement);
            Object object = statement.getTarget();
            if (object instanceof Field) {
                String string = statement.getMethodName();
                Object[] objectArray = statement.getArguments();
                if (string != null && objectArray != null) {
                    if (string.equals("get") && objectArray.length == 1) {
                        object = objectArray[0];
                    } else if (string.equals("set") && objectArray.length == 2) {
                        object = objectArray[0];
                    }
                }
            }
            this.statementList(object).add(statement);
        }
        catch (Exception exception) {
            this.getExceptionListener().exceptionThrown(new Exception("XMLEncoder: discarding statement " + statement, exception));
        }
        this.internal = bl;
    }

    @Override
    public void writeExpression(Expression expression) {
        boolean bl = this.internal;
        this.internal = true;
        Object object = this.getValue(expression);
        if (this.get(object) == null || object instanceof String && !bl) {
            this.getValueData((Object)object).exp = expression;
            super.writeExpression(expression);
        }
        this.internal = bl;
    }

    public void flush() {
        if (!this.preambleWritten) {
            if (this.declaration) {
                this.writeln("<?xml version=" + this.quote("1.0") + " encoding=" + this.quote(this.charset) + "?>");
            }
            this.writeln("<java version=" + this.quote(System.getProperty("java.version")) + " class=" + this.quote(XMLDecoder.class.getName()) + ">");
            this.preambleWritten = true;
        }
        ++this.indentation;
        List<Statement> list = this.statementList(this);
        while (!list.isEmpty()) {
            Statement statement = list.remove(0);
            if ("writeObject".equals(statement.getMethodName())) {
                this.outputValue(statement.getArguments()[0], this, true);
                continue;
            }
            this.outputStatement(statement, this, false);
        }
        --this.indentation;
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.getExceptionListener().exceptionThrown(iOException);
        }
        this.clear();
    }

    @Override
    void clear() {
        super.clear();
        this.nameGenerator.clear();
        this.valueToExpression.clear();
        this.targetToStatementList.clear();
    }

    @Override
    public void close() {
        this.flush();
        this.writeln("</java>");
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            this.getExceptionListener().exceptionThrown(iOException);
        }
    }

    private String quote(String string) {
        return "\"" + string + "\"";
    }

    private ValueData getValueData(Object object) {
        ValueData valueData = this.valueToExpression.get(object);
        if (valueData == null) {
            valueData = new ValueData();
            this.valueToExpression.put(object, valueData);
        }
        return valueData;
    }

    private static boolean isValidCharCode(int n) {
        return 32 <= n && n <= 55295 || 10 == n || 9 == n || 13 == n || 57344 <= n && n <= 65533 || 65536 <= n && n <= 0x10FFFF;
    }

    private void writeln(String string) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.indentation; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
            stringBuilder.append('\n');
            this.out.write(stringBuilder.toString());
        }
        catch (IOException iOException) {
            this.getExceptionListener().exceptionThrown(iOException);
        }
    }

    private void outputValue(Object object, Object object2, boolean bl) {
        if (object == null) {
            this.writeln("<null/>");
            return;
        }
        if (object instanceof Class) {
            this.writeln("<class>" + ((Class)object).getName() + "</class>");
            return;
        }
        ValueData valueData = this.getValueData(object);
        if (valueData.exp != null) {
            Object object3 = valueData.exp.getTarget();
            String string = valueData.exp.getMethodName();
            if (object3 == null || string == null) {
                throw new NullPointerException((object3 == null ? "target" : "methodName") + " should not be null");
            }
            if (object3 instanceof Field && string.equals("get")) {
                Field field = (Field)object3;
                this.writeln("<object class=" + this.quote(field.getDeclaringClass().getName()) + " field=" + this.quote(field.getName()) + "/>");
                return;
            }
            Class clazz = ReflectionUtils.primitiveTypeFor(object.getClass());
            if (clazz != null && object3 == object.getClass() && string.equals("new")) {
                String string2 = clazz.getName();
                if (clazz == Character.TYPE) {
                    char c = ((Character)object).charValue();
                    if (!XMLEncoder.isValidCharCode(c)) {
                        this.writeln(XMLEncoder.createString(c));
                        return;
                    }
                    object = XMLEncoder.quoteCharCode(c);
                    if (object == null) {
                        object = Character.valueOf(c);
                    }
                }
                this.writeln("<" + string2 + ">" + object + "</" + string2 + ">");
                return;
            }
        } else if (object instanceof String) {
            this.writeln(this.createString((String)object));
            return;
        }
        if (valueData.name != null) {
            if (bl) {
                this.writeln("<object idref=" + this.quote(valueData.name) + "/>");
            } else {
                this.outputXML("void", " idref=" + this.quote(valueData.name), object, new Object[0]);
            }
        } else if (valueData.exp != null) {
            this.outputStatement(valueData.exp, object2, bl);
        }
    }

    private static String quoteCharCode(int n) {
        switch (n) {
            case 38: {
                return "&amp;";
            }
            case 60: {
                return "&lt;";
            }
            case 62: {
                return "&gt;";
            }
            case 34: {
                return "&quot;";
            }
            case 39: {
                return "&apos;";
            }
            case 13: {
                return "&#13;";
            }
        }
        return null;
    }

    private static String createString(int n) {
        return "<char code=\"#" + Integer.toString(n, 16) + "\"/>";
    }

    private String createString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<string>");
        int n = 0;
        while (n < string.length()) {
            int n2 = string.codePointAt(n);
            int n3 = Character.charCount(n2);
            if (XMLEncoder.isValidCharCode(n2) && this.encoder.canEncode(string.substring(n, n + n3))) {
                String string2 = XMLEncoder.quoteCharCode(n2);
                if (string2 != null) {
                    stringBuilder.append(string2);
                } else {
                    stringBuilder.appendCodePoint(n2);
                }
                n += n3;
                continue;
            }
            stringBuilder.append(XMLEncoder.createString(string.charAt(n)));
            ++n;
        }
        stringBuilder.append("</string>");
        return stringBuilder.toString();
    }

    private void outputStatement(Statement statement, Object object, boolean bl) {
        Object object2 = statement.getTarget();
        String string = statement.getMethodName();
        if (object2 == null || string == null) {
            throw new NullPointerException((object2 == null ? "target" : "methodName") + " should not be null");
        }
        Object[] objectArray = statement.getArguments();
        boolean bl2 = statement.getClass() == Expression.class;
        Object object3 = bl2 ? this.getValue((Expression)statement) : null;
        String string2 = bl2 && bl ? "object" : "void";
        String string3 = "";
        ValueData valueData = this.getValueData(object3);
        if (object2 != object) {
            if (object2 == Array.class && string.equals("newInstance")) {
                string2 = "array";
                string3 = string3 + " class=" + this.quote(((Class)objectArray[0]).getName());
                string3 = string3 + " length=" + this.quote(objectArray[1].toString());
                objectArray = new Object[]{};
            } else if (object2.getClass() == Class.class) {
                string3 = string3 + " class=" + this.quote(((Class)object2).getName());
            } else {
                valueData.refs = 2;
                if (valueData.name == null) {
                    ++this.getValueData((Object)object2).refs;
                    List<Statement> list = this.statementList(object2);
                    if (!list.contains(statement)) {
                        list.add(statement);
                    }
                    this.outputValue(object2, object, false);
                }
                if (bl2) {
                    this.outputValue(object3, object, bl);
                }
                return;
            }
        }
        if (bl2 && valueData.refs > 1) {
            String string4;
            valueData.name = string4 = this.nameGenerator.instanceName(object3);
            string3 = string3 + " id=" + this.quote(string4);
        }
        if (!bl2 && string.equals("set") && objectArray.length == 2 && objectArray[0] instanceof Integer || bl2 && string.equals("get") && objectArray.length == 1 && objectArray[0] instanceof Integer) {
            Object[] objectArray2;
            string3 = string3 + " index=" + this.quote(objectArray[0].toString());
            if (objectArray.length == 1) {
                objectArray2 = new Object[]{};
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray2 = objectArray3;
                objectArray3[0] = objectArray[1];
            }
            objectArray = objectArray2;
        } else if (!bl2 && string.startsWith("set") && objectArray.length == 1 || bl2 && string.startsWith("get") && objectArray.length == 0) {
            if (3 < string.length()) {
                string3 = string3 + " property=" + this.quote(Introspector.decapitalize(string.substring(3)));
            }
        } else if (!string.equals("new") && !string.equals("newInstance")) {
            string3 = string3 + " method=" + this.quote(string);
        }
        this.outputXML(string2, string3, object3, objectArray);
    }

    private void outputXML(String string, String string2, Object object, Object ... objectArray) {
        List<Statement> list = this.statementList(object);
        if (objectArray.length == 0 && list.size() == 0) {
            this.writeln("<" + string + string2 + "/>");
            return;
        }
        this.writeln("<" + string + string2 + ">");
        ++this.indentation;
        for (int i = 0; i < objectArray.length; ++i) {
            this.outputValue(objectArray[i], null, true);
        }
        while (!list.isEmpty()) {
            Statement statement = list.remove(0);
            this.outputStatement(statement, object, false);
        }
        --this.indentation;
        this.writeln("</" + string + ">");
    }

    private class ValueData {
        public int refs = 0;
        public boolean marked = false;
        public String name = null;
        public Expression exp = null;

        private ValueData() {
        }
    }
}

